/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedString.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGAnimatedStringBaseVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAnimatedStringBaseVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAnimatedStringAnimVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGAnimatedStringConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAnimatedStringConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGAnimatedStringPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGAnimatedStringPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedStringPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedStringPrototype>(vm.heap)) JSSVGAnimatedStringPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedStringPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGAnimatedString> JSSVGAnimatedStringConstructor;

template<> JSValue JSSVGAnimatedStringConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedStringConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedString::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGAnimatedString"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGAnimatedStringConstructor::s_info = { "SVGAnimatedString", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedStringConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedStringPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedStringConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedStringConstructor) } },
    { "baseVal", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedStringBaseVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedStringBaseVal) } },
    { "animVal", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedStringAnimVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGAnimatedStringPrototype::s_info = { "SVGAnimatedStringPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedStringPrototype) };

void JSSVGAnimatedStringPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedStringPrototypeTableValues, *this);
}

const ClassInfo JSSVGAnimatedString::s_info = { "SVGAnimatedString", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedString) };

JSSVGAnimatedString::JSSVGAnimatedString(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedString>&& impl)
    : JSDOMWrapper<SVGAnimatedString>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGAnimatedString::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedStringPrototype::create(vm, globalObject, JSSVGAnimatedStringPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGAnimatedString::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedString>(vm, globalObject);
}

void JSSVGAnimatedString::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedString* thisObject = static_cast<JSSVGAnimatedString*>(cell);
    thisObject->JSSVGAnimatedString::~JSSVGAnimatedString();
}

EncodedJSValue jsSVGAnimatedStringBaseVal(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAnimatedString*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAnimatedString", "baseVal");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.baseVal());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAnimatedStringAnimVal(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAnimatedString*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAnimatedString", "animVal");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.animVal());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAnimatedStringConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGAnimatedStringPrototype* domObject = jsDynamicCast<JSSVGAnimatedStringPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGAnimatedString::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGAnimatedStringConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGAnimatedStringPrototype* domObject = jsDynamicCast<JSSVGAnimatedStringPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGAnimatedStringBaseVal(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGAnimatedString* castedThis = jsDynamicCast<JSSVGAnimatedString*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGAnimatedString", "baseVal");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBaseVal(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSSVGAnimatedString::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedStringConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGAnimatedStringOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedStringOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedString = jsCast<JSSVGAnimatedString*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedString->wrapped(), jsSVGAnimatedString);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGAnimatedString* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGAnimatedString>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGAnimatedString* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedString>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGAnimatedString>(globalObject, impl);
}

SVGAnimatedString* JSSVGAnimatedString::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedString*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
