/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG_FONTS)

#include "JSSVGAltGlyphDefElement.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGAltGlyphDefElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAltGlyphDefElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGAltGlyphDefElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGAltGlyphDefElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAltGlyphDefElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAltGlyphDefElementPrototype>(vm.heap)) JSSVGAltGlyphDefElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAltGlyphDefElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGAltGlyphDefElement> JSSVGAltGlyphDefElementConstructor;

template<> JSValue JSSVGAltGlyphDefElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGAltGlyphDefElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGAltGlyphDefElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGAltGlyphDefElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGAltGlyphDefElementConstructor::s_info = { "SVGAltGlyphDefElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAltGlyphDefElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGAltGlyphDefElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphDefElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAltGlyphDefElementConstructor) } },
};

const ClassInfo JSSVGAltGlyphDefElementPrototype::s_info = { "SVGAltGlyphDefElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAltGlyphDefElementPrototype) };

void JSSVGAltGlyphDefElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAltGlyphDefElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGAltGlyphDefElement::s_info = { "SVGAltGlyphDefElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAltGlyphDefElement) };

JSSVGAltGlyphDefElement::JSSVGAltGlyphDefElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAltGlyphDefElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGAltGlyphDefElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGAltGlyphDefElementPrototype::create(vm, globalObject, JSSVGAltGlyphDefElementPrototype::createStructure(vm, globalObject, JSSVGElement::getPrototype(vm, globalObject)));
}

JSObject* JSSVGAltGlyphDefElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAltGlyphDefElement>(vm, globalObject);
}

EncodedJSValue jsSVGAltGlyphDefElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGAltGlyphDefElementPrototype* domObject = jsDynamicCast<JSSVGAltGlyphDefElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGAltGlyphDefElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGAltGlyphDefElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGAltGlyphDefElementPrototype* domObject = jsDynamicCast<JSSVGAltGlyphDefElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGAltGlyphDefElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAltGlyphDefElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGAltGlyphDefElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSSVGAltGlyphDefElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}

#endif // ENABLE(SVG_FONTS)
