/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRGBColor.h"

#include "CSSPrimitiveValue.h"
#include "JSCSSPrimitiveValue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsRGBColorRed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRGBColorGreen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRGBColorBlue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRGBColorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSRGBColorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSRGBColorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSRGBColorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRGBColorPrototype* ptr = new (NotNull, JSC::allocateCell<JSRGBColorPrototype>(vm.heap)) JSRGBColorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRGBColorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSRGBColor> JSRGBColorConstructor;

template<> JSValue JSRGBColorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRGBColorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRGBColor::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("RGBColor"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSRGBColorConstructor::s_info = { "RGBColor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRGBColorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRGBColorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRGBColorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRGBColorConstructor) } },
    { "red", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRGBColorRed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "green", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRGBColorGreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "blue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRGBColorBlue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSRGBColorPrototype::s_info = { "RGBColorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRGBColorPrototype) };

void JSRGBColorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRGBColorPrototypeTableValues, *this);
}

const ClassInfo JSRGBColor::s_info = { "RGBColor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRGBColor) };

JSRGBColor::JSRGBColor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RGBColor>&& impl)
    : JSDOMWrapper<RGBColor>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSRGBColor::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSRGBColorPrototype::create(vm, globalObject, JSRGBColorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSRGBColor::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRGBColor>(vm, globalObject);
}

void JSRGBColor::destroy(JSC::JSCell* cell)
{
    JSRGBColor* thisObject = static_cast<JSRGBColor*>(cell);
    thisObject->JSRGBColor::~JSRGBColor();
}

EncodedJSValue jsRGBColorRed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRGBColor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "RGBColor", "red");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.red()));
    return JSValue::encode(result);
}


EncodedJSValue jsRGBColorGreen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRGBColor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "RGBColor", "green");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.green()));
    return JSValue::encode(result);
}


EncodedJSValue jsRGBColorBlue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRGBColor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "RGBColor", "blue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.blue()));
    return JSValue::encode(result);
}


EncodedJSValue jsRGBColorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSRGBColorPrototype* domObject = jsDynamicCast<JSRGBColorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSRGBColor::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSRGBColorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSRGBColorPrototype* domObject = jsDynamicCast<JSRGBColorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSRGBColor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRGBColorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSRGBColorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSRGBColorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRGBColor = jsCast<JSRGBColor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRGBColor->wrapped(), jsRGBColor);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, RGBColor* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSRGBColor>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, RGBColor* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSRGBColor>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RGBColor.
    COMPILE_ASSERT(!__is_polymorphic(RGBColor), RGBColor_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSRGBColor>(globalObject, impl);
}

RGBColor* JSRGBColor::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRGBColor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
