/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformance.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSPerformanceNavigation.h"
#include "JSPerformanceTiming.h"
#include "PerformanceNavigation.h"
#include "PerformanceTiming.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPerformancePrototypeFunctionNow(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsPerformanceNavigation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceTiming(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPerformanceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSPerformanceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPerformancePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSPerformancePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformancePrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformancePrototype>(vm.heap)) JSPerformancePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformancePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSPerformance> JSPerformanceConstructor;

template<> JSValue JSPerformanceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSPerformanceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformance::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Performance"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSPerformanceConstructor::s_info = { "Performance", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformanceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformancePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceConstructor) } },
    { "navigation", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timing", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTiming), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "now", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsPerformancePrototypeFunctionNow), (intptr_t) (0) } },
};

const ClassInfo JSPerformancePrototype::s_info = { "PerformancePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformancePrototype) };

void JSPerformancePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformancePrototypeTableValues, *this);
}

const ClassInfo JSPerformance::s_info = { "Performance", &Base::s_info, 0, CREATE_METHOD_TABLE(JSPerformance) };

JSPerformance::JSPerformance(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Performance>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPerformance::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSPerformancePrototype::create(vm, globalObject, JSPerformancePrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSPerformance::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformance>(vm, globalObject);
}

EncodedJSValue jsPerformanceNavigation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformance*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Performance", "navigation");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.navigation()));
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceTiming(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSPerformance*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Performance", "timing");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.timing()));
    return JSValue::encode(result);
}


EncodedJSValue jsPerformanceConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSPerformancePrototype* domObject = jsDynamicCast<JSPerformancePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSPerformance::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSPerformanceConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSPerformancePrototype* domObject = jsDynamicCast<JSPerformancePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSPerformance::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsPerformancePrototypeFunctionNow(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSPerformance*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Performance", "now");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSPerformance::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.now());
    return JSValue::encode(result);
}

void JSPerformance::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPerformance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Performance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11PerformanceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Performance* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSPerformance>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Performance* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPerformance>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Performance@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11PerformanceE[2];
#if COMPILER(CLANG)
    // If this fails Performance does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Performance), Performance_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Performance has subclasses. If Performance has subclasses that get passed
    // to toJS() we currently require Performance you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSPerformance>(globalObject, impl);
}

Performance* JSPerformance::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformance*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_TIMING)
