/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOscillatorNode.h"

#include "AudioParam.h"
#include "ExceptionCode.h"
#include "JSAudioParam.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "JSPeriodicWave.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStop(JSC::ExecState*);
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionNoteOn(JSC::ExecState*);
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionNoteOff(JSC::ExecState*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionSetPeriodicWave(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsOscillatorNodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSOscillatorNodeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOscillatorNodePlaybackState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOscillatorNodeFrequency(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOscillatorNodeDetune(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOscillatorNodeOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSOscillatorNodeOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOscillatorNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSOscillatorNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOscillatorNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSOscillatorNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOscillatorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSOscillatorNodePrototype>(vm.heap)) JSOscillatorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOscillatorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSOscillatorNode> JSOscillatorNodeConstructor;

/* Hash table for constructor */

static const HashTableValue JSOscillatorNodeConstructorTableValues[] =
{
    { "SINE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SQUARE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SAWTOOTH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TRIANGLE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CUSTOM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "UNSCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(0 == OscillatorNode::SINE, OscillatorNodeEnumSINEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == OscillatorNode::SQUARE, OscillatorNodeEnumSQUAREIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == OscillatorNode::SAWTOOTH, OscillatorNodeEnumSAWTOOTHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == OscillatorNode::TRIANGLE, OscillatorNodeEnumTRIANGLEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == OscillatorNode::CUSTOM, OscillatorNodeEnumCUSTOMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == OscillatorNode::UNSCHEDULED_STATE, OscillatorNodeEnumUNSCHEDULED_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == OscillatorNode::SCHEDULED_STATE, OscillatorNodeEnumSCHEDULED_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == OscillatorNode::PLAYING_STATE, OscillatorNodeEnumPLAYING_STATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == OscillatorNode::FINISHED_STATE, OscillatorNodeEnumFINISHED_STATEIsWrongUseDoNotCheckConstants);

template<> JSValue JSOscillatorNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSOscillatorNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOscillatorNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("OscillatorNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSOscillatorNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSOscillatorNodeConstructor::s_info = { "OscillatorNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOscillatorNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOscillatorNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOscillatorNodeConstructor) } },
    { "type", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOscillatorNodeType) } },
    { "playbackState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodePlaybackState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "frequency", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeFrequency), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "detune", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeDetune), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onended", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOscillatorNodeOnended) } },
    { "start", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionStop), (intptr_t) (0) } },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteOn", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionNoteOn), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_WEB_AUDIO)
    { "noteOff", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionNoteOff), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "setPeriodicWave", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsOscillatorNodePrototypeFunctionSetPeriodicWave), (intptr_t) (1) } },
    { "SINE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SQUARE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SAWTOOTH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TRIANGLE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CUSTOM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "UNSCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSOscillatorNodePrototype::s_info = { "OscillatorNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOscillatorNodePrototype) };

void JSOscillatorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOscillatorNodePrototypeTableValues, *this);
}

const ClassInfo JSOscillatorNode::s_info = { "OscillatorNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOscillatorNode) };

JSOscillatorNode::JSOscillatorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OscillatorNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSOscillatorNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSOscillatorNodePrototype::create(vm, globalObject, JSOscillatorNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSOscillatorNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOscillatorNode>(vm, globalObject);
}

EncodedJSValue jsOscillatorNodeType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOscillatorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OscillatorNode", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsOscillatorNodePlaybackState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOscillatorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OscillatorNode", "playbackState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.playbackState());
    return JSValue::encode(result);
}


EncodedJSValue jsOscillatorNodeFrequency(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOscillatorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OscillatorNode", "frequency");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.frequency()));
    return JSValue::encode(result);
}


EncodedJSValue jsOscillatorNodeDetune(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOscillatorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OscillatorNode", "detune");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.detune()));
    return JSValue::encode(result);
}


EncodedJSValue jsOscillatorNodeOnended(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOscillatorNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OscillatorNode", "onended");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().endedEvent));
}


EncodedJSValue jsOscillatorNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSOscillatorNodePrototype* domObject = jsDynamicCast<JSOscillatorNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSOscillatorNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSOscillatorNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSOscillatorNodePrototype* domObject = jsDynamicCast<JSOscillatorNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSOscillatorNodeType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSOscillatorNode* castedThis = jsDynamicCast<JSOscillatorNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "OscillatorNode", "type");
        return;
    }
    castedThis->setType(*state, value);
}


void setJSOscillatorNodeOnended(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSOscillatorNode* castedThis = jsDynamicCast<JSOscillatorNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "OscillatorNode", "onended");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().endedEvent, value);
}


JSValue JSOscillatorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOscillatorNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStart(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSOscillatorNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "OscillatorNode", "start");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSOscillatorNode::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.start(ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.start(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStop(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSOscillatorNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "OscillatorNode", "stop");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSOscillatorNode::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.stop(ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.stop(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionNoteOn(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSOscillatorNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "OscillatorNode", "noteOn");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSOscillatorNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.noteOn(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionNoteOff(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSOscillatorNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "OscillatorNode", "noteOff");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSOscillatorNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    double when = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.noteOff(when, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionSetPeriodicWave(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSOscillatorNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "OscillatorNode", "setPeriodicWave");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSOscillatorNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    PeriodicWave* wave = JSPeriodicWave::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setPeriodicWave(wave);
    return JSValue::encode(jsUndefined());
}

void JSOscillatorNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSOscillatorNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OscillatorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14OscillatorNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, OscillatorNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSOscillatorNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, OscillatorNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSOscillatorNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7OscillatorNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14OscillatorNodeE[2];
#if COMPILER(CLANG)
    // If this fails OscillatorNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(OscillatorNode), OscillatorNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // OscillatorNode has subclasses. If OscillatorNode has subclasses that get passed
    // to toJS() we currently require OscillatorNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSOscillatorNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
