/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationRecord.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsMutationRecordType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordAddedNodes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordRemovedNodes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordPreviousSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordNextSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordAttributeName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordAttributeNamespace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordOldValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMutationRecordConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMutationRecordPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMutationRecordPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMutationRecordPrototype* ptr = new (NotNull, JSC::allocateCell<JSMutationRecordPrototype>(vm.heap)) JSMutationRecordPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMutationRecordPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSMutationRecord> JSMutationRecordConstructor;

template<> JSValue JSMutationRecordConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMutationRecordConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMutationRecord::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MutationRecord"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMutationRecordConstructor::s_info = { "MutationRecord", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationRecordConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMutationRecordPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMutationRecordConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "target", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "addedNodes", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordAddedNodes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "removedNodes", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordRemovedNodes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "previousSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordPreviousSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordNextSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attributeName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordAttributeName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attributeNamespace", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordAttributeNamespace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oldValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordOldValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMutationRecordPrototype::s_info = { "MutationRecordPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationRecordPrototype) };

void JSMutationRecordPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMutationRecordPrototypeTableValues, *this);
}

const ClassInfo JSMutationRecord::s_info = { "MutationRecord", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMutationRecord) };

JSMutationRecord::JSMutationRecord(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MutationRecord>&& impl)
    : JSDOMWrapper<MutationRecord>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMutationRecord::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMutationRecordPrototype::create(vm, globalObject, JSMutationRecordPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSMutationRecord::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMutationRecord>(vm, globalObject);
}

void JSMutationRecord::destroy(JSC::JSCell* cell)
{
    JSMutationRecord* thisObject = static_cast<JSMutationRecord*>(cell);
    thisObject->JSMutationRecord::~JSMutationRecord();
}

EncodedJSValue jsMutationRecordType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "target");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.target()));
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordAddedNodes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "addedNodes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.addedNodes()));
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordRemovedNodes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "removedNodes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.removedNodes()));
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordPreviousSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "previousSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousSibling()));
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordNextSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "nextSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextSibling()));
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordAttributeName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "attributeName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.attributeName());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordAttributeNamespace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "attributeNamespace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.attributeNamespace());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordOldValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMutationRecord*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MutationRecord", "oldValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.oldValue());
    return JSValue::encode(result);
}


EncodedJSValue jsMutationRecordConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMutationRecordPrototype* domObject = jsDynamicCast<JSMutationRecordPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMutationRecord::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMutationRecordConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMutationRecordPrototype* domObject = jsDynamicCast<JSMutationRecordPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSMutationRecord::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationRecordConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSMutationRecordOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSMutationRecordOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMutationRecord = jsCast<JSMutationRecord*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMutationRecord->wrapped(), jsMutationRecord);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MutationRecord* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMutationRecord>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MutationRecord* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMutationRecord>(globalObject, impl))
        return result;
    return createNewWrapper<JSMutationRecord>(globalObject, impl);
}

MutationRecord* JSMutationRecord::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMutationRecord*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
