/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen(JSC::ExecState*);
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationMode(JSC::ExecState*);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationMode(JSC::ExecState*);
#endif

// Attributes

JSC::EncodedJSValue jsHTMLVideoElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLVideoElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLVideoElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementVideoWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLVideoElementVideoHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLVideoElementPoster(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLVideoElementPoster(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementWebkitSupportsFullscreen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLVideoElementWebkitDisplayingFullscreen(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLVideoElementWebkitDecodedFrameCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLVideoElementWebkitDroppedFrameCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue jsHTMLVideoElementWebkitPresentationMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsHTMLVideoElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLVideoElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLVideoElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLVideoElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLVideoElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLVideoElementPrototype>(vm.heap)) JSHTMLVideoElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLVideoElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLVideoElement> JSHTMLVideoElementConstructor;

template<> JSValue JSHTMLVideoElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLMediaElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLVideoElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLVideoElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLVideoElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLVideoElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementConstructor) } },
    { "width", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementWidth) } },
    { "height", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementHeight) } },
    { "videoWidth", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementVideoWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "videoHeight", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementVideoHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "poster", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementPoster), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementPoster) } },
    { "webkitSupportsFullscreen", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitSupportsFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitDisplayingFullscreen", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDisplayingFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitWirelessVideoPlaybackDisabled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabled) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitDecodedFrameCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDecodedFrameCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitDroppedFrameCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDroppedFrameCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "webkitPresentationMode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitPresentationMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "webkitEnterFullscreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen), (intptr_t) (0) } },
    { "webkitExitFullscreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen), (intptr_t) (0) } },
    { "webkitEnterFullScreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen), (intptr_t) (0) } },
    { "webkitExitFullScreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen), (intptr_t) (0) } },
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "webkitSupportsPresentationMode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationMode), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "webkitSetPresentationMode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationMode), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLVideoElementPrototype) };

void JSHTMLVideoElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLVideoElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLVideoElement) };

JSHTMLVideoElement::JSHTMLVideoElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLVideoElement>&& impl)
    : JSHTMLMediaElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLVideoElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLVideoElementPrototype::create(vm, globalObject, JSHTMLVideoElementPrototype::createStructure(vm, globalObject, JSHTMLMediaElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLVideoElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLVideoElement>(vm, globalObject);
}

EncodedJSValue jsHTMLVideoElementWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::widthAttr)));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLVideoElementHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::heightAttr)));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLVideoElementVideoWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "videoWidth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.videoWidth());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLVideoElementVideoHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "videoHeight");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.videoHeight());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLVideoElementPoster(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "poster");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::posterAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLVideoElementWebkitSupportsFullscreen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "webkitSupportsFullscreen");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitSupportsFullscreen());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLVideoElementWebkitDisplayingFullscreen(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "webkitDisplayingFullscreen");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitDisplayingFullscreen());
    return JSValue::encode(result);
}


#if ENABLE(WIRELESS_PLAYBACK_TARGET)
EncodedJSValue jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "webkitWirelessVideoPlaybackDisabled");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitWirelessVideoPlaybackDisabled());
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
EncodedJSValue jsHTMLVideoElementWebkitDecodedFrameCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "webkitDecodedFrameCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitDecodedFrameCount());
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
EncodedJSValue jsHTMLVideoElementWebkitDroppedFrameCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "webkitDroppedFrameCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitDroppedFrameCount());
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
EncodedJSValue jsHTMLVideoElementWebkitPresentationMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLVideoElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLVideoElement", "webkitPresentationMode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.webkitPresentationMode());
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsHTMLVideoElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLVideoElementPrototype* domObject = jsDynamicCast<JSHTMLVideoElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLVideoElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLVideoElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLVideoElementPrototype* domObject = jsDynamicCast<JSHTMLVideoElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLVideoElementWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLVideoElement* castedThis = jsDynamicCast<JSHTMLVideoElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLVideoElement", "width");
        return;
    }
    auto& impl = castedThis->wrapped();
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, nativeValue);
}


void setJSHTMLVideoElementHeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLVideoElement* castedThis = jsDynamicCast<JSHTMLVideoElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLVideoElement", "height");
        return;
    }
    auto& impl = castedThis->wrapped();
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLVideoElementPoster(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLVideoElement* castedThis = jsDynamicCast<JSHTMLVideoElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLVideoElement", "poster");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::posterAttr, nativeValue);
}


#if ENABLE(WIRELESS_PLAYBACK_TARGET)
void setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLVideoElement* castedThis = jsDynamicCast<JSHTMLVideoElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLVideoElement", "webkitWirelessVideoPlaybackDisabled");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWebkitWirelessVideoPlaybackDisabled(nativeValue);
}

#endif

JSValue JSHTMLVideoElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLVideoElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLVideoElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLVideoElement", "webkitEnterFullscreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLVideoElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.webkitEnterFullscreen(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLVideoElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLVideoElement", "webkitExitFullscreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLVideoElement::info());
    auto& impl = castedThis->wrapped();
    impl.webkitExitFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLVideoElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLVideoElement", "webkitEnterFullScreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLVideoElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.webkitEnterFullScreen(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLVideoElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLVideoElement", "webkitExitFullScreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLVideoElement::info());
    auto& impl = castedThis->wrapped();
    impl.webkitExitFullScreen();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(VIDEO_PRESENTATION_MODE)
EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationMode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLVideoElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLVideoElement", "webkitSupportsPresentationMode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLVideoElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    // Keep pointer to the JSString in a local so we don't need to ref the String.
    auto* modeString = state->argument(0).toString(state);
    auto& mode = modeString->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (mode != "fullscreen" && mode != "picture-in-picture" && mode != "inline")
        return throwArgumentMustBeEnumError(*state, 0, "mode", "HTMLVideoElement", "webkitSupportsPresentationMode", "\"fullscreen\", \"picture-in-picture\", \"inline\"");
    JSValue result = jsBoolean(impl.webkitSupportsPresentationMode(mode));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationMode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLVideoElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLVideoElement", "webkitSetPresentationMode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLVideoElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    // Keep pointer to the JSString in a local so we don't need to ref the String.
    auto* modeString = state->argument(0).toString(state);
    auto& mode = modeString->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (mode != "fullscreen" && mode != "picture-in-picture" && mode != "inline")
        return throwArgumentMustBeEnumError(*state, 0, "mode", "HTMLVideoElement", "webkitSetPresentationMode", "\"fullscreen\", \"picture-in-picture\", \"inline\"");
    impl.webkitSetPresentationMode(mode);
    return JSValue::encode(jsUndefined());
}

#endif

void JSHTMLVideoElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLVideoElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSHTMLVideoElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsHTMLVideoElement = jsCast<JSHTMLVideoElement*>(handle.slot()->asCell());
    if (jsHTMLVideoElement->wrapped().hasPendingActivity())
        return true;
    if (jsHTMLVideoElement->wrapped().isFiringEventListeners())
        return true;
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor))
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSHTMLVideoElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLVideoElement = jsCast<JSHTMLVideoElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLVideoElement->wrapped(), jsHTMLVideoElement);
}

HTMLVideoElement* JSHTMLVideoElement::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLVideoElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
