/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableHeaderCellElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLTableHeaderCellElementAbbr(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLTableHeaderCellElementAbbr(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTableHeaderCellElementScope(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLTableHeaderCellElementScope(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTableHeaderCellElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLTableHeaderCellElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLTableHeaderCellElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLTableHeaderCellElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLTableHeaderCellElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLTableHeaderCellElementPrototype>(vm.heap)) JSHTMLTableHeaderCellElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLTableHeaderCellElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLTableHeaderCellElement> JSHTMLTableHeaderCellElementConstructor;

template<> JSValue JSHTMLTableHeaderCellElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLTableCellElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLTableHeaderCellElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLTableHeaderCellElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLTableHeaderCellElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLTableHeaderCellElementConstructor::s_info = { "HTMLTableHeaderCellElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLTableHeaderCellElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLTableHeaderCellElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableHeaderCellElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTableHeaderCellElementConstructor) } },
    { "abbr", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableHeaderCellElementAbbr), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTableHeaderCellElementAbbr) } },
    { "scope", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableHeaderCellElementScope), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTableHeaderCellElementScope) } },
};

const ClassInfo JSHTMLTableHeaderCellElementPrototype::s_info = { "HTMLTableHeaderCellElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLTableHeaderCellElementPrototype) };

void JSHTMLTableHeaderCellElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLTableHeaderCellElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLTableHeaderCellElement::s_info = { "HTMLTableHeaderCellElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLTableHeaderCellElement) };

JSHTMLTableHeaderCellElement::JSHTMLTableHeaderCellElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLTableHeaderCellElement>&& impl)
    : JSHTMLTableCellElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLTableHeaderCellElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLTableHeaderCellElementPrototype::create(vm, globalObject, JSHTMLTableHeaderCellElementPrototype::createStructure(vm, globalObject, JSHTMLTableCellElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLTableHeaderCellElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableHeaderCellElement>(vm, globalObject);
}

EncodedJSValue jsHTMLTableHeaderCellElementAbbr(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLTableHeaderCellElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLTableHeaderCellElement", "abbr");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::abbrAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLTableHeaderCellElementScope(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLTableHeaderCellElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLTableHeaderCellElement", "scope");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.scope());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLTableHeaderCellElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLTableHeaderCellElementPrototype* domObject = jsDynamicCast<JSHTMLTableHeaderCellElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLTableHeaderCellElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLTableHeaderCellElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLTableHeaderCellElementPrototype* domObject = jsDynamicCast<JSHTMLTableHeaderCellElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLTableHeaderCellElementAbbr(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLTableHeaderCellElement* castedThis = jsDynamicCast<JSHTMLTableHeaderCellElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLTableHeaderCellElement", "abbr");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::abbrAttr, nativeValue);
}


void setJSHTMLTableHeaderCellElementScope(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLTableHeaderCellElement* castedThis = jsDynamicCast<JSHTMLTableHeaderCellElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLTableHeaderCellElement", "scope");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setScope(nativeValue);
}


JSValue JSHTMLTableHeaderCellElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableHeaderCellElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLTableHeaderCellElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLTableHeaderCellElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
