/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMapElement.h"

#include "HTMLCollection.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSHTMLCollection.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLMapElementAreas(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMapElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMapElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMapElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMapElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLMapElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLMapElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMapElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMapElementPrototype>(vm.heap)) JSHTMLMapElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMapElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLMapElement> JSHTMLMapElementConstructor;

template<> JSValue JSHTMLMapElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMapElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMapElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLMapElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLMapElementConstructor::s_info = { "HTMLMapElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMapElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMapElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMapElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMapElementConstructor) } },
    { "areas", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMapElementAreas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMapElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMapElementName) } },
};

const ClassInfo JSHTMLMapElementPrototype::s_info = { "HTMLMapElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMapElementPrototype) };

void JSHTMLMapElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMapElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLMapElement::s_info = { "HTMLMapElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMapElement) };

JSHTMLMapElement::JSHTMLMapElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMapElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLMapElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLMapElementPrototype::create(vm, globalObject, JSHTMLMapElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLMapElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMapElement>(vm, globalObject);
}

EncodedJSValue jsHTMLMapElementAreas(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMapElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMapElement", "areas");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.areas()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMapElementName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMapElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMapElement", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getNameAttribute());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMapElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLMapElementPrototype* domObject = jsDynamicCast<JSHTMLMapElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLMapElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLMapElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLMapElementPrototype* domObject = jsDynamicCast<JSHTMLMapElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLMapElementName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMapElement* castedThis = jsDynamicCast<JSHTMLMapElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMapElement", "name");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, nativeValue);
}


JSValue JSHTMLMapElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMapElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLMapElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLMapElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
