/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLElement.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSElement.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentElement(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentHTML(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionClick(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHTMLElementTitle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementTitle(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementLang(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementLang(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementTranslate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementTranslate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementDir(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementDir(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementTabIndex(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementTabIndex(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementDraggable(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementDraggable(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementWebkitdropzone(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementWebkitdropzone(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementHidden(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementHidden(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementAccessKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementAccessKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementInnerText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementInnerText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOuterText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementOuterText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementContentEditable(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementContentEditable(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementIsContentEditable(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementSpellcheck(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementSpellcheck(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLElementPrototype>(vm.heap)) JSHTMLElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLElement> JSHTMLElementConstructor;

template<> JSValue JSHTMLElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLElementConstructor::s_info = { "HTMLElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementConstructor) } },
    { "title", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTitle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementTitle) } },
    { "lang", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementLang), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementLang) } },
    { "translate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTranslate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementTranslate) } },
    { "dir", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDir), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementDir) } },
    { "tabIndex", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTabIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementTabIndex) } },
    { "draggable", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDraggable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementDraggable) } },
    { "webkitdropzone", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementWebkitdropzone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementWebkitdropzone) } },
    { "hidden", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementHidden), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementHidden) } },
    { "accessKey", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementAccessKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementAccessKey) } },
    { "innerText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInnerText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementInnerText) } },
    { "outerText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOuterText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOuterText) } },
    { "contentEditable", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementContentEditable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementContentEditable) } },
    { "isContentEditable", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementIsContentEditable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "spellcheck", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementSpellcheck), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementSpellcheck) } },
    { "insertAdjacentElement", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentElement), (intptr_t) (0) } },
    { "insertAdjacentHTML", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentHTML), (intptr_t) (0) } },
    { "insertAdjacentText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentText), (intptr_t) (0) } },
    { "click", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionClick), (intptr_t) (0) } },
};

const ClassInfo JSHTMLElementPrototype::s_info = { "HTMLElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLElementPrototype) };

void JSHTMLElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLElement::s_info = { "HTMLElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLElement) };

JSHTMLElement::JSHTMLElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLElement>&& impl)
    : JSElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLElementPrototype::create(vm, globalObject, JSHTMLElementPrototype::createStructure(vm, globalObject, JSElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLElement>(vm, globalObject);
}

EncodedJSValue jsHTMLElementTitle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "title");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::titleAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementLang(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "lang");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::langAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementTranslate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "translate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.translate());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementDir(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "dir");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.dir());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementTabIndex(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "tabIndex");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.tabIndex());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementDraggable(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "draggable");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.draggable());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementWebkitdropzone(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "webkitdropzone");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::webkitdropzoneAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementHidden(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "hidden");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::hiddenAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementAccessKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "accessKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::accesskeyAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementInnerText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "innerText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.innerText());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementOuterText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "outerText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.outerText());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementContentEditable(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "contentEditable");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.contentEditable());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementIsContentEditable(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "isContentEditable");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.isContentEditable());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementSpellcheck(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLElement", "spellcheck");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.spellcheck());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLElementPrototype* domObject = jsDynamicCast<JSHTMLElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLElementPrototype* domObject = jsDynamicCast<JSHTMLElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLElementTitle(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "title");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::titleAttr, nativeValue);
}


void setJSHTMLElementLang(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "lang");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::langAttr, nativeValue);
}


void setJSHTMLElementTranslate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "translate");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTranslate(nativeValue);
}


void setJSHTMLElementDir(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "dir");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDir(nativeValue);
}


void setJSHTMLElementTabIndex(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "tabIndex");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setTabIndex(nativeValue);
}


void setJSHTMLElementDraggable(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "draggable");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDraggable(nativeValue);
}


void setJSHTMLElementWebkitdropzone(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "webkitdropzone");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::webkitdropzoneAttr, nativeValue);
}


void setJSHTMLElementHidden(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "hidden");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::hiddenAttr, nativeValue);
}


void setJSHTMLElementAccessKey(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "accessKey");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::accesskeyAttr, nativeValue);
}


void setJSHTMLElementInnerText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "innerText");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setInnerText(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLElementOuterText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "outerText");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setOuterText(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLElementContentEditable(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "contentEditable");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setContentEditable(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLElementSpellcheck(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLElement* castedThis = jsDynamicCast<JSHTMLElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLElement", "spellcheck");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSpellcheck(nativeValue);
}


JSValue JSHTMLElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentElement(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLElement", "insertAdjacentElement");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String where = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Element* element = JSElement::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.insertAdjacentElement(where, element, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentHTML(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLElement", "insertAdjacentHTML");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String where = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String html = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.insertAdjacentHTML(where, html, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLElement", "insertAdjacentText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String where = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String text = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.insertAdjacentText(where, text, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionClick(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLElement", "click");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLElement::info());
    auto& impl = castedThis->wrapped();
    impl.click();
    return JSValue::encode(jsUndefined());
}

void JSHTMLElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

HTMLElement* JSHTMLElement::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
