/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLAnchorElement.h"

#include "DOMTokenList.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMTokenList.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLAnchorElementPrototypeFunctionToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsHTMLAnchorElementCharset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementCharset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementCoords(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementCoords(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(DOWNLOAD_ATTRIBUTE)
JSC::EncodedJSValue jsHTMLAnchorElementDownload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementDownload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLAnchorElementHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementHreflang(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementHreflang(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementPing(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementPing(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementRel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementRel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementRev(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementRev(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementShape(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementShape(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementHash(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementHost(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementHostname(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementPathname(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementPort(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementProtocol(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementSearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLAnchorElementText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementRelList(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementRelList(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAnchorElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAnchorElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLAnchorElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLAnchorElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLAnchorElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLAnchorElementPrototype>(vm.heap)) JSHTMLAnchorElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLAnchorElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLAnchorElement> JSHTMLAnchorElementConstructor;

template<> JSValue JSHTMLAnchorElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLAnchorElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLAnchorElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLAnchorElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLAnchorElementConstructor::s_info = { "HTMLAnchorElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAnchorElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLAnchorElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementConstructor) } },
    { "charset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementCharset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementCharset) } },
    { "coords", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementCoords), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementCoords) } },
#if ENABLE(DOWNLOAD_ATTRIBUTE)
    { "download", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementDownload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementDownload) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "href", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementHref) } },
    { "hreflang", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHreflang), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementHreflang) } },
    { "name", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementName) } },
    { "ping", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementPing), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementPing) } },
    { "rel", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementRel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementRel) } },
    { "rev", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementRev), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementRev) } },
    { "shape", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementShape), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementShape) } },
    { "target", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementTarget) } },
    { "type", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementType) } },
    { "hash", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementHash) } },
    { "host", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHost), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementHost) } },
    { "hostname", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementHostname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementHostname) } },
    { "pathname", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementPathname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementPathname) } },
    { "port", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementPort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementPort) } },
    { "protocol", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementProtocol) } },
    { "search", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementSearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementSearch) } },
    { "origin", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "text", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementText) } },
    { "relList", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAnchorElementRelList), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAnchorElementRelList) } },
    { "toString", DontEnum | JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLAnchorElementPrototypeFunctionToString), (intptr_t) (0) } },
};

const ClassInfo JSHTMLAnchorElementPrototype::s_info = { "HTMLAnchorElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAnchorElementPrototype) };

void JSHTMLAnchorElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLAnchorElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLAnchorElement::s_info = { "HTMLAnchorElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAnchorElement) };

JSHTMLAnchorElement::JSHTMLAnchorElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLAnchorElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLAnchorElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLAnchorElementPrototype::create(vm, globalObject, JSHTMLAnchorElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLAnchorElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLAnchorElement>(vm, globalObject);
}

EncodedJSValue jsHTMLAnchorElementCharset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "charset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::charsetAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementCoords(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "coords");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::coordsAttr));
    return JSValue::encode(result);
}


#if ENABLE(DOWNLOAD_ATTRIBUTE)
EncodedJSValue jsHTMLAnchorElementDownload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "download");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::downloadAttr));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsHTMLAnchorElementHref(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "href");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementHreflang(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "hreflang");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::hreflangAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getNameAttribute());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementPing(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "ping");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::pingAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementRel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "rel");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::relAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementRev(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "rev");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::revAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementShape(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "shape");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::shapeAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "target");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementHash(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "hash");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hash());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementHost(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "host");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.host());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementHostname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "hostname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.hostname());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementPathname(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "pathname");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.pathname());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementPort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "port");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.port());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementProtocol(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "protocol");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.protocol());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementSearch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "search");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.search());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementOrigin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "origin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.origin());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "text");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.text());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementRelList(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLAnchorElement", "relList");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.relList()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLAnchorElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLAnchorElementPrototype* domObject = jsDynamicCast<JSHTMLAnchorElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLAnchorElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLAnchorElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLAnchorElementPrototype* domObject = jsDynamicCast<JSHTMLAnchorElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLAnchorElementCharset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "charset");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::charsetAttr, nativeValue);
}


void setJSHTMLAnchorElementCoords(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "coords");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::coordsAttr, nativeValue);
}


#if ENABLE(DOWNLOAD_ATTRIBUTE)
void setJSHTMLAnchorElementDownload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "download");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::downloadAttr, nativeValue);
}

#endif

void setJSHTMLAnchorElementHref(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "href");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::hrefAttr, nativeValue);
}


void setJSHTMLAnchorElementHreflang(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "hreflang");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::hreflangAttr, nativeValue);
}


void setJSHTMLAnchorElementName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "name");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, nativeValue);
}


void setJSHTMLAnchorElementPing(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "ping");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::pingAttr, nativeValue);
}


void setJSHTMLAnchorElementRel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "rel");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::relAttr, nativeValue);
}


void setJSHTMLAnchorElementRev(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "rev");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::revAttr, nativeValue);
}


void setJSHTMLAnchorElementShape(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "shape");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::shapeAttr, nativeValue);
}


void setJSHTMLAnchorElementTarget(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "target");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::targetAttr, nativeValue);
}


void setJSHTMLAnchorElementType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "type");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::typeAttr, nativeValue);
}


void setJSHTMLAnchorElementHash(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "hash");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHash(nativeValue);
}


void setJSHTMLAnchorElementHost(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "host");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHost(nativeValue);
}


void setJSHTMLAnchorElementHostname(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "hostname");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHostname(nativeValue);
}


void setJSHTMLAnchorElementPathname(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "pathname");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPathname(nativeValue);
}


void setJSHTMLAnchorElementPort(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "port");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPort(nativeValue);
}


void setJSHTMLAnchorElementProtocol(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "protocol");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setProtocol(nativeValue);
}


void setJSHTMLAnchorElementSearch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "search");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSearch(nativeValue);
}


void setJSHTMLAnchorElementText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "text");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setText(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLAnchorElementRelList(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLAnchorElement* castedThis = jsDynamicCast<JSHTMLAnchorElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLAnchorElement", "relList");
        return;
    }
    Ref<DOMTokenList> forwardedImpl = castedThis->wrapped().relList();
    auto& impl = forwardedImpl.get();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setValue(nativeValue);
}


JSValue JSHTMLAnchorElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAnchorElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLAnchorElementPrototypeFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLAnchorElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLAnchorElement", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLAnchorElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.toString());
    return JSValue::encode(result);
}

void JSHTMLAnchorElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLAnchorElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
