/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFile.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsFileName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFileLastModifiedDate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFileConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSFileConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFilePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSFilePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFilePrototype* ptr = new (NotNull, JSC::allocateCell<JSFilePrototype>(vm.heap)) JSFilePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFilePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSFile> JSFileConstructor;

template<> JSValue JSFileConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSBlob::getConstructor(vm, &globalObject);
}

template<> void JSFileConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFile::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("File"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSFileConstructor::s_info = { "File", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFileConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFilePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFileConstructor) } },
    { "name", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastModifiedDate", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileLastModifiedDate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSFilePrototype::s_info = { "FilePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFilePrototype) };

void JSFilePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFilePrototypeTableValues, *this);
}

const ClassInfo JSFile::s_info = { "File", &Base::s_info, 0, CREATE_METHOD_TABLE(JSFile) };

JSFile::JSFile(Structure* structure, JSDOMGlobalObject& globalObject, Ref<File>&& impl)
    : JSBlob(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSFile::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSFilePrototype::create(vm, globalObject, JSFilePrototype::createStructure(vm, globalObject, JSBlob::getPrototype(vm, globalObject)));
}

JSObject* JSFile::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFile>(vm, globalObject);
}

EncodedJSValue jsFileName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFile*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "File", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.name());
    return JSValue::encode(result);
}


EncodedJSValue jsFileLastModifiedDate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSFile*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "File", "lastModifiedDate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsDateOrNull(state, impl.lastModifiedDate());
    return JSValue::encode(result);
}


EncodedJSValue jsFileConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSFilePrototype* domObject = jsDynamicCast<JSFilePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSFile::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSFileConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSFilePrototype* domObject = jsDynamicCast<JSFilePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSFile::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7File@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore4FileE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, File* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSFile>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, File* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFile>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7File@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore4FileE[2];
#if COMPILER(CLANG)
    // If this fails File does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(File), File_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // File has subclasses. If File has subclasses that get passed
    // to toJS() we currently require File you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSFile>(globalObject, impl);
}

File* JSFile::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFile*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
