/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSElement.h"

#include "Attr.h"
#include "CSSStyleDeclaration.h"
#include "ClientRect.h"
#include "ClientRectList.h"
#include "DOMStringMap.h"
#include "DOMTokenList.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLNames.h"
#include "JSAttr.h"
#include "JSCSSStyleDeclaration.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMStringMap.h"
#include "JSDOMTokenList.h"
#include "JSElement.h"
#include "JSEventListener.h"
#include "JSHTMLCollection.h"
#include "JSNamedNodeMap.h"
#include "JSNodeList.h"
#include "JSRange.h"
#include "NameNodeList.h"
#include "NamedNodeMap.h"
#include "NodeList.h"
#include "Range.h"
#include "ShadowRoot.h"
#include "StyleProperties.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(SHADOW_DOM)
#include "Dictionary.h"
#include "HTMLSlotElement.h"
#include "JSHTMLSlotElement.h"
#include "JSShadowRoot.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttribute(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttribute(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttribute(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributes(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagNameNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNodeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNodeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttribute(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributeNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionFocus(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBlur(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoView(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNames(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoViewIfNeeded(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByLines(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByPages(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByClassName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionMatches(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionClosest(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitMatchesSelector(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetClientRects(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetBoundingClientRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullScreen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullscreen(JSC::ExecState*);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRequestPointerLock(JSC::ExecState*);
#endif
#if ENABLE(CSS_REGIONS)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitGetRegionFlowRanges(JSC::ExecState*);
#endif
#if ENABLE(SHADOW_DOM)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAttachShadow(JSC::ExecState*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAfter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionReplaceWith(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemove(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionPrepend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAppend(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelector(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelectorAll(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsElementTagName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementAttributes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementStyle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementId(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOffsetLeft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementOffsetTop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementOffsetWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementOffsetHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientLeft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientTop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementScrollLeft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementScrollLeft(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementScrollTop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementScrollTop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementScrollWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementScrollHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementOffsetParent(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementInnerHTML(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementInnerHTML(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOuterHTML(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOuterHTML(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementClassName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementClassName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementClassList(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementClassList(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementDataset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(CSS_REGIONS)
JSC::EncodedJSValue jsElementWebkitRegionOverset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(SHADOW_DOM)
JSC::EncodedJSValue jsElementShadowRoot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(SHADOW_DOM)
JSC::EncodedJSValue jsElementSlot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementSlot(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnbeforecopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnbeforecopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforecut(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnbeforecut(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforepaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnbeforepaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOncopy(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncut(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOncut(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnpaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnpaste(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnselectstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnselectstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsElementOnwebkitfullscreenchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitfullscreenchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsElementOnwebkitfullscreenerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitfullscreenerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnanimationend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnanimationend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnanimationiteration(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnanimationiteration(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnanimationstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnanimationstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOntransitionend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOntransitionend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkitanimationend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitanimationend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkitanimationiteration(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitanimationiteration(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkitanimationstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitanimationstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkittransitionend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkittransitionend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsElementOngesturechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOngesturechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsElementOngestureend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOngestureend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsElementOngesturestart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOngesturestart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnfocusin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnfocusin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnfocusout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnfocusout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforeload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnbeforeload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsElementOnwebkitkeyadded(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitkeyadded(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsElementOnwebkitkeyerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitkeyerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsElementOnwebkitkeymessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitkeymessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
JSC::EncodedJSValue jsElementOnwebkitneedkey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitneedkey(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue jsElementOnwebkitpresentationmodechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitpresentationmodechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsElementOnwebkitcurrentplaybacktargetiswirelesschanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitcurrentplaybacktargetiswirelesschanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsElementOnwebkitplaybacktargetavailabilitychanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitplaybacktargetavailabilitychanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnabort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnabort(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(REQUEST_AUTOCOMPLETE)
JSC::EncodedJSValue jsElementOnautocomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnautocomplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(REQUEST_AUTOCOMPLETE)
JSC::EncodedJSValue jsElementOnautocompleteerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnautocompleteerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncanplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOncanplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncanplaythrough(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOncanplaythrough(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncontextmenu(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOncontextmenu(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndblclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndblclick(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndrag(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndrag(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndragend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndragend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndragenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndragenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndragleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndragleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndragover(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndragover(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndragstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndragstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndrop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndrop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOndurationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOndurationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnemptied(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnemptied(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnended(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOninput(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOninput(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOninvalid(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOninvalid(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnkeydown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnkeydown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnkeypress(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnkeypress(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnkeyup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnkeyup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnloadeddata(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnloadeddata(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnloadedmetadata(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnloadedmetadata(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnloadstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnloadstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmousedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmousedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmouseenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmouseenter(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmouseleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmouseleave(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmousemove(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmousemove(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmouseout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmouseout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmouseover(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmouseover(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmouseup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmouseup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnmousewheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnmousewheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnpause(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnpause(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnplaying(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnplaying(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnprogress(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnprogress(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnratechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnratechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnreset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnreset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnseeked(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnseeked(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnseeking(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnseeking(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnselect(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnselect(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnstalled(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnstalled(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnsubmit(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnsubmit(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnsuspend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnsuspend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOntimeupdate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOntimeupdate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnvolumechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnvolumechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwaiting(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwaiting(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnsearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnsearch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwheel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsElementOntouchcancel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOntouchcancel(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsElementOntouchend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOntouchend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsElementOntouchmove(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOntouchmove(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsElementOntouchstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOntouchstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitmouseforcechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitmouseforcechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitmouseforcedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitmouseforcedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitmouseforcewillbegin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitmouseforcewillbegin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitmouseforceup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitmouseforceup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsElementOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementPreviousElementSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementNextElementSibling(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(SHADOW_DOM)
JSC::EncodedJSValue jsElementAssignedSlot(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsElementChildren(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementFirstElementChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementLastElementChild(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementChildElementCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSElementPrototype>(vm.heap)) JSElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSElement> JSElementConstructor;

/* Hash table for constructor */

static const HashTableValue JSElementConstructorTableValues[] =
{
    { "ALLOW_KEYBOARD_INPUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
};


COMPILE_ASSERT(1 == Element::ALLOW_KEYBOARD_INPUT, ElementEnumALLOW_KEYBOARD_INPUTIsWrongUseDoNotCheckConstants);

template<> JSValue JSElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Element"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSElementConstructorTableValues, *this);
}

template<> const ClassInfo JSElementConstructor::s_info = { "Element", &Base::s_info, 0, CREATE_METHOD_TABLE(JSElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementConstructor) } },
    { "tagName", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementTagName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attributes", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAttributes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "style", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementId) } },
    { "offsetLeft", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetTop", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetWidth", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetHeight", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientLeft", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientTop", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientWidth", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientHeight", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scrollLeft", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementScrollLeft) } },
    { "scrollTop", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementScrollTop) } },
    { "scrollWidth", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scrollHeight", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetParent", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOffsetParent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "innerHTML", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementInnerHTML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementInnerHTML) } },
    { "outerHTML", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOuterHTML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOuterHTML) } },
    { "className", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClassName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementClassName) } },
    { "classList", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClassList), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementClassList) } },
    { "dataset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementDataset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(CSS_REGIONS)
    { "webkitRegionOverset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementWebkitRegionOverset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SHADOW_DOM)
    { "shadowRoot", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementShadowRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SHADOW_DOM)
    { "slot", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementSlot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementSlot) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onbeforecopy", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforecopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforecopy) } },
    { "onbeforecut", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforecut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforecut) } },
    { "onbeforepaste", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforepaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforepaste) } },
    { "oncopy", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncopy) } },
    { "oncut", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncut) } },
    { "onpaste", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnpaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnpaste) } },
    { "onselectstart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnselectstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnselectstart) } },
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitfullscreenchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitfullscreenchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitfullscreenerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitfullscreenerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onanimationend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnanimationend) } },
    { "onanimationiteration", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnanimationiteration) } },
    { "onanimationstart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnanimationstart) } },
    { "ontransitionend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOntransitionend) } },
    { "onwebkitanimationend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitanimationend) } },
    { "onwebkitanimationiteration", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitanimationiteration) } },
    { "onwebkitanimationstart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitanimationstart) } },
    { "onwebkittransitionend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkittransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkittransitionend) } },
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongesturechange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOngesturechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOngesturechange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongestureend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOngestureend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOngestureend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongesturestart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOngesturestart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOngesturestart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onfocusin", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnfocusin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnfocusin) } },
    { "onfocusout", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnfocusout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnfocusout) } },
    { "onbeforeload", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforeload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforeload) } },
#if ENABLE(ENCRYPTED_MEDIA)
    { "onwebkitkeyadded", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitkeyadded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitkeyadded) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "onwebkitkeyerror", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitkeyerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitkeyerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "onwebkitkeymessage", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitkeymessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitkeymessage) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
    { "onwebkitneedkey", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitneedkey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitneedkey) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "onwebkitpresentationmodechanged", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitpresentationmodechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitpresentationmodechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "onwebkitcurrentplaybacktargetiswirelesschanged", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitcurrentplaybacktargetiswirelesschanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitcurrentplaybacktargetiswirelesschanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "onwebkitplaybacktargetavailabilitychanged", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitplaybacktargetavailabilitychanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitplaybacktargetavailabilitychanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onabort", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnabort) } },
#if ENABLE(REQUEST_AUTOCOMPLETE)
    { "onautocomplete", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnautocomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnautocomplete) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(REQUEST_AUTOCOMPLETE)
    { "onautocompleteerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnautocompleteerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnautocompleteerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onblur", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnblur) } },
    { "oncanplay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncanplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncanplay) } },
    { "oncanplaythrough", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncanplaythrough), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncanplaythrough) } },
    { "onchange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnchange) } },
    { "onclick", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnclick) } },
    { "oncontextmenu", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncontextmenu), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncontextmenu) } },
    { "ondblclick", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndblclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndblclick) } },
    { "ondrag", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndrag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndrag) } },
    { "ondragend", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndragend) } },
    { "ondragenter", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndragenter) } },
    { "ondragleave", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndragleave) } },
    { "ondragover", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndragover) } },
    { "ondragstart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndragstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndragstart) } },
    { "ondrop", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndrop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndrop) } },
    { "ondurationchange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOndurationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOndurationchange) } },
    { "onemptied", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnemptied), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnemptied) } },
    { "onended", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnended) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnerror) } },
    { "onfocus", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnfocus) } },
    { "oninput", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOninput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOninput) } },
    { "oninvalid", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOninvalid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOninvalid) } },
    { "onkeydown", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnkeydown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnkeydown) } },
    { "onkeypress", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnkeypress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnkeypress) } },
    { "onkeyup", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnkeyup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnkeyup) } },
    { "onload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnload) } },
    { "onloadeddata", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnloadeddata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnloadeddata) } },
    { "onloadedmetadata", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnloadedmetadata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnloadedmetadata) } },
    { "onloadstart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnloadstart) } },
    { "onmousedown", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmousedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmousedown) } },
    { "onmouseenter", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmouseenter) } },
    { "onmouseleave", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmouseleave) } },
    { "onmousemove", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmousemove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmousemove) } },
    { "onmouseout", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmouseout) } },
    { "onmouseover", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmouseover) } },
    { "onmouseup", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmouseup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmouseup) } },
    { "onmousewheel", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnmousewheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnmousewheel) } },
    { "onpause", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnpause), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnpause) } },
    { "onplay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnplay) } },
    { "onplaying", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnplaying), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnplaying) } },
    { "onprogress", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnprogress) } },
    { "onratechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnratechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnratechange) } },
    { "onreset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnreset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnreset) } },
    { "onresize", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnresize) } },
    { "onscroll", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnscroll) } },
    { "onseeked", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnseeked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnseeked) } },
    { "onseeking", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnseeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnseeking) } },
    { "onselect", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnselect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnselect) } },
    { "onstalled", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnstalled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnstalled) } },
    { "onsubmit", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnsubmit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnsubmit) } },
    { "onsuspend", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnsuspend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnsuspend) } },
    { "ontimeupdate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntimeupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOntimeupdate) } },
    { "onvolumechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnvolumechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnvolumechange) } },
    { "onwaiting", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwaiting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwaiting) } },
    { "onsearch", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnsearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnsearch) } },
    { "onwheel", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwheel) } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOntouchcancel) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOntouchend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchmove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOntouchmove) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOntouchstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOntouchstart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealbottom", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitwillrevealbottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitwillrevealbottom) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealleft", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitwillrevealleft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitwillrevealleft) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealright", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitwillrevealright), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitwillrevealright) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealtop", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitwillrevealtop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitwillrevealtop) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "previousElementSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementPreviousElementSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextElementSibling", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementNextElementSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(SHADOW_DOM)
    { "assignedSlot", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAssignedSlot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "children", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementChildren), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstElementChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementFirstElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastElementChild", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementLastElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "childElementCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementChildElementCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getAttribute", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttribute), (intptr_t) (0) } },
    { "setAttribute", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttribute), (intptr_t) (0) } },
    { "removeAttribute", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemoveAttribute), (intptr_t) (0) } },
    { "getAttributeNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNode), (intptr_t) (0) } },
    { "setAttributeNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttributeNode), (intptr_t) (0) } },
    { "removeAttributeNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemoveAttributeNode), (intptr_t) (0) } },
    { "getElementsByTagName", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetElementsByTagName), (intptr_t) (0) } },
    { "hasAttributes", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionHasAttributes), (intptr_t) (0) } },
    { "getAttributeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNS), (intptr_t) (0) } },
    { "setAttributeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttributeNS), (intptr_t) (0) } },
    { "removeAttributeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemoveAttributeNS), (intptr_t) (2) } },
    { "getElementsByTagNameNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetElementsByTagNameNS), (intptr_t) (0) } },
    { "getAttributeNodeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNodeNS), (intptr_t) (0) } },
    { "setAttributeNodeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionSetAttributeNodeNS), (intptr_t) (0) } },
    { "hasAttribute", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionHasAttribute), (intptr_t) (1) } },
    { "hasAttributeNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionHasAttributeNS), (intptr_t) (0) } },
    { "focus", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionFocus), (intptr_t) (0) } },
    { "blur", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionBlur), (intptr_t) (0) } },
    { "scrollIntoView", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollIntoView), (intptr_t) (0) } },
    { "getAttributeNames", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetAttributeNames), (intptr_t) (0) } },
    { "scrollIntoViewIfNeeded", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollIntoViewIfNeeded), (intptr_t) (0) } },
    { "scrollByLines", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollByLines), (intptr_t) (0) } },
    { "scrollByPages", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionScrollByPages), (intptr_t) (0) } },
    { "getElementsByClassName", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetElementsByClassName), (intptr_t) (0) } },
    { "matches", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionMatches), (intptr_t) (1) } },
    { "closest", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionClosest), (intptr_t) (1) } },
    { "webkitMatchesSelector", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitMatchesSelector), (intptr_t) (1) } },
    { "getClientRects", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetClientRects), (intptr_t) (0) } },
    { "getBoundingClientRect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionGetBoundingClientRect), (intptr_t) (0) } },
    { "webkitRequestFullScreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitRequestFullScreen), (intptr_t) (0) } },
    { "webkitRequestFullscreen", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitRequestFullscreen), (intptr_t) (0) } },
#if ENABLE(POINTER_LOCK)
    { "requestPointerLock", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRequestPointerLock), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(CSS_REGIONS)
    { "webkitGetRegionFlowRanges", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionWebkitGetRegionFlowRanges), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SHADOW_DOM)
    { "attachShadow", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionAttachShadow), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "before", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionBefore), (intptr_t) (0) } },
    { "after", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionAfter), (intptr_t) (0) } },
    { "replaceWith", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionReplaceWith), (intptr_t) (0) } },
    { "remove", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionRemove), (intptr_t) (0) } },
    { "prepend", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionPrepend), (intptr_t) (0) } },
    { "append", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionAppend), (intptr_t) (0) } },
    { "querySelector", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionQuerySelector), (intptr_t) (1) } },
    { "querySelectorAll", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsElementPrototypeFunctionQuerySelectorAll), (intptr_t) (1) } },
    { "ALLOW_KEYBOARD_INPUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
};

const ClassInfo JSElementPrototype::s_info = { "ElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSElementPrototype) };

void JSElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSElementPrototypeTableValues, *this);
}

const ClassInfo JSElement::s_info = { "Element", &Base::s_info, 0, CREATE_METHOD_TABLE(JSElement) };

JSElement::JSElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Element>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSElementPrototype::create(vm, globalObject, JSElementPrototype::createStructure(vm, globalObject, JSNode::getPrototype(vm, globalObject)));
}

JSObject* JSElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSElement>(vm, globalObject);
}

EncodedJSValue jsElementTagName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "tagName");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.tagName());
    return JSValue::encode(result);
}


EncodedJSValue jsElementAttributes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "attributes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.attributes()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementStyle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "style");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.cssomStyle()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "id");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getIdAttribute());
    return JSValue::encode(result);
}


EncodedJSValue jsElementOffsetLeft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "offsetLeft");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.offsetLeft());
    return JSValue::encode(result);
}


EncodedJSValue jsElementOffsetTop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "offsetTop");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.offsetTop());
    return JSValue::encode(result);
}


EncodedJSValue jsElementOffsetWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "offsetWidth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.offsetWidth());
    return JSValue::encode(result);
}


EncodedJSValue jsElementOffsetHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "offsetHeight");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.offsetHeight());
    return JSValue::encode(result);
}


EncodedJSValue jsElementClientLeft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "clientLeft");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.clientLeft());
    return JSValue::encode(result);
}


EncodedJSValue jsElementClientTop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "clientTop");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.clientTop());
    return JSValue::encode(result);
}


EncodedJSValue jsElementClientWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "clientWidth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.clientWidth());
    return JSValue::encode(result);
}


EncodedJSValue jsElementClientHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "clientHeight");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.clientHeight());
    return JSValue::encode(result);
}


EncodedJSValue jsElementScrollLeft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "scrollLeft");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.scrollLeft());
    return JSValue::encode(result);
}


EncodedJSValue jsElementScrollTop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "scrollTop");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.scrollTop());
    return JSValue::encode(result);
}


EncodedJSValue jsElementScrollWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "scrollWidth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.scrollWidth());
    return JSValue::encode(result);
}


EncodedJSValue jsElementScrollHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "scrollHeight");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.scrollHeight());
    return JSValue::encode(result);
}


EncodedJSValue jsElementOffsetParent(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "offsetParent");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.bindingsOffsetParent()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementInnerHTML(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "innerHTML");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.innerHTML());
    return JSValue::encode(result);
}


EncodedJSValue jsElementOuterHTML(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "outerHTML");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.outerHTML());
    return JSValue::encode(result);
}


EncodedJSValue jsElementClassName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "className");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::classAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsElementClassList(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "classList");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.classList()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementDataset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "dataset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.dataset()));
    return JSValue::encode(result);
}


#if ENABLE(CSS_REGIONS)
EncodedJSValue jsElementWebkitRegionOverset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "webkitRegionOverset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.webkitRegionOverset());
    return JSValue::encode(result);
}

#endif

#if ENABLE(SHADOW_DOM)
EncodedJSValue jsElementShadowRoot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "shadowRoot");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.shadowRootForBindings(*state)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(SHADOW_DOM)
EncodedJSValue jsElementSlot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "slot");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::slotAttr));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsElementOnbeforecopy(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onbeforecopy");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforecopyEvent));
}


EncodedJSValue jsElementOnbeforecut(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onbeforecut");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforecutEvent));
}


EncodedJSValue jsElementOnbeforepaste(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onbeforepaste");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforepasteEvent));
}


EncodedJSValue jsElementOncopy(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oncopy");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().copyEvent));
}


EncodedJSValue jsElementOncut(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oncut");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().cutEvent));
}


EncodedJSValue jsElementOnpaste(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onpaste");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().pasteEvent));
}


EncodedJSValue jsElementOnselectstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onselectstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().selectstartEvent));
}


#if ENABLE(FULLSCREEN_API)
EncodedJSValue jsElementOnwebkitfullscreenchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitfullscreenchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitfullscreenchangeEvent));
}

#endif

#if ENABLE(FULLSCREEN_API)
EncodedJSValue jsElementOnwebkitfullscreenerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitfullscreenerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitfullscreenerrorEvent));
}

#endif

EncodedJSValue jsElementOnanimationend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onanimationend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().animationendEvent));
}


EncodedJSValue jsElementOnanimationiteration(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onanimationiteration");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().animationiterationEvent));
}


EncodedJSValue jsElementOnanimationstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onanimationstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().animationstartEvent));
}


EncodedJSValue jsElementOntransitionend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ontransitionend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().transitionendEvent));
}


EncodedJSValue jsElementOnwebkitanimationend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitanimationend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitAnimationEndEvent));
}


EncodedJSValue jsElementOnwebkitanimationiteration(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitanimationiteration");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitAnimationIterationEvent));
}


EncodedJSValue jsElementOnwebkitanimationstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitanimationstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitAnimationStartEvent));
}


EncodedJSValue jsElementOnwebkittransitionend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkittransitionend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitTransitionEndEvent));
}


#if ENABLE(IOS_GESTURE_EVENTS)
EncodedJSValue jsElementOngesturechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ongesturechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().gesturechangeEvent));
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
EncodedJSValue jsElementOngestureend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ongestureend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().gestureendEvent));
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
EncodedJSValue jsElementOngesturestart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ongesturestart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().gesturestartEvent));
}

#endif

EncodedJSValue jsElementOnfocusin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onfocusin");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().focusinEvent));
}


EncodedJSValue jsElementOnfocusout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onfocusout");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().focusoutEvent));
}


EncodedJSValue jsElementOnbeforeload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onbeforeload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().beforeloadEvent));
}


#if ENABLE(ENCRYPTED_MEDIA)
EncodedJSValue jsElementOnwebkitkeyadded(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitkeyadded");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitkeyaddedEvent));
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
EncodedJSValue jsElementOnwebkitkeyerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitkeyerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitkeyerrorEvent));
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
EncodedJSValue jsElementOnwebkitkeymessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitkeymessage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitkeymessageEvent));
}

#endif

#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
EncodedJSValue jsElementOnwebkitneedkey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitneedkey");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitneedkeyEvent));
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
EncodedJSValue jsElementOnwebkitpresentationmodechanged(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitpresentationmodechanged");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitpresentationmodechangedEvent));
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
EncodedJSValue jsElementOnwebkitcurrentplaybacktargetiswirelesschanged(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitcurrentplaybacktargetiswirelesschanged");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitcurrentplaybacktargetiswirelesschangedEvent));
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
EncodedJSValue jsElementOnwebkitplaybacktargetavailabilitychanged(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitplaybacktargetavailabilitychanged");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitplaybacktargetavailabilitychangedEvent));
}

#endif

EncodedJSValue jsElementOnabort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onabort");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().abortEvent));
}


#if ENABLE(REQUEST_AUTOCOMPLETE)
EncodedJSValue jsElementOnautocomplete(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onautocomplete");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().autocompleteEvent));
}

#endif

#if ENABLE(REQUEST_AUTOCOMPLETE)
EncodedJSValue jsElementOnautocompleteerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onautocompleteerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().autocompleteerrorEvent));
}

#endif

EncodedJSValue jsElementOnblur(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onblur");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().blurEvent));
}


EncodedJSValue jsElementOncanplay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oncanplay");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().canplayEvent));
}


EncodedJSValue jsElementOncanplaythrough(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oncanplaythrough");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().canplaythroughEvent));
}


EncodedJSValue jsElementOnchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().changeEvent));
}


EncodedJSValue jsElementOnclick(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onclick");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().clickEvent));
}


EncodedJSValue jsElementOncontextmenu(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oncontextmenu");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().contextmenuEvent));
}


EncodedJSValue jsElementOndblclick(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondblclick");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dblclickEvent));
}


EncodedJSValue jsElementOndrag(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondrag");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragEvent));
}


EncodedJSValue jsElementOndragend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondragend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragendEvent));
}


EncodedJSValue jsElementOndragenter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondragenter");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragenterEvent));
}


EncodedJSValue jsElementOndragleave(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondragleave");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragleaveEvent));
}


EncodedJSValue jsElementOndragover(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondragover");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragoverEvent));
}


EncodedJSValue jsElementOndragstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondragstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dragstartEvent));
}


EncodedJSValue jsElementOndrop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondrop");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().dropEvent));
}


EncodedJSValue jsElementOndurationchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ondurationchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().durationchangeEvent));
}


EncodedJSValue jsElementOnemptied(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onemptied");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().emptiedEvent));
}


EncodedJSValue jsElementOnended(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onended");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().endedEvent));
}


EncodedJSValue jsElementOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsElementOnfocus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onfocus");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().focusEvent));
}


EncodedJSValue jsElementOninput(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oninput");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().inputEvent));
}


EncodedJSValue jsElementOninvalid(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "oninvalid");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().invalidEvent));
}


EncodedJSValue jsElementOnkeydown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onkeydown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().keydownEvent));
}


EncodedJSValue jsElementOnkeypress(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onkeypress");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().keypressEvent));
}


EncodedJSValue jsElementOnkeyup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onkeyup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().keyupEvent));
}


EncodedJSValue jsElementOnload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadEvent));
}


EncodedJSValue jsElementOnloadeddata(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onloadeddata");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadeddataEvent));
}


EncodedJSValue jsElementOnloadedmetadata(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onloadedmetadata");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadedmetadataEvent));
}


EncodedJSValue jsElementOnloadstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onloadstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadstartEvent));
}


EncodedJSValue jsElementOnmousedown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onmousedown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mousedownEvent));
}


EncodedJSValue jsElementOnmouseenter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return JSValue::encode(jsUndefined());
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseenterEvent));
}


EncodedJSValue jsElementOnmouseleave(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return JSValue::encode(jsUndefined());
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseleaveEvent));
}


EncodedJSValue jsElementOnmousemove(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onmousemove");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mousemoveEvent));
}


EncodedJSValue jsElementOnmouseout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onmouseout");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseoutEvent));
}


EncodedJSValue jsElementOnmouseover(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onmouseover");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseoverEvent));
}


EncodedJSValue jsElementOnmouseup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onmouseup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mouseupEvent));
}


EncodedJSValue jsElementOnmousewheel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onmousewheel");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().mousewheelEvent));
}


EncodedJSValue jsElementOnpause(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onpause");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().pauseEvent));
}


EncodedJSValue jsElementOnplay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onplay");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().playEvent));
}


EncodedJSValue jsElementOnplaying(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onplaying");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().playingEvent));
}


EncodedJSValue jsElementOnprogress(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onprogress");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().progressEvent));
}


EncodedJSValue jsElementOnratechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onratechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().ratechangeEvent));
}


EncodedJSValue jsElementOnreset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onreset");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().resetEvent));
}


EncodedJSValue jsElementOnresize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onresize");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().resizeEvent));
}


EncodedJSValue jsElementOnscroll(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onscroll");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().scrollEvent));
}


EncodedJSValue jsElementOnseeked(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onseeked");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().seekedEvent));
}


EncodedJSValue jsElementOnseeking(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onseeking");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().seekingEvent));
}


EncodedJSValue jsElementOnselect(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onselect");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().selectEvent));
}


EncodedJSValue jsElementOnstalled(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onstalled");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().stalledEvent));
}


EncodedJSValue jsElementOnsubmit(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onsubmit");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().submitEvent));
}


EncodedJSValue jsElementOnsuspend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onsuspend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().suspendEvent));
}


EncodedJSValue jsElementOntimeupdate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ontimeupdate");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().timeupdateEvent));
}


EncodedJSValue jsElementOnvolumechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onvolumechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().volumechangeEvent));
}


EncodedJSValue jsElementOnwaiting(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwaiting");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().waitingEvent));
}


EncodedJSValue jsElementOnsearch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onsearch");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().searchEvent));
}


EncodedJSValue jsElementOnwheel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwheel");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().wheelEvent));
}


#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsElementOntouchcancel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ontouchcancel");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchcancelEvent));
}

#endif

#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsElementOntouchend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ontouchend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchendEvent));
}

#endif

#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsElementOntouchmove(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ontouchmove");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchmoveEvent));
}

#endif

#if ENABLE(TOUCH_EVENTS)
EncodedJSValue jsElementOntouchstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "ontouchstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().touchstartEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsElementOnwebkitmouseforcechanged(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitmouseforcechanged");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcechangedEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsElementOnwebkitmouseforcedown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitmouseforcedown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcedownEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsElementOnwebkitmouseforcewillbegin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitmouseforcewillbegin");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcewillbeginEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsElementOnwebkitmouseforceup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitmouseforceup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforceupEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsElementOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitwillrevealbottom");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsElementOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitwillrevealleft");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealleftEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsElementOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitwillrevealright");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealrightEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsElementOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "onwebkitwillrevealtop");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealtopEvent));
}

#endif

EncodedJSValue jsElementPreviousElementSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "previousElementSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.previousElementSibling()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementNextElementSibling(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "nextElementSibling");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.nextElementSibling()));
    return JSValue::encode(result);
}


#if ENABLE(SHADOW_DOM)
EncodedJSValue jsElementAssignedSlot(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "assignedSlot");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.assignedSlot()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsElementChildren(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "children");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.children()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementFirstElementChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "firstElementChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.firstElementChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementLastElementChild(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "lastElementChild");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.lastElementChild()));
    return JSValue::encode(result);
}


EncodedJSValue jsElementChildElementCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsElementCast(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Element", "childElementCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.childElementCount());
    return JSValue::encode(result);
}


EncodedJSValue jsElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSElementPrototype* domObject = jsDynamicCast<JSElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSElementPrototype* domObject = jsDynamicCast<JSElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSElementId(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "id");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::idAttr, nativeValue);
}


void setJSElementScrollLeft(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "scrollLeft");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setScrollLeft(nativeValue);
}


void setJSElementScrollTop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "scrollTop");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setScrollTop(nativeValue);
}


void setJSElementInnerHTML(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "innerHTML");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setInnerHTML(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSElementOuterHTML(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "outerHTML");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setOuterHTML(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSElementClassName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "className");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::classAttr, nativeValue);
}


void setJSElementClassList(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "classList");
        return;
    }
    Ref<DOMTokenList> forwardedImpl = castedThis->wrapped().classList();
    auto& impl = forwardedImpl.get();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setValue(nativeValue);
}


#if ENABLE(SHADOW_DOM)
void setJSElementSlot(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "slot");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::slotAttr, nativeValue);
}

#endif

void setJSElementOnbeforecopy(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onbeforecopy");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforecopyEvent, value);
}


void setJSElementOnbeforecut(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onbeforecut");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforecutEvent, value);
}


void setJSElementOnbeforepaste(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onbeforepaste");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforepasteEvent, value);
}


void setJSElementOncopy(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oncopy");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().copyEvent, value);
}


void setJSElementOncut(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oncut");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().cutEvent, value);
}


void setJSElementOnpaste(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onpaste");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pasteEvent, value);
}


void setJSElementOnselectstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onselectstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().selectstartEvent, value);
}


#if ENABLE(FULLSCREEN_API)
void setJSElementOnwebkitfullscreenchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitfullscreenchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitfullscreenchangeEvent, value);
}

#endif

#if ENABLE(FULLSCREEN_API)
void setJSElementOnwebkitfullscreenerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitfullscreenerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitfullscreenerrorEvent, value);
}

#endif

void setJSElementOnanimationend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onanimationend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().animationendEvent, value);
}


void setJSElementOnanimationiteration(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onanimationiteration");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().animationiterationEvent, value);
}


void setJSElementOnanimationstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onanimationstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().animationstartEvent, value);
}


void setJSElementOntransitionend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ontransitionend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().transitionendEvent, value);
}


void setJSElementOnwebkitanimationend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitanimationend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitAnimationEndEvent, value);
}


void setJSElementOnwebkitanimationiteration(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitanimationiteration");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitAnimationIterationEvent, value);
}


void setJSElementOnwebkitanimationstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitanimationstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitAnimationStartEvent, value);
}


void setJSElementOnwebkittransitionend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkittransitionend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitTransitionEndEvent, value);
}


#if ENABLE(IOS_GESTURE_EVENTS)
void setJSElementOngesturechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ongesturechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().gesturechangeEvent, value);
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
void setJSElementOngestureend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ongestureend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().gestureendEvent, value);
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
void setJSElementOngesturestart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ongesturestart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().gesturestartEvent, value);
}

#endif

void setJSElementOnfocusin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onfocusin");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusinEvent, value);
}


void setJSElementOnfocusout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onfocusout");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusoutEvent, value);
}


void setJSElementOnbeforeload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onbeforeload");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforeloadEvent, value);
}


#if ENABLE(ENCRYPTED_MEDIA)
void setJSElementOnwebkitkeyadded(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitkeyadded");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitkeyaddedEvent, value);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
void setJSElementOnwebkitkeyerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitkeyerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitkeyerrorEvent, value);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
void setJSElementOnwebkitkeymessage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitkeymessage");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitkeymessageEvent, value);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
void setJSElementOnwebkitneedkey(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitneedkey");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitneedkeyEvent, value);
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
void setJSElementOnwebkitpresentationmodechanged(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitpresentationmodechanged");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitpresentationmodechangedEvent, value);
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
void setJSElementOnwebkitcurrentplaybacktargetiswirelesschanged(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitcurrentplaybacktargetiswirelesschanged");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitcurrentplaybacktargetiswirelesschangedEvent, value);
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
void setJSElementOnwebkitplaybacktargetavailabilitychanged(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitplaybacktargetavailabilitychanged");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitplaybacktargetavailabilitychangedEvent, value);
}

#endif

void setJSElementOnabort(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onabort");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().abortEvent, value);
}


#if ENABLE(REQUEST_AUTOCOMPLETE)
void setJSElementOnautocomplete(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onautocomplete");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().autocompleteEvent, value);
}

#endif

#if ENABLE(REQUEST_AUTOCOMPLETE)
void setJSElementOnautocompleteerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onautocompleteerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().autocompleteerrorEvent, value);
}

#endif

void setJSElementOnblur(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onblur");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().blurEvent, value);
}


void setJSElementOncanplay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oncanplay");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().canplayEvent, value);
}


void setJSElementOncanplaythrough(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oncanplaythrough");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().canplaythroughEvent, value);
}


void setJSElementOnchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().changeEvent, value);
}


void setJSElementOnclick(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onclick");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().clickEvent, value);
}


void setJSElementOncontextmenu(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oncontextmenu");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().contextmenuEvent, value);
}


void setJSElementOndblclick(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondblclick");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dblclickEvent, value);
}


void setJSElementOndrag(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondrag");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragEvent, value);
}


void setJSElementOndragend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondragend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragendEvent, value);
}


void setJSElementOndragenter(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondragenter");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragenterEvent, value);
}


void setJSElementOndragleave(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondragleave");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragleaveEvent, value);
}


void setJSElementOndragover(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondragover");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragoverEvent, value);
}


void setJSElementOndragstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondragstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dragstartEvent, value);
}


void setJSElementOndrop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondrop");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().dropEvent, value);
}


void setJSElementOndurationchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ondurationchange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().durationchangeEvent, value);
}


void setJSElementOnemptied(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onemptied");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().emptiedEvent, value);
}


void setJSElementOnended(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onended");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().endedEvent, value);
}


void setJSElementOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSElementOnfocus(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onfocus");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusEvent, value);
}


void setJSElementOninput(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oninput");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().inputEvent, value);
}


void setJSElementOninvalid(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "oninvalid");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().invalidEvent, value);
}


void setJSElementOnkeydown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onkeydown");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().keydownEvent, value);
}


void setJSElementOnkeypress(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onkeypress");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().keypressEvent, value);
}


void setJSElementOnkeyup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onkeyup");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().keyupEvent, value);
}


void setJSElementOnload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onload");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadEvent, value);
}


void setJSElementOnloadeddata(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onloadeddata");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadeddataEvent, value);
}


void setJSElementOnloadedmetadata(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onloadedmetadata");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadedmetadataEvent, value);
}


void setJSElementOnloadstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onloadstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadstartEvent, value);
}


void setJSElementOnmousedown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onmousedown");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mousedownEvent, value);
}


void setJSElementOnmouseenter(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseenterEvent, value);
}


void setJSElementOnmouseleave(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseleaveEvent, value);
}


void setJSElementOnmousemove(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onmousemove");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mousemoveEvent, value);
}


void setJSElementOnmouseout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onmouseout");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseoutEvent, value);
}


void setJSElementOnmouseover(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onmouseover");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseoverEvent, value);
}


void setJSElementOnmouseup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onmouseup");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mouseupEvent, value);
}


void setJSElementOnmousewheel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onmousewheel");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().mousewheelEvent, value);
}


void setJSElementOnpause(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onpause");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pauseEvent, value);
}


void setJSElementOnplay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onplay");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().playEvent, value);
}


void setJSElementOnplaying(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onplaying");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().playingEvent, value);
}


void setJSElementOnprogress(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onprogress");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().progressEvent, value);
}


void setJSElementOnratechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onratechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().ratechangeEvent, value);
}


void setJSElementOnreset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onreset");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().resetEvent, value);
}


void setJSElementOnresize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onresize");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().resizeEvent, value);
}


void setJSElementOnscroll(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onscroll");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().scrollEvent, value);
}


void setJSElementOnseeked(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onseeked");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().seekedEvent, value);
}


void setJSElementOnseeking(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onseeking");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().seekingEvent, value);
}


void setJSElementOnselect(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onselect");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().selectEvent, value);
}


void setJSElementOnstalled(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onstalled");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().stalledEvent, value);
}


void setJSElementOnsubmit(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onsubmit");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().submitEvent, value);
}


void setJSElementOnsuspend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onsuspend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().suspendEvent, value);
}


void setJSElementOntimeupdate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ontimeupdate");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().timeupdateEvent, value);
}


void setJSElementOnvolumechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onvolumechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().volumechangeEvent, value);
}


void setJSElementOnwaiting(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwaiting");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().waitingEvent, value);
}


void setJSElementOnsearch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onsearch");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().searchEvent, value);
}


void setJSElementOnwheel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwheel");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().wheelEvent, value);
}


#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchcancel(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ontouchcancel");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchcancelEvent, value);
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ontouchend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchendEvent, value);
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchmove(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ontouchmove");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchmoveEvent, value);
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSElementOntouchstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "ontouchstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().touchstartEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSElementOnwebkitmouseforcechanged(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitmouseforcechanged");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcechangedEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSElementOnwebkitmouseforcedown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitmouseforcedown");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcedownEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSElementOnwebkitmouseforcewillbegin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitmouseforcewillbegin");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSElementOnwebkitmouseforceup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitmouseforceup");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforceupEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSElementOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitwillrevealbottom");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSElementOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitwillrevealleft");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealleftEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSElementOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitwillrevealright");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealrightEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSElementOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSElement* castedThis = jsElementCast(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Element", "onwebkitwillrevealtop");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealtopEvent, value);
}

#endif

JSValue JSElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttribute(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getAttribute");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getAttribute(name));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttribute(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "setAttribute");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setAttribute(name, value, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttribute(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "removeAttribute");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.removeAttribute(name);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getAttributeNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getAttributeNode(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "setAttributeNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Attr* newAttr = JSAttr::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.setAttributeNode(newAttr, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "removeAttributeNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Attr* oldAttr = JSAttr::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.removeAttributeNode(oldAttr, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagName(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getElementsByTagName");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByTagName(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributes(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "hasAttributes");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.hasAttributes());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getAttributeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getAttributeNS(namespaceURI, localName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "setAttributeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String qualifiedName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setAttributeNS(namespaceURI, qualifiedName, value, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "removeAttributeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.removeAttributeNS(namespaceURI, localName);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagNameNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getElementsByTagNameNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByTagNameNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNodeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getAttributeNodeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getAttributeNodeNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNodeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "setAttributeNodeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Attr* newAttr = JSAttr::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.setAttributeNodeNS(newAttr, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttribute(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "hasAttribute");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.hasAttribute(name));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributeNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "hasAttributeNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.hasAttributeNS(namespaceURI, localName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionFocus(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "focus");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    impl.focus();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBlur(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "blur");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    impl.blur();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoView(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "scrollIntoView");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.scrollIntoView();
        return JSValue::encode(jsUndefined());
    }

    bool alignWithTop = state->argument(0).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.scrollIntoView(alignWithTop);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNames(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getAttributeNames");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsArray(state, castedThis->globalObject(), impl.getAttributeNames());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoViewIfNeeded(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "scrollIntoViewIfNeeded");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.scrollIntoViewIfNeeded();
        return JSValue::encode(jsUndefined());
    }

    bool centerIfNeeded = state->argument(0).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.scrollIntoViewIfNeeded(centerIfNeeded);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByLines(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "scrollByLines");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    int lines = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.scrollByLines(lines);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByPages(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "scrollByPages");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    int pages = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.scrollByPages(pages);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByClassName(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getElementsByClassName");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getElementsByClassName(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionMatches(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "matches");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.matches(selectors, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionClosest(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "closest");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.closest(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitMatchesSelector(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "webkitMatchesSelector");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.matches(selectors, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetClientRects(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getClientRects");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getClientRects()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetBoundingClientRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "getBoundingClientRect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getBoundingClientRect()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullScreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "webkitRequestFullScreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    uint16_t flags = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.webkitRequestFullScreen(flags);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullscreen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "webkitRequestFullscreen");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    impl.webkitRequestFullscreen();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(POINTER_LOCK)
EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRequestPointerLock(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "requestPointerLock");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    impl.requestPointerLock();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(CSS_REGIONS)
EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitGetRegionFlowRanges(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "webkitGetRegionFlowRanges");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsArray(state, castedThis->globalObject(), impl.webkitGetRegionFlowRanges());
    return JSValue::encode(result);
}

#endif

#if ENABLE(SHADOW_DOM)
EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAttachShadow(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "attachShadow");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Dictionary options = { state, state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.attachShadow(options, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "before");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    return JSValue::encode(castedThis->before(*state));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAfter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "after");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    return JSValue::encode(castedThis->after(*state));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionReplaceWith(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "replaceWith");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    return JSValue::encode(castedThis->replaceWith(*state));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemove(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "remove");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.remove(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionPrepend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "prepend");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    return JSValue::encode(castedThis->prepend(*state));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAppend(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "append");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    return JSValue::encode(castedThis->append(*state));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelector(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "querySelector");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.querySelector(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelectorAll(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsElementCast(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Element", "querySelectorAll");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String selectors = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.querySelectorAll(selectors, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

Element* JSElement::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsElementCast(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
