/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeType.h"

#include "DOMPlugin.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMPlugin.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsDOMMimeTypeType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeSuffixes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeDescription(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeEnabledPlugin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMMimeTypeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMMimeTypePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMMimeTypePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMimeTypePrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMimeTypePrototype>(vm.heap)) JSDOMMimeTypePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMimeTypePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDOMMimeType> JSDOMMimeTypeConstructor;

template<> JSValue JSDOMMimeTypeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMMimeTypeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMMimeType::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MimeType"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMMimeTypeConstructor::s_info = { "MimeType", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMMimeTypePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMimeTypeConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "suffixes", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeSuffixes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "description", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "enabledPlugin", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeEnabledPlugin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSDOMMimeTypePrototype::s_info = { "MimeTypePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMMimeTypePrototype) };

void JSDOMMimeTypePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMimeTypePrototypeTableValues, *this);
}

const ClassInfo JSDOMMimeType::s_info = { "MimeType", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMMimeType) };

JSDOMMimeType::JSDOMMimeType(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMimeType>&& impl)
    : JSDOMWrapper<DOMMimeType>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMMimeType::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMMimeTypePrototype::create(vm, globalObject, JSDOMMimeTypePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMMimeType::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMMimeType>(vm, globalObject);
}

void JSDOMMimeType::destroy(JSC::JSCell* cell)
{
    JSDOMMimeType* thisObject = static_cast<JSDOMMimeType*>(cell);
    thisObject->JSDOMMimeType::~JSDOMMimeType();
}

EncodedJSValue jsDOMMimeTypeType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMMimeType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMMimeType", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMMimeTypeSuffixes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMMimeType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMMimeType", "suffixes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.suffixes());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMMimeTypeDescription(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMMimeType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMMimeType", "description");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.description());
    return JSValue::encode(result);
}


EncodedJSValue jsDOMMimeTypeEnabledPlugin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDOMMimeType*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DOMMimeType", "enabledPlugin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.enabledPlugin()));
    return JSValue::encode(result);
}


EncodedJSValue jsDOMMimeTypeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMMimeTypePrototype* domObject = jsDynamicCast<JSDOMMimeTypePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMMimeType::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMMimeTypeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMMimeTypePrototype* domObject = jsDynamicCast<JSDOMMimeTypePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDOMMimeType::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSDOMMimeTypeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMMimeTypeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMMimeType = jsCast<JSDOMMimeType*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMMimeType->wrapped(), jsDOMMimeType);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMimeType@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11DOMMimeTypeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMMimeType* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMMimeType>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMMimeType* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMMimeType>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMMimeType@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11DOMMimeTypeE[2];
#if COMPILER(CLANG)
    // If this fails DOMMimeType does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMMimeType), DOMMimeType_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMMimeType has subclasses. If DOMMimeType has subclasses that get passed
    // to toJS() we currently require DOMMimeType you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSDOMMimeType>(globalObject, impl);
}

DOMMimeType* JSDOMMimeType::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMimeType*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
