/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCommandLineAPIHost.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionClearConsoleMessages(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionCopyText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspectedObject(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionGetEventListeners(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionDatabaseId(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionStorageId(JSC::ExecState*);

class JSCommandLineAPIHostPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCommandLineAPIHostPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCommandLineAPIHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSCommandLineAPIHostPrototype>(vm.heap)) JSCommandLineAPIHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCommandLineAPIHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSCommandLineAPIHostPrototypeTableValues[] =
{
    { "clearConsoleMessages", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionClearConsoleMessages), (intptr_t) (0) } },
    { "copyText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionCopyText), (intptr_t) (1) } },
    { "inspect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionInspect), (intptr_t) (2) } },
    { "inspectedObject", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionInspectedObject), (intptr_t) (0) } },
    { "getEventListeners", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionGetEventListeners), (intptr_t) (1) } },
    { "databaseId", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionDatabaseId), (intptr_t) (1) } },
    { "storageId", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCommandLineAPIHostPrototypeFunctionStorageId), (intptr_t) (1) } },
};

const ClassInfo JSCommandLineAPIHostPrototype::s_info = { "CommandLineAPIHostPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCommandLineAPIHostPrototype) };

void JSCommandLineAPIHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCommandLineAPIHostPrototypeTableValues, *this);
}

const ClassInfo JSCommandLineAPIHost::s_info = { "CommandLineAPIHost", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCommandLineAPIHost) };

JSCommandLineAPIHost::JSCommandLineAPIHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CommandLineAPIHost>&& impl)
    : JSDOMWrapper<CommandLineAPIHost>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCommandLineAPIHost::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCommandLineAPIHostPrototype::create(vm, globalObject, JSCommandLineAPIHostPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCommandLineAPIHost::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCommandLineAPIHost>(vm, globalObject);
}

void JSCommandLineAPIHost::destroy(JSC::JSCell* cell)
{
    JSCommandLineAPIHost* thisObject = static_cast<JSCommandLineAPIHost*>(cell);
    thisObject->JSCommandLineAPIHost::~JSCommandLineAPIHost();
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionClearConsoleMessages(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "clearConsoleMessages");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    auto& impl = castedThis->wrapped();
    impl.clearConsoleMessages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionCopyText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "copyText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String text = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.copyText(text);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "inspect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    return JSValue::encode(castedThis->inspect(*state));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspectedObject(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "inspectedObject");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    return JSValue::encode(castedThis->inspectedObject(*state));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionGetEventListeners(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "getEventListeners");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    return JSValue::encode(castedThis->getEventListeners(*state));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionDatabaseId(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "databaseId");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    return JSValue::encode(castedThis->databaseId(*state));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionStorageId(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCommandLineAPIHost*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CommandLineAPIHost", "storageId");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCommandLineAPIHost::info());
    return JSValue::encode(castedThis->storageId(*state));
}

bool JSCommandLineAPIHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSCommandLineAPIHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCommandLineAPIHost = jsCast<JSCommandLineAPIHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCommandLineAPIHost->wrapped(), jsCommandLineAPIHost);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, CommandLineAPIHost* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCommandLineAPIHost>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, CommandLineAPIHost* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCommandLineAPIHost>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to CommandLineAPIHost.
    COMPILE_ASSERT(!__is_polymorphic(CommandLineAPIHost), CommandLineAPIHost_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSCommandLineAPIHost>(globalObject, impl);
}

CommandLineAPIHost* JSCommandLineAPIHost::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCommandLineAPIHost*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
