/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRect.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsClientRectTop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectRight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectBottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectLeft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClientRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSClientRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSClientRectPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSClientRectPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSClientRectPrototype* ptr = new (NotNull, JSC::allocateCell<JSClientRectPrototype>(vm.heap)) JSClientRectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSClientRectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSClientRect> JSClientRectConstructor;

/* Hash table */

static const struct CompactHashIndex JSClientRectTableIndex[17] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, 16 },
    { -1, -1 },
    { -1, -1 },
    { 1, -1 },
    { 0, -1 },
    { -1, -1 },
    { 5, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { -1, -1 },
    { -1, -1 },
    { 4, -1 },
};


static const HashTableValue JSClientRectTableValues[] =
{
    { "top", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "right", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectRight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bottom", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectBottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "left", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSClientRectTable = { 6, 15, true, JSClientRectTableValues, JSClientRectTableIndex };
template<> JSValue JSClientRectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSClientRectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSClientRect::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ClientRect"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSClientRectConstructor::s_info = { "ClientRect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSClientRectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSClientRectPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSClientRectConstructor) } },
};

const ClassInfo JSClientRectPrototype::s_info = { "ClientRectPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSClientRectPrototype) };

void JSClientRectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSClientRectPrototypeTableValues, *this);
}

const ClassInfo JSClientRect::s_info = { "ClientRect", &Base::s_info, &JSClientRectTable, CREATE_METHOD_TABLE(JSClientRect) };

JSClientRect::JSClientRect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ClientRect>&& impl)
    : JSDOMWrapper<ClientRect>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSClientRect::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSClientRectPrototype::create(vm, globalObject, JSClientRectPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSClientRect::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRect>(vm, globalObject);
}

void JSClientRect::destroy(JSC::JSCell* cell)
{
    JSClientRect* thisObject = static_cast<JSClientRect*>(cell);
    thisObject->JSClientRect::~JSClientRect();
}

bool JSClientRect::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSClientRect*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSClientRect, Base>(state, JSClientRectTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsClientRectTop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRect*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRect", "top");
        reportDeprecatedGetterError(*state, "ClientRect", "top");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.top());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectRight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRect*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRect", "right");
        reportDeprecatedGetterError(*state, "ClientRect", "right");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.right());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectBottom(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRect*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRect", "bottom");
        reportDeprecatedGetterError(*state, "ClientRect", "bottom");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.bottom());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectLeft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRect*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRect", "left");
        reportDeprecatedGetterError(*state, "ClientRect", "left");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.left());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRect*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRect", "width");
        reportDeprecatedGetterError(*state, "ClientRect", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.width());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSClientRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSClientRect*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "ClientRect", "height");
        reportDeprecatedGetterError(*state, "ClientRect", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.height());
    return JSValue::encode(result);
}


EncodedJSValue jsClientRectConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSClientRectPrototype* domObject = jsDynamicCast<JSClientRectPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSClientRect::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSClientRectConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSClientRectPrototype* domObject = jsDynamicCast<JSClientRectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSClientRect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSClientRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSClientRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsClientRect = jsCast<JSClientRect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsClientRect->wrapped(), jsClientRect);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ClientRect* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSClientRect>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ClientRect* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSClientRect>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ClientRect.
    COMPILE_ASSERT(!__is_polymorphic(ClientRect), ClientRect_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSClientRect>(globalObject, impl);
}

ClientRect* JSClientRect::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSClientRect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
