/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleDeclaration.h"

#include "CSSRule.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionRemoveProperty(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionSetProperty(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCSSStyleDeclarationCssText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSStyleDeclarationCssText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSStyleDeclarationLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSStyleDeclarationParentRule(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSStyleDeclarationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSStyleDeclarationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleDeclarationPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleDeclarationPrototype>(vm.heap)) JSCSSStyleDeclarationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleDeclarationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSStyleDeclaration> JSCSSStyleDeclarationConstructor;

template<> JSValue JSCSSStyleDeclarationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSStyleDeclarationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleDeclaration::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSStyleDeclaration"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCSSStyleDeclarationConstructor::s_info = { "CSSStyleDeclaration", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSStyleDeclarationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSStyleDeclarationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSStyleDeclarationConstructor) } },
    { "cssText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationCssText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSStyleDeclarationCssText) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "parentRule", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationParentRule), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getPropertyValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue), (intptr_t) (1) } },
    { "getPropertyCSSValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue), (intptr_t) (0) } },
    { "removeProperty", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionRemoveProperty), (intptr_t) (0) } },
    { "getPropertyPriority", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority), (intptr_t) (0) } },
    { "setProperty", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionSetProperty), (intptr_t) (0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionItem), (intptr_t) (0) } },
    { "getPropertyShorthand", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand), (intptr_t) (0) } },
    { "isPropertyImplicit", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit), (intptr_t) (0) } },
};

const ClassInfo JSCSSStyleDeclarationPrototype::s_info = { "CSSStyleDeclarationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSStyleDeclarationPrototype) };

void JSCSSStyleDeclarationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleDeclarationPrototypeTableValues, *this);
}

const ClassInfo JSCSSStyleDeclaration::s_info = { "CSSStyleDeclaration", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSStyleDeclaration) };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleDeclaration>&& impl)
    : JSDOMWrapper<CSSStyleDeclaration>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSStyleDeclaration::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSStyleDeclarationPrototype::create(vm, globalObject, JSCSSStyleDeclarationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCSSStyleDeclaration::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSStyleDeclaration>(vm, globalObject);
}

void JSCSSStyleDeclaration::destroy(JSC::JSCell* cell)
{
    JSCSSStyleDeclaration* thisObject = static_cast<JSCSSStyleDeclaration*>(cell);
    thisObject->JSCSSStyleDeclaration::~JSCSSStyleDeclaration();
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, jsStringOrUndefined(state, thisObject->wrapped().item(index)));
        return true;
    }
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSCSSStyleDeclaration::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index <= MAX_ARRAY_INDEX) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, jsStringOrUndefined(state, thisObject->wrapped().item(index)));
        return true;
    }
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsCSSStyleDeclarationCssText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSStyleDeclaration", "cssText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.cssText());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSStyleDeclarationLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSStyleDeclaration", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSStyleDeclarationParentRule(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSStyleDeclaration", "parentRule");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.parentRule()));
    return JSValue::encode(result);
}


EncodedJSValue jsCSSStyleDeclarationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSStyleDeclarationPrototype* domObject = jsDynamicCast<JSCSSStyleDeclarationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSStyleDeclaration::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSStyleDeclarationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSStyleDeclarationPrototype* domObject = jsDynamicCast<JSCSSStyleDeclarationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSCSSStyleDeclaration::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::put(thisObject, state, propertyName, value, slot);
}

void JSCSSStyleDeclaration::putByIndex(JSCell* cell, ExecState* state, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    PutPropertySlot slot(thisObject, shouldThrow);
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::putByIndex(cell, state, index, value, shouldThrow);
}

void setJSCSSStyleDeclarationCssText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCSSStyleDeclaration* castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CSSStyleDeclaration", "cssText");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCssText(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSCSSStyleDeclaration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleDeclarationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "getPropertyValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    String propertyName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.getPropertyValue(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "getPropertyCSSValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    return JSValue::encode(castedThis->getPropertyCSSValue(*state));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionRemoveProperty(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "removeProperty");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String propertyName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.removeProperty(propertyName, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "getPropertyPriority");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    String propertyName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getPropertyPriority(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionSetProperty(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "setProperty");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String propertyName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String value = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String priority = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setProperty(propertyName, value, priority, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.item(index));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "getPropertyShorthand");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    String propertyName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.getPropertyShorthand(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSStyleDeclaration*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSStyleDeclaration", "isPropertyImplicit");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSStyleDeclaration::info());
    auto& impl = castedThis->wrapped();
    String propertyName = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isPropertyImplicit(propertyName));
    return JSValue::encode(result);
}

void JSCSSStyleDeclaration::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCSSStyleDeclaration*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSCSSStyleDeclarationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsCSSStyleDeclaration = jsCast<JSCSSStyleDeclaration*>(handle.slot()->asCell());
    void* root = WebCore::root(&jsCSSStyleDeclaration->wrapped());
    return visitor.containsOpaqueRoot(root);
}

void JSCSSStyleDeclarationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSStyleDeclaration = jsCast<JSCSSStyleDeclaration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSStyleDeclaration->wrapped(), jsCSSStyleDeclaration);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, CSSStyleDeclaration* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCSSStyleDeclaration>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, CSSStyleDeclaration* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCSSStyleDeclaration>(globalObject, impl))
        return result;
    return createNewWrapper<JSCSSStyleDeclaration>(globalObject, impl);
}

CSSStyleDeclaration* JSCSSStyleDeclaration::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSStyleDeclaration*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
