/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioDestinationNode.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsAudioDestinationNodeMaxChannelCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioDestinationNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioDestinationNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioDestinationNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioDestinationNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioDestinationNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioDestinationNodePrototype>(vm.heap)) JSAudioDestinationNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioDestinationNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAudioDestinationNode> JSAudioDestinationNodeConstructor;

template<> JSValue JSAudioDestinationNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioDestinationNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioDestinationNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AudioDestinationNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAudioDestinationNodeConstructor::s_info = { "AudioDestinationNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioDestinationNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioDestinationNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioDestinationNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioDestinationNodeConstructor) } },
    { "maxChannelCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioDestinationNodeMaxChannelCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAudioDestinationNodePrototype::s_info = { "AudioDestinationNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioDestinationNodePrototype) };

void JSAudioDestinationNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioDestinationNodePrototypeTableValues, *this);
}

const ClassInfo JSAudioDestinationNode::s_info = { "AudioDestinationNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioDestinationNode) };

JSAudioDestinationNode::JSAudioDestinationNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioDestinationNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioDestinationNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioDestinationNodePrototype::create(vm, globalObject, JSAudioDestinationNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSAudioDestinationNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioDestinationNode>(vm, globalObject);
}

EncodedJSValue jsAudioDestinationNodeMaxChannelCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioDestinationNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioDestinationNode", "maxChannelCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.maxChannelCount());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioDestinationNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioDestinationNodePrototype* domObject = jsDynamicCast<JSAudioDestinationNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioDestinationNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioDestinationNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioDestinationNodePrototype* domObject = jsDynamicCast<JSAudioDestinationNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSAudioDestinationNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioDestinationNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAudioDestinationNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioDestinationNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioDestinationNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioDestinationNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioDestinationNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioDestinationNode>(globalObject, impl))
        return result;
    return createNewWrapper<JSAudioDestinationNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
