/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAnalyserNode.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetFloatFrequencyData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteFrequencyData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteTimeDomainData(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsAnalyserNodeFftSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAnalyserNodeFftSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeFrequencyBinCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAnalyserNodeMinDecibels(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAnalyserNodeMinDecibels(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeMaxDecibels(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAnalyserNodeMaxDecibels(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeSmoothingTimeConstant(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAnalyserNodeSmoothingTimeConstant(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAnalyserNodeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAnalyserNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAnalyserNodePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnalyserNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAnalyserNodePrototype>(vm.heap)) JSAnalyserNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnalyserNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAnalyserNode> JSAnalyserNodeConstructor;

template<> JSValue JSAnalyserNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAnalyserNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAnalyserNode::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AnalyserNode"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAnalyserNodeConstructor::s_info = { "AnalyserNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAnalyserNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAnalyserNodePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeConstructor) } },
    { "fftSize", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeFftSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeFftSize) } },
    { "frequencyBinCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeFrequencyBinCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "minDecibels", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeMinDecibels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeMinDecibels) } },
    { "maxDecibels", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeMaxDecibels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeMaxDecibels) } },
    { "smoothingTimeConstant", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeSmoothingTimeConstant), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeSmoothingTimeConstant) } },
    { "getFloatFrequencyData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAnalyserNodePrototypeFunctionGetFloatFrequencyData), (intptr_t) (1) } },
    { "getByteFrequencyData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAnalyserNodePrototypeFunctionGetByteFrequencyData), (intptr_t) (1) } },
    { "getByteTimeDomainData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAnalyserNodePrototypeFunctionGetByteTimeDomainData), (intptr_t) (1) } },
};

const ClassInfo JSAnalyserNodePrototype::s_info = { "AnalyserNodePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAnalyserNodePrototype) };

void JSAnalyserNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnalyserNodePrototypeTableValues, *this);
}

const ClassInfo JSAnalyserNode::s_info = { "AnalyserNode", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAnalyserNode) };

JSAnalyserNode::JSAnalyserNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnalyserNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAnalyserNode::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAnalyserNodePrototype::create(vm, globalObject, JSAnalyserNodePrototype::createStructure(vm, globalObject, JSAudioNode::getPrototype(vm, globalObject)));
}

JSObject* JSAnalyserNode::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAnalyserNode>(vm, globalObject);
}

EncodedJSValue jsAnalyserNodeFftSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAnalyserNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AnalyserNode", "fftSize");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.fftSize());
    return JSValue::encode(result);
}


EncodedJSValue jsAnalyserNodeFrequencyBinCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAnalyserNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AnalyserNode", "frequencyBinCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.frequencyBinCount());
    return JSValue::encode(result);
}


EncodedJSValue jsAnalyserNodeMinDecibels(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAnalyserNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AnalyserNode", "minDecibels");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.minDecibels());
    return JSValue::encode(result);
}


EncodedJSValue jsAnalyserNodeMaxDecibels(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAnalyserNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AnalyserNode", "maxDecibels");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.maxDecibels());
    return JSValue::encode(result);
}


EncodedJSValue jsAnalyserNodeSmoothingTimeConstant(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAnalyserNode*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AnalyserNode", "smoothingTimeConstant");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.smoothingTimeConstant());
    return JSValue::encode(result);
}


EncodedJSValue jsAnalyserNodeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAnalyserNodePrototype* domObject = jsDynamicCast<JSAnalyserNodePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAnalyserNode::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAnalyserNodeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAnalyserNodePrototype* domObject = jsDynamicCast<JSAnalyserNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAnalyserNodeFftSize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAnalyserNode* castedThis = jsDynamicCast<JSAnalyserNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AnalyserNode", "fftSize");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    unsigned nativeValue = toUInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setFftSize(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSAnalyserNodeMinDecibels(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAnalyserNode* castedThis = jsDynamicCast<JSAnalyserNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AnalyserNode", "minDecibels");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMinDecibels(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSAnalyserNodeMaxDecibels(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAnalyserNode* castedThis = jsDynamicCast<JSAnalyserNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AnalyserNode", "maxDecibels");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMaxDecibels(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSAnalyserNodeSmoothingTimeConstant(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAnalyserNode* castedThis = jsDynamicCast<JSAnalyserNode*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AnalyserNode", "smoothingTimeConstant");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSmoothingTimeConstant(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSAnalyserNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnalyserNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetFloatFrequencyData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAnalyserNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AnalyserNode", "getFloatFrequencyData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAnalyserNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    RefPtr<Float32Array> array = toFloat32Array(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.getFloatFrequencyData(array.get());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteFrequencyData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAnalyserNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AnalyserNode", "getByteFrequencyData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAnalyserNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    RefPtr<Uint8Array> array = toUint8Array(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.getByteFrequencyData(array.get());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteTimeDomainData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAnalyserNode*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AnalyserNode", "getByteTimeDomainData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAnalyserNode::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    RefPtr<Uint8Array> array = toUint8Array(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.getByteTimeDomainData(array.get());
    return JSValue::encode(jsUndefined());
}

void JSAnalyserNode::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAnalyserNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AnalyserNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AnalyserNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AnalyserNode* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAnalyserNode>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AnalyserNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAnalyserNode>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AnalyserNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12AnalyserNodeE[2];
#if COMPILER(CLANG)
    // If this fails AnalyserNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AnalyserNode), AnalyserNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AnalyserNode has subclasses. If AnalyserNode has subclasses that get passed
    // to toJS() we currently require AnalyserNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSAnalyserNode>(globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
