/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.io.Serializable;

public final class ValueWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ValueWrapper nullValueWrapper = new ValueWrapper(null);
    private final Serializable value;
    private final Class<?> type;
    private final String stringRepresentation;
    private final int identityHashCode;
    private final transient Object ephemeralValue;

    public static ValueWrapper create(Object object) {
        if (object instanceof ValueWrapper) {
            return (ValueWrapper)object;
        }
        return object == null ? nullValueWrapper : new ValueWrapper(object);
    }

    public static ValueWrapper create(Object object, String string) {
        if (object instanceof ValueWrapper) {
            ValueWrapper valueWrapper = (ValueWrapper)object;
            return valueWrapper.stringRepresentation.equals(string) ? valueWrapper : ValueWrapper.create(valueWrapper.value, string);
        }
        return object == null ? nullValueWrapper : new ValueWrapper(object, string);
    }

    private ValueWrapper(Object object, String string) {
        this.value = object instanceof Serializable ? (Serializable)object : null;
        this.type = object != null ? object.getClass() : null;
        this.stringRepresentation = string == null ? ValueWrapper.safeValueToString(object) : string;
        this.identityHashCode = System.identityHashCode(object);
        this.ephemeralValue = object;
    }

    private ValueWrapper(Object object) {
        this(object, ValueWrapper.safeValueToString(object));
    }

    private static String safeValueToString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Exception exception) {
            return "<Exception in toString(): " + String.valueOf(exception) + ">";
        }
    }

    public Serializable getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public Object getEphemeralValue() {
        return this.ephemeralValue;
    }

    public String toString() {
        if (this.type == null) {
            return "null";
        }
        return this.stringRepresentation + " (" + this.type.getName() + "@" + Integer.toHexString(this.identityHashCode) + ")";
    }
}

