/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleFailuresError
extends AssertionError {
    private static final long serialVersionUID = 1L;
    private static final String EOL = System.getProperty("line.separator");
    private final String heading;
    private final List<Throwable> failures;

    public MultipleFailuresError(String string, List<? extends Throwable> list) {
        if (list == null) {
            throw new NullPointerException("failures must not be null");
        }
        this.heading = MultipleFailuresError.isBlank(string) ? "Multiple Failures" : string.trim();
        this.failures = new ArrayList<Throwable>();
        for (Throwable throwable : list) {
            if (throwable == null) {
                throw new NullPointerException("failures must not contain null elements");
            }
            this.failures.add(throwable);
        }
    }

    public String getMessage() {
        int n = this.failures.size();
        if (n == 0) {
            return this.heading;
        }
        StringBuilder stringBuilder = new StringBuilder(this.heading).append(" (").append(n).append(" ").append(MultipleFailuresError.pluralize(n, "failure", "failures")).append(")").append(EOL);
        int n2 = n - 1;
        for (Throwable throwable : this.failures.subList(0, n2)) {
            stringBuilder.append("\t").append(MultipleFailuresError.nullSafeMessage(throwable)).append(EOL);
        }
        stringBuilder.append('\t').append(MultipleFailuresError.nullSafeMessage(this.failures.get(n2)));
        return stringBuilder.toString();
    }

    public List<Throwable> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    private static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static String pluralize(int n, String string, String string2) {
        return n == 1 ? string : string2;
    }

    private static String nullSafeMessage(Throwable throwable) {
        if (MultipleFailuresError.isBlank(throwable.getMessage())) {
            return throwable.getClass().getName() + ": <no message>";
        }
        return throwable.getClass().getName() + ": " + throwable.getMessage();
    }
}

