/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.extension.authorization.AuthorizationDetectionMethod;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.extension.authorization.ExtensionAuthorization;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextAuthorizationPanel
extends AbstractContextPropertiesPanel {
    private static final long serialVersionUID = 2416553589170267959L;
    private static final Logger log = LogManager.getLogger(ContextAuthorizationPanel.class);
    private static final String PANEL_NAME = Constant.messages.getString("authorization.panel.title");
    private static final String LABEL_DESCRIPTION = Constant.messages.getHtmlWrappedString("authorization.panel.label.description");
    private static final String FIELD_LABEL_INTRO = Constant.messages.getHtmlWrappedString("authorization.detection.basic.field.intro");
    private static final String FIELD_LABEL_STATUS_CODE = Constant.messages.getString("authorization.detection.basic.field.statusCode");
    private static final String FIELD_LABEL_HEADER_PATTERN = Constant.messages.getString("authorization.detection.basic.field.headerPattern");
    private static final String FIELD_LABEL_BODY_PATTERN = Constant.messages.getString("authorization.detection.basic.field.bodyPattern");
    private static final String FIELD_VALUE_AND_COMPOSITION = Constant.messages.getString("authorization.detection.basic.field.composition.and");
    private static final String FIELD_VALUE_OR_COMPOSITION = Constant.messages.getString("authorization.detection.basic.field.composition.or");
    private static Object[] STATUS_CODES = new Object[HttpStatusCode.CODES.length + 1];
    private JComboBox<Object> statusCodeComboBox;
    private JTextField headerPatternText;
    private JTextField bodyPatternText;
    private JComboBox<String> logicalOperatorComboBox;
    private ExtensionAuthorization extension;
    private AuthorizationDetectionMethod authorizationMethod;

    public ContextAuthorizationPanel(ExtensionAuthorization extension, int contextId) {
        super(contextId);
        this.extension = extension;
        this.initialize();
    }

    public static String buildName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(this.getContextId() + ": " + PANEL_NAME);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add((Component)new JLabel(LABEL_DESCRIPTION), LayoutHelper.getGBC(0, 0, 2, 0.0, new Insets(0, 0, 20, 0)));
        Insets insets = new Insets(2, 5, 2, 5);
        this.add((Component)new JLabel(FIELD_LABEL_INTRO), LayoutHelper.getGBC(0, 1, 2, 0.0, new Insets(0, 0, 5, 0)));
        JPanel configContainerPanel = new JPanel(new GridBagLayout());
        configContainerPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
        this.add((Component)configContainerPanel, LayoutHelper.getGBC(0, 2, 2, 0.0));
        configContainerPanel.add((Component)new JLabel(FIELD_LABEL_STATUS_CODE), LayoutHelper.getGBC(0, 2, 1, 0.0));
        this.statusCodeComboBox = new JComboBox<Object>(STATUS_CODES);
        configContainerPanel.add(this.statusCodeComboBox, LayoutHelper.getGBC(1, 2, 1, 1.0, insets));
        configContainerPanel.add((Component)new JLabel(FIELD_LABEL_HEADER_PATTERN), LayoutHelper.getGBC(0, 3, 1, 0.0));
        this.headerPatternText = new JTextField();
        configContainerPanel.add((Component)this.headerPatternText, LayoutHelper.getGBC(1, 3, 1, 1.0, insets));
        configContainerPanel.add((Component)new JLabel(FIELD_LABEL_BODY_PATTERN), LayoutHelper.getGBC(0, 4, 1, 0.0));
        this.bodyPatternText = new JTextField();
        configContainerPanel.add((Component)this.bodyPatternText, LayoutHelper.getGBC(1, 4, 1, 1.0, insets));
        this.logicalOperatorComboBox = new JComboBox<String>(new String[]{FIELD_VALUE_AND_COMPOSITION, FIELD_VALUE_OR_COMPOSITION});
        configContainerPanel.add(this.logicalOperatorComboBox, LayoutHelper.getGBC(0, 5, 2, 0.0, new Insets(2, 0, 2, 5)));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 99, 2, 1.0, 1.0));
    }

    @Override
    public void initContextData(Session session, Context uiSharedContext) {
        this.authorizationMethod = uiSharedContext.getAuthorizationDetectionMethod();
        if (this.authorizationMethod != null) {
            if (this.authorizationMethod instanceof BasicAuthorizationDetectionMethod) {
                log.debug("Initializing panel with " + BasicAuthorizationDetectionMethod.class.getSimpleName() + ": " + this.authorizationMethod);
                BasicAuthorizationDetectionMethod method = (BasicAuthorizationDetectionMethod)this.authorizationMethod;
                if (method.bodyPattern != null) {
                    this.bodyPatternText.setText(method.bodyPattern.pattern());
                }
                if (method.headerPattern != null) {
                    this.headerPatternText.setText(method.headerPattern.pattern());
                }
                if (method.statusCode != -1) {
                    this.statusCodeComboBox.setSelectedItem(method.statusCode);
                }
                if (method.logicalOperator == BasicAuthorizationDetectionMethod.LogicalOperator.AND) {
                    this.logicalOperatorComboBox.setSelectedItem(FIELD_VALUE_AND_COMPOSITION);
                } else {
                    this.logicalOperatorComboBox.setSelectedItem(FIELD_VALUE_OR_COMPOSITION);
                }
                return;
            }
            log.warn("Unsupported authorization method on panel: " + this.authorizationMethod.getClass().getSimpleName());
        }
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        try {
            Pattern.compile(this.headerPatternText.getText());
            Pattern.compile(this.bodyPatternText.getText());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalStateException(Constant.messages.getString("authorization.detection.basic.error.illegalPattern", this.getUISharedContext().getName()), e);
        }
    }

    private void saveMethod() {
        Integer selectedStatusCode = (Integer)(this.statusCodeComboBox.getSelectedIndex() == 0 ? null : this.statusCodeComboBox.getSelectedItem());
        BasicAuthorizationDetectionMethod.LogicalOperator selectedComposition = this.logicalOperatorComboBox.getSelectedItem().equals(FIELD_VALUE_AND_COMPOSITION) ? BasicAuthorizationDetectionMethod.LogicalOperator.AND : BasicAuthorizationDetectionMethod.LogicalOperator.OR;
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(selectedStatusCode, this.headerPatternText.getText(), this.bodyPatternText.getText(), selectedComposition);
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        this.saveMethod();
        uiSharedContext.setAuthorizationDetectionMethod(this.authorizationMethod);
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        this.saveMethod();
        session.getContext(this.getContextId()).setAuthorizationDetectionMethod(this.authorizationMethod);
        log.debug("Saving authorization method: " + this.authorizationMethod);
    }

    @Override
    public String getHelpIndex() {
        return null;
    }

    static {
        ContextAuthorizationPanel.STATUS_CODES[0] = " -- ";
        for (int i = 0; i < HttpStatusCode.CODES.length; ++i) {
            ContextAuthorizationPanel.STATUS_CODES[i + 1] = HttpStatusCode.CODES[i];
        }
    }
}

