# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _unbound
else:
    import _unbound

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



import encodings.idna
try:
    import builtins
except ImportError:
    import __builtin__ as builtins

# Ensure compatibility with older python versions
if 'bytes' not in vars():
    bytes = str

def ord(s):
    if isinstance(s, int):
        return s
    return builtins.ord(s)


def ub_ctx_free_dbg(c):
    return _unbound.ub_ctx_free_dbg(c)
RR_TYPE_A = _unbound.RR_TYPE_A
RR_TYPE_NS = _unbound.RR_TYPE_NS
RR_TYPE_MD = _unbound.RR_TYPE_MD
RR_TYPE_MF = _unbound.RR_TYPE_MF
RR_TYPE_CNAME = _unbound.RR_TYPE_CNAME
RR_TYPE_SOA = _unbound.RR_TYPE_SOA
RR_TYPE_MB = _unbound.RR_TYPE_MB
RR_TYPE_MG = _unbound.RR_TYPE_MG
RR_TYPE_MR = _unbound.RR_TYPE_MR
RR_TYPE_NULL = _unbound.RR_TYPE_NULL
RR_TYPE_WKS = _unbound.RR_TYPE_WKS
RR_TYPE_PTR = _unbound.RR_TYPE_PTR
RR_TYPE_HINFO = _unbound.RR_TYPE_HINFO
RR_TYPE_MINFO = _unbound.RR_TYPE_MINFO
RR_TYPE_MX = _unbound.RR_TYPE_MX
RR_TYPE_TXT = _unbound.RR_TYPE_TXT
RR_TYPE_RP = _unbound.RR_TYPE_RP
RR_TYPE_AFSDB = _unbound.RR_TYPE_AFSDB
RR_TYPE_X25 = _unbound.RR_TYPE_X25
RR_TYPE_ISDN = _unbound.RR_TYPE_ISDN
RR_TYPE_RT = _unbound.RR_TYPE_RT
RR_TYPE_NSAP = _unbound.RR_TYPE_NSAP
RR_TYPE_NSAP_PTR = _unbound.RR_TYPE_NSAP_PTR
RR_TYPE_SIG = _unbound.RR_TYPE_SIG
RR_TYPE_KEY = _unbound.RR_TYPE_KEY
RR_TYPE_PX = _unbound.RR_TYPE_PX
RR_TYPE_GPOS = _unbound.RR_TYPE_GPOS
RR_TYPE_AAAA = _unbound.RR_TYPE_AAAA
RR_TYPE_LOC = _unbound.RR_TYPE_LOC
RR_TYPE_NXT = _unbound.RR_TYPE_NXT
RR_TYPE_EID = _unbound.RR_TYPE_EID
RR_TYPE_NIMLOC = _unbound.RR_TYPE_NIMLOC
RR_TYPE_SRV = _unbound.RR_TYPE_SRV
RR_TYPE_ATMA = _unbound.RR_TYPE_ATMA
RR_TYPE_NAPTR = _unbound.RR_TYPE_NAPTR
RR_TYPE_KX = _unbound.RR_TYPE_KX
RR_TYPE_CERT = _unbound.RR_TYPE_CERT
RR_TYPE_A6 = _unbound.RR_TYPE_A6
RR_TYPE_DNAME = _unbound.RR_TYPE_DNAME
RR_TYPE_SINK = _unbound.RR_TYPE_SINK
RR_TYPE_OPT = _unbound.RR_TYPE_OPT
RR_TYPE_APL = _unbound.RR_TYPE_APL
RR_TYPE_DS = _unbound.RR_TYPE_DS
RR_TYPE_SSHFP = _unbound.RR_TYPE_SSHFP
RR_TYPE_IPSECKEY = _unbound.RR_TYPE_IPSECKEY
RR_TYPE_RRSIG = _unbound.RR_TYPE_RRSIG
RR_TYPE_NSEC = _unbound.RR_TYPE_NSEC
RR_TYPE_DNSKEY = _unbound.RR_TYPE_DNSKEY
RR_TYPE_DHCID = _unbound.RR_TYPE_DHCID
RR_TYPE_NSEC3 = _unbound.RR_TYPE_NSEC3
RR_TYPE_NSEC3PARAMS = _unbound.RR_TYPE_NSEC3PARAMS
RR_TYPE_UINFO = _unbound.RR_TYPE_UINFO
RR_TYPE_UID = _unbound.RR_TYPE_UID
RR_TYPE_GID = _unbound.RR_TYPE_GID
RR_TYPE_UNSPEC = _unbound.RR_TYPE_UNSPEC
RR_TYPE_TSIG = _unbound.RR_TYPE_TSIG
RR_TYPE_IXFR = _unbound.RR_TYPE_IXFR
RR_TYPE_AXFR = _unbound.RR_TYPE_AXFR
RR_TYPE_MAILB = _unbound.RR_TYPE_MAILB
RR_TYPE_MAILA = _unbound.RR_TYPE_MAILA
RR_TYPE_ANY = _unbound.RR_TYPE_ANY
RR_TYPE_CAA = _unbound.RR_TYPE_CAA
RR_TYPE_DLV = _unbound.RR_TYPE_DLV
RR_CLASS_IN = _unbound.RR_CLASS_IN
RR_CLASS_CH = _unbound.RR_CLASS_CH
RR_CLASS_HS = _unbound.RR_CLASS_HS
RR_CLASS_NONE = _unbound.RR_CLASS_NONE
RR_CLASS_ANY = _unbound.RR_CLASS_ANY

def ub_resolve_free_dbg(r):
    return _unbound.ub_resolve_free_dbg(r)
RCODE_NOERROR = _unbound.RCODE_NOERROR
RCODE_FORMERR = _unbound.RCODE_FORMERR
RCODE_SERVFAIL = _unbound.RCODE_SERVFAIL
RCODE_NXDOMAIN = _unbound.RCODE_NXDOMAIN
RCODE_NOTIMPL = _unbound.RCODE_NOTIMPL
RCODE_REFUSED = _unbound.RCODE_REFUSED
RCODE_YXDOMAIN = _unbound.RCODE_YXDOMAIN
RCODE_YXRRSET = _unbound.RCODE_YXRRSET
RCODE_NXRRSET = _unbound.RCODE_NXRRSET
RCODE_NOTAUTH = _unbound.RCODE_NOTAUTH
RCODE_NOTZONE = _unbound.RCODE_NOTZONE

class ub_data:
   """Class which makes the resolution results accessible"""
   def __init__(self, data):
      """Creates ub_data class
         :param data: a list of the result data in RAW format
      """
      if data == None:
         raise Exception("ub_data init: No data")
      self.data = data

   def __str__(self):
      """Represents data as string"""
      return ';'.join([' '.join(map(lambda x:"%02X" % ord(x),a)) for a in self.data])

   @staticmethod
   def dname2str(s, ofs=0, maxlen=0):
      """Parses DNAME and produces a list of labels

         :param ofs: where the conversion should start to parse data
         :param maxlen: maximum length (0 means parse to the end)
         :returns: list of labels (string)
      """
      if not s:
         return []

      res = []
      slen = len(s)
      if maxlen > 0:
         slen = min(slen, maxlen)

      idx = ofs
      while (idx < slen):
         complen = ord(s[idx])
# In python 3.x `str()` converts the string to unicode which is the expected text string type
         res.append(str(s[idx+1:idx+1+complen].decode()))
         idx += complen + 1

      return res

   def as_raw_data(self):
      """Returns a list of RAW strings"""
      return self.data

   raw = property(as_raw_data, doc="Returns RAW data (a list of binary encoded strings). See :meth:`as_raw_data`")

   def as_mx_list(self):
      """Represents data as a list of MX records (query for RR_TYPE_MX)

         :returns: list of tuples (priority, dname)
      """
      return [(256*ord(rdf[0])+ord(rdf[1]),'.'.join([a for a in self.dname2str(rdf,2)])) for rdf in self.data]

   mx_list = property(as_mx_list, doc="Returns a list of tuples containing priority and domain names. See :meth:`as_mx_list`")

   def as_idn_mx_list(self):
      """Represents data as a list of MX records (query for RR_TYPE_MX)

         :returns: list of tuples (priority, unicode dname)
      """
      return [(256*ord(rdf[0])+ord(rdf[1]),'.'.join([encodings.idna.ToUnicode(a) for a in self.dname2str(rdf,2)])) for rdf in self.data]

   mx_list_idn = property(as_idn_mx_list, doc="Returns a list of tuples containing priority and IDN domain names. See :meth:`as_idn_mx_list`")

   def as_address_list(self):
      """Represents data as a list of IP addresses (query for RR_TYPE_PTR)

         :returns: list of strings
      """
      return ['.'.join(map(lambda x:str(ord(x)),a)) for a in self.data]

   address_list = property(as_address_list, doc="Returns a list of IP addresses. See :meth:`as_address_list`")

   def as_domain_list(self):
      """Represents data as a list of domain names (query for RR_TYPE_A)

         :returns: list of strings
      """
      return map(lambda x:'.'.join(self.dname2str(x)), self.data)

   domain_list = property(as_domain_list, doc="Returns a list of domain names. See :meth:`as_domain_list`")

   def as_idn_domain_list(self):
      """Represents data as a list of unicode domain names (query for RR_TYPE_A)

         :returns: list of strings
      """
      return map(lambda x: '.'.join([encodings.idna.ToUnicode(a) for a in self.dname2str(x)]), self.data)

   domain_list_idn = property(as_idn_domain_list, doc="Returns a list of IDN domain names. See :meth:`as_idn_domain_list`")

class ub_result(object):
    r"""The validation and resolution results."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    qname = property(_unbound.ub_result_qname_get, _unbound.ub_result_qname_set)
    qtype = property(_unbound.ub_result_qtype_get, _unbound.ub_result_qtype_set)
    qclass = property(_unbound.ub_result_qclass_get, _unbound.ub_result_qclass_set)
    _data = property(_unbound.ub_result__data_get, _unbound.ub_result__data_set)
    len = property(_unbound.ub_result_len_get, _unbound.ub_result_len_set)
    canonname = property(_unbound.ub_result_canonname_get, _unbound.ub_result_canonname_set)
    rcode = property(_unbound.ub_result_rcode_get, _unbound.ub_result_rcode_set)
    answer_packet = property(_unbound.ub_result_answer_packet_get, _unbound.ub_result_answer_packet_set)
    answer_len = property(_unbound.ub_result_answer_len_get, _unbound.ub_result_answer_len_set)
    havedata = property(_unbound.ub_result_havedata_get, _unbound.ub_result_havedata_set)
    nxdomain = property(_unbound.ub_result_nxdomain_get, _unbound.ub_result_nxdomain_set)
    secure = property(_unbound.ub_result_secure_get, _unbound.ub_result_secure_set)
    bogus = property(_unbound.ub_result_bogus_get, _unbound.ub_result_bogus_set)
    why_bogus = property(_unbound.ub_result_why_bogus_get, _unbound.ub_result_why_bogus_set)
    was_ratelimited = property(_unbound.ub_result_was_ratelimited_get, _unbound.ub_result_was_ratelimited_set)
    ttl = property(_unbound.ub_result_ttl_get, _unbound.ub_result_ttl_set)

    def _ub_result_data(self, result):
        return _unbound.ub_result__ub_result_data(self, result)

    def _packet(self):
        return _unbound.ub_result__packet(self)

    def __init__(self):
        raise Exception("This class can't be created directly.")

    #__swig_destroy__ = _unbound.ub_resolve_free_dbg
    __swig_destroy__ = _unbound._ub_resolve_free

    #havedata = property(_unbound.ub_result_havedata_get, _unbound.ub_result_havedata_set, "Havedata property")

    rcode2str = {RCODE_NOERROR:'no error', RCODE_FORMERR:'form error', RCODE_SERVFAIL:'serv fail', RCODE_NXDOMAIN:'nx domain', RCODE_NOTIMPL:'not implemented', RCODE_REFUSED:'refused', RCODE_YXDOMAIN:'yxdomain', RCODE_YXRRSET:'yxrrset', RCODE_NXRRSET:'nxrrset', RCODE_NOTAUTH:'not auth', RCODE_NOTZONE:'not zone'}

    def _get_rcode_str(self):
        """Returns rcode in display representation form

           :returns: string
        """
        return self.rcode2str[self.rcode]

    rcode_str = property(_get_rcode_str)

    def _get_raw_data(self):
        """Result data, a list of network order DNS rdata items. 

           Data are represented as a list of strings. To decode RAW data to the list of IP addresses use :attr:`data` attribute which returns an :class:`ub_data` instance containing conversion function.
        """
        return self._ub_result_data(self)

    rawdata = property(_get_raw_data, doc="Returns raw data, a list of rdata items. To decode RAW data use the :attr:`data` attribute which returns an instance of :class:`ub_data` containing the conversion functions.")

    def _get_data(self):
        if not self.havedata: return None
        return ub_data(self._ub_result_data(self))

    packet = property(_packet)
    data = property(_get_data, doc="Returns :class:`ub_data` instance containing various decoding functions or None")



# Register ub_result in _unbound:
_unbound.ub_result_swigregister(ub_result)

UB_NOERROR = _unbound.UB_NOERROR
UB_SOCKET = _unbound.UB_SOCKET
UB_NOMEM = _unbound.UB_NOMEM
UB_SYNTAX = _unbound.UB_SYNTAX
UB_SERVFAIL = _unbound.UB_SERVFAIL
UB_FORKFAIL = _unbound.UB_FORKFAIL
UB_AFTERFINAL = _unbound.UB_AFTERFINAL
UB_INITFAIL = _unbound.UB_INITFAIL
UB_PIPE = _unbound.UB_PIPE
UB_READFILE = _unbound.UB_READFILE
UB_NOID = _unbound.UB_NOID

def ub_ctx_create():
    return _unbound.ub_ctx_create()

def _ub_ctx_delete(ctx):
    return _unbound._ub_ctx_delete(ctx)

def ub_ctx_set_option(ctx, opt, val):
    return _unbound.ub_ctx_set_option(ctx, opt, val)

def ub_ctx_get_option(ctx, opt, str):
    return _unbound.ub_ctx_get_option(ctx, opt, str)

def ub_ctx_config(ctx, fname):
    return _unbound.ub_ctx_config(ctx, fname)

def ub_ctx_set_fwd(ctx, addr):
    return _unbound.ub_ctx_set_fwd(ctx, addr)

def ub_ctx_set_tls(ctx, tls):
    return _unbound.ub_ctx_set_tls(ctx, tls)

def ub_ctx_set_stub(ctx, zone, addr, isprime):
    return _unbound.ub_ctx_set_stub(ctx, zone, addr, isprime)

def ub_ctx_resolvconf(ctx, fname):
    return _unbound.ub_ctx_resolvconf(ctx, fname)

def ub_ctx_hosts(ctx, fname):
    return _unbound.ub_ctx_hosts(ctx, fname)

def ub_ctx_add_ta(ctx, ta):
    return _unbound.ub_ctx_add_ta(ctx, ta)

def ub_ctx_add_ta_file(ctx, fname):
    return _unbound.ub_ctx_add_ta_file(ctx, fname)

def ub_ctx_add_ta_autr(ctx, fname):
    return _unbound.ub_ctx_add_ta_autr(ctx, fname)

def ub_ctx_trustedkeys(ctx, fname):
    return _unbound.ub_ctx_trustedkeys(ctx, fname)

def ub_ctx_debuglevel(ctx, d):
    return _unbound.ub_ctx_debuglevel(ctx, d)

def ub_ctx_async(ctx, dothread):
    return _unbound.ub_ctx_async(ctx, dothread)

def ub_poll(ctx):
    return _unbound.ub_poll(ctx)

def ub_wait(ctx):
    return _unbound.ub_wait(ctx)

def ub_fd(ctx):
    return _unbound.ub_fd(ctx)

def ub_process(ctx):
    return _unbound.ub_process(ctx)

def ub_resolve(ctx, name, rrtype, rrclass):
    return _unbound.ub_resolve(ctx, name, rrtype, rrclass)

def ub_resolve_async(ctx, name, rrtype, rrclass, mydata, callback, async_id):
    return _unbound.ub_resolve_async(ctx, name, rrtype, rrclass, mydata, callback, async_id)

def ub_cancel(ctx, async_id):
    return _unbound.ub_cancel(ctx, async_id)

def _ub_resolve_free(result):
    return _unbound._ub_resolve_free(result)

def ub_strerror(err):
    return _unbound.ub_strerror(err)

def ub_ctx_print_local_zones(ctx):
    return _unbound.ub_ctx_print_local_zones(ctx)

def ub_ctx_zone_add(ctx, zone_name, zone_type):
    return _unbound.ub_ctx_zone_add(ctx, zone_name, zone_type)

def ub_ctx_zone_remove(ctx, zone_name):
    return _unbound.ub_ctx_zone_remove(ctx, zone_name)

def ub_ctx_data_add(ctx, data):
    return _unbound.ub_ctx_data_add(ctx, data)

def ub_ctx_data_remove(ctx, data):
    return _unbound.ub_ctx_data_remove(ctx, data)

def ub_version():
    return _unbound.ub_version()
class ub_shm_stat_info(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    num_threads = property(_unbound.ub_shm_stat_info_num_threads_get, _unbound.ub_shm_stat_info_num_threads_set)
    time = property(_unbound.ub_shm_stat_info_time_get)
    mem = property(_unbound.ub_shm_stat_info_mem_get)

    def __init__(self):
        _unbound.ub_shm_stat_info_swiginit(self, _unbound.new_ub_shm_stat_info())
    __swig_destroy__ = _unbound.delete_ub_shm_stat_info

# Register ub_shm_stat_info in _unbound:
_unbound.ub_shm_stat_info_swigregister(ub_shm_stat_info)

class ub_shm_stat_info_mem(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    msg = property(_unbound.ub_shm_stat_info_mem_msg_get, _unbound.ub_shm_stat_info_mem_msg_set)
    rrset = property(_unbound.ub_shm_stat_info_mem_rrset_get, _unbound.ub_shm_stat_info_mem_rrset_set)
    val = property(_unbound.ub_shm_stat_info_mem_val_get, _unbound.ub_shm_stat_info_mem_val_set)
    iter = property(_unbound.ub_shm_stat_info_mem_iter_get, _unbound.ub_shm_stat_info_mem_iter_set)
    subnet = property(_unbound.ub_shm_stat_info_mem_subnet_get, _unbound.ub_shm_stat_info_mem_subnet_set)
    ipsecmod = property(_unbound.ub_shm_stat_info_mem_ipsecmod_get, _unbound.ub_shm_stat_info_mem_ipsecmod_set)
    respip = property(_unbound.ub_shm_stat_info_mem_respip_get, _unbound.ub_shm_stat_info_mem_respip_set)
    dnscrypt_shared_secret = property(_unbound.ub_shm_stat_info_mem_dnscrypt_shared_secret_get, _unbound.ub_shm_stat_info_mem_dnscrypt_shared_secret_set)
    dnscrypt_nonce = property(_unbound.ub_shm_stat_info_mem_dnscrypt_nonce_get, _unbound.ub_shm_stat_info_mem_dnscrypt_nonce_set)
    dynlib = property(_unbound.ub_shm_stat_info_mem_dynlib_get, _unbound.ub_shm_stat_info_mem_dynlib_set)

    def __init__(self):
        _unbound.ub_shm_stat_info_mem_swiginit(self, _unbound.new_ub_shm_stat_info_mem())
    __swig_destroy__ = _unbound.delete_ub_shm_stat_info_mem

# Register ub_shm_stat_info_mem in _unbound:
_unbound.ub_shm_stat_info_mem_swigregister(ub_shm_stat_info_mem)

class ub_shm_stat_info_time(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    now_sec = property(_unbound.ub_shm_stat_info_time_now_sec_get, _unbound.ub_shm_stat_info_time_now_sec_set)
    now_usec = property(_unbound.ub_shm_stat_info_time_now_usec_get, _unbound.ub_shm_stat_info_time_now_usec_set)
    up_sec = property(_unbound.ub_shm_stat_info_time_up_sec_get, _unbound.ub_shm_stat_info_time_up_sec_set)
    up_usec = property(_unbound.ub_shm_stat_info_time_up_usec_get, _unbound.ub_shm_stat_info_time_up_usec_set)
    elapsed_sec = property(_unbound.ub_shm_stat_info_time_elapsed_sec_get, _unbound.ub_shm_stat_info_time_elapsed_sec_set)
    elapsed_usec = property(_unbound.ub_shm_stat_info_time_elapsed_usec_get, _unbound.ub_shm_stat_info_time_elapsed_usec_set)

    def __init__(self):
        _unbound.ub_shm_stat_info_time_swiginit(self, _unbound.new_ub_shm_stat_info_time())
    __swig_destroy__ = _unbound.delete_ub_shm_stat_info_time

# Register ub_shm_stat_info_time in _unbound:
_unbound.ub_shm_stat_info_time_swigregister(ub_shm_stat_info_time)

UB_STATS_QTYPE_NUM = _unbound.UB_STATS_QTYPE_NUM
UB_STATS_QCLASS_NUM = _unbound.UB_STATS_QCLASS_NUM
UB_STATS_RCODE_NUM = _unbound.UB_STATS_RCODE_NUM
UB_STATS_OPCODE_NUM = _unbound.UB_STATS_OPCODE_NUM
UB_STATS_BUCKET_NUM = _unbound.UB_STATS_BUCKET_NUM
UB_STATS_RPZ_ACTION_NUM = _unbound.UB_STATS_RPZ_ACTION_NUM
class ub_server_stats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    num_queries = property(_unbound.ub_server_stats_num_queries_get, _unbound.ub_server_stats_num_queries_set)
    num_queries_ip_ratelimited = property(_unbound.ub_server_stats_num_queries_ip_ratelimited_get, _unbound.ub_server_stats_num_queries_ip_ratelimited_set)
    num_queries_missed_cache = property(_unbound.ub_server_stats_num_queries_missed_cache_get, _unbound.ub_server_stats_num_queries_missed_cache_set)
    num_queries_prefetch = property(_unbound.ub_server_stats_num_queries_prefetch_get, _unbound.ub_server_stats_num_queries_prefetch_set)
    sum_query_list_size = property(_unbound.ub_server_stats_sum_query_list_size_get, _unbound.ub_server_stats_sum_query_list_size_set)
    max_query_list_size = property(_unbound.ub_server_stats_max_query_list_size_get, _unbound.ub_server_stats_max_query_list_size_set)
    extended = property(_unbound.ub_server_stats_extended_get, _unbound.ub_server_stats_extended_set)
    qtype = property(_unbound.ub_server_stats_qtype_get, _unbound.ub_server_stats_qtype_set)
    qtype_big = property(_unbound.ub_server_stats_qtype_big_get, _unbound.ub_server_stats_qtype_big_set)
    qclass = property(_unbound.ub_server_stats_qclass_get, _unbound.ub_server_stats_qclass_set)
    qclass_big = property(_unbound.ub_server_stats_qclass_big_get, _unbound.ub_server_stats_qclass_big_set)
    qopcode = property(_unbound.ub_server_stats_qopcode_get, _unbound.ub_server_stats_qopcode_set)
    qtcp = property(_unbound.ub_server_stats_qtcp_get, _unbound.ub_server_stats_qtcp_set)
    qtcp_outgoing = property(_unbound.ub_server_stats_qtcp_outgoing_get, _unbound.ub_server_stats_qtcp_outgoing_set)
    qudp_outgoing = property(_unbound.ub_server_stats_qudp_outgoing_get, _unbound.ub_server_stats_qudp_outgoing_set)
    qtls = property(_unbound.ub_server_stats_qtls_get, _unbound.ub_server_stats_qtls_set)
    qhttps = property(_unbound.ub_server_stats_qhttps_get, _unbound.ub_server_stats_qhttps_set)
    qipv6 = property(_unbound.ub_server_stats_qipv6_get, _unbound.ub_server_stats_qipv6_set)
    qbit_QR = property(_unbound.ub_server_stats_qbit_QR_get, _unbound.ub_server_stats_qbit_QR_set)
    qbit_AA = property(_unbound.ub_server_stats_qbit_AA_get, _unbound.ub_server_stats_qbit_AA_set)
    qbit_TC = property(_unbound.ub_server_stats_qbit_TC_get, _unbound.ub_server_stats_qbit_TC_set)
    qbit_RD = property(_unbound.ub_server_stats_qbit_RD_get, _unbound.ub_server_stats_qbit_RD_set)
    qbit_RA = property(_unbound.ub_server_stats_qbit_RA_get, _unbound.ub_server_stats_qbit_RA_set)
    qbit_Z = property(_unbound.ub_server_stats_qbit_Z_get, _unbound.ub_server_stats_qbit_Z_set)
    qbit_AD = property(_unbound.ub_server_stats_qbit_AD_get, _unbound.ub_server_stats_qbit_AD_set)
    qbit_CD = property(_unbound.ub_server_stats_qbit_CD_get, _unbound.ub_server_stats_qbit_CD_set)
    qEDNS = property(_unbound.ub_server_stats_qEDNS_get, _unbound.ub_server_stats_qEDNS_set)
    qEDNS_DO = property(_unbound.ub_server_stats_qEDNS_DO_get, _unbound.ub_server_stats_qEDNS_DO_set)
    ans_rcode = property(_unbound.ub_server_stats_ans_rcode_get, _unbound.ub_server_stats_ans_rcode_set)
    ans_rcode_nodata = property(_unbound.ub_server_stats_ans_rcode_nodata_get, _unbound.ub_server_stats_ans_rcode_nodata_set)
    ans_secure = property(_unbound.ub_server_stats_ans_secure_get, _unbound.ub_server_stats_ans_secure_set)
    ans_bogus = property(_unbound.ub_server_stats_ans_bogus_get, _unbound.ub_server_stats_ans_bogus_set)
    rrset_bogus = property(_unbound.ub_server_stats_rrset_bogus_get, _unbound.ub_server_stats_rrset_bogus_set)
    queries_ratelimited = property(_unbound.ub_server_stats_queries_ratelimited_get, _unbound.ub_server_stats_queries_ratelimited_set)
    unwanted_replies = property(_unbound.ub_server_stats_unwanted_replies_get, _unbound.ub_server_stats_unwanted_replies_set)
    unwanted_queries = property(_unbound.ub_server_stats_unwanted_queries_get, _unbound.ub_server_stats_unwanted_queries_set)
    tcp_accept_usage = property(_unbound.ub_server_stats_tcp_accept_usage_get, _unbound.ub_server_stats_tcp_accept_usage_set)
    ans_expired = property(_unbound.ub_server_stats_ans_expired_get, _unbound.ub_server_stats_ans_expired_set)
    hist = property(_unbound.ub_server_stats_hist_get, _unbound.ub_server_stats_hist_set)
    msg_cache_count = property(_unbound.ub_server_stats_msg_cache_count_get, _unbound.ub_server_stats_msg_cache_count_set)
    rrset_cache_count = property(_unbound.ub_server_stats_rrset_cache_count_get, _unbound.ub_server_stats_rrset_cache_count_set)
    infra_cache_count = property(_unbound.ub_server_stats_infra_cache_count_get, _unbound.ub_server_stats_infra_cache_count_set)
    key_cache_count = property(_unbound.ub_server_stats_key_cache_count_get, _unbound.ub_server_stats_key_cache_count_set)
    num_query_dnscrypt_crypted = property(_unbound.ub_server_stats_num_query_dnscrypt_crypted_get, _unbound.ub_server_stats_num_query_dnscrypt_crypted_set)
    num_query_dnscrypt_cert = property(_unbound.ub_server_stats_num_query_dnscrypt_cert_get, _unbound.ub_server_stats_num_query_dnscrypt_cert_set)
    num_query_dnscrypt_cleartext = property(_unbound.ub_server_stats_num_query_dnscrypt_cleartext_get, _unbound.ub_server_stats_num_query_dnscrypt_cleartext_set)
    num_query_dnscrypt_crypted_malformed = property(_unbound.ub_server_stats_num_query_dnscrypt_crypted_malformed_get, _unbound.ub_server_stats_num_query_dnscrypt_crypted_malformed_set)
    num_query_dnscrypt_secret_missed_cache = property(_unbound.ub_server_stats_num_query_dnscrypt_secret_missed_cache_get, _unbound.ub_server_stats_num_query_dnscrypt_secret_missed_cache_set)
    shared_secret_cache_count = property(_unbound.ub_server_stats_shared_secret_cache_count_get, _unbound.ub_server_stats_shared_secret_cache_count_set)
    num_query_dnscrypt_replay = property(_unbound.ub_server_stats_num_query_dnscrypt_replay_get, _unbound.ub_server_stats_num_query_dnscrypt_replay_set)
    nonce_cache_count = property(_unbound.ub_server_stats_nonce_cache_count_get, _unbound.ub_server_stats_nonce_cache_count_set)
    num_query_authzone_up = property(_unbound.ub_server_stats_num_query_authzone_up_get, _unbound.ub_server_stats_num_query_authzone_up_set)
    num_query_authzone_down = property(_unbound.ub_server_stats_num_query_authzone_down_get, _unbound.ub_server_stats_num_query_authzone_down_set)
    num_neg_cache_noerror = property(_unbound.ub_server_stats_num_neg_cache_noerror_get, _unbound.ub_server_stats_num_neg_cache_noerror_set)
    num_neg_cache_nxdomain = property(_unbound.ub_server_stats_num_neg_cache_nxdomain_get, _unbound.ub_server_stats_num_neg_cache_nxdomain_set)
    num_query_subnet = property(_unbound.ub_server_stats_num_query_subnet_get, _unbound.ub_server_stats_num_query_subnet_set)
    num_query_subnet_cache = property(_unbound.ub_server_stats_num_query_subnet_cache_get, _unbound.ub_server_stats_num_query_subnet_cache_set)
    mem_stream_wait = property(_unbound.ub_server_stats_mem_stream_wait_get, _unbound.ub_server_stats_mem_stream_wait_set)
    mem_http2_query_buffer = property(_unbound.ub_server_stats_mem_http2_query_buffer_get, _unbound.ub_server_stats_mem_http2_query_buffer_set)
    mem_http2_response_buffer = property(_unbound.ub_server_stats_mem_http2_response_buffer_get, _unbound.ub_server_stats_mem_http2_response_buffer_set)
    qtls_resume = property(_unbound.ub_server_stats_qtls_resume_get, _unbound.ub_server_stats_qtls_resume_set)
    rpz_action = property(_unbound.ub_server_stats_rpz_action_get, _unbound.ub_server_stats_rpz_action_set)

    def __init__(self):
        _unbound.ub_server_stats_swiginit(self, _unbound.new_ub_server_stats())
    __swig_destroy__ = _unbound.delete_ub_server_stats

# Register ub_server_stats in _unbound:
_unbound.ub_server_stats_swigregister(ub_server_stats)

class ub_stats_info(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    svr = property(_unbound.ub_stats_info_svr_get, _unbound.ub_stats_info_svr_set)
    mesh_num_states = property(_unbound.ub_stats_info_mesh_num_states_get, _unbound.ub_stats_info_mesh_num_states_set)
    mesh_num_reply_states = property(_unbound.ub_stats_info_mesh_num_reply_states_get, _unbound.ub_stats_info_mesh_num_reply_states_set)
    mesh_jostled = property(_unbound.ub_stats_info_mesh_jostled_get, _unbound.ub_stats_info_mesh_jostled_set)
    mesh_dropped = property(_unbound.ub_stats_info_mesh_dropped_get, _unbound.ub_stats_info_mesh_dropped_set)
    mesh_replies_sent = property(_unbound.ub_stats_info_mesh_replies_sent_get, _unbound.ub_stats_info_mesh_replies_sent_set)
    mesh_replies_sum_wait_sec = property(_unbound.ub_stats_info_mesh_replies_sum_wait_sec_get, _unbound.ub_stats_info_mesh_replies_sum_wait_sec_set)
    mesh_replies_sum_wait_usec = property(_unbound.ub_stats_info_mesh_replies_sum_wait_usec_get, _unbound.ub_stats_info_mesh_replies_sum_wait_usec_set)
    mesh_time_median = property(_unbound.ub_stats_info_mesh_time_median_get, _unbound.ub_stats_info_mesh_time_median_set)

    def __init__(self):
        _unbound.ub_stats_info_swiginit(self, _unbound.new_ub_stats_info())
    __swig_destroy__ = _unbound.delete_ub_stats_info

# Register ub_stats_info in _unbound:
_unbound.ub_stats_info_swigregister(ub_stats_info)

class ub_ctx(object):
    r"""
    Unbound resolving and validation context. 

    The validation context is created to hold the resolver status, validation keys and a small cache (containing messages, rrsets, roundtrip times, trusted keys, lameness information).

    **Usage**

    >>> import unbound
    >>> ctx = unbound.ub_ctx()
    >>> ctx.resolvconf("/etc/resolv.conf")
    >>> status, result = ctx.resolve("www.google.com", unbound.RR_TYPE_A, unbound.RR_CLASS_IN)
    >>> if status==0 and result.havedata:
    >>>    print "Result:",result.data.address_list
    Result: ['74.125.43.147', '74.125.43.99', '74.125.43.103', '74.125.43.104']

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def __init__(self):
        """Creates a resolving and validation context.

           An exception is invoked if the process of creation an ub_ctx instance fails.
        """
        self.this = _unbound.ub_ctx_create()
        if not self.this:
            raise Exception("Fatal error: unbound context initialization failed")

    #__swig_destroy__ = _unbound.ub_ctx_free_dbg
    __swig_destroy__ = _unbound._ub_ctx_delete

    #UB_CTX_METHODS_#   
    def add_ta(self,ta):
        """Add a trust anchor to the given context.

           The trust anchor is a string, on one line, that holds a valid DNSKEY or DS RR.

           :param ta:
               string, with zone-format RR on one line. [domainname] [TTL optional] [type] [class optional] [rdata contents]
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_add_ta(self,ta)
    #parameters: struct ub_ctx *,char *,
    #retvals: int

    def add_ta_file(self,fname):
        """Add trust anchors to the given context.

           Pass name of a file with DS and DNSKEY records (like from dig or drill).

           :param fname:
               filename of file with keyfile with trust anchors.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_add_ta_file(self,fname)
    #parameters: struct ub_ctx *,char *,
    #retvals: int

    def config(self,fname):
        """setup configuration for the given context.

           :param fname:
               unbound config file (not all settings applicable). This is a power-users interface that lets you specify all sorts of options. For some specific options, such as adding trust anchors, special routines exist.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_config(self,fname)
    #parameters: struct ub_ctx *,char *,
    #retvals: int

    def debuglevel(self,d):
        """Set debug verbosity for the context Output is directed to stderr.

           :param d:
               debug level, 0 is off, 1 is very minimal, 2 is detailed, and 3 is lots.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_debuglevel(self,d)
    #parameters: struct ub_ctx *,int,
    #retvals: int

    def debugout(self,out):
        """Set debug output (and error output) to the specified stream.

           Pass None to disable. Default is stderr.

           :param out:
               File stream to log to.
           :returns: (int) 0 if OK, else error.

           **Usage:**

              In order to log into file, use

              ::

                ctx = unbound.ub_ctx()
                fw = fopen("debug.log")
                ctx.debuglevel(3)
                ctx.debugout(fw)

              Another option is to print the debug information to stderr output

              ::

                ctx = unbound.ub_ctx()
                ctx.debuglevel(10)
                ctx.debugout(sys.stderr) 
        """
        return _unbound.ub_ctx_debugout(self,out)
    #parameters: struct ub_ctx *,void *,
    #retvals: int

    def hosts(self,fname="/etc/hosts"):
        """Read list of hosts from the filename given.

           Usually "/etc/hosts". These addresses are not flagged as DNSSEC secure when queried for.

           :param fname:
               file name string. If None "/etc/hosts" is used.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_hosts(self,fname)
    #parameters: struct ub_ctx *,char *,
    #retvals: int

    def print_local_zones(self):
        """Print the local zones and their content (RR data) to the debug output.

           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_print_local_zones(self)
    #parameters: struct ub_ctx *,
    #retvals: int

    def resolvconf(self,fname="/etc/resolv.conf"):
        """Read list of nameservers to use from the filename given.

           Usually "/etc/resolv.conf". Uses those nameservers as caching proxies. If they do not support DNSSEC, validation may fail.

           Only nameservers are picked up, the searchdomain, ndots and other settings from resolv.conf(5) are ignored.

           :param fname:
               file name string. If None "/etc/resolv.conf" is used.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_resolvconf(self,fname)
    #parameters: struct ub_ctx *,char *,
    #retvals: int

    def set_async(self,dothread):
        """Set a context behaviour for asynchronous action.

           :param dothread:
               if True, enables threading and a call to :meth:`resolve_async` creates a thread to handle work in the background. 
               If False, a process is forked to handle work in the background. 
               Changes to this setting after :meth:`async` calls have been made have no effect (delete and re-create the context to change).
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_async(self,dothread)
    #parameters: struct ub_ctx *,int,
    #retvals: int

    def set_fwd(self,addr):
        """Set machine to forward DNS queries to, the caching resolver to use.

           IP4 or IP6 address. Forwards all DNS requests to that machine, which is expected to run a recursive resolver. If the  is not DNSSEC-capable, validation may fail. Can be called several times, in that case the addresses are used as backup servers.

           To read the list of nameservers from /etc/resolv.conf (from DHCP or so), use the call :meth:`resolvconf`.

           :param addr:
               address, IP4 or IP6 in string format. If the addr is None, forwarding is disabled.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_set_fwd(self,addr)
    #parameters: struct ub_ctx *,char *,
    #retvals: int

    def set_option(self,opt,val):
        """Set an option for the context.

           Changes to the options after :meth:`resolve`, :meth:`resolve_async`, :meth:`zone_add`, :meth:`zone_remove`, :meth:`data_add` or :meth:`data_remove` have no effect (you have to delete and re-create the context).

           :param opt:
               option name from the unbound.conf config file format. (not all settings applicable). The name includes the trailing ':' for example set_option("logfile:", "mylog.txt"); This is a power-users interface that lets you specify all sorts of options. For some specific options, such as adding trust anchors, special routines exist.
           :param val:
               value of the option.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_set_option(self,opt,val)
    #parameters: struct ub_ctx *,char *,char *,
    #retvals: int

    def trustedkeys(self,fname):
        """Add trust anchors to the given context.

           Pass the name of a bind-style config file with trusted-keys{}.

           :param fname:
               filename of file with bind-style config entries with trust anchors.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_ctx_trustedkeys(self,fname)
    #parameters: struct ub_ctx *,char *,
    #retvals: int
    #_UB_CTX_METHODS#   

    def zone_print(self):
        """Print local zones using debugout"""            
        _unbound.ub_ctx_print_local_zones(self)

    def zone_add(self,zonename,zonetype):
        """Add new local zone

           :param zonename: zone domain name (e.g. myzone.)
           :param zonetype: type of the zone ("static",...) 
           :returns: (int) 0 if OK, else error. 
        """ 
        return _unbound.ub_ctx_zone_add(self,zonename, zonetype)
    #parameters: struct ub_ctx *,char*, char*
    #retvals: int

    def zone_remove(self,zonename):
        """Remove local zone

           If exists, removes local zone with all the RRs.

           :param zonename: zone domain name
           :returns: (int) 0 if OK, else error. 
        """ 
        return _unbound.ub_ctx_zone_remove(self,zonename)
    #parameters: struct ub_ctx *,char*
    #retvals: int

    def data_add(self,rrdata):
        """Add new local RR data

           :param rrdata: string, in zone-format on one line. [domainname] [TTL optional] [type] [class optional] [rdata contents]
           :returns: (int) 0 if OK, else error. 

           **Usage**
              The local data ...

              ::

                >>> ctx = unbound.ub_ctx()
                >>> ctx.zone_add("mydomain.net.","static")
                0
                >>> status = ctx.data_add("test.mydomain.net. IN A 192.168.1.1")
                0
                >>> status, result = ctx.resolve("test.mydomain.net")
                >>> if status==0 and result.havedata:
                >>>    print \"Result:\",result.data.address_list
                Result: ['192.168.1.1']

        """ 
        return _unbound.ub_ctx_data_add(self,rrdata)
    #parameters: struct ub_ctx *,char*
    #retvals: int

    def data_remove(self,rrdata):
        """Remove local RR data

           If exists, remove resource record from local zone

           :param rrdata: string, in zone-format on one line. [domainname] [TTL optional] [type] [class optional] [rdata contents]
           :returns: (int) 0 if OK, else error. 
        """ 
        return _unbound.ub_ctx_data_remove(self,rrdata)
    #parameters: struct ub_ctx *,char*
    #retvals: int

    #UB_METHODS_#
    def cancel(self,async_id):
        """Cancel an async query in progress.

           Its callback will not be called.

           :param async_id:
               which query to cancel.
           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_cancel(self,async_id)
    #parameters: struct ub_ctx *,int,
    #retvals: int

    def get_fd(self):
        """Get file descriptor.

           Wait for it to become readable, at this point answers are returned from the asynchronous validating resolver. Then call the ub_process to continue processing. This routine works immediately after context creation, the fd does not change.

           :returns: (int) -1 on error, or file descriptor to use select(2) with.
        """
        return _unbound.ub_fd(self)
    #parameters: struct ub_ctx *,
    #retvals: int

    def poll(self):
        """Poll a context to see if it has any new results Do not poll in a loop, instead extract the fd below to poll for readiness, and then check, or wait using the wait routine.

           :returns: (int) 0 if nothing to read, or nonzero if a result is available. If nonzero, call ctx_process() to do callbacks.
        """
        return _unbound.ub_poll(self)
    #parameters: struct ub_ctx *,
    #retvals: int

    def process(self):
        """Call this routine to continue processing results from the validating resolver (when the fd becomes readable).

           Will perform necessary callbacks.

           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_process(self)
    #parameters: struct ub_ctx *,
    #retvals: int

    def resolve(self,name,rrtype=RR_TYPE_A,rrclass=RR_CLASS_IN):
        """Perform resolution and validation of the target name. 

           :param name:
               domain name in text format (a string or unicode string). IDN domain name have to be passed as a unicode string.
           :param rrtype:
               type of RR in host order (optional argument). Default value is RR_TYPE_A (A class).
           :param rrclass:
               class of RR in host order (optional argument). Default value is RR_CLASS_IN (for internet).
           :returns: * (int) 0 if OK, else error.
                     * (:class:`ub_result`) the result data is returned in a newly allocated result structure. May be None on return, return value is set to an error in that case (out of memory).
        """
        if isinstance(name, bytes): #probably IDN
            return _unbound.ub_resolve(self,name,rrtype,rrclass)
        else:
            return _unbound.ub_resolve(self,idn2dname(name),rrtype,rrclass)
    #parameters: struct ub_ctx *,char *,int,int,
    #retvals: int,struct ub_result **

    def resolve_async(self,name,mydata,callback,rrtype=RR_TYPE_A,rrclass=RR_CLASS_IN):
        """Perform resolution and validation of the target name.

           Asynchronous, after a while, the callback will be called with your data and the result. 
           If an error happens during processing, your callback will be called with error set to a nonzero value (and result==None).

           :param name:
               domain name in text format (a string or unicode string). IDN domain name have to be passed as a unicode string.
           :param mydata:
               this data is your own data (you can pass arbitrary python object or None) which are passed on to the callback function.
           :param callback:
               call-back function which is called on completion of the resolution. 
           :param rrtype:
               type of RR in host order (optional argument). Default value is RR_TYPE_A (A class).
           :param rrclass:
               class of RR in host order (optional argument). Default value is RR_CLASS_IN (for internet).
           :returns: * (int) 0 if OK, else error.
                     * (int) async_id, an identifier number is returned for the query as it is in progress. It can be used to cancel the query.

           **Call-back function:**
                The call-back function looks as the follows::

                    def call_back(mydata, status, result):
                        pass

                **Parameters:** 
                    * `mydata` - mydata object
                    * `status` - 0 when a result has been found
                    * `result` - the result structure. The result may be None, in that case err is set.

        """
        if isinstance(name, bytes): #probably IDN
            return _unbound._ub_resolve_async(self,name,rrtype,rrclass,mydata,callback)
        else:
            return _unbound._ub_resolve_async(self,idn2dname(name),rrtype,rrclass,mydata,callback)
    #parameters: struct ub_ctx *,char *,int,int,void *,ub_callback_t,
    #retvals: int, int

    def wait(self):
        """Wait for a context to finish with results.

           Calls  after the wait for you. After the wait, there are no more outstanding asynchronous queries.

           :returns: (int) 0 if OK, else error.
        """
        return _unbound.ub_wait(self)
    #parameters: struct ub_ctx *,
    #retvals: int

    #_UB_METHODS#


# Register ub_ctx in _unbound:
_unbound.ub_ctx_swigregister(ub_ctx)


def ub_ctx_debugout(*args):
    return _unbound.ub_ctx_debugout(*args)

def _ub_resolve_async(ctx, name, rrtype, rrclass, mydata, pyfunc):
    return _unbound._ub_resolve_async(ctx, name, rrtype, rrclass, mydata, pyfunc)

ub_resolve_async = _unbound._ub_resolve_async

def reverse(domain):
    """Reverse domain name

       Usable for reverse lookups when the IP address should be reversed
    """
    return '.'.join([a for a in domain.split(".")][::-1])

def idn2dname(idnname):
    """Converts domain name in IDN format to canonic domain name

       :param idnname: (unicode string) IDN name
       :returns: (string) domain name
    """
    return '.'.join([encodings.idna.ToASCII(a) if a else '' for a in idnname.split('.')])

def dname2idn(name):
    """Converts canonic domain name in IDN format to unicode string

        :param name: (string) domain name
        :returns: (unicode string) domain name
    """
    return '.'.join([encodings.idna.ToUnicode(a) for a in name.split('.')])




