// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf9160.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

// +build nrf,nrf9160

// nrf9160 reference description for radio MCU with ARM 32-bit Cortex-M33 Microcontroller
//
//     Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved.
//
//     Redistribution and use in source and binary forms, with or without
//     modification, are permitted provided that the following conditions are met:
//
//     1. Redistributions of source code must retain the above copyright notice, this
//     list of conditions and the following disclaimer.
//
//     2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//
//     3. Neither the name of Nordic Semiconductor ASA nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
//
//     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//     AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//     IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE
//     ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE
//     LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//     CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//     SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//     INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//     CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//     ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//     POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf9160"
	CPU          = "CM33"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// System protection unit
	IRQ_SPU = 3

	// System protection unit
	IRQ_SPU_S = 3

	// Clock management 0 // Power control 0 // Clock management 1 // Power control 1
	IRQ_CLOCK_POWER = 5

	// Clock management 0
	IRQ_CLOCK_NS = 5

	// Power control 0
	IRQ_POWER_NS = 5

	// Clock management 1
	IRQ_CLOCK_S = 5

	// Power control 1
	IRQ_POWER_S = 5

	// Serial Peripheral Interface Master with EasyDMA 0 // SPI Slave 0 // I2C compatible Two-Wire Master Interface with EasyDMA 0 // I2C compatible Two-Wire Slave Interface with EasyDMA 0 // UART with EasyDMA 0 // Serial Peripheral Interface Master with EasyDMA 1 // SPI Slave 1 // I2C compatible Two-Wire Master Interface with EasyDMA 1 // I2C compatible Two-Wire Slave Interface with EasyDMA 1 // UART with EasyDMA 1
	IRQ_UARTE0_SPIM0_SPIS0_TWIM0_TWIS0 = 8

	// Serial Peripheral Interface Master with EasyDMA 0
	IRQ_SPIM0_NS = 8

	// SPI Slave 0
	IRQ_SPIS0_NS = 8

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	IRQ_TWIM0_NS = 8

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	IRQ_TWIS0_NS = 8

	// UART with EasyDMA 0
	IRQ_UARTE0_NS = 8

	// Serial Peripheral Interface Master with EasyDMA 1
	IRQ_SPIM0_S = 8

	// SPI Slave 1
	IRQ_SPIS0_S = 8

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	IRQ_TWIM0_S = 8

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	IRQ_TWIS0_S = 8

	// UART with EasyDMA 1
	IRQ_UARTE0_S = 8

	// Serial Peripheral Interface Master with EasyDMA 2 // SPI Slave 2 // I2C compatible Two-Wire Master Interface with EasyDMA 2 // I2C compatible Two-Wire Slave Interface with EasyDMA 2 // UART with EasyDMA 2 // Serial Peripheral Interface Master with EasyDMA 3 // SPI Slave 3 // I2C compatible Two-Wire Master Interface with EasyDMA 3 // I2C compatible Two-Wire Slave Interface with EasyDMA 3 // UART with EasyDMA 3
	IRQ_UARTE1_SPIM1_SPIS1_TWIM1_TWIS1 = 9

	// Serial Peripheral Interface Master with EasyDMA 2
	IRQ_SPIM1_NS = 9

	// SPI Slave 2
	IRQ_SPIS1_NS = 9

	// I2C compatible Two-Wire Master Interface with EasyDMA 2
	IRQ_TWIM1_NS = 9

	// I2C compatible Two-Wire Slave Interface with EasyDMA 2
	IRQ_TWIS1_NS = 9

	// UART with EasyDMA 2
	IRQ_UARTE1_NS = 9

	// Serial Peripheral Interface Master with EasyDMA 3
	IRQ_SPIM1_S = 9

	// SPI Slave 3
	IRQ_SPIS1_S = 9

	// I2C compatible Two-Wire Master Interface with EasyDMA 3
	IRQ_TWIM1_S = 9

	// I2C compatible Two-Wire Slave Interface with EasyDMA 3
	IRQ_TWIS1_S = 9

	// UART with EasyDMA 3
	IRQ_UARTE1_S = 9

	// Serial Peripheral Interface Master with EasyDMA 4 // SPI Slave 4 // I2C compatible Two-Wire Master Interface with EasyDMA 4 // I2C compatible Two-Wire Slave Interface with EasyDMA 4 // UART with EasyDMA 4 // Serial Peripheral Interface Master with EasyDMA 5 // SPI Slave 5 // I2C compatible Two-Wire Master Interface with EasyDMA 5 // I2C compatible Two-Wire Slave Interface with EasyDMA 5 // UART with EasyDMA 5
	IRQ_UARTE2_SPIM2_SPIS2_TWIM2_TWIS2 = 10

	// Serial Peripheral Interface Master with EasyDMA 4
	IRQ_SPIM2_NS = 10

	// SPI Slave 4
	IRQ_SPIS2_NS = 10

	// I2C compatible Two-Wire Master Interface with EasyDMA 4
	IRQ_TWIM2_NS = 10

	// I2C compatible Two-Wire Slave Interface with EasyDMA 4
	IRQ_TWIS2_NS = 10

	// UART with EasyDMA 4
	IRQ_UARTE2_NS = 10

	// Serial Peripheral Interface Master with EasyDMA 5
	IRQ_SPIM2_S = 10

	// SPI Slave 5
	IRQ_SPIS2_S = 10

	// I2C compatible Two-Wire Master Interface with EasyDMA 5
	IRQ_TWIM2_S = 10

	// I2C compatible Two-Wire Slave Interface with EasyDMA 5
	IRQ_TWIS2_S = 10

	// UART with EasyDMA 5
	IRQ_UARTE2_S = 10

	// Serial Peripheral Interface Master with EasyDMA 6 // SPI Slave 6 // I2C compatible Two-Wire Master Interface with EasyDMA 6 // I2C compatible Two-Wire Slave Interface with EasyDMA 6 // UART with EasyDMA 6 // Serial Peripheral Interface Master with EasyDMA 7 // SPI Slave 7 // I2C compatible Two-Wire Master Interface with EasyDMA 7 // I2C compatible Two-Wire Slave Interface with EasyDMA 7 // UART with EasyDMA 7
	IRQ_UARTE3_SPIM3_SPIS3_TWIM3_TWIS3 = 11

	// Serial Peripheral Interface Master with EasyDMA 6
	IRQ_SPIM3_NS = 11

	// SPI Slave 6
	IRQ_SPIS3_NS = 11

	// I2C compatible Two-Wire Master Interface with EasyDMA 6
	IRQ_TWIM3_NS = 11

	// I2C compatible Two-Wire Slave Interface with EasyDMA 6
	IRQ_TWIS3_NS = 11

	// UART with EasyDMA 6
	IRQ_UARTE3_NS = 11

	// Serial Peripheral Interface Master with EasyDMA 7
	IRQ_SPIM3_S = 11

	// SPI Slave 7
	IRQ_SPIS3_S = 11

	// I2C compatible Two-Wire Master Interface with EasyDMA 7
	IRQ_TWIM3_S = 11

	// I2C compatible Two-Wire Slave Interface with EasyDMA 7
	IRQ_TWIS3_S = 11

	// UART with EasyDMA 7
	IRQ_UARTE3_S = 11

	// GPIO Tasks and Events 0
	IRQ_GPIOTE0 = 13

	// GPIO Tasks and Events 0
	IRQ_GPIOTE0_S = 13

	// Analog to Digital Converter 0 // Analog to Digital Converter 1
	IRQ_SAADC = 14

	// Analog to Digital Converter 0
	IRQ_SAADC_NS = 14

	// Analog to Digital Converter 1
	IRQ_SAADC_S = 14

	// Timer/Counter 0 // Timer/Counter 1
	IRQ_TIMER0 = 15

	// Timer/Counter 0
	IRQ_TIMER0_NS = 15

	// Timer/Counter 1
	IRQ_TIMER0_S = 15

	// Timer/Counter 2 // Timer/Counter 3
	IRQ_TIMER1 = 16

	// Timer/Counter 2
	IRQ_TIMER1_NS = 16

	// Timer/Counter 3
	IRQ_TIMER1_S = 16

	// Timer/Counter 4 // Timer/Counter 5
	IRQ_TIMER2 = 17

	// Timer/Counter 4
	IRQ_TIMER2_NS = 17

	// Timer/Counter 5
	IRQ_TIMER2_S = 17

	// Real-time counter 0 // Real-time counter 1
	IRQ_RTC0 = 20

	// Real-time counter 0
	IRQ_RTC0_NS = 20

	// Real-time counter 1
	IRQ_RTC0_S = 20

	// Real-time counter 2 // Real-time counter 3
	IRQ_RTC1 = 21

	// Real-time counter 2
	IRQ_RTC1_NS = 21

	// Real-time counter 3
	IRQ_RTC1_S = 21

	// Watchdog Timer 0 // Watchdog Timer 1
	IRQ_WDT = 24

	// Watchdog Timer 0
	IRQ_WDT_NS = 24

	// Watchdog Timer 1
	IRQ_WDT_S = 24

	// Event generator unit 0 // Event generator unit 1
	IRQ_EGU0 = 27

	// Event generator unit 0
	IRQ_EGU0_NS = 27

	// Event generator unit 1
	IRQ_EGU0_S = 27

	// Event generator unit 2 // Event generator unit 3
	IRQ_EGU1 = 28

	// Event generator unit 2
	IRQ_EGU1_NS = 28

	// Event generator unit 3
	IRQ_EGU1_S = 28

	// Event generator unit 4 // Event generator unit 5
	IRQ_EGU2 = 29

	// Event generator unit 4
	IRQ_EGU2_NS = 29

	// Event generator unit 5
	IRQ_EGU2_S = 29

	// Event generator unit 6 // Event generator unit 7
	IRQ_EGU3 = 30

	// Event generator unit 6
	IRQ_EGU3_NS = 30

	// Event generator unit 7
	IRQ_EGU3_S = 30

	// Event generator unit 8 // Event generator unit 9
	IRQ_EGU4 = 31

	// Event generator unit 8
	IRQ_EGU4_NS = 31

	// Event generator unit 9
	IRQ_EGU4_S = 31

	// Event generator unit 10 // Event generator unit 11
	IRQ_EGU5 = 32

	// Event generator unit 10
	IRQ_EGU5_NS = 32

	// Event generator unit 11
	IRQ_EGU5_S = 32

	// Pulse width modulation unit 0 // Pulse width modulation unit 1
	IRQ_PWM0 = 33

	// Pulse width modulation unit 0
	IRQ_PWM0_NS = 33

	// Pulse width modulation unit 1
	IRQ_PWM0_S = 33

	// Pulse width modulation unit 2 // Pulse width modulation unit 3
	IRQ_PWM1 = 34

	// Pulse width modulation unit 2
	IRQ_PWM1_NS = 34

	// Pulse width modulation unit 3
	IRQ_PWM1_S = 34

	// Pulse width modulation unit 4 // Pulse width modulation unit 5
	IRQ_PWM2 = 35

	// Pulse width modulation unit 4
	IRQ_PWM2_NS = 35

	// Pulse width modulation unit 5
	IRQ_PWM2_S = 35

	// Pulse width modulation unit 6 // Pulse width modulation unit 7
	IRQ_PWM3 = 36

	// Pulse width modulation unit 6
	IRQ_PWM3_NS = 36

	// Pulse width modulation unit 7
	IRQ_PWM3_S = 36

	// Pulse Density Modulation (Digital Microphone) Interface 0 // Pulse Density Modulation (Digital Microphone) Interface 1
	IRQ_PDM = 38

	// Pulse Density Modulation (Digital Microphone) Interface 0
	IRQ_PDM_NS = 38

	// Pulse Density Modulation (Digital Microphone) Interface 1
	IRQ_PDM_S = 38

	// Inter-IC Sound 0 // Inter-IC Sound 1
	IRQ_I2S = 40

	// Inter-IC Sound 0
	IRQ_I2S_NS = 40

	// Inter-IC Sound 1
	IRQ_I2S_S = 40

	// Inter Processor Communication 0 // Inter Processor Communication 1
	IRQ_IPC = 42

	// Inter Processor Communication 0
	IRQ_IPC_NS = 42

	// Inter Processor Communication 1
	IRQ_IPC_S = 42

	// FPU 0 // FPU 1
	IRQ_FPU = 44

	// FPU 0
	IRQ_FPU_NS = 44

	// FPU 1
	IRQ_FPU_S = 44

	// GPIO Tasks and Events 1
	IRQ_GPIOTE1 = 49

	// GPIO Tasks and Events 1
	IRQ_GPIOTE1_NS = 49

	// Key management unit 0 // Key management unit 1
	IRQ_KMU = 57

	// Key management unit 0
	IRQ_KMU_NS = 57

	// Key management unit 1
	IRQ_KMU_S = 57

	// ARM TrustZone CryptoCell register interface
	IRQ_CRYPTOCELL = 64

	// ARM TrustZone CryptoCell register interface
	IRQ_CRYPTOCELL_S = 64

	// Highest interrupt number on this device.
	IRQ_max = 64
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export SPU_IRQHandler
func interruptSPU() {
	callHandlers(IRQ_SPU)
}

//export CLOCK_POWER_IRQHandler
func interruptCLOCK_POWER() {
	callHandlers(IRQ_CLOCK_POWER)
}

//export UARTE0_SPIM0_SPIS0_TWIM0_TWIS0_IRQHandler
func interruptUARTE0_SPIM0_SPIS0_TWIM0_TWIS0() {
	callHandlers(IRQ_UARTE0_SPIM0_SPIS0_TWIM0_TWIS0)
}

//export UARTE1_SPIM1_SPIS1_TWIM1_TWIS1_IRQHandler
func interruptUARTE1_SPIM1_SPIS1_TWIM1_TWIS1() {
	callHandlers(IRQ_UARTE1_SPIM1_SPIS1_TWIM1_TWIS1)
}

//export UARTE2_SPIM2_SPIS2_TWIM2_TWIS2_IRQHandler
func interruptUARTE2_SPIM2_SPIS2_TWIM2_TWIS2() {
	callHandlers(IRQ_UARTE2_SPIM2_SPIS2_TWIM2_TWIS2)
}

//export UARTE3_SPIM3_SPIS3_TWIM3_TWIS3_IRQHandler
func interruptUARTE3_SPIM3_SPIS3_TWIM3_TWIS3() {
	callHandlers(IRQ_UARTE3_SPIM3_SPIS3_TWIM3_TWIS3)
}

//export GPIOTE0_IRQHandler
func interruptGPIOTE0() {
	callHandlers(IRQ_GPIOTE0)
}

//export SAADC_IRQHandler
func interruptSAADC() {
	callHandlers(IRQ_SAADC)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export RTC0_IRQHandler
func interruptRTC0() {
	callHandlers(IRQ_RTC0)
}

//export RTC1_IRQHandler
func interruptRTC1() {
	callHandlers(IRQ_RTC1)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export EGU0_IRQHandler
func interruptEGU0() {
	callHandlers(IRQ_EGU0)
}

//export EGU1_IRQHandler
func interruptEGU1() {
	callHandlers(IRQ_EGU1)
}

//export EGU2_IRQHandler
func interruptEGU2() {
	callHandlers(IRQ_EGU2)
}

//export EGU3_IRQHandler
func interruptEGU3() {
	callHandlers(IRQ_EGU3)
}

//export EGU4_IRQHandler
func interruptEGU4() {
	callHandlers(IRQ_EGU4)
}

//export EGU5_IRQHandler
func interruptEGU5() {
	callHandlers(IRQ_EGU5)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export PWM2_IRQHandler
func interruptPWM2() {
	callHandlers(IRQ_PWM2)
}

//export PWM3_IRQHandler
func interruptPWM3() {
	callHandlers(IRQ_PWM3)
}

//export PDM_IRQHandler
func interruptPDM() {
	callHandlers(IRQ_PDM)
}

//export I2S_IRQHandler
func interruptI2S() {
	callHandlers(IRQ_I2S)
}

//export IPC_IRQHandler
func interruptIPC() {
	callHandlers(IRQ_IPC)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export GPIOTE1_IRQHandler
func interruptGPIOTE1() {
	callHandlers(IRQ_GPIOTE1)
}

//export KMU_IRQHandler
func interruptKMU() {
	callHandlers(IRQ_KMU)
}

//export CRYPTOCELL_IRQHandler
func interruptCRYPTOCELL() {
	callHandlers(IRQ_CRYPTOCELL)
}

// Peripherals.
var (
	// Factory Information Configuration Registers
	FICR_S = (*FICR_Type)(unsafe.Pointer(uintptr(0xff0000)))

	// User information configuration registers User information configuration registers
	UICR_S = (*UICR_Type)(unsafe.Pointer(uintptr(0xff8000)))

	// Trace and debug control
	TAD_S = (*TAD_Type)(unsafe.Pointer(uintptr(0xe0080000)))

	// System protection unit
	SPU_S = (*SPU_Type)(unsafe.Pointer(uintptr(0x50003000)))

	// Voltage regulators control 0
	REGULATORS_NS = (*REGULATORS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Clock management 0
	CLOCK_NS = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Power control 0
	POWER_NS = (*POWER_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Control access port
	CTRL_AP_PERI_S = (*CTRLAPPERI_Type)(unsafe.Pointer(uintptr(0x50006000)))

	// Serial Peripheral Interface Master with EasyDMA 0
	SPIM0_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// SPI Slave 0
	SPIS0_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	TWIM0_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	TWIS0_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// UART with EasyDMA 0
	UARTE0_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// GPIO Tasks and Events 0
	GPIOTE0_S = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x5000d000)))

	// Analog to Digital Converter 0
	SAADC_NS = (*SAADC_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Timer/Counter 0
	TIMER0_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// Real-time counter 0
	RTC0_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Distributed Programmable Peripheral Interconnect Controller 0
	DPPIC_NS = (*DPPIC_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// Watchdog Timer 0
	WDT_NS = (*WDT_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Event generator unit 0
	EGU0_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001b000)))

	// Pulse width modulation unit 0
	PWM0_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Pulse Density Modulation (Digital Microphone) Interface 0
	PDM_NS = (*PDM_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Inter-IC Sound 0
	I2S_NS = (*I2S_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Inter Processor Communication 0
	IPC_NS = (*IPC_Type)(unsafe.Pointer(uintptr(0x4002a000)))

	// FPU 0
	FPU_NS = (*FPU_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Key management unit 0
	KMU_NS = (*KMU_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// Non-volatile memory controller 0
	NVMC_NS = (*NVMC_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// Volatile Memory controller 0
	VMC_NS = (*VMC_Type)(unsafe.Pointer(uintptr(0x4003a000)))

	// CRYPTOCELL HOST_RGF interface
	CC_HOST_RGF_S = (*CC_HOST_RGF_Type)(unsafe.Pointer(uintptr(0x50840000)))

	// ARM TrustZone CryptoCell register interface
	CRYPTOCELL_S = (*CRYPTOCELL_Type)(unsafe.Pointer(uintptr(0x50840000)))

	// GPIO Port 0
	P0_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40842500)))

	// Voltage regulators control 1
	REGULATORS_S = (*REGULATORS_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// Clock management 1
	CLOCK_S = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x50005000)))

	// Power control 1
	POWER_S = (*POWER_Type)(unsafe.Pointer(uintptr(0x50005000)))

	// Serial Peripheral Interface Master with EasyDMA 1
	SPIM0_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// SPI Slave 1
	SPIS0_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	TWIM0_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	TWIS0_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// UART with EasyDMA 1
	UARTE0_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// Serial Peripheral Interface Master with EasyDMA 2
	SPIM1_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// SPI Slave 2
	SPIS1_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 2
	TWIM1_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 2
	TWIS1_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// UART with EasyDMA 2
	UARTE1_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// Serial Peripheral Interface Master with EasyDMA 3
	SPIM1_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// SPI Slave 3
	SPIS1_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 3
	TWIM1_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 3
	TWIS1_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// UART with EasyDMA 3
	UARTE1_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x50009000)))

	// Serial Peripheral Interface Master with EasyDMA 4
	SPIM2_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// SPI Slave 4
	SPIS2_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 4
	TWIM2_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 4
	TWIS2_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// UART with EasyDMA 4
	UARTE2_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// Serial Peripheral Interface Master with EasyDMA 5
	SPIM2_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x5000a000)))

	// SPI Slave 5
	SPIS2_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x5000a000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 5
	TWIM2_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x5000a000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 5
	TWIS2_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x5000a000)))

	// UART with EasyDMA 5
	UARTE2_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x5000a000)))

	// Serial Peripheral Interface Master with EasyDMA 6
	SPIM3_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// SPI Slave 6
	SPIS3_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 6
	TWIM3_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 6
	TWIS3_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// UART with EasyDMA 6
	UARTE3_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Serial Peripheral Interface Master with EasyDMA 7
	SPIM3_S = (*SPIM_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// SPI Slave 7
	SPIS3_S = (*SPIS_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 7
	TWIM3_S = (*TWIM_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 7
	TWIS3_S = (*TWIS_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// UART with EasyDMA 7
	UARTE3_S = (*UARTE_Type)(unsafe.Pointer(uintptr(0x5000b000)))

	// Analog to Digital Converter 1
	SAADC_S = (*SAADC_Type)(unsafe.Pointer(uintptr(0x5000e000)))

	// Timer/Counter 1
	TIMER0_S = (*TIMER_Type)(unsafe.Pointer(uintptr(0x5000f000)))

	// Timer/Counter 2
	TIMER1_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer/Counter 3
	TIMER1_S = (*TIMER_Type)(unsafe.Pointer(uintptr(0x50010000)))

	// Timer/Counter 4
	TIMER2_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Timer/Counter 5
	TIMER2_S = (*TIMER_Type)(unsafe.Pointer(uintptr(0x50011000)))

	// Real-time counter 1
	RTC0_S = (*RTC_Type)(unsafe.Pointer(uintptr(0x50014000)))

	// Real-time counter 2
	RTC1_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Real-time counter 3
	RTC1_S = (*RTC_Type)(unsafe.Pointer(uintptr(0x50015000)))

	// Distributed Programmable Peripheral Interconnect Controller 1
	DPPIC_S = (*DPPIC_Type)(unsafe.Pointer(uintptr(0x50017000)))

	// Watchdog Timer 1
	WDT_S = (*WDT_Type)(unsafe.Pointer(uintptr(0x50018000)))

	// Event generator unit 1
	EGU0_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001b000)))

	// Event generator unit 2
	EGU1_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Event generator unit 3
	EGU1_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001c000)))

	// Event generator unit 4
	EGU2_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001d000)))

	// Event generator unit 5
	EGU2_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001d000)))

	// Event generator unit 6
	EGU3_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Event generator unit 7
	EGU3_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001e000)))

	// Event generator unit 8
	EGU4_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Event generator unit 9
	EGU4_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x5001f000)))

	// Event generator unit 10
	EGU5_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Event generator unit 11
	EGU5_S = (*EGU_Type)(unsafe.Pointer(uintptr(0x50020000)))

	// Pulse width modulation unit 1
	PWM0_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50021000)))

	// Pulse width modulation unit 2
	PWM1_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Pulse width modulation unit 3
	PWM1_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50022000)))

	// Pulse width modulation unit 4
	PWM2_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Pulse width modulation unit 5
	PWM2_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50023000)))

	// Pulse width modulation unit 6
	PWM3_NS = (*PWM_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Pulse width modulation unit 7
	PWM3_S = (*PWM_Type)(unsafe.Pointer(uintptr(0x50024000)))

	// Pulse Density Modulation (Digital Microphone) Interface 1
	PDM_S = (*PDM_Type)(unsafe.Pointer(uintptr(0x50026000)))

	// Inter-IC Sound 1
	I2S_S = (*I2S_Type)(unsafe.Pointer(uintptr(0x50028000)))

	// Inter Processor Communication 1
	IPC_S = (*IPC_Type)(unsafe.Pointer(uintptr(0x5002a000)))

	// FPU 1
	FPU_S = (*FPU_Type)(unsafe.Pointer(uintptr(0x5002c000)))

	// GPIO Tasks and Events 1
	GPIOTE1_NS = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x40031000)))

	// Key management unit 1
	KMU_S = (*KMU_Type)(unsafe.Pointer(uintptr(0x50039000)))

	// Non-volatile memory controller 1
	NVMC_S = (*NVMC_Type)(unsafe.Pointer(uintptr(0x50039000)))

	// Volatile Memory controller 1
	VMC_S = (*VMC_Type)(unsafe.Pointer(uintptr(0x5003a000)))

	// GPIO Port 1
	P0_S = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50842500)))
)

// Factory Information Configuration Registers
type FICR_Type struct {
	_       [512]byte
	INFO    FICR_INFO_Type // 0x200
	_       [212]byte
	TRIMCNF [256]FICR_TRIMCNF_Type // 0x300
	_       [256]byte
	TRNG90B FICR_TRNG90B_Type // 0xC00
}

type FICR_INFO_Type struct {
	_            [4]byte
	DEVICEID     [2]volatile.Register32 // 0x204
	PART         volatile.Register32    // 0x20C
	VARIANT      volatile.Register32    // 0x210
	PACKAGE      volatile.Register32    // 0x214
	RAM          volatile.Register32    // 0x218
	FLASH        volatile.Register32    // 0x21C
	CODEPAGESIZE volatile.Register32    // 0x220
	CODESIZE     volatile.Register32    // 0x224
	DEVICETYPE   volatile.Register32    // 0x228
}

// FICR_INFO.PART: Part code
func (o *FICR_INFO_Type) SetPART(value uint32) {
	volatile.StoreUint32(&o.PART.Reg, value)
}
func (o *FICR_INFO_Type) GetPART() uint32 {
	return volatile.LoadUint32(&o.PART.Reg)
}

// FICR_INFO.VARIANT: Part Variant, Hardware version and Production configuration
func (o *FICR_INFO_Type) SetVARIANT(value uint32) {
	volatile.StoreUint32(&o.VARIANT.Reg, value)
}
func (o *FICR_INFO_Type) GetVARIANT() uint32 {
	return volatile.LoadUint32(&o.VARIANT.Reg)
}

// FICR_INFO.PACKAGE: Package option
func (o *FICR_INFO_Type) SetPACKAGE(value uint32) {
	volatile.StoreUint32(&o.PACKAGE.Reg, value)
}
func (o *FICR_INFO_Type) GetPACKAGE() uint32 {
	return volatile.LoadUint32(&o.PACKAGE.Reg)
}

// FICR_INFO.RAM: RAM variant
func (o *FICR_INFO_Type) SetRAM(value uint32) {
	volatile.StoreUint32(&o.RAM.Reg, value)
}
func (o *FICR_INFO_Type) GetRAM() uint32 {
	return volatile.LoadUint32(&o.RAM.Reg)
}

// FICR_INFO.FLASH: Flash variant
func (o *FICR_INFO_Type) SetFLASH(value uint32) {
	volatile.StoreUint32(&o.FLASH.Reg, value)
}
func (o *FICR_INFO_Type) GetFLASH() uint32 {
	return volatile.LoadUint32(&o.FLASH.Reg)
}

// FICR_INFO.CODEPAGESIZE: Code memory page size
func (o *FICR_INFO_Type) SetCODEPAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CODEPAGESIZE.Reg, value)
}
func (o *FICR_INFO_Type) GetCODEPAGESIZE() uint32 {
	return volatile.LoadUint32(&o.CODEPAGESIZE.Reg)
}

// FICR_INFO.CODESIZE: Code memory size
func (o *FICR_INFO_Type) SetCODESIZE(value uint32) {
	volatile.StoreUint32(&o.CODESIZE.Reg, value)
}
func (o *FICR_INFO_Type) GetCODESIZE() uint32 {
	return volatile.LoadUint32(&o.CODESIZE.Reg)
}

// FICR_INFO.DEVICETYPE: Device type
func (o *FICR_INFO_Type) SetDEVICETYPE(value uint32) {
	volatile.StoreUint32(&o.DEVICETYPE.Reg, value)
}
func (o *FICR_INFO_Type) GetDEVICETYPE() uint32 {
	return volatile.LoadUint32(&o.DEVICETYPE.Reg)
}

type FICR_TRIMCNF_Type struct {
	ADDR volatile.Register32 // 0x300
	DATA volatile.Register32 // 0x304
}

// FICR_TRIMCNF.ADDR: Description cluster: Address
func (o *FICR_TRIMCNF_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *FICR_TRIMCNF_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// FICR_TRIMCNF.DATA: Description cluster: Data
func (o *FICR_TRIMCNF_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *FICR_TRIMCNF_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

type FICR_TRNG90B_Type struct {
	BYTES    volatile.Register32 // 0xC00
	RCCUTOFF volatile.Register32 // 0xC04
	APCUTOFF volatile.Register32 // 0xC08
	STARTUP  volatile.Register32 // 0xC0C
	ROSC1    volatile.Register32 // 0xC10
	ROSC2    volatile.Register32 // 0xC14
	ROSC3    volatile.Register32 // 0xC18
	ROSC4    volatile.Register32 // 0xC1C
}

// FICR_TRNG90B.BYTES: Amount of bytes for the required entropy bits
func (o *FICR_TRNG90B_Type) SetBYTES(value uint32) {
	volatile.StoreUint32(&o.BYTES.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetBYTES() uint32 {
	return volatile.LoadUint32(&o.BYTES.Reg)
}

// FICR_TRNG90B.RCCUTOFF: Repetition counter cutoff
func (o *FICR_TRNG90B_Type) SetRCCUTOFF(value uint32) {
	volatile.StoreUint32(&o.RCCUTOFF.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetRCCUTOFF() uint32 {
	return volatile.LoadUint32(&o.RCCUTOFF.Reg)
}

// FICR_TRNG90B.APCUTOFF: Adaptive proportion cutoff
func (o *FICR_TRNG90B_Type) SetAPCUTOFF(value uint32) {
	volatile.StoreUint32(&o.APCUTOFF.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetAPCUTOFF() uint32 {
	return volatile.LoadUint32(&o.APCUTOFF.Reg)
}

// FICR_TRNG90B.STARTUP: Amount of bytes for the startup tests
func (o *FICR_TRNG90B_Type) SetSTARTUP(value uint32) {
	volatile.StoreUint32(&o.STARTUP.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetSTARTUP() uint32 {
	return volatile.LoadUint32(&o.STARTUP.Reg)
}

// FICR_TRNG90B.ROSC1: Sample count for ring oscillator 1
func (o *FICR_TRNG90B_Type) SetROSC1(value uint32) {
	volatile.StoreUint32(&o.ROSC1.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC1() uint32 {
	return volatile.LoadUint32(&o.ROSC1.Reg)
}

// FICR_TRNG90B.ROSC2: Sample count for ring oscillator 2
func (o *FICR_TRNG90B_Type) SetROSC2(value uint32) {
	volatile.StoreUint32(&o.ROSC2.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC2() uint32 {
	return volatile.LoadUint32(&o.ROSC2.Reg)
}

// FICR_TRNG90B.ROSC3: Sample count for ring oscillator 3
func (o *FICR_TRNG90B_Type) SetROSC3(value uint32) {
	volatile.StoreUint32(&o.ROSC3.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC3() uint32 {
	return volatile.LoadUint32(&o.ROSC3.Reg)
}

// FICR_TRNG90B.ROSC4: Sample count for ring oscillator 4
func (o *FICR_TRNG90B_Type) SetROSC4(value uint32) {
	volatile.StoreUint32(&o.ROSC4.Reg, value)
}
func (o *FICR_TRNG90B_Type) GetROSC4() uint32 {
	return volatile.LoadUint32(&o.ROSC4.Reg)
}

// User information configuration registers User information configuration registers
type UICR_Type struct {
	APPROTECT       volatile.Register32 // 0x0
	_               [16]byte
	XOSC32M         volatile.Register32 // 0x14
	_               [4]byte
	HFXOSRC         volatile.Register32 // 0x1C
	HFXOCNT         volatile.Register32 // 0x20
	_               [8]byte
	SECUREAPPROTECT volatile.Register32 // 0x2C
	ERASEPROTECT    volatile.Register32 // 0x30
	_               [212]byte
	OTP             [190]volatile.Register32 // 0x108
	KEYSLOT         UICR_KEYSLOT_Type        // 0x400
}

// UICR.APPROTECT: Access port protection
func (o *UICR_Type) SetAPPROTECT(value uint32) {
	volatile.StoreUint32(&o.APPROTECT.Reg, value)
}
func (o *UICR_Type) GetAPPROTECT() uint32 {
	return volatile.LoadUint32(&o.APPROTECT.Reg)
}

// UICR.XOSC32M: Oscillator control
func (o *UICR_Type) SetXOSC32M_CTRL(value uint32) {
	volatile.StoreUint32(&o.XOSC32M.Reg, volatile.LoadUint32(&o.XOSC32M.Reg)&^(0x3f)|value)
}
func (o *UICR_Type) GetXOSC32M_CTRL() uint32 {
	return volatile.LoadUint32(&o.XOSC32M.Reg) & 0x3f
}

// UICR.HFXOSRC: HFXO clock source selection
func (o *UICR_Type) SetHFXOSRC(value uint32) {
	volatile.StoreUint32(&o.HFXOSRC.Reg, volatile.LoadUint32(&o.HFXOSRC.Reg)&^(0x1)|value)
}
func (o *UICR_Type) GetHFXOSRC() uint32 {
	return volatile.LoadUint32(&o.HFXOSRC.Reg) & 0x1
}

// UICR.HFXOCNT: HFXO startup counter
func (o *UICR_Type) SetHFXOCNT(value uint32) {
	volatile.StoreUint32(&o.HFXOCNT.Reg, volatile.LoadUint32(&o.HFXOCNT.Reg)&^(0xff)|value)
}
func (o *UICR_Type) GetHFXOCNT() uint32 {
	return volatile.LoadUint32(&o.HFXOCNT.Reg) & 0xff
}

// UICR.SECUREAPPROTECT: Secure access port protection
func (o *UICR_Type) SetSECUREAPPROTECT(value uint32) {
	volatile.StoreUint32(&o.SECUREAPPROTECT.Reg, value)
}
func (o *UICR_Type) GetSECUREAPPROTECT() uint32 {
	return volatile.LoadUint32(&o.SECUREAPPROTECT.Reg)
}

// UICR.ERASEPROTECT: Erase protection
func (o *UICR_Type) SetERASEPROTECT(value uint32) {
	volatile.StoreUint32(&o.ERASEPROTECT.Reg, value)
}
func (o *UICR_Type) GetERASEPROTECT() uint32 {
	return volatile.LoadUint32(&o.ERASEPROTECT.Reg)
}

// UICR.OTP: Description collection: One time programmable memory
func (o *UICR_Type) SetOTP_LOWER(idx int, value uint32) {
	volatile.StoreUint32(&o.OTP[idx].Reg, volatile.LoadUint32(&o.OTP[idx].Reg)&^(0xffff)|value)
}
func (o *UICR_Type) GetOTP_LOWER(idx int) uint32 {
	return volatile.LoadUint32(&o.OTP[idx].Reg) & 0xffff
}
func (o *UICR_Type) SetOTP_UPPER(idx int, value uint32) {
	volatile.StoreUint32(&o.OTP[idx].Reg, volatile.LoadUint32(&o.OTP[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *UICR_Type) GetOTP_UPPER(idx int) uint32 {
	return (volatile.LoadUint32(&o.OTP[idx].Reg) & 0xffff0000) >> 16
}

// Trace and debug control
type TAD_Type struct {
	CLOCKSTART     volatile.Register32 // 0x0
	CLOCKSTOP      volatile.Register32 // 0x4
	_              [1272]byte
	ENABLE         volatile.Register32 // 0x500
	PSEL           TAD_PSEL_Type       // 0x504
	TRACEPORTSPEED volatile.Register32 // 0x518
}

// TAD.CLOCKSTART: Start all trace and debug clocks.
func (o *TAD_Type) SetCLOCKSTART_START(value uint32) {
	volatile.StoreUint32(&o.CLOCKSTART.Reg, volatile.LoadUint32(&o.CLOCKSTART.Reg)&^(0x1)|value)
}
func (o *TAD_Type) GetCLOCKSTART_START() uint32 {
	return volatile.LoadUint32(&o.CLOCKSTART.Reg) & 0x1
}

// TAD.CLOCKSTOP: Stop all trace and debug clocks.
func (o *TAD_Type) SetCLOCKSTOP_STOP(value uint32) {
	volatile.StoreUint32(&o.CLOCKSTOP.Reg, volatile.LoadUint32(&o.CLOCKSTOP.Reg)&^(0x1)|value)
}
func (o *TAD_Type) GetCLOCKSTOP_STOP() uint32 {
	return volatile.LoadUint32(&o.CLOCKSTOP.Reg) & 0x1
}

// TAD.ENABLE: Enable debug domain and aquire selected GPIOs
func (o *TAD_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *TAD_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// TAD.TRACEPORTSPEED: Clocking options for the Trace Port debug interface
func (o *TAD_Type) SetTRACEPORTSPEED(value uint32) {
	volatile.StoreUint32(&o.TRACEPORTSPEED.Reg, volatile.LoadUint32(&o.TRACEPORTSPEED.Reg)&^(0x3)|value)
}
func (o *TAD_Type) GetTRACEPORTSPEED() uint32 {
	return volatile.LoadUint32(&o.TRACEPORTSPEED.Reg) & 0x3
}

type TAD_PSEL_Type struct {
	TRACECLK   volatile.Register32 // 0x504
	TRACEDATA0 volatile.Register32 // 0x508
	TRACEDATA1 volatile.Register32 // 0x50C
	TRACEDATA2 volatile.Register32 // 0x510
	TRACEDATA3 volatile.Register32 // 0x514
}

// TAD_PSEL.TRACECLK: Pin number configuration for TRACECLK
func (o *TAD_PSEL_Type) SetTRACECLK_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACECLK.Reg, volatile.LoadUint32(&o.TRACECLK.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACECLK_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACECLK.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACECLK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACECLK.Reg, volatile.LoadUint32(&o.TRACECLK.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACECLK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACECLK.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA0: Pin number configuration for TRACEDATA[0]
func (o *TAD_PSEL_Type) SetTRACEDATA0_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA0.Reg, volatile.LoadUint32(&o.TRACEDATA0.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA0_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA0.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA0_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA0.Reg, volatile.LoadUint32(&o.TRACEDATA0.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA0_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA0.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA1: Pin number configuration for TRACEDATA[1]
func (o *TAD_PSEL_Type) SetTRACEDATA1_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA1.Reg, volatile.LoadUint32(&o.TRACEDATA1.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA1_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA1.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA1_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA1.Reg, volatile.LoadUint32(&o.TRACEDATA1.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA1_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA1.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA2: Pin number configuration for TRACEDATA[2]
func (o *TAD_PSEL_Type) SetTRACEDATA2_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA2.Reg, volatile.LoadUint32(&o.TRACEDATA2.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA2_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA2.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA2_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA2.Reg, volatile.LoadUint32(&o.TRACEDATA2.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA2_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA2.Reg) & 0x80000000) >> 31
}

// TAD_PSEL.TRACEDATA3: Pin number configuration for TRACEDATA[3]
func (o *TAD_PSEL_Type) SetTRACEDATA3_PIN(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA3.Reg, volatile.LoadUint32(&o.TRACEDATA3.Reg)&^(0x1f)|value)
}
func (o *TAD_PSEL_Type) GetTRACEDATA3_PIN() uint32 {
	return volatile.LoadUint32(&o.TRACEDATA3.Reg) & 0x1f
}
func (o *TAD_PSEL_Type) SetTRACEDATA3_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TRACEDATA3.Reg, volatile.LoadUint32(&o.TRACEDATA3.Reg)&^(0x80000000)|value<<31)
}
func (o *TAD_PSEL_Type) GetTRACEDATA3_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TRACEDATA3.Reg) & 0x80000000) >> 31
}

// System protection unit
type SPU_Type struct {
	_                    [256]byte
	EVENTS_RAMACCERR     volatile.Register32 // 0x100
	EVENTS_FLASHACCERR   volatile.Register32 // 0x104
	EVENTS_PERIPHACCERR  volatile.Register32 // 0x108
	_                    [116]byte
	PUBLISH_RAMACCERR    volatile.Register32 // 0x180
	PUBLISH_FLASHACCERR  volatile.Register32 // 0x184
	PUBLISH_PERIPHACCERR volatile.Register32 // 0x188
	_                    [372]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [244]byte
	CAP                  volatile.Register32 // 0x400
	_                    [60]byte
	EXTDOMAIN            [1]SPU_EXTDOMAIN_Type // 0x440
	_                    [64]byte
	DPPI                 [1]SPU_DPPI_Type // 0x480
	_                    [60]byte
	GPIOPORT             [1]SPU_GPIOPORT_Type // 0x4C0
	_                    [60]byte
	FLASHNSC             [2]SPU_FLASHNSC_Type // 0x500
	_                    [48]byte
	RAMNSC               [2]SPU_RAMNSC_Type // 0x540
	_                    [176]byte
	FLASHREGION          [32]SPU_FLASHREGION_Type // 0x600
	_                    [128]byte
	RAMREGION            [32]SPU_RAMREGION_Type // 0x700
	_                    [128]byte
	PERIPHID             [67]SPU_PERIPHID_Type // 0x800
}

// SPU.EVENTS_RAMACCERR: A security violation has been detected for the RAM memory space
func (o *SPU_Type) SetEVENTS_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RAMACCERR.Reg, volatile.LoadUint32(&o.EVENTS_RAMACCERR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetEVENTS_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RAMACCERR.Reg) & 0x1
}

// SPU.EVENTS_FLASHACCERR: A security violation has been detected for the flash memory space
func (o *SPU_Type) SetEVENTS_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FLASHACCERR.Reg, volatile.LoadUint32(&o.EVENTS_FLASHACCERR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetEVENTS_FLASHACCERR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FLASHACCERR.Reg) & 0x1
}

// SPU.EVENTS_PERIPHACCERR: A security violation has been detected on one or several peripherals
func (o *SPU_Type) SetEVENTS_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PERIPHACCERR.Reg, volatile.LoadUint32(&o.EVENTS_PERIPHACCERR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetEVENTS_PERIPHACCERR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PERIPHACCERR.Reg) & 0x1
}

// SPU.PUBLISH_RAMACCERR: Publish configuration for event RAMACCERR
func (o *SPU_Type) SetPUBLISH_RAMACCERR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RAMACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg)&^(0xf)|value)
}
func (o *SPU_Type) GetPUBLISH_RAMACCERR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg) & 0xf
}
func (o *SPU_Type) SetPUBLISH_RAMACCERR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RAMACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_Type) GetPUBLISH_RAMACCERR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RAMACCERR.Reg) & 0x80000000) >> 31
}

// SPU.PUBLISH_FLASHACCERR: Publish configuration for event FLASHACCERR
func (o *SPU_Type) SetPUBLISH_FLASHACCERR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FLASHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg)&^(0xf)|value)
}
func (o *SPU_Type) GetPUBLISH_FLASHACCERR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg) & 0xf
}
func (o *SPU_Type) SetPUBLISH_FLASHACCERR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FLASHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_Type) GetPUBLISH_FLASHACCERR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_FLASHACCERR.Reg) & 0x80000000) >> 31
}

// SPU.PUBLISH_PERIPHACCERR: Publish configuration for event PERIPHACCERR
func (o *SPU_Type) SetPUBLISH_PERIPHACCERR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PERIPHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg)&^(0xf)|value)
}
func (o *SPU_Type) GetPUBLISH_PERIPHACCERR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg) & 0xf
}
func (o *SPU_Type) SetPUBLISH_PERIPHACCERR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PERIPHACCERR.Reg, volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_Type) GetPUBLISH_PERIPHACCERR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PERIPHACCERR.Reg) & 0x80000000) >> 31
}

// SPU.INTEN: Enable or disable interrupt
func (o *SPU_Type) SetINTEN_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetINTEN_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *SPU_Type) SetINTEN_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetINTEN_FLASHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetINTEN_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetINTEN_PERIPHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// SPU.INTENSET: Enable interrupt
func (o *SPU_Type) SetINTENSET_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetINTENSET_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SPU_Type) SetINTENSET_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetINTENSET_FLASHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetINTENSET_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetINTENSET_PERIPHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// SPU.INTENCLR: Disable interrupt
func (o *SPU_Type) SetINTENCLR_RAMACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetINTENCLR_RAMACCERR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SPU_Type) SetINTENCLR_FLASHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPU_Type) GetINTENCLR_FLASHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPU_Type) SetINTENCLR_PERIPHACCERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SPU_Type) GetINTENCLR_PERIPHACCERR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// SPU.CAP: Show implemented features for the current device
func (o *SPU_Type) SetCAP_TZM(value uint32) {
	volatile.StoreUint32(&o.CAP.Reg, volatile.LoadUint32(&o.CAP.Reg)&^(0x1)|value)
}
func (o *SPU_Type) GetCAP_TZM() uint32 {
	return volatile.LoadUint32(&o.CAP.Reg) & 0x1
}

type SPU_EXTDOMAIN_Type struct {
	PERM volatile.Register32 // 0x440
}

// SPU_EXTDOMAIN.PERM: Description cluster: Access for bus access generated from the external domain n List capabilities of the external domain n
func (o *SPU_EXTDOMAIN_Type) SetPERM_SECUREMAPPING(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x3)|value)
}
func (o *SPU_EXTDOMAIN_Type) GetPERM_SECUREMAPPING() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x3
}
func (o *SPU_EXTDOMAIN_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_EXTDOMAIN_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_EXTDOMAIN_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_EXTDOMAIN_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}

type SPU_DPPI_Type struct {
	PERM volatile.Register32 // 0x480
	LOCK volatile.Register32 // 0x484
}

// SPU_DPPI.PERM: Description cluster: Select between secure and non-secure attribute for the DPPI channels.
func (o *SPU_DPPI_Type) SetPERM_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL0() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL2(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL2() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL3(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8)|value<<3)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL3() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8) >> 3
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL4(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL4() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL5(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20)|value<<5)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL5() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20) >> 5
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL6(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40)|value<<6)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL6() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40) >> 6
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL7(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80)|value<<7)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL7() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80) >> 7
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL8(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL8() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL9(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200)|value<<9)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL9() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200) >> 9
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL10(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400)|value<<10)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL10() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400) >> 10
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL11(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800)|value<<11)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL11() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800) >> 11
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL12(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000)|value<<12)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL12() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000) >> 12
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL13(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000)|value<<13)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL13() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000) >> 13
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL14(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000)|value<<14)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL14() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000) >> 14
}
func (o *SPU_DPPI_Type) SetPERM_CHANNEL15(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000)|value<<15)
}
func (o *SPU_DPPI_Type) GetPERM_CHANNEL15() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000) >> 15
}

// SPU_DPPI.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
func (o *SPU_DPPI_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *SPU_DPPI_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

type SPU_GPIOPORT_Type struct {
	PERM volatile.Register32 // 0x4C0
	LOCK volatile.Register32 // 0x4C4
}

// SPU_GPIOPORT.PERM: Description cluster: Select between secure and non-secure attribute for pins 0 to 31 of port n.
func (o *SPU_GPIOPORT_Type) SetPERM_PIN0(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN0() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN1(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN1() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN2(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN2() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN3(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8)|value<<3)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN3() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8) >> 3
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN4(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN4() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN5(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20)|value<<5)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN5() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20) >> 5
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN6(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40)|value<<6)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN6() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40) >> 6
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN7(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80)|value<<7)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN7() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80) >> 7
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN8(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN8() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN9(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200)|value<<9)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN9() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200) >> 9
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN10(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400)|value<<10)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN10() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400) >> 10
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN11(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800)|value<<11)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN11() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800) >> 11
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN12(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000)|value<<12)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN12() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000) >> 12
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN13(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000)|value<<13)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN13() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000) >> 13
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN14(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000)|value<<14)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN14() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000) >> 14
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN15(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000)|value<<15)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN15() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000) >> 15
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN16(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10000)|value<<16)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN16() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10000) >> 16
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN17(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20000)|value<<17)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN17() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20000) >> 17
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN18(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40000)|value<<18)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN18() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40000) >> 18
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN19(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000)|value<<19)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN19() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000) >> 19
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN20(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100000)|value<<20)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN20() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100000) >> 20
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN21(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x200000)|value<<21)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN21() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x200000) >> 21
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN22(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x400000)|value<<22)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN22() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x400000) >> 22
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN23(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x800000)|value<<23)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN23() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x800000) >> 23
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN24(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1000000)|value<<24)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN24() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x1000000) >> 24
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN25(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2000000)|value<<25)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN25() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2000000) >> 25
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN26(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4000000)|value<<26)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN26() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4000000) >> 26
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN27(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x8000000)|value<<27)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN27() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x8000000) >> 27
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN28(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10000000)|value<<28)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN28() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10000000) >> 28
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN29(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20000000)|value<<29)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN29() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20000000) >> 29
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN30(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x40000000)|value<<30)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN30() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x40000000) >> 30
}
func (o *SPU_GPIOPORT_Type) SetPERM_PIN31(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_GPIOPORT_Type) GetPERM_PIN31() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000000) >> 31
}

// SPU_GPIOPORT.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
func (o *SPU_GPIOPORT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *SPU_GPIOPORT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

type SPU_FLASHNSC_Type struct {
	REGION volatile.Register32 // 0x500
	SIZE   volatile.Register32 // 0x504
}

// SPU_FLASHNSC.REGION: Description cluster: Define which flash region can contain the non-secure callable (NSC) region n
func (o *SPU_FLASHNSC_Type) SetREGION(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x1f)|value)
}
func (o *SPU_FLASHNSC_Type) GetREGION() uint32 {
	return volatile.LoadUint32(&o.REGION.Reg) & 0x1f
}
func (o *SPU_FLASHNSC_Type) SetREGION_LOCK(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x100)|value<<8)
}
func (o *SPU_FLASHNSC_Type) GetREGION_LOCK() uint32 {
	return (volatile.LoadUint32(&o.REGION.Reg) & 0x100) >> 8
}

// SPU_FLASHNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
func (o *SPU_FLASHNSC_Type) SetSIZE(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0xf)|value)
}
func (o *SPU_FLASHNSC_Type) GetSIZE() uint32 {
	return volatile.LoadUint32(&o.SIZE.Reg) & 0xf
}
func (o *SPU_FLASHNSC_Type) SetSIZE_LOCK(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0x100)|value<<8)
}
func (o *SPU_FLASHNSC_Type) GetSIZE_LOCK() uint32 {
	return (volatile.LoadUint32(&o.SIZE.Reg) & 0x100) >> 8
}

type SPU_RAMNSC_Type struct {
	REGION volatile.Register32 // 0x540
	SIZE   volatile.Register32 // 0x544
}

// SPU_RAMNSC.REGION: Description cluster: Define which RAM region can contain the non-secure callable (NSC) region n
func (o *SPU_RAMNSC_Type) SetREGION(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0xf)|value)
}
func (o *SPU_RAMNSC_Type) GetREGION() uint32 {
	return volatile.LoadUint32(&o.REGION.Reg) & 0xf
}
func (o *SPU_RAMNSC_Type) SetREGION_LOCK(value uint32) {
	volatile.StoreUint32(&o.REGION.Reg, volatile.LoadUint32(&o.REGION.Reg)&^(0x100)|value<<8)
}
func (o *SPU_RAMNSC_Type) GetREGION_LOCK() uint32 {
	return (volatile.LoadUint32(&o.REGION.Reg) & 0x100) >> 8
}

// SPU_RAMNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
func (o *SPU_RAMNSC_Type) SetSIZE(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0xf)|value)
}
func (o *SPU_RAMNSC_Type) GetSIZE() uint32 {
	return volatile.LoadUint32(&o.SIZE.Reg) & 0xf
}
func (o *SPU_RAMNSC_Type) SetSIZE_LOCK(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, volatile.LoadUint32(&o.SIZE.Reg)&^(0x100)|value<<8)
}
func (o *SPU_RAMNSC_Type) GetSIZE_LOCK() uint32 {
	return (volatile.LoadUint32(&o.SIZE.Reg) & 0x100) >> 8
}

type SPU_FLASHREGION_Type struct {
	PERM volatile.Register32 // 0x600
}

// SPU_FLASHREGION.PERM: Description cluster: Access permissions for flash region n
func (o *SPU_FLASHREGION_Type) SetPERM_EXECUTE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_FLASHREGION_Type) GetPERM_EXECUTE() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_FLASHREGION_Type) SetPERM_WRITE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_FLASHREGION_Type) GetPERM_WRITE() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_FLASHREGION_Type) SetPERM_READ(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_FLASHREGION_Type) GetPERM_READ() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_FLASHREGION_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_FLASHREGION_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_FLASHREGION_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_FLASHREGION_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}

type SPU_RAMREGION_Type struct {
	PERM volatile.Register32 // 0x700
}

// SPU_RAMREGION.PERM: Description cluster: Access permissions for RAM region n
func (o *SPU_RAMREGION_Type) SetPERM_EXECUTE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x1)|value)
}
func (o *SPU_RAMREGION_Type) GetPERM_EXECUTE() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x1
}
func (o *SPU_RAMREGION_Type) SetPERM_WRITE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *SPU_RAMREGION_Type) GetPERM_WRITE() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *SPU_RAMREGION_Type) SetPERM_READ(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *SPU_RAMREGION_Type) GetPERM_READ() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}
func (o *SPU_RAMREGION_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_RAMREGION_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_RAMREGION_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_RAMREGION_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}

type SPU_PERIPHID_Type struct {
	PERM volatile.Register32 // 0x800
}

// SPU_PERIPHID.PERM: Description cluster: List capabilities and access permissions for the peripheral with ID n
func (o *SPU_PERIPHID_Type) SetPERM_SECUREMAPPING(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x3)|value)
}
func (o *SPU_PERIPHID_Type) GetPERM_SECUREMAPPING() uint32 {
	return volatile.LoadUint32(&o.PERM.Reg) & 0x3
}
func (o *SPU_PERIPHID_Type) SetPERM_DMA(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0xc)|value<<2)
}
func (o *SPU_PERIPHID_Type) GetPERM_DMA() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0xc) >> 2
}
func (o *SPU_PERIPHID_Type) SetPERM_SECATTR(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x10)|value<<4)
}
func (o *SPU_PERIPHID_Type) GetPERM_SECATTR() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x10) >> 4
}
func (o *SPU_PERIPHID_Type) SetPERM_DMASEC(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x20)|value<<5)
}
func (o *SPU_PERIPHID_Type) GetPERM_DMASEC() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x20) >> 5
}
func (o *SPU_PERIPHID_Type) SetPERM_LOCK(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x100)|value<<8)
}
func (o *SPU_PERIPHID_Type) GetPERM_LOCK() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x100) >> 8
}
func (o *SPU_PERIPHID_Type) SetPERM_PRESENT(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x80000000)|value<<31)
}
func (o *SPU_PERIPHID_Type) GetPERM_PRESENT() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x80000000) >> 31
}

// Voltage regulators control 0
type REGULATORS_Type struct {
	_         [1280]byte
	SYSTEMOFF volatile.Register32 // 0x500
	_         [116]byte
	DCDCEN    volatile.Register32 // 0x578
}

// REGULATORS.SYSTEMOFF: System OFF register
func (o *REGULATORS_Type) SetSYSTEMOFF(value uint32) {
	volatile.StoreUint32(&o.SYSTEMOFF.Reg, volatile.LoadUint32(&o.SYSTEMOFF.Reg)&^(0x1)|value)
}
func (o *REGULATORS_Type) GetSYSTEMOFF() uint32 {
	return volatile.LoadUint32(&o.SYSTEMOFF.Reg) & 0x1
}

// REGULATORS.DCDCEN: Enable DC/DC mode of the main voltage regulator.
func (o *REGULATORS_Type) SetDCDCEN(value uint32) {
	volatile.StoreUint32(&o.DCDCEN.Reg, volatile.LoadUint32(&o.DCDCEN.Reg)&^(0x1)|value)
}
func (o *REGULATORS_Type) GetDCDCEN() uint32 {
	return volatile.LoadUint32(&o.DCDCEN.Reg) & 0x1
}

// Clock management 0
type CLOCK_Type struct {
	TASKS_HFCLKSTART     volatile.Register32 // 0x0
	TASKS_HFCLKSTOP      volatile.Register32 // 0x4
	TASKS_LFCLKSTART     volatile.Register32 // 0x8
	TASKS_LFCLKSTOP      volatile.Register32 // 0xC
	_                    [112]byte
	SUBSCRIBE_HFCLKSTART volatile.Register32 // 0x80
	SUBSCRIBE_HFCLKSTOP  volatile.Register32 // 0x84
	SUBSCRIBE_LFCLKSTART volatile.Register32 // 0x88
	SUBSCRIBE_LFCLKSTOP  volatile.Register32 // 0x8C
	_                    [112]byte
	EVENTS_HFCLKSTARTED  volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED  volatile.Register32 // 0x104
	_                    [120]byte
	PUBLISH_HFCLKSTARTED volatile.Register32 // 0x180
	PUBLISH_LFCLKSTARTED volatile.Register32 // 0x184
	_                    [376]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	INTPEND              volatile.Register32 // 0x30C
	_                    [248]byte
	HFCLKRUN             volatile.Register32 // 0x408
	HFCLKSTAT            volatile.Register32 // 0x40C
	_                    [4]byte
	LFCLKRUN             volatile.Register32 // 0x414
	LFCLKSTAT            volatile.Register32 // 0x418
	LFCLKSRCCOPY         volatile.Register32 // 0x41C
	_                    [248]byte
	LFCLKSRC             volatile.Register32 // 0x518
}

// CLOCK.TASKS_HFCLKSTART: Start HFCLK source
func (o *CLOCK_Type) SetTASKS_HFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_HFCLKSTOP: Stop HFCLK source
func (o *CLOCK_Type) SetTASKS_HFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTART: Start LFCLK source
func (o *CLOCK_Type) SetTASKS_LFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTOP: Stop LFCLK source
func (o *CLOCK_Type) SetTASKS_LFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg) & 0x1
}

// CLOCK.SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg)&^(0xf)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg) & 0xf
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg)&^(0xf)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg) & 0xf
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg)&^(0xf)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg) & 0xf
}
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg)&^(0xf)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg) & 0xf
}
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.EVENTS_HFCLKSTARTED: HFCLK oscillator started
func (o *CLOCK_Type) SetEVENTS_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_LFCLKSTARTED: LFCLK started
func (o *CLOCK_Type) SetEVENTS_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_LFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg) & 0x1
}

// CLOCK.PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
func (o *CLOCK_Type) SetPUBLISH_HFCLKSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg)&^(0xf)|value)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg) & 0xf
}
func (o *CLOCK_Type) SetPUBLISH_HFCLKSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
func (o *CLOCK_Type) SetPUBLISH_LFCLKSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg)&^(0xf)|value)
}
func (o *CLOCK_Type) GetPUBLISH_LFCLKSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg) & 0xf
}
func (o *CLOCK_Type) SetPUBLISH_LFCLKSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_LFCLKSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.INTEN: Enable or disable interrupt
func (o *CLOCK_Type) SetINTEN_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTEN_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTEN_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTEN_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}

// CLOCK.INTENSET: Enable interrupt
func (o *CLOCK_Type) SetINTENSET_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENSET_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENSET_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENSET_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}

// CLOCK.INTENCLR: Disable interrupt
func (o *CLOCK_Type) SetINTENCLR_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENCLR_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENCLR_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENCLR_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}

// CLOCK.INTPEND: Pending interrupts
func (o *CLOCK_Type) SetINTPEND_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTPEND_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTPEND_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTPEND_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}

// CLOCK.HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
func (o *CLOCK_Type) SetHFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.HFCLKRUN.Reg, volatile.LoadUint32(&o.HFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.HFCLKRUN.Reg) & 0x1
}

// CLOCK.HFCLKSTAT: The register shows if HFXO has been requested by triggering HFCLKSTART task and if it has been started (STATE)
func (o *CLOCK_Type) SetHFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x1
}
func (o *CLOCK_Type) SetHFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetHFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
func (o *CLOCK_Type) SetLFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.LFCLKRUN.Reg, volatile.LoadUint32(&o.LFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.LFCLKRUN.Reg) & 0x1
}

// CLOCK.LFCLKSTAT: The register shows which LFCLK source has been requested (SRC) when triggering LFCLKSTART task and if the source has been started (STATE)
func (o *CLOCK_Type) SetLFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x3
}
func (o *CLOCK_Type) SetLFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetLFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKSRCCOPY: Copy of LFCLKSRC register, set after LFCLKSTART task has been triggered
func (o *CLOCK_Type) SetLFCLKSRCCOPY_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRCCOPY.Reg, volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRCCOPY_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg) & 0x3
}

// CLOCK.LFCLKSRC: Clock source for the LFCLK. LFCLKSTART task starts starts a clock source selected with this register.
func (o *CLOCK_Type) SetLFCLKSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRC.Reg, volatile.LoadUint32(&o.LFCLKSRC.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRC.Reg) & 0x3
}

// Power control 0
type POWER_Type struct {
	_                  [120]byte
	TASKS_CONSTLAT     volatile.Register32 // 0x78
	TASKS_LOWPWR       volatile.Register32 // 0x7C
	_                  [120]byte
	SUBSCRIBE_CONSTLAT volatile.Register32 // 0xF8
	SUBSCRIBE_LOWPWR   volatile.Register32 // 0xFC
	_                  [8]byte
	EVENTS_POFWARN     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_SLEEPENTER  volatile.Register32 // 0x114
	EVENTS_SLEEPEXIT   volatile.Register32 // 0x118
	_                  [108]byte
	PUBLISH_POFWARN    volatile.Register32 // 0x188
	_                  [8]byte
	PUBLISH_SLEEPENTER volatile.Register32 // 0x194
	PUBLISH_SLEEPEXIT  volatile.Register32 // 0x198
	_                  [356]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	RESETREAS          volatile.Register32 // 0x400
	_                  [60]byte
	POWERSTATUS        volatile.Register32 // 0x440
	_                  [216]byte
	GPREGRET           [2]volatile.Register32 // 0x51C
}

// POWER.TASKS_CONSTLAT: Enable constant latency mode.
func (o *POWER_Type) SetTASKS_CONSTLAT(value uint32) {
	volatile.StoreUint32(&o.TASKS_CONSTLAT.Reg, volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_CONSTLAT() uint32 {
	return volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg) & 0x1
}

// POWER.TASKS_LOWPWR: Enable low power mode (variable latency)
func (o *POWER_Type) SetTASKS_LOWPWR(value uint32) {
	volatile.StoreUint32(&o.TASKS_LOWPWR.Reg, volatile.LoadUint32(&o.TASKS_LOWPWR.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_LOWPWR() uint32 {
	return volatile.LoadUint32(&o.TASKS_LOWPWR.Reg) & 0x1
}

// POWER.SUBSCRIBE_CONSTLAT: Subscribe configuration for task CONSTLAT
func (o *POWER_Type) SetSUBSCRIBE_CONSTLAT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CONSTLAT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg)&^(0xf)|value)
}
func (o *POWER_Type) GetSUBSCRIBE_CONSTLAT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg) & 0xf
}
func (o *POWER_Type) SetSUBSCRIBE_CONSTLAT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CONSTLAT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetSUBSCRIBE_CONSTLAT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg) & 0x80000000) >> 31
}

// POWER.SUBSCRIBE_LOWPWR: Subscribe configuration for task LOWPWR
func (o *POWER_Type) SetSUBSCRIBE_LOWPWR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LOWPWR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg)&^(0xf)|value)
}
func (o *POWER_Type) GetSUBSCRIBE_LOWPWR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg) & 0xf
}
func (o *POWER_Type) SetSUBSCRIBE_LOWPWR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LOWPWR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetSUBSCRIBE_LOWPWR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg) & 0x80000000) >> 31
}

// POWER.EVENTS_POFWARN: Power failure warning
func (o *POWER_Type) SetEVENTS_POFWARN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_POFWARN.Reg, volatile.LoadUint32(&o.EVENTS_POFWARN.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_POFWARN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_POFWARN.Reg) & 0x1
}

// POWER.EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPENTER.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPENTER() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg) & 0x1
}

// POWER.EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPEXIT.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPEXIT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg) & 0x1
}

// POWER.PUBLISH_POFWARN: Publish configuration for event POFWARN
func (o *POWER_Type) SetPUBLISH_POFWARN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_POFWARN.Reg, volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg)&^(0xf)|value)
}
func (o *POWER_Type) GetPUBLISH_POFWARN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg) & 0xf
}
func (o *POWER_Type) SetPUBLISH_POFWARN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_POFWARN.Reg, volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_POFWARN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg) & 0x80000000) >> 31
}

// POWER.PUBLISH_SLEEPENTER: Publish configuration for event SLEEPENTER
func (o *POWER_Type) SetPUBLISH_SLEEPENTER_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPENTER.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg)&^(0xf)|value)
}
func (o *POWER_Type) GetPUBLISH_SLEEPENTER_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg) & 0xf
}
func (o *POWER_Type) SetPUBLISH_SLEEPENTER_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPENTER.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_SLEEPENTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg) & 0x80000000) >> 31
}

// POWER.PUBLISH_SLEEPEXIT: Publish configuration for event SLEEPEXIT
func (o *POWER_Type) SetPUBLISH_SLEEPEXIT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPEXIT.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg)&^(0xf)|value)
}
func (o *POWER_Type) GetPUBLISH_SLEEPEXIT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg) & 0xf
}
func (o *POWER_Type) SetPUBLISH_SLEEPEXIT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPEXIT.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_SLEEPEXIT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg) & 0x80000000) >> 31
}

// POWER.INTEN: Enable or disable interrupt
func (o *POWER_Type) SetINTEN_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTEN_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTEN_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTEN_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTEN_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTEN_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}

// POWER.INTENSET: Enable interrupt
func (o *POWER_Type) SetINTENSET_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENSET_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENSET_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENSET_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENSET_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENSET_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}

// POWER.INTENCLR: Disable interrupt
func (o *POWER_Type) SetINTENCLR_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENCLR_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENCLR_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENCLR_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENCLR_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENCLR_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}

// POWER.RESETREAS: Reset reason
func (o *POWER_Type) SetRESETREAS_RESETPIN(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetRESETREAS_RESETPIN() uint32 {
	return volatile.LoadUint32(&o.RESETREAS.Reg) & 0x1
}
func (o *POWER_Type) SetRESETREAS_DOG(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x2)|value<<1)
}
func (o *POWER_Type) GetRESETREAS_DOG() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x2) >> 1
}
func (o *POWER_Type) SetRESETREAS_OFF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetRESETREAS_OFF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetRESETREAS_DIF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x10)|value<<4)
}
func (o *POWER_Type) GetRESETREAS_DIF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x10) >> 4
}
func (o *POWER_Type) SetRESETREAS_SREQ(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x10000)|value<<16)
}
func (o *POWER_Type) GetRESETREAS_SREQ() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x10000) >> 16
}
func (o *POWER_Type) SetRESETREAS_LOCKUP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x20000)|value<<17)
}
func (o *POWER_Type) GetRESETREAS_LOCKUP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x20000) >> 17
}
func (o *POWER_Type) SetRESETREAS_CTRLAP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x40000)|value<<18)
}
func (o *POWER_Type) GetRESETREAS_CTRLAP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x40000) >> 18
}

// POWER.POWERSTATUS: Modem domain power status
func (o *POWER_Type) SetPOWERSTATUS_LTEMODEM(value uint32) {
	volatile.StoreUint32(&o.POWERSTATUS.Reg, volatile.LoadUint32(&o.POWERSTATUS.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetPOWERSTATUS_LTEMODEM() uint32 {
	return volatile.LoadUint32(&o.POWERSTATUS.Reg) & 0x1
}

// POWER.GPREGRET: Description collection: General purpose retention register
func (o *POWER_Type) SetGPREGRET(idx int, value uint32) {
	volatile.StoreUint32(&o.GPREGRET[idx].Reg, volatile.LoadUint32(&o.GPREGRET[idx].Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetGPREGRET(idx int) uint32 {
	return volatile.LoadUint32(&o.GPREGRET[idx].Reg) & 0xff
}

// Control access port
type CTRLAPPERI_Type struct {
	_            [1024]byte
	MAILBOX      CTRLAPPERI_MAILBOX_Type // 0x400
	_            [120]byte
	ERASEPROTECT CTRLAPPERI_ERASEPROTECT_Type // 0x500
}

type CTRLAPPERI_MAILBOX_Type struct {
	RXDATA   volatile.Register32 // 0x400
	RXSTATUS volatile.Register32 // 0x404
	_        [120]byte
	TXDATA   volatile.Register32 // 0x480
	TXSTATUS volatile.Register32 // 0x484
}

// CTRLAPPERI_MAILBOX.RXDATA: Data sent from the debugger to the CPU
func (o *CTRLAPPERI_MAILBOX_Type) SetRXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetRXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg)
}

// CTRLAPPERI_MAILBOX.RXSTATUS: Status to indicate if data sent from the debugger to the CPU has been read
func (o *CTRLAPPERI_MAILBOX_Type) SetRXSTATUS(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetRXSTATUS() uint32 {
	return volatile.LoadUint32(&o.RXSTATUS.Reg) & 0x1
}

// CTRLAPPERI_MAILBOX.TXDATA: Data sent from the CPU to the debugger
func (o *CTRLAPPERI_MAILBOX_Type) SetTXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetTXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg)
}

// CTRLAPPERI_MAILBOX.TXSTATUS: Status to indicate if data sent from the CPU to the debugger has been read
func (o *CTRLAPPERI_MAILBOX_Type) SetTXSTATUS(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetTXSTATUS() uint32 {
	return volatile.LoadUint32(&o.TXSTATUS.Reg) & 0x1
}

type CTRLAPPERI_ERASEPROTECT_Type struct {
	LOCK    volatile.Register32 // 0x500
	DISABLE volatile.Register32 // 0x504
}

// CTRLAPPERI_ERASEPROTECT.LOCK: Lock register ERASEPROTECT.DISABLE from being written until next reset
func (o *CTRLAPPERI_ERASEPROTECT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_ERASEPROTECT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

// CTRLAPPERI_ERASEPROTECT.DISABLE: Disable ERASEPROTECT and perform ERASEALL
func (o *CTRLAPPERI_ERASEPROTECT_Type) SetDISABLE(value uint32) {
	volatile.StoreUint32(&o.DISABLE.Reg, value)
}
func (o *CTRLAPPERI_ERASEPROTECT_Type) GetDISABLE() uint32 {
	return volatile.LoadUint32(&o.DISABLE.Reg)
}

// Serial Peripheral Interface Master with EasyDMA 0
type SPIM_Type struct {
	_                 [16]byte
	TASKS_START       volatile.Register32 // 0x10
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [108]byte
	SUBSCRIBE_START   volatile.Register32 // 0x90
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [4]byte
	EVENTS_END        volatile.Register32 // 0x118
	_                 [4]byte
	EVENTS_ENDTX      volatile.Register32 // 0x120
	_                 [40]byte
	EVENTS_STARTED    volatile.Register32 // 0x14C
	_                 [52]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [4]byte
	PUBLISH_END       volatile.Register32 // 0x198
	_                 [4]byte
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	_                 [40]byte
	PUBLISH_STARTED   volatile.Register32 // 0x1CC
	_                 [48]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [500]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              SPIM_PSEL_Type // 0x508
	_                 [16]byte
	FREQUENCY         volatile.Register32 // 0x524
	_                 [12]byte
	RXD               SPIM_RXD_Type       // 0x534
	TXD               SPIM_TXD_Type       // 0x544
	CONFIG            volatile.Register32 // 0x554
	_                 [104]byte
	ORC               volatile.Register32 // 0x5C0
}

// SPIM.TASKS_START: Start SPI transaction
func (o *SPIM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SPIM.TASKS_STOP: Stop SPI transaction
func (o *SPIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SPIM.TASKS_SUSPEND: Suspend SPI transaction
func (o *SPIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// SPIM.TASKS_RESUME: Resume SPI transaction
func (o *SPIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// SPIM.SUBSCRIBE_START: Subscribe configuration for task START
func (o *SPIM_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *SPIM_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *SPIM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *SPIM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *SPIM_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xf
}
func (o *SPIM_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *SPIM_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xf
}
func (o *SPIM_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// SPIM.EVENTS_STOPPED: SPI transaction has stopped
func (o *SPIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SPIM.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIM.EVENTS_END: End of RXD buffer and TXD buffer reached
func (o *SPIM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIM.EVENTS_ENDTX: End of TXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// SPIM.EVENTS_STARTED: Transaction started
func (o *SPIM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SPIM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *SPIM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *SPIM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *SPIM_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xf
}
func (o *SPIM_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_END: Publish configuration for event END
func (o *SPIM_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xf
}
func (o *SPIM_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *SPIM_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xf
}
func (o *SPIM_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *SPIM_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xf
}
func (o *SPIM_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// SPIM.SHORTS: Shortcuts between local events and tasks
func (o *SPIM_Type) SetSHORTS_END_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *SPIM_Type) GetSHORTS_END_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}

// SPIM.INTENSET: Enable interrupt
func (o *SPIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// SPIM.INTENCLR: Disable interrupt
func (o *SPIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// SPIM.ENABLE: Enable SPIM
func (o *SPIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIM.FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
func (o *SPIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *SPIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// SPIM.CONFIG: Configuration register
func (o *SPIM_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIM_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIM_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIM.ORC: Over-read character. Character clocked out in case an over-read of the TXD buffer.
func (o *SPIM_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

type SPIM_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MOSI volatile.Register32 // 0x50C
	MISO volatile.Register32 // 0x510
}

// SPIM_PSEL.SCK: Pin select for SCK
func (o *SPIM_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIM_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MISO: Pin select for MISO signal
func (o *SPIM_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

type SPIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIM_RXD.PTR: Data pointer
func (o *SPIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *SPIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// SPIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *SPIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// SPIM_RXD.LIST: EasyDMA list type
func (o *SPIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type SPIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIM_TXD.PTR: Data pointer
func (o *SPIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *SPIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *SPIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// SPIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *SPIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// SPIM_TXD.LIST: EasyDMA list type
func (o *SPIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// SPI Slave 0
type SPIS_Type struct {
	_                 [36]byte
	TASKS_ACQUIRE     volatile.Register32 // 0x24
	TASKS_RELEASE     volatile.Register32 // 0x28
	_                 [120]byte
	SUBSCRIBE_ACQUIRE volatile.Register32 // 0xA4
	SUBSCRIBE_RELEASE volatile.Register32 // 0xA8
	_                 [88]byte
	EVENTS_END        volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [20]byte
	EVENTS_ACQUIRED   volatile.Register32 // 0x128
	_                 [88]byte
	PUBLISH_END       volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [20]byte
	PUBLISH_ACQUIRED  volatile.Register32 // 0x1A8
	_                 [84]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	SEMSTAT           volatile.Register32 // 0x400
	_                 [60]byte
	STATUS            volatile.Register32 // 0x440
	_                 [188]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              SPIS_PSEL_Type // 0x508
	_                 [28]byte
	RXD               SPIS_RXD_Type       // 0x534
	TXD               SPIS_TXD_Type       // 0x544
	CONFIG            volatile.Register32 // 0x554
	_                 [4]byte
	DEF               volatile.Register32 // 0x55C
	_                 [96]byte
	ORC               volatile.Register32 // 0x5C0
}

// SPIS.TASKS_ACQUIRE: Acquire SPI semaphore
func (o *SPIS_Type) SetTASKS_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACQUIRE.Reg, volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_ACQUIRE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg) & 0x1
}

// SPIS.TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
func (o *SPIS_Type) SetTASKS_RELEASE(value uint32) {
	volatile.StoreUint32(&o.TASKS_RELEASE.Reg, volatile.LoadUint32(&o.TASKS_RELEASE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_RELEASE() uint32 {
	return volatile.LoadUint32(&o.TASKS_RELEASE.Reg) & 0x1
}

// SPIS.SUBSCRIBE_ACQUIRE: Subscribe configuration for task ACQUIRE
func (o *SPIS_Type) SetSUBSCRIBE_ACQUIRE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACQUIRE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetSUBSCRIBE_ACQUIRE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg) & 0xf
}
func (o *SPIS_Type) SetSUBSCRIBE_ACQUIRE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACQUIRE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetSUBSCRIBE_ACQUIRE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg) & 0x80000000) >> 31
}

// SPIS.SUBSCRIBE_RELEASE: Subscribe configuration for task RELEASE
func (o *SPIS_Type) SetSUBSCRIBE_RELEASE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RELEASE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetSUBSCRIBE_RELEASE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg) & 0xf
}
func (o *SPIS_Type) SetSUBSCRIBE_RELEASE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RELEASE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetSUBSCRIBE_RELEASE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg) & 0x80000000) >> 31
}

// SPIS.EVENTS_END: Granted transaction completed
func (o *SPIS_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIS.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIS_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIS.EVENTS_ACQUIRED: Semaphore acquired
func (o *SPIS_Type) SetEVENTS_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ACQUIRED.Reg, volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ACQUIRED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg) & 0x1
}

// SPIS.PUBLISH_END: Publish configuration for event END
func (o *SPIS_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xf
}
func (o *SPIS_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SPIS.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *SPIS_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xf
}
func (o *SPIS_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// SPIS.PUBLISH_ACQUIRED: Publish configuration for event ACQUIRED
func (o *SPIS_Type) SetPUBLISH_ACQUIRED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACQUIRED.Reg, volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetPUBLISH_ACQUIRED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg) & 0xf
}
func (o *SPIS_Type) SetPUBLISH_ACQUIRED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACQUIRED.Reg, volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_ACQUIRED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg) & 0x80000000) >> 31
}

// SPIS.SHORTS: Shortcuts between local events and tasks
func (o *SPIS_Type) SetSHORTS_END_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetSHORTS_END_ACQUIRE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}

// SPIS.INTENSET: Enable interrupt
func (o *SPIS_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENSET_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENSET_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}

// SPIS.INTENCLR: Disable interrupt
func (o *SPIS_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENCLR_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENCLR_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}

// SPIS.SEMSTAT: Semaphore status register
func (o *SPIS_Type) SetSEMSTAT(value uint32) {
	volatile.StoreUint32(&o.SEMSTAT.Reg, volatile.LoadUint32(&o.SEMSTAT.Reg)&^(0x3)|value)
}
func (o *SPIS_Type) GetSEMSTAT() uint32 {
	return volatile.LoadUint32(&o.SEMSTAT.Reg) & 0x3
}

// SPIS.STATUS: Status from last transaction
func (o *SPIS_Type) SetSTATUS_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetSTATUS_OVERREAD() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SPIS_Type) SetSTATUS_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetSTATUS_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}

// SPIS.ENABLE: Enable SPI slave
func (o *SPIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIS.CONFIG: Configuration register
func (o *SPIS_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIS_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIS.DEF: Default character. Character clocked out in case of an ignored transaction.
func (o *SPIS_Type) SetDEF(value uint32) {
	volatile.StoreUint32(&o.DEF.Reg, volatile.LoadUint32(&o.DEF.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetDEF() uint32 {
	return volatile.LoadUint32(&o.DEF.Reg) & 0xff
}

// SPIS.ORC: Over-read character
func (o *SPIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

type SPIS_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MISO volatile.Register32 // 0x50C
	MOSI volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIS_PSEL.SCK: Pin select for SCK
func (o *SPIS_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MISO: Pin select for MISO signal
func (o *SPIS_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIS_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.CSN: Pin select for CSN signal
func (o *SPIS_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

type SPIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIS_RXD.PTR: RXD data pointer
func (o *SPIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *SPIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// SPIS_RXD.AMOUNT: Number of bytes received in last granted transaction
func (o *SPIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *SPIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// SPIS_RXD.LIST: EasyDMA list type
func (o *SPIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type SPIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIS_TXD.PTR: TXD data pointer
func (o *SPIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *SPIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *SPIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// SPIS_TXD.AMOUNT: Number of bytes transmitted in last granted transaction
func (o *SPIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *SPIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// SPIS_TXD.LIST: EasyDMA list type
func (o *SPIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// I2C compatible Two-Wire Master Interface with EasyDMA 0
type TWIM_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	_                 [4]byte
	TASKS_STARTTX     volatile.Register32 // 0x8
	_                 [8]byte
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [92]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	_                 [4]byte
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	_                 [8]byte
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [28]byte
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [32]byte
	EVENTS_SUSPENDED  volatile.Register32 // 0x148
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [8]byte
	EVENTS_LASTRX     volatile.Register32 // 0x15C
	EVENTS_LASTTX     volatile.Register32 // 0x160
	_                 [32]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [28]byte
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [32]byte
	PUBLISH_SUSPENDED volatile.Register32 // 0x1C8
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [8]byte
	PUBLISH_LASTRX    volatile.Register32 // 0x1DC
	PUBLISH_LASTTX    volatile.Register32 // 0x1E0
	_                 [28]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [440]byte
	ERRORSRC          volatile.Register32 // 0x4C4
	_                 [56]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              TWIM_PSEL_Type // 0x508
	_                 [20]byte
	FREQUENCY         volatile.Register32 // 0x524
	_                 [12]byte
	RXD               TWIM_RXD_Type // 0x534
	TXD               TWIM_TXD_Type // 0x544
	_                 [52]byte
	ADDRESS           volatile.Register32 // 0x588
}

// TWIM.TASKS_STARTRX: Start TWI receive sequence
func (o *TWIM_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// TWIM.TASKS_STARTTX: Start TWI transmit sequence
func (o *TWIM_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// TWIM.TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
func (o *TWIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIM.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIM.TASKS_RESUME: Resume TWI transaction
func (o *TWIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIM.SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
func (o *TWIM_Type) SetSUBSCRIBE_STARTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0xf
}
func (o *TWIM_Type) SetSUBSCRIBE_STARTRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *TWIM_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xf
}
func (o *TWIM_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TWIM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *TWIM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *TWIM_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xf
}
func (o *TWIM_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *TWIM_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xf
}
func (o *TWIM_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// TWIM.EVENTS_STOPPED: TWI stopped
func (o *TWIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIM.EVENTS_ERROR: TWI error
func (o *TWIM_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIM.EVENTS_SUSPENDED: SUSPEND task has been issued, TWI traffic is now suspended.
func (o *TWIM_Type) SetEVENTS_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SUSPENDED.Reg, volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_SUSPENDED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg) & 0x1
}

// TWIM.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIM_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIM_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_LASTRX: Byte boundary, starting to receive the last byte
func (o *TWIM_Type) SetEVENTS_LASTRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTRX.Reg, volatile.LoadUint32(&o.EVENTS_LASTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTRX.Reg) & 0x1
}

// TWIM.EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
func (o *TWIM_Type) SetEVENTS_LASTTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTTX.Reg, volatile.LoadUint32(&o.EVENTS_LASTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTTX.Reg) & 0x1
}

// TWIM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *TWIM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *TWIM_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_SUSPENDED: Publish configuration for event SUSPENDED
func (o *TWIM_Type) SetPUBLISH_SUSPENDED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SUSPENDED.Reg, volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_SUSPENDED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_SUSPENDED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SUSPENDED.Reg, volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_SUSPENDED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *TWIM_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *TWIM_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_LASTRX: Publish configuration for event LASTRX
func (o *TWIM_Type) SetPUBLISH_LASTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTRX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_LASTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_LASTRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTRX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_LASTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_LASTTX: Publish configuration for event LASTTX
func (o *TWIM_Type) SetPUBLISH_LASTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTTX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetPUBLISH_LASTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg) & 0xf
}
func (o *TWIM_Type) SetPUBLISH_LASTTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTTX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_LASTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg) & 0x80000000) >> 31
}

// TWIM.SHORTS: Shortcuts between local events and tasks
func (o *TWIM_Type) SetSHORTS_LASTTX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80)|value<<7)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80) >> 7
}
func (o *TWIM_Type) SetSHORTS_LASTTX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *TWIM_Type) SetSHORTS_LASTTX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STARTTX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400)|value<<10)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STARTTX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400) >> 10
}
func (o *TWIM_Type) SetSHORTS_LASTRX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}

// TWIM.INTEN: Enable or disable interrupt
func (o *TWIM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTEN_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTEN_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTEN_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTEN_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTEN_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTEN_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}

// TWIM.INTENSET: Enable interrupt
func (o *TWIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENSET_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENSET_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENSET_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENSET_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENSET_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENSET_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}

// TWIM.INTENCLR: Disable interrupt
func (o *TWIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENCLR_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENCLR_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENCLR_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENCLR_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENCLR_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENCLR_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}

// TWIM.ERRORSRC: Error source
func (o *TWIM_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIM_Type) SetERRORSRC_ANACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetERRORSRC_ANACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIM_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}

// TWIM.ENABLE: Enable TWIM
func (o *TWIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIM.FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
func (o *TWIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *TWIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// TWIM.ADDRESS: Address used in the TWI transfer
func (o *TWIM_Type) SetADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDRESS.Reg, volatile.LoadUint32(&o.ADDRESS.Reg)&^(0x7f)|value)
}
func (o *TWIM_Type) GetADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDRESS.Reg) & 0x7f
}

type TWIM_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIM_PSEL.SCL: Pin select for SCL signal
func (o *TWIM_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIM_PSEL.SDA: Pin select for SDA signal
func (o *TWIM_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

type TWIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIM_RXD.PTR: Data pointer
func (o *TWIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *TWIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *TWIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// TWIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *TWIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// TWIM_RXD.LIST: EasyDMA list type
func (o *TWIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type TWIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIM_TXD.PTR: Data pointer
func (o *TWIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *TWIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *TWIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// TWIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *TWIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// TWIM_TXD.LIST: EasyDMA list type
func (o *TWIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// I2C compatible Two-Wire Slave Interface with EasyDMA 0
type TWIS_Type struct {
	_                   [20]byte
	TASKS_STOP          volatile.Register32 // 0x14
	_                   [4]byte
	TASKS_SUSPEND       volatile.Register32 // 0x1C
	TASKS_RESUME        volatile.Register32 // 0x20
	_                   [12]byte
	TASKS_PREPARERX     volatile.Register32 // 0x30
	TASKS_PREPARETX     volatile.Register32 // 0x34
	_                   [92]byte
	SUBSCRIBE_STOP      volatile.Register32 // 0x94
	_                   [4]byte
	SUBSCRIBE_SUSPEND   volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME    volatile.Register32 // 0xA0
	_                   [12]byte
	SUBSCRIBE_PREPARERX volatile.Register32 // 0xB0
	SUBSCRIBE_PREPARETX volatile.Register32 // 0xB4
	_                   [76]byte
	EVENTS_STOPPED      volatile.Register32 // 0x104
	_                   [28]byte
	EVENTS_ERROR        volatile.Register32 // 0x124
	_                   [36]byte
	EVENTS_RXSTARTED    volatile.Register32 // 0x14C
	EVENTS_TXSTARTED    volatile.Register32 // 0x150
	_                   [16]byte
	EVENTS_WRITE        volatile.Register32 // 0x164
	EVENTS_READ         volatile.Register32 // 0x168
	_                   [24]byte
	PUBLISH_STOPPED     volatile.Register32 // 0x184
	_                   [28]byte
	PUBLISH_ERROR       volatile.Register32 // 0x1A4
	_                   [36]byte
	PUBLISH_RXSTARTED   volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED   volatile.Register32 // 0x1D0
	_                   [16]byte
	PUBLISH_WRITE       volatile.Register32 // 0x1E4
	PUBLISH_READ        volatile.Register32 // 0x1E8
	_                   [20]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [252]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [452]byte
	ERRORSRC            volatile.Register32 // 0x4D0
	MATCH               volatile.Register32 // 0x4D4
	_                   [40]byte
	ENABLE              volatile.Register32 // 0x500
	_                   [4]byte
	PSEL                TWIS_PSEL_Type // 0x508
	_                   [36]byte
	RXD                 TWIS_RXD_Type // 0x534
	TXD                 TWIS_TXD_Type // 0x544
	_                   [52]byte
	ADDRESS             [2]volatile.Register32 // 0x588
	_                   [4]byte
	CONFIG              volatile.Register32 // 0x594
	_                   [40]byte
	ORC                 volatile.Register32 // 0x5C0
}

// TWIS.TASKS_STOP: Stop TWI transaction
func (o *TWIS_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIS.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIS_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIS.TASKS_RESUME: Resume TWI transaction
func (o *TWIS_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIS.TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
func (o *TWIS_Type) SetTASKS_PREPARERX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARERX.Reg, volatile.LoadUint32(&o.TASKS_PREPARERX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARERX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARERX.Reg) & 0x1
}

// TWIS.TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
func (o *TWIS_Type) SetTASKS_PREPARETX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARETX.Reg, volatile.LoadUint32(&o.TASKS_PREPARETX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARETX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARETX.Reg) & 0x1
}

// TWIS.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TWIS_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *TWIS_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *TWIS_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xf
}
func (o *TWIS_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *TWIS_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xf
}
func (o *TWIS_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_PREPARERX: Subscribe configuration for task PREPARERX
func (o *TWIS_Type) SetSUBSCRIBE_PREPARERX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARERX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARERX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg) & 0xf
}
func (o *TWIS_Type) SetSUBSCRIBE_PREPARERX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARERX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARERX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_PREPARETX: Subscribe configuration for task PREPARETX
func (o *TWIS_Type) SetSUBSCRIBE_PREPARETX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARETX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARETX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg) & 0xf
}
func (o *TWIS_Type) SetSUBSCRIBE_PREPARETX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARETX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARETX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg) & 0x80000000) >> 31
}

// TWIS.EVENTS_STOPPED: TWI stopped
func (o *TWIS_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIS.EVENTS_ERROR: TWI error
func (o *TWIS_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIS.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIS_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIS_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_WRITE: Write command received
func (o *TWIS_Type) SetEVENTS_WRITE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_WRITE.Reg, volatile.LoadUint32(&o.EVENTS_WRITE.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_WRITE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_WRITE.Reg) & 0x1
}

// TWIS.EVENTS_READ: Read command received
func (o *TWIS_Type) SetEVENTS_READ(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READ.Reg, volatile.LoadUint32(&o.EVENTS_READ.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_READ() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READ.Reg) & 0x1
}

// TWIS.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *TWIS_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *TWIS_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *TWIS_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xf
}
func (o *TWIS_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *TWIS_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xf
}
func (o *TWIS_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *TWIS_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xf
}
func (o *TWIS_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_WRITE: Publish configuration for event WRITE
func (o *TWIS_Type) SetPUBLISH_WRITE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_WRITE.Reg, volatile.LoadUint32(&o.PUBLISH_WRITE.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetPUBLISH_WRITE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_WRITE.Reg) & 0xf
}
func (o *TWIS_Type) SetPUBLISH_WRITE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_WRITE.Reg, volatile.LoadUint32(&o.PUBLISH_WRITE.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_WRITE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_WRITE.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_READ: Publish configuration for event READ
func (o *TWIS_Type) SetPUBLISH_READ_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READ.Reg, volatile.LoadUint32(&o.PUBLISH_READ.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetPUBLISH_READ_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READ.Reg) & 0xf
}
func (o *TWIS_Type) SetPUBLISH_READ_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READ.Reg, volatile.LoadUint32(&o.PUBLISH_READ.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_READ_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READ.Reg) & 0x80000000) >> 31
}

// TWIS.SHORTS: Shortcuts between local events and tasks
func (o *TWIS_Type) SetSHORTS_WRITE_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *TWIS_Type) GetSHORTS_WRITE_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}
func (o *TWIS_Type) SetSHORTS_READ_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4000)|value<<14)
}
func (o *TWIS_Type) GetSHORTS_READ_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4000) >> 14
}

// TWIS.INTEN: Enable or disable interrupt
func (o *TWIS_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTEN_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTEN_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTEN_READ(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTEN_READ() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000000) >> 26
}

// TWIS.INTENSET: Enable interrupt
func (o *TWIS_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENSET_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENSET_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENSET_READ(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENSET_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}

// TWIS.INTENCLR: Disable interrupt
func (o *TWIS_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENCLR_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENCLR_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENCLR_READ(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENCLR_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}

// TWIS.ERRORSRC: Error source
func (o *TWIS_Type) SetERRORSRC_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetERRORSRC_OVERFLOW() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIS_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIS_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *TWIS_Type) SetERRORSRC_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *TWIS_Type) GetERRORSRC_OVERREAD() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// TWIS.MATCH: Status register indicating which address had a match
func (o *TWIS_Type) SetMATCH(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetMATCH() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg) & 0x1
}

// TWIS.ENABLE: Enable TWIS
func (o *TWIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIS.ADDRESS: Description collection: TWI slave address n
func (o *TWIS_Type) SetADDRESS(idx int, value uint32) {
	volatile.StoreUint32(&o.ADDRESS[idx].Reg, volatile.LoadUint32(&o.ADDRESS[idx].Reg)&^(0x7f)|value)
}
func (o *TWIS_Type) GetADDRESS(idx int) uint32 {
	return volatile.LoadUint32(&o.ADDRESS[idx].Reg) & 0x7f
}

// TWIS.CONFIG: Configuration register for the address match mechanism
func (o *TWIS_Type) SetCONFIG_ADDRESS0(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS0() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *TWIS_Type) SetCONFIG_ADDRESS1(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}

// TWIS.ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
func (o *TWIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

type TWIS_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIS_PSEL.SCL: Pin select for SCL signal
func (o *TWIS_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIS_PSEL.SDA: Pin select for SDA signal
func (o *TWIS_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

type TWIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIS_RXD.PTR: RXD Data pointer
func (o *TWIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_RXD.MAXCNT: Maximum number of bytes in RXD buffer
func (o *TWIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *TWIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// TWIS_RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
func (o *TWIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *TWIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// TWIS_RXD.LIST: EasyDMA list type
func (o *TWIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

type TWIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIS_TXD.PTR: TXD Data pointer
func (o *TWIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_TXD.MAXCNT: Maximum number of bytes in TXD buffer
func (o *TWIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *TWIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// TWIS_TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
func (o *TWIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *TWIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// TWIS_TXD.LIST: EasyDMA list type
func (o *TWIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// UART with EasyDMA 0
type UARTE_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	TASKS_STOPRX      volatile.Register32 // 0x4
	TASKS_STARTTX     volatile.Register32 // 0x8
	TASKS_STOPTX      volatile.Register32 // 0xC
	_                 [28]byte
	TASKS_FLUSHRX     volatile.Register32 // 0x2C
	_                 [80]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	SUBSCRIBE_STOPRX  volatile.Register32 // 0x84
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	SUBSCRIBE_STOPTX  volatile.Register32 // 0x8C
	_                 [28]byte
	SUBSCRIBE_FLUSHRX volatile.Register32 // 0xAC
	_                 [80]byte
	EVENTS_CTS        volatile.Register32 // 0x100
	EVENTS_NCTS       volatile.Register32 // 0x104
	EVENTS_RXDRDY     volatile.Register32 // 0x108
	_                 [4]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [8]byte
	EVENTS_TXDRDY     volatile.Register32 // 0x11C
	EVENTS_ENDTX      volatile.Register32 // 0x120
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [28]byte
	EVENTS_RXTO       volatile.Register32 // 0x144
	_                 [4]byte
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [4]byte
	EVENTS_TXSTOPPED  volatile.Register32 // 0x158
	_                 [36]byte
	PUBLISH_CTS       volatile.Register32 // 0x180
	PUBLISH_NCTS      volatile.Register32 // 0x184
	PUBLISH_RXDRDY    volatile.Register32 // 0x188
	_                 [4]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [8]byte
	PUBLISH_TXDRDY    volatile.Register32 // 0x19C
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [28]byte
	PUBLISH_RXTO      volatile.Register32 // 0x1C4
	_                 [4]byte
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [4]byte
	PUBLISH_TXSTOPPED volatile.Register32 // 0x1D8
	_                 [36]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [372]byte
	ERRORSRC          volatile.Register32 // 0x480
	_                 [124]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              UARTE_PSEL_Type // 0x508
	_                 [12]byte
	BAUDRATE          volatile.Register32 // 0x524
	_                 [12]byte
	RXD               UARTE_RXD_Type // 0x534
	_                 [4]byte
	TXD               UARTE_TXD_Type // 0x544
	_                 [28]byte
	CONFIG            volatile.Register32 // 0x56C
}

// UARTE.TASKS_STARTRX: Start UART receiver
func (o *UARTE_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// UARTE.TASKS_STOPRX: Stop UART receiver
func (o *UARTE_Type) SetTASKS_STOPRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPRX.Reg, volatile.LoadUint32(&o.TASKS_STOPRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPRX.Reg) & 0x1
}

// UARTE.TASKS_STARTTX: Start UART transmitter
func (o *UARTE_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// UARTE.TASKS_STOPTX: Stop UART transmitter
func (o *UARTE_Type) SetTASKS_STOPTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPTX.Reg, volatile.LoadUint32(&o.TASKS_STOPTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPTX.Reg) & 0x1
}

// UARTE.TASKS_FLUSHRX: Flush RX FIFO into RX buffer
func (o *UARTE_Type) SetTASKS_FLUSHRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_FLUSHRX.Reg, volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_FLUSHRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg) & 0x1
}

// UARTE.SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
func (o *UARTE_Type) SetSUBSCRIBE_STARTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0xf
}
func (o *UARTE_Type) SetSUBSCRIBE_STARTRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STOPRX: Subscribe configuration for task STOPRX
func (o *UARTE_Type) SetSUBSCRIBE_STOPRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg) & 0xf
}
func (o *UARTE_Type) SetSUBSCRIBE_STOPRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *UARTE_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xf
}
func (o *UARTE_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STOPTX: Subscribe configuration for task STOPTX
func (o *UARTE_Type) SetSUBSCRIBE_STOPTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg) & 0xf
}
func (o *UARTE_Type) SetSUBSCRIBE_STOPTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_FLUSHRX: Subscribe configuration for task FLUSHRX
func (o *UARTE_Type) SetSUBSCRIBE_FLUSHRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_FLUSHRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_FLUSHRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg) & 0xf
}
func (o *UARTE_Type) SetSUBSCRIBE_FLUSHRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_FLUSHRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_FLUSHRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg) & 0x80000000) >> 31
}

// UARTE.EVENTS_CTS: CTS is activated (set low). Clear To Send.
func (o *UARTE_Type) SetEVENTS_CTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTS.Reg, volatile.LoadUint32(&o.EVENTS_CTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_CTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTS.Reg) & 0x1
}

// UARTE.EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
func (o *UARTE_Type) SetEVENTS_NCTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NCTS.Reg, volatile.LoadUint32(&o.EVENTS_NCTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_NCTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NCTS.Reg) & 0x1
}

// UARTE.EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
func (o *UARTE_Type) SetEVENTS_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDRX: Receive buffer is filled up
func (o *UARTE_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// UARTE.EVENTS_TXDRDY: Data sent from TXD
func (o *UARTE_Type) SetEVENTS_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDTX: Last TX byte transmitted
func (o *UARTE_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// UARTE.EVENTS_ERROR: Error detected
func (o *UARTE_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// UARTE.EVENTS_RXTO: Receiver timeout
func (o *UARTE_Type) SetEVENTS_RXTO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXTO.Reg, volatile.LoadUint32(&o.EVENTS_RXTO.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXTO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXTO.Reg) & 0x1
}

// UARTE.EVENTS_RXSTARTED: UART receiver has started
func (o *UARTE_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTARTED: UART transmitter has started
func (o *UARTE_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTOPPED: Transmitter stopped
func (o *UARTE_Type) SetEVENTS_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg) & 0x1
}

// UARTE.PUBLISH_CTS: Publish configuration for event CTS
func (o *UARTE_Type) SetPUBLISH_CTS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTS.Reg, volatile.LoadUint32(&o.PUBLISH_CTS.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_CTS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CTS.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_CTS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTS.Reg, volatile.LoadUint32(&o.PUBLISH_CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_CTS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CTS.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_NCTS: Publish configuration for event NCTS
func (o *UARTE_Type) SetPUBLISH_NCTS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NCTS.Reg, volatile.LoadUint32(&o.PUBLISH_NCTS.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_NCTS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_NCTS.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_NCTS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NCTS.Reg, volatile.LoadUint32(&o.PUBLISH_NCTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_NCTS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_NCTS.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXDRDY: Publish configuration for event RXDRDY
func (o *UARTE_Type) SetPUBLISH_RXDRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXDRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_RXDRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXDRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *UARTE_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXDRDY: Publish configuration for event TXDRDY
func (o *UARTE_Type) SetPUBLISH_TXDRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXDRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_TXDRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXDRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *UARTE_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *UARTE_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXTO: Publish configuration for event RXTO
func (o *UARTE_Type) SetPUBLISH_RXTO_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXTO.Reg, volatile.LoadUint32(&o.PUBLISH_RXTO.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXTO_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXTO.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_RXTO_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXTO.Reg, volatile.LoadUint32(&o.PUBLISH_RXTO.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXTO_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXTO.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *UARTE_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *UARTE_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXSTOPPED: Publish configuration for event TXSTOPPED
func (o *UARTE_Type) SetPUBLISH_TXSTOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXSTOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg) & 0xf
}
func (o *UARTE_Type) SetPUBLISH_TXSTOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXSTOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg) & 0x80000000) >> 31
}

// UARTE.SHORTS: Shortcuts between local events and tasks
func (o *UARTE_Type) SetSHORTS_ENDRX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *UARTE_Type) SetSHORTS_ENDRX_STOPRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STOPRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}

// UARTE.INTEN: Enable or disable interrupt
func (o *UARTE_Type) SetINTEN_CTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTEN_CTS() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *UARTE_Type) SetINTEN_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTEN_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTEN_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTEN_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTEN_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTEN_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTEN_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTEN_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTEN_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTEN_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTEN_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTEN_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTEN_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTEN_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}

// UARTE.INTENSET: Enable interrupt
func (o *UARTE_Type) SetINTENSET_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENSET_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENSET_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENSET_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENSET_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENSET_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENSET_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENSET_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENSET_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENSET_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENSET_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENSET_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}

// UARTE.INTENCLR: Disable interrupt
func (o *UARTE_Type) SetINTENCLR_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENCLR_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENCLR_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENCLR_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENCLR_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENCLR_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENCLR_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENCLR_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENCLR_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENCLR_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENCLR_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENCLR_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}

// UARTE.ERRORSRC: Error source Note : this register is read / write one to clear.
func (o *UARTE_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *UARTE_Type) SetERRORSRC_PARITY(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetERRORSRC_PARITY() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetERRORSRC_FRAMING(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetERRORSRC_FRAMING() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetERRORSRC_BREAK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *UARTE_Type) GetERRORSRC_BREAK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// UARTE.ENABLE: Enable UART
func (o *UARTE_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// UARTE.BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
func (o *UARTE_Type) SetBAUDRATE(value uint32) {
	volatile.StoreUint32(&o.BAUDRATE.Reg, value)
}
func (o *UARTE_Type) GetBAUDRATE() uint32 {
	return volatile.LoadUint32(&o.BAUDRATE.Reg)
}

// UARTE.CONFIG: Configuration of parity and hardware flow control
func (o *UARTE_Type) SetCONFIG_HWFC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetCONFIG_HWFC() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *UARTE_Type) SetCONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xe)|value<<1)
}
func (o *UARTE_Type) GetCONFIG_PARITY() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xe) >> 1
}
func (o *UARTE_Type) SetCONFIG_STOP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetCONFIG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x10) >> 4
}

type UARTE_PSEL_Type struct {
	RTS volatile.Register32 // 0x508
	TXD volatile.Register32 // 0x50C
	CTS volatile.Register32 // 0x510
	RXD volatile.Register32 // 0x514
}

// UARTE_PSEL.RTS: Pin select for RTS signal
func (o *UARTE_PSEL_Type) SetRTS_PIN(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRTS_PIN() uint32 {
	return volatile.LoadUint32(&o.RTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.TXD: Pin select for TXD signal
func (o *UARTE_PSEL_Type) SetTXD_PIN(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetTXD_PIN() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetTXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetTXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.CTS: Pin select for CTS signal
func (o *UARTE_PSEL_Type) SetCTS_PIN(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetCTS_PIN() uint32 {
	return volatile.LoadUint32(&o.CTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetCTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetCTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.RXD: Pin select for RXD signal
func (o *UARTE_PSEL_Type) SetRXD_PIN(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRXD_PIN() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x80000000) >> 31
}

type UARTE_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
}

// UARTE_RXD.PTR: Data pointer
func (o *UARTE_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *UARTE_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *UARTE_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// UARTE_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *UARTE_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

type UARTE_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
}

// UARTE_TXD.PTR: Data pointer
func (o *UARTE_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *UARTE_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x1fff)|value)
}
func (o *UARTE_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x1fff
}

// UARTE_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x1fff)|value)
}
func (o *UARTE_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x1fff
}

// GPIO Tasks and Events 0
type GPIOTE_Type struct {
	TASKS_OUT     [8]volatile.Register32 // 0x0
	_             [16]byte
	TASKS_SET     [8]volatile.Register32 // 0x30
	_             [16]byte
	TASKS_CLR     [8]volatile.Register32 // 0x60
	SUBSCRIBE_OUT [8]volatile.Register32 // 0x80
	_             [16]byte
	SUBSCRIBE_SET [8]volatile.Register32 // 0xB0
	_             [16]byte
	SUBSCRIBE_CLR [8]volatile.Register32 // 0xE0
	EVENTS_IN     [8]volatile.Register32 // 0x100
	_             [92]byte
	EVENTS_PORT   volatile.Register32    // 0x17C
	PUBLISH_IN    [8]volatile.Register32 // 0x180
	_             [92]byte
	PUBLISH_PORT  volatile.Register32 // 0x1FC
	_             [260]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [516]byte
	CONFIG        [8]volatile.Register32 // 0x510
}

// GPIOTE.TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
func (o *GPIOTE_Type) SetTASKS_OUT(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_OUT[idx].Reg, volatile.LoadUint32(&o.TASKS_OUT[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_OUT(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_OUT[idx].Reg) & 0x1
}

// GPIOTE.TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
func (o *GPIOTE_Type) SetTASKS_SET(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SET[idx].Reg, volatile.LoadUint32(&o.TASKS_SET[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_SET(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SET[idx].Reg) & 0x1
}

// GPIOTE.TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
func (o *GPIOTE_Type) SetTASKS_CLR(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CLR[idx].Reg, volatile.LoadUint32(&o.TASKS_CLR[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_CLR(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CLR[idx].Reg) & 0x1
}

// GPIOTE.SUBSCRIBE_OUT: Description collection: Subscribe configuration for task OUT[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_OUT_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_OUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg)&^(0xf)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_OUT_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg) & 0xf
}
func (o *GPIOTE_Type) SetSUBSCRIBE_OUT_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_OUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_OUT_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.SUBSCRIBE_SET: Description collection: Subscribe configuration for task SET[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_SET_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SET[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg)&^(0xf)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_SET_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg) & 0xf
}
func (o *GPIOTE_Type) SetSUBSCRIBE_SET_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SET[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_SET_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.SUBSCRIBE_CLR: Description collection: Subscribe configuration for task CLR[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_CLR_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLR[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg)&^(0xf)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_CLR_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg) & 0xf
}
func (o *GPIOTE_Type) SetSUBSCRIBE_CLR_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLR[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_CLR_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
func (o *GPIOTE_Type) SetEVENTS_IN(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_IN[idx].Reg, volatile.LoadUint32(&o.EVENTS_IN[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_IN(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_IN[idx].Reg) & 0x1
}

// GPIOTE.EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
func (o *GPIOTE_Type) SetEVENTS_PORT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PORT.Reg, volatile.LoadUint32(&o.EVENTS_PORT.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_PORT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PORT.Reg) & 0x1
}

// GPIOTE.PUBLISH_IN: Description collection: Publish configuration for event IN[n]
func (o *GPIOTE_Type) SetPUBLISH_IN_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_IN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg)&^(0xf)|value)
}
func (o *GPIOTE_Type) GetPUBLISH_IN_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg) & 0xf
}
func (o *GPIOTE_Type) SetPUBLISH_IN_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_IN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetPUBLISH_IN_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.PUBLISH_PORT: Publish configuration for event PORT
func (o *GPIOTE_Type) SetPUBLISH_PORT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PORT.Reg, volatile.LoadUint32(&o.PUBLISH_PORT.Reg)&^(0xf)|value)
}
func (o *GPIOTE_Type) GetPUBLISH_PORT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PORT.Reg) & 0xf
}
func (o *GPIOTE_Type) SetPUBLISH_PORT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PORT.Reg, volatile.LoadUint32(&o.PUBLISH_PORT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetPUBLISH_PORT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PORT.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENSET: Enable interrupt
func (o *GPIOTE_Type) SetINTENSET_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENSET_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENSET_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENSET_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENSET_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENSET_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENSET_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENSET_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENSET_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENSET_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENSET_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENSET_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENSET_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENSET_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENSET_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENSET_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENSET_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENSET_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENCLR: Disable interrupt
func (o *GPIOTE_Type) SetINTENCLR_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENCLR_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENCLR_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENCLR_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENCLR_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENCLR_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENCLR_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENCLR_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENCLR_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENCLR_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENCLR_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENCLR_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENCLR_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENCLR_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENCLR_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENCLR_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENCLR_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENCLR_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000000) >> 31
}

// GPIOTE.CONFIG: Description collection: Configuration for OUT[n], SET[n] and CLR[n] tasks and IN[n] event
func (o *GPIOTE_Type) SetCONFIG_MODE(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x3)|value)
}
func (o *GPIOTE_Type) GetCONFIG_MODE(idx int) uint32 {
	return volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x3
}
func (o *GPIOTE_Type) SetCONFIG_PSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x1f00)|value<<8)
}
func (o *GPIOTE_Type) GetCONFIG_PSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x1f00) >> 8
}
func (o *GPIOTE_Type) SetCONFIG_POLARITY(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIOTE_Type) GetCONFIG_POLARITY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x30000) >> 16
}
func (o *GPIOTE_Type) SetCONFIG_OUTINIT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIOTE_Type) GetCONFIG_OUTINIT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x100000) >> 20
}

// Analog to Digital Converter 0
type SAADC_Type struct {
	TASKS_START               volatile.Register32 // 0x0
	TASKS_SAMPLE              volatile.Register32 // 0x4
	TASKS_STOP                volatile.Register32 // 0x8
	TASKS_CALIBRATEOFFSET     volatile.Register32 // 0xC
	_                         [112]byte
	SUBSCRIBE_START           volatile.Register32 // 0x80
	SUBSCRIBE_SAMPLE          volatile.Register32 // 0x84
	SUBSCRIBE_STOP            volatile.Register32 // 0x88
	SUBSCRIBE_CALIBRATEOFFSET volatile.Register32 // 0x8C
	_                         [112]byte
	EVENTS_STARTED            volatile.Register32     // 0x100
	EVENTS_END                volatile.Register32     // 0x104
	EVENTS_DONE               volatile.Register32     // 0x108
	EVENTS_RESULTDONE         volatile.Register32     // 0x10C
	EVENTS_CALIBRATEDONE      volatile.Register32     // 0x110
	EVENTS_STOPPED            volatile.Register32     // 0x114
	EVENTS_CH                 [8]SAADC_EVENTS_CH_Type // 0x118
	_                         [40]byte
	PUBLISH_STARTED           volatile.Register32      // 0x180
	PUBLISH_END               volatile.Register32      // 0x184
	PUBLISH_DONE              volatile.Register32      // 0x188
	PUBLISH_RESULTDONE        volatile.Register32      // 0x18C
	PUBLISH_CALIBRATEDONE     volatile.Register32      // 0x190
	PUBLISH_STOPPED           volatile.Register32      // 0x194
	PUBLISH_CH                [8]SAADC_PUBLISH_CH_Type // 0x198
	_                         [296]byte
	INTEN                     volatile.Register32 // 0x300
	INTENSET                  volatile.Register32 // 0x304
	INTENCLR                  volatile.Register32 // 0x308
	_                         [244]byte
	STATUS                    volatile.Register32 // 0x400
	_                         [252]byte
	ENABLE                    volatile.Register32 // 0x500
	_                         [12]byte
	CH                        [8]SAADC_CH_Type // 0x510
	_                         [96]byte
	RESOLUTION                volatile.Register32 // 0x5F0
	OVERSAMPLE                volatile.Register32 // 0x5F4
	SAMPLERATE                volatile.Register32 // 0x5F8
	_                         [48]byte
	RESULT                    SAADC_RESULT_Type // 0x62C
}

// SAADC.TASKS_START: Start the ADC and prepare the result buffer in RAM
func (o *SAADC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SAADC.TASKS_SAMPLE: Take one ADC sample, if scan is enabled all channels are sampled
func (o *SAADC_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// SAADC.TASKS_STOP: Stop the ADC and terminate any on-going conversion
func (o *SAADC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SAADC.TASKS_CALIBRATEOFFSET: Starts offset auto-calibration
func (o *SAADC_Type) SetTASKS_CALIBRATEOFFSET(value uint32) {
	volatile.StoreUint32(&o.TASKS_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.TASKS_CALIBRATEOFFSET.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_CALIBRATEOFFSET() uint32 {
	return volatile.LoadUint32(&o.TASKS_CALIBRATEOFFSET.Reg) & 0x1
}

// SAADC.SUBSCRIBE_START: Subscribe configuration for task START
func (o *SAADC_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *SAADC_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// SAADC.SUBSCRIBE_SAMPLE: Subscribe configuration for task SAMPLE
func (o *SAADC_Type) SetSUBSCRIBE_SAMPLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_SAMPLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0xf
}
func (o *SAADC_Type) SetSUBSCRIBE_SAMPLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SAMPLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_SAMPLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SAMPLE.Reg) & 0x80000000) >> 31
}

// SAADC.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *SAADC_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *SAADC_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// SAADC.SUBSCRIBE_CALIBRATEOFFSET: Subscribe configuration for task CALIBRATEOFFSET
func (o *SAADC_Type) SetSUBSCRIBE_CALIBRATEOFFSET_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetSUBSCRIBE_CALIBRATEOFFSET_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg) & 0xf
}
func (o *SAADC_Type) SetSUBSCRIBE_CALIBRATEOFFSET_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetSUBSCRIBE_CALIBRATEOFFSET_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CALIBRATEOFFSET.Reg) & 0x80000000) >> 31
}

// SAADC.EVENTS_STARTED: The ADC has started
func (o *SAADC_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SAADC.EVENTS_END: The ADC has filled up the Result buffer
func (o *SAADC_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SAADC.EVENTS_DONE: A conversion task has been completed. Depending on the mode, multiple conversions might be needed for a result to be transferred to RAM.
func (o *SAADC_Type) SetEVENTS_DONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DONE.Reg, volatile.LoadUint32(&o.EVENTS_DONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_DONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DONE.Reg) & 0x1
}

// SAADC.EVENTS_RESULTDONE: A result is ready to get transferred to RAM.
func (o *SAADC_Type) SetEVENTS_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RESULTDONE.Reg, volatile.LoadUint32(&o.EVENTS_RESULTDONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_RESULTDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RESULTDONE.Reg) & 0x1
}

// SAADC.EVENTS_CALIBRATEDONE: Calibration is complete
func (o *SAADC_Type) SetEVENTS_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.EVENTS_CALIBRATEDONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_CALIBRATEDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CALIBRATEDONE.Reg) & 0x1
}

// SAADC.EVENTS_STOPPED: The ADC has stopped
func (o *SAADC_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SAADC.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *SAADC_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xf
}
func (o *SAADC_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_END: Publish configuration for event END
func (o *SAADC_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xf
}
func (o *SAADC_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_DONE: Publish configuration for event DONE
func (o *SAADC_Type) SetPUBLISH_DONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetPUBLISH_DONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0xf
}
func (o *SAADC_Type) SetPUBLISH_DONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_DONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_RESULTDONE: Publish configuration for event RESULTDONE
func (o *SAADC_Type) SetPUBLISH_RESULTDONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RESULTDONE.Reg, volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetPUBLISH_RESULTDONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg) & 0xf
}
func (o *SAADC_Type) SetPUBLISH_RESULTDONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RESULTDONE.Reg, volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_RESULTDONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RESULTDONE.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_CALIBRATEDONE: Publish configuration for event CALIBRATEDONE
func (o *SAADC_Type) SetPUBLISH_CALIBRATEDONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetPUBLISH_CALIBRATEDONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg) & 0xf
}
func (o *SAADC_Type) SetPUBLISH_CALIBRATEDONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_CALIBRATEDONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CALIBRATEDONE.Reg) & 0x80000000) >> 31
}

// SAADC.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *SAADC_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *SAADC_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// SAADC.INTEN: Enable or disable interrupt
func (o *SAADC_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTEN_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *SAADC_Type) SetINTEN_END(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTEN_END() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTEN_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTEN_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTEN_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTEN_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTEN_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTEN_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTEN_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTEN_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTEN_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTEN_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTEN_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTEN_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTEN_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTEN_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTEN_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTEN_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTEN_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTEN_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTEN_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTEN_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTEN_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTEN_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTEN_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTEN_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTEN_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTEN_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTEN_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTEN_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTEN_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTEN_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTEN_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTEN_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTEN_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTEN_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTEN_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTEN_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTEN_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTEN_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}

// SAADC.INTENSET: Enable interrupt
func (o *SAADC_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTENSET_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SAADC_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTENSET_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTENSET_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTENSET_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTENSET_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTENSET_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTENSET_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTENSET_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTENSET_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTENSET_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTENSET_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTENSET_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTENSET_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTENSET_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTENSET_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTENSET_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTENSET_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTENSET_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTENSET_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTENSET_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTENSET_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTENSET_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTENSET_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTENSET_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTENSET_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTENSET_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTENSET_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTENSET_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTENSET_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTENSET_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTENSET_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTENSET_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTENSET_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTENSET_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTENSET_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTENSET_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTENSET_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTENSET_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTENSET_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}

// SAADC.INTENCLR: Disable interrupt
func (o *SAADC_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTENCLR_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SAADC_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTENCLR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTENCLR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTENCLR_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTENCLR_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTENCLR_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTENCLR_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTENCLR_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTENCLR_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTENCLR_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTENCLR_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTENCLR_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTENCLR_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTENCLR_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTENCLR_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTENCLR_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTENCLR_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTENCLR_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTENCLR_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTENCLR_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTENCLR_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTENCLR_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTENCLR_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTENCLR_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTENCLR_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTENCLR_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTENCLR_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTENCLR_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTENCLR_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTENCLR_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTENCLR_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTENCLR_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTENCLR_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTENCLR_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTENCLR_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTENCLR_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTENCLR_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTENCLR_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTENCLR_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}

// SAADC.STATUS: Status
func (o *SAADC_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}

// SAADC.ENABLE: Enable or disable ADC
func (o *SAADC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// SAADC.RESOLUTION: Resolution configuration
func (o *SAADC_Type) SetRESOLUTION_VAL(value uint32) {
	volatile.StoreUint32(&o.RESOLUTION.Reg, volatile.LoadUint32(&o.RESOLUTION.Reg)&^(0x7)|value)
}
func (o *SAADC_Type) GetRESOLUTION_VAL() uint32 {
	return volatile.LoadUint32(&o.RESOLUTION.Reg) & 0x7
}

// SAADC.OVERSAMPLE: Oversampling configuration. OVERSAMPLE should not be combined with SCAN. The RESOLUTION is applied before averaging, thus for high OVERSAMPLE a higher RESOLUTION should be used.
func (o *SAADC_Type) SetOVERSAMPLE(value uint32) {
	volatile.StoreUint32(&o.OVERSAMPLE.Reg, volatile.LoadUint32(&o.OVERSAMPLE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetOVERSAMPLE() uint32 {
	return volatile.LoadUint32(&o.OVERSAMPLE.Reg) & 0xf
}

// SAADC.SAMPLERATE: Controls normal or continuous sample rate
func (o *SAADC_Type) SetSAMPLERATE_CC(value uint32) {
	volatile.StoreUint32(&o.SAMPLERATE.Reg, volatile.LoadUint32(&o.SAMPLERATE.Reg)&^(0x7ff)|value)
}
func (o *SAADC_Type) GetSAMPLERATE_CC() uint32 {
	return volatile.LoadUint32(&o.SAMPLERATE.Reg) & 0x7ff
}
func (o *SAADC_Type) SetSAMPLERATE_MODE(value uint32) {
	volatile.StoreUint32(&o.SAMPLERATE.Reg, volatile.LoadUint32(&o.SAMPLERATE.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetSAMPLERATE_MODE() uint32 {
	return (volatile.LoadUint32(&o.SAMPLERATE.Reg) & 0x1000) >> 12
}

type SAADC_EVENTS_CH_Type struct {
	LIMITH volatile.Register32 // 0x118
	LIMITL volatile.Register32 // 0x11C
}

// SAADC_EVENTS_CH.LIMITH: Description cluster: Last results is equal or above CH[n].LIMIT.HIGH
func (o *SAADC_EVENTS_CH_Type) SetLIMITH(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0x1)|value)
}
func (o *SAADC_EVENTS_CH_Type) GetLIMITH() uint32 {
	return volatile.LoadUint32(&o.LIMITH.Reg) & 0x1
}

// SAADC_EVENTS_CH.LIMITL: Description cluster: Last results is equal or below CH[n].LIMIT.LOW
func (o *SAADC_EVENTS_CH_Type) SetLIMITL(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0x1)|value)
}
func (o *SAADC_EVENTS_CH_Type) GetLIMITL() uint32 {
	return volatile.LoadUint32(&o.LIMITL.Reg) & 0x1
}

type SAADC_PUBLISH_CH_Type struct {
	LIMITH volatile.Register32 // 0x198
	LIMITL volatile.Register32 // 0x19C
}

// SAADC_PUBLISH_CH.LIMITH: Description cluster: Publish configuration for event CH[n].LIMITH
func (o *SAADC_PUBLISH_CH_Type) SetLIMITH_CHIDX(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0xf)|value)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITH_CHIDX() uint32 {
	return volatile.LoadUint32(&o.LIMITH.Reg) & 0xf
}
func (o *SAADC_PUBLISH_CH_Type) SetLIMITH_EN(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITH_EN() uint32 {
	return (volatile.LoadUint32(&o.LIMITH.Reg) & 0x80000000) >> 31
}

// SAADC_PUBLISH_CH.LIMITL: Description cluster: Publish configuration for event CH[n].LIMITL
func (o *SAADC_PUBLISH_CH_Type) SetLIMITL_CHIDX(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0xf)|value)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITL_CHIDX() uint32 {
	return volatile.LoadUint32(&o.LIMITL.Reg) & 0xf
}
func (o *SAADC_PUBLISH_CH_Type) SetLIMITL_EN(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0x80000000)|value<<31)
}
func (o *SAADC_PUBLISH_CH_Type) GetLIMITL_EN() uint32 {
	return (volatile.LoadUint32(&o.LIMITL.Reg) & 0x80000000) >> 31
}

type SAADC_CH_Type struct {
	PSELP  volatile.Register32 // 0x510
	PSELN  volatile.Register32 // 0x514
	CONFIG volatile.Register32 // 0x518
	LIMIT  volatile.Register32 // 0x51C
}

// SAADC_CH.PSELP: Description cluster: Input positive pin selection for CH[n]
func (o *SAADC_CH_Type) SetPSELP(value uint32) {
	volatile.StoreUint32(&o.PSELP.Reg, volatile.LoadUint32(&o.PSELP.Reg)&^(0x1f)|value)
}
func (o *SAADC_CH_Type) GetPSELP() uint32 {
	return volatile.LoadUint32(&o.PSELP.Reg) & 0x1f
}

// SAADC_CH.PSELN: Description cluster: Input negative pin selection for CH[n]
func (o *SAADC_CH_Type) SetPSELN(value uint32) {
	volatile.StoreUint32(&o.PSELN.Reg, volatile.LoadUint32(&o.PSELN.Reg)&^(0x1f)|value)
}
func (o *SAADC_CH_Type) GetPSELN() uint32 {
	return volatile.LoadUint32(&o.PSELN.Reg) & 0x1f
}

// SAADC_CH.CONFIG: Description cluster: Input configuration for CH[n]
func (o *SAADC_CH_Type) SetCONFIG_RESP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x3)|value)
}
func (o *SAADC_CH_Type) GetCONFIG_RESP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x3
}
func (o *SAADC_CH_Type) SetCONFIG_RESN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x30)|value<<4)
}
func (o *SAADC_CH_Type) GetCONFIG_RESN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x30) >> 4
}
func (o *SAADC_CH_Type) SetCONFIG_GAIN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x700)|value<<8)
}
func (o *SAADC_CH_Type) GetCONFIG_GAIN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x700) >> 8
}
func (o *SAADC_CH_Type) SetCONFIG_REFSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_CH_Type) GetCONFIG_REFSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1000) >> 12
}
func (o *SAADC_CH_Type) SetCONFIG_TACQ(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x70000)|value<<16)
}
func (o *SAADC_CH_Type) GetCONFIG_TACQ() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x70000) >> 16
}
func (o *SAADC_CH_Type) SetCONFIG_MODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_CH_Type) GetCONFIG_MODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100000) >> 20
}
func (o *SAADC_CH_Type) SetCONFIG_BURST(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1000000)|value<<24)
}
func (o *SAADC_CH_Type) GetCONFIG_BURST() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1000000) >> 24
}

// SAADC_CH.LIMIT: Description cluster: High/low limits for event monitoring a channel
func (o *SAADC_CH_Type) SetLIMIT_LOW(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff)|value)
}
func (o *SAADC_CH_Type) GetLIMIT_LOW() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff
}
func (o *SAADC_CH_Type) SetLIMIT_HIGH(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAADC_CH_Type) GetLIMIT_HIGH() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff0000) >> 16
}

type SAADC_RESULT_Type struct {
	PTR    volatile.Register32 // 0x62C
	MAXCNT volatile.Register32 // 0x630
	AMOUNT volatile.Register32 // 0x634
}

// SAADC_RESULT.PTR: Data pointer
func (o *SAADC_RESULT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SAADC_RESULT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SAADC_RESULT.MAXCNT: Maximum number of buffer words to transfer
func (o *SAADC_RESULT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7fff)|value)
}
func (o *SAADC_RESULT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7fff
}

// SAADC_RESULT.AMOUNT: Number of buffer words transferred since last START
func (o *SAADC_RESULT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7fff)|value)
}
func (o *SAADC_RESULT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7fff
}

// Timer/Counter 0
type TIMER_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	TASKS_STOP         volatile.Register32 // 0x4
	TASKS_COUNT        volatile.Register32 // 0x8
	TASKS_CLEAR        volatile.Register32 // 0xC
	TASKS_SHUTDOWN     volatile.Register32 // 0x10
	_                  [44]byte
	TASKS_CAPTURE      [6]volatile.Register32 // 0x40
	_                  [40]byte
	SUBSCRIBE_START    volatile.Register32 // 0x80
	SUBSCRIBE_STOP     volatile.Register32 // 0x84
	SUBSCRIBE_COUNT    volatile.Register32 // 0x88
	SUBSCRIBE_CLEAR    volatile.Register32 // 0x8C
	SUBSCRIBE_SHUTDOWN volatile.Register32 // 0x90
	_                  [44]byte
	SUBSCRIBE_CAPTURE  [6]volatile.Register32 // 0xC0
	_                  [104]byte
	EVENTS_COMPARE     [6]volatile.Register32 // 0x140
	_                  [104]byte
	PUBLISH_COMPARE    [6]volatile.Register32 // 0x1C0
	_                  [40]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [256]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [504]byte
	MODE               volatile.Register32 // 0x504
	BITMODE            volatile.Register32 // 0x508
	_                  [4]byte
	PRESCALER          volatile.Register32    // 0x510
	ONESHOTEN          [6]volatile.Register32 // 0x514
	_                  [20]byte
	CC                 [6]volatile.Register32 // 0x540
}

// TIMER.TASKS_START: Start Timer
func (o *TIMER_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// TIMER.TASKS_STOP: Stop Timer
func (o *TIMER_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TIMER.TASKS_COUNT: Increment Timer (Counter mode only)
func (o *TIMER_Type) SetTASKS_COUNT(value uint32) {
	volatile.StoreUint32(&o.TASKS_COUNT.Reg, volatile.LoadUint32(&o.TASKS_COUNT.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_COUNT() uint32 {
	return volatile.LoadUint32(&o.TASKS_COUNT.Reg) & 0x1
}

// TIMER.TASKS_CLEAR: Clear time
func (o *TIMER_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// TIMER.TASKS_SHUTDOWN: Deprecated register - Shut down timer
func (o *TIMER_Type) SetTASKS_SHUTDOWN(value uint32) {
	volatile.StoreUint32(&o.TASKS_SHUTDOWN.Reg, volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_SHUTDOWN() uint32 {
	return volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg) & 0x1
}

// TIMER.TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
func (o *TIMER_Type) SetTASKS_CAPTURE(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CAPTURE[idx].Reg, volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CAPTURE(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg) & 0x1
}

// TIMER.SUBSCRIBE_START: Subscribe configuration for task START
func (o *TIMER_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *TIMER_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TIMER_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *TIMER_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_COUNT: Subscribe configuration for task COUNT
func (o *TIMER_Type) SetSUBSCRIBE_COUNT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_COUNT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_COUNT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg) & 0xf
}
func (o *TIMER_Type) SetSUBSCRIBE_COUNT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_COUNT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_COUNT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
func (o *TIMER_Type) SetSUBSCRIBE_CLEAR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_CLEAR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0xf
}
func (o *TIMER_Type) SetSUBSCRIBE_CLEAR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_CLEAR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_SHUTDOWN: Deprecated register - Subscribe configuration for task SHUTDOWN
func (o *TIMER_Type) SetSUBSCRIBE_SHUTDOWN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SHUTDOWN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_SHUTDOWN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg) & 0xf
}
func (o *TIMER_Type) SetSUBSCRIBE_SHUTDOWN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SHUTDOWN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_SHUTDOWN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
func (o *TIMER_Type) SetSUBSCRIBE_CAPTURE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_CAPTURE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0xf
}
func (o *TIMER_Type) SetSUBSCRIBE_CAPTURE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_CAPTURE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0x80000000) >> 31
}

// TIMER.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *TIMER_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// TIMER.PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
func (o *TIMER_Type) SetPUBLISH_COMPARE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetPUBLISH_COMPARE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0xf
}
func (o *TIMER_Type) SetPUBLISH_COMPARE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetPUBLISH_COMPARE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0x80000000) >> 31
}

// TIMER.SHORTS: Shortcuts between local events and tasks
func (o *TIMER_Type) SetSHORTS_COMPARE0_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_CLEAR() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *TIMER_Type) SetSHORTS_COMPARE0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200)|value<<9)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200) >> 9
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400)|value<<10)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400) >> 10
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}

// TIMER.INTENSET: Enable interrupt
func (o *TIMER_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENSET_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENSET_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENSET_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENSET_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}

// TIMER.INTENCLR: Disable interrupt
func (o *TIMER_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENCLR_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENCLR_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}

// TIMER.MODE: Timer mode selection
func (o *TIMER_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}

// TIMER.BITMODE: Configure the number of bits used by the TIMER
func (o *TIMER_Type) SetBITMODE(value uint32) {
	volatile.StoreUint32(&o.BITMODE.Reg, volatile.LoadUint32(&o.BITMODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetBITMODE() uint32 {
	return volatile.LoadUint32(&o.BITMODE.Reg) & 0x3
}

// TIMER.PRESCALER: Timer prescaler register
func (o *TIMER_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xf
}

// TIMER.ONESHOTEN: Description collection: Enable one-shot operation for Capture/Compare channel n
func (o *TIMER_Type) SetONESHOTEN(idx int, value uint32) {
	volatile.StoreUint32(&o.ONESHOTEN[idx].Reg, volatile.LoadUint32(&o.ONESHOTEN[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetONESHOTEN(idx int) uint32 {
	return volatile.LoadUint32(&o.ONESHOTEN[idx].Reg) & 0x1
}

// TIMER.CC: Description collection: Capture/Compare register n
func (o *TIMER_Type) SetCC(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, value)
}
func (o *TIMER_Type) GetCC(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg)
}

// Real-time counter 0
type RTC_Type struct {
	TASKS_START          volatile.Register32 // 0x0
	TASKS_STOP           volatile.Register32 // 0x4
	TASKS_CLEAR          volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW     volatile.Register32 // 0xC
	_                    [112]byte
	SUBSCRIBE_START      volatile.Register32 // 0x80
	SUBSCRIBE_STOP       volatile.Register32 // 0x84
	SUBSCRIBE_CLEAR      volatile.Register32 // 0x88
	SUBSCRIBE_TRIGOVRFLW volatile.Register32 // 0x8C
	_                    [112]byte
	EVENTS_TICK          volatile.Register32 // 0x100
	EVENTS_OVRFLW        volatile.Register32 // 0x104
	_                    [56]byte
	EVENTS_COMPARE       [4]volatile.Register32 // 0x140
	_                    [48]byte
	PUBLISH_TICK         volatile.Register32 // 0x180
	PUBLISH_OVRFLW       volatile.Register32 // 0x184
	_                    [56]byte
	PUBLISH_COMPARE      [4]volatile.Register32 // 0x1C0
	_                    [308]byte
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [52]byte
	EVTEN                volatile.Register32 // 0x340
	EVTENSET             volatile.Register32 // 0x344
	EVTENCLR             volatile.Register32 // 0x348
	_                    [440]byte
	COUNTER              volatile.Register32 // 0x504
	PRESCALER            volatile.Register32 // 0x508
	_                    [52]byte
	CC                   [4]volatile.Register32 // 0x540
}

// RTC.TASKS_START: Start RTC counter
func (o *RTC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RTC.TASKS_STOP: Stop RTC counter
func (o *RTC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RTC.TASKS_CLEAR: Clear RTC counter
func (o *RTC_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// RTC.TASKS_TRIGOVRFLW: Set counter to 0xFFFFF0
func (o *RTC_Type) SetTASKS_TRIGOVRFLW(value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_TRIGOVRFLW() uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg) & 0x1
}

// RTC.SUBSCRIBE_START: Subscribe configuration for task START
func (o *RTC_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *RTC_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *RTC_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *RTC_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
func (o *RTC_Type) SetSUBSCRIBE_CLEAR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_CLEAR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0xf
}
func (o *RTC_Type) SetSUBSCRIBE_CLEAR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_CLEAR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_TRIGOVRFLW: Subscribe configuration for task TRIGOVRFLW
func (o *RTC_Type) SetSUBSCRIBE_TRIGOVRFLW_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_TRIGOVRFLW_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg) & 0xf
}
func (o *RTC_Type) SetSUBSCRIBE_TRIGOVRFLW_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_TRIGOVRFLW_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg) & 0x80000000) >> 31
}

// RTC.EVENTS_TICK: Event on counter increment
func (o *RTC_Type) SetEVENTS_TICK(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TICK.Reg, volatile.LoadUint32(&o.EVENTS_TICK.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_TICK() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TICK.Reg) & 0x1
}

// RTC.EVENTS_OVRFLW: Event on counter overflow
func (o *RTC_Type) SetEVENTS_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVENTS_OVRFLW.Reg, volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_OVRFLW() uint32 {
	return volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg) & 0x1
}

// RTC.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *RTC_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// RTC.PUBLISH_TICK: Publish configuration for event TICK
func (o *RTC_Type) SetPUBLISH_TICK_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TICK.Reg, volatile.LoadUint32(&o.PUBLISH_TICK.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetPUBLISH_TICK_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TICK.Reg) & 0xf
}
func (o *RTC_Type) SetPUBLISH_TICK_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TICK.Reg, volatile.LoadUint32(&o.PUBLISH_TICK.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_TICK_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TICK.Reg) & 0x80000000) >> 31
}

// RTC.PUBLISH_OVRFLW: Publish configuration for event OVRFLW
func (o *RTC_Type) SetPUBLISH_OVRFLW_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_OVRFLW.Reg, volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetPUBLISH_OVRFLW_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg) & 0xf
}
func (o *RTC_Type) SetPUBLISH_OVRFLW_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_OVRFLW.Reg, volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_OVRFLW_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg) & 0x80000000) >> 31
}

// RTC.PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
func (o *RTC_Type) SetPUBLISH_COMPARE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetPUBLISH_COMPARE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0xf
}
func (o *RTC_Type) SetPUBLISH_COMPARE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_COMPARE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0x80000000) >> 31
}

// RTC.INTENSET: Enable interrupt
func (o *RTC_Type) SetINTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetINTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// RTC.INTENCLR: Disable interrupt
func (o *RTC_Type) SetINTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetINTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// RTC.EVTEN: Enable or disable event routing
func (o *RTC_Type) SetEVTEN_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTEN_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTEN.Reg) & 0x1
}
func (o *RTC_Type) SetEVTEN_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTEN_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTEN_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTEN_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTEN_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTEN_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTEN_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTEN_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTEN_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTEN_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x80000) >> 19
}

// RTC.EVTENSET: Enable event routing
func (o *RTC_Type) SetEVTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x80000) >> 19
}

// RTC.EVTENCLR: Disable event routing
func (o *RTC_Type) SetEVTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x80000) >> 19
}

// RTC.COUNTER: Current counter value
func (o *RTC_Type) SetCOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, volatile.LoadUint32(&o.COUNTER.Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg) & 0xffffff
}

// RTC.PRESCALER: 12-bit prescaler for counter frequency (32768/(PRESCALER+1)). Must be written when RTC is stopped.
func (o *RTC_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xfff
}

// RTC.CC: Description collection: Compare register n
func (o *RTC_Type) SetCC_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, volatile.LoadUint32(&o.CC[idx].Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCC_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg) & 0xffffff
}

// Distributed Programmable Peripheral Interconnect Controller 0
type DPPIC_Type struct {
	TASKS_CHG     [6]DPPIC_TASKS_CHG_Type // 0x0
	_             [80]byte
	SUBSCRIBE_CHG [6]DPPIC_SUBSCRIBE_CHG_Type // 0x80
	_             [1104]byte
	CHEN          volatile.Register32 // 0x500
	CHENSET       volatile.Register32 // 0x504
	CHENCLR       volatile.Register32 // 0x508
	_             [756]byte
	CHG           [6]volatile.Register32 // 0x800
}

// DPPIC.CHEN: Channel enable register
func (o *DPPIC_Type) SetCHEN_CH0(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHEN_CH0() uint32 {
	return volatile.LoadUint32(&o.CHEN.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHEN_CH1(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHEN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHEN_CH2(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHEN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHEN_CH3(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHEN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHEN_CH4(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHEN_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHEN_CH5(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHEN_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHEN_CH6(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHEN_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHEN_CH7(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHEN_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHEN_CH8(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHEN_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHEN_CH9(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHEN_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHEN_CH10(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHEN_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHEN_CH11(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHEN_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHEN_CH12(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHEN_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHEN_CH13(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHEN_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHEN_CH14(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHEN_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHEN_CH15(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHEN_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8000) >> 15
}

// DPPIC.CHENSET: Channel enable set register
func (o *DPPIC_Type) SetCHENSET_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHENSET_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENSET.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHENSET_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHENSET_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHENSET_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHENSET_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHENSET_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHENSET_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHENSET_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHENSET_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHENSET_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHENSET_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHENSET_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHENSET_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHENSET_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHENSET_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHENSET_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHENSET_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHENSET_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHENSET_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHENSET_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHENSET_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHENSET_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHENSET_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHENSET_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHENSET_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHENSET_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHENSET_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHENSET_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHENSET_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHENSET_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHENSET_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8000) >> 15
}

// DPPIC.CHENCLR: Channel enable clear register
func (o *DPPIC_Type) SetCHENCLR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHENCLR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHENCLR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHENCLR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHENCLR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHENCLR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHENCLR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHENCLR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHENCLR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHENCLR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHENCLR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHENCLR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHENCLR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHENCLR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHENCLR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHENCLR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHENCLR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHENCLR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHENCLR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHENCLR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHENCLR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHENCLR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHENCLR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHENCLR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHENCLR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHENCLR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHENCLR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHENCLR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHENCLR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHENCLR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHENCLR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHENCLR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8000) >> 15
}

// DPPIC.CHG: Description collection: Channel group n Note: Writes to this register is ignored if either SUBSCRIBE_CHG[n].EN/DIS are enabled.
func (o *DPPIC_Type) SetCHG_CH0(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHG_CH0(idx int) uint32 {
	return volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1
}
func (o *DPPIC_Type) SetCHG_CH1(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHG_CH1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHG_CH2(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHG_CH2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHG_CH3(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHG_CH3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHG_CH4(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHG_CH4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHG_CH5(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHG_CH5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHG_CH6(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHG_CH6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHG_CH7(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHG_CH7(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHG_CH8(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHG_CH8(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHG_CH9(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHG_CH9(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHG_CH10(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHG_CH10(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHG_CH11(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHG_CH11(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHG_CH12(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHG_CH12(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHG_CH13(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHG_CH13(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHG_CH14(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHG_CH14(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHG_CH15(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHG_CH15(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8000) >> 15
}

type DPPIC_TASKS_CHG_Type struct {
	EN  volatile.Register32 // 0x0
	DIS volatile.Register32 // 0x4
}

// DPPIC_TASKS_CHG.EN: Description cluster: Enable channel group n
func (o *DPPIC_TASKS_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DPPIC_TASKS_CHG_Type) GetEN() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DPPIC_TASKS_CHG.DIS: Description cluster: Disable channel group n
func (o *DPPIC_TASKS_CHG_Type) SetDIS(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *DPPIC_TASKS_CHG_Type) GetDIS() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}

type DPPIC_SUBSCRIBE_CHG_Type struct {
	EN  volatile.Register32 // 0x80
	DIS volatile.Register32 // 0x84
}

// DPPIC_SUBSCRIBE_CHG.EN: Description cluster: Subscribe configuration for task CHG[n].EN
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0xf)|value)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0xf
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetEN() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x80000000) >> 31
}

// DPPIC_SUBSCRIBE_CHG.DIS: Description cluster: Subscribe configuration for task CHG[n].DIS
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetDIS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0xf)|value)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetDIS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0xf
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetDIS_EN(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetDIS_EN() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x80000000) >> 31
}

// Watchdog Timer 0
type WDT_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	_               [124]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	_               [124]byte
	EVENTS_TIMEOUT  volatile.Register32 // 0x100
	_               [124]byte
	PUBLISH_TIMEOUT volatile.Register32 // 0x180
	_               [384]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [244]byte
	RUNSTATUS       volatile.Register32 // 0x400
	REQSTATUS       volatile.Register32 // 0x404
	_               [252]byte
	CRV             volatile.Register32 // 0x504
	RREN            volatile.Register32 // 0x508
	CONFIG          volatile.Register32 // 0x50C
	_               [240]byte
	RR              [8]volatile.Register32 // 0x600
}

// WDT.TASKS_START: Start the watchdog
func (o *WDT_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// WDT.SUBSCRIBE_START: Subscribe configuration for task START
func (o *WDT_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *WDT_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// WDT.EVENTS_TIMEOUT: Watchdog timeout
func (o *WDT_Type) SetEVENTS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TIMEOUT.Reg, volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEVENTS_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg) & 0x1
}

// WDT.PUBLISH_TIMEOUT: Publish configuration for event TIMEOUT
func (o *WDT_Type) SetPUBLISH_TIMEOUT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TIMEOUT.Reg, volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetPUBLISH_TIMEOUT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg) & 0xf
}
func (o *WDT_Type) SetPUBLISH_TIMEOUT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TIMEOUT.Reg, volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetPUBLISH_TIMEOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg) & 0x80000000) >> 31
}

// WDT.INTENSET: Enable interrupt
func (o *WDT_Type) SetINTENSET_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// WDT.INTENCLR: Disable interrupt
func (o *WDT_Type) SetINTENCLR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// WDT.RUNSTATUS: Run status
func (o *WDT_Type) SetRUNSTATUS_RUNSTATUSWDT(value uint32) {
	volatile.StoreUint32(&o.RUNSTATUS.Reg, volatile.LoadUint32(&o.RUNSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRUNSTATUS_RUNSTATUSWDT() uint32 {
	return volatile.LoadUint32(&o.RUNSTATUS.Reg) & 0x1
}

// WDT.REQSTATUS: Request status
func (o *WDT_Type) SetREQSTATUS_RR0(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetREQSTATUS_RR0() uint32 {
	return volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x1
}
func (o *WDT_Type) SetREQSTATUS_RR1(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetREQSTATUS_RR1() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetREQSTATUS_RR2(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetREQSTATUS_RR2() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetREQSTATUS_RR3(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetREQSTATUS_RR3() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetREQSTATUS_RR4(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetREQSTATUS_RR4() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetREQSTATUS_RR5(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetREQSTATUS_RR5() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetREQSTATUS_RR6(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetREQSTATUS_RR6() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetREQSTATUS_RR7(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetREQSTATUS_RR7() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x80) >> 7
}

// WDT.CRV: Counter reload value
func (o *WDT_Type) SetCRV(value uint32) {
	volatile.StoreUint32(&o.CRV.Reg, value)
}
func (o *WDT_Type) GetCRV() uint32 {
	return volatile.LoadUint32(&o.CRV.Reg)
}

// WDT.RREN: Enable register for reload request registers
func (o *WDT_Type) SetRREN_RR0(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRREN_RR0() uint32 {
	return volatile.LoadUint32(&o.RREN.Reg) & 0x1
}
func (o *WDT_Type) SetRREN_RR1(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetRREN_RR1() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetRREN_RR2(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetRREN_RR2() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetRREN_RR3(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetRREN_RR3() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetRREN_RR4(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetRREN_RR4() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetRREN_RR5(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetRREN_RR5() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetRREN_RR6(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetRREN_RR6() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetRREN_RR7(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetRREN_RR7() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration register
func (o *WDT_Type) SetCONFIG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetCONFIG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *WDT_Type) SetCONFIG_HALT(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetCONFIG_HALT() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x8) >> 3
}

// WDT.RR: Description collection: Reload request n
func (o *WDT_Type) SetRR(idx int, value uint32) {
	volatile.StoreUint32(&o.RR[idx].Reg, value)
}
func (o *WDT_Type) GetRR(idx int) uint32 {
	return volatile.LoadUint32(&o.RR[idx].Reg)
}

// Event generator unit 0
type EGU_Type struct {
	TASKS_TRIGGER     [16]volatile.Register32 // 0x0
	_                 [64]byte
	SUBSCRIBE_TRIGGER [16]volatile.Register32 // 0x80
	_                 [64]byte
	EVENTS_TRIGGERED  [16]volatile.Register32 // 0x100
	_                 [64]byte
	PUBLISH_TRIGGERED [16]volatile.Register32 // 0x180
	_                 [320]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
}

// EGU.TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
func (o *EGU_Type) SetTASKS_TRIGGER(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGGER[idx].Reg, volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetTASKS_TRIGGER(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg) & 0x1
}

// EGU.SUBSCRIBE_TRIGGER: Description collection: Subscribe configuration for task TRIGGER[n]
func (o *EGU_Type) SetSUBSCRIBE_TRIGGER_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg)&^(0xf)|value)
}
func (o *EGU_Type) GetSUBSCRIBE_TRIGGER_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg) & 0xf
}
func (o *EGU_Type) SetSUBSCRIBE_TRIGGER_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EGU_Type) GetSUBSCRIBE_TRIGGER_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg) & 0x80000000) >> 31
}

// EGU.EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
func (o *EGU_Type) SetEVENTS_TRIGGERED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetEVENTS_TRIGGERED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg) & 0x1
}

// EGU.PUBLISH_TRIGGERED: Description collection: Publish configuration for event TRIGGERED[n]
func (o *EGU_Type) SetPUBLISH_TRIGGERED_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg)&^(0xf)|value)
}
func (o *EGU_Type) GetPUBLISH_TRIGGERED_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg) & 0xf
}
func (o *EGU_Type) SetPUBLISH_TRIGGERED_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EGU_Type) GetPUBLISH_TRIGGERED_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg) & 0x80000000) >> 31
}

// EGU.INTEN: Enable or disable interrupt
func (o *EGU_Type) SetINTEN_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTEN_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *EGU_Type) SetINTEN_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTEN_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTEN_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTEN_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTEN_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTEN_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTEN_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTEN_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTEN_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTEN_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTEN_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTEN_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTEN_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTEN_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTEN_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTEN_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTEN_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTEN_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTEN_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTEN_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTEN_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTEN_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTEN_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTEN_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTEN_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTEN_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTEN_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTEN_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTEN_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTEN_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}

// EGU.INTENSET: Enable interrupt
func (o *EGU_Type) SetINTENSET_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENSET_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENSET_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENSET_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENSET_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENSET_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENSET_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENSET_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENSET_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENSET_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENSET_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENSET_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENSET_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENSET_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// EGU.INTENCLR: Disable interrupt
func (o *EGU_Type) SetINTENCLR_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// Pulse width modulation unit 0
type PWM_Type struct {
	_                    [4]byte
	TASKS_STOP           volatile.Register32    // 0x4
	TASKS_SEQSTART       [2]volatile.Register32 // 0x8
	TASKS_NEXTSTEP       volatile.Register32    // 0x10
	_                    [112]byte
	SUBSCRIBE_STOP       volatile.Register32    // 0x84
	SUBSCRIBE_SEQSTART   [2]volatile.Register32 // 0x88
	SUBSCRIBE_NEXTSTEP   volatile.Register32    // 0x90
	_                    [112]byte
	EVENTS_STOPPED       volatile.Register32    // 0x104
	EVENTS_SEQSTARTED    [2]volatile.Register32 // 0x108
	EVENTS_SEQEND        [2]volatile.Register32 // 0x110
	EVENTS_PWMPERIODEND  volatile.Register32    // 0x118
	EVENTS_LOOPSDONE     volatile.Register32    // 0x11C
	_                    [100]byte
	PUBLISH_STOPPED      volatile.Register32    // 0x184
	PUBLISH_SEQSTARTED   [2]volatile.Register32 // 0x188
	PUBLISH_SEQEND       [2]volatile.Register32 // 0x190
	PUBLISH_PWMPERIODEND volatile.Register32    // 0x198
	PUBLISH_LOOPSDONE    volatile.Register32    // 0x19C
	_                    [96]byte
	SHORTS               volatile.Register32 // 0x200
	_                    [252]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [500]byte
	ENABLE               volatile.Register32 // 0x500
	MODE                 volatile.Register32 // 0x504
	COUNTERTOP           volatile.Register32 // 0x508
	PRESCALER            volatile.Register32 // 0x50C
	DECODER              volatile.Register32 // 0x510
	LOOP                 volatile.Register32 // 0x514
	_                    [8]byte
	SEQ                  [2]PWM_SEQ_Type // 0x520
	PSEL                 PWM_PSEL_Type   // 0x560
}

// PWM.TASKS_STOP: Stops PWM pulse generation on all channels at the end of current PWM period, and stops sequence playback
func (o *PWM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// PWM.TASKS_SEQSTART: Description collection: Loads the first PWM value on all enabled channels from sequence n, and starts playing that sequence at the rate defined in SEQ[n]REFRESH and/or DECODER.MODE. Causes PWM generation to start if not running.
func (o *PWM_Type) SetTASKS_SEQSTART(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SEQSTART[idx].Reg, volatile.LoadUint32(&o.TASKS_SEQSTART[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_SEQSTART(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SEQSTART[idx].Reg) & 0x1
}

// PWM.TASKS_NEXTSTEP: Steps by one value in the current sequence on all enabled channels if DECODER.MODE=NextStep. Does not cause PWM generation to start if not running.
func (o *PWM_Type) SetTASKS_NEXTSTEP(value uint32) {
	volatile.StoreUint32(&o.TASKS_NEXTSTEP.Reg, volatile.LoadUint32(&o.TASKS_NEXTSTEP.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_NEXTSTEP() uint32 {
	return volatile.LoadUint32(&o.TASKS_NEXTSTEP.Reg) & 0x1
}

// PWM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *PWM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *PWM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// PWM.SUBSCRIBE_SEQSTART: Description collection: Subscribe configuration for task SEQSTART[n]
func (o *PWM_Type) SetSUBSCRIBE_SEQSTART_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSUBSCRIBE_SEQSTART_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg) & 0xf
}
func (o *PWM_Type) SetSUBSCRIBE_SEQSTART_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetSUBSCRIBE_SEQSTART_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SEQSTART[idx].Reg) & 0x80000000) >> 31
}

// PWM.SUBSCRIBE_NEXTSTEP: Subscribe configuration for task NEXTSTEP
func (o *PWM_Type) SetSUBSCRIBE_NEXTSTEP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_NEXTSTEP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSUBSCRIBE_NEXTSTEP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg) & 0xf
}
func (o *PWM_Type) SetSUBSCRIBE_NEXTSTEP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_NEXTSTEP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetSUBSCRIBE_NEXTSTEP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_NEXTSTEP.Reg) & 0x80000000) >> 31
}

// PWM.EVENTS_STOPPED: Response to STOP task, emitted when PWM pulses are no longer generated
func (o *PWM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// PWM.EVENTS_SEQSTARTED: Description collection: First PWM period started on sequence n
func (o *PWM_Type) SetEVENTS_SEQSTARTED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.EVENTS_SEQSTARTED[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_SEQSTARTED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_SEQSTARTED[idx].Reg) & 0x1
}

// PWM.EVENTS_SEQEND: Description collection: Emitted at end of every sequence n, when last value from RAM has been applied to wave counter
func (o *PWM_Type) SetEVENTS_SEQEND(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_SEQEND[idx].Reg, volatile.LoadUint32(&o.EVENTS_SEQEND[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_SEQEND(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_SEQEND[idx].Reg) & 0x1
}

// PWM.EVENTS_PWMPERIODEND: Emitted at the end of each PWM period
func (o *PWM_Type) SetEVENTS_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PWMPERIODEND.Reg, volatile.LoadUint32(&o.EVENTS_PWMPERIODEND.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_PWMPERIODEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PWMPERIODEND.Reg) & 0x1
}

// PWM.EVENTS_LOOPSDONE: Concatenated sequences have been played the amount of times defined in LOOP.CNT
func (o *PWM_Type) SetEVENTS_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LOOPSDONE.Reg, volatile.LoadUint32(&o.EVENTS_LOOPSDONE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_LOOPSDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LOOPSDONE.Reg) & 0x1
}

// PWM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *PWM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *PWM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_SEQSTARTED: Description collection: Publish configuration for event SEQSTARTED[n]
func (o *PWM_Type) SetPUBLISH_SEQSTARTED_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetPUBLISH_SEQSTARTED_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg) & 0xf
}
func (o *PWM_Type) SetPUBLISH_SEQSTARTED_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_SEQSTARTED_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SEQSTARTED[idx].Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_SEQEND: Description collection: Publish configuration for event SEQEND[n]
func (o *PWM_Type) SetPUBLISH_SEQEND_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQEND[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetPUBLISH_SEQEND_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg) & 0xf
}
func (o *PWM_Type) SetPUBLISH_SEQEND_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SEQEND[idx].Reg, volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_SEQEND_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SEQEND[idx].Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_PWMPERIODEND: Publish configuration for event PWMPERIODEND
func (o *PWM_Type) SetPUBLISH_PWMPERIODEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PWMPERIODEND.Reg, volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetPUBLISH_PWMPERIODEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg) & 0xf
}
func (o *PWM_Type) SetPUBLISH_PWMPERIODEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PWMPERIODEND.Reg, volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_PWMPERIODEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PWMPERIODEND.Reg) & 0x80000000) >> 31
}

// PWM.PUBLISH_LOOPSDONE: Publish configuration for event LOOPSDONE
func (o *PWM_Type) SetPUBLISH_LOOPSDONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LOOPSDONE.Reg, volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetPUBLISH_LOOPSDONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg) & 0xf
}
func (o *PWM_Type) SetPUBLISH_LOOPSDONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LOOPSDONE.Reg, volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetPUBLISH_LOOPSDONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LOOPSDONE.Reg) & 0x80000000) >> 31
}

// PWM.SHORTS: Shortcuts between local events and tasks
func (o *PWM_Type) SetSHORTS_SEQEND0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSHORTS_SEQEND0_STOP() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *PWM_Type) SetSHORTS_SEQEND1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSHORTS_SEQEND1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_SEQSTART0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_SEQSTART0() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_SEQSTART1(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_SEQSTART1() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// PWM.INTEN: Enable or disable interrupt
func (o *PWM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTEN_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTEN_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTEN_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTEN_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTEN_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTEN_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTEN_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTEN_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTEN_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTEN_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTEN_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTEN_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}

// PWM.INTENSET: Enable interrupt
func (o *PWM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTENSET_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTENSET_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTENSET_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTENSET_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTENSET_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTENSET_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTENSET_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTENSET_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTENSET_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTENSET_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTENSET_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTENSET_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}

// PWM.INTENCLR: Disable interrupt
func (o *PWM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTENCLR_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTENCLR_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTENCLR_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTENCLR_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTENCLR_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTENCLR_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTENCLR_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTENCLR_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTENCLR_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTENCLR_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTENCLR_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTENCLR_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}

// PWM.ENABLE: PWM module enable register
func (o *PWM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// PWM.MODE: Selects operating mode of the wave counter
func (o *PWM_Type) SetMODE_UPDOWN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetMODE_UPDOWN() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// PWM.COUNTERTOP: Value up to which the pulse generator counter counts
func (o *PWM_Type) SetCOUNTERTOP(value uint32) {
	volatile.StoreUint32(&o.COUNTERTOP.Reg, volatile.LoadUint32(&o.COUNTERTOP.Reg)&^(0x7fff)|value)
}
func (o *PWM_Type) GetCOUNTERTOP() uint32 {
	return volatile.LoadUint32(&o.COUNTERTOP.Reg) & 0x7fff
}

// PWM.PRESCALER: Configuration for PWM_CLK
func (o *PWM_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0x7)|value)
}
func (o *PWM_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0x7
}

// PWM.DECODER: Configuration of the decoder
func (o *PWM_Type) SetDECODER_LOAD(value uint32) {
	volatile.StoreUint32(&o.DECODER.Reg, volatile.LoadUint32(&o.DECODER.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetDECODER_LOAD() uint32 {
	return volatile.LoadUint32(&o.DECODER.Reg) & 0x3
}
func (o *PWM_Type) SetDECODER_MODE(value uint32) {
	volatile.StoreUint32(&o.DECODER.Reg, volatile.LoadUint32(&o.DECODER.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetDECODER_MODE() uint32 {
	return (volatile.LoadUint32(&o.DECODER.Reg) & 0x100) >> 8
}

// PWM.LOOP: Number of playbacks of a loop
func (o *PWM_Type) SetLOOP_CNT(value uint32) {
	volatile.StoreUint32(&o.LOOP.Reg, volatile.LoadUint32(&o.LOOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetLOOP_CNT() uint32 {
	return volatile.LoadUint32(&o.LOOP.Reg) & 0xffff
}

type PWM_SEQ_Type struct {
	PTR      volatile.Register32 // 0x520
	CNT      volatile.Register32 // 0x524
	REFRESH  volatile.Register32 // 0x528
	ENDDELAY volatile.Register32 // 0x52C
	_        [16]byte
}

// PWM_SEQ.PTR: Description cluster: Beginning address in RAM of this sequence
func (o *PWM_SEQ_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *PWM_SEQ_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// PWM_SEQ.CNT: Description cluster: Number of values (duty cycles) in this sequence
func (o *PWM_SEQ_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x7fff)|value)
}
func (o *PWM_SEQ_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0x7fff
}

// PWM_SEQ.REFRESH: Description cluster: Number of additional PWM periods between samples loaded into compare register
func (o *PWM_SEQ_Type) SetREFRESH_CNT(value uint32) {
	volatile.StoreUint32(&o.REFRESH.Reg, volatile.LoadUint32(&o.REFRESH.Reg)&^(0xffffff)|value)
}
func (o *PWM_SEQ_Type) GetREFRESH_CNT() uint32 {
	return volatile.LoadUint32(&o.REFRESH.Reg) & 0xffffff
}

// PWM_SEQ.ENDDELAY: Description cluster: Time added after the sequence
func (o *PWM_SEQ_Type) SetENDDELAY_CNT(value uint32) {
	volatile.StoreUint32(&o.ENDDELAY.Reg, volatile.LoadUint32(&o.ENDDELAY.Reg)&^(0xffffff)|value)
}
func (o *PWM_SEQ_Type) GetENDDELAY_CNT() uint32 {
	return volatile.LoadUint32(&o.ENDDELAY.Reg) & 0xffffff
}

type PWM_PSEL_Type struct {
	OUT [4]volatile.Register32 // 0x560
}

// Pulse Density Modulation (Digital Microphone) Interface 0
type PDM_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_STARTED  volatile.Register32 // 0x100
	EVENTS_STOPPED  volatile.Register32 // 0x104
	EVENTS_END      volatile.Register32 // 0x108
	_               [116]byte
	PUBLISH_STARTED volatile.Register32 // 0x180
	PUBLISH_STOPPED volatile.Register32 // 0x184
	PUBLISH_END     volatile.Register32 // 0x188
	_               [372]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [500]byte
	ENABLE          volatile.Register32 // 0x500
	PDMCLKCTRL      volatile.Register32 // 0x504
	MODE            volatile.Register32 // 0x508
	_               [12]byte
	GAINL           volatile.Register32 // 0x518
	GAINR           volatile.Register32 // 0x51C
	RATIO           volatile.Register32 // 0x520
	_               [28]byte
	PSEL            PDM_PSEL_Type // 0x540
	_               [24]byte
	SAMPLE          PDM_SAMPLE_Type // 0x560
}

// PDM.TASKS_START: Starts continuous PDM transfer
func (o *PDM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// PDM.TASKS_STOP: Stops PDM transfer
func (o *PDM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// PDM.SUBSCRIBE_START: Subscribe configuration for task START
func (o *PDM_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *PDM_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *PDM_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// PDM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *PDM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *PDM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *PDM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// PDM.EVENTS_STARTED: PDM transfer has started
func (o *PDM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// PDM.EVENTS_STOPPED: PDM transfer has finished
func (o *PDM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// PDM.EVENTS_END: The PDM has written the last sample specified by SAMPLE.MAXCNT (or the last sample after a STOP task has been received) to Data RAM
func (o *PDM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// PDM.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *PDM_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xf)|value)
}
func (o *PDM_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xf
}
func (o *PDM_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// PDM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *PDM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *PDM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *PDM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// PDM.PUBLISH_END: Publish configuration for event END
func (o *PDM_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xf)|value)
}
func (o *PDM_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xf
}
func (o *PDM_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// PDM.INTEN: Enable or disable interrupt
func (o *PDM_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTEN_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *PDM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTEN_END(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTEN_END() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// PDM.INTENSET: Enable interrupt
func (o *PDM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTENSET_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *PDM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// PDM.INTENCLR: Disable interrupt
func (o *PDM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTENCLR_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *PDM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// PDM.ENABLE: PDM module enable register
func (o *PDM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// PDM.PDMCLKCTRL: PDM clock generator control
func (o *PDM_Type) SetPDMCLKCTRL(value uint32) {
	volatile.StoreUint32(&o.PDMCLKCTRL.Reg, value)
}
func (o *PDM_Type) GetPDMCLKCTRL() uint32 {
	return volatile.LoadUint32(&o.PDMCLKCTRL.Reg)
}

// PDM.MODE: Defines the routing of the connected PDM microphones' signals
func (o *PDM_Type) SetMODE_OPERATION(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetMODE_OPERATION() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *PDM_Type) SetMODE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetMODE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x2) >> 1
}

// PDM.GAINL: Left output gain adjustment
func (o *PDM_Type) SetGAINL(value uint32) {
	volatile.StoreUint32(&o.GAINL.Reg, volatile.LoadUint32(&o.GAINL.Reg)&^(0x7f)|value)
}
func (o *PDM_Type) GetGAINL() uint32 {
	return volatile.LoadUint32(&o.GAINL.Reg) & 0x7f
}

// PDM.GAINR: Right output gain adjustment
func (o *PDM_Type) SetGAINR(value uint32) {
	volatile.StoreUint32(&o.GAINR.Reg, volatile.LoadUint32(&o.GAINR.Reg)&^(0x7f)|value)
}
func (o *PDM_Type) GetGAINR() uint32 {
	return volatile.LoadUint32(&o.GAINR.Reg) & 0x7f
}

// PDM.RATIO: Selects the ratio between PDM_CLK and output sample rate. Change PDMCLKCTRL accordingly.
func (o *PDM_Type) SetRATIO(value uint32) {
	volatile.StoreUint32(&o.RATIO.Reg, volatile.LoadUint32(&o.RATIO.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetRATIO() uint32 {
	return volatile.LoadUint32(&o.RATIO.Reg) & 0x1
}

type PDM_PSEL_Type struct {
	CLK volatile.Register32 // 0x540
	DIN volatile.Register32 // 0x544
}

// PDM_PSEL.CLK: Pin number configuration for PDM CLK signal
func (o *PDM_PSEL_Type) SetCLK_PIN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1f)|value)
}
func (o *PDM_PSEL_Type) GetCLK_PIN() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1f
}
func (o *PDM_PSEL_Type) SetCLK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_PSEL_Type) GetCLK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x80000000) >> 31
}

// PDM_PSEL.DIN: Pin number configuration for PDM DIN signal
func (o *PDM_PSEL_Type) SetDIN_PIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x1f)|value)
}
func (o *PDM_PSEL_Type) GetDIN_PIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg) & 0x1f
}
func (o *PDM_PSEL_Type) SetDIN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_PSEL_Type) GetDIN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.DIN.Reg) & 0x80000000) >> 31
}

type PDM_SAMPLE_Type struct {
	PTR    volatile.Register32 // 0x560
	MAXCNT volatile.Register32 // 0x564
}

// PDM_SAMPLE.PTR: RAM address pointer to write samples to with EasyDMA
func (o *PDM_SAMPLE_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *PDM_SAMPLE_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// PDM_SAMPLE.MAXCNT: Number of samples to allocate memory for in EasyDMA mode
func (o *PDM_SAMPLE_Type) SetMAXCNT_BUFFSIZE(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7fff)|value)
}
func (o *PDM_SAMPLE_Type) GetMAXCNT_BUFFSIZE() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7fff
}

// Inter-IC Sound 0
type I2S_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	_                [120]byte
	SUBSCRIBE_START  volatile.Register32 // 0x80
	SUBSCRIBE_STOP   volatile.Register32 // 0x84
	_                [124]byte
	EVENTS_RXPTRUPD  volatile.Register32 // 0x104
	EVENTS_STOPPED   volatile.Register32 // 0x108
	_                [8]byte
	EVENTS_TXPTRUPD  volatile.Register32 // 0x114
	_                [108]byte
	PUBLISH_RXPTRUPD volatile.Register32 // 0x184
	PUBLISH_STOPPED  volatile.Register32 // 0x188
	_                [8]byte
	PUBLISH_TXPTRUPD volatile.Register32 // 0x194
	_                [360]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [500]byte
	ENABLE           volatile.Register32 // 0x500
	CONFIG           I2S_CONFIG_Type     // 0x504
	_                [12]byte
	RXD              I2S_RXD_Type // 0x538
	_                [4]byte
	TXD              I2S_TXD_Type // 0x540
	_                [12]byte
	RXTXD            I2S_RXTXD_Type // 0x550
	_                [12]byte
	PSEL             I2S_PSEL_Type // 0x560
}

// I2S.TASKS_START: Starts continuous I2S transfer. Also starts MCK generator when this is enabled.
func (o *I2S_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// I2S.TASKS_STOP: Stops I2S transfer. Also stops MCK generator. Triggering this task will cause the STOPPED event to be generated.
func (o *I2S_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// I2S.SUBSCRIBE_START: Subscribe configuration for task START
func (o *I2S_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xf)|value)
}
func (o *I2S_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xf
}
func (o *I2S_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// I2S.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *I2S_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xf)|value)
}
func (o *I2S_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xf
}
func (o *I2S_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// I2S.EVENTS_RXPTRUPD: The RXD.PTR register has been copied to internal double-buffers. When the I2S module is started and RX is enabled, this event will be generated for every RXTXD.MAXCNT words that are received on the SDIN pin.
func (o *I2S_Type) SetEVENTS_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXPTRUPD.Reg, volatile.LoadUint32(&o.EVENTS_RXPTRUPD.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_RXPTRUPD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXPTRUPD.Reg) & 0x1
}

// I2S.EVENTS_STOPPED: I2S transfer stopped.
func (o *I2S_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// I2S.EVENTS_TXPTRUPD: The TDX.PTR register has been copied to internal double-buffers. When the I2S module is started and TX is enabled, this event will be generated for every RXTXD.MAXCNT words that are sent on the SDOUT pin.
func (o *I2S_Type) SetEVENTS_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXPTRUPD.Reg, volatile.LoadUint32(&o.EVENTS_TXPTRUPD.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_TXPTRUPD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXPTRUPD.Reg) & 0x1
}

// I2S.PUBLISH_RXPTRUPD: Publish configuration for event RXPTRUPD
func (o *I2S_Type) SetPUBLISH_RXPTRUPD_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg)&^(0xf)|value)
}
func (o *I2S_Type) GetPUBLISH_RXPTRUPD_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg) & 0xf
}
func (o *I2S_Type) SetPUBLISH_RXPTRUPD_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_RXPTRUPD_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXPTRUPD.Reg) & 0x80000000) >> 31
}

// I2S.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *I2S_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xf)|value)
}
func (o *I2S_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xf
}
func (o *I2S_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// I2S.PUBLISH_TXPTRUPD: Publish configuration for event TXPTRUPD
func (o *I2S_Type) SetPUBLISH_TXPTRUPD_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg)&^(0xf)|value)
}
func (o *I2S_Type) GetPUBLISH_TXPTRUPD_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg) & 0xf
}
func (o *I2S_Type) SetPUBLISH_TXPTRUPD_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXPTRUPD.Reg, volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetPUBLISH_TXPTRUPD_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXPTRUPD.Reg) & 0x80000000) >> 31
}

// I2S.INTEN: Enable or disable interrupt
func (o *I2S_Type) SetINTEN_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTEN_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTEN_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTEN_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}

// I2S.INTENSET: Enable interrupt
func (o *I2S_Type) SetINTENSET_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENSET_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTENSET_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENSET_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}

// I2S.INTENCLR: Disable interrupt
func (o *I2S_Type) SetINTENCLR_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENCLR_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTENCLR_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENCLR_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}

// I2S.ENABLE: Enable I2S module.
func (o *I2S_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

type I2S_CONFIG_Type struct {
	MODE     volatile.Register32 // 0x504
	RXEN     volatile.Register32 // 0x508
	TXEN     volatile.Register32 // 0x50C
	MCKEN    volatile.Register32 // 0x510
	MCKFREQ  volatile.Register32 // 0x514
	RATIO    volatile.Register32 // 0x518
	SWIDTH   volatile.Register32 // 0x51C
	ALIGN    volatile.Register32 // 0x520
	FORMAT   volatile.Register32 // 0x524
	CHANNELS volatile.Register32 // 0x528
}

// I2S_CONFIG.MODE: I2S mode.
func (o *I2S_CONFIG_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// I2S_CONFIG.RXEN: Reception (RX) enable.
func (o *I2S_CONFIG_Type) SetRXEN(value uint32) {
	volatile.StoreUint32(&o.RXEN.Reg, volatile.LoadUint32(&o.RXEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetRXEN() uint32 {
	return volatile.LoadUint32(&o.RXEN.Reg) & 0x1
}

// I2S_CONFIG.TXEN: Transmission (TX) enable.
func (o *I2S_CONFIG_Type) SetTXEN(value uint32) {
	volatile.StoreUint32(&o.TXEN.Reg, volatile.LoadUint32(&o.TXEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetTXEN() uint32 {
	return volatile.LoadUint32(&o.TXEN.Reg) & 0x1
}

// I2S_CONFIG.MCKEN: Master clock generator enable.
func (o *I2S_CONFIG_Type) SetMCKEN(value uint32) {
	volatile.StoreUint32(&o.MCKEN.Reg, volatile.LoadUint32(&o.MCKEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetMCKEN() uint32 {
	return volatile.LoadUint32(&o.MCKEN.Reg) & 0x1
}

// I2S_CONFIG.MCKFREQ: Master clock generator frequency.
func (o *I2S_CONFIG_Type) SetMCKFREQ(value uint32) {
	volatile.StoreUint32(&o.MCKFREQ.Reg, value)
}
func (o *I2S_CONFIG_Type) GetMCKFREQ() uint32 {
	return volatile.LoadUint32(&o.MCKFREQ.Reg)
}

// I2S_CONFIG.RATIO: MCK / LRCK ratio.
func (o *I2S_CONFIG_Type) SetRATIO(value uint32) {
	volatile.StoreUint32(&o.RATIO.Reg, volatile.LoadUint32(&o.RATIO.Reg)&^(0xf)|value)
}
func (o *I2S_CONFIG_Type) GetRATIO() uint32 {
	return volatile.LoadUint32(&o.RATIO.Reg) & 0xf
}

// I2S_CONFIG.SWIDTH: Sample width.
func (o *I2S_CONFIG_Type) SetSWIDTH(value uint32) {
	volatile.StoreUint32(&o.SWIDTH.Reg, volatile.LoadUint32(&o.SWIDTH.Reg)&^(0x3)|value)
}
func (o *I2S_CONFIG_Type) GetSWIDTH() uint32 {
	return volatile.LoadUint32(&o.SWIDTH.Reg) & 0x3
}

// I2S_CONFIG.ALIGN: Alignment of sample within a frame.
func (o *I2S_CONFIG_Type) SetALIGN(value uint32) {
	volatile.StoreUint32(&o.ALIGN.Reg, volatile.LoadUint32(&o.ALIGN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetALIGN() uint32 {
	return volatile.LoadUint32(&o.ALIGN.Reg) & 0x1
}

// I2S_CONFIG.FORMAT: Frame format.
func (o *I2S_CONFIG_Type) SetFORMAT(value uint32) {
	volatile.StoreUint32(&o.FORMAT.Reg, volatile.LoadUint32(&o.FORMAT.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetFORMAT() uint32 {
	return volatile.LoadUint32(&o.FORMAT.Reg) & 0x1
}

// I2S_CONFIG.CHANNELS: Enable channels.
func (o *I2S_CONFIG_Type) SetCHANNELS(value uint32) {
	volatile.StoreUint32(&o.CHANNELS.Reg, volatile.LoadUint32(&o.CHANNELS.Reg)&^(0x3)|value)
}
func (o *I2S_CONFIG_Type) GetCHANNELS() uint32 {
	return volatile.LoadUint32(&o.CHANNELS.Reg) & 0x3
}

type I2S_RXD_Type struct {
	PTR volatile.Register32 // 0x538
}

// I2S_RXD.PTR: Receive buffer RAM start address.
func (o *I2S_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *I2S_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

type I2S_TXD_Type struct {
	PTR volatile.Register32 // 0x540
}

// I2S_TXD.PTR: Transmit buffer RAM start address.
func (o *I2S_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *I2S_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

type I2S_RXTXD_Type struct {
	MAXCNT volatile.Register32 // 0x550
}

// I2S_RXTXD.MAXCNT: Size of RXD and TXD buffers.
func (o *I2S_RXTXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3fff)|value)
}
func (o *I2S_RXTXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3fff
}

type I2S_PSEL_Type struct {
	MCK   volatile.Register32 // 0x560
	SCK   volatile.Register32 // 0x564
	LRCK  volatile.Register32 // 0x568
	SDIN  volatile.Register32 // 0x56C
	SDOUT volatile.Register32 // 0x570
}

// I2S_PSEL.MCK: Pin select for MCK signal.
func (o *I2S_PSEL_Type) SetMCK_PIN(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetMCK_PIN() uint32 {
	return volatile.LoadUint32(&o.MCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetMCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetMCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SCK: Pin select for SCK signal.
func (o *I2S_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.LRCK: Pin select for LRCK signal.
func (o *I2S_PSEL_Type) SetLRCK_PIN(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetLRCK_PIN() uint32 {
	return volatile.LoadUint32(&o.LRCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetLRCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetLRCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.LRCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SDIN: Pin select for SDIN signal.
func (o *I2S_PSEL_Type) SetSDIN_PIN(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSDIN_PIN() uint32 {
	return volatile.LoadUint32(&o.SDIN.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSDIN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSDIN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDIN.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SDOUT: Pin select for SDOUT signal.
func (o *I2S_PSEL_Type) SetSDOUT_PIN(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSDOUT_PIN() uint32 {
	return volatile.LoadUint32(&o.SDOUT.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSDOUT_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSDOUT_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDOUT.Reg) & 0x80000000) >> 31
}

// Inter Processor Communication 0
type IPC_Type struct {
	TASKS_SEND      [8]volatile.Register32 // 0x0
	_               [96]byte
	SUBSCRIBE_SEND  [8]volatile.Register32 // 0x80
	_               [96]byte
	EVENTS_RECEIVE  [8]volatile.Register32 // 0x100
	_               [96]byte
	PUBLISH_RECEIVE [8]volatile.Register32 // 0x180
	_               [352]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	INTPEND         volatile.Register32 // 0x30C
	_               [512]byte
	SEND_CNF        [8]volatile.Register32 // 0x510
	_               [96]byte
	RECEIVE_CNF     [8]volatile.Register32 // 0x590
	_               [96]byte
	GPMEM           [4]volatile.Register32 // 0x610
}

// IPC.TASKS_SEND: Description collection: Trigger events on channel enabled in SEND_CNF[n].
func (o *IPC_Type) SetTASKS_SEND(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SEND[idx].Reg, volatile.LoadUint32(&o.TASKS_SEND[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetTASKS_SEND(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SEND[idx].Reg) & 0x1
}

// IPC.SUBSCRIBE_SEND: Description collection: Subscribe configuration for task SEND[n]
func (o *IPC_Type) SetSUBSCRIBE_SEND_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEND[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg)&^(0xf)|value)
}
func (o *IPC_Type) GetSUBSCRIBE_SEND_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg) & 0xf
}
func (o *IPC_Type) SetSUBSCRIBE_SEND_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEND[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *IPC_Type) GetSUBSCRIBE_SEND_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg) & 0x80000000) >> 31
}

// IPC.EVENTS_RECEIVE: Description collection: Event received on one or more of the enabled channels in RECEIVE_CNF[n].
func (o *IPC_Type) SetEVENTS_RECEIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_RECEIVE[idx].Reg, volatile.LoadUint32(&o.EVENTS_RECEIVE[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetEVENTS_RECEIVE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_RECEIVE[idx].Reg) & 0x1
}

// IPC.PUBLISH_RECEIVE: Description collection: Publish configuration for event RECEIVE[n]
func (o *IPC_Type) SetPUBLISH_RECEIVE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RECEIVE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg)&^(0xf)|value)
}
func (o *IPC_Type) GetPUBLISH_RECEIVE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg) & 0xf
}
func (o *IPC_Type) SetPUBLISH_RECEIVE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RECEIVE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *IPC_Type) GetPUBLISH_RECEIVE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg) & 0x80000000) >> 31
}

// IPC.INTEN: Enable or disable interrupt
func (o *IPC_Type) SetINTEN_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTEN_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *IPC_Type) SetINTEN_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTEN_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTEN_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTEN_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTEN_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTEN_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTEN_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTEN_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTEN_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTEN_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTEN_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTEN_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTEN_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTEN_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}

// IPC.INTENSET: Enable interrupt
func (o *IPC_Type) SetINTENSET_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTENSET_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *IPC_Type) SetINTENSET_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTENSET_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTENSET_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTENSET_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTENSET_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTENSET_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTENSET_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTENSET_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTENSET_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTENSET_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTENSET_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTENSET_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTENSET_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTENSET_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}

// IPC.INTENCLR: Disable interrupt
func (o *IPC_Type) SetINTENCLR_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *IPC_Type) SetINTENCLR_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTENCLR_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTENCLR_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTENCLR_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTENCLR_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTENCLR_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTENCLR_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}

// IPC.INTPEND: Pending interrupts
func (o *IPC_Type) SetINTPEND_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTPEND_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *IPC_Type) SetINTPEND_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTPEND_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTPEND_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTPEND_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTPEND_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTPEND_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTPEND_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTPEND_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTPEND_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTPEND_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTPEND_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTPEND_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTPEND_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTPEND_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x80) >> 7
}

// IPC.SEND_CNF: Description collection: Send event configuration for TASKS_SEND[n].
func (o *IPC_Type) SetSEND_CNF_CHEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetSEND_CNF_CHEN0(idx int) uint32 {
	return volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x1
}
func (o *IPC_Type) SetSEND_CNF_CHEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetSEND_CNF_CHEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetSEND_CNF_CHEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetSEND_CNF_CHEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetSEND_CNF_CHEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetSEND_CNF_CHEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetSEND_CNF_CHEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetSEND_CNF_CHEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetSEND_CNF_CHEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetSEND_CNF_CHEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetSEND_CNF_CHEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetSEND_CNF_CHEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetSEND_CNF_CHEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetSEND_CNF_CHEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x80) >> 7
}

// IPC.RECEIVE_CNF: Description collection: Receive event configuration for EVENTS_RECEIVE[n].
func (o *IPC_Type) SetRECEIVE_CNF_CHEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN0(idx int) uint32 {
	return volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x1
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x80) >> 7
}

// IPC.GPMEM: Description collection: General purpose memory.
func (o *IPC_Type) SetGPMEM(idx int, value uint32) {
	volatile.StoreUint32(&o.GPMEM[idx].Reg, value)
}
func (o *IPC_Type) GetGPMEM(idx int) uint32 {
	return volatile.LoadUint32(&o.GPMEM[idx].Reg)
}

// FPU 0
type FPU_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// Key management unit 0
type KMU_Type struct {
	TASKS_PUSH_KEYSLOT     volatile.Register32 // 0x0
	_                      [252]byte
	EVENTS_KEYSLOT_PUSHED  volatile.Register32 // 0x100
	EVENTS_KEYSLOT_REVOKED volatile.Register32 // 0x104
	EVENTS_KEYSLOT_ERROR   volatile.Register32 // 0x108
	_                      [500]byte
	INTEN                  volatile.Register32 // 0x300
	INTENSET               volatile.Register32 // 0x304
	INTENCLR               volatile.Register32 // 0x308
	INTPEND                volatile.Register32 // 0x30C
	_                      [252]byte
	STATUS                 volatile.Register32 // 0x40C
	_                      [240]byte
	SELECTKEYSLOT          volatile.Register32 // 0x500
}

// KMU.TASKS_PUSH_KEYSLOT: Push a key slot over secure APB
func (o *KMU_Type) SetTASKS_PUSH_KEYSLOT(value uint32) {
	volatile.StoreUint32(&o.TASKS_PUSH_KEYSLOT.Reg, volatile.LoadUint32(&o.TASKS_PUSH_KEYSLOT.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetTASKS_PUSH_KEYSLOT() uint32 {
	return volatile.LoadUint32(&o.TASKS_PUSH_KEYSLOT.Reg) & 0x1
}

// KMU.EVENTS_KEYSLOT_PUSHED: Key slot successfully pushed over secure APB
func (o *KMU_Type) SetEVENTS_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_KEYSLOT_PUSHED.Reg, volatile.LoadUint32(&o.EVENTS_KEYSLOT_PUSHED.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetEVENTS_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_KEYSLOT_PUSHED.Reg) & 0x1
}

// KMU.EVENTS_KEYSLOT_REVOKED: Key slot has been revoked and cannot be tasked for selection
func (o *KMU_Type) SetEVENTS_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_KEYSLOT_REVOKED.Reg, volatile.LoadUint32(&o.EVENTS_KEYSLOT_REVOKED.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetEVENTS_KEYSLOT_REVOKED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_KEYSLOT_REVOKED.Reg) & 0x1
}

// KMU.EVENTS_KEYSLOT_ERROR: No key slot selected, no destination address defined, or error during push operation
func (o *KMU_Type) SetEVENTS_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_KEYSLOT_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_KEYSLOT_ERROR.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetEVENTS_KEYSLOT_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_KEYSLOT_ERROR.Reg) & 0x1
}

// KMU.INTEN: Enable or disable interrupt
func (o *KMU_Type) SetINTEN_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTEN_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *KMU_Type) SetINTEN_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTEN_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTEN_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTEN_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// KMU.INTENSET: Enable interrupt
func (o *KMU_Type) SetINTENSET_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTENSET_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *KMU_Type) SetINTENSET_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTENSET_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTENSET_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTENSET_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// KMU.INTENCLR: Disable interrupt
func (o *KMU_Type) SetINTENCLR_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTENCLR_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *KMU_Type) SetINTENCLR_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTENCLR_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTENCLR_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTENCLR_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// KMU.INTPEND: Pending interrupts
func (o *KMU_Type) SetINTPEND_KEYSLOT_PUSHED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetINTPEND_KEYSLOT_PUSHED() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *KMU_Type) SetINTPEND_KEYSLOT_REVOKED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetINTPEND_KEYSLOT_REVOKED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *KMU_Type) SetINTPEND_KEYSLOT_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4)|value<<2)
}
func (o *KMU_Type) GetINTPEND_KEYSLOT_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4) >> 2
}

// KMU.STATUS: Status bits for KMU operation
func (o *KMU_Type) SetSTATUS_SELECTED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *KMU_Type) GetSTATUS_SELECTED() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *KMU_Type) SetSTATUS_BLOCKED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *KMU_Type) GetSTATUS_BLOCKED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}

// KMU.SELECTKEYSLOT: Select key slot to be read over AHB or pushed over secure APB when TASKS_PUSH_KEYSLOT is started
func (o *KMU_Type) SetSELECTKEYSLOT_ID(value uint32) {
	volatile.StoreUint32(&o.SELECTKEYSLOT.Reg, volatile.LoadUint32(&o.SELECTKEYSLOT.Reg)&^(0xff)|value)
}
func (o *KMU_Type) GetSELECTKEYSLOT_ID() uint32 {
	return volatile.LoadUint32(&o.SELECTKEYSLOT.Reg) & 0xff
}

// Non-volatile memory controller 0
type NVMC_Type struct {
	_                   [1024]byte
	READY               volatile.Register32 // 0x400
	_                   [4]byte
	READYNEXT           volatile.Register32 // 0x408
	_                   [248]byte
	CONFIG              volatile.Register32 // 0x504
	_                   [4]byte
	ERASEALL            volatile.Register32 // 0x50C
	_                   [12]byte
	ERASEPAGEPARTIALCFG volatile.Register32 // 0x51C
	_                   [32]byte
	ICACHECNF           volatile.Register32 // 0x540
	_                   [4]byte
	IHIT                volatile.Register32 // 0x548
	IMISS               volatile.Register32 // 0x54C
	_                   [52]byte
	CONFIGNS            volatile.Register32 // 0x584
	WRITEUICRNS         volatile.Register32 // 0x588
}

// NVMC.READY: Ready flag
func (o *NVMC_Type) SetREADY(value uint32) {
	volatile.StoreUint32(&o.READY.Reg, volatile.LoadUint32(&o.READY.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADY() uint32 {
	return volatile.LoadUint32(&o.READY.Reg) & 0x1
}

// NVMC.READYNEXT: Ready flag
func (o *NVMC_Type) SetREADYNEXT(value uint32) {
	volatile.StoreUint32(&o.READYNEXT.Reg, volatile.LoadUint32(&o.READYNEXT.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADYNEXT() uint32 {
	return volatile.LoadUint32(&o.READYNEXT.Reg) & 0x1
}

// NVMC.CONFIG: Configuration register
func (o *NVMC_Type) SetCONFIG_WEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x7)|value)
}
func (o *NVMC_Type) GetCONFIG_WEN() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x7
}

// NVMC.ERASEALL: Register for erasing all non-volatile user memory
func (o *NVMC_Type) SetERASEALL(value uint32) {
	volatile.StoreUint32(&o.ERASEALL.Reg, volatile.LoadUint32(&o.ERASEALL.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetERASEALL() uint32 {
	return volatile.LoadUint32(&o.ERASEALL.Reg) & 0x1
}

// NVMC.ERASEPAGEPARTIALCFG: Register for partial erase configuration
func (o *NVMC_Type) SetERASEPAGEPARTIALCFG_DURATION(value uint32) {
	volatile.StoreUint32(&o.ERASEPAGEPARTIALCFG.Reg, volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg)&^(0x7f)|value)
}
func (o *NVMC_Type) GetERASEPAGEPARTIALCFG_DURATION() uint32 {
	return volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg) & 0x7f
}

// NVMC.ICACHECNF: I-code cache configuration register
func (o *NVMC_Type) SetICACHECNF_CACHEEN(value uint32) {
	volatile.StoreUint32(&o.ICACHECNF.Reg, volatile.LoadUint32(&o.ICACHECNF.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetICACHECNF_CACHEEN() uint32 {
	return volatile.LoadUint32(&o.ICACHECNF.Reg) & 0x1
}
func (o *NVMC_Type) SetICACHECNF_CACHEPROFEN(value uint32) {
	volatile.StoreUint32(&o.ICACHECNF.Reg, volatile.LoadUint32(&o.ICACHECNF.Reg)&^(0x100)|value<<8)
}
func (o *NVMC_Type) GetICACHECNF_CACHEPROFEN() uint32 {
	return (volatile.LoadUint32(&o.ICACHECNF.Reg) & 0x100) >> 8
}

// NVMC.IHIT: I-code cache hit counter
func (o *NVMC_Type) SetIHIT(value uint32) {
	volatile.StoreUint32(&o.IHIT.Reg, value)
}
func (o *NVMC_Type) GetIHIT() uint32 {
	return volatile.LoadUint32(&o.IHIT.Reg)
}

// NVMC.IMISS: I-code cache miss counter
func (o *NVMC_Type) SetIMISS(value uint32) {
	volatile.StoreUint32(&o.IMISS.Reg, value)
}
func (o *NVMC_Type) GetIMISS() uint32 {
	return volatile.LoadUint32(&o.IMISS.Reg)
}

// NVMC.CONFIGNS: Unspecified
func (o *NVMC_Type) SetCONFIGNS_WEN(value uint32) {
	volatile.StoreUint32(&o.CONFIGNS.Reg, volatile.LoadUint32(&o.CONFIGNS.Reg)&^(0x3)|value)
}
func (o *NVMC_Type) GetCONFIGNS_WEN() uint32 {
	return volatile.LoadUint32(&o.CONFIGNS.Reg) & 0x3
}

// NVMC.WRITEUICRNS: Non-secure APPROTECT enable register
func (o *NVMC_Type) SetWRITEUICRNS_SET(value uint32) {
	volatile.StoreUint32(&o.WRITEUICRNS.Reg, volatile.LoadUint32(&o.WRITEUICRNS.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetWRITEUICRNS_SET() uint32 {
	return volatile.LoadUint32(&o.WRITEUICRNS.Reg) & 0x1
}
func (o *NVMC_Type) SetWRITEUICRNS_KEY(value uint32) {
	volatile.StoreUint32(&o.WRITEUICRNS.Reg, volatile.LoadUint32(&o.WRITEUICRNS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *NVMC_Type) GetWRITEUICRNS_KEY() uint32 {
	return (volatile.LoadUint32(&o.WRITEUICRNS.Reg) & 0xfffffff0) >> 4
}

// Volatile Memory controller 0
type VMC_Type struct {
	_   [1536]byte
	RAM [8]VMC_RAM_Type // 0x600
}

type VMC_RAM_Type struct {
	POWER    volatile.Register32 // 0x600
	POWERSET volatile.Register32 // 0x604
	POWERCLR volatile.Register32 // 0x608
	_        [4]byte
}

// VMC_RAM.POWER: Description cluster: RAMn power control register
func (o *VMC_RAM_Type) SetPOWER_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWER_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWER_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWER_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWER_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWER_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWER_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWER_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWER_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWER_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWER_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWER_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWER_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWER_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWER_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWER_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80000) >> 19
}

// VMC_RAM.POWERSET: Description cluster: RAMn power control set register
func (o *VMC_RAM_Type) SetPOWERSET_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWERSET_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERSET.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWERSET_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWERSET_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWERSET_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWERSET_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWERSET_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWERSET_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWERSET_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWERSET_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWERSET_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWERSET_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWERSET_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWERSET_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWERSET_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWERSET_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80000) >> 19
}

// VMC_RAM.POWERCLR: Description cluster: RAMn power control clear register
func (o *VMC_RAM_Type) SetPOWERCLR_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWERCLR_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWERCLR_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWERCLR_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWERCLR_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWERCLR_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWERCLR_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWERCLR_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80000) >> 19
}

// CRYPTOCELL HOST_RGF interface
type CC_HOST_RGF_Type struct {
	_                   [6712]byte
	HOST_CRYPTOKEY_SEL  volatile.Register32 // 0x1A38
	_                   [16]byte
	HOST_IOT_KPRTL_LOCK volatile.Register32 // 0x1A4C
	HOST_IOT_KDR0       volatile.Register32 // 0x1A50
	HOST_IOT_KDR1       volatile.Register32 // 0x1A54
	HOST_IOT_KDR2       volatile.Register32 // 0x1A58
	HOST_IOT_KDR3       volatile.Register32 // 0x1A5C
	HOST_IOT_LCS        volatile.Register32 // 0x1A60
}

// CC_HOST_RGF.HOST_CRYPTOKEY_SEL: AES hardware key select
func (o *CC_HOST_RGF_Type) SetHOST_CRYPTOKEY_SEL(value uint32) {
	volatile.StoreUint32(&o.HOST_CRYPTOKEY_SEL.Reg, volatile.LoadUint32(&o.HOST_CRYPTOKEY_SEL.Reg)&^(0x3)|value)
}
func (o *CC_HOST_RGF_Type) GetHOST_CRYPTOKEY_SEL() uint32 {
	return volatile.LoadUint32(&o.HOST_CRYPTOKEY_SEL.Reg) & 0x3
}

// CC_HOST_RGF.HOST_IOT_KPRTL_LOCK: This write-once register is the K_PRTL lock register. When this register is set, K_PRTL cannot be used and a zeroed key will be used instead. The value of this register is saved in the CRYPTOCELL AO power domain.
func (o *CC_HOST_RGF_Type) SetHOST_IOT_KPRTL_LOCK(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_KPRTL_LOCK.Reg, volatile.LoadUint32(&o.HOST_IOT_KPRTL_LOCK.Reg)&^(0x1)|value)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_KPRTL_LOCK() uint32 {
	return volatile.LoadUint32(&o.HOST_IOT_KPRTL_LOCK.Reg) & 0x1
}

// CC_HOST_RGF.HOST_IOT_KDR0: This register holds bits 31:0 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain. Reading from this address returns the K_DR valid status indicating if K_DR is successfully retained.
func (o *CC_HOST_RGF_Type) SetHOST_IOT_KDR0(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_KDR0.Reg, value)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_KDR0() uint32 {
	return volatile.LoadUint32(&o.HOST_IOT_KDR0.Reg)
}

// CC_HOST_RGF.HOST_IOT_KDR1: This register holds bits 63:32 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
func (o *CC_HOST_RGF_Type) SetHOST_IOT_KDR1(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_KDR1.Reg, value)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_KDR1() uint32 {
	return volatile.LoadUint32(&o.HOST_IOT_KDR1.Reg)
}

// CC_HOST_RGF.HOST_IOT_KDR2: This register holds bits 95:64 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
func (o *CC_HOST_RGF_Type) SetHOST_IOT_KDR2(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_KDR2.Reg, value)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_KDR2() uint32 {
	return volatile.LoadUint32(&o.HOST_IOT_KDR2.Reg)
}

// CC_HOST_RGF.HOST_IOT_KDR3: This register holds bits 127:96 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
func (o *CC_HOST_RGF_Type) SetHOST_IOT_KDR3(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_KDR3.Reg, value)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_KDR3() uint32 {
	return volatile.LoadUint32(&o.HOST_IOT_KDR3.Reg)
}

// CC_HOST_RGF.HOST_IOT_LCS: Controls lifecycle state (LCS) for CRYPTOCELL subsystem
func (o *CC_HOST_RGF_Type) SetHOST_IOT_LCS_LCS(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_LCS.Reg, volatile.LoadUint32(&o.HOST_IOT_LCS.Reg)&^(0x7)|value)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_LCS_LCS() uint32 {
	return volatile.LoadUint32(&o.HOST_IOT_LCS.Reg) & 0x7
}
func (o *CC_HOST_RGF_Type) SetHOST_IOT_LCS_LCS_IS_VALID(value uint32) {
	volatile.StoreUint32(&o.HOST_IOT_LCS.Reg, volatile.LoadUint32(&o.HOST_IOT_LCS.Reg)&^(0x100)|value<<8)
}
func (o *CC_HOST_RGF_Type) GetHOST_IOT_LCS_LCS_IS_VALID() uint32 {
	return (volatile.LoadUint32(&o.HOST_IOT_LCS.Reg) & 0x100) >> 8
}

// ARM TrustZone CryptoCell register interface
type CRYPTOCELL_Type struct {
	_      [1280]byte
	ENABLE volatile.Register32 // 0x500
}

// CRYPTOCELL.ENABLE: Enable CRYPTOCELL subsystem
func (o *CRYPTOCELL_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *CRYPTOCELL_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// GPIO Port 0
type GPIO_Type struct {
	_              [4]byte
	OUT            volatile.Register32 // 0x4
	OUTSET         volatile.Register32 // 0x8
	OUTCLR         volatile.Register32 // 0xC
	IN             volatile.Register32 // 0x10
	DIR            volatile.Register32 // 0x14
	DIRSET         volatile.Register32 // 0x18
	DIRCLR         volatile.Register32 // 0x1C
	LATCH          volatile.Register32 // 0x20
	DETECTMODE     volatile.Register32 // 0x24
	DETECTMODE_SEC volatile.Register32 // 0x28
	_              [468]byte
	PIN_CNF        [32]volatile.Register32 // 0x200
}

// GPIO.OUT: Write GPIO port
func (o *GPIO_Type) SetOUT_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUT_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg) & 0x1
}
func (o *GPIO_Type) SetOUT_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUT_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUT_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUT_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUT_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUT_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUT_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUT_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUT_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUT_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUT_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUT_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUT_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUT_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUT_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUT_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUT_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUT_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUT_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUT_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUT_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUT_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUT_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUT_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUT_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUT_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUT_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUT_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUT_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUT_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUT_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUT_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUT_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUT_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUT_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUT_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUT_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUT_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUT_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUT_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUT_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUT_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUT_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUT_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUT_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUT_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUT_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUT_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUT_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUT_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUT_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUT_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUT_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUT_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUT_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUT_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUT_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUT_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUT_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUT_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUT_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUT_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000000) >> 31
}

// GPIO.OUTSET: Set individual bits in GPIO port
func (o *GPIO_Type) SetOUTSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTSET.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000000) >> 31
}

// GPIO.OUTCLR: Clear individual bits in GPIO port
func (o *GPIO_Type) SetOUTCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000000) >> 31
}

// GPIO.IN: Read GPIO port
func (o *GPIO_Type) SetIN_PIN0(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIN_PIN0() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0x1
}
func (o *GPIO_Type) SetIN_PIN1(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIN_PIN2(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIN_PIN3(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIN_PIN4(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIN_PIN5(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIN_PIN6(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIN_PIN7(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIN_PIN8(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIN_PIN9(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIN_PIN10(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIN_PIN11(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIN_PIN12(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIN_PIN13(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIN_PIN14(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIN_PIN15(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIN_PIN16(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetIN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetIN_PIN17(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetIN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetIN_PIN18(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetIN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetIN_PIN19(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetIN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetIN_PIN20(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetIN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetIN_PIN21(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetIN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetIN_PIN22(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetIN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetIN_PIN23(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetIN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetIN_PIN24(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetIN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetIN_PIN25(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetIN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetIN_PIN26(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetIN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetIN_PIN27(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetIN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetIN_PIN28(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetIN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetIN_PIN29(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetIN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetIN_PIN30(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetIN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetIN_PIN31(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetIN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000000) >> 31
}

// GPIO.DIR: Direction of GPIO pins
func (o *GPIO_Type) SetDIR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000000) >> 31
}

// GPIO.DIRSET: DIR set register
func (o *GPIO_Type) SetDIRSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRSET.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000000) >> 31
}

// GPIO.DIRCLR: DIR clear register
func (o *GPIO_Type) SetDIRCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000000) >> 31
}

// GPIO.LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
func (o *GPIO_Type) SetLATCH_PIN0(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLATCH_PIN0() uint32 {
	return volatile.LoadUint32(&o.LATCH.Reg) & 0x1
}
func (o *GPIO_Type) SetLATCH_PIN1(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLATCH_PIN1() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLATCH_PIN2(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLATCH_PIN2() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLATCH_PIN3(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLATCH_PIN3() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLATCH_PIN4(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLATCH_PIN4() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLATCH_PIN5(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLATCH_PIN5() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLATCH_PIN6(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLATCH_PIN6() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLATCH_PIN7(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLATCH_PIN7() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLATCH_PIN8(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLATCH_PIN8() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLATCH_PIN9(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLATCH_PIN9() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLATCH_PIN10(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLATCH_PIN10() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLATCH_PIN11(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLATCH_PIN11() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLATCH_PIN12(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLATCH_PIN12() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLATCH_PIN13(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLATCH_PIN13() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLATCH_PIN14(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLATCH_PIN14() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLATCH_PIN15(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLATCH_PIN15() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLATCH_PIN16(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLATCH_PIN16() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLATCH_PIN17(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetLATCH_PIN17() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetLATCH_PIN18(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetLATCH_PIN18() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetLATCH_PIN19(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetLATCH_PIN19() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetLATCH_PIN20(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetLATCH_PIN20() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetLATCH_PIN21(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetLATCH_PIN21() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetLATCH_PIN22(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetLATCH_PIN22() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetLATCH_PIN23(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetLATCH_PIN23() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetLATCH_PIN24(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetLATCH_PIN24() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetLATCH_PIN25(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetLATCH_PIN25() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetLATCH_PIN26(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetLATCH_PIN26() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetLATCH_PIN27(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetLATCH_PIN27() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetLATCH_PIN28(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetLATCH_PIN28() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetLATCH_PIN29(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetLATCH_PIN29() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetLATCH_PIN30(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetLATCH_PIN30() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetLATCH_PIN31(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetLATCH_PIN31() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000000) >> 31
}

// GPIO.DETECTMODE: Select between default DETECT signal behavior and LDETECT mode (For non-secure pin only)
func (o *GPIO_Type) SetDETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE.Reg, volatile.LoadUint32(&o.DETECTMODE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE.Reg) & 0x1
}

// GPIO.DETECTMODE_SEC: Select between default DETECT signal behavior and LDETECT mode (For secure pin only)
func (o *GPIO_Type) SetDETECTMODE_SEC_DETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE_SEC.Reg, volatile.LoadUint32(&o.DETECTMODE_SEC.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE_SEC_DETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE_SEC.Reg) & 0x1
}

// GPIO.PIN_CNF: Description collection: Configuration of GPIO pins
func (o *GPIO_Type) SetPIN_CNF_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN_CNF_DIR(idx int) uint32 {
	return volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetPIN_CNF_INPUT(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN_CNF_INPUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN_CNF_PULL(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPIN_CNF_PULL(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPIN_CNF_DRIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x700)|value<<8)
}
func (o *GPIO_Type) GetPIN_CNF_DRIVE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x700) >> 8
}
func (o *GPIO_Type) SetPIN_CNF_SENSE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPIN_CNF_SENSE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x30000) >> 16
}

// Constants for FICR_S: Factory Information Configuration Registers
const (
	// INFO.DEVICEID: Description collection: Device identifier
	// Position of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Msk = 0xffffffff

	// INFO.PART: Part code
	// Position of PART field.
	FICR_INFO_PART_PART_Pos = 0x0
	// Bit mask of PART field.
	FICR_INFO_PART_PART_Msk = 0xffffffff
	// nRF9160
	FICR_INFO_PART_PART_N9160 = 0x9160

	// INFO.VARIANT: Part Variant, Hardware version and Production configuration
	// Position of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Pos = 0x0
	// Bit mask of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Msk = 0xffffffff
	// AAAA
	FICR_INFO_VARIANT_VARIANT_AAAA = 0x41414141
	// AAA0
	FICR_INFO_VARIANT_VARIANT_AAA0 = 0x41414130

	// INFO.PACKAGE: Package option
	// Position of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Pos = 0x0
	// Bit mask of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Msk = 0xffffffff
	// CCxx - 236 ball wlCSP
	FICR_INFO_PACKAGE_PACKAGE_CC = 0x2000

	// INFO.RAM: RAM variant
	// Position of RAM field.
	FICR_INFO_RAM_RAM_Pos = 0x0
	// Bit mask of RAM field.
	FICR_INFO_RAM_RAM_Msk = 0xffffffff
	// 256 kByte RAM
	FICR_INFO_RAM_RAM_K256 = 0x100
	// Unspecified
	FICR_INFO_RAM_RAM_Unspecified = 0xffffffff

	// INFO.FLASH: Flash variant
	// Position of FLASH field.
	FICR_INFO_FLASH_FLASH_Pos = 0x0
	// Bit mask of FLASH field.
	FICR_INFO_FLASH_FLASH_Msk = 0xffffffff
	// 1 MByte FLASH
	FICR_INFO_FLASH_FLASH_K1024 = 0x400

	// INFO.CODEPAGESIZE: Code memory page size
	// Position of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Pos = 0x0
	// Bit mask of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Msk = 0xffffffff

	// INFO.CODESIZE: Code memory size
	// Position of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Pos = 0x0
	// Bit mask of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Msk = 0xffffffff

	// INFO.DEVICETYPE: Device type
	// Position of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Pos = 0x0
	// Bit mask of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Msk = 0xffffffff
	// Device is an physical DIE
	FICR_INFO_DEVICETYPE_DEVICETYPE_Die = 0x0
	// Device is an FPGA
	FICR_INFO_DEVICETYPE_DEVICETYPE_FPGA = 0xffffffff

	// TRIMCNF.ADDR: Description cluster: Address
	// Position of Address field.
	FICR_TRIMCNF_ADDR_Address_Pos = 0x0
	// Bit mask of Address field.
	FICR_TRIMCNF_ADDR_Address_Msk = 0xffffffff

	// TRIMCNF.DATA: Description cluster: Data
	// Position of Data field.
	FICR_TRIMCNF_DATA_Data_Pos = 0x0
	// Bit mask of Data field.
	FICR_TRIMCNF_DATA_Data_Msk = 0xffffffff

	// TRNG90B.BYTES: Amount of bytes for the required entropy bits
	// Position of BYTES field.
	FICR_TRNG90B_BYTES_BYTES_Pos = 0x0
	// Bit mask of BYTES field.
	FICR_TRNG90B_BYTES_BYTES_Msk = 0xffffffff

	// TRNG90B.RCCUTOFF: Repetition counter cutoff
	// Position of RCCUTOFF field.
	FICR_TRNG90B_RCCUTOFF_RCCUTOFF_Pos = 0x0
	// Bit mask of RCCUTOFF field.
	FICR_TRNG90B_RCCUTOFF_RCCUTOFF_Msk = 0xffffffff

	// TRNG90B.APCUTOFF: Adaptive proportion cutoff
	// Position of APCUTOFF field.
	FICR_TRNG90B_APCUTOFF_APCUTOFF_Pos = 0x0
	// Bit mask of APCUTOFF field.
	FICR_TRNG90B_APCUTOFF_APCUTOFF_Msk = 0xffffffff

	// TRNG90B.STARTUP: Amount of bytes for the startup tests
	// Position of STARTUP field.
	FICR_TRNG90B_STARTUP_STARTUP_Pos = 0x0
	// Bit mask of STARTUP field.
	FICR_TRNG90B_STARTUP_STARTUP_Msk = 0xffffffff

	// TRNG90B.ROSC1: Sample count for ring oscillator 1
	// Position of ROSC1 field.
	FICR_TRNG90B_ROSC1_ROSC1_Pos = 0x0
	// Bit mask of ROSC1 field.
	FICR_TRNG90B_ROSC1_ROSC1_Msk = 0xffffffff

	// TRNG90B.ROSC2: Sample count for ring oscillator 2
	// Position of ROSC2 field.
	FICR_TRNG90B_ROSC2_ROSC2_Pos = 0x0
	// Bit mask of ROSC2 field.
	FICR_TRNG90B_ROSC2_ROSC2_Msk = 0xffffffff

	// TRNG90B.ROSC3: Sample count for ring oscillator 3
	// Position of ROSC3 field.
	FICR_TRNG90B_ROSC3_ROSC3_Pos = 0x0
	// Bit mask of ROSC3 field.
	FICR_TRNG90B_ROSC3_ROSC3_Msk = 0xffffffff

	// TRNG90B.ROSC4: Sample count for ring oscillator 4
	// Position of ROSC4 field.
	FICR_TRNG90B_ROSC4_ROSC4_Pos = 0x0
	// Bit mask of ROSC4 field.
	FICR_TRNG90B_ROSC4_ROSC4_Msk = 0xffffffff
)

// Constants for UICR_S: User information configuration registers User information configuration registers
const (
	// APPROTECT: Access port protection
	// Position of PALL field.
	UICR_APPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_APPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_APPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_APPROTECT_PALL_Protected = 0x0

	// XOSC32M: Oscillator control
	// Position of CTRL field.
	UICR_XOSC32M_CTRL_Pos = 0x0
	// Bit mask of CTRL field.
	UICR_XOSC32M_CTRL_Msk = 0x3f

	// HFXOSRC: HFXO clock source selection
	// Position of HFXOSRC field.
	UICR_HFXOSRC_HFXOSRC_Pos = 0x0
	// Bit mask of HFXOSRC field.
	UICR_HFXOSRC_HFXOSRC_Msk = 0x1
	// Bit HFXOSRC.
	UICR_HFXOSRC_HFXOSRC = 0x1
	// 32 MHz crystal oscillator
	UICR_HFXOSRC_HFXOSRC_XTAL = 0x1
	// 32 MHz temperature compensated crystal oscillator (TCXO)
	UICR_HFXOSRC_HFXOSRC_TCXO = 0x0

	// HFXOCNT: HFXO startup counter
	// Position of HFXOCNT field.
	UICR_HFXOCNT_HFXOCNT_Pos = 0x0
	// Bit mask of HFXOCNT field.
	UICR_HFXOCNT_HFXOCNT_Msk = 0xff
	// Min debounce time = (0*64 us + 0.5 us)
	UICR_HFXOCNT_HFXOCNT_MinDebounceTime = 0x0
	// Max debounce time = (255*64 us + 0.5 us)
	UICR_HFXOCNT_HFXOCNT_MaxDebounceTime = 0xff

	// SECUREAPPROTECT: Secure access port protection
	// Position of PALL field.
	UICR_SECUREAPPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_SECUREAPPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_SECUREAPPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_SECUREAPPROTECT_PALL_Protected = 0x0

	// ERASEPROTECT: Erase protection
	// Position of PALL field.
	UICR_ERASEPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_ERASEPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_ERASEPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_ERASEPROTECT_PALL_Protected = 0x0

	// OTP: Description collection: One time programmable memory
	// Position of LOWER field.
	UICR_OTP_LOWER_Pos = 0x0
	// Bit mask of LOWER field.
	UICR_OTP_LOWER_Msk = 0xffff
	// Position of UPPER field.
	UICR_OTP_UPPER_Pos = 0x10
	// Bit mask of UPPER field.
	UICR_OTP_UPPER_Msk = 0xffff0000
)

// Constants for TAD_S: Trace and debug control
const (
	// CLOCKSTART: Start all trace and debug clocks.
	// Position of START field.
	TAD_CLOCKSTART_START_Pos = 0x0
	// Bit mask of START field.
	TAD_CLOCKSTART_START_Msk = 0x1
	// Bit START.
	TAD_CLOCKSTART_START = 0x1
	// Start all trace and debug clocks.
	TAD_CLOCKSTART_START_Start = 0x1

	// CLOCKSTOP: Stop all trace and debug clocks.
	// Position of STOP field.
	TAD_CLOCKSTOP_STOP_Pos = 0x0
	// Bit mask of STOP field.
	TAD_CLOCKSTOP_STOP_Msk = 0x1
	// Bit STOP.
	TAD_CLOCKSTOP_STOP = 0x1
	// Stop all trace and debug clocks.
	TAD_CLOCKSTOP_STOP_Stop = 0x1

	// ENABLE: Enable debug domain and aquire selected GPIOs
	// Position of ENABLE field.
	TAD_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TAD_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	TAD_ENABLE_ENABLE = 0x1
	// Disable debug domain and release selected GPIOs
	TAD_ENABLE_ENABLE_DISABLED = 0x0
	// Enable debug domain and aquire selected GPIOs
	TAD_ENABLE_ENABLE_ENABLED = 0x1

	// PSEL.TRACECLK: Pin number configuration for TRACECLK
	// Position of PIN field.
	TAD_PSEL_TRACECLK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACECLK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TAD_PSEL_TRACECLK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACECLK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACECLK_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACECLK_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACECLK_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA0: Pin number configuration for TRACEDATA[0]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA0_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA0_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA0_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA0_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA0_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA0_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA0_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA1: Pin number configuration for TRACEDATA[1]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA1_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA1_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA1_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA1_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA1_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA1_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA1_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA2: Pin number configuration for TRACEDATA[2]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA2_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA2_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA2_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA2_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA2_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA2_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA2_CONNECT_Connected = 0x0

	// PSEL.TRACEDATA3: Pin number configuration for TRACEDATA[3]
	// Position of PIN field.
	TAD_PSEL_TRACEDATA3_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TAD_PSEL_TRACEDATA3_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TAD_PSEL_TRACEDATA3_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TAD_PSEL_TRACEDATA3_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TAD_PSEL_TRACEDATA3_CONNECT = 0x80000000
	// Disconnect
	TAD_PSEL_TRACEDATA3_CONNECT_Disconnected = 0x1
	// Connect
	TAD_PSEL_TRACEDATA3_CONNECT_Connected = 0x0

	// TRACEPORTSPEED: Clocking options for the Trace Port debug interface
	// Position of TRACEPORTSPEED field.
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_Pos = 0x0
	// Bit mask of TRACEPORTSPEED field.
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_Msk = 0x3
	// 32 MHz Trace Port clock (TRACECLK = 16 MHz)
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_32MHz = 0x0
	// 16 MHz Trace Port clock (TRACECLK = 8 MHz)
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_16MHz = 0x1
	// 8 MHz Trace Port clock (TRACECLK = 4 MHz)
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_8MHz = 0x2
	// 4 MHz Trace Port clock (TRACECLK = 2 MHz)
	TAD_TRACEPORTSPEED_TRACEPORTSPEED_4MHz = 0x3
)

// Constants for SPU_S: System protection unit
const (
	// EVENTS_RAMACCERR: A security violation has been detected for the RAM memory space
	// Position of EVENTS_RAMACCERR field.
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_Pos = 0x0
	// Bit mask of EVENTS_RAMACCERR field.
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_Msk = 0x1
	// Bit EVENTS_RAMACCERR.
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR = 0x1
	// Event not generated
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_NotGenerated = 0x0
	// Event generated
	SPU_EVENTS_RAMACCERR_EVENTS_RAMACCERR_Generated = 0x1

	// EVENTS_FLASHACCERR: A security violation has been detected for the flash memory space
	// Position of EVENTS_FLASHACCERR field.
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_Pos = 0x0
	// Bit mask of EVENTS_FLASHACCERR field.
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_Msk = 0x1
	// Bit EVENTS_FLASHACCERR.
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR = 0x1
	// Event not generated
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_NotGenerated = 0x0
	// Event generated
	SPU_EVENTS_FLASHACCERR_EVENTS_FLASHACCERR_Generated = 0x1

	// EVENTS_PERIPHACCERR: A security violation has been detected on one or several peripherals
	// Position of EVENTS_PERIPHACCERR field.
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_Pos = 0x0
	// Bit mask of EVENTS_PERIPHACCERR field.
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_Msk = 0x1
	// Bit EVENTS_PERIPHACCERR.
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR = 0x1
	// Event not generated
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_NotGenerated = 0x0
	// Event generated
	SPU_EVENTS_PERIPHACCERR_EVENTS_PERIPHACCERR_Generated = 0x1

	// PUBLISH_RAMACCERR: Publish configuration for event RAMACCERR
	// Position of CHIDX field.
	SPU_PUBLISH_RAMACCERR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPU_PUBLISH_RAMACCERR_CHIDX_Msk = 0xf
	// Position of EN field.
	SPU_PUBLISH_RAMACCERR_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPU_PUBLISH_RAMACCERR_EN_Msk = 0x80000000
	// Bit EN.
	SPU_PUBLISH_RAMACCERR_EN = 0x80000000
	// Disable publishing
	SPU_PUBLISH_RAMACCERR_EN_Disabled = 0x0
	// Enable publishing
	SPU_PUBLISH_RAMACCERR_EN_Enabled = 0x1

	// PUBLISH_FLASHACCERR: Publish configuration for event FLASHACCERR
	// Position of CHIDX field.
	SPU_PUBLISH_FLASHACCERR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPU_PUBLISH_FLASHACCERR_CHIDX_Msk = 0xf
	// Position of EN field.
	SPU_PUBLISH_FLASHACCERR_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPU_PUBLISH_FLASHACCERR_EN_Msk = 0x80000000
	// Bit EN.
	SPU_PUBLISH_FLASHACCERR_EN = 0x80000000
	// Disable publishing
	SPU_PUBLISH_FLASHACCERR_EN_Disabled = 0x0
	// Enable publishing
	SPU_PUBLISH_FLASHACCERR_EN_Enabled = 0x1

	// PUBLISH_PERIPHACCERR: Publish configuration for event PERIPHACCERR
	// Position of CHIDX field.
	SPU_PUBLISH_PERIPHACCERR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPU_PUBLISH_PERIPHACCERR_CHIDX_Msk = 0xf
	// Position of EN field.
	SPU_PUBLISH_PERIPHACCERR_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPU_PUBLISH_PERIPHACCERR_EN_Msk = 0x80000000
	// Bit EN.
	SPU_PUBLISH_PERIPHACCERR_EN = 0x80000000
	// Disable publishing
	SPU_PUBLISH_PERIPHACCERR_EN_Disabled = 0x0
	// Enable publishing
	SPU_PUBLISH_PERIPHACCERR_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RAMACCERR field.
	SPU_INTEN_RAMACCERR_Pos = 0x0
	// Bit mask of RAMACCERR field.
	SPU_INTEN_RAMACCERR_Msk = 0x1
	// Bit RAMACCERR.
	SPU_INTEN_RAMACCERR = 0x1
	// Disable
	SPU_INTEN_RAMACCERR_Disabled = 0x0
	// Enable
	SPU_INTEN_RAMACCERR_Enabled = 0x1
	// Position of FLASHACCERR field.
	SPU_INTEN_FLASHACCERR_Pos = 0x1
	// Bit mask of FLASHACCERR field.
	SPU_INTEN_FLASHACCERR_Msk = 0x2
	// Bit FLASHACCERR.
	SPU_INTEN_FLASHACCERR = 0x2
	// Disable
	SPU_INTEN_FLASHACCERR_Disabled = 0x0
	// Enable
	SPU_INTEN_FLASHACCERR_Enabled = 0x1
	// Position of PERIPHACCERR field.
	SPU_INTEN_PERIPHACCERR_Pos = 0x2
	// Bit mask of PERIPHACCERR field.
	SPU_INTEN_PERIPHACCERR_Msk = 0x4
	// Bit PERIPHACCERR.
	SPU_INTEN_PERIPHACCERR = 0x4
	// Disable
	SPU_INTEN_PERIPHACCERR_Disabled = 0x0
	// Enable
	SPU_INTEN_PERIPHACCERR_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RAMACCERR field.
	SPU_INTENSET_RAMACCERR_Pos = 0x0
	// Bit mask of RAMACCERR field.
	SPU_INTENSET_RAMACCERR_Msk = 0x1
	// Bit RAMACCERR.
	SPU_INTENSET_RAMACCERR = 0x1
	// Read: Disabled
	SPU_INTENSET_RAMACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENSET_RAMACCERR_Enabled = 0x1
	// Enable
	SPU_INTENSET_RAMACCERR_Set = 0x1
	// Position of FLASHACCERR field.
	SPU_INTENSET_FLASHACCERR_Pos = 0x1
	// Bit mask of FLASHACCERR field.
	SPU_INTENSET_FLASHACCERR_Msk = 0x2
	// Bit FLASHACCERR.
	SPU_INTENSET_FLASHACCERR = 0x2
	// Read: Disabled
	SPU_INTENSET_FLASHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENSET_FLASHACCERR_Enabled = 0x1
	// Enable
	SPU_INTENSET_FLASHACCERR_Set = 0x1
	// Position of PERIPHACCERR field.
	SPU_INTENSET_PERIPHACCERR_Pos = 0x2
	// Bit mask of PERIPHACCERR field.
	SPU_INTENSET_PERIPHACCERR_Msk = 0x4
	// Bit PERIPHACCERR.
	SPU_INTENSET_PERIPHACCERR = 0x4
	// Read: Disabled
	SPU_INTENSET_PERIPHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENSET_PERIPHACCERR_Enabled = 0x1
	// Enable
	SPU_INTENSET_PERIPHACCERR_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RAMACCERR field.
	SPU_INTENCLR_RAMACCERR_Pos = 0x0
	// Bit mask of RAMACCERR field.
	SPU_INTENCLR_RAMACCERR_Msk = 0x1
	// Bit RAMACCERR.
	SPU_INTENCLR_RAMACCERR = 0x1
	// Read: Disabled
	SPU_INTENCLR_RAMACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENCLR_RAMACCERR_Enabled = 0x1
	// Disable
	SPU_INTENCLR_RAMACCERR_Clear = 0x1
	// Position of FLASHACCERR field.
	SPU_INTENCLR_FLASHACCERR_Pos = 0x1
	// Bit mask of FLASHACCERR field.
	SPU_INTENCLR_FLASHACCERR_Msk = 0x2
	// Bit FLASHACCERR.
	SPU_INTENCLR_FLASHACCERR = 0x2
	// Read: Disabled
	SPU_INTENCLR_FLASHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENCLR_FLASHACCERR_Enabled = 0x1
	// Disable
	SPU_INTENCLR_FLASHACCERR_Clear = 0x1
	// Position of PERIPHACCERR field.
	SPU_INTENCLR_PERIPHACCERR_Pos = 0x2
	// Bit mask of PERIPHACCERR field.
	SPU_INTENCLR_PERIPHACCERR_Msk = 0x4
	// Bit PERIPHACCERR.
	SPU_INTENCLR_PERIPHACCERR = 0x4
	// Read: Disabled
	SPU_INTENCLR_PERIPHACCERR_Disabled = 0x0
	// Read: Enabled
	SPU_INTENCLR_PERIPHACCERR_Enabled = 0x1
	// Disable
	SPU_INTENCLR_PERIPHACCERR_Clear = 0x1

	// CAP: Show implemented features for the current device
	// Position of TZM field.
	SPU_CAP_TZM_Pos = 0x0
	// Bit mask of TZM field.
	SPU_CAP_TZM_Msk = 0x1
	// Bit TZM.
	SPU_CAP_TZM = 0x1
	// ARM TrustZone support not available
	SPU_CAP_TZM_NotAvailable = 0x0
	// ARM TrustZone support is available
	SPU_CAP_TZM_Enabled = 0x1

	// EXTDOMAIN.PERM: Description cluster: Access for bus access generated from the external domain n List capabilities of the external domain n
	// Position of SECUREMAPPING field.
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_Pos = 0x0
	// Bit mask of SECUREMAPPING field.
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_Msk = 0x3
	// The bus access from this external domain always have the non-secure attribute set
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_NonSecure = 0x0
	// The bus access from this external domain always have the secure attribute set
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_Secure = 0x1
	// Non-secure or secure attribute for bus access from this domain is defined by the EXTDOMAIN[n].PERM register
	SPU_EXTDOMAIN_PERM_SECUREMAPPING_UserSelectable = 0x2
	// Position of SECATTR field.
	SPU_EXTDOMAIN_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_EXTDOMAIN_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_EXTDOMAIN_PERM_SECATTR = 0x10
	// Bus accesses from this domain have the non-secure attribute set
	SPU_EXTDOMAIN_PERM_SECATTR_NonSecure = 0x0
	// Bus accesses from this domain have secure attribute set
	SPU_EXTDOMAIN_PERM_SECATTR_Secure = 0x1
	// Position of LOCK field.
	SPU_EXTDOMAIN_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_EXTDOMAIN_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_EXTDOMAIN_PERM_LOCK = 0x100
	// This register can be updated
	SPU_EXTDOMAIN_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_EXTDOMAIN_PERM_LOCK_Locked = 0x1

	// DPPI.PERM: Description cluster: Select between secure and non-secure attribute for the DPPI channels.
	// Position of CHANNEL0 field.
	SPU_DPPI_PERM_CHANNEL0_Pos = 0x0
	// Bit mask of CHANNEL0 field.
	SPU_DPPI_PERM_CHANNEL0_Msk = 0x1
	// Bit CHANNEL0.
	SPU_DPPI_PERM_CHANNEL0 = 0x1
	// Channel0 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL0_Secure = 0x1
	// Channel0 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL0_NonSecure = 0x0
	// Position of CHANNEL1 field.
	SPU_DPPI_PERM_CHANNEL1_Pos = 0x1
	// Bit mask of CHANNEL1 field.
	SPU_DPPI_PERM_CHANNEL1_Msk = 0x2
	// Bit CHANNEL1.
	SPU_DPPI_PERM_CHANNEL1 = 0x2
	// Channel1 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL1_Secure = 0x1
	// Channel1 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL1_NonSecure = 0x0
	// Position of CHANNEL2 field.
	SPU_DPPI_PERM_CHANNEL2_Pos = 0x2
	// Bit mask of CHANNEL2 field.
	SPU_DPPI_PERM_CHANNEL2_Msk = 0x4
	// Bit CHANNEL2.
	SPU_DPPI_PERM_CHANNEL2 = 0x4
	// Channel2 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL2_Secure = 0x1
	// Channel2 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL2_NonSecure = 0x0
	// Position of CHANNEL3 field.
	SPU_DPPI_PERM_CHANNEL3_Pos = 0x3
	// Bit mask of CHANNEL3 field.
	SPU_DPPI_PERM_CHANNEL3_Msk = 0x8
	// Bit CHANNEL3.
	SPU_DPPI_PERM_CHANNEL3 = 0x8
	// Channel3 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL3_Secure = 0x1
	// Channel3 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL3_NonSecure = 0x0
	// Position of CHANNEL4 field.
	SPU_DPPI_PERM_CHANNEL4_Pos = 0x4
	// Bit mask of CHANNEL4 field.
	SPU_DPPI_PERM_CHANNEL4_Msk = 0x10
	// Bit CHANNEL4.
	SPU_DPPI_PERM_CHANNEL4 = 0x10
	// Channel4 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL4_Secure = 0x1
	// Channel4 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL4_NonSecure = 0x0
	// Position of CHANNEL5 field.
	SPU_DPPI_PERM_CHANNEL5_Pos = 0x5
	// Bit mask of CHANNEL5 field.
	SPU_DPPI_PERM_CHANNEL5_Msk = 0x20
	// Bit CHANNEL5.
	SPU_DPPI_PERM_CHANNEL5 = 0x20
	// Channel5 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL5_Secure = 0x1
	// Channel5 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL5_NonSecure = 0x0
	// Position of CHANNEL6 field.
	SPU_DPPI_PERM_CHANNEL6_Pos = 0x6
	// Bit mask of CHANNEL6 field.
	SPU_DPPI_PERM_CHANNEL6_Msk = 0x40
	// Bit CHANNEL6.
	SPU_DPPI_PERM_CHANNEL6 = 0x40
	// Channel6 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL6_Secure = 0x1
	// Channel6 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL6_NonSecure = 0x0
	// Position of CHANNEL7 field.
	SPU_DPPI_PERM_CHANNEL7_Pos = 0x7
	// Bit mask of CHANNEL7 field.
	SPU_DPPI_PERM_CHANNEL7_Msk = 0x80
	// Bit CHANNEL7.
	SPU_DPPI_PERM_CHANNEL7 = 0x80
	// Channel7 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL7_Secure = 0x1
	// Channel7 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL7_NonSecure = 0x0
	// Position of CHANNEL8 field.
	SPU_DPPI_PERM_CHANNEL8_Pos = 0x8
	// Bit mask of CHANNEL8 field.
	SPU_DPPI_PERM_CHANNEL8_Msk = 0x100
	// Bit CHANNEL8.
	SPU_DPPI_PERM_CHANNEL8 = 0x100
	// Channel8 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL8_Secure = 0x1
	// Channel8 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL8_NonSecure = 0x0
	// Position of CHANNEL9 field.
	SPU_DPPI_PERM_CHANNEL9_Pos = 0x9
	// Bit mask of CHANNEL9 field.
	SPU_DPPI_PERM_CHANNEL9_Msk = 0x200
	// Bit CHANNEL9.
	SPU_DPPI_PERM_CHANNEL9 = 0x200
	// Channel9 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL9_Secure = 0x1
	// Channel9 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL9_NonSecure = 0x0
	// Position of CHANNEL10 field.
	SPU_DPPI_PERM_CHANNEL10_Pos = 0xa
	// Bit mask of CHANNEL10 field.
	SPU_DPPI_PERM_CHANNEL10_Msk = 0x400
	// Bit CHANNEL10.
	SPU_DPPI_PERM_CHANNEL10 = 0x400
	// Channel10 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL10_Secure = 0x1
	// Channel10 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL10_NonSecure = 0x0
	// Position of CHANNEL11 field.
	SPU_DPPI_PERM_CHANNEL11_Pos = 0xb
	// Bit mask of CHANNEL11 field.
	SPU_DPPI_PERM_CHANNEL11_Msk = 0x800
	// Bit CHANNEL11.
	SPU_DPPI_PERM_CHANNEL11 = 0x800
	// Channel11 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL11_Secure = 0x1
	// Channel11 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL11_NonSecure = 0x0
	// Position of CHANNEL12 field.
	SPU_DPPI_PERM_CHANNEL12_Pos = 0xc
	// Bit mask of CHANNEL12 field.
	SPU_DPPI_PERM_CHANNEL12_Msk = 0x1000
	// Bit CHANNEL12.
	SPU_DPPI_PERM_CHANNEL12 = 0x1000
	// Channel12 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL12_Secure = 0x1
	// Channel12 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL12_NonSecure = 0x0
	// Position of CHANNEL13 field.
	SPU_DPPI_PERM_CHANNEL13_Pos = 0xd
	// Bit mask of CHANNEL13 field.
	SPU_DPPI_PERM_CHANNEL13_Msk = 0x2000
	// Bit CHANNEL13.
	SPU_DPPI_PERM_CHANNEL13 = 0x2000
	// Channel13 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL13_Secure = 0x1
	// Channel13 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL13_NonSecure = 0x0
	// Position of CHANNEL14 field.
	SPU_DPPI_PERM_CHANNEL14_Pos = 0xe
	// Bit mask of CHANNEL14 field.
	SPU_DPPI_PERM_CHANNEL14_Msk = 0x4000
	// Bit CHANNEL14.
	SPU_DPPI_PERM_CHANNEL14 = 0x4000
	// Channel14 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL14_Secure = 0x1
	// Channel14 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL14_NonSecure = 0x0
	// Position of CHANNEL15 field.
	SPU_DPPI_PERM_CHANNEL15_Pos = 0xf
	// Bit mask of CHANNEL15 field.
	SPU_DPPI_PERM_CHANNEL15_Msk = 0x8000
	// Bit CHANNEL15.
	SPU_DPPI_PERM_CHANNEL15 = 0x8000
	// Channel15 has its secure attribute set
	SPU_DPPI_PERM_CHANNEL15_Secure = 0x1
	// Channel15 has its non-secure attribute set
	SPU_DPPI_PERM_CHANNEL15_NonSecure = 0x0

	// DPPI.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
	// Position of LOCK field.
	SPU_DPPI_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SPU_DPPI_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	SPU_DPPI_LOCK_LOCK = 0x1
	// DPPI[n].PERM register can't be changed until next reset
	SPU_DPPI_LOCK_LOCK_Locked = 0x1
	// DPPI[n].PERM register content can be changed
	SPU_DPPI_LOCK_LOCK_Unlocked = 0x0

	// GPIOPORT.PERM: Description cluster: Select between secure and non-secure attribute for pins 0 to 31 of port n.
	// Position of PIN0 field.
	SPU_GPIOPORT_PERM_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	SPU_GPIOPORT_PERM_PIN0_Msk = 0x1
	// Bit PIN0.
	SPU_GPIOPORT_PERM_PIN0 = 0x1
	// Pin 0 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN0_Secure = 0x1
	// Pin 0 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN0_NonSecure = 0x0
	// Position of PIN1 field.
	SPU_GPIOPORT_PERM_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	SPU_GPIOPORT_PERM_PIN1_Msk = 0x2
	// Bit PIN1.
	SPU_GPIOPORT_PERM_PIN1 = 0x2
	// Pin 1 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN1_Secure = 0x1
	// Pin 1 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN1_NonSecure = 0x0
	// Position of PIN2 field.
	SPU_GPIOPORT_PERM_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	SPU_GPIOPORT_PERM_PIN2_Msk = 0x4
	// Bit PIN2.
	SPU_GPIOPORT_PERM_PIN2 = 0x4
	// Pin 2 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN2_Secure = 0x1
	// Pin 2 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN2_NonSecure = 0x0
	// Position of PIN3 field.
	SPU_GPIOPORT_PERM_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	SPU_GPIOPORT_PERM_PIN3_Msk = 0x8
	// Bit PIN3.
	SPU_GPIOPORT_PERM_PIN3 = 0x8
	// Pin 3 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN3_Secure = 0x1
	// Pin 3 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN3_NonSecure = 0x0
	// Position of PIN4 field.
	SPU_GPIOPORT_PERM_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	SPU_GPIOPORT_PERM_PIN4_Msk = 0x10
	// Bit PIN4.
	SPU_GPIOPORT_PERM_PIN4 = 0x10
	// Pin 4 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN4_Secure = 0x1
	// Pin 4 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN4_NonSecure = 0x0
	// Position of PIN5 field.
	SPU_GPIOPORT_PERM_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	SPU_GPIOPORT_PERM_PIN5_Msk = 0x20
	// Bit PIN5.
	SPU_GPIOPORT_PERM_PIN5 = 0x20
	// Pin 5 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN5_Secure = 0x1
	// Pin 5 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN5_NonSecure = 0x0
	// Position of PIN6 field.
	SPU_GPIOPORT_PERM_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	SPU_GPIOPORT_PERM_PIN6_Msk = 0x40
	// Bit PIN6.
	SPU_GPIOPORT_PERM_PIN6 = 0x40
	// Pin 6 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN6_Secure = 0x1
	// Pin 6 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN6_NonSecure = 0x0
	// Position of PIN7 field.
	SPU_GPIOPORT_PERM_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	SPU_GPIOPORT_PERM_PIN7_Msk = 0x80
	// Bit PIN7.
	SPU_GPIOPORT_PERM_PIN7 = 0x80
	// Pin 7 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN7_Secure = 0x1
	// Pin 7 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN7_NonSecure = 0x0
	// Position of PIN8 field.
	SPU_GPIOPORT_PERM_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	SPU_GPIOPORT_PERM_PIN8_Msk = 0x100
	// Bit PIN8.
	SPU_GPIOPORT_PERM_PIN8 = 0x100
	// Pin 8 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN8_Secure = 0x1
	// Pin 8 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN8_NonSecure = 0x0
	// Position of PIN9 field.
	SPU_GPIOPORT_PERM_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	SPU_GPIOPORT_PERM_PIN9_Msk = 0x200
	// Bit PIN9.
	SPU_GPIOPORT_PERM_PIN9 = 0x200
	// Pin 9 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN9_Secure = 0x1
	// Pin 9 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN9_NonSecure = 0x0
	// Position of PIN10 field.
	SPU_GPIOPORT_PERM_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	SPU_GPIOPORT_PERM_PIN10_Msk = 0x400
	// Bit PIN10.
	SPU_GPIOPORT_PERM_PIN10 = 0x400
	// Pin 10 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN10_Secure = 0x1
	// Pin 10 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN10_NonSecure = 0x0
	// Position of PIN11 field.
	SPU_GPIOPORT_PERM_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	SPU_GPIOPORT_PERM_PIN11_Msk = 0x800
	// Bit PIN11.
	SPU_GPIOPORT_PERM_PIN11 = 0x800
	// Pin 11 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN11_Secure = 0x1
	// Pin 11 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN11_NonSecure = 0x0
	// Position of PIN12 field.
	SPU_GPIOPORT_PERM_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	SPU_GPIOPORT_PERM_PIN12_Msk = 0x1000
	// Bit PIN12.
	SPU_GPIOPORT_PERM_PIN12 = 0x1000
	// Pin 12 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN12_Secure = 0x1
	// Pin 12 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN12_NonSecure = 0x0
	// Position of PIN13 field.
	SPU_GPIOPORT_PERM_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	SPU_GPIOPORT_PERM_PIN13_Msk = 0x2000
	// Bit PIN13.
	SPU_GPIOPORT_PERM_PIN13 = 0x2000
	// Pin 13 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN13_Secure = 0x1
	// Pin 13 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN13_NonSecure = 0x0
	// Position of PIN14 field.
	SPU_GPIOPORT_PERM_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	SPU_GPIOPORT_PERM_PIN14_Msk = 0x4000
	// Bit PIN14.
	SPU_GPIOPORT_PERM_PIN14 = 0x4000
	// Pin 14 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN14_Secure = 0x1
	// Pin 14 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN14_NonSecure = 0x0
	// Position of PIN15 field.
	SPU_GPIOPORT_PERM_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	SPU_GPIOPORT_PERM_PIN15_Msk = 0x8000
	// Bit PIN15.
	SPU_GPIOPORT_PERM_PIN15 = 0x8000
	// Pin 15 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN15_Secure = 0x1
	// Pin 15 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN15_NonSecure = 0x0
	// Position of PIN16 field.
	SPU_GPIOPORT_PERM_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	SPU_GPIOPORT_PERM_PIN16_Msk = 0x10000
	// Bit PIN16.
	SPU_GPIOPORT_PERM_PIN16 = 0x10000
	// Pin 16 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN16_Secure = 0x1
	// Pin 16 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN16_NonSecure = 0x0
	// Position of PIN17 field.
	SPU_GPIOPORT_PERM_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	SPU_GPIOPORT_PERM_PIN17_Msk = 0x20000
	// Bit PIN17.
	SPU_GPIOPORT_PERM_PIN17 = 0x20000
	// Pin 17 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN17_Secure = 0x1
	// Pin 17 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN17_NonSecure = 0x0
	// Position of PIN18 field.
	SPU_GPIOPORT_PERM_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	SPU_GPIOPORT_PERM_PIN18_Msk = 0x40000
	// Bit PIN18.
	SPU_GPIOPORT_PERM_PIN18 = 0x40000
	// Pin 18 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN18_Secure = 0x1
	// Pin 18 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN18_NonSecure = 0x0
	// Position of PIN19 field.
	SPU_GPIOPORT_PERM_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	SPU_GPIOPORT_PERM_PIN19_Msk = 0x80000
	// Bit PIN19.
	SPU_GPIOPORT_PERM_PIN19 = 0x80000
	// Pin 19 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN19_Secure = 0x1
	// Pin 19 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN19_NonSecure = 0x0
	// Position of PIN20 field.
	SPU_GPIOPORT_PERM_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	SPU_GPIOPORT_PERM_PIN20_Msk = 0x100000
	// Bit PIN20.
	SPU_GPIOPORT_PERM_PIN20 = 0x100000
	// Pin 20 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN20_Secure = 0x1
	// Pin 20 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN20_NonSecure = 0x0
	// Position of PIN21 field.
	SPU_GPIOPORT_PERM_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	SPU_GPIOPORT_PERM_PIN21_Msk = 0x200000
	// Bit PIN21.
	SPU_GPIOPORT_PERM_PIN21 = 0x200000
	// Pin 21 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN21_Secure = 0x1
	// Pin 21 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN21_NonSecure = 0x0
	// Position of PIN22 field.
	SPU_GPIOPORT_PERM_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	SPU_GPIOPORT_PERM_PIN22_Msk = 0x400000
	// Bit PIN22.
	SPU_GPIOPORT_PERM_PIN22 = 0x400000
	// Pin 22 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN22_Secure = 0x1
	// Pin 22 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN22_NonSecure = 0x0
	// Position of PIN23 field.
	SPU_GPIOPORT_PERM_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	SPU_GPIOPORT_PERM_PIN23_Msk = 0x800000
	// Bit PIN23.
	SPU_GPIOPORT_PERM_PIN23 = 0x800000
	// Pin 23 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN23_Secure = 0x1
	// Pin 23 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN23_NonSecure = 0x0
	// Position of PIN24 field.
	SPU_GPIOPORT_PERM_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	SPU_GPIOPORT_PERM_PIN24_Msk = 0x1000000
	// Bit PIN24.
	SPU_GPIOPORT_PERM_PIN24 = 0x1000000
	// Pin 24 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN24_Secure = 0x1
	// Pin 24 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN24_NonSecure = 0x0
	// Position of PIN25 field.
	SPU_GPIOPORT_PERM_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	SPU_GPIOPORT_PERM_PIN25_Msk = 0x2000000
	// Bit PIN25.
	SPU_GPIOPORT_PERM_PIN25 = 0x2000000
	// Pin 25 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN25_Secure = 0x1
	// Pin 25 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN25_NonSecure = 0x0
	// Position of PIN26 field.
	SPU_GPIOPORT_PERM_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	SPU_GPIOPORT_PERM_PIN26_Msk = 0x4000000
	// Bit PIN26.
	SPU_GPIOPORT_PERM_PIN26 = 0x4000000
	// Pin 26 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN26_Secure = 0x1
	// Pin 26 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN26_NonSecure = 0x0
	// Position of PIN27 field.
	SPU_GPIOPORT_PERM_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	SPU_GPIOPORT_PERM_PIN27_Msk = 0x8000000
	// Bit PIN27.
	SPU_GPIOPORT_PERM_PIN27 = 0x8000000
	// Pin 27 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN27_Secure = 0x1
	// Pin 27 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN27_NonSecure = 0x0
	// Position of PIN28 field.
	SPU_GPIOPORT_PERM_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	SPU_GPIOPORT_PERM_PIN28_Msk = 0x10000000
	// Bit PIN28.
	SPU_GPIOPORT_PERM_PIN28 = 0x10000000
	// Pin 28 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN28_Secure = 0x1
	// Pin 28 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN28_NonSecure = 0x0
	// Position of PIN29 field.
	SPU_GPIOPORT_PERM_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	SPU_GPIOPORT_PERM_PIN29_Msk = 0x20000000
	// Bit PIN29.
	SPU_GPIOPORT_PERM_PIN29 = 0x20000000
	// Pin 29 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN29_Secure = 0x1
	// Pin 29 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN29_NonSecure = 0x0
	// Position of PIN30 field.
	SPU_GPIOPORT_PERM_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	SPU_GPIOPORT_PERM_PIN30_Msk = 0x40000000
	// Bit PIN30.
	SPU_GPIOPORT_PERM_PIN30 = 0x40000000
	// Pin 30 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN30_Secure = 0x1
	// Pin 30 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN30_NonSecure = 0x0
	// Position of PIN31 field.
	SPU_GPIOPORT_PERM_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	SPU_GPIOPORT_PERM_PIN31_Msk = 0x80000000
	// Bit PIN31.
	SPU_GPIOPORT_PERM_PIN31 = 0x80000000
	// Pin 31 has its secure attribute set
	SPU_GPIOPORT_PERM_PIN31_Secure = 0x1
	// Pin 31 has its non-secure attribute set
	SPU_GPIOPORT_PERM_PIN31_NonSecure = 0x0

	// GPIOPORT.LOCK: Description cluster: Prevent further modification of the corresponding PERM register
	// Position of LOCK field.
	SPU_GPIOPORT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SPU_GPIOPORT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	SPU_GPIOPORT_LOCK_LOCK = 0x1
	// GPIOPORT[n].PERM register can't be changed until next reset
	SPU_GPIOPORT_LOCK_LOCK_Locked = 0x1
	// GPIOPORT[n].PERM register content can be changed
	SPU_GPIOPORT_LOCK_LOCK_Unlocked = 0x0

	// FLASHNSC.REGION: Description cluster: Define which flash region can contain the non-secure callable (NSC) region n
	// Position of REGION field.
	SPU_FLASHNSC_REGION_REGION_Pos = 0x0
	// Bit mask of REGION field.
	SPU_FLASHNSC_REGION_REGION_Msk = 0x1f
	// Position of LOCK field.
	SPU_FLASHNSC_REGION_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_FLASHNSC_REGION_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_FLASHNSC_REGION_LOCK = 0x100
	// This register can be updated
	SPU_FLASHNSC_REGION_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_FLASHNSC_REGION_LOCK_Locked = 0x1

	// FLASHNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
	// Position of SIZE field.
	SPU_FLASHNSC_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	SPU_FLASHNSC_SIZE_SIZE_Msk = 0xf
	// The region n is not defined as a non-secure callable region. Normal security attributes (secure or non-secure) are enforced.
	SPU_FLASHNSC_SIZE_SIZE_Disabled = 0x0
	// The region n is defined as non-secure callable with a 32-byte size
	SPU_FLASHNSC_SIZE_SIZE_32 = 0x1
	// The region n is defined as non-secure callable with a 64-byte size
	SPU_FLASHNSC_SIZE_SIZE_64 = 0x2
	// The region n is defined as non-secure callable with a 128-byte size
	SPU_FLASHNSC_SIZE_SIZE_128 = 0x3
	// The region n is defined as non-secure callable with a 256-byte size
	SPU_FLASHNSC_SIZE_SIZE_256 = 0x4
	// The region n is defined as non-secure callable with a 512-byte size
	SPU_FLASHNSC_SIZE_SIZE_512 = 0x5
	// The region n is defined as non-secure callable with a 1024-byte size
	SPU_FLASHNSC_SIZE_SIZE_1024 = 0x6
	// The region n is defined as non-secure callable with a 2048-byte size
	SPU_FLASHNSC_SIZE_SIZE_2048 = 0x7
	// The region n is defined as non-secure callable with a 4096-byte size
	SPU_FLASHNSC_SIZE_SIZE_4096 = 0x8
	// Position of LOCK field.
	SPU_FLASHNSC_SIZE_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_FLASHNSC_SIZE_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_FLASHNSC_SIZE_LOCK = 0x100
	// This register can be updated
	SPU_FLASHNSC_SIZE_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_FLASHNSC_SIZE_LOCK_Locked = 0x1

	// RAMNSC.REGION: Description cluster: Define which RAM region can contain the non-secure callable (NSC) region n
	// Position of REGION field.
	SPU_RAMNSC_REGION_REGION_Pos = 0x0
	// Bit mask of REGION field.
	SPU_RAMNSC_REGION_REGION_Msk = 0xf
	// Position of LOCK field.
	SPU_RAMNSC_REGION_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_RAMNSC_REGION_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_RAMNSC_REGION_LOCK = 0x100
	// This register can be updated
	SPU_RAMNSC_REGION_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_RAMNSC_REGION_LOCK_Locked = 0x1

	// RAMNSC.SIZE: Description cluster: Define the size of the non-secure callable (NSC) region n
	// Position of SIZE field.
	SPU_RAMNSC_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	SPU_RAMNSC_SIZE_SIZE_Msk = 0xf
	// The region n is not defined as a non-secure callable region. Normal security attributes (secure or non-secure) are enforced.
	SPU_RAMNSC_SIZE_SIZE_Disabled = 0x0
	// The region n is defined as non-secure callable with a 32-byte size
	SPU_RAMNSC_SIZE_SIZE_32 = 0x1
	// The region n is defined as non-secure callable with a 64-byte size
	SPU_RAMNSC_SIZE_SIZE_64 = 0x2
	// The region n is defined as non-secure callable with a 128-byte size
	SPU_RAMNSC_SIZE_SIZE_128 = 0x3
	// The region n is defined as non-secure callable with a 256-byte size
	SPU_RAMNSC_SIZE_SIZE_256 = 0x4
	// The region n is defined as non-secure callable with a 512-byte size
	SPU_RAMNSC_SIZE_SIZE_512 = 0x5
	// The region n is defined as non-secure callable with a 1024-byte size
	SPU_RAMNSC_SIZE_SIZE_1024 = 0x6
	// The region n is defined as non-secure callable with a 2048-byte size
	SPU_RAMNSC_SIZE_SIZE_2048 = 0x7
	// The region n is defined as non-secure callable with a 4096-byte size
	SPU_RAMNSC_SIZE_SIZE_4096 = 0x8
	// Position of LOCK field.
	SPU_RAMNSC_SIZE_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_RAMNSC_SIZE_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_RAMNSC_SIZE_LOCK = 0x100
	// This register can be updated
	SPU_RAMNSC_SIZE_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_RAMNSC_SIZE_LOCK_Locked = 0x1

	// FLASHREGION.PERM: Description cluster: Access permissions for flash region n
	// Position of EXECUTE field.
	SPU_FLASHREGION_PERM_EXECUTE_Pos = 0x0
	// Bit mask of EXECUTE field.
	SPU_FLASHREGION_PERM_EXECUTE_Msk = 0x1
	// Bit EXECUTE.
	SPU_FLASHREGION_PERM_EXECUTE = 0x1
	// Allow instruction fetches from flash region n
	SPU_FLASHREGION_PERM_EXECUTE_Enable = 0x1
	// Block instruction fetches from flash region n
	SPU_FLASHREGION_PERM_EXECUTE_Disable = 0x0
	// Position of WRITE field.
	SPU_FLASHREGION_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	SPU_FLASHREGION_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	SPU_FLASHREGION_PERM_WRITE = 0x2
	// Allow write operation to region n
	SPU_FLASHREGION_PERM_WRITE_Enable = 0x1
	// Block write operation to region n
	SPU_FLASHREGION_PERM_WRITE_Disable = 0x0
	// Position of READ field.
	SPU_FLASHREGION_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	SPU_FLASHREGION_PERM_READ_Msk = 0x4
	// Bit READ.
	SPU_FLASHREGION_PERM_READ = 0x4
	// Allow read operation from flash region n
	SPU_FLASHREGION_PERM_READ_Enable = 0x1
	// Block read operation from flash region n
	SPU_FLASHREGION_PERM_READ_Disable = 0x0
	// Position of SECATTR field.
	SPU_FLASHREGION_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_FLASHREGION_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_FLASHREGION_PERM_SECATTR = 0x10
	// Flash region n security attribute is non-secure
	SPU_FLASHREGION_PERM_SECATTR_Non_Secure = 0x0
	// Flash region n security attribute is secure
	SPU_FLASHREGION_PERM_SECATTR_Secure = 0x1
	// Position of LOCK field.
	SPU_FLASHREGION_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_FLASHREGION_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_FLASHREGION_PERM_LOCK = 0x100
	// This register can be updated
	SPU_FLASHREGION_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_FLASHREGION_PERM_LOCK_Locked = 0x1

	// RAMREGION.PERM: Description cluster: Access permissions for RAM region n
	// Position of EXECUTE field.
	SPU_RAMREGION_PERM_EXECUTE_Pos = 0x0
	// Bit mask of EXECUTE field.
	SPU_RAMREGION_PERM_EXECUTE_Msk = 0x1
	// Bit EXECUTE.
	SPU_RAMREGION_PERM_EXECUTE = 0x1
	// Allow instruction fetches from RAM region n
	SPU_RAMREGION_PERM_EXECUTE_Enable = 0x1
	// Block instruction fetches from RAM region n
	SPU_RAMREGION_PERM_EXECUTE_Disable = 0x0
	// Position of WRITE field.
	SPU_RAMREGION_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	SPU_RAMREGION_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	SPU_RAMREGION_PERM_WRITE = 0x2
	// Allow write operation to RAM region n
	SPU_RAMREGION_PERM_WRITE_Enable = 0x1
	// Block write operation to RAM region n
	SPU_RAMREGION_PERM_WRITE_Disable = 0x0
	// Position of READ field.
	SPU_RAMREGION_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	SPU_RAMREGION_PERM_READ_Msk = 0x4
	// Bit READ.
	SPU_RAMREGION_PERM_READ = 0x4
	// Allow read operation from RAM region n
	SPU_RAMREGION_PERM_READ_Enable = 0x1
	// Block read operation from RAM region n
	SPU_RAMREGION_PERM_READ_Disable = 0x0
	// Position of SECATTR field.
	SPU_RAMREGION_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_RAMREGION_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_RAMREGION_PERM_SECATTR = 0x10
	// RAM region n security attribute is non-secure
	SPU_RAMREGION_PERM_SECATTR_Non_Secure = 0x0
	// RAM region n security attribute is secure
	SPU_RAMREGION_PERM_SECATTR_Secure = 0x1
	// Position of LOCK field.
	SPU_RAMREGION_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_RAMREGION_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_RAMREGION_PERM_LOCK = 0x100
	// This register can be updated
	SPU_RAMREGION_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_RAMREGION_PERM_LOCK_Locked = 0x1

	// PERIPHID.PERM: Description cluster: List capabilities and access permissions for the peripheral with ID n
	// Position of SECUREMAPPING field.
	SPU_PERIPHID_PERM_SECUREMAPPING_Pos = 0x0
	// Bit mask of SECUREMAPPING field.
	SPU_PERIPHID_PERM_SECUREMAPPING_Msk = 0x3
	// This peripheral is always accessible as a non-secure peripheral
	SPU_PERIPHID_PERM_SECUREMAPPING_NonSecure = 0x0
	// This peripheral is always accessible as a secure peripheral
	SPU_PERIPHID_PERM_SECUREMAPPING_Secure = 0x1
	// Non-secure or secure attribute for this peripheral is defined by the PERIPHID[n].PERM register
	SPU_PERIPHID_PERM_SECUREMAPPING_UserSelectable = 0x2
	// This peripheral implements the split security mechanism. Non-secure or secure attribute for this peripheral is defined by the PERIPHID[n].PERM register.
	SPU_PERIPHID_PERM_SECUREMAPPING_Split = 0x3
	// Position of DMA field.
	SPU_PERIPHID_PERM_DMA_Pos = 0x2
	// Bit mask of DMA field.
	SPU_PERIPHID_PERM_DMA_Msk = 0xc
	// Peripheral has no DMA capability
	SPU_PERIPHID_PERM_DMA_NoDMA = 0x0
	// Peripheral has DMA and DMA transfers always have the same security attribute as assigned to the peripheral
	SPU_PERIPHID_PERM_DMA_NoSeparateAttribute = 0x1
	// Peripheral has DMA and DMA transfers can have a different security attribute than the one assigned to the peripheral
	SPU_PERIPHID_PERM_DMA_SeparateAttribute = 0x2
	// Position of SECATTR field.
	SPU_PERIPHID_PERM_SECATTR_Pos = 0x4
	// Bit mask of SECATTR field.
	SPU_PERIPHID_PERM_SECATTR_Msk = 0x10
	// Bit SECATTR.
	SPU_PERIPHID_PERM_SECATTR = 0x10
	// Peripheral is mapped in secure peripheral address space
	SPU_PERIPHID_PERM_SECATTR_Secure = 0x1
	// If SECUREMAPPING == UserSelectable: Peripheral is mapped in non-secure peripheral address space. If SECUREMAPPING == Split: Peripheral is mapped in non-secure and secure peripheral address space.
	SPU_PERIPHID_PERM_SECATTR_NonSecure = 0x0
	// Position of DMASEC field.
	SPU_PERIPHID_PERM_DMASEC_Pos = 0x5
	// Bit mask of DMASEC field.
	SPU_PERIPHID_PERM_DMASEC_Msk = 0x20
	// Bit DMASEC.
	SPU_PERIPHID_PERM_DMASEC = 0x20
	// DMA transfers initiated by this peripheral have the secure attribute set
	SPU_PERIPHID_PERM_DMASEC_Secure = 0x1
	// DMA transfers initiated by this peripheral have the non-secure attribute set
	SPU_PERIPHID_PERM_DMASEC_NonSecure = 0x0
	// Position of LOCK field.
	SPU_PERIPHID_PERM_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	SPU_PERIPHID_PERM_LOCK_Msk = 0x100
	// Bit LOCK.
	SPU_PERIPHID_PERM_LOCK = 0x100
	// This register can be updated
	SPU_PERIPHID_PERM_LOCK_Unlocked = 0x0
	// The content of this register can't be changed until the next reset
	SPU_PERIPHID_PERM_LOCK_Locked = 0x1
	// Position of PRESENT field.
	SPU_PERIPHID_PERM_PRESENT_Pos = 0x1f
	// Bit mask of PRESENT field.
	SPU_PERIPHID_PERM_PRESENT_Msk = 0x80000000
	// Bit PRESENT.
	SPU_PERIPHID_PERM_PRESENT = 0x80000000
	// Peripheral is not present
	SPU_PERIPHID_PERM_PRESENT_NotPresent = 0x0
	// Peripheral is present
	SPU_PERIPHID_PERM_PRESENT_IsPresent = 0x1
)

// Constants for REGULATORS_NS: Voltage regulators control 0
const (
	// SYSTEMOFF: System OFF register
	// Position of SYSTEMOFF field.
	REGULATORS_SYSTEMOFF_SYSTEMOFF_Pos = 0x0
	// Bit mask of SYSTEMOFF field.
	REGULATORS_SYSTEMOFF_SYSTEMOFF_Msk = 0x1
	// Bit SYSTEMOFF.
	REGULATORS_SYSTEMOFF_SYSTEMOFF = 0x1
	// Enable System OFF mode
	REGULATORS_SYSTEMOFF_SYSTEMOFF_Enable = 0x1

	// DCDCEN: Enable DC/DC mode of the main voltage regulator.
	// Position of DCDCEN field.
	REGULATORS_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	REGULATORS_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	REGULATORS_DCDCEN_DCDCEN = 0x1
	// DC/DC mode is disabled
	REGULATORS_DCDCEN_DCDCEN_Disabled = 0x0
	// DC/DC mode is enabled
	REGULATORS_DCDCEN_DCDCEN_Enabled = 0x1
)

// Constants for CLOCK_NS: Clock management 0
const (
	// TASKS_HFCLKSTART: Start HFCLK source
	// Position of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Msk = 0x1
	// Bit TASKS_HFCLKSTART.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger = 0x1

	// TASKS_HFCLKSTOP: Stop HFCLK source
	// Position of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Msk = 0x1
	// Bit TASKS_HFCLKSTOP.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Trigger = 0x1

	// TASKS_LFCLKSTART: Start LFCLK source
	// Position of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Msk = 0x1
	// Bit TASKS_LFCLKSTART.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Trigger = 0x1

	// TASKS_LFCLKSTOP: Stop LFCLK source
	// Position of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Msk = 0x1
	// Bit TASKS_LFCLKSTOP.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Trigger = 0x1

	// SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Msk = 0xf
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Msk = 0xf
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Msk = 0xf
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Msk = 0xf
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Enabled = 0x1

	// EVENTS_HFCLKSTARTED: HFCLK oscillator started
	// Position of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKSTARTED.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Generated = 0x1

	// EVENTS_LFCLKSTARTED: LFCLK started
	// Position of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_LFCLKSTARTED.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Generated = 0x1

	// PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_HFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_LFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTEN_HFCLKSTARTED = 0x1
	// Disable
	CLOCK_INTEN_HFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_HFCLKSTARTED_Enabled = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTEN_LFCLKSTARTED = 0x2
	// Disable
	CLOCK_INTEN_LFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_LFCLKSTARTED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of HFCLKSTARTED field.
	CLOCK_INTPEND_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTPEND_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTPEND_HFCLKSTARTED = 0x1
	// Read: Not pending
	CLOCK_INTPEND_HFCLKSTARTED_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_HFCLKSTARTED_Pending = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTPEND_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTPEND_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTPEND_LFCLKSTARTED = 0x2
	// Read: Not pending
	CLOCK_INTPEND_LFCLKSTARTED_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_LFCLKSTARTED_Pending = 0x1

	// HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_HFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_HFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_HFCLKRUN_STATUS_Triggered = 0x1

	// HFCLKSTAT: The register shows if HFXO has been requested by triggering HFCLKSTART task and if it has been started (STATE)
	// Position of SRC field.
	CLOCK_HFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSTAT_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSTAT_SRC = 0x1
	// HFXO - 64 MHz clock derived from external 32 MHz crystal oscillator
	CLOCK_HFCLKSTAT_SRC_HFXO = 0x1
	// Position of STATE field.
	CLOCK_HFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_HFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_HFCLKSTAT_STATE = 0x10000
	// HFXO has not been started or HFCLKSTOP task has been triggered
	CLOCK_HFCLKSTAT_STATE_NotRunning = 0x0
	// HFXO has been started (HFCLKSTARTED event has been generated)
	CLOCK_HFCLKSTAT_STATE_Running = 0x1

	// LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_LFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_LFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_LFCLKRUN_STATUS_Triggered = 0x1

	// LFCLKSTAT: The register shows which LFCLK source has been requested (SRC) when triggering LFCLKSTART task and if the source has been started (STATE)
	// Position of SRC field.
	CLOCK_LFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSTAT_SRC_Msk = 0x3
	// Reserved for future use
	CLOCK_LFCLKSTAT_SRC_RFU = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSTAT_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSTAT_SRC_LFXO = 0x2
	// Position of STATE field.
	CLOCK_LFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_LFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_LFCLKSTAT_STATE = 0x10000
	// Requested LFCLK source has not been started or LFCLKSTOP task has been triggered
	CLOCK_LFCLKSTAT_STATE_NotRunning = 0x0
	// Requested LFCLK source has been started (LFCLKSTARTED event has been generated)
	CLOCK_LFCLKSTAT_STATE_Running = 0x1

	// LFCLKSRCCOPY: Copy of LFCLKSRC register, set after LFCLKSTART task has been triggered
	// Position of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Msk = 0x3
	// Reserved for future use
	CLOCK_LFCLKSRCCOPY_SRC_RFU = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFXO = 0x2

	// LFCLKSRC: Clock source for the LFCLK. LFCLKSTART task starts starts a clock source selected with this register.
	// Position of SRC field.
	CLOCK_LFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRC_SRC_Msk = 0x3
	// Reserved for future use (equals selecting LFRC)
	CLOCK_LFCLKSRC_SRC_RFU = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSRC_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSRC_SRC_LFXO = 0x2
)

// Constants for POWER_NS: Power control 0
const (
	// TASKS_CONSTLAT: Enable constant latency mode.
	// Position of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Pos = 0x0
	// Bit mask of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Msk = 0x1
	// Bit TASKS_CONSTLAT.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT = 0x1
	// Trigger task
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Trigger = 0x1

	// TASKS_LOWPWR: Enable low power mode (variable latency)
	// Position of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Pos = 0x0
	// Bit mask of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Msk = 0x1
	// Bit TASKS_LOWPWR.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR = 0x1
	// Trigger task
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Trigger = 0x1

	// SUBSCRIBE_CONSTLAT: Subscribe configuration for task CONSTLAT
	// Position of CHIDX field.
	POWER_SUBSCRIBE_CONSTLAT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_SUBSCRIBE_CONSTLAT_CHIDX_Msk = 0xf
	// Position of EN field.
	POWER_SUBSCRIBE_CONSTLAT_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_SUBSCRIBE_CONSTLAT_EN_Msk = 0x80000000
	// Bit EN.
	POWER_SUBSCRIBE_CONSTLAT_EN = 0x80000000
	// Disable subscription
	POWER_SUBSCRIBE_CONSTLAT_EN_Disabled = 0x0
	// Enable subscription
	POWER_SUBSCRIBE_CONSTLAT_EN_Enabled = 0x1

	// SUBSCRIBE_LOWPWR: Subscribe configuration for task LOWPWR
	// Position of CHIDX field.
	POWER_SUBSCRIBE_LOWPWR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_SUBSCRIBE_LOWPWR_CHIDX_Msk = 0xf
	// Position of EN field.
	POWER_SUBSCRIBE_LOWPWR_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_SUBSCRIBE_LOWPWR_EN_Msk = 0x80000000
	// Bit EN.
	POWER_SUBSCRIBE_LOWPWR_EN = 0x80000000
	// Disable subscription
	POWER_SUBSCRIBE_LOWPWR_EN_Disabled = 0x0
	// Enable subscription
	POWER_SUBSCRIBE_LOWPWR_EN_Enabled = 0x1

	// EVENTS_POFWARN: Power failure warning
	// Position of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Pos = 0x0
	// Bit mask of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Msk = 0x1
	// Bit EVENTS_POFWARN.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN = 0x1
	// Event not generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Generated = 0x1

	// EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
	// Position of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Pos = 0x0
	// Bit mask of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Msk = 0x1
	// Bit EVENTS_SLEEPENTER.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Generated = 0x1

	// EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
	// Position of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Pos = 0x0
	// Bit mask of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Msk = 0x1
	// Bit EVENTS_SLEEPEXIT.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Generated = 0x1

	// PUBLISH_POFWARN: Publish configuration for event POFWARN
	// Position of CHIDX field.
	POWER_PUBLISH_POFWARN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_POFWARN_CHIDX_Msk = 0xf
	// Position of EN field.
	POWER_PUBLISH_POFWARN_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_POFWARN_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_POFWARN_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_POFWARN_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_POFWARN_EN_Enabled = 0x1

	// PUBLISH_SLEEPENTER: Publish configuration for event SLEEPENTER
	// Position of CHIDX field.
	POWER_PUBLISH_SLEEPENTER_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_SLEEPENTER_CHIDX_Msk = 0xf
	// Position of EN field.
	POWER_PUBLISH_SLEEPENTER_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_SLEEPENTER_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_SLEEPENTER_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_SLEEPENTER_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_SLEEPENTER_EN_Enabled = 0x1

	// PUBLISH_SLEEPEXIT: Publish configuration for event SLEEPEXIT
	// Position of CHIDX field.
	POWER_PUBLISH_SLEEPEXIT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_SLEEPEXIT_CHIDX_Msk = 0xf
	// Position of EN field.
	POWER_PUBLISH_SLEEPEXIT_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_SLEEPEXIT_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_SLEEPEXIT_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_SLEEPEXIT_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_SLEEPEXIT_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of POFWARN field.
	POWER_INTEN_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTEN_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTEN_POFWARN = 0x4
	// Disable
	POWER_INTEN_POFWARN_Disabled = 0x0
	// Enable
	POWER_INTEN_POFWARN_Enabled = 0x1
	// Position of SLEEPENTER field.
	POWER_INTEN_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTEN_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTEN_SLEEPENTER = 0x20
	// Disable
	POWER_INTEN_SLEEPENTER_Disabled = 0x0
	// Enable
	POWER_INTEN_SLEEPENTER_Enabled = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTEN_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTEN_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTEN_SLEEPEXIT = 0x40
	// Disable
	POWER_INTEN_SLEEPEXIT_Disabled = 0x0
	// Enable
	POWER_INTEN_SLEEPEXIT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of POFWARN field.
	POWER_INTENSET_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENSET_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENSET_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENSET_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_POFWARN_Enabled = 0x1
	// Enable
	POWER_INTENSET_POFWARN_Set = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENSET_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENSET_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPENTER_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPENTER_Set = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENSET_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENSET_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPEXIT_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPEXIT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of POFWARN field.
	POWER_INTENCLR_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENCLR_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENCLR_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENCLR_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_POFWARN_Enabled = 0x1
	// Disable
	POWER_INTENCLR_POFWARN_Clear = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENCLR_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENCLR_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPENTER_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPENTER_Clear = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENCLR_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENCLR_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPEXIT_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPEXIT_Clear = 0x1

	// RESETREAS: Reset reason
	// Position of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Pos = 0x0
	// Bit mask of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Msk = 0x1
	// Bit RESETPIN.
	POWER_RESETREAS_RESETPIN = 0x1
	// Not detected
	POWER_RESETREAS_RESETPIN_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_RESETPIN_Detected = 0x1
	// Position of DOG field.
	POWER_RESETREAS_DOG_Pos = 0x1
	// Bit mask of DOG field.
	POWER_RESETREAS_DOG_Msk = 0x2
	// Bit DOG.
	POWER_RESETREAS_DOG = 0x2
	// Not detected
	POWER_RESETREAS_DOG_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_DOG_Detected = 0x1
	// Position of OFF field.
	POWER_RESETREAS_OFF_Pos = 0x2
	// Bit mask of OFF field.
	POWER_RESETREAS_OFF_Msk = 0x4
	// Bit OFF.
	POWER_RESETREAS_OFF = 0x4
	// Not detected
	POWER_RESETREAS_OFF_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_OFF_Detected = 0x1
	// Position of DIF field.
	POWER_RESETREAS_DIF_Pos = 0x4
	// Bit mask of DIF field.
	POWER_RESETREAS_DIF_Msk = 0x10
	// Bit DIF.
	POWER_RESETREAS_DIF = 0x10
	// Not detected
	POWER_RESETREAS_DIF_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_DIF_Detected = 0x1
	// Position of SREQ field.
	POWER_RESETREAS_SREQ_Pos = 0x10
	// Bit mask of SREQ field.
	POWER_RESETREAS_SREQ_Msk = 0x10000
	// Bit SREQ.
	POWER_RESETREAS_SREQ = 0x10000
	// Not detected
	POWER_RESETREAS_SREQ_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_SREQ_Detected = 0x1
	// Position of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Pos = 0x11
	// Bit mask of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Msk = 0x20000
	// Bit LOCKUP.
	POWER_RESETREAS_LOCKUP = 0x20000
	// Not detected
	POWER_RESETREAS_LOCKUP_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_LOCKUP_Detected = 0x1
	// Position of CTRLAP field.
	POWER_RESETREAS_CTRLAP_Pos = 0x12
	// Bit mask of CTRLAP field.
	POWER_RESETREAS_CTRLAP_Msk = 0x40000
	// Bit CTRLAP.
	POWER_RESETREAS_CTRLAP = 0x40000
	// Not detected
	POWER_RESETREAS_CTRLAP_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_CTRLAP_Detected = 0x1

	// POWERSTATUS: Modem domain power status
	// Position of LTEMODEM field.
	POWER_POWERSTATUS_LTEMODEM_Pos = 0x0
	// Bit mask of LTEMODEM field.
	POWER_POWERSTATUS_LTEMODEM_Msk = 0x1
	// Bit LTEMODEM.
	POWER_POWERSTATUS_LTEMODEM = 0x1
	// LTE modem domain is powered off
	POWER_POWERSTATUS_LTEMODEM_OFF = 0x0
	// LTE modem domain is powered on
	POWER_POWERSTATUS_LTEMODEM_ON = 0x1

	// GPREGRET: Description collection: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Msk = 0xff
)

// Constants for CTRL_AP_PERI_S: Control access port
const (
	// MAILBOX.RXDATA: Data sent from the debugger to the CPU
	// Position of RXDATA field.
	CTRLAPPERI_MAILBOX_RXDATA_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	CTRLAPPERI_MAILBOX_RXDATA_RXDATA_Msk = 0xffffffff

	// MAILBOX.RXSTATUS: Status to indicate if data sent from the debugger to the CPU has been read
	// Position of RXSTATUS field.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_Pos = 0x0
	// Bit mask of RXSTATUS field.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_Msk = 0x1
	// Bit RXSTATUS.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS = 0x1
	// No data pending in register RXDATA
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_NoDataPending = 0x0
	// Data pending in register RXDATA
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_DataPending = 0x1

	// MAILBOX.TXDATA: Data sent from the CPU to the debugger
	// Position of TXDATA field.
	CTRLAPPERI_MAILBOX_TXDATA_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	CTRLAPPERI_MAILBOX_TXDATA_TXDATA_Msk = 0xffffffff

	// MAILBOX.TXSTATUS: Status to indicate if data sent from the CPU to the debugger has been read
	// Position of TXSTATUS field.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_Pos = 0x0
	// Bit mask of TXSTATUS field.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_Msk = 0x1
	// Bit TXSTATUS.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS = 0x1
	// No data pending in register TXDATA
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_NoDataPending = 0x0
	// Data pending in register TXDATA
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_DataPending = 0x1

	// ERASEPROTECT.LOCK: Lock register ERASEPROTECT.DISABLE from being written until next reset
	// Position of LOCK field.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK = 0x1
	// Register ERASEPROTECT.DISABLE is writeable
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Unlocked = 0x0
	// Register ERASEPROTECT.DISABLE is read-only
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Locked = 0x1

	// ERASEPROTECT.DISABLE: Disable ERASEPROTECT and perform ERASEALL
	// Position of KEY field.
	CTRLAPPERI_ERASEPROTECT_DISABLE_KEY_Pos = 0x0
	// Bit mask of KEY field.
	CTRLAPPERI_ERASEPROTECT_DISABLE_KEY_Msk = 0xffffffff
)

// Constants for SPIM0_NS: Serial Peripheral Interface Master with EasyDMA 0
const (
	// TASKS_START: Start SPI transaction
	// Position of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SPIM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SPIM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop SPI transaction
	// Position of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SPIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SPIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend SPI transaction
	// Position of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume SPI transaction
	// Position of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	SPIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	SPIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_RESUME_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// EVENTS_STOPPED: SPI transaction has stopped
	// Position of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_END: End of RXD buffer and TXD buffer reached
	// Position of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDTX: End of TXD buffer reached
	// Position of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_STARTED: Transaction started
	// Position of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SPIM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	SPIM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	SPIM_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_ENDRX_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SPIM_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_END_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_ENDTX: Publish configuration for event ENDTX
	// Position of CHIDX field.
	SPIM_PUBLISH_ENDTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_ENDTX_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_PUBLISH_ENDTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_ENDTX_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_ENDTX_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_ENDTX_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_ENDTX_EN_Enabled = 0x1

	// PUBLISH_STARTED: Publish configuration for event STARTED
	// Position of CHIDX field.
	SPIM_PUBLISH_STARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_STARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIM_PUBLISH_STARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_STARTED_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_STARTED_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_STARTED_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_STARTED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_START field.
	SPIM_SHORTS_END_START_Pos = 0x11
	// Bit mask of END_START field.
	SPIM_SHORTS_END_START_Msk = 0x20000
	// Bit END_START.
	SPIM_SHORTS_END_START = 0x20000
	// Disable shortcut
	SPIM_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	SPIM_SHORTS_END_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	SPIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STOPPED_Set = 0x1
	// Position of ENDRX field.
	SPIM_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDRX_Set = 0x1
	// Position of END field.
	SPIM_INTENSET_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENSET_END_Msk = 0x40
	// Bit END.
	SPIM_INTENSET_END = 0x40
	// Read: Disabled
	SPIM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_END_Enabled = 0x1
	// Enable
	SPIM_INTENSET_END_Set = 0x1
	// Position of ENDTX field.
	SPIM_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENSET_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDTX_Set = 0x1
	// Position of STARTED field.
	SPIM_INTENSET_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENSET_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENSET_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STARTED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	SPIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ENDRX field.
	SPIM_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDRX_Clear = 0x1
	// Position of END field.
	SPIM_INTENCLR_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENCLR_END_Msk = 0x40
	// Bit END.
	SPIM_INTENCLR_END = 0x40
	// Read: Disabled
	SPIM_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_END_Clear = 0x1
	// Position of ENDTX field.
	SPIM_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDTX_Clear = 0x1
	// Position of STARTED field.
	SPIM_INTENCLR_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENCLR_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENCLR_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STARTED_Clear = 0x1

	// ENABLE: Enable SPIM
	// Position of ENABLE field.
	SPIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIM_ENABLE_ENABLE_Msk = 0xf
	// Disable SPIM
	SPIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPIM
	SPIM_ENABLE_ENABLE_Enabled = 0x7

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIM_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_SCK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIM_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIM_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MISO_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MISO_CONNECT_Connected = 0x0

	// FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125 kbps
	SPIM_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250 kbps
	SPIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500 kbps
	SPIM_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1 Mbps
	SPIM_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2 Mbps
	SPIM_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4 Mbps
	SPIM_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8 Mbps
	SPIM_FREQUENCY_FREQUENCY_M8 = 0x80000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIM_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIM_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIM_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIM_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIM_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIM_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIM_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIM_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIM_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIM_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIM_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIM_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIM_CONFIG_CPOL = 0x4
	// Active high
	SPIM_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIM_CONFIG_CPOL_ActiveLow = 0x1

	// ORC: Over-read character. Character clocked out in case an over-read of the TXD buffer.
	// Position of ORC field.
	SPIM_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIM_ORC_ORC_Msk = 0xff
)

// Constants for SPIS0_NS: SPI Slave 0
const (
	// TASKS_ACQUIRE: Acquire SPI semaphore
	// Position of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Pos = 0x0
	// Bit mask of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Msk = 0x1
	// Bit TASKS_ACQUIRE.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE = 0x1
	// Trigger task
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Trigger = 0x1

	// TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
	// Position of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Pos = 0x0
	// Bit mask of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Msk = 0x1
	// Bit TASKS_RELEASE.
	SPIS_TASKS_RELEASE_TASKS_RELEASE = 0x1
	// Trigger task
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Trigger = 0x1

	// SUBSCRIBE_ACQUIRE: Subscribe configuration for task ACQUIRE
	// Position of CHIDX field.
	SPIS_SUBSCRIBE_ACQUIRE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_SUBSCRIBE_ACQUIRE_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIS_SUBSCRIBE_ACQUIRE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_SUBSCRIBE_ACQUIRE_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_SUBSCRIBE_ACQUIRE_EN = 0x80000000
	// Disable subscription
	SPIS_SUBSCRIBE_ACQUIRE_EN_Disabled = 0x0
	// Enable subscription
	SPIS_SUBSCRIBE_ACQUIRE_EN_Enabled = 0x1

	// SUBSCRIBE_RELEASE: Subscribe configuration for task RELEASE
	// Position of CHIDX field.
	SPIS_SUBSCRIBE_RELEASE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_SUBSCRIBE_RELEASE_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIS_SUBSCRIBE_RELEASE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_SUBSCRIBE_RELEASE_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_SUBSCRIBE_RELEASE_EN = 0x80000000
	// Disable subscription
	SPIS_SUBSCRIBE_RELEASE_EN_Disabled = 0x0
	// Enable subscription
	SPIS_SUBSCRIBE_RELEASE_EN_Enabled = 0x1

	// EVENTS_END: Granted transaction completed
	// Position of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIS_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIS_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_ACQUIRED: Semaphore acquired
	// Position of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Pos = 0x0
	// Bit mask of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Msk = 0x1
	// Bit EVENTS_ACQUIRED.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED = 0x1
	// Event not generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Generated = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SPIS_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_END_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIS_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	SPIS_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_ENDRX_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIS_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_ACQUIRED: Publish configuration for event ACQUIRED
	// Position of CHIDX field.
	SPIS_PUBLISH_ACQUIRED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_ACQUIRED_CHIDX_Msk = 0xf
	// Position of EN field.
	SPIS_PUBLISH_ACQUIRED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_ACQUIRED_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_ACQUIRED_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_ACQUIRED_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_ACQUIRED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Pos = 0x2
	// Bit mask of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Msk = 0x4
	// Bit END_ACQUIRE.
	SPIS_SHORTS_END_ACQUIRE = 0x4
	// Disable shortcut
	SPIS_SHORTS_END_ACQUIRE_Disabled = 0x0
	// Enable shortcut
	SPIS_SHORTS_END_ACQUIRE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	SPIS_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENSET_END_Msk = 0x2
	// Bit END.
	SPIS_INTENSET_END = 0x2
	// Read: Disabled
	SPIS_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_END_Enabled = 0x1
	// Enable
	SPIS_INTENSET_END_Set = 0x1
	// Position of ENDRX field.
	SPIS_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ENDRX_Set = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENSET_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENSET_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ACQUIRED_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ACQUIRED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	SPIS_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENCLR_END_Msk = 0x2
	// Bit END.
	SPIS_INTENCLR_END = 0x2
	// Read: Disabled
	SPIS_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_END_Clear = 0x1
	// Position of ENDRX field.
	SPIS_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ENDRX_Clear = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENCLR_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENCLR_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ACQUIRED_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ACQUIRED_Clear = 0x1

	// SEMSTAT: Semaphore status register
	// Position of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Pos = 0x0
	// Bit mask of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Msk = 0x3
	// Semaphore is free
	SPIS_SEMSTAT_SEMSTAT_Free = 0x0
	// Semaphore is assigned to CPU
	SPIS_SEMSTAT_SEMSTAT_CPU = 0x1
	// Semaphore is assigned to SPI slave
	SPIS_SEMSTAT_SEMSTAT_SPIS = 0x2
	// Semaphore is assigned to SPI but a handover to the CPU is pending
	SPIS_SEMSTAT_SEMSTAT_CPUPending = 0x3

	// STATUS: Status from last transaction
	// Position of OVERREAD field.
	SPIS_STATUS_OVERREAD_Pos = 0x0
	// Bit mask of OVERREAD field.
	SPIS_STATUS_OVERREAD_Msk = 0x1
	// Bit OVERREAD.
	SPIS_STATUS_OVERREAD = 0x1
	// Read: error not present
	SPIS_STATUS_OVERREAD_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERREAD_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERREAD_Clear = 0x1
	// Position of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Pos = 0x1
	// Bit mask of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Msk = 0x2
	// Bit OVERFLOW.
	SPIS_STATUS_OVERFLOW = 0x2
	// Read: error not present
	SPIS_STATUS_OVERFLOW_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERFLOW_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERFLOW_Clear = 0x1

	// ENABLE: Enable SPI slave
	// Position of ENABLE field.
	SPIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIS_ENABLE_ENABLE_Msk = 0xf
	// Disable SPI slave
	SPIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI slave
	SPIS_ENABLE_ENABLE_Enabled = 0x2

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIS_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_SCK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIS_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MISO_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIS_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN signal
	// Position of PIN field.
	SPIS_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_CSN_PIN_Msk = 0x1f
	// Position of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_CSN_CONNECT_Connected = 0x0

	// RXD.PTR: RXD data pointer
	// Position of PTR field.
	SPIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// RXD.AMOUNT: Number of bytes received in last granted transaction
	// Position of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD data pointer
	// Position of PTR field.
	SPIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// TXD.AMOUNT: Number of bytes transmitted in last granted transaction
	// Position of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIS_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIS_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIS_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIS_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIS_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIS_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIS_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIS_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIS_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIS_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIS_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIS_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIS_CONFIG_CPOL = 0x4
	// Active high
	SPIS_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIS_CONFIG_CPOL_ActiveLow = 0x1

	// DEF: Default character. Character clocked out in case of an ignored transaction.
	// Position of DEF field.
	SPIS_DEF_DEF_Pos = 0x0
	// Bit mask of DEF field.
	SPIS_DEF_DEF_Msk = 0xff

	// ORC: Over-read character
	// Position of ORC field.
	SPIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIS_ORC_ORC_Msk = 0xff
)

// Constants for TWIM0_NS: I2C compatible Two-Wire Master Interface with EasyDMA 0
const (
	// TASKS_STARTRX: Start TWI receive sequence
	// Position of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	TWIM_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STARTTX: Start TWI transmit sequence
	// Position of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	TWIM_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
	// Position of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STARTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STARTRX_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_SUBSCRIBE_STARTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STARTRX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STARTRX_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STARTRX_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STARTRX_EN_Enabled = 0x1

	// SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STARTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STARTTX_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_SUBSCRIBE_STARTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STARTTX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STARTTX_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STARTTX_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STARTTX_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_RESUME_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_SUSPENDED: SUSPEND task has been issued, TWI traffic is now suspended.
	// Position of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Pos = 0x0
	// Bit mask of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Msk = 0x1
	// Bit EVENTS_SUSPENDED.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED = 0x1
	// Event not generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_LASTRX: Byte boundary, starting to receive the last byte
	// Position of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Pos = 0x0
	// Bit mask of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Msk = 0x1
	// Bit EVENTS_LASTRX.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Generated = 0x1

	// EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
	// Position of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Pos = 0x0
	// Bit mask of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Msk = 0x1
	// Bit EVENTS_LASTTX.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	TWIM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	TWIM_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_ERROR_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_SUSPENDED: Publish configuration for event SUSPENDED
	// Position of CHIDX field.
	TWIM_PUBLISH_SUSPENDED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_SUSPENDED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_SUSPENDED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_SUSPENDED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_SUSPENDED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_SUSPENDED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_SUSPENDED_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	TWIM_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_RXSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	TWIM_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_TXSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_LASTRX: Publish configuration for event LASTRX
	// Position of CHIDX field.
	TWIM_PUBLISH_LASTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_LASTRX_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_LASTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_LASTRX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_LASTRX_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_LASTRX_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_LASTRX_EN_Enabled = 0x1

	// PUBLISH_LASTTX: Publish configuration for event LASTTX
	// Position of CHIDX field.
	TWIM_PUBLISH_LASTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_LASTTX_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIM_PUBLISH_LASTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_LASTTX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_LASTTX_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_LASTTX_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_LASTTX_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Pos = 0x7
	// Bit mask of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Msk = 0x80
	// Bit LASTTX_STARTRX.
	TWIM_SHORTS_LASTTX_STARTRX = 0x80
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Enabled = 0x1
	// Position of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Pos = 0x8
	// Bit mask of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Msk = 0x100
	// Bit LASTTX_SUSPEND.
	TWIM_SHORTS_LASTTX_SUSPEND = 0x100
	// Disable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Enabled = 0x1
	// Position of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Pos = 0x9
	// Bit mask of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Msk = 0x200
	// Bit LASTTX_STOP.
	TWIM_SHORTS_LASTTX_STOP = 0x200
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STOP_Enabled = 0x1
	// Position of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Pos = 0xa
	// Bit mask of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Msk = 0x400
	// Bit LASTRX_STARTTX.
	TWIM_SHORTS_LASTRX_STARTTX = 0x400
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Enabled = 0x1
	// Position of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Pos = 0xb
	// Bit mask of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Msk = 0x800
	// Bit LASTRX_SUSPEND.
	TWIM_SHORTS_LASTRX_SUSPEND = 0x800
	// Disable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Enabled = 0x1
	// Position of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Pos = 0xc
	// Bit mask of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Msk = 0x1000
	// Bit LASTRX_STOP.
	TWIM_SHORTS_LASTRX_STOP = 0x1000
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTEN_STOPPED = 0x2
	// Disable
	TWIM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIM_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIM_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTEN_ERROR = 0x200
	// Disable
	TWIM_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIM_INTEN_ERROR_Enabled = 0x1
	// Position of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTEN_SUSPENDED = 0x40000
	// Disable
	TWIM_INTEN_SUSPENDED_Disabled = 0x0
	// Enable
	TWIM_INTEN_SUSPENDED_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIM_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIM_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_TXSTARTED_Enabled = 0x1
	// Position of LASTRX field.
	TWIM_INTEN_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTEN_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTEN_LASTRX = 0x800000
	// Disable
	TWIM_INTEN_LASTRX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTRX_Enabled = 0x1
	// Position of LASTTX field.
	TWIM_INTEN_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTEN_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTEN_LASTTX = 0x1000000
	// Disable
	TWIM_INTEN_LASTTX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTTX_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIM_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIM_INTENSET_ERROR_Set = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENSET_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENSET_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_SUSPENDED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_SUSPENDED_Set = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_TXSTARTED_Set = 0x1
	// Position of LASTRX field.
	TWIM_INTENSET_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENSET_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENSET_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENSET_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTRX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTRX_Set = 0x1
	// Position of LASTTX field.
	TWIM_INTENSET_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENSET_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENSET_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENSET_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTTX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTTX_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIM_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_ERROR_Clear = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENCLR_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENCLR_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_SUSPENDED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_SUSPENDED_Clear = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of LASTRX field.
	TWIM_INTENCLR_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENCLR_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENCLR_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENCLR_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTRX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTRX_Clear = 0x1
	// Position of LASTTX field.
	TWIM_INTENCLR_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENCLR_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENCLR_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENCLR_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTTX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTTX_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	TWIM_ERRORSRC_OVERRUN = 0x1
	// Error did not occur
	TWIM_ERRORSRC_OVERRUN_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_OVERRUN_Received = 0x1
	// Position of ANACK field.
	TWIM_ERRORSRC_ANACK_Pos = 0x1
	// Bit mask of ANACK field.
	TWIM_ERRORSRC_ANACK_Msk = 0x2
	// Bit ANACK.
	TWIM_ERRORSRC_ANACK = 0x2
	// Error did not occur
	TWIM_ERRORSRC_ANACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_ANACK_Received = 0x1
	// Position of DNACK field.
	TWIM_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIM_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIM_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIM_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_DNACK_Received = 0x1

	// ENABLE: Enable TWIM
	// Position of ENABLE field.
	TWIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIM_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIM
	TWIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIM
	TWIM_ENABLE_ENABLE_Enabled = 0x6

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIM_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SCL_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIM_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SDA_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SDA_CONNECT_Connected = 0x0

	// FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 100 kbps
	TWIM_FREQUENCY_FREQUENCY_K100 = 0x1980000
	// 250 kbps
	TWIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 400 kbps
	TWIM_FREQUENCY_FREQUENCY_K400 = 0x6400000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Address used in the TWI transfer
	// Position of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Msk = 0x7f
)

// Constants for TWIS0_NS: I2C compatible Two-Wire Slave Interface with EasyDMA 0
const (
	// TASKS_STOP: Stop TWI transaction
	// Position of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIS_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIS_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIS_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIS_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
	// Position of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Pos = 0x0
	// Bit mask of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Msk = 0x1
	// Bit TASKS_PREPARERX.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Trigger = 0x1

	// TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
	// Position of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Pos = 0x0
	// Bit mask of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Msk = 0x1
	// Bit TASKS_PREPARETX.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Trigger = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_RESUME_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// SUBSCRIBE_PREPARERX: Subscribe configuration for task PREPARERX
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_PREPARERX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_PREPARERX_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_SUBSCRIBE_PREPARERX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_PREPARERX_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_PREPARERX_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_PREPARERX_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_PREPARERX_EN_Enabled = 0x1

	// SUBSCRIBE_PREPARETX: Subscribe configuration for task PREPARETX
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_PREPARETX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_PREPARETX_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_SUBSCRIBE_PREPARETX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_PREPARETX_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_PREPARETX_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_PREPARETX_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_PREPARETX_EN_Enabled = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIS_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_WRITE: Write command received
	// Position of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Pos = 0x0
	// Bit mask of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Msk = 0x1
	// Bit EVENTS_WRITE.
	TWIS_EVENTS_WRITE_EVENTS_WRITE = 0x1
	// Event not generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Generated = 0x1

	// EVENTS_READ: Read command received
	// Position of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Pos = 0x0
	// Bit mask of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Msk = 0x1
	// Bit EVENTS_READ.
	TWIS_EVENTS_READ_EVENTS_READ = 0x1
	// Event not generated
	TWIS_EVENTS_READ_EVENTS_READ_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_READ_EVENTS_READ_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	TWIS_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	TWIS_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_ERROR_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	TWIS_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_RXSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	TWIS_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_TXSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_WRITE: Publish configuration for event WRITE
	// Position of CHIDX field.
	TWIS_PUBLISH_WRITE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_WRITE_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_PUBLISH_WRITE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_WRITE_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_WRITE_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_WRITE_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_WRITE_EN_Enabled = 0x1

	// PUBLISH_READ: Publish configuration for event READ
	// Position of CHIDX field.
	TWIS_PUBLISH_READ_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_READ_CHIDX_Msk = 0xf
	// Position of EN field.
	TWIS_PUBLISH_READ_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_READ_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_READ_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_READ_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_READ_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Pos = 0xd
	// Bit mask of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Msk = 0x2000
	// Bit WRITE_SUSPEND.
	TWIS_SHORTS_WRITE_SUSPEND = 0x2000
	// Disable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Enabled = 0x1
	// Position of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Pos = 0xe
	// Bit mask of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Msk = 0x4000
	// Bit READ_SUSPEND.
	TWIS_SHORTS_READ_SUSPEND = 0x4000
	// Disable shortcut
	TWIS_SHORTS_READ_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_READ_SUSPEND_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIS_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTEN_STOPPED = 0x2
	// Disable
	TWIS_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIS_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIS_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTEN_ERROR = 0x200
	// Disable
	TWIS_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIS_INTEN_ERROR_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIS_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIS_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_TXSTARTED_Enabled = 0x1
	// Position of WRITE field.
	TWIS_INTEN_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTEN_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTEN_WRITE = 0x2000000
	// Disable
	TWIS_INTEN_WRITE_Disabled = 0x0
	// Enable
	TWIS_INTEN_WRITE_Enabled = 0x1
	// Position of READ field.
	TWIS_INTEN_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTEN_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTEN_READ = 0x4000000
	// Disable
	TWIS_INTEN_READ_Disabled = 0x0
	// Enable
	TWIS_INTEN_READ_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIS_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIS_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIS_INTENSET_ERROR_Set = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_TXSTARTED_Set = 0x1
	// Position of WRITE field.
	TWIS_INTENSET_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENSET_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENSET_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENSET_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_WRITE_Enabled = 0x1
	// Enable
	TWIS_INTENSET_WRITE_Set = 0x1
	// Position of READ field.
	TWIS_INTENSET_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENSET_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENSET_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENSET_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_READ_Enabled = 0x1
	// Enable
	TWIS_INTENSET_READ_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIS_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIS_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_ERROR_Clear = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of WRITE field.
	TWIS_INTENCLR_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENCLR_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENCLR_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENCLR_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_WRITE_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_WRITE_Clear = 0x1
	// Position of READ field.
	TWIS_INTENCLR_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENCLR_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENCLR_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENCLR_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_READ_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_READ_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Pos = 0x0
	// Bit mask of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Msk = 0x1
	// Bit OVERFLOW.
	TWIS_ERRORSRC_OVERFLOW = 0x1
	// Error did not occur
	TWIS_ERRORSRC_OVERFLOW_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERFLOW_Detected = 0x1
	// Position of DNACK field.
	TWIS_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIS_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIS_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIS_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIS_ERRORSRC_DNACK_Received = 0x1
	// Position of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Pos = 0x3
	// Bit mask of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Msk = 0x8
	// Bit OVERREAD.
	TWIS_ERRORSRC_OVERREAD = 0x8
	// Error did not occur
	TWIS_ERRORSRC_OVERREAD_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERREAD_Detected = 0x1

	// MATCH: Status register indicating which address had a match
	// Position of MATCH field.
	TWIS_MATCH_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	TWIS_MATCH_MATCH_Msk = 0x1
	// Bit MATCH.
	TWIS_MATCH_MATCH = 0x1

	// ENABLE: Enable TWIS
	// Position of ENABLE field.
	TWIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIS_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIS
	TWIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIS
	TWIS_ENABLE_ENABLE_Enabled = 0x9

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIS_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SCL_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIS_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SDA_PIN_Msk = 0x1f
	// Position of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SDA_CONNECT_Connected = 0x0

	// RXD.PTR: RXD Data pointer
	// Position of PTR field.
	TWIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in RXD buffer
	// Position of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
	// Position of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD Data pointer
	// Position of PTR field.
	TWIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in TXD buffer
	// Position of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
	// Position of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Description collection: TWI slave address n
	// Position of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Msk = 0x7f

	// CONFIG: Configuration register for the address match mechanism
	// Position of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Pos = 0x0
	// Bit mask of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Msk = 0x1
	// Bit ADDRESS0.
	TWIS_CONFIG_ADDRESS0 = 0x1
	// Disabled
	TWIS_CONFIG_ADDRESS0_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS0_Enabled = 0x1
	// Position of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Pos = 0x1
	// Bit mask of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Msk = 0x2
	// Bit ADDRESS1.
	TWIS_CONFIG_ADDRESS1 = 0x2
	// Disabled
	TWIS_CONFIG_ADDRESS1_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS1_Enabled = 0x1

	// ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
	// Position of ORC field.
	TWIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	TWIS_ORC_ORC_Msk = 0xff
)

// Constants for UARTE0_NS: UART with EasyDMA 0
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UARTE_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UARTE_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UARTE_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UARTE_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_FLUSHRX: Flush RX FIFO into RX buffer
	// Position of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Pos = 0x0
	// Bit mask of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Msk = 0x1
	// Bit TASKS_FLUSHRX.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX = 0x1
	// Trigger task
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Trigger = 0x1

	// SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STARTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STARTRX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_SUBSCRIBE_STARTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STARTRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STARTRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STARTRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STARTRX_EN_Enabled = 0x1

	// SUBSCRIBE_STOPRX: Subscribe configuration for task STOPRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STOPRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STOPRX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_SUBSCRIBE_STOPRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STOPRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STOPRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STOPRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STOPRX_EN_Enabled = 0x1

	// SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STARTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STARTTX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_SUBSCRIBE_STARTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STARTTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STARTTX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STARTTX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STARTTX_EN_Enabled = 0x1

	// SUBSCRIBE_STOPTX: Subscribe configuration for task STOPTX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STOPTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STOPTX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_SUBSCRIBE_STOPTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STOPTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STOPTX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STOPTX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STOPTX_EN_Enabled = 0x1

	// SUBSCRIBE_FLUSHRX: Subscribe configuration for task FLUSHRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_FLUSHRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_FLUSHRX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_SUBSCRIBE_FLUSHRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_FLUSHRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_FLUSHRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_FLUSHRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_FLUSHRX_EN_Enabled = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UARTE_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UARTE_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UARTE_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
	// Position of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_ENDRX: Receive buffer is filled up
	// Position of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ENDTX: Last TX byte transmitted
	// Position of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UARTE_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UARTE_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// EVENTS_RXSTARTED: UART receiver has started
	// Position of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: UART transmitter has started
	// Position of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_TXSTOPPED: Transmitter stopped
	// Position of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Msk = 0x1
	// Bit EVENTS_TXSTOPPED.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Generated = 0x1

	// PUBLISH_CTS: Publish configuration for event CTS
	// Position of CHIDX field.
	UARTE_PUBLISH_CTS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_CTS_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_CTS_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_CTS_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_CTS_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_CTS_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_CTS_EN_Enabled = 0x1

	// PUBLISH_NCTS: Publish configuration for event NCTS
	// Position of CHIDX field.
	UARTE_PUBLISH_NCTS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_NCTS_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_NCTS_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_NCTS_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_NCTS_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_NCTS_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_NCTS_EN_Enabled = 0x1

	// PUBLISH_RXDRDY: Publish configuration for event RXDRDY
	// Position of CHIDX field.
	UARTE_PUBLISH_RXDRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXDRDY_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_RXDRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXDRDY_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXDRDY_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXDRDY_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXDRDY_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	UARTE_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ENDRX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_TXDRDY: Publish configuration for event TXDRDY
	// Position of CHIDX field.
	UARTE_PUBLISH_TXDRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXDRDY_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_TXDRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXDRDY_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXDRDY_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXDRDY_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXDRDY_EN_Enabled = 0x1

	// PUBLISH_ENDTX: Publish configuration for event ENDTX
	// Position of CHIDX field.
	UARTE_PUBLISH_ENDTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ENDTX_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_ENDTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ENDTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ENDTX_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ENDTX_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ENDTX_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	UARTE_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ERROR_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_RXTO: Publish configuration for event RXTO
	// Position of CHIDX field.
	UARTE_PUBLISH_RXTO_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXTO_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_RXTO_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXTO_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXTO_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXTO_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXTO_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	UARTE_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	UARTE_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTOPPED: Publish configuration for event TXSTOPPED
	// Position of CHIDX field.
	UARTE_PUBLISH_TXSTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXSTOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	UARTE_PUBLISH_TXSTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXSTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXSTOPPED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXSTOPPED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXSTOPPED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Pos = 0x5
	// Bit mask of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Msk = 0x20
	// Bit ENDRX_STARTRX.
	UARTE_SHORTS_ENDRX_STARTRX = 0x20
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Enabled = 0x1
	// Position of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Pos = 0x6
	// Bit mask of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Msk = 0x40
	// Bit ENDRX_STOPRX.
	UARTE_SHORTS_ENDRX_STOPRX = 0x40
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of CTS field.
	UARTE_INTEN_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTEN_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTEN_CTS = 0x1
	// Disable
	UARTE_INTEN_CTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_CTS_Enabled = 0x1
	// Position of NCTS field.
	UARTE_INTEN_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTEN_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTEN_NCTS = 0x2
	// Disable
	UARTE_INTEN_NCTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_NCTS_Enabled = 0x1
	// Position of RXDRDY field.
	UARTE_INTEN_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTEN_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTEN_RXDRDY = 0x4
	// Disable
	UARTE_INTEN_RXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXDRDY_Enabled = 0x1
	// Position of ENDRX field.
	UARTE_INTEN_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTEN_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTEN_ENDRX = 0x10
	// Disable
	UARTE_INTEN_ENDRX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDRX_Enabled = 0x1
	// Position of TXDRDY field.
	UARTE_INTEN_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTEN_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTEN_TXDRDY = 0x80
	// Disable
	UARTE_INTEN_TXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXDRDY_Enabled = 0x1
	// Position of ENDTX field.
	UARTE_INTEN_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTEN_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTEN_ENDTX = 0x100
	// Disable
	UARTE_INTEN_ENDTX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDTX_Enabled = 0x1
	// Position of ERROR field.
	UARTE_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTEN_ERROR = 0x200
	// Disable
	UARTE_INTEN_ERROR_Disabled = 0x0
	// Enable
	UARTE_INTEN_ERROR_Enabled = 0x1
	// Position of RXTO field.
	UARTE_INTEN_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTEN_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTEN_RXTO = 0x20000
	// Disable
	UARTE_INTEN_RXTO_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXTO_Enabled = 0x1
	// Position of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTEN_RXSTARTED = 0x80000
	// Disable
	UARTE_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTEN_TXSTARTED = 0x100000
	// Disable
	UARTE_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTARTED_Enabled = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTEN_TXSTOPPED = 0x400000
	// Disable
	UARTE_INTEN_TXSTOPPED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTOPPED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UARTE_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENSET_CTS = 0x1
	// Read: Disabled
	UARTE_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_CTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UARTE_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENSET_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXDRDY_Set = 0x1
	// Position of ENDRX field.
	UARTE_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENSET_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDRX_Set = 0x1
	// Position of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXDRDY_Set = 0x1
	// Position of ENDTX field.
	UARTE_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENSET_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDTX_Set = 0x1
	// Position of ERROR field.
	UARTE_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENSET_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UARTE_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXTO_Set = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTARTED_Set = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENSET_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENSET_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTOPPED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UARTE_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENCLR_CTS = 0x1
	// Read: Disabled
	UARTE_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UARTE_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXDRDY_Clear = 0x1
	// Position of ENDRX field.
	UARTE_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDRX_Clear = 0x1
	// Position of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ENDTX field.
	UARTE_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDTX_Clear = 0x1
	// Position of ERROR field.
	UARTE_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UARTE_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXTO_Clear = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENCLR_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENCLR_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTOPPED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTOPPED_Clear = 0x1

	// ERRORSRC: Error source Note : this register is read / write one to clear.
	// Position of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UARTE_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UARTE_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UARTE_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UARTE_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UARTE_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UARTE_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UARTE_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UARTE_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UARTE_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UARTE_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UARTE_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UARTE_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UARTE_ENABLE_ENABLE_Msk = 0xf
	// Disable UARTE
	UARTE_ENABLE_ENABLE_Disabled = 0x0
	// Enable UARTE
	UARTE_ENABLE_ENABLE_Enabled = 0x8

	// PSEL.RTS: Pin select for RTS signal
	// Position of PIN field.
	UARTE_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RTS_PIN_Msk = 0x1f
	// Position of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD signal
	// Position of PIN field.
	UARTE_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_TXD_PIN_Msk = 0x1f
	// Position of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS signal
	// Position of PIN field.
	UARTE_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_CTS_PIN_Msk = 0x1f
	// Position of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD signal
	// Position of PIN field.
	UARTE_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RXD_PIN_Msk = 0x1f
	// Position of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RXD_CONNECT_Connected = 0x0

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UARTE_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UARTE_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UARTE_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UARTE_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14401)
	UARTE_BAUDRATE_BAUDRATE_Baud14400 = 0x3af000
	// 19200 baud (actual rate: 19208)
	UARTE_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28777)
	UARTE_BAUDRATE_BAUDRATE_Baud28800 = 0x75c000
	// 31250 baud
	UARTE_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38369)
	UARTE_BAUDRATE_BAUDRATE_Baud38400 = 0x9d0000
	// 56000 baud (actual rate: 55944)
	UARTE_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57554)
	UARTE_BAUDRATE_BAUDRATE_Baud57600 = 0xeb0000
	// 76800 baud (actual rate: 76923)
	UARTE_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115108)
	UARTE_BAUDRATE_BAUDRATE_Baud115200 = 0x1d60000
	// 230400 baud (actual rate: 231884)
	UARTE_BAUDRATE_BAUDRATE_Baud230400 = 0x3b00000
	// 250000 baud
	UARTE_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 457143)
	UARTE_BAUDRATE_BAUDRATE_Baud460800 = 0x7400000
	// 921600 baud (actual rate: 941176)
	UARTE_BAUDRATE_BAUDRATE_Baud921600 = 0xf000000
	// 1Mega baud
	UARTE_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// TXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Msk = 0x1fff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Msk = 0x1fff

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UARTE_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UARTE_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UARTE_CONFIG_HWFC = 0x1
	// Disabled
	UARTE_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UARTE_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UARTE_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UARTE_CONFIG_PARITY_Excluded = 0x0
	// Include even parity bit
	UARTE_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UARTE_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UARTE_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UARTE_CONFIG_STOP = 0x10
	// One stop bit
	UARTE_CONFIG_STOP_One = 0x0
	// Two stop bits
	UARTE_CONFIG_STOP_Two = 0x1
)

// Constants for GPIOTE0_S: GPIO Tasks and Events 0
const (
	// TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
	// Position of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Pos = 0x0
	// Bit mask of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Msk = 0x1
	// Bit TASKS_OUT.
	GPIOTE_TASKS_OUT_TASKS_OUT = 0x1
	// Trigger task
	GPIOTE_TASKS_OUT_TASKS_OUT_Trigger = 0x1

	// TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
	// Position of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Pos = 0x0
	// Bit mask of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Msk = 0x1
	// Bit TASKS_SET.
	GPIOTE_TASKS_SET_TASKS_SET = 0x1
	// Trigger task
	GPIOTE_TASKS_SET_TASKS_SET_Trigger = 0x1

	// TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
	// Position of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Pos = 0x0
	// Bit mask of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Msk = 0x1
	// Bit TASKS_CLR.
	GPIOTE_TASKS_CLR_TASKS_CLR = 0x1
	// Trigger task
	GPIOTE_TASKS_CLR_TASKS_CLR_Trigger = 0x1

	// SUBSCRIBE_OUT: Description collection: Subscribe configuration for task OUT[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_OUT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_OUT_CHIDX_Msk = 0xf
	// Position of EN field.
	GPIOTE_SUBSCRIBE_OUT_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_OUT_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_OUT_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_OUT_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_OUT_EN_Enabled = 0x1

	// SUBSCRIBE_SET: Description collection: Subscribe configuration for task SET[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_SET_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_SET_CHIDX_Msk = 0xf
	// Position of EN field.
	GPIOTE_SUBSCRIBE_SET_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_SET_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_SET_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_SET_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_SET_EN_Enabled = 0x1

	// SUBSCRIBE_CLR: Description collection: Subscribe configuration for task CLR[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_CLR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_CLR_CHIDX_Msk = 0xf
	// Position of EN field.
	GPIOTE_SUBSCRIBE_CLR_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_CLR_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_CLR_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_CLR_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_CLR_EN_Enabled = 0x1

	// EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
	// Position of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Pos = 0x0
	// Bit mask of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Msk = 0x1
	// Bit EVENTS_IN.
	GPIOTE_EVENTS_IN_EVENTS_IN = 0x1
	// Event not generated
	GPIOTE_EVENTS_IN_EVENTS_IN_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_IN_EVENTS_IN_Generated = 0x1

	// EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
	// Position of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Pos = 0x0
	// Bit mask of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Msk = 0x1
	// Bit EVENTS_PORT.
	GPIOTE_EVENTS_PORT_EVENTS_PORT = 0x1
	// Event not generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Generated = 0x1

	// PUBLISH_IN: Description collection: Publish configuration for event IN[n]
	// Position of CHIDX field.
	GPIOTE_PUBLISH_IN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_PUBLISH_IN_CHIDX_Msk = 0xf
	// Position of EN field.
	GPIOTE_PUBLISH_IN_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_PUBLISH_IN_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_PUBLISH_IN_EN = 0x80000000
	// Disable publishing
	GPIOTE_PUBLISH_IN_EN_Disabled = 0x0
	// Enable publishing
	GPIOTE_PUBLISH_IN_EN_Enabled = 0x1

	// PUBLISH_PORT: Publish configuration for event PORT
	// Position of CHIDX field.
	GPIOTE_PUBLISH_PORT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_PUBLISH_PORT_CHIDX_Msk = 0xf
	// Position of EN field.
	GPIOTE_PUBLISH_PORT_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_PUBLISH_PORT_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_PUBLISH_PORT_EN = 0x80000000
	// Disable publishing
	GPIOTE_PUBLISH_PORT_EN_Disabled = 0x0
	// Enable publishing
	GPIOTE_PUBLISH_PORT_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of IN0 field.
	GPIOTE_INTENSET_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENSET_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENSET_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENSET_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN0_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN0_Set = 0x1
	// Position of IN1 field.
	GPIOTE_INTENSET_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENSET_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENSET_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENSET_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN1_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN1_Set = 0x1
	// Position of IN2 field.
	GPIOTE_INTENSET_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENSET_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENSET_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENSET_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN2_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN2_Set = 0x1
	// Position of IN3 field.
	GPIOTE_INTENSET_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENSET_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENSET_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENSET_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN3_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN3_Set = 0x1
	// Position of IN4 field.
	GPIOTE_INTENSET_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENSET_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENSET_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENSET_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN4_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN4_Set = 0x1
	// Position of IN5 field.
	GPIOTE_INTENSET_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENSET_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENSET_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENSET_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN5_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN5_Set = 0x1
	// Position of IN6 field.
	GPIOTE_INTENSET_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENSET_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENSET_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENSET_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN6_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN6_Set = 0x1
	// Position of IN7 field.
	GPIOTE_INTENSET_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENSET_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENSET_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENSET_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN7_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN7_Set = 0x1
	// Position of PORT field.
	GPIOTE_INTENSET_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENSET_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENSET_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENSET_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_PORT_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_PORT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of IN0 field.
	GPIOTE_INTENCLR_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENCLR_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENCLR_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENCLR_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN0_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN0_Clear = 0x1
	// Position of IN1 field.
	GPIOTE_INTENCLR_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENCLR_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENCLR_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENCLR_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN1_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN1_Clear = 0x1
	// Position of IN2 field.
	GPIOTE_INTENCLR_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENCLR_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENCLR_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENCLR_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN2_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN2_Clear = 0x1
	// Position of IN3 field.
	GPIOTE_INTENCLR_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENCLR_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENCLR_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENCLR_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN3_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN3_Clear = 0x1
	// Position of IN4 field.
	GPIOTE_INTENCLR_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENCLR_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENCLR_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENCLR_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN4_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN4_Clear = 0x1
	// Position of IN5 field.
	GPIOTE_INTENCLR_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENCLR_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENCLR_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENCLR_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN5_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN5_Clear = 0x1
	// Position of IN6 field.
	GPIOTE_INTENCLR_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENCLR_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENCLR_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENCLR_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN6_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN6_Clear = 0x1
	// Position of IN7 field.
	GPIOTE_INTENCLR_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENCLR_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENCLR_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENCLR_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN7_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN7_Clear = 0x1
	// Position of PORT field.
	GPIOTE_INTENCLR_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENCLR_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENCLR_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENCLR_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_PORT_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_PORT_Clear = 0x1

	// CONFIG: Description collection: Configuration for OUT[n], SET[n] and CLR[n] tasks and IN[n] event
	// Position of MODE field.
	GPIOTE_CONFIG_MODE_Pos = 0x0
	// Bit mask of MODE field.
	GPIOTE_CONFIG_MODE_Msk = 0x3
	// Disabled. Pin specified by PSEL will not be acquired by the GPIOTE module.
	GPIOTE_CONFIG_MODE_Disabled = 0x0
	// Event mode
	GPIOTE_CONFIG_MODE_Event = 0x1
	// Task mode
	GPIOTE_CONFIG_MODE_Task = 0x3
	// Position of PSEL field.
	GPIOTE_CONFIG_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	GPIOTE_CONFIG_PSEL_Msk = 0x1f00
	// Position of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Pos = 0x10
	// Bit mask of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Msk = 0x30000
	// Task mode: No effect on pin from OUT[n] task. Event mode: no IN[n] event generated on pin activity.
	GPIOTE_CONFIG_POLARITY_None = 0x0
	// Task mode: Set pin from OUT[n] task. Event mode: Generate IN[n] event when rising edge on pin.
	GPIOTE_CONFIG_POLARITY_LoToHi = 0x1
	// Task mode: Clear pin from OUT[n] task. Event mode: Generate IN[n] event when falling edge on pin.
	GPIOTE_CONFIG_POLARITY_HiToLo = 0x2
	// Task mode: Toggle pin from OUT[n]. Event mode: Generate IN[n] when any change on pin.
	GPIOTE_CONFIG_POLARITY_Toggle = 0x3
	// Position of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Pos = 0x14
	// Bit mask of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Msk = 0x100000
	// Bit OUTINIT.
	GPIOTE_CONFIG_OUTINIT = 0x100000
	// Task mode: Initial value of pin before task triggering is low
	GPIOTE_CONFIG_OUTINIT_Low = 0x0
	// Task mode: Initial value of pin before task triggering is high
	GPIOTE_CONFIG_OUTINIT_High = 0x1
)

// Constants for SAADC_NS: Analog to Digital Converter 0
const (
	// TASKS_START: Start the ADC and prepare the result buffer in RAM
	// Position of TASKS_START field.
	SAADC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SAADC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SAADC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SAADC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_SAMPLE: Take one ADC sample, if scan is enabled all channels are sampled
	// Position of TASKS_SAMPLE field.
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE_Pos = 0x0
	// Bit mask of TASKS_SAMPLE field.
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE_Msk = 0x1
	// Bit TASKS_SAMPLE.
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE = 0x1
	// Trigger task
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE_Trigger = 0x1

	// TASKS_STOP: Stop the ADC and terminate any on-going conversion
	// Position of TASKS_STOP field.
	SAADC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SAADC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SAADC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SAADC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_CALIBRATEOFFSET: Starts offset auto-calibration
	// Position of TASKS_CALIBRATEOFFSET field.
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET_Pos = 0x0
	// Bit mask of TASKS_CALIBRATEOFFSET field.
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET_Msk = 0x1
	// Bit TASKS_CALIBRATEOFFSET.
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET = 0x1
	// Trigger task
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	SAADC_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	SAADC_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	SAADC_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_SAMPLE: Subscribe configuration for task SAMPLE
	// Position of CHIDX field.
	SAADC_SUBSCRIBE_SAMPLE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_SUBSCRIBE_SAMPLE_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_SUBSCRIBE_SAMPLE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_SUBSCRIBE_SAMPLE_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_SUBSCRIBE_SAMPLE_EN = 0x80000000
	// Disable subscription
	SAADC_SUBSCRIBE_SAMPLE_EN_Disabled = 0x0
	// Enable subscription
	SAADC_SUBSCRIBE_SAMPLE_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	SAADC_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	SAADC_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	SAADC_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_CALIBRATEOFFSET: Subscribe configuration for task CALIBRATEOFFSET
	// Position of CHIDX field.
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_EN = 0x80000000
	// Disable subscription
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_EN_Disabled = 0x0
	// Enable subscription
	SAADC_SUBSCRIBE_CALIBRATEOFFSET_EN_Enabled = 0x1

	// EVENTS_STARTED: The ADC has started
	// Position of EVENTS_STARTED field.
	SAADC_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SAADC_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SAADC_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SAADC_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// EVENTS_END: The ADC has filled up the Result buffer
	// Position of EVENTS_END field.
	SAADC_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SAADC_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SAADC_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SAADC_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_DONE: A conversion task has been completed. Depending on the mode, multiple conversions might be needed for a result to be transferred to RAM.
	// Position of EVENTS_DONE field.
	SAADC_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	SAADC_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	SAADC_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	SAADC_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// EVENTS_RESULTDONE: A result is ready to get transferred to RAM.
	// Position of EVENTS_RESULTDONE field.
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_Pos = 0x0
	// Bit mask of EVENTS_RESULTDONE field.
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_Msk = 0x1
	// Bit EVENTS_RESULTDONE.
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE = 0x1
	// Event not generated
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_Generated = 0x1

	// EVENTS_CALIBRATEDONE: Calibration is complete
	// Position of EVENTS_CALIBRATEDONE field.
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_Pos = 0x0
	// Bit mask of EVENTS_CALIBRATEDONE field.
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_Msk = 0x1
	// Bit EVENTS_CALIBRATEDONE.
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE = 0x1
	// Event not generated
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_Generated = 0x1

	// EVENTS_STOPPED: The ADC has stopped
	// Position of EVENTS_STOPPED field.
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_CH.LIMITH: Description cluster: Last results is equal or above CH[n].LIMIT.HIGH
	// Position of LIMITH field.
	SAADC_EVENTS_CH_LIMITH_LIMITH_Pos = 0x0
	// Bit mask of LIMITH field.
	SAADC_EVENTS_CH_LIMITH_LIMITH_Msk = 0x1
	// Bit LIMITH.
	SAADC_EVENTS_CH_LIMITH_LIMITH = 0x1
	// Event not generated
	SAADC_EVENTS_CH_LIMITH_LIMITH_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_CH_LIMITH_LIMITH_Generated = 0x1

	// EVENTS_CH.LIMITL: Description cluster: Last results is equal or below CH[n].LIMIT.LOW
	// Position of LIMITL field.
	SAADC_EVENTS_CH_LIMITL_LIMITL_Pos = 0x0
	// Bit mask of LIMITL field.
	SAADC_EVENTS_CH_LIMITL_LIMITL_Msk = 0x1
	// Bit LIMITL.
	SAADC_EVENTS_CH_LIMITL_LIMITL = 0x1
	// Event not generated
	SAADC_EVENTS_CH_LIMITL_LIMITL_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_CH_LIMITL_LIMITL_Generated = 0x1

	// PUBLISH_STARTED: Publish configuration for event STARTED
	// Position of CHIDX field.
	SAADC_PUBLISH_STARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_STARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_STARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_STARTED_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_STARTED_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_STARTED_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_STARTED_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SAADC_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_END_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_DONE: Publish configuration for event DONE
	// Position of CHIDX field.
	SAADC_PUBLISH_DONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_DONE_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_DONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_DONE_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_DONE_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_DONE_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_DONE_EN_Enabled = 0x1

	// PUBLISH_RESULTDONE: Publish configuration for event RESULTDONE
	// Position of CHIDX field.
	SAADC_PUBLISH_RESULTDONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_RESULTDONE_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_RESULTDONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_RESULTDONE_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_RESULTDONE_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_RESULTDONE_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_RESULTDONE_EN_Enabled = 0x1

	// PUBLISH_CALIBRATEDONE: Publish configuration for event CALIBRATEDONE
	// Position of CHIDX field.
	SAADC_PUBLISH_CALIBRATEDONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_CALIBRATEDONE_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_CALIBRATEDONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_CALIBRATEDONE_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_CALIBRATEDONE_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_CALIBRATEDONE_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_CALIBRATEDONE_EN_Enabled = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	SAADC_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_CH.LIMITH: Description cluster: Publish configuration for event CH[n].LIMITH
	// Position of CHIDX field.
	SAADC_PUBLISH_CH_LIMITH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_CH_LIMITH_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_CH_LIMITH_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_CH_LIMITH_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_CH_LIMITH_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_CH_LIMITH_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_CH_LIMITH_EN_Enabled = 0x1

	// PUBLISH_CH.LIMITL: Description cluster: Publish configuration for event CH[n].LIMITL
	// Position of CHIDX field.
	SAADC_PUBLISH_CH_LIMITL_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SAADC_PUBLISH_CH_LIMITL_CHIDX_Msk = 0xf
	// Position of EN field.
	SAADC_PUBLISH_CH_LIMITL_EN_Pos = 0x1f
	// Bit mask of EN field.
	SAADC_PUBLISH_CH_LIMITL_EN_Msk = 0x80000000
	// Bit EN.
	SAADC_PUBLISH_CH_LIMITL_EN = 0x80000000
	// Disable publishing
	SAADC_PUBLISH_CH_LIMITL_EN_Disabled = 0x0
	// Enable publishing
	SAADC_PUBLISH_CH_LIMITL_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STARTED field.
	SAADC_INTEN_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	SAADC_INTEN_STARTED_Msk = 0x1
	// Bit STARTED.
	SAADC_INTEN_STARTED = 0x1
	// Disable
	SAADC_INTEN_STARTED_Disabled = 0x0
	// Enable
	SAADC_INTEN_STARTED_Enabled = 0x1
	// Position of END field.
	SAADC_INTEN_END_Pos = 0x1
	// Bit mask of END field.
	SAADC_INTEN_END_Msk = 0x2
	// Bit END.
	SAADC_INTEN_END = 0x2
	// Disable
	SAADC_INTEN_END_Disabled = 0x0
	// Enable
	SAADC_INTEN_END_Enabled = 0x1
	// Position of DONE field.
	SAADC_INTEN_DONE_Pos = 0x2
	// Bit mask of DONE field.
	SAADC_INTEN_DONE_Msk = 0x4
	// Bit DONE.
	SAADC_INTEN_DONE = 0x4
	// Disable
	SAADC_INTEN_DONE_Disabled = 0x0
	// Enable
	SAADC_INTEN_DONE_Enabled = 0x1
	// Position of RESULTDONE field.
	SAADC_INTEN_RESULTDONE_Pos = 0x3
	// Bit mask of RESULTDONE field.
	SAADC_INTEN_RESULTDONE_Msk = 0x8
	// Bit RESULTDONE.
	SAADC_INTEN_RESULTDONE = 0x8
	// Disable
	SAADC_INTEN_RESULTDONE_Disabled = 0x0
	// Enable
	SAADC_INTEN_RESULTDONE_Enabled = 0x1
	// Position of CALIBRATEDONE field.
	SAADC_INTEN_CALIBRATEDONE_Pos = 0x4
	// Bit mask of CALIBRATEDONE field.
	SAADC_INTEN_CALIBRATEDONE_Msk = 0x10
	// Bit CALIBRATEDONE.
	SAADC_INTEN_CALIBRATEDONE = 0x10
	// Disable
	SAADC_INTEN_CALIBRATEDONE_Disabled = 0x0
	// Enable
	SAADC_INTEN_CALIBRATEDONE_Enabled = 0x1
	// Position of STOPPED field.
	SAADC_INTEN_STOPPED_Pos = 0x5
	// Bit mask of STOPPED field.
	SAADC_INTEN_STOPPED_Msk = 0x20
	// Bit STOPPED.
	SAADC_INTEN_STOPPED = 0x20
	// Disable
	SAADC_INTEN_STOPPED_Disabled = 0x0
	// Enable
	SAADC_INTEN_STOPPED_Enabled = 0x1
	// Position of CH0LIMITH field.
	SAADC_INTEN_CH0LIMITH_Pos = 0x6
	// Bit mask of CH0LIMITH field.
	SAADC_INTEN_CH0LIMITH_Msk = 0x40
	// Bit CH0LIMITH.
	SAADC_INTEN_CH0LIMITH = 0x40
	// Disable
	SAADC_INTEN_CH0LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH0LIMITH_Enabled = 0x1
	// Position of CH0LIMITL field.
	SAADC_INTEN_CH0LIMITL_Pos = 0x7
	// Bit mask of CH0LIMITL field.
	SAADC_INTEN_CH0LIMITL_Msk = 0x80
	// Bit CH0LIMITL.
	SAADC_INTEN_CH0LIMITL = 0x80
	// Disable
	SAADC_INTEN_CH0LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH0LIMITL_Enabled = 0x1
	// Position of CH1LIMITH field.
	SAADC_INTEN_CH1LIMITH_Pos = 0x8
	// Bit mask of CH1LIMITH field.
	SAADC_INTEN_CH1LIMITH_Msk = 0x100
	// Bit CH1LIMITH.
	SAADC_INTEN_CH1LIMITH = 0x100
	// Disable
	SAADC_INTEN_CH1LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH1LIMITH_Enabled = 0x1
	// Position of CH1LIMITL field.
	SAADC_INTEN_CH1LIMITL_Pos = 0x9
	// Bit mask of CH1LIMITL field.
	SAADC_INTEN_CH1LIMITL_Msk = 0x200
	// Bit CH1LIMITL.
	SAADC_INTEN_CH1LIMITL = 0x200
	// Disable
	SAADC_INTEN_CH1LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH1LIMITL_Enabled = 0x1
	// Position of CH2LIMITH field.
	SAADC_INTEN_CH2LIMITH_Pos = 0xa
	// Bit mask of CH2LIMITH field.
	SAADC_INTEN_CH2LIMITH_Msk = 0x400
	// Bit CH2LIMITH.
	SAADC_INTEN_CH2LIMITH = 0x400
	// Disable
	SAADC_INTEN_CH2LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH2LIMITH_Enabled = 0x1
	// Position of CH2LIMITL field.
	SAADC_INTEN_CH2LIMITL_Pos = 0xb
	// Bit mask of CH2LIMITL field.
	SAADC_INTEN_CH2LIMITL_Msk = 0x800
	// Bit CH2LIMITL.
	SAADC_INTEN_CH2LIMITL = 0x800
	// Disable
	SAADC_INTEN_CH2LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH2LIMITL_Enabled = 0x1
	// Position of CH3LIMITH field.
	SAADC_INTEN_CH3LIMITH_Pos = 0xc
	// Bit mask of CH3LIMITH field.
	SAADC_INTEN_CH3LIMITH_Msk = 0x1000
	// Bit CH3LIMITH.
	SAADC_INTEN_CH3LIMITH = 0x1000
	// Disable
	SAADC_INTEN_CH3LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH3LIMITH_Enabled = 0x1
	// Position of CH3LIMITL field.
	SAADC_INTEN_CH3LIMITL_Pos = 0xd
	// Bit mask of CH3LIMITL field.
	SAADC_INTEN_CH3LIMITL_Msk = 0x2000
	// Bit CH3LIMITL.
	SAADC_INTEN_CH3LIMITL = 0x2000
	// Disable
	SAADC_INTEN_CH3LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH3LIMITL_Enabled = 0x1
	// Position of CH4LIMITH field.
	SAADC_INTEN_CH4LIMITH_Pos = 0xe
	// Bit mask of CH4LIMITH field.
	SAADC_INTEN_CH4LIMITH_Msk = 0x4000
	// Bit CH4LIMITH.
	SAADC_INTEN_CH4LIMITH = 0x4000
	// Disable
	SAADC_INTEN_CH4LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH4LIMITH_Enabled = 0x1
	// Position of CH4LIMITL field.
	SAADC_INTEN_CH4LIMITL_Pos = 0xf
	// Bit mask of CH4LIMITL field.
	SAADC_INTEN_CH4LIMITL_Msk = 0x8000
	// Bit CH4LIMITL.
	SAADC_INTEN_CH4LIMITL = 0x8000
	// Disable
	SAADC_INTEN_CH4LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH4LIMITL_Enabled = 0x1
	// Position of CH5LIMITH field.
	SAADC_INTEN_CH5LIMITH_Pos = 0x10
	// Bit mask of CH5LIMITH field.
	SAADC_INTEN_CH5LIMITH_Msk = 0x10000
	// Bit CH5LIMITH.
	SAADC_INTEN_CH5LIMITH = 0x10000
	// Disable
	SAADC_INTEN_CH5LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH5LIMITH_Enabled = 0x1
	// Position of CH5LIMITL field.
	SAADC_INTEN_CH5LIMITL_Pos = 0x11
	// Bit mask of CH5LIMITL field.
	SAADC_INTEN_CH5LIMITL_Msk = 0x20000
	// Bit CH5LIMITL.
	SAADC_INTEN_CH5LIMITL = 0x20000
	// Disable
	SAADC_INTEN_CH5LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH5LIMITL_Enabled = 0x1
	// Position of CH6LIMITH field.
	SAADC_INTEN_CH6LIMITH_Pos = 0x12
	// Bit mask of CH6LIMITH field.
	SAADC_INTEN_CH6LIMITH_Msk = 0x40000
	// Bit CH6LIMITH.
	SAADC_INTEN_CH6LIMITH = 0x40000
	// Disable
	SAADC_INTEN_CH6LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH6LIMITH_Enabled = 0x1
	// Position of CH6LIMITL field.
	SAADC_INTEN_CH6LIMITL_Pos = 0x13
	// Bit mask of CH6LIMITL field.
	SAADC_INTEN_CH6LIMITL_Msk = 0x80000
	// Bit CH6LIMITL.
	SAADC_INTEN_CH6LIMITL = 0x80000
	// Disable
	SAADC_INTEN_CH6LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH6LIMITL_Enabled = 0x1
	// Position of CH7LIMITH field.
	SAADC_INTEN_CH7LIMITH_Pos = 0x14
	// Bit mask of CH7LIMITH field.
	SAADC_INTEN_CH7LIMITH_Msk = 0x100000
	// Bit CH7LIMITH.
	SAADC_INTEN_CH7LIMITH = 0x100000
	// Disable
	SAADC_INTEN_CH7LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH7LIMITH_Enabled = 0x1
	// Position of CH7LIMITL field.
	SAADC_INTEN_CH7LIMITL_Pos = 0x15
	// Bit mask of CH7LIMITL field.
	SAADC_INTEN_CH7LIMITL_Msk = 0x200000
	// Bit CH7LIMITL.
	SAADC_INTEN_CH7LIMITL = 0x200000
	// Disable
	SAADC_INTEN_CH7LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH7LIMITL_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STARTED field.
	SAADC_INTENSET_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	SAADC_INTENSET_STARTED_Msk = 0x1
	// Bit STARTED.
	SAADC_INTENSET_STARTED = 0x1
	// Read: Disabled
	SAADC_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_STARTED_Enabled = 0x1
	// Enable
	SAADC_INTENSET_STARTED_Set = 0x1
	// Position of END field.
	SAADC_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SAADC_INTENSET_END_Msk = 0x2
	// Bit END.
	SAADC_INTENSET_END = 0x2
	// Read: Disabled
	SAADC_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_END_Enabled = 0x1
	// Enable
	SAADC_INTENSET_END_Set = 0x1
	// Position of DONE field.
	SAADC_INTENSET_DONE_Pos = 0x2
	// Bit mask of DONE field.
	SAADC_INTENSET_DONE_Msk = 0x4
	// Bit DONE.
	SAADC_INTENSET_DONE = 0x4
	// Read: Disabled
	SAADC_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_DONE_Enabled = 0x1
	// Enable
	SAADC_INTENSET_DONE_Set = 0x1
	// Position of RESULTDONE field.
	SAADC_INTENSET_RESULTDONE_Pos = 0x3
	// Bit mask of RESULTDONE field.
	SAADC_INTENSET_RESULTDONE_Msk = 0x8
	// Bit RESULTDONE.
	SAADC_INTENSET_RESULTDONE = 0x8
	// Read: Disabled
	SAADC_INTENSET_RESULTDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_RESULTDONE_Enabled = 0x1
	// Enable
	SAADC_INTENSET_RESULTDONE_Set = 0x1
	// Position of CALIBRATEDONE field.
	SAADC_INTENSET_CALIBRATEDONE_Pos = 0x4
	// Bit mask of CALIBRATEDONE field.
	SAADC_INTENSET_CALIBRATEDONE_Msk = 0x10
	// Bit CALIBRATEDONE.
	SAADC_INTENSET_CALIBRATEDONE = 0x10
	// Read: Disabled
	SAADC_INTENSET_CALIBRATEDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CALIBRATEDONE_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CALIBRATEDONE_Set = 0x1
	// Position of STOPPED field.
	SAADC_INTENSET_STOPPED_Pos = 0x5
	// Bit mask of STOPPED field.
	SAADC_INTENSET_STOPPED_Msk = 0x20
	// Bit STOPPED.
	SAADC_INTENSET_STOPPED = 0x20
	// Read: Disabled
	SAADC_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SAADC_INTENSET_STOPPED_Set = 0x1
	// Position of CH0LIMITH field.
	SAADC_INTENSET_CH0LIMITH_Pos = 0x6
	// Bit mask of CH0LIMITH field.
	SAADC_INTENSET_CH0LIMITH_Msk = 0x40
	// Bit CH0LIMITH.
	SAADC_INTENSET_CH0LIMITH = 0x40
	// Read: Disabled
	SAADC_INTENSET_CH0LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH0LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH0LIMITH_Set = 0x1
	// Position of CH0LIMITL field.
	SAADC_INTENSET_CH0LIMITL_Pos = 0x7
	// Bit mask of CH0LIMITL field.
	SAADC_INTENSET_CH0LIMITL_Msk = 0x80
	// Bit CH0LIMITL.
	SAADC_INTENSET_CH0LIMITL = 0x80
	// Read: Disabled
	SAADC_INTENSET_CH0LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH0LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH0LIMITL_Set = 0x1
	// Position of CH1LIMITH field.
	SAADC_INTENSET_CH1LIMITH_Pos = 0x8
	// Bit mask of CH1LIMITH field.
	SAADC_INTENSET_CH1LIMITH_Msk = 0x100
	// Bit CH1LIMITH.
	SAADC_INTENSET_CH1LIMITH = 0x100
	// Read: Disabled
	SAADC_INTENSET_CH1LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH1LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH1LIMITH_Set = 0x1
	// Position of CH1LIMITL field.
	SAADC_INTENSET_CH1LIMITL_Pos = 0x9
	// Bit mask of CH1LIMITL field.
	SAADC_INTENSET_CH1LIMITL_Msk = 0x200
	// Bit CH1LIMITL.
	SAADC_INTENSET_CH1LIMITL = 0x200
	// Read: Disabled
	SAADC_INTENSET_CH1LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH1LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH1LIMITL_Set = 0x1
	// Position of CH2LIMITH field.
	SAADC_INTENSET_CH2LIMITH_Pos = 0xa
	// Bit mask of CH2LIMITH field.
	SAADC_INTENSET_CH2LIMITH_Msk = 0x400
	// Bit CH2LIMITH.
	SAADC_INTENSET_CH2LIMITH = 0x400
	// Read: Disabled
	SAADC_INTENSET_CH2LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH2LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH2LIMITH_Set = 0x1
	// Position of CH2LIMITL field.
	SAADC_INTENSET_CH2LIMITL_Pos = 0xb
	// Bit mask of CH2LIMITL field.
	SAADC_INTENSET_CH2LIMITL_Msk = 0x800
	// Bit CH2LIMITL.
	SAADC_INTENSET_CH2LIMITL = 0x800
	// Read: Disabled
	SAADC_INTENSET_CH2LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH2LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH2LIMITL_Set = 0x1
	// Position of CH3LIMITH field.
	SAADC_INTENSET_CH3LIMITH_Pos = 0xc
	// Bit mask of CH3LIMITH field.
	SAADC_INTENSET_CH3LIMITH_Msk = 0x1000
	// Bit CH3LIMITH.
	SAADC_INTENSET_CH3LIMITH = 0x1000
	// Read: Disabled
	SAADC_INTENSET_CH3LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH3LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH3LIMITH_Set = 0x1
	// Position of CH3LIMITL field.
	SAADC_INTENSET_CH3LIMITL_Pos = 0xd
	// Bit mask of CH3LIMITL field.
	SAADC_INTENSET_CH3LIMITL_Msk = 0x2000
	// Bit CH3LIMITL.
	SAADC_INTENSET_CH3LIMITL = 0x2000
	// Read: Disabled
	SAADC_INTENSET_CH3LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH3LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH3LIMITL_Set = 0x1
	// Position of CH4LIMITH field.
	SAADC_INTENSET_CH4LIMITH_Pos = 0xe
	// Bit mask of CH4LIMITH field.
	SAADC_INTENSET_CH4LIMITH_Msk = 0x4000
	// Bit CH4LIMITH.
	SAADC_INTENSET_CH4LIMITH = 0x4000
	// Read: Disabled
	SAADC_INTENSET_CH4LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH4LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH4LIMITH_Set = 0x1
	// Position of CH4LIMITL field.
	SAADC_INTENSET_CH4LIMITL_Pos = 0xf
	// Bit mask of CH4LIMITL field.
	SAADC_INTENSET_CH4LIMITL_Msk = 0x8000
	// Bit CH4LIMITL.
	SAADC_INTENSET_CH4LIMITL = 0x8000
	// Read: Disabled
	SAADC_INTENSET_CH4LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH4LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH4LIMITL_Set = 0x1
	// Position of CH5LIMITH field.
	SAADC_INTENSET_CH5LIMITH_Pos = 0x10
	// Bit mask of CH5LIMITH field.
	SAADC_INTENSET_CH5LIMITH_Msk = 0x10000
	// Bit CH5LIMITH.
	SAADC_INTENSET_CH5LIMITH = 0x10000
	// Read: Disabled
	SAADC_INTENSET_CH5LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH5LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH5LIMITH_Set = 0x1
	// Position of CH5LIMITL field.
	SAADC_INTENSET_CH5LIMITL_Pos = 0x11
	// Bit mask of CH5LIMITL field.
	SAADC_INTENSET_CH5LIMITL_Msk = 0x20000
	// Bit CH5LIMITL.
	SAADC_INTENSET_CH5LIMITL = 0x20000
	// Read: Disabled
	SAADC_INTENSET_CH5LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH5LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH5LIMITL_Set = 0x1
	// Position of CH6LIMITH field.
	SAADC_INTENSET_CH6LIMITH_Pos = 0x12
	// Bit mask of CH6LIMITH field.
	SAADC_INTENSET_CH6LIMITH_Msk = 0x40000
	// Bit CH6LIMITH.
	SAADC_INTENSET_CH6LIMITH = 0x40000
	// Read: Disabled
	SAADC_INTENSET_CH6LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH6LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH6LIMITH_Set = 0x1
	// Position of CH6LIMITL field.
	SAADC_INTENSET_CH6LIMITL_Pos = 0x13
	// Bit mask of CH6LIMITL field.
	SAADC_INTENSET_CH6LIMITL_Msk = 0x80000
	// Bit CH6LIMITL.
	SAADC_INTENSET_CH6LIMITL = 0x80000
	// Read: Disabled
	SAADC_INTENSET_CH6LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH6LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH6LIMITL_Set = 0x1
	// Position of CH7LIMITH field.
	SAADC_INTENSET_CH7LIMITH_Pos = 0x14
	// Bit mask of CH7LIMITH field.
	SAADC_INTENSET_CH7LIMITH_Msk = 0x100000
	// Bit CH7LIMITH.
	SAADC_INTENSET_CH7LIMITH = 0x100000
	// Read: Disabled
	SAADC_INTENSET_CH7LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH7LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH7LIMITH_Set = 0x1
	// Position of CH7LIMITL field.
	SAADC_INTENSET_CH7LIMITL_Pos = 0x15
	// Bit mask of CH7LIMITL field.
	SAADC_INTENSET_CH7LIMITL_Msk = 0x200000
	// Bit CH7LIMITL.
	SAADC_INTENSET_CH7LIMITL = 0x200000
	// Read: Disabled
	SAADC_INTENSET_CH7LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH7LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH7LIMITL_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STARTED field.
	SAADC_INTENCLR_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	SAADC_INTENCLR_STARTED_Msk = 0x1
	// Bit STARTED.
	SAADC_INTENCLR_STARTED = 0x1
	// Read: Disabled
	SAADC_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_STARTED_Clear = 0x1
	// Position of END field.
	SAADC_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SAADC_INTENCLR_END_Msk = 0x2
	// Bit END.
	SAADC_INTENCLR_END = 0x2
	// Read: Disabled
	SAADC_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_END_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_END_Clear = 0x1
	// Position of DONE field.
	SAADC_INTENCLR_DONE_Pos = 0x2
	// Bit mask of DONE field.
	SAADC_INTENCLR_DONE_Msk = 0x4
	// Bit DONE.
	SAADC_INTENCLR_DONE = 0x4
	// Read: Disabled
	SAADC_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_DONE_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_DONE_Clear = 0x1
	// Position of RESULTDONE field.
	SAADC_INTENCLR_RESULTDONE_Pos = 0x3
	// Bit mask of RESULTDONE field.
	SAADC_INTENCLR_RESULTDONE_Msk = 0x8
	// Bit RESULTDONE.
	SAADC_INTENCLR_RESULTDONE = 0x8
	// Read: Disabled
	SAADC_INTENCLR_RESULTDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_RESULTDONE_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_RESULTDONE_Clear = 0x1
	// Position of CALIBRATEDONE field.
	SAADC_INTENCLR_CALIBRATEDONE_Pos = 0x4
	// Bit mask of CALIBRATEDONE field.
	SAADC_INTENCLR_CALIBRATEDONE_Msk = 0x10
	// Bit CALIBRATEDONE.
	SAADC_INTENCLR_CALIBRATEDONE = 0x10
	// Read: Disabled
	SAADC_INTENCLR_CALIBRATEDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CALIBRATEDONE_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CALIBRATEDONE_Clear = 0x1
	// Position of STOPPED field.
	SAADC_INTENCLR_STOPPED_Pos = 0x5
	// Bit mask of STOPPED field.
	SAADC_INTENCLR_STOPPED_Msk = 0x20
	// Bit STOPPED.
	SAADC_INTENCLR_STOPPED = 0x20
	// Read: Disabled
	SAADC_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_STOPPED_Clear = 0x1
	// Position of CH0LIMITH field.
	SAADC_INTENCLR_CH0LIMITH_Pos = 0x6
	// Bit mask of CH0LIMITH field.
	SAADC_INTENCLR_CH0LIMITH_Msk = 0x40
	// Bit CH0LIMITH.
	SAADC_INTENCLR_CH0LIMITH = 0x40
	// Read: Disabled
	SAADC_INTENCLR_CH0LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH0LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH0LIMITH_Clear = 0x1
	// Position of CH0LIMITL field.
	SAADC_INTENCLR_CH0LIMITL_Pos = 0x7
	// Bit mask of CH0LIMITL field.
	SAADC_INTENCLR_CH0LIMITL_Msk = 0x80
	// Bit CH0LIMITL.
	SAADC_INTENCLR_CH0LIMITL = 0x80
	// Read: Disabled
	SAADC_INTENCLR_CH0LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH0LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH0LIMITL_Clear = 0x1
	// Position of CH1LIMITH field.
	SAADC_INTENCLR_CH1LIMITH_Pos = 0x8
	// Bit mask of CH1LIMITH field.
	SAADC_INTENCLR_CH1LIMITH_Msk = 0x100
	// Bit CH1LIMITH.
	SAADC_INTENCLR_CH1LIMITH = 0x100
	// Read: Disabled
	SAADC_INTENCLR_CH1LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH1LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH1LIMITH_Clear = 0x1
	// Position of CH1LIMITL field.
	SAADC_INTENCLR_CH1LIMITL_Pos = 0x9
	// Bit mask of CH1LIMITL field.
	SAADC_INTENCLR_CH1LIMITL_Msk = 0x200
	// Bit CH1LIMITL.
	SAADC_INTENCLR_CH1LIMITL = 0x200
	// Read: Disabled
	SAADC_INTENCLR_CH1LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH1LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH1LIMITL_Clear = 0x1
	// Position of CH2LIMITH field.
	SAADC_INTENCLR_CH2LIMITH_Pos = 0xa
	// Bit mask of CH2LIMITH field.
	SAADC_INTENCLR_CH2LIMITH_Msk = 0x400
	// Bit CH2LIMITH.
	SAADC_INTENCLR_CH2LIMITH = 0x400
	// Read: Disabled
	SAADC_INTENCLR_CH2LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH2LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH2LIMITH_Clear = 0x1
	// Position of CH2LIMITL field.
	SAADC_INTENCLR_CH2LIMITL_Pos = 0xb
	// Bit mask of CH2LIMITL field.
	SAADC_INTENCLR_CH2LIMITL_Msk = 0x800
	// Bit CH2LIMITL.
	SAADC_INTENCLR_CH2LIMITL = 0x800
	// Read: Disabled
	SAADC_INTENCLR_CH2LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH2LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH2LIMITL_Clear = 0x1
	// Position of CH3LIMITH field.
	SAADC_INTENCLR_CH3LIMITH_Pos = 0xc
	// Bit mask of CH3LIMITH field.
	SAADC_INTENCLR_CH3LIMITH_Msk = 0x1000
	// Bit CH3LIMITH.
	SAADC_INTENCLR_CH3LIMITH = 0x1000
	// Read: Disabled
	SAADC_INTENCLR_CH3LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH3LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH3LIMITH_Clear = 0x1
	// Position of CH3LIMITL field.
	SAADC_INTENCLR_CH3LIMITL_Pos = 0xd
	// Bit mask of CH3LIMITL field.
	SAADC_INTENCLR_CH3LIMITL_Msk = 0x2000
	// Bit CH3LIMITL.
	SAADC_INTENCLR_CH3LIMITL = 0x2000
	// Read: Disabled
	SAADC_INTENCLR_CH3LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH3LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH3LIMITL_Clear = 0x1
	// Position of CH4LIMITH field.
	SAADC_INTENCLR_CH4LIMITH_Pos = 0xe
	// Bit mask of CH4LIMITH field.
	SAADC_INTENCLR_CH4LIMITH_Msk = 0x4000
	// Bit CH4LIMITH.
	SAADC_INTENCLR_CH4LIMITH = 0x4000
	// Read: Disabled
	SAADC_INTENCLR_CH4LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH4LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH4LIMITH_Clear = 0x1
	// Position of CH4LIMITL field.
	SAADC_INTENCLR_CH4LIMITL_Pos = 0xf
	// Bit mask of CH4LIMITL field.
	SAADC_INTENCLR_CH4LIMITL_Msk = 0x8000
	// Bit CH4LIMITL.
	SAADC_INTENCLR_CH4LIMITL = 0x8000
	// Read: Disabled
	SAADC_INTENCLR_CH4LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH4LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH4LIMITL_Clear = 0x1
	// Position of CH5LIMITH field.
	SAADC_INTENCLR_CH5LIMITH_Pos = 0x10
	// Bit mask of CH5LIMITH field.
	SAADC_INTENCLR_CH5LIMITH_Msk = 0x10000
	// Bit CH5LIMITH.
	SAADC_INTENCLR_CH5LIMITH = 0x10000
	// Read: Disabled
	SAADC_INTENCLR_CH5LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH5LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH5LIMITH_Clear = 0x1
	// Position of CH5LIMITL field.
	SAADC_INTENCLR_CH5LIMITL_Pos = 0x11
	// Bit mask of CH5LIMITL field.
	SAADC_INTENCLR_CH5LIMITL_Msk = 0x20000
	// Bit CH5LIMITL.
	SAADC_INTENCLR_CH5LIMITL = 0x20000
	// Read: Disabled
	SAADC_INTENCLR_CH5LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH5LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH5LIMITL_Clear = 0x1
	// Position of CH6LIMITH field.
	SAADC_INTENCLR_CH6LIMITH_Pos = 0x12
	// Bit mask of CH6LIMITH field.
	SAADC_INTENCLR_CH6LIMITH_Msk = 0x40000
	// Bit CH6LIMITH.
	SAADC_INTENCLR_CH6LIMITH = 0x40000
	// Read: Disabled
	SAADC_INTENCLR_CH6LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH6LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH6LIMITH_Clear = 0x1
	// Position of CH6LIMITL field.
	SAADC_INTENCLR_CH6LIMITL_Pos = 0x13
	// Bit mask of CH6LIMITL field.
	SAADC_INTENCLR_CH6LIMITL_Msk = 0x80000
	// Bit CH6LIMITL.
	SAADC_INTENCLR_CH6LIMITL = 0x80000
	// Read: Disabled
	SAADC_INTENCLR_CH6LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH6LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH6LIMITL_Clear = 0x1
	// Position of CH7LIMITH field.
	SAADC_INTENCLR_CH7LIMITH_Pos = 0x14
	// Bit mask of CH7LIMITH field.
	SAADC_INTENCLR_CH7LIMITH_Msk = 0x100000
	// Bit CH7LIMITH.
	SAADC_INTENCLR_CH7LIMITH = 0x100000
	// Read: Disabled
	SAADC_INTENCLR_CH7LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH7LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH7LIMITH_Clear = 0x1
	// Position of CH7LIMITL field.
	SAADC_INTENCLR_CH7LIMITL_Pos = 0x15
	// Bit mask of CH7LIMITL field.
	SAADC_INTENCLR_CH7LIMITL_Msk = 0x200000
	// Bit CH7LIMITL.
	SAADC_INTENCLR_CH7LIMITL = 0x200000
	// Read: Disabled
	SAADC_INTENCLR_CH7LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH7LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH7LIMITL_Clear = 0x1

	// STATUS: Status
	// Position of STATUS field.
	SAADC_STATUS_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	SAADC_STATUS_STATUS_Msk = 0x1
	// Bit STATUS.
	SAADC_STATUS_STATUS = 0x1
	// ADC is ready. No on-going conversion.
	SAADC_STATUS_STATUS_Ready = 0x0
	// ADC is busy. Single conversion in progress.
	SAADC_STATUS_STATUS_Busy = 0x1

	// ENABLE: Enable or disable ADC
	// Position of ENABLE field.
	SAADC_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SAADC_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SAADC_ENABLE_ENABLE = 0x1
	// Disable ADC
	SAADC_ENABLE_ENABLE_Disabled = 0x0
	// Enable ADC
	SAADC_ENABLE_ENABLE_Enabled = 0x1

	// CH.PSELP: Description cluster: Input positive pin selection for CH[n]
	// Position of PSELP field.
	SAADC_CH_PSELP_PSELP_Pos = 0x0
	// Bit mask of PSELP field.
	SAADC_CH_PSELP_PSELP_Msk = 0x1f
	// Not connected
	SAADC_CH_PSELP_PSELP_NC = 0x0
	// AIN0
	SAADC_CH_PSELP_PSELP_AnalogInput0 = 0x1
	// AIN1
	SAADC_CH_PSELP_PSELP_AnalogInput1 = 0x2
	// AIN2
	SAADC_CH_PSELP_PSELP_AnalogInput2 = 0x3
	// AIN3
	SAADC_CH_PSELP_PSELP_AnalogInput3 = 0x4
	// AIN4
	SAADC_CH_PSELP_PSELP_AnalogInput4 = 0x5
	// AIN5
	SAADC_CH_PSELP_PSELP_AnalogInput5 = 0x6
	// AIN6
	SAADC_CH_PSELP_PSELP_AnalogInput6 = 0x7
	// AIN7
	SAADC_CH_PSELP_PSELP_AnalogInput7 = 0x8
	// VDD_GPIO
	SAADC_CH_PSELP_PSELP_VDDGPIO = 0x9

	// CH.PSELN: Description cluster: Input negative pin selection for CH[n]
	// Position of PSELN field.
	SAADC_CH_PSELN_PSELN_Pos = 0x0
	// Bit mask of PSELN field.
	SAADC_CH_PSELN_PSELN_Msk = 0x1f
	// Not connected
	SAADC_CH_PSELN_PSELN_NC = 0x0
	// AIN0
	SAADC_CH_PSELN_PSELN_AnalogInput0 = 0x1
	// AIN1
	SAADC_CH_PSELN_PSELN_AnalogInput1 = 0x2
	// AIN2
	SAADC_CH_PSELN_PSELN_AnalogInput2 = 0x3
	// AIN3
	SAADC_CH_PSELN_PSELN_AnalogInput3 = 0x4
	// AIN4
	SAADC_CH_PSELN_PSELN_AnalogInput4 = 0x5
	// AIN5
	SAADC_CH_PSELN_PSELN_AnalogInput5 = 0x6
	// AIN6
	SAADC_CH_PSELN_PSELN_AnalogInput6 = 0x7
	// AIN7
	SAADC_CH_PSELN_PSELN_AnalogInput7 = 0x8
	// VDD_GPIO
	SAADC_CH_PSELN_PSELN_VDD_GPIO = 0x9

	// CH.CONFIG: Description cluster: Input configuration for CH[n]
	// Position of RESP field.
	SAADC_CH_CONFIG_RESP_Pos = 0x0
	// Bit mask of RESP field.
	SAADC_CH_CONFIG_RESP_Msk = 0x3
	// Bypass resistor ladder
	SAADC_CH_CONFIG_RESP_Bypass = 0x0
	// Pull-down to GND
	SAADC_CH_CONFIG_RESP_Pulldown = 0x1
	// Pull-up to VDD_GPIO
	SAADC_CH_CONFIG_RESP_Pullup = 0x2
	// Set input at VDD_GPIO/2
	SAADC_CH_CONFIG_RESP_VDD1_2 = 0x3
	// Position of RESN field.
	SAADC_CH_CONFIG_RESN_Pos = 0x4
	// Bit mask of RESN field.
	SAADC_CH_CONFIG_RESN_Msk = 0x30
	// Bypass resistor ladder
	SAADC_CH_CONFIG_RESN_Bypass = 0x0
	// Pull-down to GND
	SAADC_CH_CONFIG_RESN_Pulldown = 0x1
	// Pull-up to VDD_GPIO
	SAADC_CH_CONFIG_RESN_Pullup = 0x2
	// Set input at VDD_GPIO/2
	SAADC_CH_CONFIG_RESN_VDD1_2 = 0x3
	// Position of GAIN field.
	SAADC_CH_CONFIG_GAIN_Pos = 0x8
	// Bit mask of GAIN field.
	SAADC_CH_CONFIG_GAIN_Msk = 0x700
	// 1/6
	SAADC_CH_CONFIG_GAIN_Gain1_6 = 0x0
	// 1/5
	SAADC_CH_CONFIG_GAIN_Gain1_5 = 0x1
	// 1/4
	SAADC_CH_CONFIG_GAIN_Gain1_4 = 0x2
	// 1/3
	SAADC_CH_CONFIG_GAIN_Gain1_3 = 0x3
	// 1/2
	SAADC_CH_CONFIG_GAIN_Gain1_2 = 0x4
	// 1
	SAADC_CH_CONFIG_GAIN_Gain1 = 0x5
	// 2
	SAADC_CH_CONFIG_GAIN_Gain2 = 0x6
	// 4
	SAADC_CH_CONFIG_GAIN_Gain4 = 0x7
	// Position of REFSEL field.
	SAADC_CH_CONFIG_REFSEL_Pos = 0xc
	// Bit mask of REFSEL field.
	SAADC_CH_CONFIG_REFSEL_Msk = 0x1000
	// Bit REFSEL.
	SAADC_CH_CONFIG_REFSEL = 0x1000
	// Internal reference (0.6 V)
	SAADC_CH_CONFIG_REFSEL_Internal = 0x0
	// VDD_GPIO/4 as reference
	SAADC_CH_CONFIG_REFSEL_VDD1_4 = 0x1
	// Position of TACQ field.
	SAADC_CH_CONFIG_TACQ_Pos = 0x10
	// Bit mask of TACQ field.
	SAADC_CH_CONFIG_TACQ_Msk = 0x70000
	// 3 us
	SAADC_CH_CONFIG_TACQ_3us = 0x0
	// 5 us
	SAADC_CH_CONFIG_TACQ_5us = 0x1
	// 10 us
	SAADC_CH_CONFIG_TACQ_10us = 0x2
	// 15 us
	SAADC_CH_CONFIG_TACQ_15us = 0x3
	// 20 us
	SAADC_CH_CONFIG_TACQ_20us = 0x4
	// 40 us
	SAADC_CH_CONFIG_TACQ_40us = 0x5
	// Position of MODE field.
	SAADC_CH_CONFIG_MODE_Pos = 0x14
	// Bit mask of MODE field.
	SAADC_CH_CONFIG_MODE_Msk = 0x100000
	// Bit MODE.
	SAADC_CH_CONFIG_MODE = 0x100000
	// Single ended, PSELN will be ignored, negative input to ADC shorted to GND
	SAADC_CH_CONFIG_MODE_SE = 0x0
	// Differential
	SAADC_CH_CONFIG_MODE_Diff = 0x1
	// Position of BURST field.
	SAADC_CH_CONFIG_BURST_Pos = 0x18
	// Bit mask of BURST field.
	SAADC_CH_CONFIG_BURST_Msk = 0x1000000
	// Bit BURST.
	SAADC_CH_CONFIG_BURST = 0x1000000
	// Burst mode is disabled (normal operation)
	SAADC_CH_CONFIG_BURST_Disabled = 0x0
	// Burst mode is enabled. SAADC takes 2^OVERSAMPLE number of samples as fast as it can, and sends the average to Data RAM.
	SAADC_CH_CONFIG_BURST_Enabled = 0x1

	// CH.LIMIT: Description cluster: High/low limits for event monitoring a channel
	// Position of LOW field.
	SAADC_CH_LIMIT_LOW_Pos = 0x0
	// Bit mask of LOW field.
	SAADC_CH_LIMIT_LOW_Msk = 0xffff
	// Position of HIGH field.
	SAADC_CH_LIMIT_HIGH_Pos = 0x10
	// Bit mask of HIGH field.
	SAADC_CH_LIMIT_HIGH_Msk = 0xffff0000

	// RESOLUTION: Resolution configuration
	// Position of VAL field.
	SAADC_RESOLUTION_VAL_Pos = 0x0
	// Bit mask of VAL field.
	SAADC_RESOLUTION_VAL_Msk = 0x7
	// 8 bit
	SAADC_RESOLUTION_VAL_8bit = 0x0
	// 10 bit
	SAADC_RESOLUTION_VAL_10bit = 0x1
	// 12 bit
	SAADC_RESOLUTION_VAL_12bit = 0x2
	// 14 bit
	SAADC_RESOLUTION_VAL_14bit = 0x3

	// OVERSAMPLE: Oversampling configuration. OVERSAMPLE should not be combined with SCAN. The RESOLUTION is applied before averaging, thus for high OVERSAMPLE a higher RESOLUTION should be used.
	// Position of OVERSAMPLE field.
	SAADC_OVERSAMPLE_OVERSAMPLE_Pos = 0x0
	// Bit mask of OVERSAMPLE field.
	SAADC_OVERSAMPLE_OVERSAMPLE_Msk = 0xf
	// Bypass oversampling
	SAADC_OVERSAMPLE_OVERSAMPLE_Bypass = 0x0
	// Oversample 2x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over2x = 0x1
	// Oversample 4x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over4x = 0x2
	// Oversample 8x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over8x = 0x3
	// Oversample 16x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over16x = 0x4
	// Oversample 32x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over32x = 0x5
	// Oversample 64x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over64x = 0x6
	// Oversample 128x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over128x = 0x7
	// Oversample 256x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over256x = 0x8

	// SAMPLERATE: Controls normal or continuous sample rate
	// Position of CC field.
	SAADC_SAMPLERATE_CC_Pos = 0x0
	// Bit mask of CC field.
	SAADC_SAMPLERATE_CC_Msk = 0x7ff
	// Position of MODE field.
	SAADC_SAMPLERATE_MODE_Pos = 0xc
	// Bit mask of MODE field.
	SAADC_SAMPLERATE_MODE_Msk = 0x1000
	// Bit MODE.
	SAADC_SAMPLERATE_MODE = 0x1000
	// Rate is controlled from SAMPLE task
	SAADC_SAMPLERATE_MODE_Task = 0x0
	// Rate is controlled from local timer (use CC to control the rate)
	SAADC_SAMPLERATE_MODE_Timers = 0x1

	// RESULT.PTR: Data pointer
	// Position of PTR field.
	SAADC_RESULT_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SAADC_RESULT_PTR_PTR_Msk = 0xffffffff

	// RESULT.MAXCNT: Maximum number of buffer words to transfer
	// Position of MAXCNT field.
	SAADC_RESULT_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SAADC_RESULT_MAXCNT_MAXCNT_Msk = 0x7fff

	// RESULT.AMOUNT: Number of buffer words transferred since last START
	// Position of AMOUNT field.
	SAADC_RESULT_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SAADC_RESULT_AMOUNT_AMOUNT_Msk = 0x7fff
)

// Constants for TIMER0_NS: Timer/Counter 0
const (
	// TASKS_START: Start Timer
	// Position of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TIMER_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TIMER_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop Timer
	// Position of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TIMER_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TIMER_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_COUNT: Increment Timer (Counter mode only)
	// Position of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Pos = 0x0
	// Bit mask of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Msk = 0x1
	// Bit TASKS_COUNT.
	TIMER_TASKS_COUNT_TASKS_COUNT = 0x1
	// Trigger task
	TIMER_TASKS_COUNT_TASKS_COUNT_Trigger = 0x1

	// TASKS_CLEAR: Clear time
	// Position of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	TIMER_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_SHUTDOWN: Deprecated register - Shut down timer
	// Position of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Pos = 0x0
	// Bit mask of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Msk = 0x1
	// Bit TASKS_SHUTDOWN.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN = 0x1
	// Trigger task
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Trigger = 0x1

	// TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
	// Position of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Pos = 0x0
	// Bit mask of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Msk = 0x1
	// Bit TASKS_CAPTURE.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE = 0x1
	// Trigger task
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_COUNT: Subscribe configuration for task COUNT
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_COUNT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_COUNT_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_SUBSCRIBE_COUNT_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_COUNT_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_COUNT_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_COUNT_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_COUNT_EN_Enabled = 0x1

	// SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_CLEAR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_CLEAR_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_SUBSCRIBE_CLEAR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_CLEAR_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_CLEAR_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_CLEAR_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_CLEAR_EN_Enabled = 0x1

	// SUBSCRIBE_SHUTDOWN: Deprecated register - Subscribe configuration for task SHUTDOWN
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_SHUTDOWN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_SHUTDOWN_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_SHUTDOWN_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Enabled = 0x1

	// SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_CAPTURE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_CAPTURE_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_SUBSCRIBE_CAPTURE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_CAPTURE_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_CAPTURE_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_CAPTURE_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_CAPTURE_EN_Enabled = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
	// Position of CHIDX field.
	TIMER_PUBLISH_COMPARE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_PUBLISH_COMPARE_CHIDX_Msk = 0xf
	// Position of EN field.
	TIMER_PUBLISH_COMPARE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_PUBLISH_COMPARE_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_PUBLISH_COMPARE_EN = 0x80000000
	// Disable publishing
	TIMER_PUBLISH_COMPARE_EN_Disabled = 0x0
	// Enable publishing
	TIMER_PUBLISH_COMPARE_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	TIMER_SHORTS_COMPARE0_CLEAR = 0x1
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	TIMER_SHORTS_COMPARE1_CLEAR = 0x2
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	TIMER_SHORTS_COMPARE2_CLEAR = 0x4
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	TIMER_SHORTS_COMPARE3_CLEAR = 0x8
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Enabled = 0x1
	// Position of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Pos = 0x4
	// Bit mask of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Msk = 0x10
	// Bit COMPARE4_CLEAR.
	TIMER_SHORTS_COMPARE4_CLEAR = 0x10
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Enabled = 0x1
	// Position of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Pos = 0x5
	// Bit mask of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Msk = 0x20
	// Bit COMPARE5_CLEAR.
	TIMER_SHORTS_COMPARE5_CLEAR = 0x20
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Enabled = 0x1
	// Position of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Pos = 0x8
	// Bit mask of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Msk = 0x100
	// Bit COMPARE0_STOP.
	TIMER_SHORTS_COMPARE0_STOP = 0x100
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Enabled = 0x1
	// Position of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Pos = 0x9
	// Bit mask of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Msk = 0x200
	// Bit COMPARE1_STOP.
	TIMER_SHORTS_COMPARE1_STOP = 0x200
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Enabled = 0x1
	// Position of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Pos = 0xa
	// Bit mask of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Msk = 0x400
	// Bit COMPARE2_STOP.
	TIMER_SHORTS_COMPARE2_STOP = 0x400
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Enabled = 0x1
	// Position of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Pos = 0xb
	// Bit mask of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Msk = 0x800
	// Bit COMPARE3_STOP.
	TIMER_SHORTS_COMPARE3_STOP = 0x800
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Enabled = 0x1
	// Position of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Pos = 0xc
	// Bit mask of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Msk = 0x1000
	// Bit COMPARE4_STOP.
	TIMER_SHORTS_COMPARE4_STOP = 0x1000
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Enabled = 0x1
	// Position of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Pos = 0xd
	// Bit mask of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Msk = 0x2000
	// Bit COMPARE5_STOP.
	TIMER_SHORTS_COMPARE5_STOP = 0x2000
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE3_Set = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENSET_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENSET_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE4_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE4_Set = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENSET_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENSET_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE5_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE5_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE3_Clear = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENCLR_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE4_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE4_Clear = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENCLR_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE5_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE5_Clear = 0x1

	// MODE: Timer mode selection
	// Position of MODE field.
	TIMER_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	TIMER_MODE_MODE_Msk = 0x3
	// Select Timer mode
	TIMER_MODE_MODE_Timer = 0x0
	// Deprecated enumerator - Select Counter mode
	TIMER_MODE_MODE_Counter = 0x1
	// Select Low Power Counter mode
	TIMER_MODE_MODE_LowPowerCounter = 0x2

	// BITMODE: Configure the number of bits used by the TIMER
	// Position of BITMODE field.
	TIMER_BITMODE_BITMODE_Pos = 0x0
	// Bit mask of BITMODE field.
	TIMER_BITMODE_BITMODE_Msk = 0x3
	// 16 bit timer bit width
	TIMER_BITMODE_BITMODE_16Bit = 0x0
	// 8 bit timer bit width
	TIMER_BITMODE_BITMODE_08Bit = 0x1
	// 24 bit timer bit width
	TIMER_BITMODE_BITMODE_24Bit = 0x2
	// 32 bit timer bit width
	TIMER_BITMODE_BITMODE_32Bit = 0x3

	// PRESCALER: Timer prescaler register
	// Position of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Msk = 0xf

	// ONESHOTEN: Description collection: Enable one-shot operation for Capture/Compare channel n
	// Position of ONESHOTEN field.
	TIMER_ONESHOTEN_ONESHOTEN_Pos = 0x0
	// Bit mask of ONESHOTEN field.
	TIMER_ONESHOTEN_ONESHOTEN_Msk = 0x1
	// Bit ONESHOTEN.
	TIMER_ONESHOTEN_ONESHOTEN = 0x1
	// Disable one-shot operation
	TIMER_ONESHOTEN_ONESHOTEN_Disable = 0x0
	// Enable one-shot operation
	TIMER_ONESHOTEN_ONESHOTEN_Enable = 0x1

	// CC: Description collection: Capture/Compare register n
	// Position of CC field.
	TIMER_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TIMER_CC_CC_Msk = 0xffffffff
)

// Constants for RTC0_NS: Real-time counter 0
const (
	// TASKS_START: Start RTC counter
	// Position of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RTC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RTC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RTC counter
	// Position of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RTC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RTC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_CLEAR: Clear RTC counter
	// Position of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	RTC_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	RTC_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_TRIGOVRFLW: Set counter to 0xFFFFF0
	// Position of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Pos = 0x0
	// Bit mask of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Msk = 0x1
	// Bit TASKS_TRIGOVRFLW.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW = 0x1
	// Trigger task
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RTC_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RTC_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
	// Position of CHIDX field.
	RTC_SUBSCRIBE_CLEAR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_CLEAR_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_SUBSCRIBE_CLEAR_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_CLEAR_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_CLEAR_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_CLEAR_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_CLEAR_EN_Enabled = 0x1

	// SUBSCRIBE_TRIGOVRFLW: Subscribe configuration for task TRIGOVRFLW
	// Position of CHIDX field.
	RTC_SUBSCRIBE_TRIGOVRFLW_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_TRIGOVRFLW_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Enabled = 0x1

	// EVENTS_TICK: Event on counter increment
	// Position of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Pos = 0x0
	// Bit mask of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Msk = 0x1
	// Bit EVENTS_TICK.
	RTC_EVENTS_TICK_EVENTS_TICK = 0x1
	// Event not generated
	RTC_EVENTS_TICK_EVENTS_TICK_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_TICK_EVENTS_TICK_Generated = 0x1

	// EVENTS_OVRFLW: Event on counter overflow
	// Position of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Pos = 0x0
	// Bit mask of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Msk = 0x1
	// Bit EVENTS_OVRFLW.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW = 0x1
	// Event not generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Generated = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// PUBLISH_TICK: Publish configuration for event TICK
	// Position of CHIDX field.
	RTC_PUBLISH_TICK_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_TICK_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_PUBLISH_TICK_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_TICK_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_TICK_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_TICK_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_TICK_EN_Enabled = 0x1

	// PUBLISH_OVRFLW: Publish configuration for event OVRFLW
	// Position of CHIDX field.
	RTC_PUBLISH_OVRFLW_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_OVRFLW_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_PUBLISH_OVRFLW_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_OVRFLW_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_OVRFLW_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_OVRFLW_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_OVRFLW_EN_Enabled = 0x1

	// PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
	// Position of CHIDX field.
	RTC_PUBLISH_COMPARE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_COMPARE_CHIDX_Msk = 0xf
	// Position of EN field.
	RTC_PUBLISH_COMPARE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_COMPARE_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_COMPARE_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_COMPARE_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_COMPARE_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TICK field.
	RTC_INTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENSET_TICK = 0x1
	// Read: Disabled
	RTC_INTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_INTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_INTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_INTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE3_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TICK field.
	RTC_INTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_INTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_INTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_INTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE3_Clear = 0x1

	// EVTEN: Enable or disable event routing
	// Position of TICK field.
	RTC_EVTEN_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTEN_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTEN_TICK = 0x1
	// Disable
	RTC_EVTEN_TICK_Disabled = 0x0
	// Disable
	RTC_EVTEN_TICK_Enabled = 0x1
	// Position of OVRFLW field.
	RTC_EVTEN_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTEN_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTEN_OVRFLW = 0x2
	// Disable
	RTC_EVTEN_OVRFLW_Disabled = 0x0
	// Disable
	RTC_EVTEN_OVRFLW_Enabled = 0x1
	// Position of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTEN_COMPARE0 = 0x10000
	// Disable
	RTC_EVTEN_COMPARE0_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTEN_COMPARE1 = 0x20000
	// Disable
	RTC_EVTEN_COMPARE1_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTEN_COMPARE2 = 0x40000
	// Disable
	RTC_EVTEN_COMPARE2_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTEN_COMPARE3 = 0x80000
	// Disable
	RTC_EVTEN_COMPARE3_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE3_Enabled = 0x1

	// EVTENSET: Enable event routing
	// Position of TICK field.
	RTC_EVTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENSET_TICK = 0x1
	// Read: Disabled
	RTC_EVTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_EVTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_EVTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE3_Set = 0x1

	// EVTENCLR: Disable event routing
	// Position of TICK field.
	RTC_EVTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_EVTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE3_Clear = 0x1

	// COUNTER: Current counter value
	// Position of COUNTER field.
	RTC_COUNTER_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	RTC_COUNTER_COUNTER_Msk = 0xffffff

	// PRESCALER: 12-bit prescaler for counter frequency (32768/(PRESCALER+1)). Must be written when RTC is stopped.
	// Position of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Msk = 0xfff

	// CC: Description collection: Compare register n
	// Position of COMPARE field.
	RTC_CC_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	RTC_CC_COMPARE_Msk = 0xffffff
)

// Constants for DPPIC_NS: Distributed Programmable Peripheral Interconnect Controller 0
const (
	// TASKS_CHG.EN: Description cluster: Enable channel group n
	// Position of EN field.
	DPPIC_TASKS_CHG_EN_EN_Pos = 0x0
	// Bit mask of EN field.
	DPPIC_TASKS_CHG_EN_EN_Msk = 0x1
	// Bit EN.
	DPPIC_TASKS_CHG_EN_EN = 0x1
	// Trigger task
	DPPIC_TASKS_CHG_EN_EN_Trigger = 0x1

	// TASKS_CHG.DIS: Description cluster: Disable channel group n
	// Position of DIS field.
	DPPIC_TASKS_CHG_DIS_DIS_Pos = 0x0
	// Bit mask of DIS field.
	DPPIC_TASKS_CHG_DIS_DIS_Msk = 0x1
	// Bit DIS.
	DPPIC_TASKS_CHG_DIS_DIS = 0x1
	// Trigger task
	DPPIC_TASKS_CHG_DIS_DIS_Trigger = 0x1

	// SUBSCRIBE_CHG.EN: Description cluster: Subscribe configuration for task CHG[n].EN
	// Position of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_EN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_EN_CHIDX_Msk = 0xf
	// Position of EN field.
	DPPIC_SUBSCRIBE_CHG_EN_EN_Pos = 0x1f
	// Bit mask of EN field.
	DPPIC_SUBSCRIBE_CHG_EN_EN_Msk = 0x80000000
	// Bit EN.
	DPPIC_SUBSCRIBE_CHG_EN_EN = 0x80000000
	// Disable subscription
	DPPIC_SUBSCRIBE_CHG_EN_EN_Disabled = 0x0
	// Enable subscription
	DPPIC_SUBSCRIBE_CHG_EN_EN_Enabled = 0x1

	// SUBSCRIBE_CHG.DIS: Description cluster: Subscribe configuration for task CHG[n].DIS
	// Position of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_DIS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_DIS_CHIDX_Msk = 0xf
	// Position of EN field.
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Pos = 0x1f
	// Bit mask of EN field.
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Msk = 0x80000000
	// Bit EN.
	DPPIC_SUBSCRIBE_CHG_DIS_EN = 0x80000000
	// Disable subscription
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Disabled = 0x0
	// Enable subscription
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Enabled = 0x1

	// CHEN: Channel enable register
	// Position of CH0 field.
	DPPIC_CHEN_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHEN_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHEN_CH0 = 0x1
	// Disable channel
	DPPIC_CHEN_CH0_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH0_Enabled = 0x1
	// Position of CH1 field.
	DPPIC_CHEN_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHEN_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHEN_CH1 = 0x2
	// Disable channel
	DPPIC_CHEN_CH1_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH1_Enabled = 0x1
	// Position of CH2 field.
	DPPIC_CHEN_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHEN_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHEN_CH2 = 0x4
	// Disable channel
	DPPIC_CHEN_CH2_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH2_Enabled = 0x1
	// Position of CH3 field.
	DPPIC_CHEN_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHEN_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHEN_CH3 = 0x8
	// Disable channel
	DPPIC_CHEN_CH3_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH3_Enabled = 0x1
	// Position of CH4 field.
	DPPIC_CHEN_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHEN_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHEN_CH4 = 0x10
	// Disable channel
	DPPIC_CHEN_CH4_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH4_Enabled = 0x1
	// Position of CH5 field.
	DPPIC_CHEN_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHEN_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHEN_CH5 = 0x20
	// Disable channel
	DPPIC_CHEN_CH5_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH5_Enabled = 0x1
	// Position of CH6 field.
	DPPIC_CHEN_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHEN_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHEN_CH6 = 0x40
	// Disable channel
	DPPIC_CHEN_CH6_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH6_Enabled = 0x1
	// Position of CH7 field.
	DPPIC_CHEN_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHEN_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHEN_CH7 = 0x80
	// Disable channel
	DPPIC_CHEN_CH7_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH7_Enabled = 0x1
	// Position of CH8 field.
	DPPIC_CHEN_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHEN_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHEN_CH8 = 0x100
	// Disable channel
	DPPIC_CHEN_CH8_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH8_Enabled = 0x1
	// Position of CH9 field.
	DPPIC_CHEN_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHEN_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHEN_CH9 = 0x200
	// Disable channel
	DPPIC_CHEN_CH9_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH9_Enabled = 0x1
	// Position of CH10 field.
	DPPIC_CHEN_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHEN_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHEN_CH10 = 0x400
	// Disable channel
	DPPIC_CHEN_CH10_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH10_Enabled = 0x1
	// Position of CH11 field.
	DPPIC_CHEN_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHEN_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHEN_CH11 = 0x800
	// Disable channel
	DPPIC_CHEN_CH11_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH11_Enabled = 0x1
	// Position of CH12 field.
	DPPIC_CHEN_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHEN_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHEN_CH12 = 0x1000
	// Disable channel
	DPPIC_CHEN_CH12_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH12_Enabled = 0x1
	// Position of CH13 field.
	DPPIC_CHEN_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHEN_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHEN_CH13 = 0x2000
	// Disable channel
	DPPIC_CHEN_CH13_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH13_Enabled = 0x1
	// Position of CH14 field.
	DPPIC_CHEN_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHEN_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHEN_CH14 = 0x4000
	// Disable channel
	DPPIC_CHEN_CH14_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH14_Enabled = 0x1
	// Position of CH15 field.
	DPPIC_CHEN_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHEN_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHEN_CH15 = 0x8000
	// Disable channel
	DPPIC_CHEN_CH15_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH15_Enabled = 0x1

	// CHENSET: Channel enable set register
	// Position of CH0 field.
	DPPIC_CHENSET_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHENSET_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHENSET_CH0 = 0x1
	// Read: channel disabled
	DPPIC_CHENSET_CH0_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH0_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH0_Set = 0x1
	// Position of CH1 field.
	DPPIC_CHENSET_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHENSET_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHENSET_CH1 = 0x2
	// Read: channel disabled
	DPPIC_CHENSET_CH1_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH1_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH1_Set = 0x1
	// Position of CH2 field.
	DPPIC_CHENSET_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHENSET_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHENSET_CH2 = 0x4
	// Read: channel disabled
	DPPIC_CHENSET_CH2_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH2_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH2_Set = 0x1
	// Position of CH3 field.
	DPPIC_CHENSET_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHENSET_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHENSET_CH3 = 0x8
	// Read: channel disabled
	DPPIC_CHENSET_CH3_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH3_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH3_Set = 0x1
	// Position of CH4 field.
	DPPIC_CHENSET_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHENSET_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHENSET_CH4 = 0x10
	// Read: channel disabled
	DPPIC_CHENSET_CH4_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH4_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH4_Set = 0x1
	// Position of CH5 field.
	DPPIC_CHENSET_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHENSET_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHENSET_CH5 = 0x20
	// Read: channel disabled
	DPPIC_CHENSET_CH5_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH5_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH5_Set = 0x1
	// Position of CH6 field.
	DPPIC_CHENSET_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHENSET_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHENSET_CH6 = 0x40
	// Read: channel disabled
	DPPIC_CHENSET_CH6_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH6_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH6_Set = 0x1
	// Position of CH7 field.
	DPPIC_CHENSET_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHENSET_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHENSET_CH7 = 0x80
	// Read: channel disabled
	DPPIC_CHENSET_CH7_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH7_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH7_Set = 0x1
	// Position of CH8 field.
	DPPIC_CHENSET_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHENSET_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHENSET_CH8 = 0x100
	// Read: channel disabled
	DPPIC_CHENSET_CH8_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH8_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH8_Set = 0x1
	// Position of CH9 field.
	DPPIC_CHENSET_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHENSET_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHENSET_CH9 = 0x200
	// Read: channel disabled
	DPPIC_CHENSET_CH9_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH9_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH9_Set = 0x1
	// Position of CH10 field.
	DPPIC_CHENSET_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHENSET_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHENSET_CH10 = 0x400
	// Read: channel disabled
	DPPIC_CHENSET_CH10_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH10_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH10_Set = 0x1
	// Position of CH11 field.
	DPPIC_CHENSET_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHENSET_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHENSET_CH11 = 0x800
	// Read: channel disabled
	DPPIC_CHENSET_CH11_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH11_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH11_Set = 0x1
	// Position of CH12 field.
	DPPIC_CHENSET_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHENSET_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHENSET_CH12 = 0x1000
	// Read: channel disabled
	DPPIC_CHENSET_CH12_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH12_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH12_Set = 0x1
	// Position of CH13 field.
	DPPIC_CHENSET_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHENSET_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHENSET_CH13 = 0x2000
	// Read: channel disabled
	DPPIC_CHENSET_CH13_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH13_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH13_Set = 0x1
	// Position of CH14 field.
	DPPIC_CHENSET_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHENSET_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHENSET_CH14 = 0x4000
	// Read: channel disabled
	DPPIC_CHENSET_CH14_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH14_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH14_Set = 0x1
	// Position of CH15 field.
	DPPIC_CHENSET_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHENSET_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHENSET_CH15 = 0x8000
	// Read: channel disabled
	DPPIC_CHENSET_CH15_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENSET_CH15_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH15_Set = 0x1

	// CHENCLR: Channel enable clear register
	// Position of CH0 field.
	DPPIC_CHENCLR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHENCLR_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHENCLR_CH0 = 0x1
	// Read: channel disabled
	DPPIC_CHENCLR_CH0_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH0_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH0_Clear = 0x1
	// Position of CH1 field.
	DPPIC_CHENCLR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHENCLR_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHENCLR_CH1 = 0x2
	// Read: channel disabled
	DPPIC_CHENCLR_CH1_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH1_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH1_Clear = 0x1
	// Position of CH2 field.
	DPPIC_CHENCLR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHENCLR_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHENCLR_CH2 = 0x4
	// Read: channel disabled
	DPPIC_CHENCLR_CH2_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH2_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH2_Clear = 0x1
	// Position of CH3 field.
	DPPIC_CHENCLR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHENCLR_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHENCLR_CH3 = 0x8
	// Read: channel disabled
	DPPIC_CHENCLR_CH3_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH3_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH3_Clear = 0x1
	// Position of CH4 field.
	DPPIC_CHENCLR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHENCLR_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHENCLR_CH4 = 0x10
	// Read: channel disabled
	DPPIC_CHENCLR_CH4_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH4_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH4_Clear = 0x1
	// Position of CH5 field.
	DPPIC_CHENCLR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHENCLR_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHENCLR_CH5 = 0x20
	// Read: channel disabled
	DPPIC_CHENCLR_CH5_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH5_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH5_Clear = 0x1
	// Position of CH6 field.
	DPPIC_CHENCLR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHENCLR_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHENCLR_CH6 = 0x40
	// Read: channel disabled
	DPPIC_CHENCLR_CH6_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH6_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH6_Clear = 0x1
	// Position of CH7 field.
	DPPIC_CHENCLR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHENCLR_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHENCLR_CH7 = 0x80
	// Read: channel disabled
	DPPIC_CHENCLR_CH7_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH7_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH7_Clear = 0x1
	// Position of CH8 field.
	DPPIC_CHENCLR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHENCLR_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHENCLR_CH8 = 0x100
	// Read: channel disabled
	DPPIC_CHENCLR_CH8_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH8_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH8_Clear = 0x1
	// Position of CH9 field.
	DPPIC_CHENCLR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHENCLR_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHENCLR_CH9 = 0x200
	// Read: channel disabled
	DPPIC_CHENCLR_CH9_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH9_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH9_Clear = 0x1
	// Position of CH10 field.
	DPPIC_CHENCLR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHENCLR_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHENCLR_CH10 = 0x400
	// Read: channel disabled
	DPPIC_CHENCLR_CH10_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH10_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH10_Clear = 0x1
	// Position of CH11 field.
	DPPIC_CHENCLR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHENCLR_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHENCLR_CH11 = 0x800
	// Read: channel disabled
	DPPIC_CHENCLR_CH11_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH11_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH11_Clear = 0x1
	// Position of CH12 field.
	DPPIC_CHENCLR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHENCLR_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHENCLR_CH12 = 0x1000
	// Read: channel disabled
	DPPIC_CHENCLR_CH12_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH12_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH12_Clear = 0x1
	// Position of CH13 field.
	DPPIC_CHENCLR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHENCLR_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHENCLR_CH13 = 0x2000
	// Read: channel disabled
	DPPIC_CHENCLR_CH13_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH13_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH13_Clear = 0x1
	// Position of CH14 field.
	DPPIC_CHENCLR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHENCLR_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHENCLR_CH14 = 0x4000
	// Read: channel disabled
	DPPIC_CHENCLR_CH14_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH14_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH14_Clear = 0x1
	// Position of CH15 field.
	DPPIC_CHENCLR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHENCLR_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHENCLR_CH15 = 0x8000
	// Read: channel disabled
	DPPIC_CHENCLR_CH15_Disabled = 0x0
	// Read: channel enabled
	DPPIC_CHENCLR_CH15_Enabled = 0x1
	// Write: disable channel
	DPPIC_CHENCLR_CH15_Clear = 0x1

	// CHG: Description collection: Channel group n Note: Writes to this register is ignored if either SUBSCRIBE_CHG[n].EN/DIS are enabled.
	// Position of CH0 field.
	DPPIC_CHG_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHG_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHG_CH0 = 0x1
	// Exclude
	DPPIC_CHG_CH0_Excluded = 0x0
	// Include
	DPPIC_CHG_CH0_Included = 0x1
	// Position of CH1 field.
	DPPIC_CHG_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHG_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHG_CH1 = 0x2
	// Exclude
	DPPIC_CHG_CH1_Excluded = 0x0
	// Include
	DPPIC_CHG_CH1_Included = 0x1
	// Position of CH2 field.
	DPPIC_CHG_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHG_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHG_CH2 = 0x4
	// Exclude
	DPPIC_CHG_CH2_Excluded = 0x0
	// Include
	DPPIC_CHG_CH2_Included = 0x1
	// Position of CH3 field.
	DPPIC_CHG_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHG_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHG_CH3 = 0x8
	// Exclude
	DPPIC_CHG_CH3_Excluded = 0x0
	// Include
	DPPIC_CHG_CH3_Included = 0x1
	// Position of CH4 field.
	DPPIC_CHG_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHG_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHG_CH4 = 0x10
	// Exclude
	DPPIC_CHG_CH4_Excluded = 0x0
	// Include
	DPPIC_CHG_CH4_Included = 0x1
	// Position of CH5 field.
	DPPIC_CHG_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHG_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHG_CH5 = 0x20
	// Exclude
	DPPIC_CHG_CH5_Excluded = 0x0
	// Include
	DPPIC_CHG_CH5_Included = 0x1
	// Position of CH6 field.
	DPPIC_CHG_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHG_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHG_CH6 = 0x40
	// Exclude
	DPPIC_CHG_CH6_Excluded = 0x0
	// Include
	DPPIC_CHG_CH6_Included = 0x1
	// Position of CH7 field.
	DPPIC_CHG_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHG_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHG_CH7 = 0x80
	// Exclude
	DPPIC_CHG_CH7_Excluded = 0x0
	// Include
	DPPIC_CHG_CH7_Included = 0x1
	// Position of CH8 field.
	DPPIC_CHG_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHG_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHG_CH8 = 0x100
	// Exclude
	DPPIC_CHG_CH8_Excluded = 0x0
	// Include
	DPPIC_CHG_CH8_Included = 0x1
	// Position of CH9 field.
	DPPIC_CHG_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHG_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHG_CH9 = 0x200
	// Exclude
	DPPIC_CHG_CH9_Excluded = 0x0
	// Include
	DPPIC_CHG_CH9_Included = 0x1
	// Position of CH10 field.
	DPPIC_CHG_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHG_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHG_CH10 = 0x400
	// Exclude
	DPPIC_CHG_CH10_Excluded = 0x0
	// Include
	DPPIC_CHG_CH10_Included = 0x1
	// Position of CH11 field.
	DPPIC_CHG_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHG_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHG_CH11 = 0x800
	// Exclude
	DPPIC_CHG_CH11_Excluded = 0x0
	// Include
	DPPIC_CHG_CH11_Included = 0x1
	// Position of CH12 field.
	DPPIC_CHG_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHG_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHG_CH12 = 0x1000
	// Exclude
	DPPIC_CHG_CH12_Excluded = 0x0
	// Include
	DPPIC_CHG_CH12_Included = 0x1
	// Position of CH13 field.
	DPPIC_CHG_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHG_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHG_CH13 = 0x2000
	// Exclude
	DPPIC_CHG_CH13_Excluded = 0x0
	// Include
	DPPIC_CHG_CH13_Included = 0x1
	// Position of CH14 field.
	DPPIC_CHG_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHG_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHG_CH14 = 0x4000
	// Exclude
	DPPIC_CHG_CH14_Excluded = 0x0
	// Include
	DPPIC_CHG_CH14_Included = 0x1
	// Position of CH15 field.
	DPPIC_CHG_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHG_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHG_CH15 = 0x8000
	// Exclude
	DPPIC_CHG_CH15_Excluded = 0x0
	// Include
	DPPIC_CHG_CH15_Included = 0x1
)

// Constants for WDT_NS: Watchdog Timer 0
const (
	// TASKS_START: Start the watchdog
	// Position of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	WDT_TASKS_START_TASKS_START = 0x1
	// Trigger task
	WDT_TASKS_START_TASKS_START_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	WDT_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	WDT_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	WDT_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	WDT_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	WDT_SUBSCRIBE_START_EN_Enabled = 0x1

	// EVENTS_TIMEOUT: Watchdog timeout
	// Position of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Pos = 0x0
	// Bit mask of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Msk = 0x1
	// Bit EVENTS_TIMEOUT.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT = 0x1
	// Event not generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_NotGenerated = 0x0
	// Event generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Generated = 0x1

	// PUBLISH_TIMEOUT: Publish configuration for event TIMEOUT
	// Position of CHIDX field.
	WDT_PUBLISH_TIMEOUT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_PUBLISH_TIMEOUT_CHIDX_Msk = 0xf
	// Position of EN field.
	WDT_PUBLISH_TIMEOUT_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_PUBLISH_TIMEOUT_EN_Msk = 0x80000000
	// Bit EN.
	WDT_PUBLISH_TIMEOUT_EN = 0x80000000
	// Disable publishing
	WDT_PUBLISH_TIMEOUT_EN_Disabled = 0x0
	// Enable publishing
	WDT_PUBLISH_TIMEOUT_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENSET_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENSET_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENSET_TIMEOUT_Enabled = 0x1
	// Enable
	WDT_INTENSET_TIMEOUT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENCLR_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENCLR_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENCLR_TIMEOUT_Enabled = 0x1
	// Disable
	WDT_INTENCLR_TIMEOUT_Clear = 0x1

	// RUNSTATUS: Run status
	// Position of RUNSTATUSWDT field.
	WDT_RUNSTATUS_RUNSTATUSWDT_Pos = 0x0
	// Bit mask of RUNSTATUSWDT field.
	WDT_RUNSTATUS_RUNSTATUSWDT_Msk = 0x1
	// Bit RUNSTATUSWDT.
	WDT_RUNSTATUS_RUNSTATUSWDT = 0x1
	// Watchdog not running
	WDT_RUNSTATUS_RUNSTATUSWDT_NotRunning = 0x0
	// Watchdog is running
	WDT_RUNSTATUS_RUNSTATUSWDT_Running = 0x1

	// REQSTATUS: Request status
	// Position of RR0 field.
	WDT_REQSTATUS_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_REQSTATUS_RR0_Msk = 0x1
	// Bit RR0.
	WDT_REQSTATUS_RR0 = 0x1
	// RR[0] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR0_DisabledOrRequested = 0x0
	// RR[0] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR0_EnabledAndUnrequested = 0x1
	// Position of RR1 field.
	WDT_REQSTATUS_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_REQSTATUS_RR1_Msk = 0x2
	// Bit RR1.
	WDT_REQSTATUS_RR1 = 0x2
	// RR[1] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR1_DisabledOrRequested = 0x0
	// RR[1] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR1_EnabledAndUnrequested = 0x1
	// Position of RR2 field.
	WDT_REQSTATUS_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_REQSTATUS_RR2_Msk = 0x4
	// Bit RR2.
	WDT_REQSTATUS_RR2 = 0x4
	// RR[2] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR2_DisabledOrRequested = 0x0
	// RR[2] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR2_EnabledAndUnrequested = 0x1
	// Position of RR3 field.
	WDT_REQSTATUS_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_REQSTATUS_RR3_Msk = 0x8
	// Bit RR3.
	WDT_REQSTATUS_RR3 = 0x8
	// RR[3] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR3_DisabledOrRequested = 0x0
	// RR[3] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR3_EnabledAndUnrequested = 0x1
	// Position of RR4 field.
	WDT_REQSTATUS_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_REQSTATUS_RR4_Msk = 0x10
	// Bit RR4.
	WDT_REQSTATUS_RR4 = 0x10
	// RR[4] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR4_DisabledOrRequested = 0x0
	// RR[4] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR4_EnabledAndUnrequested = 0x1
	// Position of RR5 field.
	WDT_REQSTATUS_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_REQSTATUS_RR5_Msk = 0x20
	// Bit RR5.
	WDT_REQSTATUS_RR5 = 0x20
	// RR[5] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR5_DisabledOrRequested = 0x0
	// RR[5] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR5_EnabledAndUnrequested = 0x1
	// Position of RR6 field.
	WDT_REQSTATUS_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_REQSTATUS_RR6_Msk = 0x40
	// Bit RR6.
	WDT_REQSTATUS_RR6 = 0x40
	// RR[6] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR6_DisabledOrRequested = 0x0
	// RR[6] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR6_EnabledAndUnrequested = 0x1
	// Position of RR7 field.
	WDT_REQSTATUS_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_REQSTATUS_RR7_Msk = 0x80
	// Bit RR7.
	WDT_REQSTATUS_RR7 = 0x80
	// RR[7] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR7_DisabledOrRequested = 0x0
	// RR[7] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR7_EnabledAndUnrequested = 0x1

	// CRV: Counter reload value
	// Position of CRV field.
	WDT_CRV_CRV_Pos = 0x0
	// Bit mask of CRV field.
	WDT_CRV_CRV_Msk = 0xffffffff

	// RREN: Enable register for reload request registers
	// Position of RR0 field.
	WDT_RREN_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_RREN_RR0_Msk = 0x1
	// Bit RR0.
	WDT_RREN_RR0 = 0x1
	// Disable RR[0] register
	WDT_RREN_RR0_Disabled = 0x0
	// Enable RR[0] register
	WDT_RREN_RR0_Enabled = 0x1
	// Position of RR1 field.
	WDT_RREN_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_RREN_RR1_Msk = 0x2
	// Bit RR1.
	WDT_RREN_RR1 = 0x2
	// Disable RR[1] register
	WDT_RREN_RR1_Disabled = 0x0
	// Enable RR[1] register
	WDT_RREN_RR1_Enabled = 0x1
	// Position of RR2 field.
	WDT_RREN_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_RREN_RR2_Msk = 0x4
	// Bit RR2.
	WDT_RREN_RR2 = 0x4
	// Disable RR[2] register
	WDT_RREN_RR2_Disabled = 0x0
	// Enable RR[2] register
	WDT_RREN_RR2_Enabled = 0x1
	// Position of RR3 field.
	WDT_RREN_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_RREN_RR3_Msk = 0x8
	// Bit RR3.
	WDT_RREN_RR3 = 0x8
	// Disable RR[3] register
	WDT_RREN_RR3_Disabled = 0x0
	// Enable RR[3] register
	WDT_RREN_RR3_Enabled = 0x1
	// Position of RR4 field.
	WDT_RREN_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_RREN_RR4_Msk = 0x10
	// Bit RR4.
	WDT_RREN_RR4 = 0x10
	// Disable RR[4] register
	WDT_RREN_RR4_Disabled = 0x0
	// Enable RR[4] register
	WDT_RREN_RR4_Enabled = 0x1
	// Position of RR5 field.
	WDT_RREN_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_RREN_RR5_Msk = 0x20
	// Bit RR5.
	WDT_RREN_RR5 = 0x20
	// Disable RR[5] register
	WDT_RREN_RR5_Disabled = 0x0
	// Enable RR[5] register
	WDT_RREN_RR5_Enabled = 0x1
	// Position of RR6 field.
	WDT_RREN_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_RREN_RR6_Msk = 0x40
	// Bit RR6.
	WDT_RREN_RR6 = 0x40
	// Disable RR[6] register
	WDT_RREN_RR6_Disabled = 0x0
	// Enable RR[6] register
	WDT_RREN_RR6_Enabled = 0x1
	// Position of RR7 field.
	WDT_RREN_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_RREN_RR7_Msk = 0x80
	// Bit RR7.
	WDT_RREN_RR7 = 0x80
	// Disable RR[7] register
	WDT_RREN_RR7_Disabled = 0x0
	// Enable RR[7] register
	WDT_RREN_RR7_Enabled = 0x1

	// CONFIG: Configuration register
	// Position of SLEEP field.
	WDT_CONFIG_SLEEP_Pos = 0x0
	// Bit mask of SLEEP field.
	WDT_CONFIG_SLEEP_Msk = 0x1
	// Bit SLEEP.
	WDT_CONFIG_SLEEP = 0x1
	// Pause watchdog while the CPU is sleeping
	WDT_CONFIG_SLEEP_Pause = 0x0
	// Keep the watchdog running while the CPU is sleeping
	WDT_CONFIG_SLEEP_Run = 0x1
	// Position of HALT field.
	WDT_CONFIG_HALT_Pos = 0x3
	// Bit mask of HALT field.
	WDT_CONFIG_HALT_Msk = 0x8
	// Bit HALT.
	WDT_CONFIG_HALT = 0x8
	// Pause watchdog while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Pause = 0x0
	// Keep the watchdog running while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Run = 0x1

	// RR: Description collection: Reload request n
	// Position of RR field.
	WDT_RR_RR_Pos = 0x0
	// Bit mask of RR field.
	WDT_RR_RR_Msk = 0xffffffff
	// Value to request a reload of the watchdog timer
	WDT_RR_RR_Reload = 0x6e524635
)

// Constants for EGU0_NS: Event generator unit 0
const (
	// TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
	// Position of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Pos = 0x0
	// Bit mask of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Msk = 0x1
	// Bit TASKS_TRIGGER.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER = 0x1
	// Trigger task
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Trigger = 0x1

	// SUBSCRIBE_TRIGGER: Description collection: Subscribe configuration for task TRIGGER[n]
	// Position of CHIDX field.
	EGU_SUBSCRIBE_TRIGGER_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	EGU_SUBSCRIBE_TRIGGER_CHIDX_Msk = 0xf
	// Position of EN field.
	EGU_SUBSCRIBE_TRIGGER_EN_Pos = 0x1f
	// Bit mask of EN field.
	EGU_SUBSCRIBE_TRIGGER_EN_Msk = 0x80000000
	// Bit EN.
	EGU_SUBSCRIBE_TRIGGER_EN = 0x80000000
	// Disable subscription
	EGU_SUBSCRIBE_TRIGGER_EN_Disabled = 0x0
	// Enable subscription
	EGU_SUBSCRIBE_TRIGGER_EN_Enabled = 0x1

	// EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
	// Position of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Pos = 0x0
	// Bit mask of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Msk = 0x1
	// Bit EVENTS_TRIGGERED.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED = 0x1
	// Event not generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_NotGenerated = 0x0
	// Event generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Generated = 0x1

	// PUBLISH_TRIGGERED: Description collection: Publish configuration for event TRIGGERED[n]
	// Position of CHIDX field.
	EGU_PUBLISH_TRIGGERED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	EGU_PUBLISH_TRIGGERED_CHIDX_Msk = 0xf
	// Position of EN field.
	EGU_PUBLISH_TRIGGERED_EN_Pos = 0x1f
	// Bit mask of EN field.
	EGU_PUBLISH_TRIGGERED_EN_Msk = 0x80000000
	// Bit EN.
	EGU_PUBLISH_TRIGGERED_EN = 0x80000000
	// Disable publishing
	EGU_PUBLISH_TRIGGERED_EN_Disabled = 0x0
	// Enable publishing
	EGU_PUBLISH_TRIGGERED_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTEN_TRIGGERED0 = 0x1
	// Disable
	EGU_INTEN_TRIGGERED0_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED0_Enabled = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTEN_TRIGGERED1 = 0x2
	// Disable
	EGU_INTEN_TRIGGERED1_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED1_Enabled = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTEN_TRIGGERED2 = 0x4
	// Disable
	EGU_INTEN_TRIGGERED2_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED2_Enabled = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTEN_TRIGGERED3 = 0x8
	// Disable
	EGU_INTEN_TRIGGERED3_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED3_Enabled = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTEN_TRIGGERED4 = 0x10
	// Disable
	EGU_INTEN_TRIGGERED4_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED4_Enabled = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTEN_TRIGGERED5 = 0x20
	// Disable
	EGU_INTEN_TRIGGERED5_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED5_Enabled = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTEN_TRIGGERED6 = 0x40
	// Disable
	EGU_INTEN_TRIGGERED6_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED6_Enabled = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTEN_TRIGGERED7 = 0x80
	// Disable
	EGU_INTEN_TRIGGERED7_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED7_Enabled = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTEN_TRIGGERED8 = 0x100
	// Disable
	EGU_INTEN_TRIGGERED8_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED8_Enabled = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTEN_TRIGGERED9 = 0x200
	// Disable
	EGU_INTEN_TRIGGERED9_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED9_Enabled = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTEN_TRIGGERED10 = 0x400
	// Disable
	EGU_INTEN_TRIGGERED10_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED10_Enabled = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTEN_TRIGGERED11 = 0x800
	// Disable
	EGU_INTEN_TRIGGERED11_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED11_Enabled = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTEN_TRIGGERED12 = 0x1000
	// Disable
	EGU_INTEN_TRIGGERED12_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED12_Enabled = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTEN_TRIGGERED13 = 0x2000
	// Disable
	EGU_INTEN_TRIGGERED13_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED13_Enabled = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTEN_TRIGGERED14 = 0x4000
	// Disable
	EGU_INTEN_TRIGGERED14_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED14_Enabled = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTEN_TRIGGERED15 = 0x8000
	// Disable
	EGU_INTEN_TRIGGERED15_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED15_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENSET_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENSET_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED0_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED0_Set = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENSET_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENSET_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED1_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED1_Set = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENSET_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENSET_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED2_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED2_Set = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENSET_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENSET_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED3_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED3_Set = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENSET_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENSET_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED4_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED4_Set = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENSET_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENSET_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED5_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED5_Set = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENSET_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENSET_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED6_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED6_Set = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENSET_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENSET_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED7_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED7_Set = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENSET_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENSET_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED8_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED8_Set = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENSET_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENSET_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED9_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED9_Set = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENSET_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENSET_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED10_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED10_Set = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENSET_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENSET_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED11_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED11_Set = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENSET_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED12_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED12_Set = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENSET_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED13_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED13_Set = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENSET_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED14_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED14_Set = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENSET_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED15_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED15_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENCLR_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED0_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED0_Clear = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENCLR_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED1_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED1_Clear = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENCLR_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED2_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED2_Clear = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENCLR_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED3_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED3_Clear = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENCLR_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED4_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED4_Clear = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENCLR_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED5_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED5_Clear = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENCLR_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED6_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED6_Clear = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENCLR_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED7_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED7_Clear = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENCLR_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED8_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED8_Clear = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENCLR_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED9_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED9_Clear = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENCLR_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED10_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED10_Clear = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENCLR_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED11_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED11_Clear = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENCLR_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED12_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED12_Clear = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENCLR_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED13_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED13_Clear = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENCLR_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED14_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED14_Clear = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENCLR_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED15_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED15_Clear = 0x1
)

// Constants for PWM0_NS: Pulse width modulation unit 0
const (
	// TASKS_STOP: Stops PWM pulse generation on all channels at the end of current PWM period, and stops sequence playback
	// Position of TASKS_STOP field.
	PWM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	PWM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	PWM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	PWM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SEQSTART: Description collection: Loads the first PWM value on all enabled channels from sequence n, and starts playing that sequence at the rate defined in SEQ[n]REFRESH and/or DECODER.MODE. Causes PWM generation to start if not running.
	// Position of TASKS_SEQSTART field.
	PWM_TASKS_SEQSTART_TASKS_SEQSTART_Pos = 0x0
	// Bit mask of TASKS_SEQSTART field.
	PWM_TASKS_SEQSTART_TASKS_SEQSTART_Msk = 0x1
	// Bit TASKS_SEQSTART.
	PWM_TASKS_SEQSTART_TASKS_SEQSTART = 0x1
	// Trigger task
	PWM_TASKS_SEQSTART_TASKS_SEQSTART_Trigger = 0x1

	// TASKS_NEXTSTEP: Steps by one value in the current sequence on all enabled channels if DECODER.MODE=NextStep. Does not cause PWM generation to start if not running.
	// Position of TASKS_NEXTSTEP field.
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP_Pos = 0x0
	// Bit mask of TASKS_NEXTSTEP field.
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP_Msk = 0x1
	// Bit TASKS_NEXTSTEP.
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP = 0x1
	// Trigger task
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP_Trigger = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	PWM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	PWM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	PWM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	PWM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SEQSTART: Description collection: Subscribe configuration for task SEQSTART[n]
	// Position of CHIDX field.
	PWM_SUBSCRIBE_SEQSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_SUBSCRIBE_SEQSTART_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_SUBSCRIBE_SEQSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_SUBSCRIBE_SEQSTART_EN_Msk = 0x80000000
	// Bit EN.
	PWM_SUBSCRIBE_SEQSTART_EN = 0x80000000
	// Disable subscription
	PWM_SUBSCRIBE_SEQSTART_EN_Disabled = 0x0
	// Enable subscription
	PWM_SUBSCRIBE_SEQSTART_EN_Enabled = 0x1

	// SUBSCRIBE_NEXTSTEP: Subscribe configuration for task NEXTSTEP
	// Position of CHIDX field.
	PWM_SUBSCRIBE_NEXTSTEP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_SUBSCRIBE_NEXTSTEP_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_SUBSCRIBE_NEXTSTEP_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_SUBSCRIBE_NEXTSTEP_EN_Msk = 0x80000000
	// Bit EN.
	PWM_SUBSCRIBE_NEXTSTEP_EN = 0x80000000
	// Disable subscription
	PWM_SUBSCRIBE_NEXTSTEP_EN_Disabled = 0x0
	// Enable subscription
	PWM_SUBSCRIBE_NEXTSTEP_EN_Enabled = 0x1

	// EVENTS_STOPPED: Response to STOP task, emitted when PWM pulses are no longer generated
	// Position of EVENTS_STOPPED field.
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	PWM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_SEQSTARTED: Description collection: First PWM period started on sequence n
	// Position of EVENTS_SEQSTARTED field.
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_Pos = 0x0
	// Bit mask of EVENTS_SEQSTARTED field.
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_Msk = 0x1
	// Bit EVENTS_SEQSTARTED.
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED = 0x1
	// Event not generated
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_Generated = 0x1

	// EVENTS_SEQEND: Description collection: Emitted at end of every sequence n, when last value from RAM has been applied to wave counter
	// Position of EVENTS_SEQEND field.
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_Pos = 0x0
	// Bit mask of EVENTS_SEQEND field.
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_Msk = 0x1
	// Bit EVENTS_SEQEND.
	PWM_EVENTS_SEQEND_EVENTS_SEQEND = 0x1
	// Event not generated
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_Generated = 0x1

	// EVENTS_PWMPERIODEND: Emitted at the end of each PWM period
	// Position of EVENTS_PWMPERIODEND field.
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_Pos = 0x0
	// Bit mask of EVENTS_PWMPERIODEND field.
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_Msk = 0x1
	// Bit EVENTS_PWMPERIODEND.
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND = 0x1
	// Event not generated
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_Generated = 0x1

	// EVENTS_LOOPSDONE: Concatenated sequences have been played the amount of times defined in LOOP.CNT
	// Position of EVENTS_LOOPSDONE field.
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_Pos = 0x0
	// Bit mask of EVENTS_LOOPSDONE field.
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_Msk = 0x1
	// Bit EVENTS_LOOPSDONE.
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE = 0x1
	// Event not generated
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	PWM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	PWM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	PWM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	PWM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_SEQSTARTED: Description collection: Publish configuration for event SEQSTARTED[n]
	// Position of CHIDX field.
	PWM_PUBLISH_SEQSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_PUBLISH_SEQSTARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_PUBLISH_SEQSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_PUBLISH_SEQSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	PWM_PUBLISH_SEQSTARTED_EN = 0x80000000
	// Disable publishing
	PWM_PUBLISH_SEQSTARTED_EN_Disabled = 0x0
	// Enable publishing
	PWM_PUBLISH_SEQSTARTED_EN_Enabled = 0x1

	// PUBLISH_SEQEND: Description collection: Publish configuration for event SEQEND[n]
	// Position of CHIDX field.
	PWM_PUBLISH_SEQEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_PUBLISH_SEQEND_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_PUBLISH_SEQEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_PUBLISH_SEQEND_EN_Msk = 0x80000000
	// Bit EN.
	PWM_PUBLISH_SEQEND_EN = 0x80000000
	// Disable publishing
	PWM_PUBLISH_SEQEND_EN_Disabled = 0x0
	// Enable publishing
	PWM_PUBLISH_SEQEND_EN_Enabled = 0x1

	// PUBLISH_PWMPERIODEND: Publish configuration for event PWMPERIODEND
	// Position of CHIDX field.
	PWM_PUBLISH_PWMPERIODEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_PUBLISH_PWMPERIODEND_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_PUBLISH_PWMPERIODEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_PUBLISH_PWMPERIODEND_EN_Msk = 0x80000000
	// Bit EN.
	PWM_PUBLISH_PWMPERIODEND_EN = 0x80000000
	// Disable publishing
	PWM_PUBLISH_PWMPERIODEND_EN_Disabled = 0x0
	// Enable publishing
	PWM_PUBLISH_PWMPERIODEND_EN_Enabled = 0x1

	// PUBLISH_LOOPSDONE: Publish configuration for event LOOPSDONE
	// Position of CHIDX field.
	PWM_PUBLISH_LOOPSDONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PWM_PUBLISH_LOOPSDONE_CHIDX_Msk = 0xf
	// Position of EN field.
	PWM_PUBLISH_LOOPSDONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	PWM_PUBLISH_LOOPSDONE_EN_Msk = 0x80000000
	// Bit EN.
	PWM_PUBLISH_LOOPSDONE_EN = 0x80000000
	// Disable publishing
	PWM_PUBLISH_LOOPSDONE_EN_Disabled = 0x0
	// Enable publishing
	PWM_PUBLISH_LOOPSDONE_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of SEQEND0_STOP field.
	PWM_SHORTS_SEQEND0_STOP_Pos = 0x0
	// Bit mask of SEQEND0_STOP field.
	PWM_SHORTS_SEQEND0_STOP_Msk = 0x1
	// Bit SEQEND0_STOP.
	PWM_SHORTS_SEQEND0_STOP = 0x1
	// Disable shortcut
	PWM_SHORTS_SEQEND0_STOP_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_SEQEND0_STOP_Enabled = 0x1
	// Position of SEQEND1_STOP field.
	PWM_SHORTS_SEQEND1_STOP_Pos = 0x1
	// Bit mask of SEQEND1_STOP field.
	PWM_SHORTS_SEQEND1_STOP_Msk = 0x2
	// Bit SEQEND1_STOP.
	PWM_SHORTS_SEQEND1_STOP = 0x2
	// Disable shortcut
	PWM_SHORTS_SEQEND1_STOP_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_SEQEND1_STOP_Enabled = 0x1
	// Position of LOOPSDONE_SEQSTART0 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Pos = 0x2
	// Bit mask of LOOPSDONE_SEQSTART0 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Msk = 0x4
	// Bit LOOPSDONE_SEQSTART0.
	PWM_SHORTS_LOOPSDONE_SEQSTART0 = 0x4
	// Disable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Enabled = 0x1
	// Position of LOOPSDONE_SEQSTART1 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Pos = 0x3
	// Bit mask of LOOPSDONE_SEQSTART1 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Msk = 0x8
	// Bit LOOPSDONE_SEQSTART1.
	PWM_SHORTS_LOOPSDONE_SEQSTART1 = 0x8
	// Disable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Enabled = 0x1
	// Position of LOOPSDONE_STOP field.
	PWM_SHORTS_LOOPSDONE_STOP_Pos = 0x4
	// Bit mask of LOOPSDONE_STOP field.
	PWM_SHORTS_LOOPSDONE_STOP_Msk = 0x10
	// Bit LOOPSDONE_STOP.
	PWM_SHORTS_LOOPSDONE_STOP = 0x10
	// Disable shortcut
	PWM_SHORTS_LOOPSDONE_STOP_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_LOOPSDONE_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	PWM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PWM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PWM_INTEN_STOPPED = 0x2
	// Disable
	PWM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	PWM_INTEN_STOPPED_Enabled = 0x1
	// Position of SEQSTARTED0 field.
	PWM_INTEN_SEQSTARTED0_Pos = 0x2
	// Bit mask of SEQSTARTED0 field.
	PWM_INTEN_SEQSTARTED0_Msk = 0x4
	// Bit SEQSTARTED0.
	PWM_INTEN_SEQSTARTED0 = 0x4
	// Disable
	PWM_INTEN_SEQSTARTED0_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQSTARTED0_Enabled = 0x1
	// Position of SEQSTARTED1 field.
	PWM_INTEN_SEQSTARTED1_Pos = 0x3
	// Bit mask of SEQSTARTED1 field.
	PWM_INTEN_SEQSTARTED1_Msk = 0x8
	// Bit SEQSTARTED1.
	PWM_INTEN_SEQSTARTED1 = 0x8
	// Disable
	PWM_INTEN_SEQSTARTED1_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQSTARTED1_Enabled = 0x1
	// Position of SEQEND0 field.
	PWM_INTEN_SEQEND0_Pos = 0x4
	// Bit mask of SEQEND0 field.
	PWM_INTEN_SEQEND0_Msk = 0x10
	// Bit SEQEND0.
	PWM_INTEN_SEQEND0 = 0x10
	// Disable
	PWM_INTEN_SEQEND0_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQEND0_Enabled = 0x1
	// Position of SEQEND1 field.
	PWM_INTEN_SEQEND1_Pos = 0x5
	// Bit mask of SEQEND1 field.
	PWM_INTEN_SEQEND1_Msk = 0x20
	// Bit SEQEND1.
	PWM_INTEN_SEQEND1 = 0x20
	// Disable
	PWM_INTEN_SEQEND1_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQEND1_Enabled = 0x1
	// Position of PWMPERIODEND field.
	PWM_INTEN_PWMPERIODEND_Pos = 0x6
	// Bit mask of PWMPERIODEND field.
	PWM_INTEN_PWMPERIODEND_Msk = 0x40
	// Bit PWMPERIODEND.
	PWM_INTEN_PWMPERIODEND = 0x40
	// Disable
	PWM_INTEN_PWMPERIODEND_Disabled = 0x0
	// Enable
	PWM_INTEN_PWMPERIODEND_Enabled = 0x1
	// Position of LOOPSDONE field.
	PWM_INTEN_LOOPSDONE_Pos = 0x7
	// Bit mask of LOOPSDONE field.
	PWM_INTEN_LOOPSDONE_Msk = 0x80
	// Bit LOOPSDONE.
	PWM_INTEN_LOOPSDONE = 0x80
	// Disable
	PWM_INTEN_LOOPSDONE_Disabled = 0x0
	// Enable
	PWM_INTEN_LOOPSDONE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	PWM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PWM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PWM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	PWM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	PWM_INTENSET_STOPPED_Set = 0x1
	// Position of SEQSTARTED0 field.
	PWM_INTENSET_SEQSTARTED0_Pos = 0x2
	// Bit mask of SEQSTARTED0 field.
	PWM_INTENSET_SEQSTARTED0_Msk = 0x4
	// Bit SEQSTARTED0.
	PWM_INTENSET_SEQSTARTED0 = 0x4
	// Read: Disabled
	PWM_INTENSET_SEQSTARTED0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQSTARTED0_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQSTARTED0_Set = 0x1
	// Position of SEQSTARTED1 field.
	PWM_INTENSET_SEQSTARTED1_Pos = 0x3
	// Bit mask of SEQSTARTED1 field.
	PWM_INTENSET_SEQSTARTED1_Msk = 0x8
	// Bit SEQSTARTED1.
	PWM_INTENSET_SEQSTARTED1 = 0x8
	// Read: Disabled
	PWM_INTENSET_SEQSTARTED1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQSTARTED1_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQSTARTED1_Set = 0x1
	// Position of SEQEND0 field.
	PWM_INTENSET_SEQEND0_Pos = 0x4
	// Bit mask of SEQEND0 field.
	PWM_INTENSET_SEQEND0_Msk = 0x10
	// Bit SEQEND0.
	PWM_INTENSET_SEQEND0 = 0x10
	// Read: Disabled
	PWM_INTENSET_SEQEND0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQEND0_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQEND0_Set = 0x1
	// Position of SEQEND1 field.
	PWM_INTENSET_SEQEND1_Pos = 0x5
	// Bit mask of SEQEND1 field.
	PWM_INTENSET_SEQEND1_Msk = 0x20
	// Bit SEQEND1.
	PWM_INTENSET_SEQEND1 = 0x20
	// Read: Disabled
	PWM_INTENSET_SEQEND1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQEND1_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQEND1_Set = 0x1
	// Position of PWMPERIODEND field.
	PWM_INTENSET_PWMPERIODEND_Pos = 0x6
	// Bit mask of PWMPERIODEND field.
	PWM_INTENSET_PWMPERIODEND_Msk = 0x40
	// Bit PWMPERIODEND.
	PWM_INTENSET_PWMPERIODEND = 0x40
	// Read: Disabled
	PWM_INTENSET_PWMPERIODEND_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_PWMPERIODEND_Enabled = 0x1
	// Enable
	PWM_INTENSET_PWMPERIODEND_Set = 0x1
	// Position of LOOPSDONE field.
	PWM_INTENSET_LOOPSDONE_Pos = 0x7
	// Bit mask of LOOPSDONE field.
	PWM_INTENSET_LOOPSDONE_Msk = 0x80
	// Bit LOOPSDONE.
	PWM_INTENSET_LOOPSDONE = 0x80
	// Read: Disabled
	PWM_INTENSET_LOOPSDONE_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_LOOPSDONE_Enabled = 0x1
	// Enable
	PWM_INTENSET_LOOPSDONE_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	PWM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PWM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PWM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	PWM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	PWM_INTENCLR_STOPPED_Clear = 0x1
	// Position of SEQSTARTED0 field.
	PWM_INTENCLR_SEQSTARTED0_Pos = 0x2
	// Bit mask of SEQSTARTED0 field.
	PWM_INTENCLR_SEQSTARTED0_Msk = 0x4
	// Bit SEQSTARTED0.
	PWM_INTENCLR_SEQSTARTED0 = 0x4
	// Read: Disabled
	PWM_INTENCLR_SEQSTARTED0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQSTARTED0_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQSTARTED0_Clear = 0x1
	// Position of SEQSTARTED1 field.
	PWM_INTENCLR_SEQSTARTED1_Pos = 0x3
	// Bit mask of SEQSTARTED1 field.
	PWM_INTENCLR_SEQSTARTED1_Msk = 0x8
	// Bit SEQSTARTED1.
	PWM_INTENCLR_SEQSTARTED1 = 0x8
	// Read: Disabled
	PWM_INTENCLR_SEQSTARTED1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQSTARTED1_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQSTARTED1_Clear = 0x1
	// Position of SEQEND0 field.
	PWM_INTENCLR_SEQEND0_Pos = 0x4
	// Bit mask of SEQEND0 field.
	PWM_INTENCLR_SEQEND0_Msk = 0x10
	// Bit SEQEND0.
	PWM_INTENCLR_SEQEND0 = 0x10
	// Read: Disabled
	PWM_INTENCLR_SEQEND0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQEND0_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQEND0_Clear = 0x1
	// Position of SEQEND1 field.
	PWM_INTENCLR_SEQEND1_Pos = 0x5
	// Bit mask of SEQEND1 field.
	PWM_INTENCLR_SEQEND1_Msk = 0x20
	// Bit SEQEND1.
	PWM_INTENCLR_SEQEND1 = 0x20
	// Read: Disabled
	PWM_INTENCLR_SEQEND1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQEND1_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQEND1_Clear = 0x1
	// Position of PWMPERIODEND field.
	PWM_INTENCLR_PWMPERIODEND_Pos = 0x6
	// Bit mask of PWMPERIODEND field.
	PWM_INTENCLR_PWMPERIODEND_Msk = 0x40
	// Bit PWMPERIODEND.
	PWM_INTENCLR_PWMPERIODEND = 0x40
	// Read: Disabled
	PWM_INTENCLR_PWMPERIODEND_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_PWMPERIODEND_Enabled = 0x1
	// Disable
	PWM_INTENCLR_PWMPERIODEND_Clear = 0x1
	// Position of LOOPSDONE field.
	PWM_INTENCLR_LOOPSDONE_Pos = 0x7
	// Bit mask of LOOPSDONE field.
	PWM_INTENCLR_LOOPSDONE_Msk = 0x80
	// Bit LOOPSDONE.
	PWM_INTENCLR_LOOPSDONE = 0x80
	// Read: Disabled
	PWM_INTENCLR_LOOPSDONE_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_LOOPSDONE_Enabled = 0x1
	// Disable
	PWM_INTENCLR_LOOPSDONE_Clear = 0x1

	// ENABLE: PWM module enable register
	// Position of ENABLE field.
	PWM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	PWM_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	PWM_ENABLE_ENABLE = 0x1
	// Disabled
	PWM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	PWM_ENABLE_ENABLE_Enabled = 0x1

	// MODE: Selects operating mode of the wave counter
	// Position of UPDOWN field.
	PWM_MODE_UPDOWN_Pos = 0x0
	// Bit mask of UPDOWN field.
	PWM_MODE_UPDOWN_Msk = 0x1
	// Bit UPDOWN.
	PWM_MODE_UPDOWN = 0x1
	// Up counter, edge-aligned PWM duty cycle
	PWM_MODE_UPDOWN_Up = 0x0
	// Up and down counter, center-aligned PWM duty cycle
	PWM_MODE_UPDOWN_UpAndDown = 0x1

	// COUNTERTOP: Value up to which the pulse generator counter counts
	// Position of COUNTERTOP field.
	PWM_COUNTERTOP_COUNTERTOP_Pos = 0x0
	// Bit mask of COUNTERTOP field.
	PWM_COUNTERTOP_COUNTERTOP_Msk = 0x7fff

	// PRESCALER: Configuration for PWM_CLK
	// Position of PRESCALER field.
	PWM_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	PWM_PRESCALER_PRESCALER_Msk = 0x7
	// Divide by 1 (16 MHz)
	PWM_PRESCALER_PRESCALER_DIV_1 = 0x0
	// Divide by 2 (8 MHz)
	PWM_PRESCALER_PRESCALER_DIV_2 = 0x1
	// Divide by 4 (4 MHz)
	PWM_PRESCALER_PRESCALER_DIV_4 = 0x2
	// Divide by 8 (2 MHz)
	PWM_PRESCALER_PRESCALER_DIV_8 = 0x3
	// Divide by 16 (1 MHz)
	PWM_PRESCALER_PRESCALER_DIV_16 = 0x4
	// Divide by 32 (500 kHz)
	PWM_PRESCALER_PRESCALER_DIV_32 = 0x5
	// Divide by 64 (250 kHz)
	PWM_PRESCALER_PRESCALER_DIV_64 = 0x6
	// Divide by 128 (125 kHz)
	PWM_PRESCALER_PRESCALER_DIV_128 = 0x7

	// DECODER: Configuration of the decoder
	// Position of LOAD field.
	PWM_DECODER_LOAD_Pos = 0x0
	// Bit mask of LOAD field.
	PWM_DECODER_LOAD_Msk = 0x3
	// 1st half word (16-bit) used in all PWM channels 0..3
	PWM_DECODER_LOAD_Common = 0x0
	// 1st half word (16-bit) used in channel 0..1; 2nd word in channel 2..3
	PWM_DECODER_LOAD_Grouped = 0x1
	// 1st half word (16-bit) in ch.0; 2nd in ch.1; ...; 4th in ch.3
	PWM_DECODER_LOAD_Individual = 0x2
	// 1st half word (16-bit) in ch.0; 2nd in ch.1; ...; 4th in COUNTERTOP
	PWM_DECODER_LOAD_WaveForm = 0x3
	// Position of MODE field.
	PWM_DECODER_MODE_Pos = 0x8
	// Bit mask of MODE field.
	PWM_DECODER_MODE_Msk = 0x100
	// Bit MODE.
	PWM_DECODER_MODE = 0x100
	// SEQ[n].REFRESH is used to determine loading internal compare registers
	PWM_DECODER_MODE_RefreshCount = 0x0
	// NEXTSTEP task causes a new value to be loaded to internal compare registers
	PWM_DECODER_MODE_NextStep = 0x1

	// LOOP: Number of playbacks of a loop
	// Position of CNT field.
	PWM_LOOP_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_LOOP_CNT_Msk = 0xffff
	// Looping disabled (stop at the end of the sequence)
	PWM_LOOP_CNT_Disabled = 0x0

	// SEQ.PTR: Description cluster: Beginning address in RAM of this sequence
	// Position of PTR field.
	PWM_SEQ_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	PWM_SEQ_PTR_PTR_Msk = 0xffffffff

	// SEQ.CNT: Description cluster: Number of values (duty cycles) in this sequence
	// Position of CNT field.
	PWM_SEQ_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_SEQ_CNT_CNT_Msk = 0x7fff
	// Sequence is disabled, and shall not be started as it is empty
	PWM_SEQ_CNT_CNT_Disabled = 0x0

	// SEQ.REFRESH: Description cluster: Number of additional PWM periods between samples loaded into compare register
	// Position of CNT field.
	PWM_SEQ_REFRESH_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_SEQ_REFRESH_CNT_Msk = 0xffffff
	// Update every PWM period
	PWM_SEQ_REFRESH_CNT_Continuous = 0x0

	// SEQ.ENDDELAY: Description cluster: Time added after the sequence
	// Position of CNT field.
	PWM_SEQ_ENDDELAY_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_SEQ_ENDDELAY_CNT_Msk = 0xffffff

	// PSEL.OUT: Description collection: Output pin select for PWM channel n
	// Position of PIN field.
	PWM_PSEL_OUT_PIN_Pos = 0x0
	// Bit mask of PIN field.
	PWM_PSEL_OUT_PIN_Msk = 0x1f
	// Position of CONNECT field.
	PWM_PSEL_OUT_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	PWM_PSEL_OUT_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	PWM_PSEL_OUT_CONNECT = 0x80000000
	// Disconnect
	PWM_PSEL_OUT_CONNECT_Disconnected = 0x1
	// Connect
	PWM_PSEL_OUT_CONNECT_Connected = 0x0
)

// Constants for PDM_NS: Pulse Density Modulation (Digital Microphone) Interface 0
const (
	// TASKS_START: Starts continuous PDM transfer
	// Position of TASKS_START field.
	PDM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	PDM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	PDM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	PDM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stops PDM transfer
	// Position of TASKS_STOP field.
	PDM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	PDM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	PDM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	PDM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	PDM_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PDM_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	PDM_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	PDM_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	PDM_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	PDM_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	PDM_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	PDM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PDM_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	PDM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	PDM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	PDM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	PDM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	PDM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_STARTED: PDM transfer has started
	// Position of EVENTS_STARTED field.
	PDM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	PDM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	PDM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	PDM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	PDM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// EVENTS_STOPPED: PDM transfer has finished
	// Position of EVENTS_STOPPED field.
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	PDM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_END: The PDM has written the last sample specified by SAMPLE.MAXCNT (or the last sample after a STOP task has been received) to Data RAM
	// Position of EVENTS_END field.
	PDM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	PDM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	PDM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	PDM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	PDM_EVENTS_END_EVENTS_END_Generated = 0x1

	// PUBLISH_STARTED: Publish configuration for event STARTED
	// Position of CHIDX field.
	PDM_PUBLISH_STARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PDM_PUBLISH_STARTED_CHIDX_Msk = 0xf
	// Position of EN field.
	PDM_PUBLISH_STARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	PDM_PUBLISH_STARTED_EN_Msk = 0x80000000
	// Bit EN.
	PDM_PUBLISH_STARTED_EN = 0x80000000
	// Disable publishing
	PDM_PUBLISH_STARTED_EN_Disabled = 0x0
	// Enable publishing
	PDM_PUBLISH_STARTED_EN_Enabled = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	PDM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PDM_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	PDM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	PDM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	PDM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	PDM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	PDM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	PDM_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	PDM_PUBLISH_END_CHIDX_Msk = 0xf
	// Position of EN field.
	PDM_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	PDM_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	PDM_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	PDM_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	PDM_PUBLISH_END_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STARTED field.
	PDM_INTEN_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	PDM_INTEN_STARTED_Msk = 0x1
	// Bit STARTED.
	PDM_INTEN_STARTED = 0x1
	// Disable
	PDM_INTEN_STARTED_Disabled = 0x0
	// Enable
	PDM_INTEN_STARTED_Enabled = 0x1
	// Position of STOPPED field.
	PDM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PDM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PDM_INTEN_STOPPED = 0x2
	// Disable
	PDM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	PDM_INTEN_STOPPED_Enabled = 0x1
	// Position of END field.
	PDM_INTEN_END_Pos = 0x2
	// Bit mask of END field.
	PDM_INTEN_END_Msk = 0x4
	// Bit END.
	PDM_INTEN_END = 0x4
	// Disable
	PDM_INTEN_END_Disabled = 0x0
	// Enable
	PDM_INTEN_END_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STARTED field.
	PDM_INTENSET_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	PDM_INTENSET_STARTED_Msk = 0x1
	// Bit STARTED.
	PDM_INTENSET_STARTED = 0x1
	// Read: Disabled
	PDM_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENSET_STARTED_Enabled = 0x1
	// Enable
	PDM_INTENSET_STARTED_Set = 0x1
	// Position of STOPPED field.
	PDM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PDM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PDM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	PDM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	PDM_INTENSET_STOPPED_Set = 0x1
	// Position of END field.
	PDM_INTENSET_END_Pos = 0x2
	// Bit mask of END field.
	PDM_INTENSET_END_Msk = 0x4
	// Bit END.
	PDM_INTENSET_END = 0x4
	// Read: Disabled
	PDM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	PDM_INTENSET_END_Enabled = 0x1
	// Enable
	PDM_INTENSET_END_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STARTED field.
	PDM_INTENCLR_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	PDM_INTENCLR_STARTED_Msk = 0x1
	// Bit STARTED.
	PDM_INTENCLR_STARTED = 0x1
	// Read: Disabled
	PDM_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	PDM_INTENCLR_STARTED_Clear = 0x1
	// Position of STOPPED field.
	PDM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PDM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PDM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	PDM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	PDM_INTENCLR_STOPPED_Clear = 0x1
	// Position of END field.
	PDM_INTENCLR_END_Pos = 0x2
	// Bit mask of END field.
	PDM_INTENCLR_END_Msk = 0x4
	// Bit END.
	PDM_INTENCLR_END = 0x4
	// Read: Disabled
	PDM_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	PDM_INTENCLR_END_Enabled = 0x1
	// Disable
	PDM_INTENCLR_END_Clear = 0x1

	// ENABLE: PDM module enable register
	// Position of ENABLE field.
	PDM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	PDM_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	PDM_ENABLE_ENABLE = 0x1
	// Disable
	PDM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	PDM_ENABLE_ENABLE_Enabled = 0x1

	// PDMCLKCTRL: PDM clock generator control
	// Position of FREQ field.
	PDM_PDMCLKCTRL_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	PDM_PDMCLKCTRL_FREQ_Msk = 0xffffffff
	// PDM_CLK = 32 MHz / 32 = 1.000 MHz
	PDM_PDMCLKCTRL_FREQ_1000K = 0x8000000
	// PDM_CLK = 32 MHz / 31 = 1.032 MHz. Nominal clock for RATIO=Ratio64.
	PDM_PDMCLKCTRL_FREQ_Default = 0x8400000
	// PDM_CLK = 32 MHz / 30 = 1.067 MHz
	PDM_PDMCLKCTRL_FREQ_1067K = 0x8800000
	// PDM_CLK = 32 MHz / 26 = 1.231 MHz
	PDM_PDMCLKCTRL_FREQ_1231K = 0x9800000
	// PDM_CLK = 32 MHz / 25 = 1.280 MHz. Nominal clock for RATIO=Ratio80.
	PDM_PDMCLKCTRL_FREQ_1280K = 0xa000000
	// PDM_CLK = 32 MHz / 24 = 1.333 MHz
	PDM_PDMCLKCTRL_FREQ_1333K = 0xa800000

	// MODE: Defines the routing of the connected PDM microphones' signals
	// Position of OPERATION field.
	PDM_MODE_OPERATION_Pos = 0x0
	// Bit mask of OPERATION field.
	PDM_MODE_OPERATION_Msk = 0x1
	// Bit OPERATION.
	PDM_MODE_OPERATION = 0x1
	// Sample and store one pair (Left + Right) of 16bit samples per RAM word R=[31:16]; L=[15:0]
	PDM_MODE_OPERATION_Stereo = 0x0
	// Sample and store two successive Left samples (16 bit each) per RAM word L1=[31:16]; L0=[15:0]
	PDM_MODE_OPERATION_Mono = 0x1
	// Position of EDGE field.
	PDM_MODE_EDGE_Pos = 0x1
	// Bit mask of EDGE field.
	PDM_MODE_EDGE_Msk = 0x2
	// Bit EDGE.
	PDM_MODE_EDGE = 0x2
	// Left (or mono) is sampled on falling edge of PDM_CLK
	PDM_MODE_EDGE_LeftFalling = 0x0
	// Left (or mono) is sampled on rising edge of PDM_CLK
	PDM_MODE_EDGE_LeftRising = 0x1

	// GAINL: Left output gain adjustment
	// Position of GAINL field.
	PDM_GAINL_GAINL_Pos = 0x0
	// Bit mask of GAINL field.
	PDM_GAINL_GAINL_Msk = 0x7f
	// -20dB gain adjustment (minimum)
	PDM_GAINL_GAINL_MinGain = 0x0
	// 0dB gain adjustment
	PDM_GAINL_GAINL_DefaultGain = 0x28
	// +20dB gain adjustment (maximum)
	PDM_GAINL_GAINL_MaxGain = 0x50

	// GAINR: Right output gain adjustment
	// Position of GAINR field.
	PDM_GAINR_GAINR_Pos = 0x0
	// Bit mask of GAINR field.
	PDM_GAINR_GAINR_Msk = 0x7f
	// -20dB gain adjustment (minimum)
	PDM_GAINR_GAINR_MinGain = 0x0
	// 0dB gain adjustment
	PDM_GAINR_GAINR_DefaultGain = 0x28
	// +20dB gain adjustment (maximum)
	PDM_GAINR_GAINR_MaxGain = 0x50

	// RATIO: Selects the ratio between PDM_CLK and output sample rate. Change PDMCLKCTRL accordingly.
	// Position of RATIO field.
	PDM_RATIO_RATIO_Pos = 0x0
	// Bit mask of RATIO field.
	PDM_RATIO_RATIO_Msk = 0x1
	// Bit RATIO.
	PDM_RATIO_RATIO = 0x1
	// Ratio of 64
	PDM_RATIO_RATIO_Ratio64 = 0x0
	// Ratio of 80
	PDM_RATIO_RATIO_Ratio80 = 0x1

	// PSEL.CLK: Pin number configuration for PDM CLK signal
	// Position of PIN field.
	PDM_PSEL_CLK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	PDM_PSEL_CLK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	PDM_PSEL_CLK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	PDM_PSEL_CLK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	PDM_PSEL_CLK_CONNECT = 0x80000000
	// Disconnect
	PDM_PSEL_CLK_CONNECT_Disconnected = 0x1
	// Connect
	PDM_PSEL_CLK_CONNECT_Connected = 0x0

	// PSEL.DIN: Pin number configuration for PDM DIN signal
	// Position of PIN field.
	PDM_PSEL_DIN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	PDM_PSEL_DIN_PIN_Msk = 0x1f
	// Position of CONNECT field.
	PDM_PSEL_DIN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	PDM_PSEL_DIN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	PDM_PSEL_DIN_CONNECT = 0x80000000
	// Disconnect
	PDM_PSEL_DIN_CONNECT_Disconnected = 0x1
	// Connect
	PDM_PSEL_DIN_CONNECT_Connected = 0x0

	// SAMPLE.PTR: RAM address pointer to write samples to with EasyDMA
	// Position of SAMPLEPTR field.
	PDM_SAMPLE_PTR_SAMPLEPTR_Pos = 0x0
	// Bit mask of SAMPLEPTR field.
	PDM_SAMPLE_PTR_SAMPLEPTR_Msk = 0xffffffff

	// SAMPLE.MAXCNT: Number of samples to allocate memory for in EasyDMA mode
	// Position of BUFFSIZE field.
	PDM_SAMPLE_MAXCNT_BUFFSIZE_Pos = 0x0
	// Bit mask of BUFFSIZE field.
	PDM_SAMPLE_MAXCNT_BUFFSIZE_Msk = 0x7fff
)

// Constants for I2S_NS: Inter-IC Sound 0
const (
	// TASKS_START: Starts continuous I2S transfer. Also starts MCK generator when this is enabled.
	// Position of TASKS_START field.
	I2S_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	I2S_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	I2S_TASKS_START_TASKS_START = 0x1
	// Trigger task
	I2S_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stops I2S transfer. Also stops MCK generator. Triggering this task will cause the STOPPED event to be generated.
	// Position of TASKS_STOP field.
	I2S_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	I2S_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	I2S_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	I2S_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	I2S_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	I2S_SUBSCRIBE_START_CHIDX_Msk = 0xf
	// Position of EN field.
	I2S_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	I2S_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	I2S_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	I2S_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	I2S_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	I2S_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	I2S_SUBSCRIBE_STOP_CHIDX_Msk = 0xf
	// Position of EN field.
	I2S_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	I2S_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	I2S_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	I2S_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	I2S_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_RXPTRUPD: The RXD.PTR register has been copied to internal double-buffers. When the I2S module is started and RX is enabled, this event will be generated for every RXTXD.MAXCNT words that are received on the SDIN pin.
	// Position of EVENTS_RXPTRUPD field.
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_Pos = 0x0
	// Bit mask of EVENTS_RXPTRUPD field.
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_Msk = 0x1
	// Bit EVENTS_RXPTRUPD.
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD = 0x1
	// Event not generated
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_NotGenerated = 0x0
	// Event generated
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_Generated = 0x1

	// EVENTS_STOPPED: I2S transfer stopped.
	// Position of EVENTS_STOPPED field.
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	I2S_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_TXPTRUPD: The TDX.PTR register has been copied to internal double-buffers. When the I2S module is started and TX is enabled, this event will be generated for every RXTXD.MAXCNT words that are sent on the SDOUT pin.
	// Position of EVENTS_TXPTRUPD field.
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_Pos = 0x0
	// Bit mask of EVENTS_TXPTRUPD field.
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_Msk = 0x1
	// Bit EVENTS_TXPTRUPD.
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD = 0x1
	// Event not generated
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_NotGenerated = 0x0
	// Event generated
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_Generated = 0x1

	// PUBLISH_RXPTRUPD: Publish configuration for event RXPTRUPD
	// Position of CHIDX field.
	I2S_PUBLISH_RXPTRUPD_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	I2S_PUBLISH_RXPTRUPD_CHIDX_Msk = 0xf
	// Position of EN field.
	I2S_PUBLISH_RXPTRUPD_EN_Pos = 0x1f
	// Bit mask of EN field.
	I2S_PUBLISH_RXPTRUPD_EN_Msk = 0x80000000
	// Bit EN.
	I2S_PUBLISH_RXPTRUPD_EN = 0x80000000
	// Disable publishing
	I2S_PUBLISH_RXPTRUPD_EN_Disabled = 0x0
	// Enable publishing
	I2S_PUBLISH_RXPTRUPD_EN_Enabled = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	I2S_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	I2S_PUBLISH_STOPPED_CHIDX_Msk = 0xf
	// Position of EN field.
	I2S_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	I2S_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	I2S_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	I2S_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	I2S_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_TXPTRUPD: Publish configuration for event TXPTRUPD
	// Position of CHIDX field.
	I2S_PUBLISH_TXPTRUPD_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	I2S_PUBLISH_TXPTRUPD_CHIDX_Msk = 0xf
	// Position of EN field.
	I2S_PUBLISH_TXPTRUPD_EN_Pos = 0x1f
	// Bit mask of EN field.
	I2S_PUBLISH_TXPTRUPD_EN_Msk = 0x80000000
	// Bit EN.
	I2S_PUBLISH_TXPTRUPD_EN = 0x80000000
	// Disable publishing
	I2S_PUBLISH_TXPTRUPD_EN_Disabled = 0x0
	// Enable publishing
	I2S_PUBLISH_TXPTRUPD_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RXPTRUPD field.
	I2S_INTEN_RXPTRUPD_Pos = 0x1
	// Bit mask of RXPTRUPD field.
	I2S_INTEN_RXPTRUPD_Msk = 0x2
	// Bit RXPTRUPD.
	I2S_INTEN_RXPTRUPD = 0x2
	// Disable
	I2S_INTEN_RXPTRUPD_Disabled = 0x0
	// Enable
	I2S_INTEN_RXPTRUPD_Enabled = 0x1
	// Position of STOPPED field.
	I2S_INTEN_STOPPED_Pos = 0x2
	// Bit mask of STOPPED field.
	I2S_INTEN_STOPPED_Msk = 0x4
	// Bit STOPPED.
	I2S_INTEN_STOPPED = 0x4
	// Disable
	I2S_INTEN_STOPPED_Disabled = 0x0
	// Enable
	I2S_INTEN_STOPPED_Enabled = 0x1
	// Position of TXPTRUPD field.
	I2S_INTEN_TXPTRUPD_Pos = 0x5
	// Bit mask of TXPTRUPD field.
	I2S_INTEN_TXPTRUPD_Msk = 0x20
	// Bit TXPTRUPD.
	I2S_INTEN_TXPTRUPD = 0x20
	// Disable
	I2S_INTEN_TXPTRUPD_Disabled = 0x0
	// Enable
	I2S_INTEN_TXPTRUPD_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RXPTRUPD field.
	I2S_INTENSET_RXPTRUPD_Pos = 0x1
	// Bit mask of RXPTRUPD field.
	I2S_INTENSET_RXPTRUPD_Msk = 0x2
	// Bit RXPTRUPD.
	I2S_INTENSET_RXPTRUPD = 0x2
	// Read: Disabled
	I2S_INTENSET_RXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENSET_RXPTRUPD_Enabled = 0x1
	// Enable
	I2S_INTENSET_RXPTRUPD_Set = 0x1
	// Position of STOPPED field.
	I2S_INTENSET_STOPPED_Pos = 0x2
	// Bit mask of STOPPED field.
	I2S_INTENSET_STOPPED_Msk = 0x4
	// Bit STOPPED.
	I2S_INTENSET_STOPPED = 0x4
	// Read: Disabled
	I2S_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	I2S_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	I2S_INTENSET_STOPPED_Set = 0x1
	// Position of TXPTRUPD field.
	I2S_INTENSET_TXPTRUPD_Pos = 0x5
	// Bit mask of TXPTRUPD field.
	I2S_INTENSET_TXPTRUPD_Msk = 0x20
	// Bit TXPTRUPD.
	I2S_INTENSET_TXPTRUPD = 0x20
	// Read: Disabled
	I2S_INTENSET_TXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENSET_TXPTRUPD_Enabled = 0x1
	// Enable
	I2S_INTENSET_TXPTRUPD_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RXPTRUPD field.
	I2S_INTENCLR_RXPTRUPD_Pos = 0x1
	// Bit mask of RXPTRUPD field.
	I2S_INTENCLR_RXPTRUPD_Msk = 0x2
	// Bit RXPTRUPD.
	I2S_INTENCLR_RXPTRUPD = 0x2
	// Read: Disabled
	I2S_INTENCLR_RXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENCLR_RXPTRUPD_Enabled = 0x1
	// Disable
	I2S_INTENCLR_RXPTRUPD_Clear = 0x1
	// Position of STOPPED field.
	I2S_INTENCLR_STOPPED_Pos = 0x2
	// Bit mask of STOPPED field.
	I2S_INTENCLR_STOPPED_Msk = 0x4
	// Bit STOPPED.
	I2S_INTENCLR_STOPPED = 0x4
	// Read: Disabled
	I2S_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	I2S_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	I2S_INTENCLR_STOPPED_Clear = 0x1
	// Position of TXPTRUPD field.
	I2S_INTENCLR_TXPTRUPD_Pos = 0x5
	// Bit mask of TXPTRUPD field.
	I2S_INTENCLR_TXPTRUPD_Msk = 0x20
	// Bit TXPTRUPD.
	I2S_INTENCLR_TXPTRUPD = 0x20
	// Read: Disabled
	I2S_INTENCLR_TXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENCLR_TXPTRUPD_Enabled = 0x1
	// Disable
	I2S_INTENCLR_TXPTRUPD_Clear = 0x1

	// ENABLE: Enable I2S module.
	// Position of ENABLE field.
	I2S_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	I2S_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	I2S_ENABLE_ENABLE = 0x1
	// Disable
	I2S_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	I2S_ENABLE_ENABLE_Enabled = 0x1

	// CONFIG.MODE: I2S mode.
	// Position of MODE field.
	I2S_CONFIG_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	I2S_CONFIG_MODE_MODE_Msk = 0x1
	// Bit MODE.
	I2S_CONFIG_MODE_MODE = 0x1
	// Master mode. SCK and LRCK generated from internal master clcok (MCK) and output on pins defined by PSEL.xxx.
	I2S_CONFIG_MODE_MODE_Master = 0x0
	// Slave mode. SCK and LRCK generated by external master and received on pins defined by PSEL.xxx
	I2S_CONFIG_MODE_MODE_Slave = 0x1

	// CONFIG.RXEN: Reception (RX) enable.
	// Position of RXEN field.
	I2S_CONFIG_RXEN_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	I2S_CONFIG_RXEN_RXEN_Msk = 0x1
	// Bit RXEN.
	I2S_CONFIG_RXEN_RXEN = 0x1
	// Reception disabled and now data will be written to the RXD.PTR address.
	I2S_CONFIG_RXEN_RXEN_Disabled = 0x0
	// Reception enabled.
	I2S_CONFIG_RXEN_RXEN_Enabled = 0x1

	// CONFIG.TXEN: Transmission (TX) enable.
	// Position of TXEN field.
	I2S_CONFIG_TXEN_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	I2S_CONFIG_TXEN_TXEN_Msk = 0x1
	// Bit TXEN.
	I2S_CONFIG_TXEN_TXEN = 0x1
	// Transmission disabled and now data will be read from the RXD.TXD address.
	I2S_CONFIG_TXEN_TXEN_Disabled = 0x0
	// Transmission enabled.
	I2S_CONFIG_TXEN_TXEN_Enabled = 0x1

	// CONFIG.MCKEN: Master clock generator enable.
	// Position of MCKEN field.
	I2S_CONFIG_MCKEN_MCKEN_Pos = 0x0
	// Bit mask of MCKEN field.
	I2S_CONFIG_MCKEN_MCKEN_Msk = 0x1
	// Bit MCKEN.
	I2S_CONFIG_MCKEN_MCKEN = 0x1
	// Master clock generator disabled and PSEL.MCK not connected(available as GPIO).
	I2S_CONFIG_MCKEN_MCKEN_Disabled = 0x0
	// Master clock generator running and MCK output on PSEL.MCK.
	I2S_CONFIG_MCKEN_MCKEN_Enabled = 0x1

	// CONFIG.MCKFREQ: Master clock generator frequency.
	// Position of MCKFREQ field.
	I2S_CONFIG_MCKFREQ_MCKFREQ_Pos = 0x0
	// Bit mask of MCKFREQ field.
	I2S_CONFIG_MCKFREQ_MCKFREQ_Msk = 0xffffffff
	// 32 MHz / 8 = 4.0 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV8 = 0x20000000
	// 32 MHz / 10 = 3.2 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV10 = 0x18000000
	// 32 MHz / 11 = 2.9090909 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV11 = 0x16000000
	// 32 MHz / 15 = 2.1333333 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV15 = 0x11000000
	// 32 MHz / 16 = 2.0 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV16 = 0x10000000
	// 32 MHz / 21 = 1.5238095
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV21 = 0xc000000
	// 32 MHz / 23 = 1.3913043 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV23 = 0xb000000
	// 32 MHz / 30 = 1.0666667 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV30 = 0x8800000
	// 32 MHz / 31 = 1.0322581 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV31 = 0x8400000
	// 32 MHz / 32 = 1.0 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV32 = 0x8000000
	// 32 MHz / 42 = 0.7619048 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV42 = 0x6000000
	// 32 MHz / 63 = 0.5079365 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV63 = 0x4100000
	// 32 MHz / 125 = 0.256 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV125 = 0x20c0000

	// CONFIG.RATIO: MCK / LRCK ratio.
	// Position of RATIO field.
	I2S_CONFIG_RATIO_RATIO_Pos = 0x0
	// Bit mask of RATIO field.
	I2S_CONFIG_RATIO_RATIO_Msk = 0xf
	// LRCK = MCK / 32
	I2S_CONFIG_RATIO_RATIO_32X = 0x0
	// LRCK = MCK / 48
	I2S_CONFIG_RATIO_RATIO_48X = 0x1
	// LRCK = MCK / 64
	I2S_CONFIG_RATIO_RATIO_64X = 0x2
	// LRCK = MCK / 96
	I2S_CONFIG_RATIO_RATIO_96X = 0x3
	// LRCK = MCK / 128
	I2S_CONFIG_RATIO_RATIO_128X = 0x4
	// LRCK = MCK / 192
	I2S_CONFIG_RATIO_RATIO_192X = 0x5
	// LRCK = MCK / 256
	I2S_CONFIG_RATIO_RATIO_256X = 0x6
	// LRCK = MCK / 384
	I2S_CONFIG_RATIO_RATIO_384X = 0x7
	// LRCK = MCK / 512
	I2S_CONFIG_RATIO_RATIO_512X = 0x8

	// CONFIG.SWIDTH: Sample width.
	// Position of SWIDTH field.
	I2S_CONFIG_SWIDTH_SWIDTH_Pos = 0x0
	// Bit mask of SWIDTH field.
	I2S_CONFIG_SWIDTH_SWIDTH_Msk = 0x3
	// 8 bit.
	I2S_CONFIG_SWIDTH_SWIDTH_8Bit = 0x0
	// 16 bit.
	I2S_CONFIG_SWIDTH_SWIDTH_16Bit = 0x1
	// 24 bit.
	I2S_CONFIG_SWIDTH_SWIDTH_24Bit = 0x2

	// CONFIG.ALIGN: Alignment of sample within a frame.
	// Position of ALIGN field.
	I2S_CONFIG_ALIGN_ALIGN_Pos = 0x0
	// Bit mask of ALIGN field.
	I2S_CONFIG_ALIGN_ALIGN_Msk = 0x1
	// Bit ALIGN.
	I2S_CONFIG_ALIGN_ALIGN = 0x1
	// Left-aligned.
	I2S_CONFIG_ALIGN_ALIGN_Left = 0x0
	// Right-aligned.
	I2S_CONFIG_ALIGN_ALIGN_Right = 0x1

	// CONFIG.FORMAT: Frame format.
	// Position of FORMAT field.
	I2S_CONFIG_FORMAT_FORMAT_Pos = 0x0
	// Bit mask of FORMAT field.
	I2S_CONFIG_FORMAT_FORMAT_Msk = 0x1
	// Bit FORMAT.
	I2S_CONFIG_FORMAT_FORMAT = 0x1
	// Original I2S format.
	I2S_CONFIG_FORMAT_FORMAT_I2S = 0x0
	// Alternate (left- or right-aligned) format.
	I2S_CONFIG_FORMAT_FORMAT_Aligned = 0x1

	// CONFIG.CHANNELS: Enable channels.
	// Position of CHANNELS field.
	I2S_CONFIG_CHANNELS_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	I2S_CONFIG_CHANNELS_CHANNELS_Msk = 0x3
	// Stereo.
	I2S_CONFIG_CHANNELS_CHANNELS_Stereo = 0x0
	// Left only.
	I2S_CONFIG_CHANNELS_CHANNELS_Left = 0x1
	// Right only.
	I2S_CONFIG_CHANNELS_CHANNELS_Right = 0x2

	// RXD.PTR: Receive buffer RAM start address.
	// Position of PTR field.
	I2S_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	I2S_RXD_PTR_PTR_Msk = 0xffffffff

	// TXD.PTR: Transmit buffer RAM start address.
	// Position of PTR field.
	I2S_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	I2S_TXD_PTR_PTR_Msk = 0xffffffff

	// RXTXD.MAXCNT: Size of RXD and TXD buffers.
	// Position of MAXCNT field.
	I2S_RXTXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	I2S_RXTXD_MAXCNT_MAXCNT_Msk = 0x3fff

	// PSEL.MCK: Pin select for MCK signal.
	// Position of PIN field.
	I2S_PSEL_MCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_MCK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	I2S_PSEL_MCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_MCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_MCK_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_MCK_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_MCK_CONNECT_Connected = 0x0

	// PSEL.SCK: Pin select for SCK signal.
	// Position of PIN field.
	I2S_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_SCK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	I2S_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.LRCK: Pin select for LRCK signal.
	// Position of PIN field.
	I2S_PSEL_LRCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_LRCK_PIN_Msk = 0x1f
	// Position of CONNECT field.
	I2S_PSEL_LRCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_LRCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_LRCK_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_LRCK_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_LRCK_CONNECT_Connected = 0x0

	// PSEL.SDIN: Pin select for SDIN signal.
	// Position of PIN field.
	I2S_PSEL_SDIN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_SDIN_PIN_Msk = 0x1f
	// Position of CONNECT field.
	I2S_PSEL_SDIN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_SDIN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_SDIN_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_SDIN_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_SDIN_CONNECT_Connected = 0x0

	// PSEL.SDOUT: Pin select for SDOUT signal.
	// Position of PIN field.
	I2S_PSEL_SDOUT_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_SDOUT_PIN_Msk = 0x1f
	// Position of CONNECT field.
	I2S_PSEL_SDOUT_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_SDOUT_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_SDOUT_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_SDOUT_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_SDOUT_CONNECT_Connected = 0x0
)

// Constants for IPC_NS: Inter Processor Communication 0
const (
	// TASKS_SEND: Description collection: Trigger events on channel enabled in SEND_CNF[n].
	// Position of TASKS_SEND field.
	IPC_TASKS_SEND_TASKS_SEND_Pos = 0x0
	// Bit mask of TASKS_SEND field.
	IPC_TASKS_SEND_TASKS_SEND_Msk = 0x1
	// Bit TASKS_SEND.
	IPC_TASKS_SEND_TASKS_SEND = 0x1
	// Trigger task
	IPC_TASKS_SEND_TASKS_SEND_Trigger = 0x1

	// SUBSCRIBE_SEND: Description collection: Subscribe configuration for task SEND[n]
	// Position of CHIDX field.
	IPC_SUBSCRIBE_SEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	IPC_SUBSCRIBE_SEND_CHIDX_Msk = 0xf
	// Position of EN field.
	IPC_SUBSCRIBE_SEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	IPC_SUBSCRIBE_SEND_EN_Msk = 0x80000000
	// Bit EN.
	IPC_SUBSCRIBE_SEND_EN = 0x80000000
	// Disable subscription
	IPC_SUBSCRIBE_SEND_EN_Disabled = 0x0
	// Enable subscription
	IPC_SUBSCRIBE_SEND_EN_Enabled = 0x1

	// EVENTS_RECEIVE: Description collection: Event received on one or more of the enabled channels in RECEIVE_CNF[n].
	// Position of EVENTS_RECEIVE field.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Pos = 0x0
	// Bit mask of EVENTS_RECEIVE field.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Msk = 0x1
	// Bit EVENTS_RECEIVE.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE = 0x1
	// Event not generated
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_NotGenerated = 0x0
	// Event generated
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Generated = 0x1

	// PUBLISH_RECEIVE: Description collection: Publish configuration for event RECEIVE[n]
	// Position of CHIDX field.
	IPC_PUBLISH_RECEIVE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	IPC_PUBLISH_RECEIVE_CHIDX_Msk = 0xf
	// Position of EN field.
	IPC_PUBLISH_RECEIVE_EN_Pos = 0x1f
	// Bit mask of EN field.
	IPC_PUBLISH_RECEIVE_EN_Msk = 0x80000000
	// Bit EN.
	IPC_PUBLISH_RECEIVE_EN = 0x80000000
	// Disable publishing
	IPC_PUBLISH_RECEIVE_EN_Disabled = 0x0
	// Enable publishing
	IPC_PUBLISH_RECEIVE_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RECEIVE0 field.
	IPC_INTEN_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTEN_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTEN_RECEIVE0 = 0x1
	// Disable
	IPC_INTEN_RECEIVE0_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE0_Enabled = 0x1
	// Position of RECEIVE1 field.
	IPC_INTEN_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTEN_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTEN_RECEIVE1 = 0x2
	// Disable
	IPC_INTEN_RECEIVE1_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE1_Enabled = 0x1
	// Position of RECEIVE2 field.
	IPC_INTEN_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTEN_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTEN_RECEIVE2 = 0x4
	// Disable
	IPC_INTEN_RECEIVE2_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE2_Enabled = 0x1
	// Position of RECEIVE3 field.
	IPC_INTEN_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTEN_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTEN_RECEIVE3 = 0x8
	// Disable
	IPC_INTEN_RECEIVE3_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE3_Enabled = 0x1
	// Position of RECEIVE4 field.
	IPC_INTEN_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTEN_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTEN_RECEIVE4 = 0x10
	// Disable
	IPC_INTEN_RECEIVE4_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE4_Enabled = 0x1
	// Position of RECEIVE5 field.
	IPC_INTEN_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTEN_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTEN_RECEIVE5 = 0x20
	// Disable
	IPC_INTEN_RECEIVE5_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE5_Enabled = 0x1
	// Position of RECEIVE6 field.
	IPC_INTEN_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTEN_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTEN_RECEIVE6 = 0x40
	// Disable
	IPC_INTEN_RECEIVE6_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE6_Enabled = 0x1
	// Position of RECEIVE7 field.
	IPC_INTEN_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTEN_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTEN_RECEIVE7 = 0x80
	// Disable
	IPC_INTEN_RECEIVE7_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE7_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RECEIVE0 field.
	IPC_INTENSET_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTENSET_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTENSET_RECEIVE0 = 0x1
	// Read: Disabled
	IPC_INTENSET_RECEIVE0_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE0_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE0_Set = 0x1
	// Position of RECEIVE1 field.
	IPC_INTENSET_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTENSET_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTENSET_RECEIVE1 = 0x2
	// Read: Disabled
	IPC_INTENSET_RECEIVE1_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE1_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE1_Set = 0x1
	// Position of RECEIVE2 field.
	IPC_INTENSET_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTENSET_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTENSET_RECEIVE2 = 0x4
	// Read: Disabled
	IPC_INTENSET_RECEIVE2_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE2_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE2_Set = 0x1
	// Position of RECEIVE3 field.
	IPC_INTENSET_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTENSET_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTENSET_RECEIVE3 = 0x8
	// Read: Disabled
	IPC_INTENSET_RECEIVE3_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE3_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE3_Set = 0x1
	// Position of RECEIVE4 field.
	IPC_INTENSET_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTENSET_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTENSET_RECEIVE4 = 0x10
	// Read: Disabled
	IPC_INTENSET_RECEIVE4_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE4_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE4_Set = 0x1
	// Position of RECEIVE5 field.
	IPC_INTENSET_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTENSET_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTENSET_RECEIVE5 = 0x20
	// Read: Disabled
	IPC_INTENSET_RECEIVE5_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE5_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE5_Set = 0x1
	// Position of RECEIVE6 field.
	IPC_INTENSET_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTENSET_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTENSET_RECEIVE6 = 0x40
	// Read: Disabled
	IPC_INTENSET_RECEIVE6_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE6_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE6_Set = 0x1
	// Position of RECEIVE7 field.
	IPC_INTENSET_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTENSET_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTENSET_RECEIVE7 = 0x80
	// Read: Disabled
	IPC_INTENSET_RECEIVE7_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE7_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE7_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RECEIVE0 field.
	IPC_INTENCLR_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTENCLR_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTENCLR_RECEIVE0 = 0x1
	// Read: Disabled
	IPC_INTENCLR_RECEIVE0_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE0_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE0_Clear = 0x1
	// Position of RECEIVE1 field.
	IPC_INTENCLR_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTENCLR_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTENCLR_RECEIVE1 = 0x2
	// Read: Disabled
	IPC_INTENCLR_RECEIVE1_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE1_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE1_Clear = 0x1
	// Position of RECEIVE2 field.
	IPC_INTENCLR_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTENCLR_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTENCLR_RECEIVE2 = 0x4
	// Read: Disabled
	IPC_INTENCLR_RECEIVE2_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE2_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE2_Clear = 0x1
	// Position of RECEIVE3 field.
	IPC_INTENCLR_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTENCLR_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTENCLR_RECEIVE3 = 0x8
	// Read: Disabled
	IPC_INTENCLR_RECEIVE3_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE3_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE3_Clear = 0x1
	// Position of RECEIVE4 field.
	IPC_INTENCLR_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTENCLR_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTENCLR_RECEIVE4 = 0x10
	// Read: Disabled
	IPC_INTENCLR_RECEIVE4_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE4_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE4_Clear = 0x1
	// Position of RECEIVE5 field.
	IPC_INTENCLR_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTENCLR_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTENCLR_RECEIVE5 = 0x20
	// Read: Disabled
	IPC_INTENCLR_RECEIVE5_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE5_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE5_Clear = 0x1
	// Position of RECEIVE6 field.
	IPC_INTENCLR_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTENCLR_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTENCLR_RECEIVE6 = 0x40
	// Read: Disabled
	IPC_INTENCLR_RECEIVE6_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE6_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE6_Clear = 0x1
	// Position of RECEIVE7 field.
	IPC_INTENCLR_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTENCLR_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTENCLR_RECEIVE7 = 0x80
	// Read: Disabled
	IPC_INTENCLR_RECEIVE7_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE7_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE7_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of RECEIVE0 field.
	IPC_INTPEND_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTPEND_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTPEND_RECEIVE0 = 0x1
	// Read: Not pending
	IPC_INTPEND_RECEIVE0_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE0_Pending = 0x1
	// Position of RECEIVE1 field.
	IPC_INTPEND_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTPEND_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTPEND_RECEIVE1 = 0x2
	// Read: Not pending
	IPC_INTPEND_RECEIVE1_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE1_Pending = 0x1
	// Position of RECEIVE2 field.
	IPC_INTPEND_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTPEND_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTPEND_RECEIVE2 = 0x4
	// Read: Not pending
	IPC_INTPEND_RECEIVE2_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE2_Pending = 0x1
	// Position of RECEIVE3 field.
	IPC_INTPEND_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTPEND_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTPEND_RECEIVE3 = 0x8
	// Read: Not pending
	IPC_INTPEND_RECEIVE3_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE3_Pending = 0x1
	// Position of RECEIVE4 field.
	IPC_INTPEND_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTPEND_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTPEND_RECEIVE4 = 0x10
	// Read: Not pending
	IPC_INTPEND_RECEIVE4_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE4_Pending = 0x1
	// Position of RECEIVE5 field.
	IPC_INTPEND_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTPEND_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTPEND_RECEIVE5 = 0x20
	// Read: Not pending
	IPC_INTPEND_RECEIVE5_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE5_Pending = 0x1
	// Position of RECEIVE6 field.
	IPC_INTPEND_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTPEND_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTPEND_RECEIVE6 = 0x40
	// Read: Not pending
	IPC_INTPEND_RECEIVE6_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE6_Pending = 0x1
	// Position of RECEIVE7 field.
	IPC_INTPEND_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTPEND_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTPEND_RECEIVE7 = 0x80
	// Read: Not pending
	IPC_INTPEND_RECEIVE7_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE7_Pending = 0x1

	// SEND_CNF: Description collection: Send event configuration for TASKS_SEND[n].
	// Position of CHEN0 field.
	IPC_SEND_CNF_CHEN0_Pos = 0x0
	// Bit mask of CHEN0 field.
	IPC_SEND_CNF_CHEN0_Msk = 0x1
	// Bit CHEN0.
	IPC_SEND_CNF_CHEN0 = 0x1
	// Disable broadcast.
	IPC_SEND_CNF_CHEN0_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN0_Enable = 0x1
	// Position of CHEN1 field.
	IPC_SEND_CNF_CHEN1_Pos = 0x1
	// Bit mask of CHEN1 field.
	IPC_SEND_CNF_CHEN1_Msk = 0x2
	// Bit CHEN1.
	IPC_SEND_CNF_CHEN1 = 0x2
	// Disable broadcast.
	IPC_SEND_CNF_CHEN1_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN1_Enable = 0x1
	// Position of CHEN2 field.
	IPC_SEND_CNF_CHEN2_Pos = 0x2
	// Bit mask of CHEN2 field.
	IPC_SEND_CNF_CHEN2_Msk = 0x4
	// Bit CHEN2.
	IPC_SEND_CNF_CHEN2 = 0x4
	// Disable broadcast.
	IPC_SEND_CNF_CHEN2_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN2_Enable = 0x1
	// Position of CHEN3 field.
	IPC_SEND_CNF_CHEN3_Pos = 0x3
	// Bit mask of CHEN3 field.
	IPC_SEND_CNF_CHEN3_Msk = 0x8
	// Bit CHEN3.
	IPC_SEND_CNF_CHEN3 = 0x8
	// Disable broadcast.
	IPC_SEND_CNF_CHEN3_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN3_Enable = 0x1
	// Position of CHEN4 field.
	IPC_SEND_CNF_CHEN4_Pos = 0x4
	// Bit mask of CHEN4 field.
	IPC_SEND_CNF_CHEN4_Msk = 0x10
	// Bit CHEN4.
	IPC_SEND_CNF_CHEN4 = 0x10
	// Disable broadcast.
	IPC_SEND_CNF_CHEN4_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN4_Enable = 0x1
	// Position of CHEN5 field.
	IPC_SEND_CNF_CHEN5_Pos = 0x5
	// Bit mask of CHEN5 field.
	IPC_SEND_CNF_CHEN5_Msk = 0x20
	// Bit CHEN5.
	IPC_SEND_CNF_CHEN5 = 0x20
	// Disable broadcast.
	IPC_SEND_CNF_CHEN5_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN5_Enable = 0x1
	// Position of CHEN6 field.
	IPC_SEND_CNF_CHEN6_Pos = 0x6
	// Bit mask of CHEN6 field.
	IPC_SEND_CNF_CHEN6_Msk = 0x40
	// Bit CHEN6.
	IPC_SEND_CNF_CHEN6 = 0x40
	// Disable broadcast.
	IPC_SEND_CNF_CHEN6_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN6_Enable = 0x1
	// Position of CHEN7 field.
	IPC_SEND_CNF_CHEN7_Pos = 0x7
	// Bit mask of CHEN7 field.
	IPC_SEND_CNF_CHEN7_Msk = 0x80
	// Bit CHEN7.
	IPC_SEND_CNF_CHEN7 = 0x80
	// Disable broadcast.
	IPC_SEND_CNF_CHEN7_Disable = 0x0
	// Enable broadcast.
	IPC_SEND_CNF_CHEN7_Enable = 0x1

	// RECEIVE_CNF: Description collection: Receive event configuration for EVENTS_RECEIVE[n].
	// Position of CHEN0 field.
	IPC_RECEIVE_CNF_CHEN0_Pos = 0x0
	// Bit mask of CHEN0 field.
	IPC_RECEIVE_CNF_CHEN0_Msk = 0x1
	// Bit CHEN0.
	IPC_RECEIVE_CNF_CHEN0 = 0x1
	// Disable events.
	IPC_RECEIVE_CNF_CHEN0_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN0_Enable = 0x1
	// Position of CHEN1 field.
	IPC_RECEIVE_CNF_CHEN1_Pos = 0x1
	// Bit mask of CHEN1 field.
	IPC_RECEIVE_CNF_CHEN1_Msk = 0x2
	// Bit CHEN1.
	IPC_RECEIVE_CNF_CHEN1 = 0x2
	// Disable events.
	IPC_RECEIVE_CNF_CHEN1_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN1_Enable = 0x1
	// Position of CHEN2 field.
	IPC_RECEIVE_CNF_CHEN2_Pos = 0x2
	// Bit mask of CHEN2 field.
	IPC_RECEIVE_CNF_CHEN2_Msk = 0x4
	// Bit CHEN2.
	IPC_RECEIVE_CNF_CHEN2 = 0x4
	// Disable events.
	IPC_RECEIVE_CNF_CHEN2_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN2_Enable = 0x1
	// Position of CHEN3 field.
	IPC_RECEIVE_CNF_CHEN3_Pos = 0x3
	// Bit mask of CHEN3 field.
	IPC_RECEIVE_CNF_CHEN3_Msk = 0x8
	// Bit CHEN3.
	IPC_RECEIVE_CNF_CHEN3 = 0x8
	// Disable events.
	IPC_RECEIVE_CNF_CHEN3_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN3_Enable = 0x1
	// Position of CHEN4 field.
	IPC_RECEIVE_CNF_CHEN4_Pos = 0x4
	// Bit mask of CHEN4 field.
	IPC_RECEIVE_CNF_CHEN4_Msk = 0x10
	// Bit CHEN4.
	IPC_RECEIVE_CNF_CHEN4 = 0x10
	// Disable events.
	IPC_RECEIVE_CNF_CHEN4_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN4_Enable = 0x1
	// Position of CHEN5 field.
	IPC_RECEIVE_CNF_CHEN5_Pos = 0x5
	// Bit mask of CHEN5 field.
	IPC_RECEIVE_CNF_CHEN5_Msk = 0x20
	// Bit CHEN5.
	IPC_RECEIVE_CNF_CHEN5 = 0x20
	// Disable events.
	IPC_RECEIVE_CNF_CHEN5_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN5_Enable = 0x1
	// Position of CHEN6 field.
	IPC_RECEIVE_CNF_CHEN6_Pos = 0x6
	// Bit mask of CHEN6 field.
	IPC_RECEIVE_CNF_CHEN6_Msk = 0x40
	// Bit CHEN6.
	IPC_RECEIVE_CNF_CHEN6 = 0x40
	// Disable events.
	IPC_RECEIVE_CNF_CHEN6_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN6_Enable = 0x1
	// Position of CHEN7 field.
	IPC_RECEIVE_CNF_CHEN7_Pos = 0x7
	// Bit mask of CHEN7 field.
	IPC_RECEIVE_CNF_CHEN7_Msk = 0x80
	// Bit CHEN7.
	IPC_RECEIVE_CNF_CHEN7 = 0x80
	// Disable events.
	IPC_RECEIVE_CNF_CHEN7_Disable = 0x0
	// Enable events.
	IPC_RECEIVE_CNF_CHEN7_Enable = 0x1

	// GPMEM: Description collection: General purpose memory.
	// Position of GPMEM field.
	IPC_GPMEM_GPMEM_Pos = 0x0
	// Bit mask of GPMEM field.
	IPC_GPMEM_GPMEM_Msk = 0xffffffff
)

// Constants for FPU_NS: FPU 0
const ()

// Constants for KMU_NS: Key management unit 0
const (
	// TASKS_PUSH_KEYSLOT: Push a key slot over secure APB
	// Position of TASKS_PUSH_KEYSLOT field.
	KMU_TASKS_PUSH_KEYSLOT_TASKS_PUSH_KEYSLOT_Pos = 0x0
	// Bit mask of TASKS_PUSH_KEYSLOT field.
	KMU_TASKS_PUSH_KEYSLOT_TASKS_PUSH_KEYSLOT_Msk = 0x1
	// Bit TASKS_PUSH_KEYSLOT.
	KMU_TASKS_PUSH_KEYSLOT_TASKS_PUSH_KEYSLOT = 0x1
	// Trigger task
	KMU_TASKS_PUSH_KEYSLOT_TASKS_PUSH_KEYSLOT_Trigger = 0x1

	// EVENTS_KEYSLOT_PUSHED: Key slot successfully pushed over secure APB
	// Position of EVENTS_KEYSLOT_PUSHED field.
	KMU_EVENTS_KEYSLOT_PUSHED_EVENTS_KEYSLOT_PUSHED_Pos = 0x0
	// Bit mask of EVENTS_KEYSLOT_PUSHED field.
	KMU_EVENTS_KEYSLOT_PUSHED_EVENTS_KEYSLOT_PUSHED_Msk = 0x1
	// Bit EVENTS_KEYSLOT_PUSHED.
	KMU_EVENTS_KEYSLOT_PUSHED_EVENTS_KEYSLOT_PUSHED = 0x1
	// Event not generated
	KMU_EVENTS_KEYSLOT_PUSHED_EVENTS_KEYSLOT_PUSHED_NotGenerated = 0x0
	// Event generated
	KMU_EVENTS_KEYSLOT_PUSHED_EVENTS_KEYSLOT_PUSHED_Generated = 0x1

	// EVENTS_KEYSLOT_REVOKED: Key slot has been revoked and cannot be tasked for selection
	// Position of EVENTS_KEYSLOT_REVOKED field.
	KMU_EVENTS_KEYSLOT_REVOKED_EVENTS_KEYSLOT_REVOKED_Pos = 0x0
	// Bit mask of EVENTS_KEYSLOT_REVOKED field.
	KMU_EVENTS_KEYSLOT_REVOKED_EVENTS_KEYSLOT_REVOKED_Msk = 0x1
	// Bit EVENTS_KEYSLOT_REVOKED.
	KMU_EVENTS_KEYSLOT_REVOKED_EVENTS_KEYSLOT_REVOKED = 0x1
	// Event not generated
	KMU_EVENTS_KEYSLOT_REVOKED_EVENTS_KEYSLOT_REVOKED_NotGenerated = 0x0
	// Event generated
	KMU_EVENTS_KEYSLOT_REVOKED_EVENTS_KEYSLOT_REVOKED_Generated = 0x1

	// EVENTS_KEYSLOT_ERROR: No key slot selected, no destination address defined, or error during push operation
	// Position of EVENTS_KEYSLOT_ERROR field.
	KMU_EVENTS_KEYSLOT_ERROR_EVENTS_KEYSLOT_ERROR_Pos = 0x0
	// Bit mask of EVENTS_KEYSLOT_ERROR field.
	KMU_EVENTS_KEYSLOT_ERROR_EVENTS_KEYSLOT_ERROR_Msk = 0x1
	// Bit EVENTS_KEYSLOT_ERROR.
	KMU_EVENTS_KEYSLOT_ERROR_EVENTS_KEYSLOT_ERROR = 0x1
	// Event not generated
	KMU_EVENTS_KEYSLOT_ERROR_EVENTS_KEYSLOT_ERROR_NotGenerated = 0x0
	// Event generated
	KMU_EVENTS_KEYSLOT_ERROR_EVENTS_KEYSLOT_ERROR_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of KEYSLOT_PUSHED field.
	KMU_INTEN_KEYSLOT_PUSHED_Pos = 0x0
	// Bit mask of KEYSLOT_PUSHED field.
	KMU_INTEN_KEYSLOT_PUSHED_Msk = 0x1
	// Bit KEYSLOT_PUSHED.
	KMU_INTEN_KEYSLOT_PUSHED = 0x1
	// Disable
	KMU_INTEN_KEYSLOT_PUSHED_Disabled = 0x0
	// Enable
	KMU_INTEN_KEYSLOT_PUSHED_Enabled = 0x1
	// Position of KEYSLOT_REVOKED field.
	KMU_INTEN_KEYSLOT_REVOKED_Pos = 0x1
	// Bit mask of KEYSLOT_REVOKED field.
	KMU_INTEN_KEYSLOT_REVOKED_Msk = 0x2
	// Bit KEYSLOT_REVOKED.
	KMU_INTEN_KEYSLOT_REVOKED = 0x2
	// Disable
	KMU_INTEN_KEYSLOT_REVOKED_Disabled = 0x0
	// Enable
	KMU_INTEN_KEYSLOT_REVOKED_Enabled = 0x1
	// Position of KEYSLOT_ERROR field.
	KMU_INTEN_KEYSLOT_ERROR_Pos = 0x2
	// Bit mask of KEYSLOT_ERROR field.
	KMU_INTEN_KEYSLOT_ERROR_Msk = 0x4
	// Bit KEYSLOT_ERROR.
	KMU_INTEN_KEYSLOT_ERROR = 0x4
	// Disable
	KMU_INTEN_KEYSLOT_ERROR_Disabled = 0x0
	// Enable
	KMU_INTEN_KEYSLOT_ERROR_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of KEYSLOT_PUSHED field.
	KMU_INTENSET_KEYSLOT_PUSHED_Pos = 0x0
	// Bit mask of KEYSLOT_PUSHED field.
	KMU_INTENSET_KEYSLOT_PUSHED_Msk = 0x1
	// Bit KEYSLOT_PUSHED.
	KMU_INTENSET_KEYSLOT_PUSHED = 0x1
	// Read: Disabled
	KMU_INTENSET_KEYSLOT_PUSHED_Disabled = 0x0
	// Read: Enabled
	KMU_INTENSET_KEYSLOT_PUSHED_Enabled = 0x1
	// Enable
	KMU_INTENSET_KEYSLOT_PUSHED_Set = 0x1
	// Position of KEYSLOT_REVOKED field.
	KMU_INTENSET_KEYSLOT_REVOKED_Pos = 0x1
	// Bit mask of KEYSLOT_REVOKED field.
	KMU_INTENSET_KEYSLOT_REVOKED_Msk = 0x2
	// Bit KEYSLOT_REVOKED.
	KMU_INTENSET_KEYSLOT_REVOKED = 0x2
	// Read: Disabled
	KMU_INTENSET_KEYSLOT_REVOKED_Disabled = 0x0
	// Read: Enabled
	KMU_INTENSET_KEYSLOT_REVOKED_Enabled = 0x1
	// Enable
	KMU_INTENSET_KEYSLOT_REVOKED_Set = 0x1
	// Position of KEYSLOT_ERROR field.
	KMU_INTENSET_KEYSLOT_ERROR_Pos = 0x2
	// Bit mask of KEYSLOT_ERROR field.
	KMU_INTENSET_KEYSLOT_ERROR_Msk = 0x4
	// Bit KEYSLOT_ERROR.
	KMU_INTENSET_KEYSLOT_ERROR = 0x4
	// Read: Disabled
	KMU_INTENSET_KEYSLOT_ERROR_Disabled = 0x0
	// Read: Enabled
	KMU_INTENSET_KEYSLOT_ERROR_Enabled = 0x1
	// Enable
	KMU_INTENSET_KEYSLOT_ERROR_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of KEYSLOT_PUSHED field.
	KMU_INTENCLR_KEYSLOT_PUSHED_Pos = 0x0
	// Bit mask of KEYSLOT_PUSHED field.
	KMU_INTENCLR_KEYSLOT_PUSHED_Msk = 0x1
	// Bit KEYSLOT_PUSHED.
	KMU_INTENCLR_KEYSLOT_PUSHED = 0x1
	// Read: Disabled
	KMU_INTENCLR_KEYSLOT_PUSHED_Disabled = 0x0
	// Read: Enabled
	KMU_INTENCLR_KEYSLOT_PUSHED_Enabled = 0x1
	// Disable
	KMU_INTENCLR_KEYSLOT_PUSHED_Clear = 0x1
	// Position of KEYSLOT_REVOKED field.
	KMU_INTENCLR_KEYSLOT_REVOKED_Pos = 0x1
	// Bit mask of KEYSLOT_REVOKED field.
	KMU_INTENCLR_KEYSLOT_REVOKED_Msk = 0x2
	// Bit KEYSLOT_REVOKED.
	KMU_INTENCLR_KEYSLOT_REVOKED = 0x2
	// Read: Disabled
	KMU_INTENCLR_KEYSLOT_REVOKED_Disabled = 0x0
	// Read: Enabled
	KMU_INTENCLR_KEYSLOT_REVOKED_Enabled = 0x1
	// Disable
	KMU_INTENCLR_KEYSLOT_REVOKED_Clear = 0x1
	// Position of KEYSLOT_ERROR field.
	KMU_INTENCLR_KEYSLOT_ERROR_Pos = 0x2
	// Bit mask of KEYSLOT_ERROR field.
	KMU_INTENCLR_KEYSLOT_ERROR_Msk = 0x4
	// Bit KEYSLOT_ERROR.
	KMU_INTENCLR_KEYSLOT_ERROR = 0x4
	// Read: Disabled
	KMU_INTENCLR_KEYSLOT_ERROR_Disabled = 0x0
	// Read: Enabled
	KMU_INTENCLR_KEYSLOT_ERROR_Enabled = 0x1
	// Disable
	KMU_INTENCLR_KEYSLOT_ERROR_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of KEYSLOT_PUSHED field.
	KMU_INTPEND_KEYSLOT_PUSHED_Pos = 0x0
	// Bit mask of KEYSLOT_PUSHED field.
	KMU_INTPEND_KEYSLOT_PUSHED_Msk = 0x1
	// Bit KEYSLOT_PUSHED.
	KMU_INTPEND_KEYSLOT_PUSHED = 0x1
	// Read: Not pending
	KMU_INTPEND_KEYSLOT_PUSHED_NotPending = 0x0
	// Read: Pending
	KMU_INTPEND_KEYSLOT_PUSHED_Pending = 0x1
	// Position of KEYSLOT_REVOKED field.
	KMU_INTPEND_KEYSLOT_REVOKED_Pos = 0x1
	// Bit mask of KEYSLOT_REVOKED field.
	KMU_INTPEND_KEYSLOT_REVOKED_Msk = 0x2
	// Bit KEYSLOT_REVOKED.
	KMU_INTPEND_KEYSLOT_REVOKED = 0x2
	// Read: Not pending
	KMU_INTPEND_KEYSLOT_REVOKED_NotPending = 0x0
	// Read: Pending
	KMU_INTPEND_KEYSLOT_REVOKED_Pending = 0x1
	// Position of KEYSLOT_ERROR field.
	KMU_INTPEND_KEYSLOT_ERROR_Pos = 0x2
	// Bit mask of KEYSLOT_ERROR field.
	KMU_INTPEND_KEYSLOT_ERROR_Msk = 0x4
	// Bit KEYSLOT_ERROR.
	KMU_INTPEND_KEYSLOT_ERROR = 0x4
	// Read: Not pending
	KMU_INTPEND_KEYSLOT_ERROR_NotPending = 0x0
	// Read: Pending
	KMU_INTPEND_KEYSLOT_ERROR_Pending = 0x1

	// STATUS: Status bits for KMU operation
	// Position of SELECTED field.
	KMU_STATUS_SELECTED_Pos = 0x0
	// Bit mask of SELECTED field.
	KMU_STATUS_SELECTED_Msk = 0x1
	// Bit SELECTED.
	KMU_STATUS_SELECTED = 0x1
	// No key slot ID selected by KMU
	KMU_STATUS_SELECTED_Disabled = 0x0
	// Key slot ID successfully selected by KMU
	KMU_STATUS_SELECTED_Enabled = 0x1
	// Position of BLOCKED field.
	KMU_STATUS_BLOCKED_Pos = 0x1
	// Bit mask of BLOCKED field.
	KMU_STATUS_BLOCKED_Msk = 0x2
	// Bit BLOCKED.
	KMU_STATUS_BLOCKED = 0x2
	// No access violation detected
	KMU_STATUS_BLOCKED_Disabled = 0x0
	// Access violation detected and blocked
	KMU_STATUS_BLOCKED_Enabled = 0x1

	// SELECTKEYSLOT: Select key slot to be read over AHB or pushed over secure APB when TASKS_PUSH_KEYSLOT is started
	// Position of ID field.
	KMU_SELECTKEYSLOT_ID_Pos = 0x0
	// Bit mask of ID field.
	KMU_SELECTKEYSLOT_ID_Msk = 0xff
)

// Constants for NVMC_NS: Non-volatile memory controller 0
const (
	// READY: Ready flag
	// Position of READY field.
	NVMC_READY_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMC_READY_READY_Msk = 0x1
	// Bit READY.
	NVMC_READY_READY = 0x1
	// NVMC is busy (on-going write or erase operation)
	NVMC_READY_READY_Busy = 0x0
	// NVMC is ready
	NVMC_READY_READY_Ready = 0x1

	// READYNEXT: Ready flag
	// Position of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Pos = 0x0
	// Bit mask of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Msk = 0x1
	// Bit READYNEXT.
	NVMC_READYNEXT_READYNEXT = 0x1
	// NVMC cannot accept any write operation
	NVMC_READYNEXT_READYNEXT_Busy = 0x0
	// NVMC is ready
	NVMC_READYNEXT_READYNEXT_Ready = 0x1

	// CONFIG: Configuration register
	// Position of WEN field.
	NVMC_CONFIG_WEN_Pos = 0x0
	// Bit mask of WEN field.
	NVMC_CONFIG_WEN_Msk = 0x7
	// Read only access
	NVMC_CONFIG_WEN_Ren = 0x0
	// Write enabled
	NVMC_CONFIG_WEN_Wen = 0x1
	// Erase enabled
	NVMC_CONFIG_WEN_Een = 0x2
	// Partial erase enabled
	NVMC_CONFIG_WEN_PEen = 0x4

	// ERASEALL: Register for erasing all non-volatile user memory
	// Position of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Pos = 0x0
	// Bit mask of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Msk = 0x1
	// Bit ERASEALL.
	NVMC_ERASEALL_ERASEALL = 0x1
	// No operation
	NVMC_ERASEALL_ERASEALL_NoOperation = 0x0
	// Start chip erase
	NVMC_ERASEALL_ERASEALL_Erase = 0x1

	// ERASEPAGEPARTIALCFG: Register for partial erase configuration
	// Position of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Pos = 0x0
	// Bit mask of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Msk = 0x7f

	// ICACHECNF: I-code cache configuration register
	// Position of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Pos = 0x0
	// Bit mask of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Msk = 0x1
	// Bit CACHEEN.
	NVMC_ICACHECNF_CACHEEN = 0x1
	// Disable cache. Invalidates all cache entries.
	NVMC_ICACHECNF_CACHEEN_Disabled = 0x0
	// Enable cache
	NVMC_ICACHECNF_CACHEEN_Enabled = 0x1
	// Position of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Pos = 0x8
	// Bit mask of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Msk = 0x100
	// Bit CACHEPROFEN.
	NVMC_ICACHECNF_CACHEPROFEN = 0x100
	// Disable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Disabled = 0x0
	// Enable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Enabled = 0x1

	// IHIT: I-code cache hit counter
	// Position of HITS field.
	NVMC_IHIT_HITS_Pos = 0x0
	// Bit mask of HITS field.
	NVMC_IHIT_HITS_Msk = 0xffffffff

	// IMISS: I-code cache miss counter
	// Position of MISSES field.
	NVMC_IMISS_MISSES_Pos = 0x0
	// Bit mask of MISSES field.
	NVMC_IMISS_MISSES_Msk = 0xffffffff

	// CONFIGNS: Unspecified
	// Position of WEN field.
	NVMC_CONFIGNS_WEN_Pos = 0x0
	// Bit mask of WEN field.
	NVMC_CONFIGNS_WEN_Msk = 0x3
	// Read only access
	NVMC_CONFIGNS_WEN_Ren = 0x0
	// Write enabled
	NVMC_CONFIGNS_WEN_Wen = 0x1
	// Erase enabled
	NVMC_CONFIGNS_WEN_Een = 0x2

	// WRITEUICRNS: Non-secure APPROTECT enable register
	// Position of SET field.
	NVMC_WRITEUICRNS_SET_Pos = 0x0
	// Bit mask of SET field.
	NVMC_WRITEUICRNS_SET_Msk = 0x1
	// Bit SET.
	NVMC_WRITEUICRNS_SET = 0x1
	// Set value
	NVMC_WRITEUICRNS_SET_Set = 0x1
	// Position of KEY field.
	NVMC_WRITEUICRNS_KEY_Pos = 0x4
	// Bit mask of KEY field.
	NVMC_WRITEUICRNS_KEY_Msk = 0xfffffff0
	// Key value
	NVMC_WRITEUICRNS_KEY_Keyvalid = 0xafbe5a7
)

// Constants for VMC_NS: Volatile Memory controller 0
const (
	// RAM.POWER: Description cluster: RAMn power control register
	// Position of S0POWER field.
	VMC_RAM_POWER_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWER_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWER_S0POWER = 0x1
	// Off
	VMC_RAM_POWER_S0POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S0POWER_On = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWER_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWER_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWER_S1POWER = 0x2
	// Off
	VMC_RAM_POWER_S1POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S1POWER_On = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWER_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWER_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWER_S2POWER = 0x4
	// Off
	VMC_RAM_POWER_S2POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S2POWER_On = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWER_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWER_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWER_S3POWER = 0x8
	// Off
	VMC_RAM_POWER_S3POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S3POWER_On = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWER_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWER_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWER_S0RETENTION = 0x10000
	// Off
	VMC_RAM_POWER_S0RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWER_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWER_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWER_S1RETENTION = 0x20000
	// Off
	VMC_RAM_POWER_S1RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWER_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWER_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWER_S2RETENTION = 0x40000
	// Off
	VMC_RAM_POWER_S2RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWER_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWER_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWER_S3RETENTION = 0x80000
	// Off
	VMC_RAM_POWER_S3RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S3RETENTION_On = 0x1

	// RAM.POWERSET: Description cluster: RAMn power control set register
	// Position of S0POWER field.
	VMC_RAM_POWERSET_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWERSET_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWERSET_S0POWER = 0x1
	// On
	VMC_RAM_POWERSET_S0POWER_On = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWERSET_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWERSET_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWERSET_S1POWER = 0x2
	// On
	VMC_RAM_POWERSET_S1POWER_On = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWERSET_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWERSET_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWERSET_S2POWER = 0x4
	// On
	VMC_RAM_POWERSET_S2POWER_On = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWERSET_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWERSET_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWERSET_S3POWER = 0x8
	// On
	VMC_RAM_POWERSET_S3POWER_On = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWERSET_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWERSET_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWERSET_S0RETENTION = 0x10000
	// On
	VMC_RAM_POWERSET_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWERSET_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWERSET_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWERSET_S1RETENTION = 0x20000
	// On
	VMC_RAM_POWERSET_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWERSET_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWERSET_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWERSET_S2RETENTION = 0x40000
	// On
	VMC_RAM_POWERSET_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWERSET_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWERSET_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWERSET_S3RETENTION = 0x80000
	// On
	VMC_RAM_POWERSET_S3RETENTION_On = 0x1

	// RAM.POWERCLR: Description cluster: RAMn power control clear register
	// Position of S0POWER field.
	VMC_RAM_POWERCLR_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWERCLR_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWERCLR_S0POWER = 0x1
	// Off
	VMC_RAM_POWERCLR_S0POWER_Off = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWERCLR_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWERCLR_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWERCLR_S1POWER = 0x2
	// Off
	VMC_RAM_POWERCLR_S1POWER_Off = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWERCLR_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWERCLR_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWERCLR_S2POWER = 0x4
	// Off
	VMC_RAM_POWERCLR_S2POWER_Off = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWERCLR_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWERCLR_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWERCLR_S3POWER = 0x8
	// Off
	VMC_RAM_POWERCLR_S3POWER_Off = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWERCLR_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWERCLR_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWERCLR_S0RETENTION = 0x10000
	// Off
	VMC_RAM_POWERCLR_S0RETENTION_Off = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWERCLR_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWERCLR_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWERCLR_S1RETENTION = 0x20000
	// Off
	VMC_RAM_POWERCLR_S1RETENTION_Off = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWERCLR_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWERCLR_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWERCLR_S2RETENTION = 0x40000
	// Off
	VMC_RAM_POWERCLR_S2RETENTION_Off = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWERCLR_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWERCLR_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWERCLR_S3RETENTION = 0x80000
	// Off
	VMC_RAM_POWERCLR_S3RETENTION_Off = 0x1
)

// Constants for CC_HOST_RGF_S: CRYPTOCELL HOST_RGF interface
const (
	// HOST_CRYPTOKEY_SEL: AES hardware key select
	// Position of HOST_CRYPTOKEY_SEL field.
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_Pos = 0x0
	// Bit mask of HOST_CRYPTOKEY_SEL field.
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_Msk = 0x3
	// Use device root key K_DR from CRYPTOCELL AO power domain
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_K_DR = 0x0
	// Use hard-coded RTL key K_PRTL
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_K_PRTL = 0x1
	// Use provided session key
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_Session = 0x2

	// HOST_IOT_KPRTL_LOCK: This write-once register is the K_PRTL lock register. When this register is set, K_PRTL cannot be used and a zeroed key will be used instead. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KPRTL_LOCK field.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Pos = 0x0
	// Bit mask of HOST_IOT_KPRTL_LOCK field.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Msk = 0x1
	// Bit HOST_IOT_KPRTL_LOCK.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK = 0x1
	// K_PRTL can be selected for use from register HOST_CRYPTOKEY_SEL
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Disabled = 0x0
	// K_PRTL has been locked until next power-on reset (POR). If K_PRTL is selected anyway, a zeroed key will be used instead.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Enabled = 0x1

	// HOST_IOT_KDR0: This register holds bits 31:0 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain. Reading from this address returns the K_DR valid status indicating if K_DR is successfully retained.
	// Position of HOST_IOT_KDR0 field.
	CC_HOST_RGF_HOST_IOT_KDR0_HOST_IOT_KDR0_Pos = 0x0
	// Bit mask of HOST_IOT_KDR0 field.
	CC_HOST_RGF_HOST_IOT_KDR0_HOST_IOT_KDR0_Msk = 0xffffffff

	// HOST_IOT_KDR1: This register holds bits 63:32 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KDR1 field.
	CC_HOST_RGF_HOST_IOT_KDR1_HOST_IOT_KDR1_Pos = 0x0
	// Bit mask of HOST_IOT_KDR1 field.
	CC_HOST_RGF_HOST_IOT_KDR1_HOST_IOT_KDR1_Msk = 0xffffffff

	// HOST_IOT_KDR2: This register holds bits 95:64 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KDR2 field.
	CC_HOST_RGF_HOST_IOT_KDR2_HOST_IOT_KDR2_Pos = 0x0
	// Bit mask of HOST_IOT_KDR2 field.
	CC_HOST_RGF_HOST_IOT_KDR2_HOST_IOT_KDR2_Msk = 0xffffffff

	// HOST_IOT_KDR3: This register holds bits 127:96 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KDR3 field.
	CC_HOST_RGF_HOST_IOT_KDR3_HOST_IOT_KDR3_Pos = 0x0
	// Bit mask of HOST_IOT_KDR3 field.
	CC_HOST_RGF_HOST_IOT_KDR3_HOST_IOT_KDR3_Msk = 0xffffffff

	// HOST_IOT_LCS: Controls lifecycle state (LCS) for CRYPTOCELL subsystem
	// Position of LCS field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Pos = 0x0
	// Bit mask of LCS field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Msk = 0x7
	// CC310 operates in debug mode
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Debug = 0x0
	// CC310 operates in secure mode
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Secure = 0x2
	// Position of LCS_IS_VALID field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Pos = 0x8
	// Bit mask of LCS_IS_VALID field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Msk = 0x100
	// Bit LCS_IS_VALID.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID = 0x100
	// Valid LCS not yet retained in the CRYPTOCELL AO power domain
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Invalid = 0x0
	// Valid LCS successfully retained in the CRYPTOCELL AO power domain
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Valid = 0x1
)

// Constants for CRYPTOCELL_S: ARM TrustZone CryptoCell register interface
const (
	// ENABLE: Enable CRYPTOCELL subsystem
	// Position of ENABLE field.
	CRYPTOCELL_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CRYPTOCELL_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	CRYPTOCELL_ENABLE_ENABLE = 0x1
	// CRYPTOCELL subsystem disabled
	CRYPTOCELL_ENABLE_ENABLE_Disabled = 0x0
	// CRYPTOCELL subsystem enabled.
	CRYPTOCELL_ENABLE_ENABLE_Enabled = 0x1
)

// Constants for P0_NS: GPIO Port 0
const (
	// OUT: Write GPIO port
	// Position of PIN0 field.
	GPIO_OUT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_PIN0 = 0x1
	// Pin driver is low
	GPIO_OUT_PIN0_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_OUT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_PIN1 = 0x2
	// Pin driver is low
	GPIO_OUT_PIN1_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_OUT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_PIN2 = 0x4
	// Pin driver is low
	GPIO_OUT_PIN2_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_OUT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_PIN3 = 0x8
	// Pin driver is low
	GPIO_OUT_PIN3_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_OUT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_PIN4 = 0x10
	// Pin driver is low
	GPIO_OUT_PIN4_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_OUT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_PIN5 = 0x20
	// Pin driver is low
	GPIO_OUT_PIN5_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_OUT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_PIN6 = 0x40
	// Pin driver is low
	GPIO_OUT_PIN6_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_OUT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_PIN7 = 0x80
	// Pin driver is low
	GPIO_OUT_PIN7_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_OUT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_PIN8 = 0x100
	// Pin driver is low
	GPIO_OUT_PIN8_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_OUT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_PIN9 = 0x200
	// Pin driver is low
	GPIO_OUT_PIN9_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_OUT_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUT_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUT_PIN10 = 0x400
	// Pin driver is low
	GPIO_OUT_PIN10_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_OUT_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUT_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUT_PIN11 = 0x800
	// Pin driver is low
	GPIO_OUT_PIN11_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_OUT_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUT_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUT_PIN12 = 0x1000
	// Pin driver is low
	GPIO_OUT_PIN12_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_OUT_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUT_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUT_PIN13 = 0x2000
	// Pin driver is low
	GPIO_OUT_PIN13_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_OUT_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUT_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUT_PIN14 = 0x4000
	// Pin driver is low
	GPIO_OUT_PIN14_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_OUT_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUT_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUT_PIN15 = 0x8000
	// Pin driver is low
	GPIO_OUT_PIN15_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_OUT_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUT_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUT_PIN16 = 0x10000
	// Pin driver is low
	GPIO_OUT_PIN16_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_OUT_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUT_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUT_PIN17 = 0x20000
	// Pin driver is low
	GPIO_OUT_PIN17_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_OUT_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUT_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUT_PIN18 = 0x40000
	// Pin driver is low
	GPIO_OUT_PIN18_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_OUT_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUT_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUT_PIN19 = 0x80000
	// Pin driver is low
	GPIO_OUT_PIN19_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_OUT_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUT_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUT_PIN20 = 0x100000
	// Pin driver is low
	GPIO_OUT_PIN20_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_OUT_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUT_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUT_PIN21 = 0x200000
	// Pin driver is low
	GPIO_OUT_PIN21_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_OUT_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUT_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUT_PIN22 = 0x400000
	// Pin driver is low
	GPIO_OUT_PIN22_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_OUT_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUT_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUT_PIN23 = 0x800000
	// Pin driver is low
	GPIO_OUT_PIN23_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_OUT_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUT_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUT_PIN24 = 0x1000000
	// Pin driver is low
	GPIO_OUT_PIN24_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_OUT_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUT_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUT_PIN25 = 0x2000000
	// Pin driver is low
	GPIO_OUT_PIN25_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_OUT_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUT_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUT_PIN26 = 0x4000000
	// Pin driver is low
	GPIO_OUT_PIN26_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_OUT_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUT_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUT_PIN27 = 0x8000000
	// Pin driver is low
	GPIO_OUT_PIN27_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_OUT_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUT_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUT_PIN28 = 0x10000000
	// Pin driver is low
	GPIO_OUT_PIN28_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_OUT_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUT_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUT_PIN29 = 0x20000000
	// Pin driver is low
	GPIO_OUT_PIN29_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_OUT_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUT_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUT_PIN30 = 0x40000000
	// Pin driver is low
	GPIO_OUT_PIN30_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_OUT_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUT_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUT_PIN31 = 0x80000000
	// Pin driver is low
	GPIO_OUT_PIN31_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN31_High = 0x1

	// OUTSET: Set individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTSET_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTSET_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN0_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_OUTSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTSET_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTSET_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN1_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_OUTSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTSET_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTSET_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN2_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_OUTSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTSET_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTSET_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN3_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_OUTSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTSET_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTSET_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN4_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_OUTSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTSET_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTSET_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN5_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_OUTSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTSET_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTSET_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN6_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_OUTSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTSET_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTSET_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN7_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_OUTSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTSET_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTSET_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN8_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_OUTSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTSET_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTSET_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN9_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_OUTSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTSET_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTSET_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN10_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_OUTSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTSET_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTSET_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN11_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_OUTSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTSET_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTSET_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN12_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_OUTSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTSET_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTSET_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN13_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_OUTSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTSET_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTSET_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN14_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_OUTSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTSET_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTSET_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN15_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_OUTSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTSET_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTSET_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN16_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_OUTSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTSET_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTSET_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN17_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_OUTSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTSET_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTSET_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN18_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_OUTSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTSET_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTSET_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN19_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_OUTSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTSET_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTSET_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN20_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_OUTSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTSET_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTSET_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN21_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_OUTSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTSET_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTSET_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN22_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_OUTSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTSET_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTSET_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN23_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_OUTSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTSET_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN24_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_OUTSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTSET_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN25_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_OUTSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTSET_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN26_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_OUTSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTSET_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN27_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_OUTSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTSET_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN28_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_OUTSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTSET_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN29_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_OUTSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTSET_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN30_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_OUTSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTSET_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN31_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN31_Set = 0x1

	// OUTCLR: Clear individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTCLR_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTCLR_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN0_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_OUTCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTCLR_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTCLR_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN1_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_OUTCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTCLR_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTCLR_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN2_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_OUTCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTCLR_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTCLR_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN3_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_OUTCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTCLR_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTCLR_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN4_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_OUTCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTCLR_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTCLR_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN5_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_OUTCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTCLR_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTCLR_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN6_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_OUTCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTCLR_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTCLR_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN7_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_OUTCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTCLR_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTCLR_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN8_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_OUTCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTCLR_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTCLR_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN9_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_OUTCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTCLR_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTCLR_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN10_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_OUTCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTCLR_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTCLR_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN11_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_OUTCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTCLR_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN12_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_OUTCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTCLR_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN13_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_OUTCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTCLR_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN14_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_OUTCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTCLR_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN15_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_OUTCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTCLR_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN16_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_OUTCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTCLR_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN17_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_OUTCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTCLR_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN18_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_OUTCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTCLR_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN19_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_OUTCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTCLR_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN20_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_OUTCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTCLR_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN21_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_OUTCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTCLR_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN22_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_OUTCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTCLR_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN23_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_OUTCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTCLR_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN24_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_OUTCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTCLR_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN25_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_OUTCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTCLR_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN26_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_OUTCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTCLR_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN27_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_OUTCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTCLR_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN28_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_OUTCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTCLR_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN29_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_OUTCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTCLR_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN30_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_OUTCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTCLR_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN31_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN31_Clear = 0x1

	// IN: Read GPIO port
	// Position of PIN0 field.
	GPIO_IN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IN_PIN0 = 0x1
	// Pin input is low
	GPIO_IN_PIN0_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_IN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IN_PIN1 = 0x2
	// Pin input is low
	GPIO_IN_PIN1_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_IN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IN_PIN2 = 0x4
	// Pin input is low
	GPIO_IN_PIN2_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_IN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IN_PIN3 = 0x8
	// Pin input is low
	GPIO_IN_PIN3_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_IN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IN_PIN4 = 0x10
	// Pin input is low
	GPIO_IN_PIN4_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_IN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IN_PIN5 = 0x20
	// Pin input is low
	GPIO_IN_PIN5_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_IN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IN_PIN6 = 0x40
	// Pin input is low
	GPIO_IN_PIN6_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_IN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IN_PIN7 = 0x80
	// Pin input is low
	GPIO_IN_PIN7_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_IN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IN_PIN8 = 0x100
	// Pin input is low
	GPIO_IN_PIN8_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_IN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IN_PIN9 = 0x200
	// Pin input is low
	GPIO_IN_PIN9_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_IN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IN_PIN10 = 0x400
	// Pin input is low
	GPIO_IN_PIN10_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_IN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IN_PIN11 = 0x800
	// Pin input is low
	GPIO_IN_PIN11_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_IN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IN_PIN12 = 0x1000
	// Pin input is low
	GPIO_IN_PIN12_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_IN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IN_PIN13 = 0x2000
	// Pin input is low
	GPIO_IN_PIN13_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_IN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IN_PIN14 = 0x4000
	// Pin input is low
	GPIO_IN_PIN14_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_IN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IN_PIN15 = 0x8000
	// Pin input is low
	GPIO_IN_PIN15_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_IN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IN_PIN16 = 0x10000
	// Pin input is low
	GPIO_IN_PIN16_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_IN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IN_PIN17 = 0x20000
	// Pin input is low
	GPIO_IN_PIN17_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_IN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IN_PIN18 = 0x40000
	// Pin input is low
	GPIO_IN_PIN18_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_IN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IN_PIN19 = 0x80000
	// Pin input is low
	GPIO_IN_PIN19_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_IN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IN_PIN20 = 0x100000
	// Pin input is low
	GPIO_IN_PIN20_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_IN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IN_PIN21 = 0x200000
	// Pin input is low
	GPIO_IN_PIN21_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_IN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IN_PIN22 = 0x400000
	// Pin input is low
	GPIO_IN_PIN22_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_IN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IN_PIN23 = 0x800000
	// Pin input is low
	GPIO_IN_PIN23_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_IN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IN_PIN24 = 0x1000000
	// Pin input is low
	GPIO_IN_PIN24_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_IN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IN_PIN25 = 0x2000000
	// Pin input is low
	GPIO_IN_PIN25_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_IN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IN_PIN26 = 0x4000000
	// Pin input is low
	GPIO_IN_PIN26_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_IN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IN_PIN27 = 0x8000000
	// Pin input is low
	GPIO_IN_PIN27_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_IN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IN_PIN28 = 0x10000000
	// Pin input is low
	GPIO_IN_PIN28_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_IN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IN_PIN29 = 0x20000000
	// Pin input is low
	GPIO_IN_PIN29_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_IN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IN_PIN30 = 0x40000000
	// Pin input is low
	GPIO_IN_PIN30_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_IN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IN_PIN31 = 0x80000000
	// Pin input is low
	GPIO_IN_PIN31_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN31_High = 0x1

	// DIR: Direction of GPIO pins
	// Position of PIN0 field.
	GPIO_DIR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIR_PIN0 = 0x1
	// Pin set as input
	GPIO_DIR_PIN0_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN0_Output = 0x1
	// Position of PIN1 field.
	GPIO_DIR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIR_PIN1 = 0x2
	// Pin set as input
	GPIO_DIR_PIN1_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN1_Output = 0x1
	// Position of PIN2 field.
	GPIO_DIR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIR_PIN2 = 0x4
	// Pin set as input
	GPIO_DIR_PIN2_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN2_Output = 0x1
	// Position of PIN3 field.
	GPIO_DIR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIR_PIN3 = 0x8
	// Pin set as input
	GPIO_DIR_PIN3_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN3_Output = 0x1
	// Position of PIN4 field.
	GPIO_DIR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIR_PIN4 = 0x10
	// Pin set as input
	GPIO_DIR_PIN4_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN4_Output = 0x1
	// Position of PIN5 field.
	GPIO_DIR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIR_PIN5 = 0x20
	// Pin set as input
	GPIO_DIR_PIN5_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN5_Output = 0x1
	// Position of PIN6 field.
	GPIO_DIR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIR_PIN6 = 0x40
	// Pin set as input
	GPIO_DIR_PIN6_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN6_Output = 0x1
	// Position of PIN7 field.
	GPIO_DIR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIR_PIN7 = 0x80
	// Pin set as input
	GPIO_DIR_PIN7_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN7_Output = 0x1
	// Position of PIN8 field.
	GPIO_DIR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIR_PIN8 = 0x100
	// Pin set as input
	GPIO_DIR_PIN8_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN8_Output = 0x1
	// Position of PIN9 field.
	GPIO_DIR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIR_PIN9 = 0x200
	// Pin set as input
	GPIO_DIR_PIN9_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN9_Output = 0x1
	// Position of PIN10 field.
	GPIO_DIR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIR_PIN10 = 0x400
	// Pin set as input
	GPIO_DIR_PIN10_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN10_Output = 0x1
	// Position of PIN11 field.
	GPIO_DIR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIR_PIN11 = 0x800
	// Pin set as input
	GPIO_DIR_PIN11_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN11_Output = 0x1
	// Position of PIN12 field.
	GPIO_DIR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIR_PIN12 = 0x1000
	// Pin set as input
	GPIO_DIR_PIN12_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN12_Output = 0x1
	// Position of PIN13 field.
	GPIO_DIR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIR_PIN13 = 0x2000
	// Pin set as input
	GPIO_DIR_PIN13_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN13_Output = 0x1
	// Position of PIN14 field.
	GPIO_DIR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIR_PIN14 = 0x4000
	// Pin set as input
	GPIO_DIR_PIN14_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN14_Output = 0x1
	// Position of PIN15 field.
	GPIO_DIR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIR_PIN15 = 0x8000
	// Pin set as input
	GPIO_DIR_PIN15_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN15_Output = 0x1
	// Position of PIN16 field.
	GPIO_DIR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIR_PIN16 = 0x10000
	// Pin set as input
	GPIO_DIR_PIN16_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN16_Output = 0x1
	// Position of PIN17 field.
	GPIO_DIR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIR_PIN17 = 0x20000
	// Pin set as input
	GPIO_DIR_PIN17_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN17_Output = 0x1
	// Position of PIN18 field.
	GPIO_DIR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIR_PIN18 = 0x40000
	// Pin set as input
	GPIO_DIR_PIN18_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN18_Output = 0x1
	// Position of PIN19 field.
	GPIO_DIR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIR_PIN19 = 0x80000
	// Pin set as input
	GPIO_DIR_PIN19_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN19_Output = 0x1
	// Position of PIN20 field.
	GPIO_DIR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIR_PIN20 = 0x100000
	// Pin set as input
	GPIO_DIR_PIN20_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN20_Output = 0x1
	// Position of PIN21 field.
	GPIO_DIR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIR_PIN21 = 0x200000
	// Pin set as input
	GPIO_DIR_PIN21_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN21_Output = 0x1
	// Position of PIN22 field.
	GPIO_DIR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIR_PIN22 = 0x400000
	// Pin set as input
	GPIO_DIR_PIN22_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN22_Output = 0x1
	// Position of PIN23 field.
	GPIO_DIR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIR_PIN23 = 0x800000
	// Pin set as input
	GPIO_DIR_PIN23_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN23_Output = 0x1
	// Position of PIN24 field.
	GPIO_DIR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIR_PIN24 = 0x1000000
	// Pin set as input
	GPIO_DIR_PIN24_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN24_Output = 0x1
	// Position of PIN25 field.
	GPIO_DIR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIR_PIN25 = 0x2000000
	// Pin set as input
	GPIO_DIR_PIN25_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN25_Output = 0x1
	// Position of PIN26 field.
	GPIO_DIR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIR_PIN26 = 0x4000000
	// Pin set as input
	GPIO_DIR_PIN26_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN26_Output = 0x1
	// Position of PIN27 field.
	GPIO_DIR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIR_PIN27 = 0x8000000
	// Pin set as input
	GPIO_DIR_PIN27_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN27_Output = 0x1
	// Position of PIN28 field.
	GPIO_DIR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIR_PIN28 = 0x10000000
	// Pin set as input
	GPIO_DIR_PIN28_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN28_Output = 0x1
	// Position of PIN29 field.
	GPIO_DIR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIR_PIN29 = 0x20000000
	// Pin set as input
	GPIO_DIR_PIN29_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN29_Output = 0x1
	// Position of PIN30 field.
	GPIO_DIR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIR_PIN30 = 0x40000000
	// Pin set as input
	GPIO_DIR_PIN30_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN30_Output = 0x1
	// Position of PIN31 field.
	GPIO_DIR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIR_PIN31 = 0x80000000
	// Pin set as input
	GPIO_DIR_PIN31_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN31_Output = 0x1

	// DIRSET: DIR set register
	// Position of PIN0 field.
	GPIO_DIRSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRSET_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRSET_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_DIRSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRSET_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRSET_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_DIRSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRSET_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRSET_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_DIRSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRSET_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRSET_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_DIRSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRSET_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRSET_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_DIRSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRSET_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRSET_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_DIRSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRSET_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRSET_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_DIRSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRSET_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRSET_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_DIRSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRSET_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRSET_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_DIRSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRSET_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRSET_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_DIRSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRSET_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRSET_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_DIRSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRSET_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRSET_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_DIRSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRSET_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRSET_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_DIRSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRSET_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRSET_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_DIRSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRSET_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRSET_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_DIRSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRSET_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRSET_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_DIRSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRSET_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRSET_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_DIRSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRSET_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRSET_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_DIRSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRSET_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRSET_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_DIRSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRSET_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRSET_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_DIRSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRSET_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRSET_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_DIRSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRSET_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRSET_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_DIRSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRSET_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRSET_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_DIRSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRSET_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRSET_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_DIRSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRSET_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRSET_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_DIRSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRSET_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRSET_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_DIRSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRSET_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRSET_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_DIRSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRSET_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRSET_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_DIRSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRSET_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRSET_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_DIRSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRSET_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRSET_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_DIRSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRSET_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRSET_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_DIRSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRSET_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRSET_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN31_Set = 0x1

	// DIRCLR: DIR clear register
	// Position of PIN0 field.
	GPIO_DIRCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRCLR_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRCLR_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_DIRCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRCLR_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRCLR_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_DIRCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRCLR_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRCLR_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_DIRCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRCLR_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRCLR_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_DIRCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRCLR_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRCLR_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_DIRCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRCLR_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRCLR_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_DIRCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRCLR_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRCLR_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_DIRCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRCLR_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRCLR_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_DIRCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRCLR_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRCLR_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_DIRCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRCLR_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRCLR_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_DIRCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRCLR_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRCLR_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_DIRCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRCLR_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRCLR_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_DIRCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRCLR_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRCLR_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_DIRCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRCLR_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRCLR_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_DIRCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRCLR_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRCLR_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_DIRCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRCLR_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRCLR_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_DIRCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRCLR_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRCLR_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_DIRCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRCLR_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRCLR_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_DIRCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRCLR_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRCLR_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_DIRCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRCLR_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRCLR_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_DIRCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRCLR_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRCLR_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_DIRCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRCLR_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRCLR_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_DIRCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRCLR_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRCLR_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_DIRCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRCLR_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRCLR_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_DIRCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRCLR_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_DIRCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRCLR_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_DIRCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRCLR_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_DIRCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRCLR_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_DIRCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRCLR_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_DIRCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRCLR_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_DIRCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRCLR_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_DIRCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRCLR_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN31_Clear = 0x1

	// LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
	// Position of PIN0 field.
	GPIO_LATCH_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_LATCH_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_LATCH_PIN0 = 0x1
	// Criteria has not been met
	GPIO_LATCH_PIN0_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN0_Latched = 0x1
	// Position of PIN1 field.
	GPIO_LATCH_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_LATCH_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_LATCH_PIN1 = 0x2
	// Criteria has not been met
	GPIO_LATCH_PIN1_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN1_Latched = 0x1
	// Position of PIN2 field.
	GPIO_LATCH_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_LATCH_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_LATCH_PIN2 = 0x4
	// Criteria has not been met
	GPIO_LATCH_PIN2_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN2_Latched = 0x1
	// Position of PIN3 field.
	GPIO_LATCH_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_LATCH_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_LATCH_PIN3 = 0x8
	// Criteria has not been met
	GPIO_LATCH_PIN3_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN3_Latched = 0x1
	// Position of PIN4 field.
	GPIO_LATCH_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_LATCH_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_LATCH_PIN4 = 0x10
	// Criteria has not been met
	GPIO_LATCH_PIN4_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN4_Latched = 0x1
	// Position of PIN5 field.
	GPIO_LATCH_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_LATCH_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_LATCH_PIN5 = 0x20
	// Criteria has not been met
	GPIO_LATCH_PIN5_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN5_Latched = 0x1
	// Position of PIN6 field.
	GPIO_LATCH_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_LATCH_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_LATCH_PIN6 = 0x40
	// Criteria has not been met
	GPIO_LATCH_PIN6_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN6_Latched = 0x1
	// Position of PIN7 field.
	GPIO_LATCH_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_LATCH_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_LATCH_PIN7 = 0x80
	// Criteria has not been met
	GPIO_LATCH_PIN7_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN7_Latched = 0x1
	// Position of PIN8 field.
	GPIO_LATCH_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_LATCH_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_LATCH_PIN8 = 0x100
	// Criteria has not been met
	GPIO_LATCH_PIN8_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN8_Latched = 0x1
	// Position of PIN9 field.
	GPIO_LATCH_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_LATCH_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_LATCH_PIN9 = 0x200
	// Criteria has not been met
	GPIO_LATCH_PIN9_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN9_Latched = 0x1
	// Position of PIN10 field.
	GPIO_LATCH_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_LATCH_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_LATCH_PIN10 = 0x400
	// Criteria has not been met
	GPIO_LATCH_PIN10_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN10_Latched = 0x1
	// Position of PIN11 field.
	GPIO_LATCH_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_LATCH_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_LATCH_PIN11 = 0x800
	// Criteria has not been met
	GPIO_LATCH_PIN11_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN11_Latched = 0x1
	// Position of PIN12 field.
	GPIO_LATCH_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_LATCH_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_LATCH_PIN12 = 0x1000
	// Criteria has not been met
	GPIO_LATCH_PIN12_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN12_Latched = 0x1
	// Position of PIN13 field.
	GPIO_LATCH_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_LATCH_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_LATCH_PIN13 = 0x2000
	// Criteria has not been met
	GPIO_LATCH_PIN13_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN13_Latched = 0x1
	// Position of PIN14 field.
	GPIO_LATCH_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_LATCH_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_LATCH_PIN14 = 0x4000
	// Criteria has not been met
	GPIO_LATCH_PIN14_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN14_Latched = 0x1
	// Position of PIN15 field.
	GPIO_LATCH_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_LATCH_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_LATCH_PIN15 = 0x8000
	// Criteria has not been met
	GPIO_LATCH_PIN15_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN15_Latched = 0x1
	// Position of PIN16 field.
	GPIO_LATCH_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_LATCH_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_LATCH_PIN16 = 0x10000
	// Criteria has not been met
	GPIO_LATCH_PIN16_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN16_Latched = 0x1
	// Position of PIN17 field.
	GPIO_LATCH_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_LATCH_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_LATCH_PIN17 = 0x20000
	// Criteria has not been met
	GPIO_LATCH_PIN17_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN17_Latched = 0x1
	// Position of PIN18 field.
	GPIO_LATCH_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_LATCH_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_LATCH_PIN18 = 0x40000
	// Criteria has not been met
	GPIO_LATCH_PIN18_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN18_Latched = 0x1
	// Position of PIN19 field.
	GPIO_LATCH_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_LATCH_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_LATCH_PIN19 = 0x80000
	// Criteria has not been met
	GPIO_LATCH_PIN19_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN19_Latched = 0x1
	// Position of PIN20 field.
	GPIO_LATCH_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_LATCH_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_LATCH_PIN20 = 0x100000
	// Criteria has not been met
	GPIO_LATCH_PIN20_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN20_Latched = 0x1
	// Position of PIN21 field.
	GPIO_LATCH_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_LATCH_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_LATCH_PIN21 = 0x200000
	// Criteria has not been met
	GPIO_LATCH_PIN21_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN21_Latched = 0x1
	// Position of PIN22 field.
	GPIO_LATCH_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_LATCH_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_LATCH_PIN22 = 0x400000
	// Criteria has not been met
	GPIO_LATCH_PIN22_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN22_Latched = 0x1
	// Position of PIN23 field.
	GPIO_LATCH_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_LATCH_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_LATCH_PIN23 = 0x800000
	// Criteria has not been met
	GPIO_LATCH_PIN23_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN23_Latched = 0x1
	// Position of PIN24 field.
	GPIO_LATCH_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_LATCH_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_LATCH_PIN24 = 0x1000000
	// Criteria has not been met
	GPIO_LATCH_PIN24_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN24_Latched = 0x1
	// Position of PIN25 field.
	GPIO_LATCH_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_LATCH_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_LATCH_PIN25 = 0x2000000
	// Criteria has not been met
	GPIO_LATCH_PIN25_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN25_Latched = 0x1
	// Position of PIN26 field.
	GPIO_LATCH_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_LATCH_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_LATCH_PIN26 = 0x4000000
	// Criteria has not been met
	GPIO_LATCH_PIN26_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN26_Latched = 0x1
	// Position of PIN27 field.
	GPIO_LATCH_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_LATCH_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_LATCH_PIN27 = 0x8000000
	// Criteria has not been met
	GPIO_LATCH_PIN27_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN27_Latched = 0x1
	// Position of PIN28 field.
	GPIO_LATCH_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_LATCH_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_LATCH_PIN28 = 0x10000000
	// Criteria has not been met
	GPIO_LATCH_PIN28_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN28_Latched = 0x1
	// Position of PIN29 field.
	GPIO_LATCH_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_LATCH_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_LATCH_PIN29 = 0x20000000
	// Criteria has not been met
	GPIO_LATCH_PIN29_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN29_Latched = 0x1
	// Position of PIN30 field.
	GPIO_LATCH_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_LATCH_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_LATCH_PIN30 = 0x40000000
	// Criteria has not been met
	GPIO_LATCH_PIN30_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN30_Latched = 0x1
	// Position of PIN31 field.
	GPIO_LATCH_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_LATCH_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_LATCH_PIN31 = 0x80000000
	// Criteria has not been met
	GPIO_LATCH_PIN31_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN31_Latched = 0x1

	// DETECTMODE: Select between default DETECT signal behavior and LDETECT mode (For non-secure pin only)
	// Position of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Pos = 0x0
	// Bit mask of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Msk = 0x1
	// Bit DETECTMODE.
	GPIO_DETECTMODE_DETECTMODE = 0x1
	// DETECT directly connected to PIN DETECT signals
	GPIO_DETECTMODE_DETECTMODE_Default = 0x0
	// Use the latched LDETECT behavior
	GPIO_DETECTMODE_DETECTMODE_LDETECT = 0x1

	// DETECTMODE_SEC: Select between default DETECT signal behavior and LDETECT mode (For secure pin only)
	// Position of DETECTMODE field.
	GPIO_DETECTMODE_SEC_DETECTMODE_Pos = 0x0
	// Bit mask of DETECTMODE field.
	GPIO_DETECTMODE_SEC_DETECTMODE_Msk = 0x1
	// Bit DETECTMODE.
	GPIO_DETECTMODE_SEC_DETECTMODE = 0x1
	// DETECT directly connected to PIN DETECT signals
	GPIO_DETECTMODE_SEC_DETECTMODE_Default = 0x0
	// Use the latched LDETECT behavior
	GPIO_DETECTMODE_SEC_DETECTMODE_LDETECT = 0x1

	// PIN_CNF: Description collection: Configuration of GPIO pins
	// Position of DIR field.
	GPIO_PIN_CNF_DIR_Pos = 0x0
	// Bit mask of DIR field.
	GPIO_PIN_CNF_DIR_Msk = 0x1
	// Bit DIR.
	GPIO_PIN_CNF_DIR = 0x1
	// Configure pin as an input pin
	GPIO_PIN_CNF_DIR_Input = 0x0
	// Configure pin as an output pin
	GPIO_PIN_CNF_DIR_Output = 0x1
	// Position of INPUT field.
	GPIO_PIN_CNF_INPUT_Pos = 0x1
	// Bit mask of INPUT field.
	GPIO_PIN_CNF_INPUT_Msk = 0x2
	// Bit INPUT.
	GPIO_PIN_CNF_INPUT = 0x2
	// Connect input buffer
	GPIO_PIN_CNF_INPUT_Connect = 0x0
	// Disconnect input buffer
	GPIO_PIN_CNF_INPUT_Disconnect = 0x1
	// Position of PULL field.
	GPIO_PIN_CNF_PULL_Pos = 0x2
	// Bit mask of PULL field.
	GPIO_PIN_CNF_PULL_Msk = 0xc
	// No pull
	GPIO_PIN_CNF_PULL_Disabled = 0x0
	// Pull down on pin
	GPIO_PIN_CNF_PULL_Pulldown = 0x1
	// Pull up on pin
	GPIO_PIN_CNF_PULL_Pullup = 0x3
	// Position of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Pos = 0x8
	// Bit mask of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Msk = 0x700
	// Standard '0', standard '1'
	GPIO_PIN_CNF_DRIVE_S0S1 = 0x0
	// High drive '0', standard '1'
	GPIO_PIN_CNF_DRIVE_H0S1 = 0x1
	// Standard '0', high drive '1'
	GPIO_PIN_CNF_DRIVE_S0H1 = 0x2
	// High drive '0', high 'drive '1''
	GPIO_PIN_CNF_DRIVE_H0H1 = 0x3
	// Disconnect '0', standard '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0S1 = 0x4
	// Disconnect '0', high drive '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0H1 = 0x5
	// Standard '0', disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_S0D1 = 0x6
	// High drive '0', disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_H0D1 = 0x7
	// Position of SENSE field.
	GPIO_PIN_CNF_SENSE_Pos = 0x10
	// Bit mask of SENSE field.
	GPIO_PIN_CNF_SENSE_Msk = 0x30000
	// Disabled
	GPIO_PIN_CNF_SENSE_Disabled = 0x0
	// Sense for high level
	GPIO_PIN_CNF_SENSE_High = 0x2
	// Sense for low level
	GPIO_PIN_CNF_SENSE_Low = 0x3
)
