/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Cursor;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;
import java.util.ArrayList;

public class ServerParams {
    private static final int subsampleUndefined = -1;
    private static final int subsampleNone = 0;
    private static final int subsampleGray = 1;
    private static final int subsample2X = 2;
    private static final int subsample4X = 3;
    private static final int subsample8X = 4;
    private static final int subsample16X = 5;
    public int majorVersion = 0;
    public int minorVersion = 0;
    public boolean useCopyRect = false;
    public boolean supportsLocalCursor = false;
    public boolean supportsLocalXCursor = false;
    public boolean supportsLocalCursorWithAlpha = false;
    public boolean supportsDesktopResize = false;
    public boolean supportsExtendedDesktopSize = false;
    public boolean supportsDesktopRename = false;
    public boolean supportsLastRect = false;
    public boolean supportsClientRedirect = false;
    public boolean supportsSetDesktopSize = false;
    public boolean supportsFence = false;
    public boolean supportsContinuousUpdates = false;
    public int compressLevel = 6;
    public int qualityLevel = -1;
    public int fineQualityLevel = -1;
    public int subsampling = -1;
    private int width_ = 0;
    private int height_ = 0;
    private ScreenSet screenLayout_;
    private PixelFormat pf_;
    private String name_ = null;
    private Cursor cursor_;
    private ArrayList encodings_ = new ArrayList();
    private StringBuilder verStr;
    private int verStrPos = 0;

    public ServerParams() {
        this.screenLayout_ = new ScreenSet();
        this.setName("");
    }

    public void setVersion(int n, int n2) {
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public boolean isVersion(int n, int n2) {
        return this.majorVersion == n && this.minorVersion == n2;
    }

    public boolean beforeVersion(int n, int n2) {
        return this.majorVersion < n || this.majorVersion == n && this.minorVersion < n2;
    }

    public boolean afterVersion(int n, int n2) {
        return !this.beforeVersion(n, n2 + 1);
    }

    public int width() {
        return this.width_;
    }

    public int height() {
        return this.height_;
    }

    public ScreenSet screenLayout() {
        return this.screenLayout_;
    }

    public void setDimensions(int n, int n2) {
        ScreenSet screenSet = new ScreenSet();
        screenSet.add_screen(new Screen(0, 0, 0, n, n2, 0));
        this.setDimensions(n, n2, screenSet);
    }

    public void setDimensions(int n, int n2, ScreenSet screenSet) {
        if (!screenSet.validate(n, n2)) {
            throw new Exception("Attempted to configure an invalid screen layout");
        }
        this.width_ = n;
        this.height_ = n2;
        this.screenLayout_ = screenSet;
    }

    public PixelFormat pf() {
        return this.pf_;
    }

    public void setPF(PixelFormat pixelFormat) {
        this.pf_ = pixelFormat;
        if (pixelFormat.bpp != 8 && pixelFormat.bpp != 16 && pixelFormat.bpp != 32) {
            throw new Exception("setPF: not 8, 16 or 32 bpp?");
        }
    }

    public String name() {
        return this.name_;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public boolean supportsEncoding(int n) {
        return this.encodings_.indexOf(n) != -1;
    }

    public void setEncodings(int n, int[] nArray) {
        this.useCopyRect = false;
        this.supportsLocalCursor = false;
        this.supportsLocalCursorWithAlpha = false;
        this.supportsDesktopResize = false;
        this.supportsExtendedDesktopSize = false;
        this.supportsLocalXCursor = false;
        this.supportsLastRect = false;
        this.compressLevel = -1;
        this.qualityLevel = -1;
        this.fineQualityLevel = -1;
        this.subsampling = -1;
        this.encodings_.clear();
        this.encodings_.add(0);
        for (int i = n - 1; i >= 0; --i) {
            switch (nArray[i]) {
                case 1: {
                    this.useCopyRect = true;
                    break;
                }
                case -239: {
                    this.supportsLocalCursor = true;
                    break;
                }
                case -240: {
                    this.supportsLocalXCursor = true;
                    break;
                }
                case -314: {
                    this.supportsLocalCursorWithAlpha = true;
                    break;
                }
                case -223: {
                    this.supportsDesktopResize = true;
                    break;
                }
                case -308: {
                    this.supportsExtendedDesktopSize = true;
                    break;
                }
                case -307: {
                    this.supportsDesktopRename = true;
                    break;
                }
                case -224: {
                    this.supportsLastRect = true;
                    break;
                }
                case -312: {
                    this.supportsFence = true;
                    break;
                }
                case -313: {
                    this.supportsContinuousUpdates = true;
                    break;
                }
                case -311: {
                    this.supportsClientRedirect = true;
                    break;
                }
                case -768: {
                    this.subsampling = 0;
                    break;
                }
                case -765: {
                    this.subsampling = 1;
                    break;
                }
                case -766: {
                    this.subsampling = 2;
                    break;
                }
                case -767: {
                    this.subsampling = 3;
                    break;
                }
                case -764: {
                    this.subsampling = 4;
                    break;
                }
                case -763: {
                    this.subsampling = 5;
                }
            }
            if (nArray[i] >= -256 && nArray[i] <= -247) {
                this.compressLevel = nArray[i] - -256;
            }
            if (nArray[i] >= -32 && nArray[i] <= -23) {
                this.qualityLevel = nArray[i] - -32;
            }
            if (nArray[i] >= -512 && nArray[i] <= -412) {
                this.fineQualityLevel = nArray[i] - -512;
            }
            if (nArray[i] <= 0) continue;
            this.encodings_.add(nArray[i]);
        }
    }
}

