/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.ExportableView;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.FurnitureView;
import com.eteks.sweethome3d.viewcontroller.TransferableView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FurnitureTable
extends JTable
implements FurnitureView,
Printable {
    private static final String EXPANDED_ROWS_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ExpandedGroups";
    private static final String COLUMN_WIDTHS_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ColumnWidths";
    private UserPreferences preferences;
    private ListSelectionListener tableSelectionListener;
    private boolean selectionByUser;
    private boolean selectionToggling;
    private int furnitureInformationRow;
    private Popup furnitureInformationPopup;
    private AWTEventListener informationPopupRemovalListener;
    private final boolean reorderingEnabled;

    public FurnitureTable(Home home, UserPreferences userPreferences) {
        this(home, userPreferences, null);
    }

    public FurnitureTable(Home home, UserPreferences userPreferences, FurnitureController furnitureController) {
        this.preferences = userPreferences;
        boolean bl = true;
        try {
            bl = Boolean.parseBoolean(System.getProperty("com.eteks.sweethome3d.furnitureTableReorderingEnabled", "true"));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.reorderingEnabled = bl;
        float f = SwingTools.getResolutionScale();
        if (f != 1.0f) {
            this.setRowHeight(Math.round((float)this.getRowHeight() * f));
        }
        this.setModel(new FurnitureTreeTableModel(home));
        this.setColumnModel(new FurnitureTableColumnModel(home, userPreferences));
        this.updateTableColumnsWidth(home, 0);
        this.updateExpandedRows(home);
        this.updateTableSelectedFurniture(home);
        if (furnitureController != null) {
            this.addSelectionListeners(home, furnitureController);
            this.addTableHeaderListener(furnitureController);
            this.addTableColumnModelListener(furnitureController);
            this.addMouseListener(home, furnitureController);
        }
        this.addFocusListener(home);
        this.addHomeListener(home, furnitureController);
        this.addUserPreferencesListener(userPreferences);
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            try {
                Class<?> clazz = Class.forName("javax.swing.DropMode");
                Object object = clazz.getMethod("valueOf", String.class).invoke(null, "INSERT_ROWS");
                this.getClass().getMethod("setDropMode", clazz).invoke((Object)this, object);
                UIManager.getDefaults().remove("Table.dropLineShortColor");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void addSelectionListeners(final Home home, final FurnitureController furnitureController) {
        MouseListener[] mouseListenerArray;
        SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureTable.this.updateTableSelectedFurniture(home);
                FurnitureTable.this.storeExpandedRows(home, furnitureController);
            }
        };
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FurnitureTable.this.selectionToggling = (mouseEvent.getModifiers() & FurnitureTable.this.getToolkit().getMenuShortcutKeyMask()) != 0;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }
        });
        for (MouseListener mouseListener : mouseListenerArray) {
            this.addMouseListener(mouseListener);
        }
        this.tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FurnitureTable.this.selectionByUser = true;
                int[] nArray = FurnitureTable.this.getSelectedRows();
                ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(nArray.length);
                ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>();
                TableModel tableModel = FurnitureTable.this.getModel();
                for (int n : nArray) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)tableModel.getValueAt(n, 0);
                    if (arrayList2.contains(homePieceOfFurniture)) continue;
                    arrayList.add(homePieceOfFurniture);
                    if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                    arrayList2.addAll(((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture());
                }
                furnitureController.setSelectedFurniture(new ArrayList<HomePieceOfFurniture>(arrayList), !FurnitureTable.this.selectionToggling);
                FurnitureTable.this.selectionByUser = false;
                FurnitureTable.this.selectionToggling = false;
            }
        };
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        home.addSelectionListener(selectionListener);
    }

    private void updateTableSelectedFurniture(Home home) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.tableSelectionListener);
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        List<Selectable> list = home.getSelectedItems();
        for (Selectable selectable : list) {
            if (!(selectable instanceof HomePieceOfFurniture)) continue;
            furnitureTreeTableModel.expandPathToPieceOfFurniture((HomePieceOfFurniture)selectable);
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        Object object = new int[furnitureTreeTableModel.getRowCount()];
        int n3 = 0;
        for (Selectable selectable : list) {
            HomePieceOfFurniture homePieceOfFurniture;
            int n4;
            if (!(selectable instanceof HomePieceOfFurniture) || (n4 = furnitureTreeTableModel.getPieceOfFurnitureIndex(homePieceOfFurniture = (HomePieceOfFurniture)selectable)) == -1) continue;
            object[n3++] = n4;
            n = Math.min(n, n4);
            n2 = Math.max(n2, n4);
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup) || !furnitureTreeTableModel.isRowExpanded(n4)) continue;
            List<HomePieceOfFurniture> list2 = ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture();
            ++n4;
            while (n4 < furnitureTreeTableModel.getRowCount() && list2.contains((HomePieceOfFurniture)furnitureTreeTableModel.getValueAt(n4, 0))) {
                object[n3++] = n4;
                n = Math.min(n, n4);
                n2 = Math.max(n2, n4);
                ++n4;
            }
        }
        if (n3 < ((int[])object).length) {
            Object object2 = new int[n3];
            System.arraycopy(object, 0, object2, 0, n3);
            object = object2;
        }
        Arrays.sort(object);
        if (this.getSelectedRowCount() != n3 || !Arrays.equals(this.getSelectedRows(), object)) {
            this.deleteInformationPopup();
            this.clearSelection();
            int n5 = 0;
            while (n5 < ((int[])object).length) {
                int n6 = n5;
                while (n6 + 1 < ((int[])object).length && object[n6] + 1 == object[n6 + 1]) {
                    ++n6;
                }
                this.addRowSelectionInterval(object[n6], object[n5]);
                n5 = n6 + 1;
            }
        }
        if (!this.selectionByUser && n != Integer.MIN_VALUE) {
            this.makeRowsVisible(n, n2);
        }
        listSelectionModel.addListSelectionListener(this.tableSelectionListener);
    }

    private void updateExpandedRows(Home home) {
        String string;
        if (home.getVersion() >= 5000L && (string = home.getProperty(EXPANDED_ROWS_VISUAL_PROPERTY)) != null && string.length() > 0) {
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)FurnitureTable.this.getModel();
                    for (String string2 : string.split(",")) {
                        int n = Integer.parseInt(string2);
                        if (n >= furnitureTreeTableModel.getRowCount() || furnitureTreeTableModel.isRowExpanded(n)) continue;
                        furnitureTreeTableModel.toggleRowExpandedState(n);
                    }
                    FurnitureTable.this.removeAncestorListener(this);
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        }
    }

    private void storeExpandedRows(Home home, FurnitureController furnitureController) {
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        StringBuilder stringBuilder = new StringBuilder();
        int n = furnitureTreeTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!furnitureTreeTableModel.isRowExpanded(i)) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(i);
        }
        if (home.getProperty(EXPANDED_ROWS_VISUAL_PROPERTY) != null || stringBuilder.length() > 0) {
            furnitureController.setHomeProperty(EXPANDED_ROWS_VISUAL_PROPERTY, stringBuilder.toString());
        }
    }

    private void updateTableColumnsWidth(Home home, int n) {
        int n2;
        String[] stringArray;
        TableColumnModel tableColumnModel = this.getColumnModel();
        int[] nArray = null;
        if (home != null && home.getProperty(COLUMN_WIDTHS_VISUAL_PROPERTY) != null && (stringArray = home.getProperty(COLUMN_WIDTHS_VISUAL_PROPERTY).split(",")).length == tableColumnModel.getColumnCount()) {
            nArray = new int[stringArray.length];
            n2 = tableColumnModel.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                try {
                    int n3;
                    nArray[i] = n3 = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    nArray = null;
                    break;
                }
            }
        }
        int n4 = this.getIntercellSpacing().width + n;
        TableModel tableModel = this.getModel();
        int n5 = tableColumnModel.getColumnCount();
        for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            int n7 = this.convertColumnIndexToModel(n2);
            if (nArray == null) {
                n6 = tableColumn.getHeaderRenderer().getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)n2).getPreferredSize().width;
                int n8 = tableModel.getRowCount();
                if (n8 > 0) {
                    for (int i = 0; i < n8; ++i) {
                        n6 = Math.max(n6, tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)this, (Object)tableModel.getValueAt((int)i, (int)n7), (boolean)false, (boolean)false, (int)-1, (int)n2).getPreferredSize().width);
                    }
                } else {
                    n6 = Math.max(n6, tableColumn.getPreferredWidth());
                }
                n6 += n4;
            } else {
                n6 = nArray[n2];
            }
            tableColumn.setPreferredWidth(n6);
            tableColumn.setWidth(n6);
        }
    }

    private void addMouseListener(Home home, final FurnitureController furnitureController) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = FurnitureTable.this.columnAtPoint(mouseEvent.getPoint());
                int n2 = FurnitureTable.this.rowAtPoint(mouseEvent.getPoint());
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (n >= 0 && n2 >= 0) {
                    Object object;
                    Object object2;
                    Object object3 = FurnitureTable.this.getColumnModel().getColumn(n).getIdentifier();
                    if (object3 == HomePieceOfFurniture.SortableProperty.VISIBLE) {
                        object2 = FurnitureTable.this.getCellRenderer(n2, n).getTableCellRendererComponent(FurnitureTable.this, FurnitureTable.this.getValueAt(n2, n), false, false, n2, n);
                        if (((Component)object2).isEnabled()) {
                            object = FurnitureTable.this.getCellRect(n2, n, false);
                            ((Component)object2).setSize(((Component)object2).getPreferredSize());
                            ((Component)object2).setLocation(((Rectangle)object).x + (((Rectangle)object).width - ((Component)object2).getWidth()) / 2, ((Rectangle)object).y + (((Rectangle)object).height - ((Component)object2).getHeight()) / 2);
                            bl = ((Component)object2).getBounds().contains(mouseEvent.getPoint());
                        }
                    } else if (object3 == HomePieceOfFurniture.SortableProperty.NAME && (object2 = FurnitureTable.this.getCellRenderer(n2, n)) instanceof TreeTableNameCellRenderer) {
                        object = ((TreeTableNameCellRenderer)object2).getInformationIconBounds(FurnitureTable.this, n2, n);
                        boolean bl4 = bl3 = mouseEvent.getClickCount() == 1 && object != null && ((Rectangle)object).contains(mouseEvent.getPoint());
                        if (!bl3 && FurnitureTable.this.getValueAt(n2, n) instanceof HomeFurnitureGroup) {
                            Rectangle rectangle = ((TreeTableNameCellRenderer)object2).getExpandedStateBounds(FurnitureTable.this, n2, n);
                            bl2 = rectangle.contains(mouseEvent.getPoint());
                        }
                    }
                    if (bl) {
                        furnitureController.toggleSelectedFurnitureVisibility();
                    } else if (bl3) {
                        object2 = (FurnitureTreeTableModel)FurnitureTable.this.getModel();
                        object = ((HomePieceOfFurniture)((FurnitureTreeTableModel)object2).getValueAt(n2, 0)).getInformation();
                        if (FurnitureTable.this.furnitureInformationPopup != null && FurnitureTable.this.furnitureInformationRow == n2) {
                            FurnitureTable.this.deleteInformationPopup();
                        } else {
                            FurnitureTable.this.showInformationPopup((String)object, n, n2);
                        }
                    } else if (bl2) {
                        object2 = (FurnitureTreeTableModel)FurnitureTable.this.getModel();
                        ((FurnitureTreeTableModel)object2).toggleRowExpandedState(n2);
                        furnitureController.setSelectedFurniture(Arrays.asList((HomePieceOfFurniture)((FurnitureTreeTableModel)object2).getValueAt(n2, 0)));
                    } else if (mouseEvent.getClickCount() == 2) {
                        FurnitureTable.this.deleteInformationPopup();
                        furnitureController.modifySelectedFurniture();
                    }
                }
                if (!bl3) {
                    FurnitureTable.this.deleteInformationPopup();
                }
            }
        });
    }

    private void addFocusListener(final Home home) {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FurnitureTable.this.setDragEnabled(FurnitureTable.this.reorderingEnabled && home.getFurnitureSortedPropertyName() == null);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FurnitureTable.this.setDragEnabled(false);
            }
        });
    }

    private void showInformationPopup(String string, int n, int n2) {
        if (this.furnitureInformationPopup == null || this.furnitureInformationRow != n2) {
            this.deleteInformationPopup();
            final JEditorPane jEditorPane = new JEditorPane("text/html", string);
            jEditorPane.setEditable(false);
            jEditorPane.setFocusable(false);
            Font font = this.getFont();
            String string2 = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; text-align: center; }";
            ((HTMLDocument)jEditorPane.getDocument()).getStyleSheet().addRule(string2);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        FurnitureTable.this.deleteInformationPopup();
                        SwingTools.showDocumentInBrowser(hyperlinkEvent.getURL());
                    }
                }
            });
            Border border = UIManager.getBorder("ToolTip.border");
            if (!OperatingSystem.isMacOSX() || OperatingSystem.isMacOSXLeopardOrSuperior()) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 3, 0, 2));
            }
            jEditorPane.setBorder(border);
            JToolTip jToolTip = new JToolTip();
            jToolTip.setComponent(this);
            jEditorPane.setBackground(jToolTip.getBackground().getRGB() == 0 && this.getBackground().getRGB() != 0 ? Color.WHITE : jToolTip.getBackground());
            jEditorPane.setForeground(jToolTip.getForeground());
            jEditorPane.setSize(jEditorPane.getPreferredSize());
            Rectangle rectangle = this.getCellRect(n2, n, true);
            Point point = new Point(rectangle.x, rectangle.y);
            if (this.getComponentOrientation().isLeftToRight()) {
                point.translate(rectangle.width, 0);
            } else {
                point.translate(-jEditorPane.getWidth(), 0);
            }
            SwingUtilities.convertPointToScreen(point, this);
            try {
                this.informationPopupRemovalListener = new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent aWTEvent) {
                        if (aWTEvent instanceof KeyEvent) {
                            if (((KeyEvent)aWTEvent).getKeyCode() == 27) {
                                FurnitureTable.this.deleteInformationPopup();
                                ((KeyEvent)aWTEvent).consume();
                            }
                        } else if (aWTEvent.getID() != 200 && (!(aWTEvent instanceof MouseEvent) || aWTEvent.getSource() != FurnitureTable.this && aWTEvent.getSource() != jEditorPane)) {
                            FurnitureTable.this.deleteInformationPopup();
                        }
                    }
                };
                this.getToolkit().addAWTEventListener(this.informationPopupRemovalListener, 917596L);
                this.furnitureInformationPopup = PopupFactory.getSharedInstance().getPopup(this, jEditorPane, point.x, point.y);
                this.furnitureInformationPopup.show();
                this.furnitureInformationRow = n2;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public void deleteInformationPopup() {
        if (this.furnitureInformationPopup != null) {
            this.getToolkit().removeAWTEventListener(this.informationPopupRemovalListener);
            this.furnitureInformationPopup.hide();
            this.furnitureInformationPopup = null;
        }
    }

    private void addUserPreferencesListener(UserPreferences userPreferences) {
        UserPreferencesChangeListener userPreferencesChangeListener = new UserPreferencesChangeListener(this);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.CURRENCY, userPreferencesChangeListener);
    }

    private void addHomeListener(final Home home, final FurnitureController furnitureController) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((FurnitureTreeTableModel)FurnitureTable.this.getModel()).filterAndSortFurniture();
                FurnitureTable.this.updateTableSelectedFurniture(home);
                FurnitureTable.this.storeExpandedRows(home, furnitureController);
                FurnitureTable.this.getTableHeader().repaint();
                FurnitureTable.this.setDragEnabled(FurnitureTable.this.reorderingEnabled && home.getFurnitureSortedPropertyName() == null && FurnitureTable.this.hasFocus());
            }
        };
        home.addPropertyChangeListener(Home.Property.FURNITURE_SORTED_PROPERTY, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.FURNITURE_DESCENDING_SORTED, propertyChangeListener);
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((FurnitureTreeTableModel)FurnitureTable.this.getModel()).filterAndSortFurniture();
                FurnitureTable.this.updateTableSelectedFurniture(home);
                FurnitureTable.this.storeExpandedRows(home, furnitureController);
            }
        };
        for (HomePieceOfFurniture homeObject : home.getFurniture()) {
            homeObject.addPropertyChangeListener(propertyChangeListener2);
            if (!(homeObject instanceof HomeFurnitureGroup)) continue;
            for (HomePieceOfFurniture homePieceOfFurniture : ((HomeFurnitureGroup)homeObject).getAllFurniture()) {
                homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener2);
            }
        }
        home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                block4: {
                    HomePieceOfFurniture homePieceOfFurniture;
                    block3: {
                        homePieceOfFurniture = collectionEvent.getItem();
                        if (collectionEvent.getType() != CollectionEvent.Type.ADD) break block3;
                        homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener2);
                        if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) break block4;
                        for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                            homePieceOfFurniture2.addPropertyChangeListener(propertyChangeListener2);
                        }
                        break block4;
                    }
                    homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener2);
                    if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                        for (HomePieceOfFurniture homePieceOfFurniture3 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                            homePieceOfFurniture3.removePropertyChangeListener(propertyChangeListener2);
                        }
                    }
                }
            }
        });
        for (Level level : home.getLevels()) {
            level.addPropertyChangeListener(propertyChangeListener2);
        }
        home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                } else {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                }
            }
        });
    }

    private void makeRowsVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (n != n2) {
            rectangle = rectangle.union(this.getCellRect(n2, 0, true));
        }
        if (this.getAutoResizeMode() == 0) {
            int n3 = this.getColumnCount() - 1;
            rectangle = rectangle.union(this.getCellRect(n, n3, true));
            if (n != n2) {
                rectangle = rectangle.union(this.getCellRect(n2, n3, true));
            }
        }
        this.scrollRectToVisible(rectangle);
    }

    private void addTableHeaderListener(final FurnitureController furnitureController) {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = FurnitureTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                    Object object = FurnitureTable.this.getColumnModel().getColumn(n).getIdentifier();
                    if (object instanceof HomePieceOfFurniture.SortableProperty) {
                        furnitureController.sortFurniture(((HomePieceOfFurniture.SortableProperty)((Object)object)).name());
                    } else if (object instanceof ObjectProperty) {
                        furnitureController.sortFurniture(((ObjectProperty)object).getName());
                    }
                }
            }
        });
    }

    private void addTableColumnModelListener(final FurnitureController furnitureController) {
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                FurnitureTable.this.getColumnModel().removeColumnModelListener(this);
                ArrayList<String> arrayList = new ArrayList<String>();
                Enumeration<TableColumn> enumeration = FurnitureTable.this.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement().getIdentifier();
                    if (object instanceof HomePieceOfFurniture.SortableProperty) {
                        arrayList.add(((HomePieceOfFurniture.SortableProperty)((Object)object)).name());
                        continue;
                    }
                    if (!(object instanceof ObjectProperty)) continue;
                    arrayList.add(((ObjectProperty)object).getName());
                }
                furnitureController.setFurnitureVisiblePropertyNames(arrayList);
                FurnitureTable.this.getColumnModel().addColumnModelListener(this);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("width".equals(propertyChangeEvent.getPropertyName())) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = FurnitureTable.this.getColumnModel().getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        if (stringBuilder.length() != 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(FurnitureTable.this.getColumnModel().getColumn(i).getWidth());
                    }
                    furnitureController.setHomeProperty(FurnitureTable.COLUMN_WIDTHS_VISUAL_PROPERTY, stringBuilder.toString());
                }
            }
        };
        int n = this.columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object = UIManager.getDefaults().get("Table.dropLineColor");
        if (object != null && !this.getDragEnabled()) {
            UIManager.getDefaults().remove("Table.dropLineColor");
        }
        super.paintComponent(graphics);
        if (object != null) {
            UIManager.getDefaults().put("Table.dropLineColor", object);
        }
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        super.setComponentPopupMenu(jPopupMenu);
        this.getTableHeader().setComponentPopupMenu(jPopupMenu);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setIcon(null);
                jLabel.setBackground(Color.LIGHT_GRAY);
                jLabel.setForeground(Color.BLACK);
                jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), jLabel.getBorder()));
                return jLabel;
            }
        };
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            final TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableColumn tableColumn2 = new TableColumn();
            tableColumn2.setIdentifier(tableColumn.getIdentifier());
            tableColumn2.setHeaderValue(tableColumn.getHeaderValue());
            TableCellRenderer tableCellRenderer2 = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof JCheckBox) {
                        component = defaultTableCellRenderer.getTableCellRendererComponent(jTable, ((JCheckBox)component).isSelected() ? "x" : "", false, false, n, n2);
                    }
                    component.setBackground(Color.WHITE);
                    component.setForeground(Color.BLACK);
                    return component;
                }
            };
            tableColumn2.setCellRenderer(tableCellRenderer2);
            tableColumn2.setHeaderRenderer(tableCellRenderer);
            defaultTableColumnModel.addColumn(tableColumn2);
        }
        return this.print(graphics, pageFormat, n, defaultTableColumnModel, Color.BLACK);
    }

    private int print(final Graphics graphics, final PageFormat pageFormat, final int n, final TableColumnModel tableColumnModel, final Color color) throws PrinterException {
        if (EventQueue.isDispatchThread()) {
            TableColumnModel tableColumnModel2 = this.getColumnModel();
            Color color2 = this.getGridColor();
            this.setColumnModel(tableColumnModel);
            if (OperatingSystem.isWindows()) {
                this.updateTableColumnsWidth(null, 3);
            } else {
                this.updateTableColumnsWidth(null, 0);
            }
            this.setGridColor(color);
            Printable printable = this.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
            int n2 = printable.print(graphics, pageFormat, n);
            this.setColumnModel(tableColumnModel2);
            this.setGridColor(color2);
            return n2;
        }
        class RunnableContext {
            int pageExists;
            PrinterException exception;

            RunnableContext() {
            }
        }
        final RunnableContext runnableContext = new RunnableContext();
        try {
            EventQueue.invokeAndWait(new Runnable(){
                {
                }

                @Override
                public void run() {
                    try {
                        runnableContext.pageExists = FurnitureTable.this.print(graphics, pageFormat, n, tableColumnModel, color);
                    }
                    catch (PrinterException printerException) {
                        runnableContext.exception = printerException;
                    }
                }
            });
            if (runnableContext.exception != null) {
                throw runnableContext.exception;
            }
            return runnableContext.pageExists;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedPrinterException("Print interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw (Error)invocationTargetException.getCause();
        }
    }

    @Override
    public boolean isFormatTypeSupported(ExportableView.FormatType formatType) {
        return formatType == ExportableView.FormatType.CSV;
    }

    @Override
    public void exportData(OutputStream outputStream, ExportableView.FormatType formatType, Properties properties) throws IOException {
        String string;
        if (formatType == ExportableView.FormatType.CSV) {
            try {
                string = System.getProperty("com.eteks.sweethome3d.CSVEncoding", "UTF-8");
                if (string.length() == 0) {
                    string = null;
                }
            }
            catch (AccessControlException accessControlException) {
                string = "UTF-8";
            }
        } else {
            throw new UnsupportedOperationException("Unsupported format " + formatType);
        }
        OutputStreamWriter outputStreamWriter = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
        char c = properties != null ? (char)properties.getProperty("fieldSeparator", "\t").charAt(0) : (char)'\t';
        this.exportToCSV(outputStreamWriter, c);
        outputStreamWriter.flush();
    }

    public void exportToCSV(Writer writer, char c) throws IOException {
        TableColumnModel tableColumnModel = this.getExportColumnModel();
        this.exportHeaderToCSV(writer, tableColumnModel, c);
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.exportRowToCSV(writer, i, tableColumnModel, c);
        }
    }

    private TableColumnModel getExportColumnModel() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof FurnitureTableColumnModel) {
            DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = tableColumnModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn.getIdentifier() instanceof ObjectProperty && (!((ObjectProperty)tableColumn.getIdentifier()).isExportable() || ((ObjectProperty)tableColumn.getIdentifier()).getType() == ObjectProperty.Type.CONTENT)) continue;
                defaultTableColumnModel.addColumn(tableColumn);
                arrayList.add(tableColumn.getIdentifier());
            }
            Map map = ((FurnitureTableColumnModel)tableColumnModel).getAvailableColumns();
            for (TableColumn tableColumn : map.values()) {
                if (arrayList.contains(tableColumn.getIdentifier()) || !(tableColumn.getIdentifier() instanceof ObjectProperty) || !((ObjectProperty)tableColumn.getIdentifier()).isExportable() || ((ObjectProperty)tableColumn.getIdentifier()).getType() == ObjectProperty.Type.CONTENT) continue;
                defaultTableColumnModel.addColumn(tableColumn);
            }
            return defaultTableColumnModel;
        }
        return tableColumnModel;
    }

    private void exportHeaderToCSV(Writer writer, TableColumnModel tableColumnModel, char c) throws IOException {
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                writer.write(c);
            }
            writer.write(String.valueOf(tableColumnModel.getColumn(i).getHeaderValue()));
        }
        writer.write(System.getProperty("line.separator"));
    }

    private void exportRowToCSV(Writer writer, int n, TableColumnModel tableColumnModel, char c) throws IOException {
        TableModel tableModel = this.getModel();
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)tableModel.getValueAt(n, 0);
        Format format = this.preferences.getLengthUnit().isMetric() || this.preferences.getLengthUnit() == LengthUnit.FOOT_DECIMALS ? this.preferences.getLengthUnit().getFormat() : LengthUnit.INCH_DECIMALS.getFormat();
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string;
            String string2;
            Object object;
            TableColumn tableColumn;
            Object object2;
            if (i > 0) {
                writer.write(c);
            }
            if ((object2 = (tableColumn = tableColumnModel.getColumn(i)).getIdentifier()) instanceof HomePieceOfFurniture.SortableProperty) {
                switch ((HomePieceOfFurniture.SortableProperty)((Object)object2)) {
                    case CATALOG_ID: {
                        object = homePieceOfFurniture.getCatalogId();
                        writer.write((String)(object != null ? object : ""));
                        break;
                    }
                    case NAME: {
                        writer.write(homePieceOfFurniture.getName());
                        break;
                    }
                    case DESCRIPTION: {
                        if (homePieceOfFurniture.getDescription() == null) break;
                        writer.write(homePieceOfFurniture.getDescription());
                        break;
                    }
                    case CREATOR: {
                        string2 = ((JLabel)tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n, i)).getText();
                        if (string2 == null) break;
                        writer.write(string2);
                        break;
                    }
                    case LICENSE: {
                        if (homePieceOfFurniture.getLicense() == null) break;
                        writer.write(homePieceOfFurniture.getLicense());
                        break;
                    }
                    case LEVEL: {
                        writer.write(homePieceOfFurniture.getLevel() != null ? homePieceOfFurniture.getLevel().getName() : "");
                        break;
                    }
                    case COLOR: {
                        if (homePieceOfFurniture.getColor() == null) break;
                        writer.write("#" + Integer.toHexString(homePieceOfFurniture.getColor()).substring(2));
                        break;
                    }
                    case TEXTURE: {
                        if (homePieceOfFurniture.getTexture() == null) break;
                        writer.write(homePieceOfFurniture.getTexture().getName());
                        break;
                    }
                    case WIDTH: {
                        writer.write(format.format(Float.valueOf(homePieceOfFurniture.getWidth())));
                        break;
                    }
                    case DEPTH: {
                        writer.write(format.format(Float.valueOf(homePieceOfFurniture.getDepth())));
                        break;
                    }
                    case HEIGHT: {
                        writer.write(format.format(Float.valueOf(homePieceOfFurniture.getHeight())));
                        break;
                    }
                    case X: {
                        writer.write(format.format(Float.valueOf(homePieceOfFurniture.getX())));
                        break;
                    }
                    case Y: {
                        writer.write(format.format(Float.valueOf(homePieceOfFurniture.getY())));
                        break;
                    }
                    case ELEVATION: {
                        writer.write(format.format(Float.valueOf(homePieceOfFurniture.getElevation())));
                        break;
                    }
                    case ANGLE: 
                    case MODEL_SIZE: 
                    case PRICE: 
                    case VALUE_ADDED_TAX_PERCENTAGE: 
                    case VALUE_ADDED_TAX: 
                    case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                        string = ((JLabel)tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n, i)).getText();
                        if (string == null) break;
                        writer.write(string);
                        break;
                    }
                    case MOVABLE: {
                        writer.write(String.valueOf(homePieceOfFurniture.isMovable()));
                        break;
                    }
                    case DOOR_OR_WINDOW: {
                        writer.write(String.valueOf(homePieceOfFurniture.isDoorOrWindow()));
                        break;
                    }
                    case VISIBLE: {
                        writer.write(String.valueOf(homePieceOfFurniture.isVisible()));
                    }
                }
                continue;
            }
            if (object2 instanceof ObjectProperty && ((ObjectProperty)object2).getType() != null) {
                object = (ObjectProperty)object2;
                string2 = homePieceOfFurniture.getProperty(((ObjectProperty)object).getName());
                if (string2 == null) continue;
                switch (((ObjectProperty)object).getType()) {
                    case LENGTH: {
                        writer.write(format.format(new BigDecimal(string2)));
                        break;
                    }
                    case ANY: 
                    case DATE: 
                    case INTEGER: 
                    case NUMBER: 
                    case PRICE: 
                    case PERCENTAGE: {
                        string = ((JLabel)tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n, i)).getText();
                        if (string == null) break;
                        writer.write(string);
                        break;
                    }
                    case BOOLEAN: {
                        writer.write(String.valueOf(string2));
                        break;
                    }
                    case STRING: {
                        writer.write(string2);
                        break;
                    }
                }
                continue;
            }
            object = tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n, i);
            if (object instanceof JLabel) {
                string2 = ((JLabel)object).getText();
                if (string2 == null) continue;
                writer.write(string2);
                continue;
            }
            writer.write(String.valueOf(tableModel.getValueAt(n, i)));
        }
        writer.write(System.getProperty("line.separator"));
    }

    @Override
    public Object createTransferData(TransferableView.DataType dataType) {
        if (dataType == TransferableView.DataType.FURNITURE_LIST) {
            return this.getClipboardCSV();
        }
        return null;
    }

    public String getClipboardCSV() {
        StringWriter stringWriter = new StringWriter();
        TableColumnModel tableColumnModel = this.getExportColumnModel();
        try {
            this.exportHeaderToCSV(stringWriter, tableColumnModel, '\t');
            for (int n : this.getSelectedRows()) {
                this.exportRowToCSV(stringWriter, n, tableColumnModel, '\t');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    @Override
    public void setFurnitureFilter(FurnitureView.FurnitureFilter furnitureFilter) {
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        furnitureTreeTableModel.setFurnitureFilter(furnitureFilter);
    }

    @Override
    public FurnitureView.FurnitureFilter getFurnitureFilter() {
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        return furnitureTreeTableModel.getFurnitureFilter();
    }

    private static class FurnitureTreeTableModel
    extends AbstractTableModel
    implements TreeModel {
        private Home home;
        private List<HomePieceOfFurniture> filteredAndSortedFurniture;
        private FurnitureView.FurnitureFilter furnitureFilter;
        private Set<HomeFurnitureGroup> expandedGroups;
        private List<TreeModelListener> treeModelListeners;
        private Map<Object, List<HomePieceOfFurniture>> childFurnitureCache;
        private boolean containsNotViewableFurniture;

        public FurnitureTreeTableModel(Home home) {
            this.home = home;
            this.expandedGroups = new HashSet<HomeFurnitureGroup>();
            this.treeModelListeners = new ArrayList<TreeModelListener>();
            this.childFurnitureCache = new HashMap<Object, List<HomePieceOfFurniture>>();
            this.addHomeListener(home);
            this.filterAndSortFurniture();
        }

        private void addHomeListener(final Home home) {
            home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

                @Override
                public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                    HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                    int n = collectionEvent.getIndex();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            if (!expandedGroups.isEmpty() || containsNotViewableFurniture || n < 0) {
                                this.filterAndSortFurniture();
                                break;
                            }
                            int n2 = this.getPieceOfFurnitureInsertionIndex(homePieceOfFurniture, home, n);
                            if (n2 == -1) break;
                            filteredAndSortedFurniture.add(n2, homePieceOfFurniture);
                            this.fireTableRowsInserted(n2, n2);
                            this.fireTreeModelChanged();
                            break;
                        }
                        case DELETE: {
                            if (furnitureFilter != null || n < 0) {
                                this.filterAndSortFurniture();
                            } else {
                                int n3 = this.getPieceOfFurnitureDeletionIndex(homePieceOfFurniture, home, n);
                                if (n3 != -1) {
                                    if (expandedGroups.contains(homePieceOfFurniture)) {
                                        this.filterAndSortFurniture();
                                    } else {
                                        filteredAndSortedFurniture.remove(n3);
                                        this.fireTableRowsDeleted(n3, n3);
                                        this.fireTreeModelChanged();
                                    }
                                }
                            }
                            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) break;
                            expandedGroups.remove(homePieceOfFurniture);
                        }
                    }
                }

                private int getPieceOfFurnitureInsertionIndex(HomePieceOfFurniture homePieceOfFurniture, Home home2, int n) {
                    int n2;
                    if (furnitureFilter == null) {
                        if (home2.getFurnitureSortedPropertyName() == null) {
                            return n;
                        }
                    } else {
                        if (!furnitureFilter.include(home2, homePieceOfFurniture)) {
                            return -1;
                        }
                        if (home2.getFurnitureSortedPropertyName() == null) {
                            int n3;
                            if (n == 0 || filteredAndSortedFurniture.size() == 0) {
                                return 0;
                            }
                            List<HomePieceOfFurniture> list = home2.getFurniture();
                            for (n3 = n - 1; n3 > 0 && !furnitureFilter.include(home2, list.get(n3)); --n3) {
                            }
                            return this.getPieceOfFurnitureIndex(list.get(n3)) + 1;
                        }
                    }
                    if ((n2 = Collections.binarySearch(filteredAndSortedFurniture, homePieceOfFurniture, this.getFurnitureComparator(home2))) >= 0) {
                        return n2;
                    }
                    return -(n2 + 1);
                }

                private int getPieceOfFurnitureDeletionIndex(HomePieceOfFurniture homePieceOfFurniture, Home home2, int n) {
                    if (furnitureFilter == null && home2.getFurnitureSortedPropertyName() == null && expandedGroups.isEmpty() && !containsNotViewableFurniture) {
                        return n;
                    }
                    return this.getPieceOfFurnitureIndex(homePieceOfFurniture);
                }
            });
            home.addPropertyChangeListener(Home.Property.FURNITURE_VISIBLE_PROPERTIES, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!home.getFurnitureVisiblePropertyNames().contains(HomePieceOfFurniture.SortableProperty.NAME.name())) {
                        expandedGroups.clear();
                        this.filterAndSortFurniture();
                    }
                }
            });
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.filteredAndSortedFurniture.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.filteredAndSortedFurniture.get(n);
        }

        public int getPieceOfFurnitureIndex(HomePieceOfFurniture homePieceOfFurniture) {
            return this.filteredAndSortedFurniture.indexOf(homePieceOfFurniture);
        }

        public void filterAndSortFurniture() {
            int n = this.filteredAndSortedFurniture != null ? this.filteredAndSortedFurniture.size() : 0;
            List<HomePieceOfFurniture> list = this.home.getFurniture();
            boolean bl = false;
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                Level level = homePieceOfFurniture.getLevel();
                if (level == null || level.isViewable()) continue;
                bl = true;
                break;
            }
            this.containsNotViewableFurniture = bl;
            this.filteredAndSortedFurniture = this.getFilteredAndSortedFurniture(list, true);
            if (n != this.filteredAndSortedFurniture.size()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
            this.fireTreeModelChanged();
        }

        /*
         * WARNING - void declaration
         */
        private List<HomePieceOfFurniture> getFilteredAndSortedFurniture(List<HomePieceOfFurniture> list, boolean bl) {
            ArrayList<HomePieceOfFurniture> arrayList;
            ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>(list.size());
            for (HomePieceOfFurniture object : list) {
                if (object.getLevel() != null && !object.getLevel().isViewable()) continue;
                arrayList2.add(object);
            }
            if (this.furnitureFilter == null) {
                arrayList = arrayList2;
            } else {
                arrayList = new ArrayList<HomePieceOfFurniture>(arrayList2.size());
                for (HomePieceOfFurniture homePieceOfFurniture : arrayList2) {
                    if (!this.furnitureFilter.include(this.home, homePieceOfFurniture)) continue;
                    arrayList.add(homePieceOfFurniture);
                }
            }
            if (this.home.getFurnitureSortedPropertyName() != null) {
                Comparator<HomePieceOfFurniture> comparator = this.getFurnitureComparator(this.home);
                Collections.sort(arrayList, comparator);
            }
            if (bl) {
                void var5_11;
                int n = arrayList.size() - 1;
                while (var5_11 >= 0) {
                    HomePieceOfFurniture homePieceOfFurniture;
                    homePieceOfFurniture = (HomePieceOfFurniture)arrayList.get((int)var5_11);
                    if (homePieceOfFurniture instanceof HomeFurnitureGroup && this.expandedGroups.contains(homePieceOfFurniture)) {
                        arrayList.addAll((int)(var5_11 + true), this.getFilteredAndSortedFurniture(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture(), true));
                    }
                    --var5_11;
                }
            }
            return arrayList;
        }

        private Comparator<HomePieceOfFurniture> getFurnitureComparator(Home home) {
            Comparator<HomePieceOfFurniture> comparator;
            String string = home.getFurnitureSortedPropertyName();
            try {
                comparator = HomePieceOfFurniture.getFurnitureComparator(HomePieceOfFurniture.SortableProperty.valueOf(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                comparator = HomePieceOfFurniture.getFurnitureComparator(HomePieceOfFurniture.SortableProperty.NAME);
                for (final ObjectProperty objectProperty : home.getFurnitureAdditionalProperties()) {
                    if (!objectProperty.getName().equals(string)) continue;
                    final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    final Collator collator = Collator.getInstance();
                    comparator = new Comparator<HomePieceOfFurniture>(){

                        @Override
                        public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                            String string;
                            String string2 = homePieceOfFurniture.isContentProperty(objectProperty.getName()) ? homePieceOfFurniture.getName() : homePieceOfFurniture.getProperty(objectProperty.getName());
                            String string3 = string = homePieceOfFurniture2.isContentProperty(objectProperty.getName()) ? homePieceOfFurniture2.getName() : homePieceOfFurniture2.getProperty(objectProperty.getName());
                            if (string2 == null) {
                                if (string == null) {
                                    return collator.compare(homePieceOfFurniture.getName(), homePieceOfFurniture2.getName());
                                }
                                return -1;
                            }
                            if (string == null) {
                                return 1;
                            }
                            ObjectProperty.Type type = objectProperty.getType();
                            if (type == null) {
                                type = ObjectProperty.Type.ANY;
                            }
                            switch (type) {
                                case BOOLEAN: {
                                    return Boolean.parseBoolean(string2) == Boolean.parseBoolean(string) ? 0 : (Boolean.parseBoolean(string2) ? 1 : -1);
                                }
                                case DATE: {
                                    try {
                                        Date date = simpleDateFormat.parse(string2);
                                        Date date2 = simpleDateFormat.parse(string);
                                        int n = date.compareTo(date2);
                                        if (n != 0) {
                                            return n;
                                        }
                                        return collator.compare(homePieceOfFurniture.getName(), homePieceOfFurniture2.getName());
                                    }
                                    catch (ParseException parseException) {
                                        int n = collator.compare(string2, string);
                                        if (n != 0) {
                                            return n;
                                        }
                                        return collator.compare(homePieceOfFurniture.getName(), homePieceOfFurniture2.getName());
                                    }
                                }
                                case LENGTH: 
                                case ANY: 
                                case INTEGER: 
                                case NUMBER: 
                                case PRICE: 
                                case PERCENTAGE: {
                                    try {
                                        double d = Double.parseDouble(string2);
                                        double d2 = Double.parseDouble(string);
                                        int n = Double.compare(d, d2);
                                        if (n != 0) {
                                            return n;
                                        }
                                        return collator.compare(homePieceOfFurniture.getName(), homePieceOfFurniture2.getName());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        int n = collator.compare(string2, string);
                                        if (n != 0) {
                                            return n;
                                        }
                                        return collator.compare(homePieceOfFurniture.getName(), homePieceOfFurniture2.getName());
                                    }
                                }
                            }
                            return collator.compare(string2, string);
                        }
                    };
                }
            }
            if (home.isFurnitureDescendingSorted()) {
                comparator = Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        public void setFurnitureFilter(FurnitureView.FurnitureFilter furnitureFilter) {
            this.furnitureFilter = furnitureFilter;
            this.filterAndSortFurniture();
        }

        public FurnitureView.FurnitureFilter getFurnitureFilter() {
            return this.furnitureFilter;
        }

        @Override
        public Object getRoot() {
            return this.home;
        }

        @Override
        public Object getChild(Object object, int n) {
            return this.getChildFurniture(object).get(n);
        }

        @Override
        public int getChildCount(Object object) {
            return this.getChildFurniture(object).size();
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            return this.getChildFurniture(object).indexOf(object2);
        }

        private List<HomePieceOfFurniture> getChildFurniture(Object object) {
            List<HomePieceOfFurniture> list = this.childFurnitureCache.get(object);
            if (list == null) {
                list = object instanceof HomeFurnitureGroup ? ((HomeFurnitureGroup)object).getFurniture() : this.home.getFurniture();
                list = this.getFilteredAndSortedFurniture(list, false);
                this.childFurnitureCache.put(object, list);
            }
            return list;
        }

        @Override
        public boolean isLeaf(Object object) {
            return object instanceof HomePieceOfFurniture && !(object instanceof HomeFurnitureGroup);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.remove(treeModelListener);
        }

        private void fireTreeModelChanged() {
            this.childFurnitureCache.clear();
            for (TreeModelListener treeModelListener : this.treeModelListeners) {
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.home)));
            }
        }

        public boolean isRowExpanded(int n) {
            return this.expandedGroups.contains(this.filteredAndSortedFurniture.get(n));
        }

        public void toggleRowExpandedState(int n) {
            HomePieceOfFurniture homePieceOfFurniture = this.filteredAndSortedFurniture.get(n);
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                if (this.expandedGroups.contains(homePieceOfFurniture)) {
                    this.expandedGroups.remove((HomeFurnitureGroup)homePieceOfFurniture);
                } else {
                    this.expandedGroups.add((HomeFurnitureGroup)homePieceOfFurniture);
                }
                this.filterAndSortFurniture();
            }
        }

        public void expandPathToPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            List<HomePieceOfFurniture> list = this.home.getFurniture();
            if (list.contains(homePieceOfFurniture)) {
                return;
            }
            for (HomeFurnitureGroup homePieceOfFurniture2 : this.expandedGroups) {
                if (!homePieceOfFurniture2.getFurniture().contains(homePieceOfFurniture)) continue;
                return;
            }
            for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
                if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || !this.expandPathToPieceOfFurniture(homePieceOfFurniture, (HomeFurnitureGroup)homePieceOfFurniture2)) continue;
                this.filterAndSortFurniture();
                return;
            }
        }

        private boolean expandPathToPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, HomeFurnitureGroup homeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : homeFurnitureGroup.getFurniture()) {
                if (homePieceOfFurniture2 != homePieceOfFurniture && (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || !this.expandPathToPieceOfFurniture(homePieceOfFurniture, (HomeFurnitureGroup)homePieceOfFurniture2))) continue;
                this.expandedGroups.add(homeFurnitureGroup);
                return true;
            }
            return false;
        }
    }

    private static class TreeTableNameCellRenderer
    implements TableCellRenderer {
        private static final ResourceURLContent GROUP_ICON_CONTENT = new ResourceURLContent(FurnitureTable.class, "resources/groupIcon.png");
        private PanelWithInformationIcon groupRendererComponent;
        private JTree nameRendererTree;
        private int renderedRow;
        private PanelWithInformationIcon noGroupRendererComponent;
        private DefaultTableCellRenderer nameRendererLabel;
        private Font defaultFont;

        private TreeTableNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.defaultFont == null) {
                this.defaultFont = jTable.getFont();
            }
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
            boolean bl3 = false;
            if (homePieceOfFurniture != null) {
                for (int i = 0; i < jTable.getRowCount(); ++i) {
                    if (!(jTable.getValueAt(i, 0) instanceof HomeFurnitureGroup)) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl3) {
                this.prepareTree(jTable);
                if (this.groupRendererComponent == null) {
                    this.groupRendererComponent = new PanelWithInformationIcon();
                    this.groupRendererComponent.add((Component)this.nameRendererTree, "Center");
                }
                this.groupRendererComponent.setInformationIconVisible(homePieceOfFurniture.getInformation() != null);
                this.groupRendererComponent.setFont(this.defaultFont);
                if (bl) {
                    this.nameRendererTree.setSelectionRow(n);
                    this.groupRendererComponent.setBackground(jTable.getSelectionBackground());
                } else {
                    this.nameRendererTree.clearSelection();
                    this.groupRendererComponent.setBackground(jTable.getBackground());
                }
                this.renderedRow = n;
                this.groupRendererComponent.applyComponentOrientation(jTable.getComponentOrientation());
                return this.groupRendererComponent;
            }
            if (this.noGroupRendererComponent == null) {
                this.nameRendererLabel = new DefaultTableCellRenderer();
                this.noGroupRendererComponent = new PanelWithInformationIcon();
                this.noGroupRendererComponent.add((Component)this.nameRendererLabel, "Center");
            }
            String string = homePieceOfFurniture != null ? homePieceOfFurniture.getName() : null;
            this.nameRendererLabel.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (homePieceOfFurniture != null) {
                Content content = homePieceOfFurniture instanceof HomeFurnitureGroup ? GROUP_ICON_CONTENT : homePieceOfFurniture.getIcon();
                this.nameRendererLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - jTable.getRowMargin(), jTable));
                this.noGroupRendererComponent.setInformationIconVisible(homePieceOfFurniture.getInformation() != null);
            } else {
                this.nameRendererLabel.setIcon(null);
                this.noGroupRendererComponent.setInformationIconVisible(false);
            }
            this.noGroupRendererComponent.setBackground(this.nameRendererLabel.getBackground());
            this.noGroupRendererComponent.setBorder(this.nameRendererLabel.getBorder());
            this.nameRendererLabel.setBorder(null);
            this.noGroupRendererComponent.applyComponentOrientation(jTable.getComponentOrientation());
            return this.noGroupRendererComponent;
        }

        private void prepareTree(final JTable jTable) {
            if (this.nameRendererTree == null) {
                UIManager.put("Tree.rendererFillBackground", Boolean.TRUE);
                final DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

                    @Override
                    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                        if (object instanceof HomePieceOfFurniture) {
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            super.getTreeCellRendererComponent(jTree, homePieceOfFurniture.getName(), bl, bl2, bl3, n, false);
                            Content content = homePieceOfFurniture instanceof HomeFurnitureGroup ? GROUP_ICON_CONTENT : homePieceOfFurniture.getIcon();
                            this.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - jTable.getRowMargin(), jTable));
                            this.setHorizontalAlignment(2);
                            this.setBackgroundSelectionColor(jTable.getSelectionBackground());
                            this.setBackgroundNonSelectionColor(jTable.getBackground());
                            this.setTextSelectionColor(jTable.getSelectionForeground());
                            this.setTextNonSelectionColor(jTable.getForeground());
                        }
                        return this;
                    }

                    @Override
                    public void setBounds(int n, int n2, int n3, int n4) {
                        super.setBounds(n, n2, nameRendererTree.getWidth() - n, n4);
                    }
                };
                final FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)jTable.getModel();
                this.nameRendererTree = new JTree(furnitureTreeTableModel){
                    boolean drawing;
                    {
                        super(treeModel);
                        this.drawing = false;
                    }

                    @Override
                    public void setBounds(int n, int n2, int n3, int n4) {
                        super.setBounds(n, 0, n3, jTable.getHeight());
                    }

                    @Override
                    public void paint(Graphics graphics) {
                        if (jTable.getRowMargin() > 0) {
                            Rectangle rectangle = graphics.getClipBounds();
                            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, this.getRowHeight() - jTable.getRowMargin());
                        }
                        graphics.translate(0, -renderedRow * this.getRowHeight());
                        this.drawing = true;
                        super.paint(graphics);
                        this.drawing = false;
                    }

                    @Override
                    public TreeCellRenderer getCellRenderer() {
                        return defaultTreeCellRenderer;
                    }

                    @Override
                    public boolean hasFocus() {
                        if (this.drawing && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                            return true;
                        }
                        return super.hasFocus();
                    }
                };
                this.nameRendererTree.setOpaque(false);
                this.nameRendererTree.setRowHeight(jTable.getRowHeight());
                this.nameRendererTree.setRootVisible(false);
                this.nameRendererTree.setShowsRootHandles(true);
                this.updateExpandedRows(furnitureTreeTableModel);
                furnitureTreeTableModel.addTreeModelListener(new TreeModelListener(){

                    @Override
                    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                        this.updateExpandedRows(furnitureTreeTableModel);
                    }

                    @Override
                    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    }

                    @Override
                    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    }

                    @Override
                    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    }
                });
            }
        }

        private void updateExpandedRows(FurnitureTreeTableModel furnitureTreeTableModel) {
            for (int i = 0; i < furnitureTreeTableModel.getRowCount(); ++i) {
                TreePath treePath;
                if (!(furnitureTreeTableModel.getValueAt(i, 0) instanceof HomeFurnitureGroup)) continue;
                if (furnitureTreeTableModel.isRowExpanded(i)) {
                    treePath = this.nameRendererTree.getPathForRow(i);
                    if (!this.nameRendererTree.isCollapsed(treePath)) continue;
                    this.nameRendererTree.expandPath(treePath);
                    continue;
                }
                treePath = this.nameRendererTree.getPathForRow(i);
                if (!this.nameRendererTree.isExpanded(treePath)) continue;
                this.nameRendererTree.collapsePath(treePath);
            }
        }

        public Rectangle getExpandedStateBounds(JTable jTable, int n, int n2) {
            this.prepareTree(jTable);
            Rectangle rectangle = jTable.getCellRect(n, n2, true);
            Rectangle rectangle2 = this.nameRendererTree.getPathBounds(this.nameRendererTree.getPathForRow(n));
            if (!jTable.getComponentOrientation().isLeftToRight()) {
                rectangle.x += rectangle.width - rectangle2.x;
            }
            rectangle.width = rectangle2.x;
            return rectangle;
        }

        public Rectangle getInformationIconBounds(JTable jTable, int n, int n2) {
            Rectangle rectangle;
            Component component = this.getTableCellRendererComponent(jTable, jTable.getValueAt(n, n2), false, false, n, n2);
            if (component instanceof PanelWithInformationIcon && (rectangle = ((PanelWithInformationIcon)component).getInformationIconBounds()) != null) {
                Rectangle rectangle2 = jTable.getCellRect(n, n2, false);
                rectangle.translate(rectangle2.x, rectangle2.y);
                return rectangle;
            }
            return null;
        }

        private static class PanelWithInformationIcon
        extends JPanel {
            private static final ImageIcon INFORMATION_ICON = SwingTools.getScaledImageIcon(FurnitureTable.class.getResource("resources/furnitureInformation.png"));
            private JLabel informationLabel = new JLabel(INFORMATION_ICON){

                @Override
                public void print(Graphics graphics) {
                }
            };

            public PanelWithInformationIcon() {
                super(new BorderLayout());
                this.add((Component)this.informationLabel, "After");
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long l, int n, int n2, int n3, int n4) {
            }

            @Override
            public void repaint() {
            }

            public void setInformationIconVisible(boolean bl) {
                this.informationLabel.setVisible(bl);
            }

            public Rectangle getInformationIconBounds() {
                if (this.informationLabel.isVisible()) {
                    return this.informationLabel.getBounds();
                }
                return null;
            }

            @Override
            public void setFont(Font font) {
                super.setFont(font);
                int n = this.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.getComponent(i).setFont(font);
                }
            }
        }
    }

    private static class FurnitureTableColumnModel
    extends DefaultTableColumnModel {
        private Map<String, TableColumn> availableColumns;

        public FurnitureTableColumnModel(Home home, UserPreferences userPreferences) {
            this.createAvailableColumns(home, userPreferences);
            this.updateModelColumns(home.getFurnitureVisiblePropertyNames(), userPreferences);
            this.addHomeListener(home, userPreferences);
            this.addUserPreferencesListener(userPreferences, home);
        }

        private void createAvailableColumns(Home home, UserPreferences userPreferences) {
            this.availableColumns = new LinkedHashMap<String, TableColumn>();
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer(home);
            for (HomePieceOfFurniture.SortableProperty sortableProperty : HomePieceOfFurniture.SortableProperty.values()) {
                this.availableColumns.put(sortableProperty.name(), this.createColumn(userPreferences, tableCellRenderer, (Object)sortableProperty));
            }
            for (ObjectProperty objectProperty : home.getFurnitureAdditionalProperties()) {
                this.availableColumns.put(objectProperty.getName(), this.createColumn(userPreferences, tableCellRenderer, objectProperty));
            }
        }

        private TableColumn createColumn(UserPreferences userPreferences, TableCellRenderer tableCellRenderer, Object object) {
            TableColumn tableColumn = new TableColumn();
            tableColumn.setIdentifier(object);
            tableColumn.setHeaderValue(this.getColumnName(object, userPreferences));
            tableColumn.setCellRenderer(this.getColumnRenderer(object, userPreferences));
            tableColumn.setPreferredWidth(this.getColumnPreferredWidth(object));
            tableColumn.setHeaderRenderer(tableCellRenderer);
            return tableColumn;
        }

        private Map<String, TableColumn> getAvailableColumns() {
            return Collections.unmodifiableMap(this.availableColumns);
        }

        private void addHomeListener(final Home home, final UserPreferences userPreferences) {
            home.addPropertyChangeListener(Home.Property.FURNITURE_VISIBLE_PROPERTIES, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.updateModelColumns(home.getFurnitureVisiblePropertyNames(), userPreferences);
                }
            });
            home.addPropertyChangeListener(Home.Property.FURNITURE_ADDITIONAL_PROPERTIES, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    List<ObjectProperty> list = home.getFurnitureAdditionalProperties();
                    Iterator<Object> iterator = availableColumns.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object object = ((TableColumn)entry.getValue()).getIdentifier();
                        if (!(object instanceof ObjectProperty) || list.contains(object)) continue;
                        iterator.remove();
                    }
                    for (ObjectProperty objectProperty : list) {
                        if (availableColumns.get(objectProperty.getName()) != null) continue;
                        availableColumns.put(objectProperty.getName(), this.createColumn(userPreferences, this.getHeaderRenderer(home), objectProperty));
                    }
                }
            });
        }

        private void addUserPreferencesListener(UserPreferences userPreferences, Home home) {
            UserPreferencesChangeListener userPreferencesChangeListener = new UserPreferencesChangeListener(this, home);
            userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, userPreferencesChangeListener);
            userPreferences.addPropertyChangeListener(UserPreferences.Property.CURRENCY, userPreferencesChangeListener);
            userPreferences.addPropertyChangeListener(UserPreferences.Property.VALUE_ADDED_TAX_ENABLED, userPreferencesChangeListener);
        }

        /*
         * WARNING - void declaration
         */
        private void updateModelColumns(List<String> list, UserPreferences userPreferences) {
            Object object;
            Object object2;
            for (int i = this.tableColumns.size() - 1; i >= 0; --i) {
                TableColumn object3 = (TableColumn)this.tableColumns.get(i);
                object2 = object3.getIdentifier();
                if (!(object2 instanceof HomePieceOfFurniture.SortableProperty) && !(object2 instanceof ObjectProperty)) continue;
                Object object4 = object = object2 instanceof HomePieceOfFurniture.SortableProperty ? ((HomePieceOfFurniture.SortableProperty)((Object)object2)).name() : ((ObjectProperty)object2).getName();
                if (list.contains(object) && !this.isPropertyAccepted(object2, userPreferences)) continue;
                this.removeColumn(object3);
            }
            for (String string : list) {
                object2 = this.availableColumns.get(string);
                if (object2 == null || this.tableColumns.contains(object2) || !this.isPropertyAccepted(((TableColumn)object2).getIdentifier(), userPreferences)) continue;
                this.addColumn((TableColumn)object2);
            }
            boolean bl = false;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                void var4_10;
                int n2;
                object = this.availableColumns.get(list.get(i));
                if (object == null || (n2 = this.tableColumns.indexOf(object)) == -1) continue;
                if (n2 != var4_10) {
                    this.moveColumn(n2, (int)var4_10);
                }
                ++var4_10;
            }
        }

        private boolean isPropertyAccepted(Object object, UserPreferences userPreferences) {
            if (object instanceof HomePieceOfFurniture.SortableProperty) {
                switch ((HomePieceOfFurniture.SortableProperty)((Object)object)) {
                    case PRICE: {
                        return userPreferences.getCurrency() != null;
                    }
                    case VALUE_ADDED_TAX_PERCENTAGE: 
                    case VALUE_ADDED_TAX: 
                    case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                        return userPreferences.isValueAddedTaxEnabled();
                    }
                }
                return true;
            }
            return ((ObjectProperty)object).isDisplayable();
        }

        private String getColumnName(Object object, UserPreferences userPreferences) {
            if (object instanceof HomePieceOfFurniture.SortableProperty) {
                switch ((HomePieceOfFurniture.SortableProperty)((Object)object)) {
                    case CATALOG_ID: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "catalogIdColumn", new Object[0]);
                    }
                    case NAME: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "nameColumn", new Object[0]);
                    }
                    case DESCRIPTION: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "descriptionColumn", new Object[0]);
                    }
                    case CREATOR: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "creatorColumn", new Object[0]);
                    }
                    case LICENSE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "licenseColumn", new Object[0]);
                    }
                    case WIDTH: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "widthColumn", new Object[0]);
                    }
                    case DEPTH: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "depthColumn", new Object[0]);
                    }
                    case HEIGHT: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "heightColumn", new Object[0]);
                    }
                    case X: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "xColumn", new Object[0]);
                    }
                    case Y: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "yColumn", new Object[0]);
                    }
                    case ELEVATION: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "elevationColumn", new Object[0]);
                    }
                    case ANGLE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "angleColumn", new Object[0]);
                    }
                    case LEVEL: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "levelColumn", new Object[0]);
                    }
                    case MODEL_SIZE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "modelSizeColumn", new Object[0]);
                    }
                    case COLOR: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "colorColumn", new Object[0]);
                    }
                    case TEXTURE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "textureColumn", new Object[0]);
                    }
                    case MOVABLE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "movableColumn", new Object[0]);
                    }
                    case DOOR_OR_WINDOW: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "doorOrWindowColumn", new Object[0]);
                    }
                    case VISIBLE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "visibleColumn", new Object[0]);
                    }
                    case PRICE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "priceColumn", new Object[0]);
                    }
                    case VALUE_ADDED_TAX_PERCENTAGE: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "valueAddedTaxPercentageColumn", new Object[0]);
                    }
                    case VALUE_ADDED_TAX: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "valueAddedTaxColumn", new Object[0]);
                    }
                    case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                        return userPreferences.getLocalizedString(FurnitureTable.class, "priceValueAddedTaxIncludedColumn", new Object[0]);
                    }
                }
            }
            if (object instanceof ObjectProperty) {
                return ((ObjectProperty)object).getDisplayedName();
            }
            throw new IllegalArgumentException("Unknown column name " + object);
        }

        private int getColumnPreferredWidth(Object object) {
            if (object instanceof HomePieceOfFurniture.SortableProperty) {
                switch ((HomePieceOfFurniture.SortableProperty)((Object)object)) {
                    case CATALOG_ID: 
                    case NAME: {
                        return 120;
                    }
                    case DESCRIPTION: 
                    case CREATOR: {
                        return 80;
                    }
                    case LICENSE: {
                        return 70;
                    }
                    case WIDTH: 
                    case DEPTH: 
                    case HEIGHT: 
                    case X: 
                    case Y: 
                    case ELEVATION: 
                    case MODEL_SIZE: {
                        return 50;
                    }
                    case ANGLE: {
                        return 35;
                    }
                    case LEVEL: {
                        return 70;
                    }
                    case COLOR: 
                    case TEXTURE: {
                        return 30;
                    }
                    case MOVABLE: 
                    case DOOR_OR_WINDOW: 
                    case VISIBLE: {
                        return 20;
                    }
                    case PRICE: 
                    case VALUE_ADDED_TAX_PERCENTAGE: 
                    case VALUE_ADDED_TAX: 
                    case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                        return 70;
                    }
                }
            }
            return 50;
        }

        private TableCellRenderer getColumnRenderer(final Object object, final UserPreferences userPreferences) {
            if (object instanceof HomePieceOfFurniture.SortableProperty) {
                switch ((HomePieceOfFurniture.SortableProperty)((Object)object)) {
                    case CATALOG_ID: {
                        return this.getCatalogIdRenderer();
                    }
                    case NAME: {
                        return this.getNameWithIconRenderer();
                    }
                    case DESCRIPTION: {
                        return this.getDescriptionRenderer();
                    }
                    case CREATOR: {
                        return this.getCreatorRenderer();
                    }
                    case LICENSE: {
                        return this.getLicenseRenderer();
                    }
                    case WIDTH: {
                        return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.WIDTH, userPreferences);
                    }
                    case DEPTH: {
                        return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.DEPTH, userPreferences);
                    }
                    case HEIGHT: {
                        return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.HEIGHT, userPreferences);
                    }
                    case X: {
                        return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.X, userPreferences);
                    }
                    case Y: {
                        return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.Y, userPreferences);
                    }
                    case ELEVATION: {
                        return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.ELEVATION, userPreferences);
                    }
                    case ANGLE: {
                        return this.getAngleRenderer();
                    }
                    case LEVEL: {
                        return this.getLevelRenderer();
                    }
                    case MODEL_SIZE: {
                        return this.getModelSizeRenderer();
                    }
                    case COLOR: {
                        return this.getColorRenderer();
                    }
                    case TEXTURE: {
                        return this.getTextureRenderer();
                    }
                    case MOVABLE: {
                        return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.MOVABLE);
                    }
                    case DOOR_OR_WINDOW: {
                        return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW);
                    }
                    case VISIBLE: {
                        return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.VISIBLE);
                    }
                    case PRICE: {
                        return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.PRICE, userPreferences);
                    }
                    case VALUE_ADDED_TAX_PERCENTAGE: {
                        return this.getValueAddedTaxPercentageRenderer();
                    }
                    case VALUE_ADDED_TAX: {
                        return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, userPreferences);
                    }
                    case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                        return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences);
                    }
                }
                throw new IllegalArgumentException("Unknown column name " + object);
            }
            if (object instanceof ObjectProperty) {
                return new DefaultTableCellRenderer(){
                    private TableCellRenderer booleanRenderer;
                    private SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");
                    private NumberFormat defaultPriceFormat = new DecimalFormat("##0.00");

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object2, boolean bl, boolean bl2, int n, int n2) {
                        String string;
                        block34: {
                            ObjectProperty objectProperty = (ObjectProperty)object;
                            string = ((HomePieceOfFurniture)object2).getProperty(objectProperty.getName());
                            if (((HomePieceOfFurniture)object2).isContentProperty(objectProperty.getName())) {
                                Content content = ((HomePieceOfFurniture)object2).getContentProperty(objectProperty.getName());
                                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
                                jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - jTable.getRowMargin(), jTable));
                                jLabel.setHorizontalAlignment(0);
                                return jLabel;
                            }
                            if (objectProperty.getType() == ObjectProperty.Type.BOOLEAN) {
                                if (this.booleanRenderer == null) {
                                    this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                                }
                                JComponent jComponent = (JComponent)this.booleanRenderer.getTableCellRendererComponent(jTable, Boolean.valueOf(string), bl, bl2, n, n2);
                                jComponent.setEnabled(false);
                                return jComponent;
                            }
                            if (string != null) {
                                if (objectProperty.getType() != null && objectProperty.getType() != ObjectProperty.Type.ANY) {
                                    switch (objectProperty.getType()) {
                                        case LENGTH: {
                                            try {
                                                object2 = userPreferences.getLengthUnit().getFormat().format(Float.valueOf(Float.parseFloat(string)));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                object2 = null;
                                            }
                                            this.setHorizontalAlignment(4);
                                            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
                                        }
                                        case DATE: {
                                            try {
                                                object2 = DateFormat.getDateInstance(3).format(this.dateParser.parse(string));
                                            }
                                            catch (ParseException parseException) {
                                                object2 = null;
                                            }
                                            this.setHorizontalAlignment(4);
                                            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
                                        }
                                        case INTEGER: {
                                            try {
                                                object2 = NumberFormat.getIntegerInstance().format(Long.parseLong(string));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                object2 = null;
                                            }
                                            this.setHorizontalAlignment(4);
                                            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
                                        }
                                        case NUMBER: {
                                            try {
                                                object2 = NumberFormat.getNumberInstance().format(Float.parseFloat(string));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                object2 = null;
                                            }
                                            this.setHorizontalAlignment(4);
                                            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
                                        }
                                        case PRICE: {
                                            String string2 = ((HomePieceOfFurniture)object2).getCurrency();
                                            if (string2 == null) {
                                                string2 = userPreferences.getCurrency();
                                            }
                                            NumberFormat numberFormat = this.defaultPriceFormat;
                                            if (string2 != null) {
                                                try {
                                                    numberFormat = NumberFormat.getCurrencyInstance();
                                                    Currency currency = Currency.getInstance(string2);
                                                    numberFormat.setCurrency(currency);
                                                    numberFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
                                                }
                                                catch (IllegalArgumentException illegalArgumentException) {
                                                    // empty catch block
                                                }
                                            }
                                            try {
                                                object2 = numberFormat.format(new BigDecimal(string));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                object2 = null;
                                            }
                                            this.setHorizontalAlignment(4);
                                            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
                                        }
                                        case PERCENTAGE: {
                                            try {
                                                NumberFormat numberFormat = NumberFormat.getPercentInstance();
                                                numberFormat.setMaximumFractionDigits(2);
                                                object2 = numberFormat.format(new BigDecimal(string));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                object2 = null;
                                            }
                                            this.setHorizontalAlignment(4);
                                            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
                                        }
                                        case STRING: 
                                        case CONTENT: {
                                            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                                        }
                                    }
                                } else {
                                    try {
                                        super.getTableCellRendererComponent(jTable, NumberFormat.getInstance().format(new BigDecimal(string)), bl, bl2, n, n2);
                                        this.setHorizontalAlignment(4);
                                        return this;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        if (!"true".equalsIgnoreCase(string) && !"false".equalsIgnoreCase(string)) break block34;
                                        if (this.booleanRenderer == null) {
                                            this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                                        }
                                        JComponent jComponent = (JComponent)this.booleanRenderer.getTableCellRendererComponent(jTable, Boolean.parseBoolean(string), bl, bl2, n, n2);
                                        jComponent.setEnabled(false);
                                        return jComponent;
                                    }
                                }
                            }
                        }
                        super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                        this.setHorizontalAlignment(2);
                        return this;
                    }
                };
            }
            throw new IllegalArgumentException("Unknown column " + object);
        }

        private TableCellRenderer getCatalogIdRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object != null ? ((HomePieceOfFurniture)object).getCatalogId() : null, bl, bl2, n, n2);
                    component.setComponentOrientation(jTable.getComponentOrientation());
                    return component;
                }
            };
        }

        private TableCellRenderer getLevelRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    Level level = object != null ? homePieceOfFurniture.getLevel() : null;
                    Component component = super.getTableCellRendererComponent(jTable, level != null ? level.getName() : null, bl, bl2, n, n2);
                    component.setComponentOrientation(jTable.getComponentOrientation());
                    return component;
                }
            };
        }

        private TableCellRenderer getNameWithIconRenderer() {
            return new TreeTableNameCellRenderer();
        }

        private TableCellRenderer getDescriptionRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).getDescription(), bl, bl2, n, n2);
                    component.setComponentOrientation(jTable.getComponentOrientation());
                    return component;
                }
            };
        }

        private TableCellRenderer getCreatorRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Serializable serializable;
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    String string = homePieceOfFurniture.getCreator();
                    if (string != null) {
                        serializable = homePieceOfFurniture.getTexture();
                        if (serializable != null) {
                            String string2 = ((HomeTexture)serializable).getCreator();
                            if (string2 != null && !string.equals(string2)) {
                                string = string + ", " + string2;
                            }
                        } else {
                            String string3 = string;
                            HomeMaterial[] homeMaterialArray = homePieceOfFurniture.getModelMaterials();
                            if (homeMaterialArray != null) {
                                for (HomeMaterial homeMaterial : homeMaterialArray) {
                                    String string4;
                                    HomeTexture homeTexture;
                                    if (homeMaterial == null || (homeTexture = homeMaterial.getTexture()) == null || (string4 = homeTexture.getCreator()) == null || string3.equals(string4) || string.indexOf(", " + string4) != -1) continue;
                                    string = string + ", " + string4;
                                }
                            }
                        }
                    }
                    serializable = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                    ((Component)serializable).setComponentOrientation(jTable.getComponentOrientation());
                    return serializable;
                }
            };
        }

        private TableCellRenderer getLicenseRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).getLicense(), bl, bl2, n, n2);
                    component.setComponentOrientation(jTable.getComponentOrientation());
                    return component;
                }
            };
        }

        private TableCellRenderer getSizeRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, final UserPreferences userPreferences) {
            switch (sortableProperty) {
                class SizeRenderer
                extends DefaultTableCellRenderer {
                    final /* synthetic */ UserPreferences val$preferences;

                    SizeRenderer() {
                        this.val$preferences = userPreferences;
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        if (object != null) {
                            object = this.val$preferences.getLengthUnit().getFormat().format((Float)object);
                        }
                        this.setHorizontalAlignment(4);
                        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                }
                case WIDTH: {
                    return new SizeRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Float.valueOf(((HomePieceOfFurniture)object).getWidth()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case DEPTH: {
                    return new SizeRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Float.valueOf(((HomePieceOfFurniture)object).getDepth()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case HEIGHT: {
                    return new SizeRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Float.valueOf(((HomePieceOfFurniture)object).getHeight()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case X: {
                    return new SizeRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Float.valueOf(((HomePieceOfFurniture)object).getX()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case Y: {
                    return new SizeRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Float.valueOf(((HomePieceOfFurniture)object).getY()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case ELEVATION: {
                    return new SizeRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Float.valueOf(((HomePieceOfFurniture)object).getElevation()) : null, bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a size column");
        }

        private TableCellRenderer getPriceRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, final UserPreferences userPreferences) {
            switch (sortableProperty) {
                class PriceRenderer
                extends DefaultTableCellRenderer {
                    final /* synthetic */ UserPreferences val$preferences;

                    PriceRenderer() {
                        this.val$preferences = userPreferences;
                    }

                    public Component getTableCellRendererComponent(JTable jTable, BigDecimal bigDecimal, String string, boolean bl, boolean bl2, int n, int n2) {
                        String string2;
                        if (bigDecimal != null) {
                            NumberFormat numberFormat = NumberFormat.getCurrencyInstance();
                            if (string == null) {
                                string = this.val$preferences.getCurrency();
                            }
                            try {
                                Currency currency = Currency.getInstance(string);
                                numberFormat.setCurrency(currency);
                                numberFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            string2 = numberFormat.format(bigDecimal);
                        } else {
                            string2 = null;
                        }
                        this.setHorizontalAlignment(4);
                        return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                    }
                }
                case PRICE: {
                    return new PriceRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            String string;
                            BigDecimal bigDecimal;
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            if (object != null) {
                                bigDecimal = homePieceOfFurniture.getPrice();
                                string = homePieceOfFurniture.getCurrency();
                            } else {
                                bigDecimal = null;
                                string = null;
                            }
                            return super.getTableCellRendererComponent(jTable, bigDecimal, string, bl, bl2, n, n2);
                        }
                    };
                }
                case VALUE_ADDED_TAX: {
                    return new PriceRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            String string;
                            BigDecimal bigDecimal;
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            if (object != null) {
                                bigDecimal = homePieceOfFurniture.getValueAddedTax();
                                string = homePieceOfFurniture.getCurrency();
                            } else {
                                bigDecimal = null;
                                string = null;
                            }
                            return super.getTableCellRendererComponent(jTable, bigDecimal, string, bl, bl2, n, n2);
                        }
                    };
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return new PriceRenderer(){
                        {
                            super(furnitureTableColumnModel, userPreferences2);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            String string;
                            BigDecimal bigDecimal;
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            if (object != null) {
                                bigDecimal = homePieceOfFurniture.getPriceValueAddedTaxIncluded();
                                string = homePieceOfFurniture.getCurrency();
                            } else {
                                bigDecimal = null;
                                string = null;
                            }
                            return super.getTableCellRendererComponent(jTable, bigDecimal, string, bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a price column");
        }

        private TableCellRenderer getAngleRenderer() {
            return new DefaultTableCellRenderer(){
                private TableCellRenderer integerRenderer;

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.integerRenderer == null) {
                        this.integerRenderer = jTable.getDefaultRenderer(Integer.class);
                    }
                    Integer n3 = object != null ? Integer.valueOf((int)(Math.round(Math.toDegrees(((HomePieceOfFurniture)object).getAngle()) + 360.0) % 360L)) : null;
                    return this.integerRenderer.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getModelSizeRenderer() {
            return new DefaultTableCellRenderer(){
                private TableCellRenderer integerRenderer;

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture;
                    if (this.integerRenderer == null) {
                        this.integerRenderer = jTable.getDefaultRenderer(Integer.class);
                    }
                    Integer n3 = (homePieceOfFurniture = (HomePieceOfFurniture)object) != null && homePieceOfFurniture.getModelSize() != null && homePieceOfFurniture.getModelSize() > 0L ? Integer.valueOf(Math.max(1, (int)Math.round((double)homePieceOfFurniture.getModelSize().longValue() / 1000.0))) : null;
                    return this.integerRenderer.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getValueAddedTaxPercentageRenderer() {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    BigDecimal bigDecimal;
                    BigDecimal bigDecimal2 = bigDecimal = object != null ? ((HomePieceOfFurniture)object).getValueAddedTaxPercentage() : null;
                    if (bigDecimal != null) {
                        NumberFormat numberFormat = NumberFormat.getPercentInstance();
                        numberFormat.setMinimumFractionDigits(bigDecimal.scale() - 2);
                        object = numberFormat.format(bigDecimal);
                    } else {
                        object = null;
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getColorRenderer() {
            return new DefaultTableCellRenderer(){
                private Icon squareIcon = new Icon(){

                    @Override
                    public int getIconHeight() {
                        return this.getFont().getSize();
                    }

                    @Override
                    public int getIconWidth() {
                        return this.getIconHeight();
                    }

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        int n3 = this.getIconHeight();
                        graphics.setColor(component.getForeground());
                        graphics.fillRect(n + 2, n2 + 2, n3 - 3, n3 - 3);
                        graphics.setColor(component.getParent().getParent().getForeground());
                        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n3 - 2);
                    }
                };

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Integer n3 = object != null ? ((HomePieceOfFurniture)object).getColor() : null;
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                    if (n3 != null) {
                        jLabel.setText(null);
                        jLabel.setIcon(this.squareIcon);
                        jLabel.setForeground(new Color(n3));
                    } else {
                        if (object != null) {
                            jLabel.setText("-");
                        }
                        jLabel.setIcon(null);
                        jLabel.setForeground(jTable.getForeground());
                    }
                    jLabel.setHorizontalAlignment(0);
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getTextureRenderer() {
            return new DefaultTableCellRenderer(){
                {
                    this.setHorizontalAlignment(0);
                }

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomeTexture homeTexture;
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
                    HomeTexture homeTexture2 = homeTexture = homePieceOfFurniture != null ? homePieceOfFurniture.getTexture() : null;
                    if (homeTexture != null) {
                        Content content = homeTexture.getImage();
                        jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - 2, jTable));
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getBooleanRenderer(HomePieceOfFurniture.SortableProperty sortableProperty) {
            switch (sortableProperty) {
                class BooleanRenderer
                implements TableCellRenderer {
                    private TableCellRenderer booleanRenderer;
                    private final boolean enabled;

                    public BooleanRenderer(boolean bl) {
                        this.enabled = bl;
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        if (this.booleanRenderer == null) {
                            this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                        }
                        Component component = this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        component.setEnabled(this.enabled);
                        return component;
                    }
                }
                case MOVABLE: {
                    return new BooleanRenderer(false){
                        {
                            super(bl);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Boolean.valueOf(((HomePieceOfFurniture)object).isMovable()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case DOOR_OR_WINDOW: {
                    return new BooleanRenderer(false){
                        {
                            super(bl);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, object != null ? Boolean.valueOf(((HomePieceOfFurniture)object).isDoorOrWindow()) : null, bl, bl2, n, n2);
                        }
                    };
                }
                case VISIBLE: {
                    return new BooleanRenderer(true){
                        {
                            super(bl);
                        }

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            Component component = super.getTableCellRendererComponent(jTable, object != null ? Boolean.valueOf(((HomePieceOfFurniture)object).isVisible()) : null, bl, bl2, n, n2);
                            if (object != null) {
                                FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)jTable.getModel();
                                component.setEnabled(furnitureTreeTableModel.getIndexOfChild(furnitureTreeTableModel.getRoot(), object) != -1);
                            }
                            return component;
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a boolean column");
        }

        private TableCellRenderer getHeaderRenderer(final Home home) {
            return new TableCellRenderer(){
                private TableCellRenderer headerRenderer;
                private ImageIcon ascendingSortIcon = new ImageIcon(FurnitureTable.class.getResource("resources/ascending.png"));
                private ImageIcon descendingSortIcon = new ImageIcon(FurnitureTable.class.getResource("resources/descending.png"));

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.headerRenderer == null) {
                        this.headerRenderer = jTable.getTableHeader().getDefaultRenderer();
                    }
                    JLabel jLabel = (JLabel)this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    Object object2 = this.getColumn(n2).getIdentifier();
                    if (object2 instanceof HomePieceOfFurniture.SortableProperty && ((HomePieceOfFurniture.SortableProperty)((Object)object2)).name().equals(home.getFurnitureSortedPropertyName()) || object2 instanceof ObjectProperty && ((ObjectProperty)object2).getName().equals(home.getFurnitureSortedPropertyName())) {
                        jLabel.setHorizontalTextPosition(10);
                        if (home.isFurnitureDescendingSorted()) {
                            jLabel.setIcon(this.descendingSortIcon);
                        } else {
                            jLabel.setIcon(this.ascendingSortIcon);
                        }
                    } else {
                        jLabel.setIcon(null);
                    }
                    jLabel.setComponentOrientation(jTable.getComponentOrientation());
                    return jLabel;
                }
            };
        }

        private static class UserPreferencesChangeListener
        implements PropertyChangeListener {
            private WeakReference<FurnitureTableColumnModel> furnitureTableColumnModel;
            private WeakReference<Home> home;

            public UserPreferencesChangeListener(FurnitureTableColumnModel furnitureTableColumnModel, Home home) {
                this.furnitureTableColumnModel = new WeakReference<FurnitureTableColumnModel>(furnitureTableColumnModel);
                this.home = new WeakReference<Home>(home);
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureTableColumnModel furnitureTableColumnModel = (FurnitureTableColumnModel)this.furnitureTableColumnModel.get();
                Home home = (Home)this.home.get();
                UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
                UserPreferences.Property property = UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName());
                if (furnitureTableColumnModel == null || home == null) {
                    userPreferences.removePropertyChangeListener(property, this);
                } else {
                    switch (property) {
                        case LANGUAGE: {
                            for (TableColumn tableColumn : furnitureTableColumnModel.availableColumns.values()) {
                                Object object = tableColumn.getIdentifier();
                                tableColumn.setHeaderValue(furnitureTableColumnModel.getColumnName(object, userPreferences));
                                tableColumn.setCellRenderer(furnitureTableColumnModel.getColumnRenderer(object, userPreferences));
                            }
                            break;
                        }
                        case CURRENCY: 
                        case VALUE_ADDED_TAX_ENABLED: {
                            furnitureTableColumnModel.updateModelColumns(home.getFurnitureVisiblePropertyNames(), userPreferences);
                            break;
                        }
                    }
                }
            }
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureTable> furnitureTable;

        public UserPreferencesChangeListener(FurnitureTable furnitureTable) {
            this.furnitureTable = new WeakReference<FurnitureTable>(furnitureTable);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureTable furnitureTable = (FurnitureTable)this.furnitureTable.get();
            if (furnitureTable == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                furnitureTable.repaint();
                furnitureTable.getTableHeader().repaint();
            }
        }
    }
}

