/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLevitation;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.Elixir;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;

public class ElixirOfFeatherFall
extends Elixir {
    public ElixirOfFeatherFall() {
        this.image = ItemSpriteSheet.ELIXIR_FEATHER;
        this.talentChance = 0.5f;
    }

    @Override
    public void apply(Hero hero) {
        Buff.append(hero, FeatherBuff.class, 50.0f);
        hero.sprite.emitter().burst(Speck.factory(106), 20);
        GLog.p(Messages.get(this, "light", new Object[0]), new Object[0]);
    }

    @Override
    public int value() {
        return (int)(60.0f * ((float)this.quantity / 2.0f));
    }

    @Override
    public int energyVal() {
        return (int)(12.0f * ((float)this.quantity / 2.0f));
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        private static final int OUT_QUANTITY = 2;

        public Recipe() {
            this.inputs = new Class[]{PotionOfLevitation.class};
            this.inQuantity = new int[]{1};
            this.cost = 16;
            this.output = ElixirOfFeatherFall.class;
            this.outQuantity = 2;
        }
    }

    public static class FeatherBuff
    extends FlavourBuff {
        public static final float DURATION = 50.0f;

        public FeatherBuff() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 1;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(1.0f, 2.0f, 1.25f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (50.0f - this.visualcooldown()) / 50.0f);
        }
    }
}

