/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.protege.editor.owl.ui.renderer.OWLEntityColorProvider;
import org.protege.editor.owl.ui.renderer.OWLEntityColorProviderPlugin;
import org.protege.editor.owl.ui.renderer.OWLEntityColorProviderPluginLoader;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLCellRenderer
implements TableCellRenderer,
TreeCellRenderer,
ListCellRenderer {
    private final Logger logger = LoggerFactory.getLogger(OWLCellRenderer.class);
    private boolean forceReadOnlyRendering;
    private OWLEditorKit owlEditorKit;
    private boolean renderIcon;
    private boolean renderExpression;
    private boolean strikeThrough;
    private OWLOntology ontology;
    private Set<OWLObject> equivalentObjects;
    private LinkedObjectComponent linkedObjectComponent;
    private Font plainFont;
    private Font boldFont;
    public static final Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("List.selectionBackground");
    public static final Color SELECTION_FOREGROUND = UIManager.getDefaults().getColor("List.selectionForeground");
    public static final Color FOREGROUND = UIManager.getDefaults().getColor("List.foreground");
    private boolean ignoreLinks;
    private boolean isLocked = false;
    private final OWLCellRenderer tmp;
    private List<OWLEntityColorProvider> entityColorProviders;
    private OWLObject iconObject;
    private int leftMargin = 0;
    private int rightMargin = 40;
    private JComponent componentBeingRendered;
    private JPanel renderingComponent;
    private final IconComponent iconComponent = new IconComponent();
    private JTextPane textPane;
    private int preferredWidth;
    private int minTextHeight;
    private OWLEntity focusedEntity;
    private boolean commentedOut;
    private boolean feint;
    private boolean highlightKeywords;
    private boolean wrap = true;
    private boolean highlightUnsatisfiableClasses = true;
    private boolean highlightUnsatisfiableProperties = true;
    private Set<OWLEntity> crossedOutEntities;
    private Set<String> unsatisfiableNames;
    private Set<String> boxedNames;
    private boolean opaque = false;
    private boolean renderLinks;
    private ActiveEntityVisitor activeEntityVisitor = new ActiveEntityVisitor();
    private Composite disabledComposite = AlphaComposite.getInstance(3, 0.5f);
    private Style plainStyle;
    private Style boldStyle;
    private Style nonBoldStyle;
    private Style selectionForeground;
    private Style foreground;
    private Style linkStyle;
    private Style inconsistentClassStyle;
    private Style focusedEntityStyle;
    private Style ontologyURIStyle;
    private Style commentedOutStyle;
    private Style feintStyle;
    private Style strikeOutStyle;
    private Style fontSizeStyle;
    private boolean annotURIRendered = false;
    private boolean linkRendered = false;
    private boolean parenthesisRendered = false;

    public OWLCellRenderer(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, true, true);
    }

    public OWLCellRenderer(OWLEditorKit owlEditorKit, boolean renderExpression, boolean renderIcon) {
        this(owlEditorKit, renderExpression, renderIcon, new OWLCellRenderer(owlEditorKit, renderExpression, renderIcon, null));
    }

    OWLCellRenderer(OWLEditorKit owlEditorKit, boolean renderExpression, boolean renderIcon, OWLCellRenderer tmp) {
        this.owlEditorKit = owlEditorKit;
        this.renderExpression = renderExpression;
        this.renderIcon = renderIcon;
        this.equivalentObjects = new HashSet<OWLObject>();
        this.iconComponent.setOpaque(false);
        this.textPane = new JTextPane();
        this.textPane.setOpaque(false);
        this.renderingComponent = new OWLCellRendererPanel(new OWLCellRendererLayoutManager());
        this.renderingComponent.add(this.iconComponent);
        this.renderingComponent.add(this.textPane);
        this.entityColorProviders = new ArrayList<OWLEntityColorProvider>();
        OWLEntityColorProviderPluginLoader loader = new OWLEntityColorProviderPluginLoader(this.getOWLModelManager());
        for (OWLEntityColorProviderPlugin plugin : loader.getPlugins()) {
            try {
                OWLEntityColorProvider prov = (OWLEntityColorProvider)plugin.newInstance();
                prov.initialise();
                this.entityColorProviders.add(prov);
            }
            catch (Exception e) {
                this.logger.error("An error occurred whilst trying to load an OWLEntityColorProviderPlugin", (Throwable)e);
            }
        }
        this.crossedOutEntities = new HashSet<OWLEntity>();
        this.unsatisfiableNames = new HashSet<String>();
        this.boxedNames = new HashSet<String>();
        this.prepareStyles();
        this.setupFont();
        this.tmp = tmp;
    }

    public void setForceReadOnlyRendering(boolean forceReadOnlyRendering) {
        this.forceReadOnlyRendering = forceReadOnlyRendering;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public void setUnsatisfiableNames(Set<String> unsatisfiableNames) {
        this.unsatisfiableNames.clear();
        this.unsatisfiableNames.addAll(unsatisfiableNames);
    }

    public void setHighlightKeywords(boolean hightlighKeywords) {
        this.highlightKeywords = hightlighKeywords;
    }

    public void setHighlightUnsatisfiableClasses(boolean highlightUnsatisfiableClasses) {
        this.highlightUnsatisfiableClasses = highlightUnsatisfiableClasses;
    }

    public void setHighlightUnsatisfiableProperties(boolean highlightUnsatisfiableProperties) {
        this.highlightUnsatisfiableProperties = highlightUnsatisfiableProperties;
    }

    public void setOntology(OWLOntology ont) {
        this.forceReadOnlyRendering = false;
        this.ontology = ont;
    }

    public void setIconObject(OWLObject object) {
        this.iconObject = object;
    }

    public void setCrossedOutEntities(Set<OWLEntity> entities) {
        this.crossedOutEntities.addAll(entities);
    }

    public void addBoxedName(String name) {
        this.boxedNames.add(name);
    }

    public boolean isBoxedName(String name) {
        return this.boxedNames.contains(name);
    }

    public void reset() {
        this.iconObject = null;
        this.rightMargin = 0;
        this.ontology = null;
        this.focusedEntity = null;
        this.commentedOut = false;
        this.feint = false;
        this.strikeThrough = false;
        this.highlightUnsatisfiableClasses = true;
        this.highlightUnsatisfiableProperties = true;
        this.crossedOutEntities.clear();
        this.unsatisfiableNames.clear();
        this.equivalentObjects.clear();
        this.boxedNames.clear();
    }

    public void save() {
        this.tmp.iconObject = this.iconObject;
        this.tmp.rightMargin = this.rightMargin;
        this.tmp.ontology = this.ontology;
        this.tmp.focusedEntity = this.focusedEntity;
        this.tmp.commentedOut = this.commentedOut;
        this.tmp.feint = this.feint;
        this.tmp.strikeThrough = this.strikeThrough;
        this.tmp.highlightUnsatisfiableClasses = this.highlightUnsatisfiableClasses;
        this.tmp.highlightUnsatisfiableProperties = this.highlightUnsatisfiableProperties;
        this.tmp.crossedOutEntities.clear();
        this.tmp.crossedOutEntities.addAll(this.crossedOutEntities);
        this.tmp.unsatisfiableNames.clear();
        this.tmp.unsatisfiableNames.addAll(this.unsatisfiableNames);
        this.tmp.boxedNames.clear();
        this.tmp.boxedNames.addAll(this.boxedNames);
        this.unlock();
    }

    public void restore() {
        this.lock();
        this.iconObject = this.tmp.iconObject;
        this.rightMargin = this.tmp.rightMargin;
        this.ontology = this.tmp.ontology;
        this.focusedEntity = this.tmp.focusedEntity;
        this.commentedOut = this.tmp.commentedOut;
        this.feint = this.tmp.feint;
        this.strikeThrough = this.tmp.strikeThrough;
        this.highlightUnsatisfiableClasses = this.tmp.highlightUnsatisfiableClasses;
        this.highlightUnsatisfiableProperties = this.tmp.highlightUnsatisfiableProperties;
        this.crossedOutEntities.clear();
        this.crossedOutEntities.addAll(this.tmp.crossedOutEntities);
        this.unsatisfiableNames.clear();
        this.unsatisfiableNames.addAll(this.tmp.unsatisfiableNames);
        this.equivalentObjects.clear();
        this.equivalentObjects.addAll(this.tmp.equivalentObjects);
        this.boxedNames.clear();
        this.boxedNames.addAll(this.tmp.boxedNames);
    }

    public void setFocusedEntity(OWLEntity entity) {
        this.focusedEntity = entity;
    }

    public void setEquivalentObjects(Set<OWLObject> objects) {
        this.equivalentObjects.clear();
        this.equivalentObjects.addAll(objects);
    }

    public void setInferred(boolean inferred) {
    }

    public void setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    private void setupFont() {
        this.plainFont = OWLRendererPreferences.getInstance().getFont();
        this.boldFont = this.plainFont.deriveFont(1);
        this.textPane.setFont(this.plainFont);
    }

    protected int getFontSize() {
        return OWLRendererPreferences.getInstance().getFontSize();
    }

    public boolean isRenderExpression() {
        return this.renderExpression;
    }

    public boolean isRenderIcon() {
        return this.renderIcon;
    }

    public void setCommentedOut(boolean commentedOut) {
        this.commentedOut = commentedOut;
    }

    public void setFeint(boolean feint) {
        this.feint = feint;
    }

    public void setRelationshipsDisplayed(boolean relationshipsDisplayed) {
        this.iconComponent.setRelationshipsDisplayed(relationshipsDisplayed);
    }

    public void setRelationship(Object relationship) {
        this.iconComponent.setRelationShip(relationship);
    }

    public void clearRelationship() {
        this.iconComponent.clearRelationship();
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    void lock() {
        if (this.isLocked) {
            throw new RuntimeException("Renderer used recursively without saving the settings!");
        }
        this.isLocked = true;
    }

    void unlock() {
        if (!this.isLocked) {
            throw new RuntimeException("Renderer was not locked!");
        }
        this.reset();
        this.isLocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.lock();
        try {
            this.setupLinkedObjectComponent(table, table.getCellRect(row, column, true));
            this.preferredWidth = table.getParent().getWidth();
            this.componentBeingRendered = table;
            Component component = this.prepareRenderer(value, isSelected, hasFocus);
            return component;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.lock();
        try {
            this.componentBeingRendered = tree;
            Rectangle cellBounds = new Rectangle();
            if (!this.ignoreLinks) {
                this.ignoreLinks = true;
                this.save();
                try {
                    cellBounds = tree.getRowBounds(row);
                }
                finally {
                    this.restore();
                }
                this.ignoreLinks = false;
            }
            this.setupLinkedObjectComponent(tree, cellBounds);
            this.preferredWidth = -1;
            this.minTextHeight = 12;
            Component component = this.prepareRenderer(value, selected, hasFocus);
            return component;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.lock();
        try {
            this.componentBeingRendered = list;
            Rectangle cellBounds = new Rectangle();
            if (!this.ignoreLinks) {
                this.ignoreLinks = true;
                this.save();
                try {
                    cellBounds = list.getCellBounds(index, index);
                }
                finally {
                    this.restore();
                }
                this.ignoreLinks = false;
            }
            this.minTextHeight = 12;
            if (list.getParent() != null) {
                this.preferredWidth = list.getParent().getWidth();
            }
            this.setupLinkedObjectComponent(list, cellBounds);
            Component component = this.prepareRenderer(value, isSelected, cellHasFocus);
            return component;
        }
        finally {
            this.unlock();
        }
    }

    private void setupLinkedObjectComponent(JComponent component, Rectangle cellRect) {
        this.renderLinks = false;
        this.linkedObjectComponent = null;
        if (cellRect == null) {
            return;
        }
        if (component instanceof LinkedObjectComponent && OWLRendererPreferences.getInstance().isRenderHyperlinks()) {
            this.linkedObjectComponent = (LinkedObjectComponent)((Object)component);
            Point mouseLoc = component.getMousePosition();
            if (mouseLoc == null) {
                this.linkedObjectComponent.setLinkedObject(null);
                return;
            }
            this.renderLinks = cellRect.contains(mouseLoc);
        }
    }

    private Component prepareRenderer(Object value, boolean isSelected, boolean hasFocus) {
        this.renderingComponent.setOpaque(isSelected || this.opaque);
        if (value instanceof OWLEntity) {
            OWLEntity entity = (OWLEntity)value;
            OWLDeclarationAxiom declAx = this.getOWLModelManager().getOWLDataFactory().getOWLDeclarationAxiom(entity);
            if (this.getOWLModelManager().getActiveOntology().containsAxiom((OWLAxiom)declAx)) {
                this.ontology = this.getOWLModelManager().getActiveOntology();
            }
            entity.accept((OWLEntityVisitor)this.activeEntityVisitor);
            if (this.getOWLModelManager().isDeprecated((OWLObject)entity)) {
                this.setStrikeThrough(true);
            } else {
                this.setStrikeThrough(false);
            }
        }
        this.prepareTextPane(this.getRendering(value), isSelected);
        if (isSelected) {
            this.renderingComponent.setBackground(SELECTION_BACKGROUND);
            this.textPane.setForeground(SELECTION_FOREGROUND);
        } else {
            this.renderingComponent.setBackground(this.componentBeingRendered.getBackground());
            this.textPane.setForeground(this.componentBeingRendered.getForeground());
        }
        Icon icon = this.getIcon(value);
        this.iconComponent.setIcon(icon);
        this.renderingComponent.revalidate();
        return this.renderingComponent;
    }

    protected String getRendering(Object object) {
        if (object instanceof OWLObject) {
            String rendering = this.getOWLModelManager().getDisabmiguatedRendering((OWLObject)object, RenderingEscapeUtils.RenderingEscapeSetting.UNESCAPED_RENDERING);
            for (OWLObject eqObj : this.equivalentObjects) {
                rendering = rendering + " \u2261 " + this.getOWLModelManager().getRendering(eqObj);
            }
            return rendering;
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected Icon getIcon(Object object) {
        if (!this.renderIcon) {
            return null;
        }
        if (this.iconObject != null) {
            return this.owlEditorKit.getWorkspace().getOWLIconProvider().getIcon(this.iconObject);
        }
        if (object instanceof OWLObject) {
            return this.owlEditorKit.getWorkspace().getOWLIconProvider().getIcon((OWLObject)object);
        }
        return null;
    }

    private OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    protected Color getColor(OWLEntity entity, Color defaultColor) {
        for (OWLEntityColorProvider prov : this.entityColorProviders) {
            Color c = prov.getColor(entity);
            if (c == null) continue;
            return c;
        }
        return defaultColor;
    }

    protected boolean activeOntologyContainsAxioms(OWLEntity owlEntity) {
        return !this.getOWLModelManager().getActiveOntology().getReferencingAxioms((OWLPrimitive)owlEntity).isEmpty();
    }

    private void prepareStyles() {
        StyledDocument doc = this.textPane.getStyledDocument();
        Map<String, Color> keyWordColorMap = this.owlEditorKit.getWorkspace().getKeyWordColorMap();
        for (String keyWord : keyWordColorMap.keySet()) {
            Style s = doc.addStyle(keyWord, null);
            Color color = keyWordColorMap.get(keyWord);
            StyleConstants.setForeground(s, color);
            StyleConstants.setBold(s, true);
        }
        this.plainStyle = doc.addStyle("PLAIN_STYLE", null);
        StyleConstants.setItalic(this.plainStyle, false);
        StyleConstants.setSpaceAbove(this.plainStyle, 0.0f);
        this.boldStyle = doc.addStyle("BOLD_STYLE", null);
        StyleConstants.setBold(this.boldStyle, true);
        this.nonBoldStyle = doc.addStyle("NON_BOLD_STYLE", null);
        StyleConstants.setBold(this.nonBoldStyle, false);
        this.selectionForeground = doc.addStyle("SEL_FG_STYPE", null);
        if (this.selectionForeground != null && SELECTION_FOREGROUND != null) {
            StyleConstants.setForeground(this.selectionForeground, SELECTION_FOREGROUND);
        }
        this.foreground = doc.addStyle("FG_STYLE", null);
        if (this.foreground != null && FOREGROUND != null) {
            StyleConstants.setForeground(this.foreground, FOREGROUND);
        }
        this.linkStyle = doc.addStyle("LINK_STYLE", null);
        StyleConstants.setForeground(this.linkStyle, Color.BLUE);
        StyleConstants.setUnderline(this.linkStyle, true);
        this.inconsistentClassStyle = doc.addStyle("INCONSISTENT_CLASS_STYLE", null);
        StyleConstants.setForeground(this.inconsistentClassStyle, Color.RED);
        this.focusedEntityStyle = doc.addStyle("FOCUSED_ENTITY_STYLE", null);
        StyleConstants.setForeground(this.focusedEntityStyle, Color.BLACK);
        StyleConstants.setBackground(this.focusedEntityStyle, new Color(220, 220, 250));
        this.ontologyURIStyle = doc.addStyle("ONTOLOGY_URI_STYLE", null);
        StyleConstants.setForeground(this.ontologyURIStyle, Color.GRAY);
        this.commentedOutStyle = doc.addStyle("COMMENTED_OUT_STYLE", null);
        StyleConstants.setForeground(this.commentedOutStyle, Color.GRAY);
        StyleConstants.setItalic(this.commentedOutStyle, true);
        this.feintStyle = doc.addStyle("FEINT_STYLE", null);
        StyleConstants.setForeground(this.feintStyle, Color.GRAY);
        this.strikeOutStyle = doc.addStyle("STRIKE_OUT", null);
        StyleConstants.setStrikeThrough(this.strikeOutStyle, true);
        StyleConstants.setBold(this.strikeOutStyle, false);
        this.fontSizeStyle = doc.addStyle("FONT_SIZE", null);
        StyleConstants.setFontSize(this.fontSizeStyle, 40);
    }

    private void prepareTextPane(Object value, boolean selected) {
        this.textPane.setBorder(null);
        String theVal = value.toString();
        if (!this.wrap) {
            theVal = theVal.replace('\n', ' ');
            theVal = theVal.replaceAll(" [ ]+", " ");
        }
        this.textPane.setText(theVal);
        if (this.commentedOut) {
            this.textPane.setText(this.textPane.getText());
        }
        StyledDocument doc = this.textPane.getStyledDocument();
        this.resetStyles(doc);
        if (selected) {
            doc.setParagraphAttributes(0, doc.getLength(), this.selectionForeground, false);
        } else {
            doc.setParagraphAttributes(0, doc.getLength(), this.foreground, false);
        }
        if (this.commentedOut) {
            doc.setParagraphAttributes(0, doc.getLength(), this.commentedOutStyle, false);
            return;
        }
        if (this.strikeThrough) {
            doc.setParagraphAttributes(0, doc.getLength(), this.strikeOutStyle, false);
        }
        if (this.ontology != null) {
            if (OWLRendererPreferences.getInstance().isHighlightActiveOntologyStatements() && this.getOWLModelManager().getActiveOntology().equals(this.ontology)) {
                doc.setParagraphAttributes(0, doc.getLength(), this.boldStyle, false);
            } else {
                doc.setParagraphAttributes(0, doc.getLength(), this.nonBoldStyle, false);
            }
        } else {
            this.textPane.setFont(this.plainFont);
        }
        if (this.feint) {
            doc.setParagraphAttributes(0, doc.getLength(), this.feintStyle, false);
        }
        if (this.ontology != null) {
            if (this.getOWLModelManager().isMutable(this.ontology)) {
                this.textPane.setEnabled(!this.forceReadOnlyRendering);
            } else {
                this.textPane.setEnabled(false);
            }
        } else if (value instanceof OWLEntity && this.activeOntologyContainsAxioms((OWLEntity)value)) {
            this.textPane.setFont(this.boldFont);
        }
        this.highlightText(doc, selected);
        if (selected && this.selectionForeground != null) {
            doc.setCharacterAttributes(0, doc.getLength(), this.selectionForeground, false);
        }
    }

    protected void highlightText(StyledDocument doc, boolean selected) {
        StringTokenizer tokenizer = new StringTokenizer(this.textPane.getText(), " []{}(),\n\t'", true);
        this.linkRendered = false;
        this.annotURIRendered = false;
        int tokenStartIndex = 0;
        while (tokenizer.hasMoreTokens()) {
            String curToken = tokenizer.nextToken();
            if (curToken.equals("'")) {
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    curToken = curToken + s;
                    if (!s.equals("'")) continue;
                    break;
                }
            }
            this.renderToken(curToken, tokenStartIndex, doc, selected);
            tokenStartIndex += curToken.length();
        }
        if (this.renderLinks && !this.linkRendered) {
            this.linkedObjectComponent.setLinkedObject(null);
        }
    }

    protected void renderToken(String curToken, int tokenStartIndex, StyledDocument doc, boolean selected) {
        boolean enclosedByBracket = false;
        if (this.parenthesisRendered) {
            this.parenthesisRendered = false;
            enclosedByBracket = true;
        }
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        int tokenLength = curToken.length();
        Color c = this.owlEditorKit.getWorkspace().getKeyWordColorMap().get(curToken);
        if (c != null && prefs.isHighlightKeyWords() && this.highlightKeywords) {
            Style s = doc.getStyle(curToken);
            doc.setCharacterAttributes(tokenStartIndex, tokenLength, s, true);
        } else {
            OWLEntity curEntity = this.getOWLModelManager().getOWLEntityFinder().getOWLEntity(curToken);
            if (curEntity != null) {
                if (this.focusedEntity != null && !selected) {
                    if (curEntity.equals(this.focusedEntity)) {
                        doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.focusedEntityStyle, true);
                    }
                } else if (this.highlightUnsatisfiableClasses && curEntity instanceof OWLClass) {
                    try {
                        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_CLASS_UNSATISFIABILITY, () -> {
                            OWLReasoner reasoner = this.getOWLModelManager().getReasoner();
                            boolean consistent = reasoner.isConsistent();
                            if (!consistent || !this.getOWLModelManager().getReasoner().isSatisfiable((OWLClassExpression)((OWLClass)curEntity))) {
                                doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.inconsistentClassStyle, true);
                            }
                        });
                    }
                    catch (Exception e) {
                        this.logger.error("An error occurred whilst rendering a token. Token: {}; Token start index: {}", new Object[]{curToken, tokenStartIndex, e});
                    }
                } else if (this.highlightUnsatisfiableProperties && curEntity instanceof OWLObjectProperty) {
                    this.highlightPropertyIfUnsatisfiable(curEntity, doc, tokenStartIndex, tokenLength);
                }
                if (this.getOWLModelManager().isDeprecated((OWLObject)curEntity)) {
                    this.setStrikeThrough(true);
                } else {
                    this.setStrikeThrough(false);
                }
                this.strikeoutEntityIfCrossedOut(curEntity, doc, tokenStartIndex, tokenLength);
                if (this.renderLinks) {
                    this.renderHyperlink(curEntity, tokenStartIndex, tokenLength, doc);
                }
            } else if (this.highlightUnsatisfiableClasses && this.unsatisfiableNames.contains(curToken)) {
                doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.inconsistentClassStyle, true);
            } else {
                switch (curToken) {
                    case " ": {
                        break;
                    }
                    case "(": {
                        this.parenthesisRendered = true;
                        break;
                    }
                    case ")": {
                        break;
                    }
                    case "[": {
                        break;
                    }
                    case "]": {
                        break;
                    }
                    case "{": {
                        break;
                    }
                    case "}": {
                        break;
                    }
                    case ",": {
                        break;
                    }
                    case "\n": {
                        break;
                    }
                    case "\t": {
                        break;
                    }
                    case "'": {
                        break;
                    }
                    default: {
                        if (!this.isOntologyURI(curToken)) break;
                        this.fadeOntologyURI(doc, tokenStartIndex, tokenLength, enclosedByBracket);
                    }
                }
            }
        }
    }

    private void renderHyperlink(OWLEntity curEntity, int tokenStartIndex, int tokenLength, StyledDocument doc) {
        try {
            Rectangle startRect = this.textPane.modelToView(tokenStartIndex);
            Rectangle endRect = this.textPane.modelToView(tokenStartIndex + tokenLength);
            if (startRect != null && endRect != null) {
                int width = endRect.x - startRect.x;
                int heght = startRect.height;
                Rectangle tokenRect = new Rectangle(startRect.x, startRect.y, width, heght);
                tokenRect.grow(0, -2);
                Point mouseCellLocation = this.linkedObjectComponent.getMouseCellLocation();
                if (mouseCellLocation != null && tokenRect.contains(mouseCellLocation = SwingUtilities.convertPoint(this.renderingComponent, mouseCellLocation, this.textPane))) {
                    doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.linkStyle, false);
                    this.linkedObjectComponent.setLinkedObject((OWLObject)curEntity);
                    this.linkRendered = true;
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean isOntologyURI(String token) {
        try {
            URI uri = new URI(token);
            if (uri.isAbsolute()) {
                IRI iri = IRI.create((URI)uri);
                OWLOntology ont = this.getOWLModelManager().getOWLOntologyManager().getOntology(iri);
                if (this.getOWLModelManager().getActiveOntologies().contains(ont)) {
                    return true;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    private void fadeOntologyURI(StyledDocument doc, int tokenStartIndex, int tokenLength, boolean enclosedByBracket) {
        int start = tokenStartIndex;
        int length = tokenLength;
        if (enclosedByBracket) {
            --start;
            length += 2;
        }
        doc.setCharacterAttributes(start, length, this.ontologyURIStyle, true);
    }

    private void strikeoutEntityIfCrossedOut(OWLEntity entity, StyledDocument doc, int tokenStartIndex, int tokenLength) {
        if (this.crossedOutEntities.contains(entity) || this.strikeThrough) {
            doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.strikeOutStyle, false);
        }
    }

    private void highlightPropertyIfUnsatisfiable(OWLEntity entity, StyledDocument doc, int tokenStartIndex, int tokenLength) {
        try {
            this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_OBJECT_PROPERTY_UNSATISFIABILITY, () -> {
                OWLObjectProperty prop = (OWLObjectProperty)entity;
                OWLReasoner reasoner = this.getOWLModelManager().getReasoner();
                boolean consistent = reasoner.isConsistent();
                if (!consistent || reasoner.getBottomObjectPropertyNode().contains((OWLObject)prop)) {
                    doc.setCharacterAttributes(tokenStartIndex, tokenLength, this.inconsistentClassStyle, true);
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("An error occurred whilst highlighting an unsatisfiable property: {}", (Throwable)e);
        }
    }

    private void resetStyles(StyledDocument doc) {
        doc.setParagraphAttributes(0, doc.getLength(), this.plainStyle, true);
        StyleConstants.setFontSize(this.fontSizeStyle, this.getFontSize());
        Font f = OWLRendererPreferences.getInstance().getFont();
        StyleConstants.setFontFamily(this.fontSizeStyle, f.getFamily());
        doc.setParagraphAttributes(0, doc.getLength(), this.fontSizeStyle, false);
        this.setupFont();
    }

    private static final class IconComponent
    extends JPanel {
        private static final BasicStroke RELATIONSHIP_STROKE = new BasicStroke(1.5f);
        private static final Color UNSPECIFIED_RELATIONSHIP_COLOR = new Color(190, 190, 190);
        @Nullable
        private Icon icon;
        private Dimension preferredSize = new Dimension();
        @Nullable
        private Object relationship = null;
        private boolean relationshipsDisplayed;

        private IconComponent() {
        }

        public void setRelationshipsDisplayed(boolean relationshipsDisplayed) {
            this.relationshipsDisplayed = relationshipsDisplayed;
            this.updatePreferredSize();
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
            this.updatePreferredSize();
        }

        private void updatePreferredSize() {
            int prefWidth = 0;
            int prefHeight = 0;
            if (this.icon != null) {
                prefHeight = this.icon.getIconHeight();
                prefWidth = this.icon.getIconWidth();
            }
            if (this.relationshipsDisplayed) {
                prefWidth += 18;
            }
            this.preferredSize.width = prefWidth;
            this.preferredSize.height = prefHeight;
        }

        public void setRelationShip(Object relationShip) {
            this.relationship = relationShip;
            this.updatePreferredSize();
        }

        public void clearRelationship() {
            this.relationship = null;
            this.updatePreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int xOffset = 1;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.relationshipsDisplayed) {
                g2.setStroke(RELATIONSHIP_STROKE);
                if (this.relationship != null) {
                    g.setColor(OWLSystemColors.getOWLObjectPropertyColor());
                } else {
                    g.setColor(UNSPECIFIED_RELATIONSHIP_COLOR);
                }
                int lineY = this.preferredSize.height / 2;
                g.drawLine(xOffset + 5, lineY, xOffset + 14, lineY);
                g.drawLine(xOffset + 4, lineY, xOffset + 6, lineY - 2);
                g.drawLine(xOffset + 4, lineY, xOffset + 6, lineY + 2);
                xOffset += 16;
            }
            if (this.icon != null) {
                this.icon.paintIcon(this, g, xOffset, 0);
            }
        }
    }

    private class OWLCellRendererLayoutManager
    implements LayoutManager2 {
        private OWLCellRendererLayoutManager() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int width;
            int textHeight;
            JList list;
            if (OWLCellRenderer.this.componentBeingRendered instanceof JList && (list = (JList)OWLCellRenderer.this.componentBeingRendered).getFixedCellHeight() != -1) {
                return new Dimension(list.getWidth(), list.getHeight());
            }
            Dimension preferredSize = OWLCellRenderer.this.iconComponent.getPreferredSize();
            int iconWidth = preferredSize.width + 2;
            int iconHeight = preferredSize.height;
            Insets rcInsets = OWLCellRenderer.this.renderingComponent.getInsets();
            if (OWLCellRenderer.this.preferredWidth != -1) {
                int textWidth = OWLCellRenderer.this.preferredWidth - iconWidth - rcInsets.left - rcInsets.right;
                View v = OWLCellRenderer.this.textPane.getUI().getRootView(OWLCellRenderer.this.textPane);
                v.setSize(textWidth, 2.1474836E9f);
                textHeight = (int)v.getMinimumSpan(1);
                width = OWLCellRenderer.this.preferredWidth;
            } else {
                int textWidth = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().width;
                textHeight = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().height;
                width = textWidth + iconWidth;
            }
            int height = textHeight < iconHeight ? iconHeight : textHeight;
            int minHeight = OWLCellRenderer.this.minTextHeight;
            if (height < minHeight) {
                height = minHeight;
            }
            int totalWidth = width + rcInsets.left + rcInsets.right;
            int totalHeight = height + rcInsets.top + rcInsets.bottom;
            return new Dimension(totalWidth + 10, totalHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            int topOffset;
            int textHeight;
            int textWidth;
            Insets rcInsets = OWLCellRenderer.this.renderingComponent.getInsets();
            Dimension iconPreferredSize = OWLCellRenderer.this.iconComponent.getPreferredSize();
            if (OWLCellRenderer.this.preferredWidth != -1) {
                textWidth = OWLCellRenderer.this.preferredWidth - iconPreferredSize.width - rcInsets.left - rcInsets.right;
                View v = OWLCellRenderer.this.textPane.getUI().getRootView(OWLCellRenderer.this.textPane);
                v.setSize(textWidth, 2.1474836E9f);
                textHeight = (int)v.getMinimumSpan(1);
            } else {
                textWidth = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().width;
                textHeight = ((OWLCellRenderer)OWLCellRenderer.this).textPane.getPreferredSize().height;
                if (textHeight < OWLCellRenderer.this.minTextHeight) {
                    textHeight = OWLCellRenderer.this.minTextHeight;
                }
            }
            int leftOffset = rcInsets.left;
            int textPaneY = topOffset = rcInsets.top;
            OWLCellRenderer.this.iconComponent.setBounds(leftOffset, topOffset, iconPreferredSize.width, iconPreferredSize.height);
            OWLCellRenderer.this.textPane.setBounds(leftOffset + iconPreferredSize.width + 2, textPaneY, textWidth, textHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }

    private class ActiveEntityVisitor
    implements OWLEntityVisitor {
        private ActiveEntityVisitor() {
        }

        public void visit(OWLClass cls) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(cls).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLDatatype dataType) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(dataType).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLNamedIndividual individual) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms((OWLIndividual)individual).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLDataProperty property) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(property).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLObjectProperty property) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms((OWLObjectPropertyExpression)property).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }

        public void visit(OWLAnnotationProperty property) {
            if (!OWLCellRenderer.this.getOWLModelManager().getActiveOntology().getAxioms(property).isEmpty()) {
                OWLCellRenderer.this.ontology = OWLCellRenderer.this.getOWLModelManager().getActiveOntology();
            }
        }
    }

    private class OWLCellRendererPanel
    extends JPanel {
        private OWLCellRendererPanel(LayoutManager layout) {
            super(layout);
        }
    }
}

