# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.generic_movie_writer import GenericMovieWriter


class FFMPEGWriter(GenericMovieWriter):
    """
    FFMPEGWriter - Uses the FFMPEG library to write video files.
    
    Superclass: GenericMovieWriter
    
    FFMPEGWriter is an adapter that allows VTK to use the LGPL'd
    FFMPEG library to write movie files. FFMPEG can create a variety of
    multimedia file formats and can use a variety of encoding algorithms
    (codecs). This class creates .avi files containing MP43 encoded video
    without audio.
    
    The FFMPEG multimedia library source code can be obtained from the
    sourceforge web site at http://ffmpeg.sourceforge.net/download.php or
    is a tarball along with installation instructions at
    http://www.vtk.org/files/support/ffmpeg_source.tar.gz
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFFMPEGWriter, obj, update, **traits)
    
    compression = tvtk_base.true_bool_trait(desc=\
        """
        Turns on(the default) or off compression. Turning off compression
        overrides quality setting.
        """
    )

    def _compression_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompression,
                        self.compression_)

    bit_rate = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the bit-rate
        """
    )

    def _bit_rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBitRate,
                        self.bit_rate)

    bit_rate_tolerance = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set/Get the bit-rate tolerance
        """
    )

    def _bit_rate_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBitRateTolerance,
                        self.bit_rate_tolerance)

    quality = traits.Trait(2, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the compression quality. 0 means worst quality and
        smallest file size 2 means best quality and largest file size
        """
    )

    def _quality_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuality,
                        self.quality)

    rate = traits.Trait(25, traits.Range(1, 5000, enter_set=True, auto_set=False), desc=\
        """
        Set/Get the frame rate, in frame/s.
        """
    )

    def _rate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRate,
                        self.rate)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('compression', 'GetCompression'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('bit_rate', 'GetBitRate'),
    ('bit_rate_tolerance', 'GetBitRateTolerance'), ('quality',
    'GetQuality'), ('rate', 'GetRate'), ('file_name', 'GetFileName'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compression', 'debug', 'global_warning_display',
    'release_data_flag', 'bit_rate', 'bit_rate_tolerance', 'file_name',
    'progress_text', 'quality', 'rate'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FFMPEGWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FFMPEGWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compression'], [], ['bit_rate', 'bit_rate_tolerance',
            'file_name', 'quality', 'rate']),
            title='Edit FFMPEGWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FFMPEGWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

