/**
 * Forcibly set the version of the bridge, for use by other components.
 * This will override `getBridgeVersion`s default behaviour of fetching the
 * version from package.json.
 * @param version A version string e.g. `v1.0.0`
 */
export declare function setBridgeVersion(version: string): void;
/**
 * Get the current version of the bridge from the package.json file.
 * @param packageJsonPath The path to the package.json of the bridge.
 * @returns Either the version number, or unknown.
 */
export declare function getBridgeVersion(packageJsonPath?: string): string;
