/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlNode;
import nokogiri.XmlRelaxng;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.IgnoreSchemaErrorsErrorHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SchemaErrorHandler;
import nokogiri.internals.XmlDomParserContext;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@JRubyClass(name={"Nokogiri::XML::Schema"})
public class XmlSchema
extends RubyObject {
    private Validator validator;

    public XmlSchema(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private Schema getSchema(Source source, String string, String string2) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        SchemaResourceResolver schemaResourceResolver = new SchemaResourceResolver(string, string2, null);
        schemaFactory.setResourceResolver(schemaResourceResolver);
        schemaFactory.setErrorHandler(new IgnoreSchemaErrorsErrorHandler());
        return schemaFactory.newSchema(source);
    }

    private void setValidator(Validator validator) {
        this.validator = validator;
    }

    static XmlSchema createSchemaInstance(ThreadContext threadContext, RubyClass rubyClass, Source source) {
        Ruby ruby = threadContext.getRuntime();
        XmlSchema xmlSchema = (XmlSchema)NokogiriService.XML_SCHEMA_ALLOCATOR.allocate(ruby, rubyClass);
        xmlSchema.setInstanceVariable("@errors", (IRubyObject)ruby.newEmptyArray());
        try {
            Schema schema = xmlSchema.getSchema(source, threadContext.getRuntime().getCurrentDirectory(), threadContext.getRuntime().getInstanceConfig().getScriptFileName());
            xmlSchema.setValidator(schema.newValidator());
            return xmlSchema;
        }
        catch (SAXException sAXException) {
            throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + sAXException.getMessage());
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject from_document(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlDocument xmlDocument = (XmlDocument)((XmlNode)iRubyObject2).document(threadContext);
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        if (!rubyArray.isEmpty()) {
            throw new RaiseException((RubyException)((XmlSyntaxError)rubyArray.first()));
        }
        DOMSource dOMSource = new DOMSource(xmlDocument.getDocument());
        IRubyObject iRubyObject3 = xmlDocument.url(threadContext);
        if (!iRubyObject3.isNil()) {
            dOMSource.setSystemId(iRubyObject3.convertToString().asJavaString());
        }
        return XmlSchema.getSchema(threadContext, (RubyClass)iRubyObject, dOMSource);
    }

    private static IRubyObject getSchema(ThreadContext threadContext, RubyClass rubyClass, Source source) {
        String string = rubyClass.getName();
        if ("Nokogiri::XML::Schema".equals(string)) {
            return XmlSchema.createSchemaInstance(threadContext, rubyClass, source);
        }
        if ("Nokogiri::XML::RelaxNG".equals(string)) {
            return XmlRelaxng.createSchemaInstance(threadContext, rubyClass, source);
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().asJavaString();
        return XmlSchema.getSchema(threadContext, (RubyClass)iRubyObject, new StreamSource(new StringReader(string)));
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject validate_document(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.validate_document_or_file(threadContext, (XmlDocument)iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject validate_file(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(ruby, (IRubyObject)RubyFixnum.newFixnum((Ruby)ruby, (long)1L));
        xmlDomParserContext.setInputSourceFile(threadContext, iRubyObject);
        XmlDocument xmlDocument = xmlDomParserContext.parse(threadContext, (IRubyObject)NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"), ruby.getNil());
        return this.validate_document_or_file(threadContext, xmlDocument);
    }

    IRubyObject validate_document_or_file(ThreadContext threadContext, XmlDocument xmlDocument) {
        RubyArray rubyArray = (RubyArray)this.getInstanceVariable("@errors");
        SchemaErrorHandler schemaErrorHandler = new SchemaErrorHandler(threadContext.runtime, rubyArray);
        this.setErrorHandler(schemaErrorHandler);
        try {
            this.validate(xmlDocument.getDocument());
        }
        catch (SAXException sAXException) {
            XmlSyntaxError xmlSyntaxError = XmlSyntaxError.createXMLSyntaxError(threadContext.runtime);
            xmlSyntaxError.setException(sAXException);
            rubyArray.append((IRubyObject)xmlSyntaxError);
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newIOError(iOException.getMessage());
        }
        return rubyArray;
    }

    protected void setErrorHandler(ErrorHandler errorHandler) {
        this.validator.setErrorHandler(errorHandler);
    }

    protected void validate(Document document) throws SAXException, IOException {
        DOMSource dOMSource = new DOMSource(document);
        this.validator.validate(dOMSource);
    }

    private class SchemaLSInput
    implements LSInput {
        protected String fPublicId;
        protected String fSystemId;
        protected String fBaseSystemId;
        protected InputStream fByteStream;
        protected Reader fCharStream;
        protected String fData;
        protected String fEncoding;
        protected boolean fCertifiedText = false;

        private SchemaLSInput() {
        }

        @Override
        public String getBaseURI() {
            return this.fBaseSystemId;
        }

        @Override
        public InputStream getByteStream() {
            return this.fByteStream;
        }

        @Override
        public boolean getCertifiedText() {
            return this.fCertifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.fCharStream;
        }

        @Override
        public String getEncoding() {
            return this.fEncoding;
        }

        @Override
        public String getPublicId() {
            return this.fPublicId;
        }

        @Override
        public String getStringData() {
            return this.fData;
        }

        @Override
        public String getSystemId() {
            return this.fSystemId;
        }

        @Override
        public void setBaseURI(String string) {
            this.fBaseSystemId = string;
        }

        @Override
        public void setByteStream(InputStream inputStream) {
            this.fByteStream = inputStream;
        }

        @Override
        public void setCertifiedText(boolean bl) {
            this.fCertifiedText = bl;
        }

        @Override
        public void setCharacterStream(Reader reader) {
            this.fCharStream = reader;
        }

        @Override
        public void setEncoding(String string) {
            this.fEncoding = string;
        }

        @Override
        public void setPublicId(String string) {
            this.fPublicId = string;
        }

        @Override
        public void setStringData(String string) {
            this.fData = string;
        }

        @Override
        public void setSystemId(String string) {
            this.fSystemId = string;
        }
    }

    private class SchemaResourceResolver
    implements LSResourceResolver {
        SchemaLSInput lsInput;
        String currentDir;
        String scriptFileName;

        SchemaResourceResolver(String string, String string2, Object object) {
            this.lsInput = new SchemaLSInput();
            this.currentDir = string;
            this.scriptFileName = string2;
            if (object == null) {
                return;
            }
            if (object instanceof String) {
                this.lsInput.setStringData((String)object);
            } else if (object instanceof Reader) {
                this.lsInput.setCharacterStream((Reader)object);
            } else if (object instanceof InputStream) {
                this.lsInput.setByteStream((InputStream)object);
            }
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            String string6 = NokogiriHelpers.adjustSystemIdIfNecessary(this.currentDir, this.scriptFileName, string5, string4);
            this.lsInput.setPublicId(string3);
            this.lsInput.setSystemId(string6 != null ? string6 : string4);
            this.lsInput.setBaseURI(string5);
            return this.lsInput;
        }
    }
}

