"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var events_1 = require("../../../../utils/events");
var crosshair_utils_1 = require("../../crosshair/crosshair_utils");
var common_1 = require("../utils/common");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_series_geometries_1 = require("./compute_series_geometries");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_geometries_index_keys_1 = require("./get_geometries_index_keys");
var get_oriented_projected_pointer_position_1 = require("./get_oriented_projected_pointer_position");
var get_specs_1 = require("./get_specs");
var is_tooltip_snap_enabled_1 = require("./is_tooltip_snap_enabled");
var getExternalPointerEventStateSelector = function (state) { return state.externalEvents.pointer; };
exports.getCursorBandPositionSelector = re_reselect_1.default([
    get_oriented_projected_pointer_position_1.getOrientedProjectedPointerPositionSelector,
    getExternalPointerEventStateSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    compute_series_geometries_1.computeSeriesGeometriesSelector,
    get_specs_1.getSeriesSpecsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    is_tooltip_snap_enabled_1.isTooltipSnapEnableSelector,
    get_geometries_index_keys_1.getGeometriesIndexKeysSelector,
], function (orientedProjectedPointerPosition, externalPointerEvent, chartDimensions, settingsSpec, seriesGeometries, seriesSpec, totalBarsInCluster, isTooltipSnapEnabled, geometriesIndexKeys) {
    return getCursorBand(orientedProjectedPointerPosition, externalPointerEvent, chartDimensions.chartDimensions, settingsSpec, seriesGeometries.scales.xScale, seriesSpec, totalBarsInCluster, isTooltipSnapEnabled, geometriesIndexKeys);
})(get_chart_id_1.getChartIdSelector);
function getCursorBand(orientedProjectedPoinerPosition, externalPointerEvent, chartDimensions, settingsSpec, xScale, seriesSpecs, totalBarsInCluster, isTooltipSnapEnabled, geometriesIndexKeys) {
    var isLineAreaOnly = common_1.isLineAreaOnlyChart(seriesSpecs);
    if (!xScale) {
        return;
    }
    var pointerPosition = orientedProjectedPoinerPosition;
    var xValue;
    var fromExternalEvent = false;
    if (events_1.isValidPointerOverEvent(xScale, externalPointerEvent)) {
        fromExternalEvent = true;
        var x = xScale.pureScale(externalPointerEvent.value);
        if (x == null || x > chartDimensions.width || x < 0) {
            return;
        }
        pointerPosition = { x: x, y: 0 };
        xValue = {
            value: externalPointerEvent.value,
            withinBandwidth: true,
        };
    }
    else {
        xValue = xScale.invertWithStep(orientedProjectedPoinerPosition.x, geometriesIndexKeys);
        if (!xValue) {
            return;
        }
    }
    var cursorBand = crosshair_utils_1.getCursorBandPosition(settingsSpec.rotation, chartDimensions, pointerPosition, {
        value: xValue.value,
        withinBandwidth: true,
    }, isTooltipSnapEnabled, xScale, isLineAreaOnly ? 1 : totalBarsInCluster);
    return __assign(__assign({}, cursorBand), { fromExternalEvent: fromExternalEvent });
}
//# sourceMappingURL=get_cursor_band.js.map