"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var constants_1 = require("../../../../specs/constants");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var common_1 = require("../utils/common");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var MIN_AREA_SIZE = 1;
var getMouseDownPosition = function (state) { return state.interactions.pointer.down; };
var getCurrentPointerPosition = function (state) { return state.interactions.pointer.current.position; };
exports.getBrushAreaSelector = re_reselect_1.default([
    getMouseDownPosition,
    getCurrentPointerPosition,
    get_chart_rotation_1.getChartRotationSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
], function (mouseDownPosition, end, chartRotation, _a, _b) {
    var chartDimensions = _a.chartDimensions;
    var brushAxis = _b.brushAxis;
    if (!mouseDownPosition) {
        return null;
    }
    var start = {
        x: mouseDownPosition.position.x,
        y: mouseDownPosition.position.y,
    };
    switch (brushAxis) {
        case constants_1.BrushAxis.Y:
            return getBrushForYAxis(chartDimensions, chartRotation, start, end);
        case constants_1.BrushAxis.Both:
            return getBrushForBothAxis(chartDimensions, start, end);
        case constants_1.BrushAxis.X:
        default:
            return getBrushForXAxis(chartDimensions, chartRotation, start, end);
    }
})(get_chart_id_1.getChartIdSelector);
function getBrushForXAxis(chartDimensions, chartRotation, start, end) {
    var rotated = common_1.isVerticalRotation(chartRotation);
    return {
        left: rotated ? 0 : getLeftPoint(chartDimensions, start),
        top: rotated ? getTopPoint(chartDimensions, start) : 0,
        height: rotated ? getMinimalHeight(start, end) : chartDimensions.height,
        width: rotated ? chartDimensions.width : getMinimalWidth(start, end),
    };
}
exports.getBrushForXAxis = getBrushForXAxis;
function getBrushForYAxis(chartDimensions, chartRotation, start, end) {
    var rotated = common_1.isVerticalRotation(chartRotation);
    return {
        left: rotated ? getLeftPoint(chartDimensions, start) : 0,
        top: rotated ? 0 : getTopPoint(chartDimensions, start),
        height: rotated ? chartDimensions.height : getMinimalHeight(start, end),
        width: rotated ? getMinimalWidth(start, end) : chartDimensions.width,
    };
}
exports.getBrushForYAxis = getBrushForYAxis;
function getBrushForBothAxis(chartDimensions, start, end) {
    return {
        left: getLeftPoint(chartDimensions, start),
        top: getTopPoint(chartDimensions, start),
        height: getMinimalHeight(start, end),
        width: getMinimalWidth(start, end),
    };
}
exports.getBrushForBothAxis = getBrushForBothAxis;
function getLeftPoint(_a, _b) {
    var left = _a.left;
    var x = _b.x;
    return x - left;
}
exports.getLeftPoint = getLeftPoint;
function getTopPoint(_a, _b) {
    var top = _a.top;
    var y = _b.y;
    return y - top;
}
exports.getTopPoint = getTopPoint;
function getMinimalHeight(start, end, min) {
    if (min === void 0) { min = MIN_AREA_SIZE; }
    var height = end.y - start.y;
    if (Math.abs(height) < min) {
        return min;
    }
    return height;
}
function getMinimalWidth(start, end, min) {
    if (min === void 0) { min = MIN_AREA_SIZE; }
    var width = end.x - start.x;
    if (Math.abs(width) < min) {
        return min;
    }
    return width;
}
//# sourceMappingURL=get_brush_area.js.map