"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var config_types_1 = require("../../layout/types/config_types");
var constants_1 = require("../../layout/utils/constants");
var EPSILON = 1e-6;
function getSectorShapeFromCanvasArc(x, y, r, a0, a1, ccw) {
    var cw = Number(!ccw);
    var da = ccw ? a0 - a1 : a1 - a0;
    return "A" + r + "," + r + ",0," + +(da >= Math.PI) + "," + cw + "," + (x + r * Math.cos(a1)) + "," + (y + r * Math.sin(a1));
}
function renderRectangles(geometry, key, style) {
    var x0 = geometry.x0, x1 = geometry.x1, y0px = geometry.y0px, y1px = geometry.y1px;
    var props = style.color ? { fill: style.color } : { className: style.fillClassName };
    return react_1.default.createElement("rect", __assign({ key: key, x: x0, y: y0px, width: Math.abs(x1 - x0), height: Math.abs(y1px - y0px) }, props));
}
function renderSector(geometry, key, style) {
    var x0 = geometry.x0, x1 = geometry.x1, y0px = geometry.y0px, y1px = geometry.y1px;
    if ((Math.abs(x0 - x1) + constants_1.TAU) % constants_1.TAU < EPSILON) {
        var props_1 = style.color ? { stroke: style.color } : { className: style.strokeClassName };
        return react_1.default.createElement("circle", __assign({ key: key, r: (y0px + y1px) / 2 }, props_1, { fill: "none", strokeWidth: y1px - y0px }));
    }
    var X0 = x0 - constants_1.TAU / 4;
    var X1 = x1 - constants_1.TAU / 4;
    var path = [
        "M" + y0px * Math.cos(X0) + "," + y0px * Math.sin(X0),
        getSectorShapeFromCanvasArc(0, 0, y0px, X0, X1, false),
        "L" + y1px * Math.cos(X1) + "," + y1px * Math.sin(X1),
        getSectorShapeFromCanvasArc(0, 0, y1px, X1, X0, true),
        'Z',
    ].join(' ');
    var props = style.color ? { fill: style.color } : { className: style.fillClassName };
    return react_1.default.createElement("path", __assign({ key: key, d: path }, props));
}
function renderGeometries(geometries, partitionLayout, style) {
    var maxDepth = -1;
    if (partitionLayout === config_types_1.PartitionLayout.treemap) {
        maxDepth = geometries.reduce(function (acc, geom) { return Math.max(acc, geom.depth); }, 0);
    }
    return geometries
        .filter(function (geometry) {
        if (maxDepth !== -1) {
            return geometry.depth >= maxDepth;
        }
        return true;
    })
        .map(function (geometry, index) {
        if (partitionLayout === config_types_1.PartitionLayout.sunburst) {
            return renderSector(geometry, "" + index, style);
        }
        return renderRectangles(geometry, "" + index, style);
    });
}
var HighlighterComponent = (function (_super) {
    __extends(HighlighterComponent, _super);
    function HighlighterComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    HighlighterComponent.prototype.renderAsMask = function () {
        var _a = this.props, geometries = _a.geometries, diskCenter = _a.diskCenter, outerRadius = _a.outerRadius, partitionLayout = _a.partitionLayout, chartId = _a.chartId, _b = _a.canvasDimension, width = _b.width, height = _b.height;
        var maskId = "echHighlighterMask__" + chartId;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("defs", null,
                react_1.default.createElement("mask", { id: maskId },
                    react_1.default.createElement("rect", { x: 0, y: 0, width: width, height: height, fill: "white" }),
                    react_1.default.createElement("g", { transform: "translate(" + diskCenter.x + ", " + diskCenter.y + ")" }, renderGeometries(geometries, partitionLayout, { color: 'black' })))),
            partitionLayout === config_types_1.PartitionLayout.sunburst && (react_1.default.createElement("circle", { cx: diskCenter.x, cy: diskCenter.y, r: outerRadius, mask: "url(#" + maskId + ")", className: "echHighlighter__mask" })),
            partitionLayout === config_types_1.PartitionLayout.treemap && (react_1.default.createElement("rect", { x: 0, y: 0, width: width, height: height, mask: "url(#" + maskId + ")", className: "echHighlighter__mask" }))));
    };
    HighlighterComponent.prototype.renderAsOverlay = function () {
        var _a = this.props, geometries = _a.geometries, diskCenter = _a.diskCenter, partitionLayout = _a.partitionLayout;
        return (react_1.default.createElement("g", { transform: "translate(" + diskCenter.x + ", " + diskCenter.y + ")" }, renderGeometries(geometries, partitionLayout, {
            fillClassName: 'echHighlighterOverlay__fill',
            strokeClassName: 'echHighlighterOverlay__stroke',
        })));
    };
    HighlighterComponent.prototype.render = function () {
        var _a = this.props, geometries = _a.geometries, renderAsOverlay = _a.renderAsOverlay;
        if (geometries.length === 0) {
            return null;
        }
        return (react_1.default.createElement("svg", { className: "echHighlighter", width: "100%", height: "100%" }, renderAsOverlay ? this.renderAsOverlay() : this.renderAsMask()));
    };
    HighlighterComponent.displayName = 'Highlighter';
    return HighlighterComponent;
}(react_1.default.Component));
exports.HighlighterComponent = HighlighterComponent;
exports.DEFAULT_PROPS = {
    chartId: 'empty',
    initialized: false,
    canvasDimension: {
        width: 0,
        height: 0,
        left: 0,
        top: 0,
    },
    geometries: [],
    diskCenter: {
        x: 0,
        y: 0,
    },
    outerRadius: 10,
    renderAsOverlay: false,
    partitionLayout: config_types_1.PartitionLayout.sunburst,
};
//# sourceMappingURL=highlighter.js.map