/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.ClusterContainerStats;
import org.infinispan.stats.impl.AbstractClusterStats;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ClusterContainerStats", description="General container statistics aggregated across the cluster.")
public class ClusterContainerStatsImpl
extends AbstractClusterStats
implements ClusterContainerStats {
    private static final Log log = LogFactory.getLog(ClusterContainerStatsImpl.class);
    private static final String MEMORY_AVAILABLE = "memoryAvailable";
    private static final String MEMORY_MAX = "memoryMax";
    private static final String MEMORY_TOTAL = "memoryTotal";
    private static final String MEMORY_USED = "memoryUsed";
    private static final String[] LONG_ATTRIBUTES = new String[]{"memoryAvailable", "memoryMax", "memoryTotal", "memoryUsed"};
    private EmbeddedCacheManager cacheManager;

    public ClusterContainerStatsImpl() {
        super(log);
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager, GlobalConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.statisticsEnabled = configuration.globalJmxStatistics().enabled();
    }

    @Override
    void updateStats() throws Exception {
        List<Map<String, Number>> memoryMap = this.getClusterStatMaps();
        for (String att : LONG_ATTRIBUTES) {
            this.putLongAttributes(memoryMap, att);
        }
    }

    private List<Map<String, Number>> getClusterStatMaps() throws Exception {
        ArrayList<Map<String, Number>> successfulResponseMaps = new ArrayList<Map<String, Number>>();
        CompletableFutures.await(this.cacheManager.executor().submit(() -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            long available = Runtime.getRuntime().freeMemory();
            long total = Runtime.getRuntime().totalMemory();
            map.put(MEMORY_AVAILABLE, available);
            map.put(MEMORY_MAX, Runtime.getRuntime().maxMemory());
            map.put(MEMORY_TOTAL, total);
            map.put(MEMORY_USED, total - available);
            successfulResponseMaps.add(map);
        }));
        return successfulResponseMaps;
    }

    @Override
    @ManagedAttribute(description="The maximum amount of free memory in bytes across the cluster JVMs", displayName="Cluster wide available memory.", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public long getMemoryAvailable() {
        return this.getStatAsLong(MEMORY_AVAILABLE);
    }

    @Override
    @ManagedAttribute(description="The maximum amount of memory that JVMs across the cluster will attempt to utilise in bytes", displayName="Cluster wide max memory of JVMs", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public long getMemoryMax() {
        return this.getStatAsLong(MEMORY_MAX);
    }

    @Override
    @ManagedAttribute(description="The total amount of memory in the JVMs across the cluster in bytes", displayName="Cluster wide total memory", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public long getMemoryTotal() {
        return this.getStatAsLong(MEMORY_TOTAL);
    }

    @Override
    @ManagedAttribute(description="The amount of memory used by JVMs across the cluster in bytes", displayName="Cluster wide memory utilisation", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public long getMemoryUsed() {
        return this.getStatAsLong(MEMORY_USED);
    }
}

