/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

public class RetryOnFailureXSiteCommand {
    public static final RetryPolicy NO_RETRY = new MaxRetriesPolicy(0);
    private static final Log log = LogFactory.getLog(RetryOnFailureXSiteCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean debug = log.isDebugEnabled();
    private final Collection<XSiteBackup> backups;
    private final XSiteReplicateCommand command;
    private final RetryPolicy retryPolicy;

    private RetryOnFailureXSiteCommand(Collection<XSiteBackup> backups, XSiteReplicateCommand command, RetryPolicy retryPolicy) {
        this.backups = backups;
        this.command = command;
        this.retryPolicy = retryPolicy;
    }

    public void execute(RpcManager rpcManager, long waitTimeBetweenRetries, TimeUnit unit) throws Throwable {
        if (this.backups.isEmpty()) {
            if (debug) {
                log.debugf("Executing '%s' but backup list is empty.", this);
            }
            return;
        }
        RetryOnFailureXSiteCommand.assertNotNull(rpcManager, "RpcManager");
        RetryOnFailureXSiteCommand.assertNotNull((Object)unit, "TimeUnit");
        RetryOnFailureXSiteCommand.assertGreaterThanZero(waitTimeBetweenRetries, "WaitTimeBetweenRetries");
        while (true) {
            if (trace) {
                log.tracef("Sending %s to %s", this.command, this.backups);
            }
            BackupResponse response = rpcManager.invokeXSite(this.backups, this.command);
            response.waitForBackupToFinish();
            Throwable throwable = RetryOnFailureXSiteCommand.extractThrowable(response);
            if (throwable == null) {
                if (trace) {
                    log.trace("Successfull Response received.");
                }
                return;
            }
            if (!this.retryPolicy.retry(throwable, rpcManager)) {
                if (trace) {
                    log.tracef("Exception Response received. Exception is %s", throwable);
                }
                throw throwable;
            }
            unit.sleep(waitTimeBetweenRetries);
        }
    }

    public static RetryOnFailureXSiteCommand newInstance(XSiteBackup backup, XSiteReplicateCommand command, RetryPolicy retryPolicy) {
        RetryOnFailureXSiteCommand.assertNotNull(backup, "XSiteBackup");
        RetryOnFailureXSiteCommand.assertNotNull(command, "XSiteReplicateCommand");
        RetryOnFailureXSiteCommand.assertNotNull(retryPolicy, "RetryPolicy");
        return new RetryOnFailureXSiteCommand(Collections.singletonList(backup), command, retryPolicy);
    }

    public String toString() {
        return "RetryOnLinkFailureXSiteCommand{backups=" + this.backups + ", command=" + this.command + '}';
    }

    private static void assertNotNull(Object value, String field) {
        if (value == null) {
            throw new NullPointerException(field + " must be not null.");
        }
    }

    private static void assertGreaterThanZero(long value, String field) {
        if (value <= 0L) {
            throw new IllegalArgumentException(field + " must be greater that zero but instead it is " + value);
        }
    }

    private static Throwable extractThrowable(BackupResponse response) {
        Map<String, Throwable> errorMap = response.getFailedBackups();
        return errorMap.isEmpty() ? null : errorMap.values().iterator().next();
    }

    public static class MaxRetriesPolicy
    implements RetryPolicy {
        private int maxRetries;

        public MaxRetriesPolicy(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public boolean retry(Throwable throwable, RpcManager transport) {
            return this.maxRetries-- > 0;
        }
    }

    public static interface RetryPolicy {
        public boolean retry(Throwable var1, RpcManager var2);
    }
}

