/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAML11AssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.SAML11RequestParser;
import org.keycloak.saml.processing.core.parsers.saml.SAML11ResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAuthnStatementParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLEncryptedAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEntitiesDescriptorParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLArtifactResolveParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLArtifactResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLAttributeQueryParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLAuthNRequestParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLResponseParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLSloRequestParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLSloResponseParser;

public class SAMLParser
extends AbstractParser {
    private static final SAML11ResponseParser SAML_11_RESPONSE_PARSER = new SAML11ResponseParser();
    private static final SAML11RequestParser SAML_11_REQUEST_PARSER = new SAML11RequestParser();
    private static final QName SAML_11_ASSERTION = new QName("urn:oasis:names:tc:SAML:1.0:assertion", JBossSAMLConstants.ASSERTION.get());
    private static final QName SAML_11_ENCRYPTED_ASSERTION = new QName("urn:oasis:names:tc:SAML:1.0:assertion", JBossSAMLConstants.ENCRYPTED_ASSERTION.get());
    private static final QName SAML_11_RESPONSE = new QName("urn:oasis:names:tc:SAML:1.0:assertion", JBossSAMLConstants.RESPONSE__PROTOCOL.get());
    private static final QName SAML_11_REQUEST = new QName("urn:oasis:names:tc:SAML:1.0:assertion", JBossSAMLConstants.REQUEST.get());
    private static final Map<QName, ParserFactory> PARSERS = new HashMap<QName, ParserFactory>();
    private static final SAMLParser INSTANCE;

    public static SAMLParser getInstance() {
        return INSTANCE;
    }

    protected SAMLParser() {
    }

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                QName name = startElement.getName();
                ParserFactory pf = PARSERS.get(name);
                if (pf == null) {
                    throw logger.parserException(new RuntimeException("PL00064: Parser: Unknown Start Element: " + name + "::location=" + startElement.getLocation()));
                }
                return pf.create().parse(xmlEventReader);
            }
            StaxParserUtil.getNextEvent(xmlEventReader);
        }
        throw new RuntimeException("PL00067: Parsing has failed:SAML Parsing has failed");
    }

    static {
        PARSERS.put(SAML_11_ASSERTION, new ParserFactory(){

            @Override
            public StaxParser create() {
                return new SAML11AssertionParser();
            }
        });
        PARSERS.put(SAML_11_ENCRYPTED_ASSERTION, new ParserFactory(){

            @Override
            public StaxParser create() {
                return new SAML11AssertionParser();
            }
        });
        PARSERS.put(SAML_11_RESPONSE, new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAML_11_RESPONSE_PARSER;
            }
        });
        PARSERS.put(SAML_11_REQUEST, new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAML_11_REQUEST_PARSER;
            }
        });
        PARSERS.put(SAMLProtocolQNames.AUTHN_REQUEST.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLAuthNRequestParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.RESPONSE.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLResponseParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.LOGOUT_REQUEST.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLSloRequestParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.LOGOUT_RESPONSE.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLSloResponseParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.ARTIFACT_RESOLVE.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLArtifactResolveParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.ARTIFACT_RESPONSE.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLArtifactResponseParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.ASSERTION.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLAssertionParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.ENCRYPTED_ASSERTION.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLEncryptedAssertionParser.getInstance();
            }
        });
        PARSERS.put(SAMLAssertionQNames.AUTHN_STATEMENT.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLAuthnStatementParser.getInstance();
            }
        });
        PARSERS.put(SAMLMetadataQNames.ENTITY_DESCRIPTOR.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLEntityDescriptorParser.getInstance();
            }
        });
        PARSERS.put(SAMLMetadataQNames.ENTITIES_DESCRIPTOR.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLEntitiesDescriptorParser.getInstance();
            }
        });
        PARSERS.put(SAMLProtocolQNames.ATTRIBUTE_QUERY.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return SAMLAttributeQueryParser.getInstance();
            }
        });
        INSTANCE = new SAMLParser();
    }

    private static interface ParserFactory {
        public StaxParser create();
    }
}

