/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.url.DefaultHostnameProvider;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.HostnameProviderFactory;

public class DefaultHostnameProviderFactory
implements HostnameProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(DefaultHostnameProviderFactory.class);
    private URI frontendUri;
    private URI adminUri;
    private boolean forceBackendUrlToFrontendUrl;

    public HostnameProvider create(KeycloakSession session) {
        return new DefaultHostnameProvider(session, this.frontendUri, this.adminUri, this.forceBackendUrlToFrontendUrl);
    }

    public void init(Config.Scope config) {
        String frontendUrl = config.get("frontendUrl");
        String adminUrl = config.get("adminUrl");
        if (frontendUrl != null && !frontendUrl.isEmpty()) {
            try {
                this.frontendUri = new URI(frontendUrl);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid value for frontendUrl", e);
            }
        }
        if (adminUrl != null && !adminUrl.isEmpty()) {
            try {
                this.adminUri = new URI(adminUrl);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid value for adminUrl", e);
            }
        }
        this.forceBackendUrlToFrontendUrl = config.getBoolean("forceBackendUrlToFrontendUrl", Boolean.valueOf(false));
        LOGGER.infov("Frontend: {0}, Admin: {1}, Backend: {2}", (Object)(this.frontendUri != null ? this.frontendUri.toString() : "<request>"), (Object)(this.adminUri != null ? this.adminUri.toString() : "<frontend>"), (Object)(this.forceBackendUrlToFrontendUrl ? "<frontend>" : "<request>"));
    }

    public String getId() {
        return "default";
    }
}

