/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.timer.basic;

import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;
import org.keycloak.timer.basic.BasicTimerProviderFactory;
import org.keycloak.timer.basic.TimerTaskContextImpl;

public class BasicTimerProvider
implements TimerProvider {
    private static final Logger logger = Logger.getLogger(BasicTimerProvider.class);
    private final KeycloakSession session;
    private final Timer timer;
    private final BasicTimerProviderFactory factory;

    public BasicTimerProvider(KeycloakSession session, Timer timer, BasicTimerProviderFactory factory) {
        this.session = session;
        this.timer = timer;
        this.factory = factory;
    }

    public void schedule(final Runnable runnable, long intervalMillis, String taskName) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        TimerTaskContextImpl taskContext = new TimerTaskContextImpl(runnable, task, intervalMillis);
        TimerTaskContextImpl existingTask = this.factory.putTask(taskName, taskContext);
        if (existingTask != null) {
            logger.debugf("Existing timer task '%s' found. Cancelling it", (Object)taskName);
            existingTask.timerTask.cancel();
        }
        logger.debugf("Starting task '%s' with interval '%d'", (Object)taskName, (Object)intervalMillis);
        this.timer.schedule(task, intervalMillis, intervalMillis);
    }

    public void scheduleTask(ScheduledTask scheduledTask, long intervalMillis, String taskName) {
        ScheduledTaskRunner scheduledTaskRunner = new ScheduledTaskRunner(this.session.getKeycloakSessionFactory(), scheduledTask);
        this.schedule(scheduledTaskRunner, intervalMillis, taskName);
    }

    public TimerProvider.TimerTaskContext cancelTask(String taskName) {
        TimerTaskContextImpl existingTask = this.factory.removeTask(taskName);
        if (existingTask != null) {
            logger.debugf("Cancelling task '%s'", (Object)taskName);
            existingTask.timerTask.cancel();
        }
        return existingTask;
    }

    public void close() {
    }
}

