/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.provider.Provider;
import org.keycloak.services.managers.UserStorageSyncManager;
import org.keycloak.storage.OnCreateComponent;
import org.keycloak.storage.OnUpdateComponent;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserBulkUpdateProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class UserStorageManager
implements UserProvider,
OnUserCache,
OnCreateComponent,
OnUpdateComponent {
    private static final Logger logger = Logger.getLogger(UserStorageManager.class);
    protected KeycloakSession session;

    public UserStorageManager(KeycloakSession session) {
        this.session = session;
    }

    public static boolean isStorageProviderEnabled(RealmModel realm, String providerId) {
        UserStorageProviderModel model = UserStorageManager.getStorageProviderModel(realm, providerId);
        return model.isEnabled();
    }

    protected UserProvider localStorage() {
        return this.session.userLocalStorage();
    }

    public static List<UserStorageProviderModel> getStorageProviders(RealmModel realm) {
        return realm.getUserStorageProviders();
    }

    public static UserStorageProvider getStorageProviderInstance(KeycloakSession session, UserStorageProviderModel model, UserStorageProviderFactory factory) {
        UserStorageProvider instance = (UserStorageProvider)session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(session, (ComponentModel)model);
        if (instance == null) {
            throw new IllegalStateException("UserStorageProvideFactory (of type " + factory.getClass().getName() + ") produced a null instance");
        }
        session.enlistForClose((Provider)instance);
        session.setAttribute(model.getId(), (Object)instance);
        return instance;
    }

    public static <T> List<T> getStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        LinkedList<T> list = new LinkedList<T>();
        for (UserStorageProviderModel model : UserStorageManager.getStorageProviders(realm)) {
            UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
            if (factory == null) {
                logger.warnv("Configured UserStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                continue;
            }
            if (!Types.supports(type, (Object)factory, UserStorageProviderFactory.class)) continue;
            list.add(type.cast(UserStorageManager.getStorageProviderInstance(session, model, factory)));
        }
        return list;
    }

    public static <T> List<T> getEnabledStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        LinkedList<T> list = new LinkedList<T>();
        for (UserStorageProviderModel model : UserStorageManager.getStorageProviders(realm)) {
            if (!model.isEnabled()) continue;
            UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
            if (factory == null) {
                logger.warnv("Configured UserStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                continue;
            }
            if (!Types.supports(type, (Object)factory, UserStorageProviderFactory.class)) continue;
            list.add(type.cast(UserStorageManager.getStorageProviderInstance(session, model, factory)));
        }
        return list;
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.localStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
    }

    public UserModel addUser(RealmModel realm, String username) {
        for (UserRegistrationProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserRegistrationProvider.class)) {
            UserModel user = provider.addUser(realm, username);
            if (user == null) continue;
            return user;
        }
        return this.localStorage().addUser(realm, username.toLowerCase());
    }

    public static UserStorageProviderModel getStorageProviderModel(RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        return new UserStorageProviderModel(model);
    }

    public static UserStorageProvider getStorageProvider(KeycloakSession session, RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        UserStorageProviderModel storageModel = new UserStorageProviderModel(model);
        UserStorageProviderFactory factory = (UserStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find UserStorageProviderFactory for: " + model.getProviderId());
        }
        return UserStorageManager.getStorageProviderInstance(session, storageModel, factory);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        StorageId storageId;
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, user);
        }
        if ((storageId = new StorageId(user.getId())).getProviderId() == null) {
            boolean linkRemoved = true;
            if (user.getFederationLink() != null) {
                if (UserStorageManager.isStorageProviderEnabled(realm, user.getFederationLink())) {
                    UserStorageProvider provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink());
                    if (provider != null && provider instanceof UserRegistrationProvider) {
                        ((UserRegistrationProvider)provider).removeUser(realm, user);
                    }
                } else {
                    linkRemoved = false;
                }
            }
            return this.localStorage().removeUser(realm, user) && linkRemoved;
        }
        UserRegistrationProvider registry = (UserRegistrationProvider)UserStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        if (registry == null) {
            throw new ModelException("Could not resolve StorageProvider: " + storageId.getProviderId());
        }
        return registry.removeUser(realm, user);
    }

    public UserFederatedStorageProvider getFederatedStorage() {
        return this.session.userFederatedStorage();
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().addFederatedIdentity(realm, user, socialLink);
        } else {
            this.getFederatedStorage().addFederatedIdentity(realm, user.getId(), socialLink);
        }
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (StorageId.isLocalStorage((UserModel)federatedUser)) {
            this.localStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        } else {
            this.getFederatedStorage().updateFederatedIdentity(realm, federatedUser.getId(), federatedIdentityModel);
        }
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().removeFederatedIdentity(realm, user, socialProvider);
        }
        return this.getFederatedStorage().removeFederatedIdentity(realm, user.getId(), socialProvider);
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().addConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().addConsent(realm, userId, consent);
        }
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentByClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().getConsentByClient(realm, userId, clientInternalId);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsents(realm, userId);
        }
        return this.getFederatedStorage().getConsents(realm, userId);
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().updateConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().updateConsent(realm, userId, consent);
        }
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().revokeConsentForClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().revokeConsentForClient(realm, userId, clientInternalId);
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().setNotBeforeForUser(realm, user, notBefore);
        } else {
            this.getFederatedStorage().setNotBeforeForUser(realm, user.getId(), notBefore);
        }
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().getNotBeforeOfUser(realm, user);
        }
        return this.getFederatedStorage().getNotBeforeOfUser(realm, user.getId());
    }

    protected UserModel importValidation(RealmModel realm, UserModel user) {
        if (user == null || user.getFederationLink() == null) {
            return user;
        }
        UserStorageProvider provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink());
        if (provider != null && provider instanceof ImportedUserValidation) {
            if (!UserStorageManager.isStorageProviderEnabled(realm, user.getFederationLink())) {
                return new ReadOnlyUserModelDelegate(user){

                    public boolean isEnabled() {
                        return false;
                    }
                };
            }
            UserModel validated = ((ImportedUserValidation)provider).validate(realm, user);
            if (validated == null) {
                this.deleteInvalidUser(realm, user);
                return null;
            }
            return validated;
        }
        if (provider == null) {
            logger.debugf("Removed user with federation link of unknown storage provider '%s'", (Object)user.getUsername());
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return user;
    }

    protected void deleteInvalidUser(final RealmModel realm, UserModel user) {
        final String userId = user.getId();
        final String userName = user.getUsername();
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel realmModel = session.realms().getRealm(realm.getId());
                if (realmModel == null) {
                    return;
                }
                UserModel deletedUser = session.userLocalStorage().getUserById(userId, realmModel);
                if (deletedUser != null) {
                    new UserManager(session).removeUser(realmModel, deletedUser, session.userLocalStorage());
                    logger.debugf("Removed invalid user '%s'", (Object)userName);
                }
            }
        });
    }

    protected List<UserModel> importValidation(RealmModel realm, List<UserModel> users) {
        LinkedList<UserModel> tmp = new LinkedList<UserModel>();
        for (UserModel user : users) {
            UserModel model = this.importValidation(realm, user);
            if (model == null) continue;
            tmp.add(model);
        }
        return tmp;
    }

    public UserModel getUserById(String id, RealmModel realm) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            UserModel user = this.localStorage().getUserById(id, realm);
            return this.importValidation(realm, user);
        }
        UserLookupProvider provider = (UserLookupProvider)UserStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        if (provider == null) {
            return null;
        }
        if (!UserStorageManager.isStorageProviderEnabled(realm, storageId.getProviderId())) {
            return null;
        }
        return provider.getUserById(id, realm);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, -1, -1);
    }

    public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role) {
        return this.getRoleMembers(realm, role, -1, -1);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        UserModel user = this.localStorage().getUserByUsername(username, realm);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        for (UserLookupProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserLookupProvider.class)) {
            user = provider.getUserByUsername(username, realm);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        UserModel user = this.localStorage().getUserByEmail(email, realm);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        for (UserLookupProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserLookupProvider.class)) {
            user = provider.getUserByEmail(email, realm);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        UserModel user = this.localStorage().getUserByFederatedIdentity(socialLink, realm);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        if (this.getFederatedStorage() == null) {
            return null;
        }
        String id = this.getFederatedStorage().getUserByFederatedIdentity(socialLink, realm);
        if (id != null) {
            return this.getUserById(id, realm);
        }
        return null;
    }

    public UserModel getServiceAccount(ClientModel client) {
        return this.localStorage().getServiceAccount(client);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, 0, 0x7FFFFFFE, includeServiceAccounts);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        int size = this.localStorage().getUsersCount(realm, includeServiceAccount);
        for (UserQueryProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserQueryProvider.class)) {
            size += provider.getUsersCount(realm);
        }
        return size;
    }

    public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    protected List<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, int firstResult, int maxResults) {
        List<UserQueryProvider> storageProviders;
        if (maxResults == 0) {
            return Collections.EMPTY_LIST;
        }
        if (firstResult < 0) {
            firstResult = 0;
        }
        if (maxResults < 0) {
            maxResults = 0x7FFFFFFE;
        }
        if ((storageProviders = UserStorageManager.getEnabledStorageProviders(this.session, realm, UserQueryProvider.class)).isEmpty()) {
            return pagedQuery.query(this.localStorage(), firstResult, maxResults);
        }
        LinkedList<Object> providers = new LinkedList<Object>();
        LinkedList<UserModel> results = new LinkedList<UserModel>();
        providers.add(this.localStorage());
        providers.addAll(storageProviders);
        if (this.getFederatedStorage() != null) {
            providers.add(this.getFederatedStorage());
        }
        int leftToRead = maxResults;
        int leftToFirstResult = firstResult;
        Iterator it = providers.iterator();
        while (it.hasNext() && leftToRead != 0) {
            Object provider = it.next();
            boolean exhausted = false;
            int index = 0;
            if (leftToFirstResult > 0) {
                do {
                    int toRead = Math.min(50, leftToFirstResult);
                    List<UserModel> tmp = pagedQuery.query(provider, index, toRead);
                    leftToFirstResult -= tmp.size();
                    index += tmp.size();
                    if (tmp.size() >= toRead) continue;
                    exhausted = true;
                    break;
                } while (leftToFirstResult > 0);
            }
            if (exhausted) continue;
            List<UserModel> tmp = pagedQuery.query(provider, index, leftToRead);
            results.addAll(tmp);
            if (leftToRead <= 0) continue;
            leftToRead -= tmp.size();
        }
        return results;
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserProvider) {
                return ((UserProvider)provider).getUsers(realm, first, max, includeServiceAccounts);
            }
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getUsers(realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUser(search, realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        List<UserModel> results = this.searchForUser(attributes, realm, 0, 0x7FFFFFFE);
        return this.importValidation(realm, results);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUser(attributes, realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUserByUserAttribute(attrName, attrValue, realm);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                List ids = ((UserFederatedStorageProvider)provider).getUsersByUserAttribute(realm, attrName, attrValue);
                LinkedList<UserModel> rs = new LinkedList<UserModel>();
                for (String id : ids) {
                    UserModel user = this.getUserById(id, realm);
                    if (user == null) continue;
                    rs.add(user);
                }
                return rs;
            }
            return Collections.EMPTY_LIST;
        }, realm, 0, 0x7FFFFFFE);
        return this.importValidation(realm, results);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        if (StorageId.isLocalStorage((UserModel)user)) {
            set.addAll(this.localStorage().getFederatedIdentities(user, realm));
        }
        if (this.getFederatedStorage() != null) {
            set.addAll(this.getFederatedStorage().getFederatedIdentities(user.getId(), realm));
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        FederatedIdentityModel model;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        if (StorageId.isLocalStorage((UserModel)user) && (model = this.localStorage().getFederatedIdentity(user, socialProvider, realm)) != null) {
            return model;
        }
        if (this.getFederatedStorage() != null) {
            return this.getFederatedStorage().getFederatedIdentity(user.getId(), socialProvider, realm);
        }
        return null;
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        List<UserBulkUpdateProvider> storageProviders = UserStorageManager.getEnabledStorageProviders(this.session, realm, UserBulkUpdateProvider.class);
        LinkedList<Object> providers = new LinkedList<Object>();
        providers.add(this.localStorage());
        providers.addAll(storageProviders);
        for (UserBulkUpdateProvider userBulkUpdateProvider : providers) {
            userBulkUpdateProvider.grantToAllUsers(realm, role);
        }
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getGroupMembers(realm, group, first, max);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                List ids = ((UserFederatedStorageProvider)provider).getMembership(realm, group, first, max);
                LinkedList<UserModel> rs = new LinkedList<UserModel>();
                for (String id : ids) {
                    UserModel user = this.getUserById(id, realm);
                    if (user == null) continue;
                    rs.add(user);
                }
                return rs;
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getRoleMembers(realm, role, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public void preRemove(RealmModel realm) {
        this.localStorage().preRemove(realm);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm);
            for (UserStorageProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserStorageProvider.class)) {
                provider.preRemove(realm);
            }
        }
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.localStorage().preRemove(realm, group);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, group);
            for (UserStorageProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserStorageProvider.class)) {
                provider.preRemove(realm, group);
            }
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.localStorage().preRemove(realm, role);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, role);
            for (UserStorageProvider provider : UserStorageManager.getEnabledStorageProviders(this.session, realm, UserStorageProvider.class)) {
                provider.preRemove(realm, role);
            }
        }
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.localStorage().preRemove(realm, client);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, client);
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.localStorage().preRemove(protocolMapper);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(protocolMapper);
        }
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.localStorage().preRemove(clientScope);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(clientScope);
        }
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.localStorage().preRemove(realm, component);
            if (this.getFederatedStorage() != null) {
                this.getFederatedStorage().preRemove(realm, component);
            }
            return;
        }
        if (!component.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.localStorage().preRemove(realm, component);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, component);
        }
        new UserStorageSyncManager().notifyToRefreshPeriodicSync(this.session, realm, new UserStorageProviderModel(component), true);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().removeImportedUsers(realm, storageProviderId);
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().unlinkUsers(realm, storageProviderId);
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            if (this.session.userLocalStorage() instanceof OnUserCache) {
                ((OnUserCache)this.session.userLocalStorage()).onCache(realm, user, delegate);
            }
        } else {
            UserStorageProvider provider = UserStorageManager.getStorageProvider(this.session, realm, StorageId.resolveProviderId((UserModel)user));
            if (provider != null && provider instanceof OnUserCache) {
                ((OnUserCache)provider).onCache(realm, user, delegate);
            }
        }
    }

    public void close() {
    }

    public void onCreate(KeycloakSession session, RealmModel realm, ComponentModel model) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)model);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        new UserStorageSyncManager().notifyToRefreshPeriodicSync(session, realm, new UserStorageProviderModel(model), false);
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)newModel);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        UserStorageProviderModel old = new UserStorageProviderModel(oldModel);
        UserStorageProviderModel newP = new UserStorageProviderModel(newModel);
        if (old.getChangedSyncPeriod() != newP.getChangedSyncPeriod() || old.getFullSyncPeriod() != newP.getFullSyncPeriod() || old.isImportEnabled() != newP.isImportEnabled()) {
            new UserStorageSyncManager().notifyToRefreshPeriodicSync(session, realm, new UserStorageProviderModel(newModel), false);
        }
    }

    @FunctionalInterface
    static interface PaginatedQuery {
        public List<UserModel> query(Object var1, int var2, int var3);
    }
}

