/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public class DefaultClientCertificateLookup
implements X509ClientCertificateLookup {
    private static final Logger logger = Logger.getLogger(DefaultClientCertificateLookup.class);
    public static final String JAVAX_SERVLET_REQUEST_X509_CERTIFICATE = "javax.servlet.request.X509Certificate";

    public void close() {
    }

    @Override
    public X509Certificate[] getCertificateChain(HttpRequest httpRequest) {
        X509Certificate[] certs = (X509Certificate[])httpRequest.getAttribute(JAVAX_SERVLET_REQUEST_X509_CERTIFICATE);
        if (certs != null) {
            for (X509Certificate cert : certs) {
                logger.tracef("Certificate's SubjectDN => \"%s\"", (Object)cert.getSubjectDN().getName());
            }
        }
        return certs;
    }
}

