/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpirationTracker;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class NonClusteredBeanExpirationScheduler<I, T>
implements Scheduler<I> {
    private final Batcher<TransactionBatch> batcher;
    private final BeanRemover<I, T> remover;
    private final ExpirationConfiguration<T> expiration;
    private final ExpirationTracker<I> expirationTracker;
    private volatile Future<?> expireTask;

    NonClusteredBeanExpirationScheduler(Batcher<TransactionBatch> batcher, BeanRemover<I, T> remover, ExpirationConfiguration<T> expiration) {
        this.batcher = batcher;
        this.remover = remover;
        this.expiration = expiration;
        this.expirationTracker = expiration.getTimeout().isNegative() ? null : new ExpirationTracker(expiration.getTimeout());
    }

    @Override
    public void prepareRescheduling(I id) {
        if (this.expirationTracker != null) {
            this.expirationTracker.invalidateExpiration(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(I id) {
        if (this.expirationTracker != null) {
            this.expirationTracker.trackExpiration(id);
            if (this.expireTask == null) {
                NonClusteredBeanExpirationScheduler nonClusteredBeanExpirationScheduler = this;
                synchronized (nonClusteredBeanExpirationScheduler) {
                    if (this.expireTask == null) {
                        ExpirationTask task = new ExpirationTask();
                        Duration timeout = this.expiration.getTimeout();
                        InfinispanEjbLogger.ROOT_LOGGER.tracef("Scheduling stateful session bean %s to expire in %s", id, timeout);
                        this.expireTask = this.expiration.getExecutor().schedule(task, timeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    @Override
    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        this.schedule(id);
    }

    @Override
    public void cancel(I id) {
        this.expirationTracker.forget(id);
    }

    @Override
    public void cancel(Locality locality) {
        for (I id : this.expirationTracker.getTrackedIds()) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal(id)) continue;
            this.cancel(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Future<?> task;
        NonClusteredBeanExpirationScheduler nonClusteredBeanExpirationScheduler = this;
        synchronized (nonClusteredBeanExpirationScheduler) {
            if (this.expireTask == null) {
                return;
            }
            task = this.expireTask;
            this.expireTask = null;
        }
        task.cancel(false);
        if (!task.isDone()) {
            try {
                task.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private class ExpirationTask
    implements Runnable {
        private ExpirationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object sessionId = null;
            boolean removed = true;
            long currentTime = System.currentTimeMillis();
            while (removed) {
                Object i = NonClusteredBeanExpirationScheduler.this.expirationTracker.getExpiredId(currentTime);
                sessionId = i;
                if (i == null) break;
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", sessionId);
                removed = false;
                Batch batch = NonClusteredBeanExpirationScheduler.this.batcher.createBatch();
                Throwable throwable = null;
                try {
                    try {
                        removed = NonClusteredBeanExpirationScheduler.this.remover.remove(sessionId, NonClusteredBeanExpirationScheduler.this.expiration.getRemoveListener());
                    }
                    catch (Throwable e) {
                        InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e, sessionId);
                        batch.discard();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (batch == null) continue;
                    if (throwable != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    batch.close();
                }
            }
            if (!removed) {
                NonClusteredBeanExpirationScheduler.this.expirationTracker.retryExpiration(sessionId);
            }
            long nextExpirationInMillis = NonClusteredBeanExpirationScheduler.this.expirationTracker.getNextExpirationInMillis();
            NonClusteredBeanExpirationScheduler nonClusteredBeanExpirationScheduler = NonClusteredBeanExpirationScheduler.this;
            synchronized (nonClusteredBeanExpirationScheduler) {
                if (nextExpirationInMillis != -1L && NonClusteredBeanExpirationScheduler.this.expireTask != null) {
                    NonClusteredBeanExpirationScheduler.this.expireTask = NonClusteredBeanExpirationScheduler.this.expiration.getExecutor().schedule(this, nextExpirationInMillis - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                } else {
                    NonClusteredBeanExpirationScheduler.this.expireTask = null;
                }
            }
        }
    }
}

