/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultClientScopes;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo4_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("4.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo4_0_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealms().stream().forEach(r -> this.migrateRealm(session, (RealmModel)r, false));
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm, true);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm, boolean json) {
        for (ClientScopeModel clientScope : realm.getClientScopes()) {
            if (!clientScope.getName().contains(" ")) continue;
            LOG.debugf("Replacing spaces with underscores in the name of client scope '%s' of realm '%s'", (Object)clientScope.getName(), (Object)realm.getName());
            String replacedName = clientScope.getName().replaceAll(" ", "_");
            clientScope.setName(replacedName);
        }
        if (!json) {
            LOG.debugf("Adding defaultClientScopes for realm '%s'", (Object)realm.getName());
            DefaultClientScopes.createDefaultClientScopes(session, realm, false);
        }
        for (ComponentModel component : realm.getComponents(realm.getId(), "org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy")) {
            if (!"allowed-client-templates".equals(component.getProviderId())) continue;
            List configVal = (List)component.getConfig().remove((Object)"allowed-client-templates");
            if (configVal != null) {
                component.getConfig().put((Object)"allowed-client-scopes", (Object)configVal);
            }
            component.put("allow-default-scopes", true);
            realm.updateComponent(component);
        }
        RoleModel offlineAccessRole = realm.getRole("offline_access");
        ClientScopeModel offlineAccessScope = null;
        if (offlineAccessRole == null) {
            LOG.infof("Role 'offline_access' not available in realm '%s'. Skip migration of offline_access client scope.", (Object)realm.getName());
        } else {
            offlineAccessScope = KeycloakModelUtils.getClientScopeByName(realm, "offline_access");
            if (offlineAccessScope == null) {
                LOG.infof("Client scope 'offline_access' not available in realm '%s'. Skip migration of offline_access client scope.", (Object)realm.getName());
            } else {
                for (ClientModel client : realm.getClients()) {
                    if (!"openid-connect".equals(client.getProtocol()) || client.isBearerOnly() || !client.hasScope(offlineAccessRole) || client.getClientScopes(false, true).containsKey("offline_access")) continue;
                    LOG.debugf("Adding client scope 'offline_access' as optional scope to client '%s' in realm '%s'.", (Object)client.getClientId(), (Object)realm.getName());
                    client.addClientScope(offlineAccessScope, false);
                    if (client.isFullScopeAllowed()) continue;
                    LOG.debugf("Removing role scope mapping for role 'offline_access' from client '%s' in realm '%s'.", (Object)client.getClientId(), (Object)realm.getName());
                    client.deleteScopeMapping(offlineAccessRole);
                }
            }
        }
        for (ClientModel client : realm.getClients()) {
            if (!client.isConsentRequired() || !client.getClientScopes(true, true).isEmpty()) continue;
            LOG.debugf("Adding client '%s' of realm '%s' to display itself on consent screen", (Object)client.getClientId(), (Object)realm.getName());
            client.setDisplayOnConsentScreen(true);
            String consentText = client.getName() == null ? client.getClientId() : client.getName();
            client.setConsentScreenText(consentText);
        }
    }
}

