/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class OracleTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(OracleTableManager.class, Log.class);
    private static final int MAX_INDEX_IDENTIFIER_SIZE = 30;
    private static final String INDEX_PREFIX = "IDX";

    OracleTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema() == null ? metaData.getUserName() : tableName.getSchema();
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (LOG.isTraceEnabled()) {
                LOG.tracef(e, "SQLException occurs while checking the table %s", tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean indexExists(String indexName, Connection conn) throws PersistenceException {
        ResultSet rs;
        block7: {
            boolean bl;
            block6: {
                rs = null;
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    rs = meta.getIndexInfo(null, null, this.getTableName().toString(), false, false);
                    while (rs.next()) {
                        String index = rs.getString("INDEX_NAME");
                        if (!indexName.equalsIgnoreCase(index)) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        throw throwable;
                    }
                }
            }
            JdbcUtil.safeClose(rs);
            return bl;
        }
        JdbcUtil.safeClose(rs);
        return false;
    }

    @Override
    public String getIndexName(boolean withIdentifier, String indexExt) {
        if (indexExt.equals("timestamp_index")) {
            indexExt = INDEX_PREFIX;
        }
        int maxNameSize = 30 - indexExt.length() - 1;
        String tableName = this.getTableName().toString().replace(this.identifierQuoteString, "");
        String truncatedName = tableName.length() > maxNameSize ? tableName.substring(0, maxNameSize) : tableName;
        String indexName = indexExt + "_" + truncatedName;
        if (withIdentifier) {
            return this.identifierQuoteString + indexName + this.identifierQuoteString;
        }
        return indexName;
    }

    protected String getDropTimestampSql() {
        return String.format("DROP INDEX %s", this.getIndexName(true, "timestamp_index"));
    }

    @Override
    public String getInsertRowSql() {
        if (this.insertRowSql == null) {
            this.insertRowSql = this.metaData.isSegmentedDisabled() ? String.format("INSERT INTO %s (%s,%s,%s) VALUES (?,?,?)", this.getTableName(), this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName()) : String.format("INSERT INTO %s (%s,%s,%s,%s) VALUES (?,?,?,?)", this.getTableName(), this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName(), this.config.segmentColumnName());
        }
        return this.insertRowSql;
    }

    @Override
    public String getUpdateRowSql() {
        if (this.updateRowSql == null) {
            this.updateRowSql = String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = ?", this.getTableName(), this.config.timestampColumnName(), this.config.dataColumnName(), this.config.idColumnName());
        }
        return this.updateRowSql;
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = this.metaData.isSegmentedDisabled() ? String.format("MERGE INTO %1$s t USING (SELECT ? %2$s, ? %3$s, ? %4$s from dual) tmp ON (t.%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET t.%3$s = tmp.%3$s, t.%4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s)", this.getTableName(), this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName()) : String.format("MERGE INTO %1$s t USING (SELECT ? %2$s, ? %3$s, ? %4$s, ? %5$s from dual) tmp ON (t.%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET t.%3$s = tmp.%3$s, t.%4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s, %5$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s, tmp.%5$s)", this.getTableName(), this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName(), this.config.segmentColumnName());
        }
        return this.upsertRowSql;
    }

    @Override
    public void prepareUpsertStatement(PreparedStatement ps, String key, long timestamp, int segment, ByteBuffer byteBuffer) throws SQLException {
        ps.setString(1, key);
        ps.setLong(2, timestamp);
        ps.setBlob(3, new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        if (!this.metaData.isSegmentedDisabled()) {
            ps.setInt(4, segment);
        }
    }

    @Override
    public void prepareUpdateStatement(PreparedStatement ps, String key, long timestamp, int segment, ByteBuffer byteBuffer) throws SQLException {
        ps.setLong(1, timestamp);
        ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setString(3, key);
        if (!this.metaData.isSegmentedDisabled()) {
            ps.setInt(4, segment);
        }
    }
}

