/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration.embedder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenEmbedder;
import org.appformer.maven.integration.embedder.MavenEmbedderException;
import org.appformer.maven.integration.embedder.MavenRequest;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectLoader {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectLoader.class);
    private static final String DUMMY_POM = "    <project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n      <modelVersion>4.0.0</modelVersion>\n     \n      <groupId>myGroupId</groupId>\n      <artifactId>myArtifactId</artifactId>\n      <version>1.0-SNAPSHOT</version>\n    </project>";
    static MavenProject mavenProject;

    public static MavenProject parseMavenPom(File pomFile) {
        return MavenProjectLoader.parseMavenPom(pomFile, false);
    }

    public static MavenProject parseMavenPom(File pomFile, boolean offline) {
        boolean hasPom = pomFile.exists();
        MavenRequest mavenRequest = MavenProjectLoader.createMavenRequest(offline);
        if (hasPom) {
            mavenRequest.setPom(pomFile.getAbsolutePath());
        }
        MavenEmbedder mavenEmbedder = null;
        try {
            mavenEmbedder = new MavenEmbedder(mavenRequest);
            MavenProject mavenProject = hasPom ? mavenEmbedder.readProject(pomFile) : mavenEmbedder.readProject(new ByteArrayInputStream(DUMMY_POM.getBytes(StandardCharsets.UTF_8)));
            return mavenProject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (mavenEmbedder != null) {
                mavenEmbedder.dispose();
            }
        }
    }

    public static MavenProject parseMavenPom(InputStream pomStream) {
        return MavenProjectLoader.parseMavenPom(pomStream, false);
    }

    public static MavenProject parseMavenPom(InputStream pomStream, boolean offline) {
        MavenEmbedder mavenEmbedder = null;
        try {
            mavenEmbedder = MavenProjectLoader.newMavenEmbedder(offline);
            MavenProject mavenProject = mavenEmbedder.readProject(pomStream);
            return mavenProject;
        }
        catch (Exception e) {
            log.error("Unable to create MavenProject from InputStream", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (mavenEmbedder != null) {
                mavenEmbedder.dispose();
            }
        }
    }

    public static MavenEmbedder newMavenEmbedder(boolean offline) {
        MavenEmbedder mavenEmbedder;
        MavenRequest mavenRequest = MavenProjectLoader.createMavenRequest(offline);
        try {
            mavenEmbedder = new MavenEmbedder(mavenRequest);
        }
        catch (MavenEmbedderException e) {
            log.error("Unable to create new MavenEmbedder", (Throwable)e);
            throw new RuntimeException(e);
        }
        return mavenEmbedder;
    }

    public static MavenRequest createMavenRequest(boolean offline) {
        MavenRequest mavenRequest = new MavenRequest();
        mavenRequest.setLocalRepositoryPath(MavenSettings.getSettings().getLocalRepository());
        mavenRequest.setUserSettingsSource(MavenSettings.getUserSettingsSource());
        mavenRequest.setResolveDependencies(true);
        mavenRequest.setOffline(offline);
        return mavenRequest;
    }

    public static synchronized MavenProject loadMavenProject() {
        return MavenProjectLoader.loadMavenProject(false);
    }

    public static synchronized MavenProject loadMavenProject(boolean offline) {
        if (mavenProject == null) {
            File pomFile = new File("pom.xml");
            try {
                mavenProject = MavenProjectLoader.parseMavenPom(pomFile, offline);
            }
            catch (Exception e) {
                log.warn("Unable to parse pom.xml file of the running project: " + e.getMessage());
            }
        }
        return mavenProject;
    }
}

