/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.provider.util;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Provider;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.wildfly.security.provider.util.ProviderServiceLoaderSupplier;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.provider.util._private.ElytronMessages;

public class ProviderFactory {
    private static String[] elytronProviderClassNames = new String[]{"org.wildfly.security.password.WildFlyElytronPasswordProvider", "org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider", "org.wildfly.security.digest.WildFlyElytronDigestProvider", "org.wildfly.security.http.basic.WildFlyElytronHttpBasicProvider", "org.wildfly.security.http.bearer.WildFlyElytronHttpBearerProvider", "org.wildfly.security.http.bearer.WildFlyElytronHttpClientCertProvider", "org.wildfly.security.http.bearer.WildFlyElytronHttpDigestProvider", "org.wildfly.security.http.bearer.WildFlyElytronHttpFormProvider", "org.wildfly.security.http.bearer.WildFlyElytronHttpSpnegoProvider", "org.wildfly.security.key.WildFlyElytronKeyProvider", "org.wildfly.security.keystore.WildFlyElytronKeyStoreProvider", "org.wildfly.security.sasl.anonymous.WildFlyElytronSaslAnonymousProvider", "org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider", "org.wildfly.security.sasl.entity.WildFlyElytronSaslEntityProvider", "org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider", "org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider", "org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider", "org.wildfly.security.sasl.localuser.WildFlyElytronSaslLocalUserProvider", "org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider", "org.wildfly.security.sasl.otp.WildFlyElytronSaslOTPProvider", "org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider", "org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider"};

    static Class[] getWildflyElytronProviderClasses(ClassLoader classLoader) {
        ArrayList providers = new ArrayList();
        for (String elytronProviderClassName : elytronProviderClassNames) {
            try {
                providers.add(Class.forName(elytronProviderClassName, false, classLoader));
            }
            catch (ClassNotFoundException e) {
                ElytronMessages.log.debug("Provider " + elytronProviderClassName + " not found.");
            }
        }
        return providers.toArray(new Class[0]);
    }

    private static Provider[] getWildflyElytronProviders(ClassLoader classLoader) {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (String elytronProviderClassName : elytronProviderClassNames) {
            try {
                providers.add((Provider)Class.forName(elytronProviderClassName, false, classLoader).getMethod("getInstance", new Class[0]).invoke(null, new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                ElytronMessages.log.debug("Provider " + elytronProviderClassName + " not found.");
            }
        }
        return providers.toArray(new Provider[0]);
    }

    public static Supplier<Provider[]> getElytronProviderSupplier(ClassLoader classLoader) {
        return ProviderUtil.aggregate(() -> System.getSecurityManager() != null ? AccessController.doPrivileged(() -> ProviderFactory.getWildflyElytronProviders(classLoader)) : ProviderFactory.getWildflyElytronProviders(classLoader), System.getSecurityManager() != null ? (Supplier)AccessController.doPrivileged(() -> new ProviderServiceLoaderSupplier(classLoader, true)) : new ProviderServiceLoaderSupplier(classLoader, true));
    }

    public static Supplier<Provider[]> getDefaultProviderSupplier(ClassLoader classLoader) {
        return ProviderUtil.aggregate(ProviderFactory.getElytronProviderSupplier(classLoader), ProviderUtil.INSTALLED_PROVIDERS);
    }
}

