/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.RandomUtil;

public final class UDPBroadcastEndpointFactory
implements BroadcastEndpointFactory {
    private transient String localBindAddress = UDPBroadcastEndpointFactory.getProperty(UDPBroadcastEndpointFactory.class.getName() + ".localBindAddress", null);
    private transient int localBindPort = -1;
    private String groupAddress = null;
    private int groupPort = -1;

    @Override
    public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
        return new UDPBroadcastEndpoint().setGroupAddress(this.groupAddress != null ? InetAddress.getByName(this.groupAddress) : null).setGroupPort(this.groupPort).setLocalBindAddress(this.localBindAddress != null ? InetAddress.getByName(this.localBindAddress) : null).setLocalBindPort(this.localBindPort);
    }

    public String getGroupAddress() {
        return this.groupAddress;
    }

    public UDPBroadcastEndpointFactory setGroupAddress(String groupAddress) {
        this.groupAddress = groupAddress;
        return this;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public UDPBroadcastEndpointFactory setGroupPort(int groupPort) {
        this.groupPort = groupPort;
        return this;
    }

    public int getLocalBindPort() {
        return this.localBindPort;
    }

    public UDPBroadcastEndpointFactory setLocalBindPort(int localBindPort) {
        this.localBindPort = localBindPort;
        return this;
    }

    public String getLocalBindAddress() {
        return this.localBindAddress;
    }

    public UDPBroadcastEndpointFactory setLocalBindAddress(String localBindAddress) {
        this.localBindAddress = localBindAddress;
        return this;
    }

    private static String getProperty(String key, String defaultValue) {
        try {
            String tmp = System.getProperty(key);
            if (tmp == null) {
                tmp = defaultValue;
            }
            return tmp;
        }
        catch (Throwable t) {
            ActiveMQClientLogger.LOGGER.unableToGetProperty(t);
            return defaultValue;
        }
    }

    private static int getIntProperty(String key, String defaultValue) {
        String value = UDPBroadcastEndpointFactory.getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable t) {
            ActiveMQClientLogger.LOGGER.unableToParseValue(t);
            return Integer.parseInt(defaultValue);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupAddress == null ? 0 : this.groupAddress.hashCode());
        result = 31 * result + this.groupPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UDPBroadcastEndpointFactory other = (UDPBroadcastEndpointFactory)obj;
        if (this.groupAddress == null ? other.groupAddress != null : !this.groupAddress.equals(other.groupAddress)) {
            return false;
        }
        return this.groupPort == other.groupPort;
    }

    private static class UDPBroadcastEndpoint
    implements BroadcastEndpoint {
        private static final int SOCKET_TIMEOUT = 500;
        private InetAddress localAddress;
        private int localBindPort;
        private InetAddress groupAddress;
        private int groupPort;
        private DatagramSocket broadcastingSocket;
        private MulticastSocket receivingSocket;
        private volatile boolean open;

        private UDPBroadcastEndpoint() {
        }

        public UDPBroadcastEndpoint setGroupAddress(InetAddress groupAddress) {
            this.groupAddress = groupAddress;
            return this;
        }

        public UDPBroadcastEndpoint setGroupPort(int groupPort) {
            this.groupPort = groupPort;
            return this;
        }

        public UDPBroadcastEndpoint setLocalBindAddress(InetAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public UDPBroadcastEndpoint setLocalBindPort(int localBindPort) {
            this.localBindPort = localBindPort;
            return this;
        }

        @Override
        public void broadcast(byte[] data) throws Exception {
            DatagramPacket packet = new DatagramPacket(data, data.length, this.groupAddress, this.groupPort);
            this.broadcastingSocket.send(packet);
        }

        @Override
        public byte[] receiveBroadcast() throws Exception {
            byte[] data = new byte[65535];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            while (this.open) {
                try {
                    this.receivingSocket.receive(packet);
                    break;
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    if (!this.open) break;
                    ActiveMQClientLogger.LOGGER.unableToReceiveBroadcast(e, this.toString());
                    break;
                }
            }
            return data;
        }

        @Override
        public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
            return this.receiveBroadcast();
        }

        @Override
        public void openBroadcaster() throws Exception {
            if (this.localBindPort != -1) {
                this.broadcastingSocket = new DatagramSocket(this.localBindPort, this.localAddress);
            } else {
                if (this.localAddress != null) {
                    for (int i = 0; i < 100; ++i) {
                        int nextPort = RandomUtil.randomInterval(3000, 4000);
                        try {
                            this.broadcastingSocket = new DatagramSocket(nextPort, this.localAddress);
                            ActiveMQClientLogger.LOGGER.broadcastGroupBindError(this.localAddress.toString() + ":" + nextPort);
                            break;
                        }
                        catch (Exception e) {
                            ActiveMQClientLogger.LOGGER.broadcastGroupBindErrorRetry(this.localAddress.toString() + ":" + nextPort, e);
                            continue;
                        }
                    }
                }
                if (this.broadcastingSocket == null) {
                    this.broadcastingSocket = new DatagramSocket();
                }
            }
            this.open = true;
        }

        @Override
        public void openClient() throws Exception {
            if (UDPBroadcastEndpoint.checkForLinux() || UDPBroadcastEndpoint.checkForSolaris() || UDPBroadcastEndpoint.checkForHp()) {
                try {
                    this.receivingSocket = new MulticastSocket(new InetSocketAddress(this.groupAddress, this.groupPort));
                }
                catch (IOException e) {
                    ActiveMQClientLogger.LOGGER.ioDiscoveryError(this.groupAddress.getHostAddress(), this.groupAddress instanceof Inet4Address ? "IPv4" : "IPv6");
                    this.receivingSocket = new MulticastSocket(this.groupPort);
                }
            } else {
                this.receivingSocket = new MulticastSocket(this.groupPort);
            }
            if (this.localAddress != null) {
                this.receivingSocket.setInterface(this.localAddress);
            }
            this.receivingSocket.joinGroup(this.groupAddress);
            this.receivingSocket.setSoTimeout(500);
            this.open = true;
        }

        @Override
        public void close(boolean isBroadcast) throws Exception {
            this.open = false;
            if (this.broadcastingSocket != null) {
                this.broadcastingSocket.close();
            }
            if (this.receivingSocket != null) {
                this.receivingSocket.close();
            }
        }

        private static boolean checkForLinux() {
            return UDPBroadcastEndpoint.checkForPresence("os.name", "linux");
        }

        private static boolean checkForHp() {
            return UDPBroadcastEndpoint.checkForPresence("os.name", "hp");
        }

        private static boolean checkForSolaris() {
            return UDPBroadcastEndpoint.checkForPresence("os.name", "sun");
        }

        private static boolean checkForPresence(String key, String value) {
            String tmp = UDPBroadcastEndpointFactory.getProperty(key, null);
            return tmp != null && tmp.trim().toLowerCase().startsWith(value);
        }
    }
}

