/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.stat;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.stat.SimpleStat;

public class DefaultSimpleStat
implements SimpleStat {
    private final LongAdder count = new LongAdder();
    private final LongAdder sum = new LongAdder();
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

    @Override
    public void record(long value) {
        this.updateMin(value);
        this.updateMax(value);
        this.sum.add(value);
        this.count.increment();
    }

    @Override
    public long getMin(long defaultValue) {
        return this.count.sum() == 0L ? defaultValue : this.min.get();
    }

    @Override
    public long getMax(long defaultValue) {
        return this.count.sum() == 0L ? defaultValue : this.max.get();
    }

    @Override
    public long getAverage(long defaultValue) {
        long counted = this.count.sum();
        return counted == 0L ? defaultValue : this.sum.sum() / counted;
    }

    @Override
    public long count() {
        return this.count.sum();
    }

    private void updateMin(long value) {
        long tmp = this.min.get();
        while (value < tmp) {
            if (this.min.compareAndSet(tmp, value)) {
                return;
            }
            tmp = this.min.get();
        }
    }

    private void updateMax(long value) {
        long tmp = this.max.get();
        while (value > tmp) {
            if (this.max.compareAndSet(tmp, value)) {
                return;
            }
            tmp = this.max.get();
        }
    }
}

