/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@SerializeWith(value=ExternalizerImpl.class)
public class SessionPredicate<S extends SessionEntity>
implements Predicate<Map.Entry<String, SessionEntityWrapper<S>>> {
    private final String realm;

    private SessionPredicate(String realm) {
        this.realm = realm;
    }

    public static SessionPredicate create(String realm) {
        return new SessionPredicate(realm);
    }

    @Override
    public boolean test(Map.Entry<String, SessionEntityWrapper<S>> entry) {
        return this.realm.equals(((SessionEntity)entry.getValue().getEntity()).getRealmId());
    }

    public static class ExternalizerImpl
    implements Externalizer<SessionPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, SessionPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realm, (ObjectOutput)output);
        }

        public SessionPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public SessionPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            SessionPredicate res = new SessionPredicate(MarshallUtil.unmarshallString((ObjectInput)input));
            return res;
        }
    }
}

